/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.SortArrowRenderer;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

public class MyColumnHeaderRenderer
extends GridHeaderRenderer {
    int r = -1;
    int g = -1;
    int b = -1;
    int BGC = -1;
    int FGC = -1;
    int leftMargin = 6;
    int rightMargin = 6;
    int topMargin = 3;
    int bottomMargin = 3;
    int arrowMargin = 6;
    int imageSpacing = 3;
    private SortArrowRenderer arrowRenderer = new SortArrowRenderer();
    private TextLayout textLayout;

    public void setBGC(int c) {
        this.BGC = c;
    }

    public void setFGC(int c) {
        this.FGC = c;
    }

    public void setRGB(int r, int g, int b) {
        this.BGC = 1;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        GridColumn column = (GridColumn)value;
        gc.setFont(column.getHeaderFont());
        int x = this.leftMargin;
        int y = this.topMargin + gc.getFontMetrics().getHeight() + this.bottomMargin;
        if (column.getImage() != null) {
            x += column.getImage().getBounds().width + this.imageSpacing;
            y = Math.max(y, this.topMargin + column.getImage().getBounds().height + this.bottomMargin);
        }
        if (!this.isWordWrap()) {
            x += gc.stringExtent((String)column.getText()).x + this.rightMargin;
        } else {
            int plainTextWidth = wHint == -1 ? this.getBounds().width - x - this.rightMargin : wHint - x - this.rightMargin;
            this.getTextLayout(gc, column);
            this.textLayout.setText(column.getText());
            this.textLayout.setWidth(plainTextWidth < 1 ? 1 : plainTextWidth);
            x += plainTextWidth + this.rightMargin;
            int textHeight = this.topMargin;
            textHeight += this.textLayout.getBounds().height;
            y = Math.max(y, textHeight += this.bottomMargin);
        }
        return new Point(x, y += this.computeControlSize((GridColumn)column).y);
    }

    public void paint(GC gc, Object value) {
        int len;
        boolean drawSelected;
        GridColumn column = (GridColumn)value;
        gc.setFont(column.getHeaderFont());
        boolean flat = column.getParent().getCellSelectionEnabled() && !column.getMoveable();
        boolean bl = drawSelected = this.isMouseDown() && this.isHover();
        if (this.BGC == -1) {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        } else if (this.r == -1) {
            gc.setBackground(this.getDisplay().getSystemColor(this.BGC));
        } else {
            Display device = Display.getCurrent();
            gc.setBackground(new Color((Device)device, this.r, this.g, this.b));
        }
        if (flat && this.isSelected()) {
            gc.setBackground(column.getParent().getCellHeaderSelectionBackground());
        }
        gc.fillRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        int pushedDrawingOffset = 0;
        if (drawSelected) {
            pushedDrawingOffset = 1;
        }
        int x = this.leftMargin;
        if (column.getImage() != null) {
            int y = this.bottomMargin;
            if (column.getHeaderControl() == null) {
                y = this.getBounds().y + pushedDrawingOffset + this.getBounds().height - this.bottomMargin - column.getImage().getBounds().height;
            }
            gc.drawImage(column.getImage(), this.getBounds().x + x + pushedDrawingOffset, y);
            x += column.getImage().getBounds().width + this.imageSpacing;
        }
        int width = this.getBounds().width - x;
        width = column.getSort() == 0 ? (width -= this.rightMargin) : (width -= this.arrowMargin + this.arrowRenderer.getSize().x + this.arrowMargin);
        if (this.FGC == -1) {
            gc.setForeground(this.getDisplay().getSystemColor(21));
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(this.FGC));
        }
        int y = this.bottomMargin;
        y = column.getHeaderControl() == null ? this.getBounds().y + this.getBounds().height - this.bottomMargin - gc.getFontMetrics().getHeight() : this.getBounds().y + this.getBounds().height - this.bottomMargin - gc.getFontMetrics().getHeight() - this.computeControlSize((GridColumn)column).y;
        String text = column.getText();
        if (!this.isWordWrap()) {
            text = TextUtils.getShortStr((GC)gc, (String)text, (int)width, (int)0);
        }
        if (column.getAlignment() == 131072) {
            int len2 = gc.stringExtent((String)text).x;
            if (len2 < width) {
                x += width - len2;
            }
        } else if (column.getAlignment() == 0x1000000 && (len = gc.stringExtent((String)text).x) < width) {
            x += (width - len) / 2;
        }
        if (!this.isWordWrap()) {
            gc.drawString(text, this.getBounds().x + x + pushedDrawingOffset, y + pushedDrawingOffset, true);
        } else {
            this.getTextLayout(gc, column);
            this.textLayout.setWidth(width < 1 ? 1 : width);
            this.textLayout.setText(text);
            y -= this.textLayout.getBounds().height;
            y += gc.getFontMetrics().getHeight();
            if (column.getParent().isAutoHeight()) {
                column.getParent().recalculateHeader();
            }
            this.textLayout.draw(gc, this.getBounds().x + x + pushedDrawingOffset, y + pushedDrawingOffset);
        }
        if (column.getSort() != 0) {
            y = column.getHeaderControl() == null ? this.getBounds().y + (this.getBounds().height - this.arrowRenderer.getBounds().height) / 2 + 1 : this.getBounds().y + (this.getBounds().height - this.computeControlSize((GridColumn)column).y - this.arrowRenderer.getBounds().height) / 2 + 1;
            this.arrowRenderer.setSelected(column.getSort() == 128);
            if (drawSelected) {
                this.arrowRenderer.setLocation(this.getBounds().x + this.getBounds().width - this.arrowMargin - this.arrowRenderer.getBounds().width + 1, y);
            } else {
                y = column.getHeaderControl() == null ? this.getBounds().y + (this.getBounds().height - this.arrowRenderer.getBounds().height) / 2 : this.getBounds().y + (this.getBounds().height - this.computeControlSize((GridColumn)column).y - this.arrowRenderer.getBounds().height) / 2;
                this.arrowRenderer.setLocation(this.getBounds().x + this.getBounds().width - this.arrowMargin - this.arrowRenderer.getBounds().width, y);
            }
            this.arrowRenderer.paint(gc, null);
        }
        if (!flat) {
            if (drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(20));
            }
            gc.drawLine(this.getBounds().x, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y);
            gc.drawLine(this.getBounds().x, this.getBounds().y, this.getBounds().x, this.getBounds().y + this.getBounds().height - 1);
            if (!drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(19));
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + 1, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + 1);
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + 1, this.getBounds().x + 1, this.getBounds().y + this.getBounds().height - 2);
            }
            if (drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(17));
            }
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height - 1, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            if (!drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
                gc.drawLine(this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + 1, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + this.getBounds().height - 2);
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + this.getBounds().height - 2, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + this.getBounds().height - 2);
            }
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(17));
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height - 1, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
        }
    }

    public void setDisplay(Display display) {
        super.setDisplay(display);
        this.arrowRenderer.setDisplay(display);
    }

    public boolean notify(int event, Point point, Object value) {
        return false;
    }

    public Rectangle getTextBounds(Object value, boolean preferred) {
        GridColumn column = (GridColumn)value;
        int x = this.leftMargin;
        if (column.getImage() != null) {
            x += column.getImage().getBounds().width + this.imageSpacing;
        }
        GC gc = new GC((Drawable)column.getParent());
        gc.setFont(column.getParent().getFont());
        int y = this.getBounds().height - this.bottomMargin - gc.getFontMetrics().getHeight();
        Rectangle bounds = new Rectangle(x, y, 0, 0);
        Point p = gc.stringExtent(column.getText());
        bounds.height = p.y;
        if (preferred) {
            bounds.width = p.x;
        } else {
            int width = this.getBounds().width - x;
            width = column.getSort() == 0 ? (width -= this.rightMargin) : (width -= this.arrowMargin + this.arrowRenderer.getSize().x + this.arrowMargin);
            bounds.width = width;
        }
        gc.dispose();
        return bounds;
    }

    protected Rectangle getControlBounds(Object value, boolean preferred) {
        Rectangle bounds = this.getBounds();
        GridColumn column = (GridColumn)value;
        Point controlSize = this.computeControlSize(column);
        int y = this.getBounds().y + this.getBounds().height - this.bottomMargin - controlSize.y;
        return new Rectangle(bounds.x + 3, y, bounds.width - 6, controlSize.y);
    }

    private Point computeControlSize(GridColumn column) {
        if (column.getHeaderControl() != null) {
            return column.getHeaderControl().computeSize(-1, -1);
        }
        return new Point(0, 0);
    }

    private void getTextLayout(GC gc, GridColumn column) {
        if (this.textLayout == null) {
            this.textLayout = new TextLayout(gc.getDevice());
            this.textLayout.setFont(gc.getFont());
            column.getParent().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MyColumnHeaderRenderer.this.textLayout.dispose();
                }
            });
        }
        this.textLayout.setAlignment(column.getAlignment());
    }
}

