/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderStatusDto;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import com.kdjsystem.mlink.tot.ui.MyCellRenderer;
import com.kdjsystem.mlink.tot.ui.MyColumnHeaderRenderer;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class OrderStatusLogDialog
extends CommandDialog {
    public static String ID = "com.kdjsystem.mlink.tot.command.UserInfo.ID";
    public static String TITLE = "\ub85c\uadf8\uad00\ub9ac";
    String[][] column_name = new String[][]{{"No.", "65"}, {"\uc1fc\ud551\ubab0\uba85", "100"}, {"\uc1fc\ud551\ubab0\uc544\uc774\ub514", "100"}, {"\uc2f1\ud0dc\uba85", "100"}, {"\ucc98\ub9ac\uacb0\uacfc", "300"}, {"\ucc98\ub9ac\uc77c\uc2dc", "300"}};
    int selectedRowNo = -1;
    private Grid table;
    GridTableViewer tableViewer;
    private Button btn_cancel;

    public OrderStatusLogDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        gl_composite.horizontalSpacing = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayout((Layout)new GridLayout(3, false));
        composite_1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblNewLabel = new Label(composite_1, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setBounds(0, 0, 71, 20);
        lblNewLabel.setText("\ub0a0\uc9dc");
        final DateTime dateTime = new DateTime(composite_1, 2048);
        dateTime.setYear(2019);
        dateTime.setMonth(10);
        dateTime.setDay(28);
        Button btn_search = new Button(composite_1, 0);
        btn_search.setToolTipText("\ucc3e\uae30");
        btn_search.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                String date1 = YDMATimeUtil.getRoRddtDate(dateTime);
                OrderStatusLogDialog.this.getShopOrderStatus(date1);
            }
        });
        btn_search.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uac80\uc0c9.png"));
        Composite composite_2 = new Composite(composite, 0);
        GridLayout gl_composite_2 = new GridLayout(1, false);
        gl_composite_2.horizontalSpacing = 0;
        gl_composite_2.marginHeight = 0;
        gl_composite_2.marginWidth = 0;
        gl_composite_2.verticalSpacing = 0;
        composite_2.setLayout((Layout)gl_composite_2);
        GridData gd_composite_2 = new GridData(4, 4, true, true, 1, 1);
        gd_composite_2.widthHint = 1024;
        gd_composite_2.heightHint = 600;
        composite_2.setLayoutData((Object)gd_composite_2);
        composite_2.setBounds(0, 0, 64, 64);
        this.tableViewer = new GridTableViewer(composite_2, 772);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OrderStatusLogDialog.this.selectedRowNo = OrderStatusLogDialog.this.table.getSelectionIndex();
            }
        });
        this.table = this.tableViewer.getGrid();
        this.table.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        this.table.setLinesVisible(true);
        this.table.setLineColor(SWTResourceManager.getColor(18));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setHeaderVisible(true);
        MyColumnHeaderRenderer myHeaderRender = new MyColumnHeaderRenderer();
        myHeaderRender.setBGC(14);
        myHeaderRender.setFGC(1);
        new MyCellRenderer();
        int i = 0;
        while (i < this.column_name.length) {
            String[] column = this.column_name[i];
            GridColumn tableViewerColumn_x = new GridColumn(this.table, 0x1000000);
            tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
            tableViewerColumn_x.setWidth(Integer.parseInt(column[1]));
            tableViewerColumn_x.setText(column[0]);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MyLableProvider());
        this.tableViewer.setContentProvider((IContentProvider)new MyContentProvider());
        return composite;
    }

    private void getShopOrderStatus(String date) {
        try {
            ShopOrderDao dao = ShopOrderDao.get();
            List<ShopOrderStatusDto> list = dao.getOrderStatus(date);
            this.tableViewer.setInput(list);
            this.selectedRowNo = -1;
            if (list == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\ub370\uc774\ud0c0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openWarning((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btn_cancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        this.btn_cancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(TITLE);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(1024, 768);
    }

    class MyContentProvider
    extends ArrayContentProvider
    implements IStructuredContentProvider {
        MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class MyLableProvider
    extends StyledCellLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        MyLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ShopOrderStatusDto dto = (ShopOrderStatusDto)element;
            Object value = "";
            switch (columnIndex) {
                case 0: {
                    value = "" + dto.getOrdseq();
                    break;
                }
                case 1: {
                    value = dto.getShopnm();
                    break;
                }
                case 2: {
                    value = dto.getShopuserid();
                    break;
                }
                case 3: {
                    value = dto.getStatusname();
                    break;
                }
                case 4: {
                    value = dto.getResultMessage();
                    break;
                }
                case 5: {
                    value = dto.getSenddt();
                    break;
                }
                default: {
                    value = "";
                }
            }
            return value;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

