/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.ui.SBNetOrderReceiveDialog;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SBNetOrderReceiveThread
extends Thread {
    SBNetOrderReceiveDialog opener;
    private ProgressBar progressBar;
    List<List<String>> sheetContents;
    String responseData;

    public SBNetOrderReceiveThread(SBNetOrderReceiveDialog opener, ProgressBar progressBar, String responseData, List<List<String>> sheetContents) {
        this.opener = opener;
        this.progressBar = progressBar;
        this.responseData = responseData;
        this.sheetContents = sheetContents;
    }

    @Override
    public void run() {
        try {
            int totalCount = 0;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = null;
            this.responseData = this.responseData.replaceAll("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD\\u10000-\\u10FFF]+", "");
            InputSource is = new InputSource(new StringReader(this.responseData));
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(is);
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            XPathExpression expr_header = xpath.compile("/SABANG_ORDER_LIST/HEADER");
            NodeList nodeList2 = (NodeList)expr_header.evaluate(document, XPathConstants.NODESET);
            int i = 0;
            while (i < nodeList2.getLength()) {
                NodeList child = nodeList2.item(i).getChildNodes();
                int j = 0;
                while (j < child.getLength()) {
                    Node node = child.item(j);
                    if (node.getNodeType() == 1) {
                        if (node.getNodeName().equals("TOTAL_COUNT")) {
                            totalCount = Integer.parseInt(node.getTextContent());
                        }
                        YDMAStringUtil.Print("\ub178\ub4dc \uc774\ub984, \uac12 : " + node.getNodeName() + "=" + node.getTextContent());
                    }
                    ++j;
                }
                ++i;
            }
            XPathExpression expr_data = xpath.compile("/SABANG_ORDER_LIST/DATA");
            NodeList nodeList = (NodeList)expr_data.evaluate(document, XPathConstants.NODESET);
            int idx = 0;
            int i2 = 0;
            while (i2 < nodeList.getLength()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(String.valueOf(i2 + 1));
                NodeList child = nodeList.item(i2).getChildNodes();
                StringBuffer SKU_VALUE = new StringBuffer();
                StringBuffer MALL_ID = new StringBuffer();
                StringBuffer COMPAYNY_GOODS_CD = new StringBuffer();
                int j = 0;
                while (j < child.getLength()) {
                    Node node = child.item(j);
                    if (node.getNodeType() == 1) {
                        if (node.getNodeName().equals("SKU_VALUE")) {
                            SKU_VALUE.append(node.getTextContent());
                        } else if (node.getNodeName().equals("SKU_ALIAS")) {
                            SKU_VALUE.append(" ").append(node.getTextContent());
                            list.add(SKU_VALUE.toString());
                        } else if (node.getNodeName().equals("MALL_ID")) {
                            MALL_ID.append(node.getTextContent());
                        } else if (node.getNodeName().equals("MALL_USER_ID")) {
                            MALL_ID.append(" ").append(node.getTextContent());
                            list.add(MALL_ID.toString());
                        } else if (node.getNodeName().equals("COMPAYNY_GOODS_CD")) {
                            COMPAYNY_GOODS_CD.append(node.getTextContent());
                        } else if (node.getNodeName().equals("ORDER_ETC_1")) {
                            COMPAYNY_GOODS_CD.append(" ").append(node.getTextContent());
                            list.add(COMPAYNY_GOODS_CD.toString());
                        } else {
                            if (node.getNodeName().equals("ORDER_DATE")) {
                                String ORDER_DATE = node.getTextContent();
                                ORDER_DATE = YDMATimeUtil.convertSabangNetOrderDateToOrddt(ORDER_DATE, false);
                                node.setTextContent(ORDER_DATE);
                            }
                            list.add(node.getTextContent());
                            if (node.getNodeName().equals("DELV_MSG1")) {
                                list.add("");
                                list.add("\ud0dd\ubc30");
                            }
                        }
                    }
                    ++j;
                }
                this.updateGUIInProgress(idx++, totalCount);
                this.sheetContents.add(list);
                Thread.sleep(5L);
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateGUIWhenFinish();
    }

    private void updateGUIWhenFinish() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SBNetOrderReceiveThread.this.progressBar.setSelection(0);
                SBNetOrderReceiveThread.this.progressBar.setMaximum(1);
                SBNetOrderReceiveThread.this.opener.close();
            }
        });
    }

    private void updateGUIInProgress(final int value, final int count) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SBNetOrderReceiveThread.this.progressBar.setMaximum(count);
                SBNetOrderReceiveThread.this.progressBar.setSelection(value);
            }
        });
    }
}

