/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.common.ShopCombo;
import com.kdjsystem.mlink.shop.dao.EnvironmentBackupDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.mlink.MLinkDBBackupDao;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import com.kdjsystem.mlink.tot.ui.ShopDBBackupDetail;
import com.kdjsystem.mlink.tot.ui.ShopDBBackupPassword;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class ShopDBBackupDetailDialog
extends CommandDialog {
    public String TITLE = "\ub0b4 \ucef4\ud4e8\ud130\ub85c \ubc31\uc5c5";
    ShopDBBackupDetail opener;
    ShopCombo scb_backperiod;
    int orderfrom;
    int inquiryfrom;
    Button btn_search;
    static ProgressBar progressBar;
    static Label lb_progress;
    boolean env;
    boolean product;
    boolean order;
    boolean inquiry;
    Button button_save;
    private Text txt_path;
    private Button btnCancel;
    static Text txt_detaillog;

    public ShopDBBackupDetailDialog(Shell shell, ShopDBBackupDetail opener, int orderfrom, int inquiryfrom, boolean env, boolean product2, boolean order, boolean inquiry) {
        super(shell);
        this.setShellStyle(0x870 | ShopDBBackupDetailDialog.getDefaultOrientation());
        this.opener = opener;
        this.orderfrom = orderfrom;
        this.inquiryfrom = inquiryfrom;
        this.env = env;
        this.product = product2;
        this.order = order;
        this.inquiry = inquiry;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        lblNewLabel.setText("\ud604\uc7ac \uc811\uc18d\ud55c DB\uc11c\ubc84\uc758 \ubaa8\ub4e0 \ub0b4\uc6a9\uc744 \ud30c\uc77c\ub85c \ubc31\uc5c5\ud558\uc5ec \ub0b4 \ucef4\ud4e8\ud130\uc5d0 \uc800\uc7a5 \ud569\ub2c8\ub2e4.");
        lblNewLabel.setFont(SWTResourceManager.getFont("\ub9d1\uc740\uace0\ub515", 15, 1));
        Label lblNewLabel_9 = new Label(composite, 0);
        GridData gd_lblNewLabel_9 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel_9.widthHint = 30;
        lblNewLabel_9.setLayoutData((Object)gd_lblNewLabel_9);
        Label lblNewLabel_10 = new Label(composite, 0);
        lblNewLabel_10.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_10.setText("\uac00\uc785\uc790ID : ");
        Label lblNewLabel_11 = new Label(composite, 0);
        lblNewLabel_11.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblNewLabel_11.setText("   " + YDMASessonUtil.getUserInfo().getUsernam() + " (" + YDMASessonUtil.getUserInfo().getUserId() + ")");
        lblNewLabel_11.setFont(SWTResourceManager.getFont("\ub9d1\uc740\uace0\ub515", 12, 1));
        Label lblNewLabel_12 = new Label(composite, 0);
        GridData gd_lblNewLabel_12 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblNewLabel_12.widthHint = 30;
        lblNewLabel_12.setLayoutData((Object)gd_lblNewLabel_12);
        Label lblNewLabel_13 = new Label(composite, 0);
        lblNewLabel_13.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel_13.setText("DB\uc11c\ubc84 : ");
        Label lblNewLabel_14 = new Label(composite, 0);
        lblNewLabel_14.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblNewLabel_14.setText("   [\ud638\uc2a4\ud305\uc0ac\uc6a9]");
        lblNewLabel_14.setFont(SWTResourceManager.getFont("\ub9d1\uc740\uace0\ub515", 12, 1));
        Label lblNewLabel_1 = new Label(composite, 0);
        lblNewLabel_1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        lblNewLabel_1.setText("\n\u203b \ub370\uc774\ud130 \uc591\uc5d0 \ub530\ub77c \uc218\ubd84~\uc218\uc2dc\uac04\uc774 \uc18c\uc694\ub420 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
        lblNewLabel_1.setForeground(SWTResourceManager.getColor(3));
        Label lblNewLabel_15 = new Label(composite, 0);
        lblNewLabel_15.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        lblNewLabel_15.setText("\u203b \uc791\uc5c5 \uc911 PC \ubc0f \uc811\uc18d\ud558\uc2e0 DB\uc11c\ubc84\uac00 \uc885\ub8cc\ub418\uc9c0 \uc54a\ub3c4\ub85d \uc8fc\uc758 \ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
        lblNewLabel_15.setForeground(SWTResourceManager.getColor(3));
        Label lblNewLabel_16 = new Label(composite, 0);
        lblNewLabel_16.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        lblNewLabel_16.setText("\u203b \uc900\ube44\ub97c \uc644\ub8cc\ud558\uc168\uc73c\uba74, [\uc2dc\uc791] \ubc84\ud2bc\uc744 \ud074\ub9ad\ud558\uc2ed\uc2dc\uc624.");
        lblNewLabel_16.setForeground(SWTResourceManager.getColor(3));
        Label lblNewLabel_2 = new Label(composite, 0);
        lblNewLabel_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        lblNewLabel_2.setText("\n\ubc31\uc5c5 \ud30c\uc77c\uc774 \uc800\uc7a5\ub420 \uacbd\ub85c\n");
        this.txt_path = new Text(composite, 2048);
        GridData gd_txt_path = new GridData(4, 4, true, false, 3, 1);
        gd_txt_path.widthHint = 650;
        this.txt_path.setLayoutData((Object)gd_txt_path);
        this.btn_search = new Button(composite, 0);
        this.btn_search.setText("\ucc3e\uc544\ubcf4\uae30...");
        this.btn_search.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShopDBBackupDetailDialog.this.getPath();
            }
        });
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        Label lblNewLabel_3 = new Label(composite, 0);
        lblNewLabel_3.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        lblNewLabel_3.setText("\n\uc791\uc5c5 \uc9c4\ud589 \uc0c1\ud0dc");
        progressBar = new ProgressBar(composite, 0);
        GridData gd_progressBar = new GridData(4, 0x1000000, true, false, 4, 1);
        gd_progressBar.heightHint = 25;
        progressBar.setLayoutData((Object)gd_progressBar);
        lb_progress = new Label(composite, 0);
        lb_progress.setLayoutData((Object)new GridData(4, 128, true, true, 4, 1));
        lb_progress.setText("0/0");
        return container;
    }

    public static void setProgressbar(final String coment) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                lb_progress.setText(coment);
            }
        });
    }

    public static void setProgressbar(final int total, final int cnt) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                progressBar.setMaximum(total);
                lb_progress.setText(String.valueOf(cnt) + "/" + String.valueOf(total) + "\ubc31\uc5c5 \uc911\uc785\ub2c8\ub2e4.");
                progressBar.setSelection(cnt);
                if (cnt >= total) {
                    lb_progress.setText(String.valueOf(total) + "/" + String.valueOf(total) + "\ubc31\uc5c5 \uc644\ub8cc!");
                }
            }
        });
    }

    public static void setGridTableSetting(List<ShopProductDto> list) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    protected void getPath() {
        FileDialog fd = new FileDialog(this.getShell(), 8192);
        fd.setText("\ubc31\uc5c5 \ud30c\uc77c \uc704\uce58 \uc9c0\uc815");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.zip"};
        fd.setFileName("dump_" + YDMATimeUtil.getCurrentDateScheduler() + ".zip");
        fd.setFilterExtensions(filterExt);
        String selected = fd.open();
        this.txt_path.setText(selected);
    }

    protected void okPressed() {
        try {
            File file;
            String zippath = this.txt_path.getText();
            if (zippath == null || zippath.trim().isEmpty()) {
                return;
            }
            ShopDBBackupPassword d = new ShopDBBackupPassword(null);
            d.open();
            String path = zippath.substring(0, zippath.lastIndexOf("\\") + 1);
            String pass = d.getPassword();
            String cpass = d.getCpassword();
            if (pass == null || cpass == null || pass.isEmpty() || cpass.isEmpty()) {
                return;
            }
            if (!pass.equals(cpass)) {
                return;
            }
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setCompressionMethod(8);
            zipParameters.setCompressionLevel(5);
            zipParameters.setEncryptFiles(true);
            zipParameters.setEncryptionMethod(99);
            zipParameters.setAesKeyStrength(3);
            zipParameters.setPassword(pass);
            ZipFile zipFile = new ZipFile(zippath);
            if (zipFile.isValidZipFile() && (file = new File(zippath)).exists() && !file.delete()) {
                System.err.println("\ud30c\uc77c \uc0ad\uc81c \uc2e4\ud328: " + file.getAbsolutePath());
            }
            ArrayList<File> list = new ArrayList<File>();
            List<EnvironmentBackupDto> tabLst = new ArrayList<EnvironmentBackupDto>();
            if (this.env) {
                tabLst = this.getEnvironmentBackup(path, tabLst, list);
            }
            this.setMetaFile(path + "mmeta", tabLst, list);
            zipFile.createZipFile(list, zipParameters);
            for (File filename : list) {
                if (!filename.exists() || filename.delete()) continue;
                System.err.println("\uc784\uc2dc \ud30c\uc77c \uc0ad\uc81c \uc2e4\ud328: " + filename.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected List<EnvironmentBackupDto> getEnvironmentBackup(String path, List<EnvironmentBackupDto> tabLst, ArrayList<File> list) throws Exception {
        String file2 = path + "environment";
        BufferedWriter output = null;
        ArrayList<String> tables = new ArrayList<String>();
        tables.add("systemconf");
        tables.add("shopdtl");
        tables.add("shopdtldome");
        tables.add("shopmst");
        tables.add("shopmstdome");
        tabLst = this.setTargetTableList(file2, tables);
        int total = tabLst.stream().mapToInt(o -> o.getCnt()).sum();
        ShopDBBackupDetailDialog.setProgressbar(total, 0);
        for (EnvironmentBackupDto tab : tabLst) {
            try {
                new ObjectMapper();
                int s = 0;
                ArrayList<String> fnamedtl = new ArrayList<String>();
                while (s < total) {
                    String filePath = tab.getFname() + Integer.toString(s);
                    File file = new File(filePath);
                    file.createNewFile();
                    output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, true), "UTF8"));
                    String json = MLinkDBBackupDao.get().getEnvironmentBackup(s, tab);
                    if (!json.isEmpty()) {
                        output.write(json);
                        output.close();
                        list.add(new File(filePath));
                        fnamedtl.add(file.getName());
                    }
                    ShopDBBackupDetailDialog.setProgressbar(total, s += 1000);
                }
                if (fnamedtl.size() <= 0) continue;
                tab.setFnamedtl(fnamedtl);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return tabLst;
    }

    protected List<EnvironmentBackupDto> setTargetTableList(String file2, List<String> tables) throws Exception {
        ArrayList<EnvironmentBackupDto> tabLst = new ArrayList<EnvironmentBackupDto>();
        for (String tname : tables) {
            EnvironmentBackupDto tab = new EnvironmentBackupDto();
            tab.setTname(tname);
            MLinkDBBackupDao.get().getBackupCnt(tab);
            MLinkDBBackupDao.get().getBackupSQL(tab);
            MLinkDBBackupDao.get().getBackupPrimaryKeys(tab);
            tab.setFname(file2.concat(tname).concat("enc"));
            tabLst.add(tab);
        }
        return tabLst;
    }

    protected void setMetaFile(String filePath, List<EnvironmentBackupDto> tabLst, ArrayList<File> list) {
        BufferedWriter output = null;
        try {
            File file = new File(filePath);
            file.createNewFile();
            output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath, true), "UTF8"));
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writeValueAsString(tabLst);
            output.write(json);
            output.close();
            list.add(new File(filePath));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    protected void getProductBackup(String path, ArrayList<File> list) throws Exception {
    }

    protected void getOrderBackup(String path, ArrayList<File> list) throws Exception {
    }

    protected void getInquiryBackup(String path, ArrayList<File> list) throws Exception {
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.button_save = this.createButton(parent, 0, "\uc2dc\uc791", false);
        this.btnCancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        this.button_save.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc800\uc7a5.png"));
        this.btnCancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.TITLE);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(706, 529);
    }
}

