/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductOptionDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class ShopOptionProductInDao {
    private static ShopOptionProductInDao instance = new ShopOptionProductInDao();

    public ShopOptionProductInDao get() {
        return instance;
    }

    public String getShopOptProdInListBySendseq(ProductDTO prodto) throws Exception {
        String sendseq = "0";
        new ArrayList();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select sendseq   from shopprodin  where COMPNO = ?    and SHOPCD = ?    and PRODSEQ = ?    and SHOP_USERID = ?    and SHOPSEQ = ?    and SHOPPRODNO = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, prodto.getShopcd());
                pstmt.setString(3, prodto.getPRODSEQ());
                pstmt.setString(4, prodto.getSHOP_USERID());
                pstmt.setString(5, prodto.getShopseq());
                pstmt.setString(6, prodto.getShopprodno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    sendseq = rs.getString(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return sendseq;
    }

    public List<ShopProductOptionDto> getShopOptProdInListBySendseq(String sendseq) throws Exception {
        ArrayList<ShopProductOptionDto> list = new ArrayList<ShopProductOptionDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT SENDSEQ,ifnull(SKUSEQ,0),COMPNO,ifnull(SHOPPRODNO,''),ifnull(SHOPPRODSKU,''),\t\t  ifnull(SHOPPRODSKU_NM,''),\t\t  ifnull(PRODSEQ,'0'),ifnull(OPTPRODCD,''),ifnull(OPTPRODNM,''),ifnull(OPTSPECDES,''),\t\t  ifnull(OPTEA,0),ifnull(OPTSALE,''),ifnull(OPTSALEOUT,''),\t\t  ifnull(OPTNOTUSE,''), ifnull(OPTSAFESTOCK,'0'),ifnull(OPTVERTSTOCK,'0'),\t\t  ifnull(OPTADDAMT,0),ifnull(OPTDELYN,'N'),ifnull(BARCODE,'')   FROM Shop_OptProdIn  WHERE SENDSEQ = ?    AND COMPNO = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, sendseq);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopOptProdInListBySendseq]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int idx = 0;
                while (rs.next()) {
                    int rowIdx = 0;
                    ShopProductOptionDto dto = new ShopProductOptionDto();
                    dto.setRow(String.valueOf(++idx));
                    dto.setSendseq(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setSkuseq(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setCompno(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setShopprodno(rs.getString(++rowIdx));
                    dto.setShopprodsku(rs.getString(++rowIdx));
                    dto.setShopprodsku_nm(rs.getString(++rowIdx));
                    dto.setProdseq(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setOptprodcd(rs.getString(++rowIdx));
                    dto.setOptprodnm(rs.getString(++rowIdx));
                    dto.setOptspecdes(rs.getString(++rowIdx));
                    dto.setOptea(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setOptsale(rs.getString(++rowIdx));
                    dto.setOptsaleout(rs.getString(++rowIdx));
                    dto.setOptnotuse(rs.getString(++rowIdx));
                    dto.setOptsafestock(rs.getString(++rowIdx));
                    dto.setOptvertstock(rs.getString(++rowIdx));
                    dto.setOptaddamt(Integer.parseInt(rs.getString(++rowIdx)));
                    dto.setOptdelyn(rs.getString(++rowIdx));
                    dto.setBarcode(rs.getString(++rowIdx));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public boolean checkExistShopOptProdIn(int sendseq) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select 1 from Shop_OptProdIn where sendseq = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, sendseq);
                YDMAStringUtil.Print("[checkExistShopOptProdIn]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public void insertShopOptProdIn(int sendseq, List<ShopProductOptionDto> list) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "insert into Shop_OptProdIn (sendseq, skuseq, shopprodno, shopprodsku, shopprodskunm,  compno, prodseq, optprodcd, optprodnm, optspecdes, optea,  optsale, optsaleout, optnotuse, optsafestock, optvertstock, optaddamt, optdelyn, barcode, insertdt, insertid)  values (?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (ShopProductOptionDto dto : list) {
                        int rowIdx = 0;
                        pstmt.setInt(++rowIdx, dto.getSendseq());
                        pstmt.setInt(++rowIdx, dto.getSkuseq());
                        pstmt.setString(++rowIdx, dto.getShopprodno());
                        pstmt.setString(++rowIdx, dto.getShopprodsku());
                        pstmt.setString(++rowIdx, dto.getShopprodsku_nm());
                        pstmt.setInt(++rowIdx, dto.getCompno());
                        pstmt.setInt(++rowIdx, dto.getProdseq());
                        pstmt.setString(++rowIdx, dto.getOptprodcd());
                        pstmt.setString(++rowIdx, dto.getOptprodnm());
                        pstmt.setString(++rowIdx, dto.getOptspecdes());
                        pstmt.setInt(++rowIdx, dto.getOptea());
                        pstmt.setString(++rowIdx, dto.getOptsale());
                        pstmt.setString(++rowIdx, dto.getOptsaleout());
                        pstmt.setString(++rowIdx, dto.getOptnotuse());
                        pstmt.setString(++rowIdx, dto.getOptsafestock());
                        pstmt.setString(++rowIdx, dto.getOptvertstock());
                        pstmt.setInt(++rowIdx, dto.getOptaddamt());
                        pstmt.setString(++rowIdx, dto.getOptdelyn());
                        pstmt.setString(++rowIdx, dto.getBarcode());
                        pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[ShopOptProdIn]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
    }

    public int updateShopOptProdInBySku(int sendseq, int skuseq, String shopprodsku, String shopprodsku_nm) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update Shop_OptProdIn    set shopprodsku=?, shopprodsku_nm=?, updatedt=?, updateid=? where sendseq= ?    and skuseq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopprodsku);
                pstmt.setString(2, shopprodsku_nm);
                pstmt.setString(3, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(4, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setInt(5, sendseq);
                pstmt.setInt(6, skuseq);
                YDMAStringUtil.Print("[updateShopOptProdInBySku]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }
}

