/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.common;

import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;

public class MarketPriceCalc {
    private double testPrice;
    private float margin;
    private float commission;
    private float dc;
    private float sellerDc;
    private float flatDc;
    private boolean isFree_delivery;
    private float compliancePrice;
    private static MarketPriceCalc instanc = new MarketPriceCalc();

    public static MarketPriceCalc get() {
        MarketPriceCalc.instanc.testPrice = 0.0;
        MarketPriceCalc.instanc.margin = 0.0f;
        MarketPriceCalc.instanc.commission = 0.0f;
        MarketPriceCalc.instanc.dc = 0.0f;
        MarketPriceCalc.instanc.sellerDc = 0.0f;
        MarketPriceCalc.instanc.flatDc = 0.0f;
        MarketPriceCalc.instanc.compliancePrice = 0.0f;
        return instanc;
    }

    public MarketPriceCalc setCompliancePrice(float compliancePrice) {
        this.compliancePrice = compliancePrice;
        return this;
    }

    public MarketPriceCalc setTestPrice(double testPrice) {
        this.testPrice = testPrice;
        return this;
    }

    public MarketPriceCalc setMargin(float margin) {
        this.margin = margin > 0.0f ? margin / 100.0f : margin;
        return this;
    }

    public MarketPriceCalc setCommission(float commission) {
        this.commission = commission > 0.0f ? commission / 100.0f : commission;
        return this;
    }

    public MarketPriceCalc setDc(float dc) {
        this.dc = dc > 0.0f ? dc / 100.0f : dc;
        return this;
    }

    public MarketPriceCalc setSellerDc(float sellerDc) {
        this.sellerDc = sellerDc > 0.0f ? sellerDc / 100.0f : sellerDc;
        return this;
    }

    public MarketPriceCalc setFlatDc(float flatDc) {
        this.flatDc = flatDc;
        return this;
    }

    public MarketPriceCalc setFree_delivery(boolean free_delivery) {
        this.isFree_delivery = free_delivery;
        return this;
    }

    public ResultMarketPrice calculate() {
        ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
        double sale_price_1 = ((double)(this.margin * this.flatDc - this.flatDc) - this.testPrice) / (double)((this.margin - 1.0f) * (1.0f - this.commission - this.sellerDc - this.dc));
        sale_price_1 = Math.ceil(sale_price_1 / 10.0) * 10.0;
        resultMarketPrice.setSale_price_1(String.format("%.0f", sale_price_1));
        double sale_price_discount_1 = sale_price_1 * (double)(1.0f - this.sellerDc);
        sale_price_discount_1 = Math.ceil(sale_price_discount_1);
        resultMarketPrice.setSale_price_discount_1(String.format("%.0f", sale_price_discount_1));
        double consumer_if_sale_price = Math.ceil(this.compliancePrice / (1.0f - (this.sellerDc + this.dc)) + this.flatDc);
        double consumer_sale_temp = sale_price_1 * (double)(1.0f - (this.sellerDc + this.dc));
        if (consumer_sale_temp > (double)this.compliancePrice) {
            consumer_if_sale_price = sale_price_1;
        }
        consumer_if_sale_price = Math.ceil(consumer_if_sale_price / 10.0) * 10.0;
        resultMarketPrice.setConsumer_if_sale_price(String.format("%.0f", consumer_if_sale_price));
        double market_price = consumer_if_sale_price * (double)(1.0f - this.sellerDc);
        market_price = Math.ceil(market_price / 10.0) * 10.0;
        resultMarketPrice.setMarket_price(String.format("%.0f", market_price));
        double total_sale_discount = consumer_if_sale_price * (double)(1.0f - (this.sellerDc + this.dc)) + (double)this.flatDc;
        total_sale_discount = Math.ceil(total_sale_discount / 10.0) * 10.0;
        resultMarketPrice.setTotal_sale_discount(String.format("%.0f", total_sale_discount));
        return resultMarketPrice;
    }
}

