/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.jcef;

import java.awt.Frame;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefContextMenuHandler;
import tests.detailed.dialog.SearchDialog;
import tests.detailed.dialog.ShowTextDialog;

public class ContextMenuHandler
implements CefContextMenuHandler {
    private final Frame owner_;
    private Map<Integer, String> suggestions_ = new HashMap<Integer, String>();

    public ContextMenuHandler(Frame owner) {
        this.owner_ = owner;
    }

    public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
        model.clear();
        model.addItem(100, "Back");
        model.setEnabled(100, browser.canGoBack());
        model.addItem(101, "Forward");
        model.setEnabled(101, browser.canGoForward());
        model.addSeparator();
        model.addItem(130, "Find...");
        if (params.hasImageContents() && params.getSourceUrl() != null) {
            model.addItem(26500, "Download Image...");
        }
        model.addItem(132, "View Source...");
        Vector suggestions = new Vector();
        params.getDictionarySuggestions(suggestions);
        model.addSeparator();
        if (suggestions.size() == 0) {
            model.addItem(205, "No suggestions");
            model.setEnabled(205, false);
            return;
        }
        int id = 200;
        for (String suggestedWord : suggestions) {
            model.addItem(id, suggestedWord);
            this.suggestions_.put(id, suggestedWord);
            if (++id > 204) break;
        }
    }

    public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
        String newWord;
        switch (commandId) {
            case 132: {
                ShowTextDialog visitor = new ShowTextDialog(this.owner_, "Source of \"" + browser.getURL() + "\"");
                browser.getSource((CefStringVisitor)visitor);
                return true;
            }
            case 130: {
                SearchDialog search = new SearchDialog(this.owner_, browser);
                search.setVisible(true);
                return true;
            }
            case 26500: {
                browser.startDownload(params.getSourceUrl());
                return true;
            }
        }
        if (commandId >= 200 && (newWord = this.suggestions_.get(commandId)) != null) {
            System.err.println("replacing " + params.getMisspelledWord() + " with " + newWord);
            browser.replaceMisspelling(newWord);
            return true;
        }
        return false;
    }

    public void onContextMenuDismissed(CefBrowser browser, CefFrame frame) {
        this.suggestions_.clear();
    }
}

