/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.data.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.CategoryClassDto;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.data.dao.ShoppingMallCategoryDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCatInfDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class CategoryDao {
    private static CategoryDao instance = new CategoryDao();

    public static CategoryDao get() {
        return instance;
    }

    public void categoryLargeInsert(String code, String category, String disp, String use_yn, String comment, String nvcategory) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into categlarge (compno,code,category, disp, use_yn, comment,navercode )   values (?, ?, ?, ?, ?, ? , ?) ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, code);
                pstmt.setString(++i, category);
                pstmt.setInt(++i, Integer.parseInt(disp));
                pstmt.setString(++i, use_yn);
                pstmt.setString(++i, comment);
                pstmt.setString(++i, nvcategory);
                YDMAStringUtil.Print("[CategoryLargeInsert]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void categoryMidiumInsert(String differcode, String code, String category, String disp, String use_yn, String comment, String nvcategory) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into categmidium (compno,code, lrgcode, category, disp, use_yn, comment, navercode)   values (?, ?, ?, ?, ? ,? ,?, ?) ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, code);
                pstmt.setString(++i, differcode);
                pstmt.setString(++i, category);
                pstmt.setInt(++i, Integer.parseInt(disp));
                pstmt.setString(++i, use_yn);
                pstmt.setString(++i, comment);
                pstmt.setString(++i, nvcategory);
                YDMAStringUtil.Print("[midCategoryInsert]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void categorySmallInsert(String differcode, String code, String category, String disp, String use_yn, String comment, String nvcategory) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into categsmall (compno, code, midcode, category, disp, use_yn, comment, navercode)   values (?, ?, ?, ?, ? ,?, ? ,?) ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, code);
                pstmt.setString(++i, differcode);
                pstmt.setString(++i, category);
                pstmt.setInt(++i, Integer.parseInt(disp));
                pstmt.setString(++i, use_yn);
                pstmt.setString(++i, comment);
                pstmt.setString(++i, nvcategory);
                YDMAStringUtil.Print("[smlCategoryInsert]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void categoryDetailInsert(String differcode, String code, String category, String disp, String use_yn, String comment, String nvcategory) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into categdetail (compno, code, smlcode, category, disp, use_yn, comment,navercode)   values (?, ?, ?, ?, ?, ?, ? , ?) ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, code);
                pstmt.setString(++i, differcode);
                pstmt.setString(++i, category);
                pstmt.setInt(++i, Integer.parseInt(disp));
                pstmt.setString(++i, use_yn);
                pstmt.setString(++i, comment);
                pstmt.setString(++i, nvcategory);
                YDMAStringUtil.Print("[detCategoryInsert]" + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<List<String>> getLargeCategory() throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, category, disp, use_yn, comment   from categlarge  where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getLargeCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getMidiumCategory(String code) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, lrgcode, category, disp, use_yn, comment   from categmidium  where lrgcode = ?    and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, code);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getMidCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getSmallCategory(String code) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, midcode, category, disp, use_yn, comment   from categsmall  where midcode = ?    and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, code);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getSmlCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getDetailCategory(String code) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, smlcode, category, disp, use_yn, comment   from categdetail  where smlcode = ?    and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, code);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getDetCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> largeCategory() throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, disp,category, use_yn, ifnull(comment,''),ifnull(navercode,''),  (SELECT COUNT(*) FROM categlgmap b WHERE b.COMPNO=a.compno AND b.CODE = a.CODE)    from categlarge a  where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[largeCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex).equals("1") ? "\uc0ac\uc6a9\uc911" : "\ubbf8\uc0ac\uc6a9");
                    list.add(rs.getString(++columnIndex));
                    list.add("");
                    list.add(rs.getString(++columnIndex));
                    list.add("\uc218\uc815");
                    list.add("\ub9e4\ud551");
                    list.add("(" + rs.getString(++columnIndex) + ")");
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> midiumCategory(String categ) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, disp,category, use_yn, ifnull(comment,''),lrgcode,ifnull(navercode,''),  (SELECT COUNT(*) FROM categmdmap b WHERE b.COMPNO=a.compno AND b.CODE = a.CODE)    from categmidium a  where lrgcode = ?    and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, categ);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[midiumCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex).equals("1") ? "\uc0ac\uc6a9\uc911" : "\ubbf8\uc0ac\uc6a9");
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add("");
                    list.add("");
                    list.add("(" + rs.getString(++columnIndex) + ")");
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> smallCategory(String categ) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, disp,category, use_yn, ifnull(comment,''),midcode,ifnull(navercode,''),  (SELECT COUNT(*) FROM categsmmap b WHERE b.COMPNO=a.compno AND b.CODE = a.CODE)    from categsmall a  where midcode = ?    and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, categ);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[smallCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex).equals("1") ? "\uc0ac\uc6a9\uc911" : "\ubbf8\uc0ac\uc6a9");
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add("");
                    list.add("");
                    list.add("(" + rs.getString(++columnIndex) + ")");
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> detailCategory(String categ) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, disp,category, use_yn, ifnull(comment,''),smlcode,ifnull(navercode,''),  (SELECT COUNT(*) FROM categdtlmap b WHERE b.COMPNO=a.compno AND b.CODE = a.CODE)    from categdetail a  where smlcode = ?    and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, categ);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[detailCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex).equals("1") ? "\uc0ac\uc6a9\uc911" : "\ubbf8\uc0ac\uc6a9");
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add("");
                    list.add("");
                    list.add("(" + rs.getString(++columnIndex) + ")");
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public void categoryLargeUpdate(String code, String category, String disp, String use_yn, String comment, String nvcategory) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "update categlarge set category=?, disp=?, use_yn=?, comment=?, navercode = ? where code=? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, category);
                pstmt.setInt(++i, Integer.parseInt(disp));
                pstmt.setString(++i, use_yn);
                pstmt.setString(++i, comment);
                pstmt.setString(++i, nvcategory);
                pstmt.setString(++i, code);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[larCategoryUpdate]" + pstmt.toString());
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void categoryMidiumUpdate(String differcode, String code, String category, String disp, String use_yn, String comment, String nvcategory) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "update categmidium set category=?, disp=?, use_yn=?, comment=?, lrgcode=?, navercode = ? where code=? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, category);
                pstmt.setInt(++i, Integer.parseInt(disp));
                pstmt.setString(++i, use_yn);
                pstmt.setString(++i, comment);
                pstmt.setString(++i, differcode);
                pstmt.setString(++i, nvcategory);
                pstmt.setString(++i, code);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[midCategoryUpdate]" + pstmt.toString());
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void categorySmallUpdate(String differcode, String code, String category, String disp, String use_yn, String comment, String nvcategory) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "update categsmall set category=?, disp=?, use_yn=?, comment=?, midcode=?, navercode =? where code=? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, category);
                pstmt.setInt(++i, Integer.parseInt(disp));
                pstmt.setString(++i, use_yn);
                pstmt.setString(++i, comment);
                pstmt.setString(++i, differcode);
                pstmt.setString(++i, nvcategory);
                pstmt.setString(++i, code);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[smlCategoryUpdate]" + pstmt.toString());
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void categoryDetailUpdate(String differcode, String code, String category, String disp, String use_yn, String comment, String nvcategory) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "update categdetail set category=?, disp=?, use_yn=?, comment=?, smlcode=?,navercode =? where code=? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, category);
                pstmt.setInt(++i, Integer.parseInt(disp));
                pstmt.setString(++i, use_yn);
                pstmt.setString(++i, comment);
                pstmt.setString(++i, differcode);
                pstmt.setString(++i, nvcategory);
                pstmt.setString(++i, code);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[detCategoryUpdate]" + pstmt.toString());
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<List<String>> getNaverLargeCategory() throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select nvcode, nvcategory from naverlagcateg ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[nvlagCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getNaverMidiumCategory(String nacate) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select nvcode,nvlarge, nvcategory from navermidcateg where nvlarge = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, nacate);
                YDMAStringUtil.Print("[nvmidCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getNaverSmallCategory(String nacate) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select nvcode,nvmidium, nvcategory from naversmlcateg where nvmidium = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, nacate);
                YDMAStringUtil.Print("[nvsmlCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getNaverDetailCategory(String nacate) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select nvcode,nvsmall, nvcategory from naverdetcateg where nvsmall = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, nacate);
                YDMAStringUtil.Print("[nvsmlCategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<String> naverLargeCategory(String categlagcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, category, disp, use_yn, comment,ifnull(navercode,'') from categlarge where code = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, categlagcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[nvlarcategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<String> naverMidiumCategory(String categlagcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, lrgcode,category, disp, use_yn, comment,ifnull(navercode,'') from categmidium where code = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, categlagcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[nvmidcategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<String> naverSmallCategory(String categlagcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, midcode,category, disp, use_yn, comment,ifnull(navercode,'') from categsmall where code = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, categlagcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[nvsmlcategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<String> naverDetailCategory(String categlagcd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code, smlcode,category, disp, use_yn, comment,ifnull(navercode,'') from categdetail where code = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, categlagcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[nvdetcategory]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public boolean isExistLarge(String code) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code from categlarge where code = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, code);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[isExistProduct]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isExistMidium(String mycode) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code from categmidium where code = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, mycode);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[isExistProduct]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isExistSmall(String mycode) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code from categsmall where code = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, mycode);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[isExistProduct]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isExistDetail(String mycode) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select code from categdetail where code = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, mycode);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[isExistProduct]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public int getShopcatinfMaxseq(String shopcd) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt_orddtl = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql_orddtl = "SELECT ifnull(MAX(SHOPCATNO),0) FROM shopcatinf  where compno = ?    and shopcd = ?";
                sql_orddtl = sql_orddtl.toUpperCase();
                pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_orddtl.setString(2, shopcd);
                YDMAStringUtil.Print("[getShopcatinfMaxseq]" + pstmt_orddtl.toString());
                rs = pstmt_orddtl.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
        return result;
    }

    public int setShopcatinfInsert(String shopcode, int seq, String title, String allcate, String lagcd, String midcd, String smlcd, String detcd, String service, String useyn, String nomal, String shopid, String comm, String esmcatecd) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        int result = 0;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into shopcatinf (compno, shopcd, shopcatno, shopcatnm, shopcatsitenm, shoplagcatcd, shopmidcatcd, shopsmlcatcd, shopdetcatcd, serviceprod, use_yn, SHOPGENERAL, SHOPID, insertdt, SHOPCOMMIS, EBAYCATCD)   values (?, ?, ?, ?, ? ,?, ? , ?, ?, ?, ?, ?, ?, ?, ? ,? ) ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, shopcode);
                pstmt.setInt(++i, seq);
                pstmt.setString(++i, title);
                pstmt.setString(++i, allcate);
                pstmt.setString(++i, lagcd);
                pstmt.setString(++i, midcd);
                pstmt.setString(++i, smlcd);
                pstmt.setString(++i, detcd);
                pstmt.setString(++i, service);
                pstmt.setString(++i, useyn);
                pstmt.setString(++i, nomal);
                pstmt.setString(++i, shopid);
                pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setFloat(++i, Float.parseFloat(comm) / 100.0f);
                pstmt.setString(++i, esmcatecd);
                YDMAStringUtil.Print("[smlCategoryInsert]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public List<List<String>> getCategorySearchList(int date, int result, String search, String prodFrom, String prodTo, int shopcd, int useyn, List<String> shoplist) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(b.SHOPCATNO,''),ifnull(c.SHOPNM,''),ifnull(c.MARKETCATEG,''),ifnull(b.SHOPCATNM,''),ifnull(b.SHOPCATSITENM,''),ifnull(b.SHOPLAGCATCD,''),ifnull(b.SHOPMIDCATCD,''),ifnull(b.SHOPSMLCATCD,''), ifnull(b.SHOPDETCATCD,''), ifnull(b.SERVICEPROD,''),ifnull(b.USE_YN,''),ifnull(b.INSERTDT,''),ifnull(b.MODIFYDT,'')  FROM shopmst a JOIN shopcatinf b ON a.SHOPCD=b.SHOPCD and a.COMPNO = b.COMPNO join shopinfo c ON a.shopcd = c.shopcd where b.compno = ? ";
                sql = date == 0 ? String.valueOf(sql) + " and b.insertdt >= ? and b.insertdt <= ? " : String.valueOf(sql) + " and b.updatedt >= ? and b.updatedt <= ? ";
                sql = useyn == 1 ? String.valueOf(sql) + " and b.USE_YN = 'Y' " : String.valueOf(sql) + " and b.USE_YN = 'N' ";
                sql = result == 1 ? String.valueOf(sql) + " and b.shopcatnm like ? " : String.valueOf(sql) + " and b.SHOPCATNO like ? ";
                if (shopcd != 0) {
                    sql = String.valueOf(sql) + " and b.shopcd = ? ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (date == 0) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                } else {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                }
                if (result == 1) {
                    pstmt.setString(4, "%" + search + "%");
                } else {
                    pstmt.setString(4, "%" + search + "%");
                }
                if (shopcd != 0) {
                    pstmt.setString(5, shoplist.get(0));
                }
                YDMAStringUtil.Print("[getCategorySearchList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getAllCategoryList() throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(a.CODE,''),ifnull(a.CATEGORY,''),ifnull(b.CODE,''),ifnull(b.LRGCODE,''),ifnull(b.CATEGORY,''),ifnull(C.CODE,''),ifnull(c.MIDCODE,''),ifnull(C.CATEGORY,''), ifnull(D.CODE,''),ifnull(D.SMLCODE,''),ifnull(D.CATEGORY,'')  FROM CATEGLARGE a JOIN CATEGMIDIUM b ON a.COMPNO=b.COMPNO AND a.CODE = b.LRGCODE JOIN CATEGSMALL C ON a.COMPNO = C.COMPNO AND b.CODE = C.MIDCODE JOIN CATEGDETAIL D ON  a.COMPNO = D.COMPNO AND C.CODE = D.SMLCODE WHERE a.compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopMstSelectList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int setShopcatinfUpdate(String shopcode, String shopcatno, String title, String allcate, String lagcd, String midcd, String smlcd, String detcd, String service, String useyn, String nomal, String shopid, String comm, String esmcatecd) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopcatinf set SHOPCATNM=?, SHOPCATSITENM=?, SHOPLAGCATCD=?, SHOPMIDCATCD=?, SHOPSMLCATCD=?, SHOPDETCATCD=?, SERVICEPROD =? , use_yn = ?,SHOPGENERAL =?, SHOPID =?,  MODIFYDT = ?, SHOPCOMMIS = ? , EBAYCATCD = ?  where SHOPCATNO = ? and SHOPCD=? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, title);
                pstmt.setString(++i, allcate);
                pstmt.setString(++i, lagcd);
                pstmt.setString(++i, midcd);
                pstmt.setString(++i, smlcd);
                pstmt.setString(++i, detcd);
                pstmt.setString(++i, service);
                pstmt.setString(++i, useyn);
                pstmt.setString(++i, nomal);
                pstmt.setString(++i, shopid);
                pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setFloat(++i, Float.parseFloat(comm) / 100.0f);
                pstmt.setString(++i, esmcatecd);
                pstmt.setString(++i, shopcatno);
                pstmt.setString(++i, shopcode);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[detCategoryUpdate]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public void catinfoDelete(List<List<String>> contents_target) throws Exception {
        block6: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "delete from shopcatinf where compno = ? and shopcatno = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (List<String> list : contents_target) {
                        int i = 0;
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setString(++i, list.get(0));
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[prodAttrvalInsert]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public List<List<String>> getCategorymapping(String compno, String shopcatno) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select IFNULL(B.SHOPNM,''),IFNULL(A.SHOPID,''),IFNULL(A.SHOPCATNM,''),IFNULL(A.SHOPCATSITENM,''),IFNULL(A.SHOPCD,'') from shopcatinf AS A INNER JOIN SHOPINFO AS B ON A.SHOPCD = B.SHOPCD where A.compno=? and A.shopcatno  =? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, compno);
                pstmt.setString(2, shopcatno);
                YDMAStringUtil.Print("[getCategorymapping]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                    YDMAStringUtil.Print();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int ShopcatinfInsert1(ShopCatInfDto dto, String dome) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        int result = 0;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into shopcatinf (COMPNO,DOME, SHOPCATNM,SHOPCD,SHOPCATSITENM,SHOPLAGCATCD,SHOPMIDCATCD,SHOPSMLCATCD,SHOPDETCATCD,SHOPID,INSERTDT,SHOPCATNO) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)   ON DUPLICATE KEY UPDATE SHOPCATNM = ?  ,     SHOPCATSITENM = ?,            SHOPLAGCATCD = ?,            SHOPMIDCATCD = ?,            SHOPSMLCATCD = ?,            SHOPDETCATCD = ?,            SHOPCATNO = ?        ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, dto.getCompno());
                pstmt.setString(++i, dome);
                pstmt.setString(++i, dto.getShopcatnm());
                pstmt.setString(++i, dto.getShopcd());
                pstmt.setString(++i, dto.getShopcatsitenm().trim());
                pstmt.setString(++i, dto.getShoplagcatcd());
                pstmt.setString(++i, dto.getShopmidcatcd());
                pstmt.setString(++i, dto.getShopsmlcatcd());
                pstmt.setString(++i, dto.getShopdetcatcd());
                pstmt.setString(++i, dto.getShopid());
                pstmt.setString(++i, dto.getInsertdt());
                pstmt.setString(++i, dto.getShopcatno());
                pstmt.setString(++i, dto.getShopcatnm());
                pstmt.setString(++i, dto.getShopcatsitenm().trim());
                pstmt.setString(++i, dto.getShoplagcatcd());
                pstmt.setString(++i, dto.getShopmidcatcd());
                pstmt.setString(++i, dto.getShopsmlcatcd());
                pstmt.setString(++i, dto.getShopdetcatcd());
                pstmt.setString(++i, dto.getShopcatno());
                YDMAStringUtil.Print("[ShopcatinfInsert1]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public Map<Integer, List<CategoryClassDto>> getCategoryClass() throws SQLException {
        HashMap<Integer, List<CategoryClassDto>> result = new HashMap<Integer, List<CategoryClassDto>>();
        BeanListHandler handler = new BeanListHandler(CategoryClassDto.class);
        QueryRunner run = new QueryRunner();
        try (Connection connection = null;){
            try {
                connection = DBCPInit.getInstance().getConnection();
                int i = 1;
                while (i < 5) {
                    String sql = "SELECT ID, NAME, PARENT_CODE, FULL_NAME, `LEVEL`, IFNULL(SHOPCATE, '') AS SHOPCATE FROM category WHERE `LEVEL`=" + Integer.toString(i);
                    List categoryInfo = (List)run.query(connection, sql, (ResultSetHandler)handler);
                    result.put(i, categoryInfo);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return result;
    }

    public CategoryClassDto getCategoryInfo(String fullNm) throws Exception {
        CategoryClassDto categoryList = new CategoryClassDto();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(CategoryClassDto.class);
        try (Connection connection = DBCPInit.getInstance().getConnection();){
            try {
                String sql = "SELECT * FROM category WHERE FULL_NAME='" + fullNm + "'";
                categoryList = (CategoryClassDto)run.query(connection, sql, (ResultSetHandler)handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return categoryList;
    }

    public List<ShoppingMallCategoryDto> getShopCategoryInfo(String shopCd) throws Exception {
        List<ShoppingMallCategoryDto> shopCategoryList = new ArrayList<ShoppingMallCategoryDto>();
        Connection connection = DBCPInit.getInstance().getConnection();
        QueryRunner run = new QueryRunner();
        BeanListHandler handler = new BeanListHandler(ShoppingMallCategoryDto.class);
        try {
            try {
                String sql = "SELECT * FROM SHOPCATEGORYS WHERE SHOPCD='" + shopCd + "' AND SHOPCATENM LIKE '%>%'";
                shopCategoryList = (List)run.query(connection, sql, (ResultSetHandler)handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        finally {
            connection.close();
        }
        return shopCategoryList;
    }

    public ShoppingMallCategoryDto getShopCategoryInfo2(String shopCd, String code) throws Exception {
        ShoppingMallCategoryDto shopCategory = null;
        Connection connection = DBCPInit.getInstance().getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ShoppingMallCategoryDto.class);
        try {
            try {
                String sql = "SELECT * FROM SHOPCATEGORYS WHERE SHOPCD='" + shopCd + "' AND `CODE`='" + code + "'";
                shopCategory = (ShoppingMallCategoryDto)run.query(connection, sql, (ResultSetHandler)handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        finally {
            connection.close();
        }
        return shopCategory;
    }

    public ShoppingMallCategoryDto getShopCategoryInfo3(String shopCd, String fullNm) throws Exception {
        ShoppingMallCategoryDto shopCategory = null;
        Connection connection = DBCPInit.getInstance().getConnection();
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ShoppingMallCategoryDto.class);
        try {
            try {
                String sql = shopCd.equals("shop0075") ? "SELECT * FROM SHOPCATEGORYS WHERE SHOPCD='" + shopCd + "' AND SHOPCATENM like CONCAT(' ','" + fullNm + "%') LIMIT 1" : "SELECT * FROM SHOPCATEGORYS WHERE SHOPCD='" + shopCd + "' AND SHOPCATENM='" + fullNm + "'";
                shopCategory = (ShoppingMallCategoryDto)run.query(connection, sql, (ResultSetHandler)handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        finally {
            connection.close();
        }
        return shopCategory;
    }
}

