/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.coupang;

import com.coupang.openapi.sdk.Hmac;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class CoupangOrderConfirmCommand
implements IShopOrderCommand {
    private static IShopOrderCommand instance = new CoupangOrderConfirmCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    @Override
    public void Login(String loginID, String loginPw, String gubun) throws Exception {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return 0;
    }

    @Override
    public int Search_conf(String URL2, String startdt, String enddt, String searchkeyword) throws Exception {
        return 0;
    }

    private CoupangOrderConfirmCommand() {
    }

    private List<ShopOrderMstDto> getApiList(List<ShopOrderMstDto> param, String json) throws Exception {
        ArrayList<ShopOrderMstDto> ret_list;
        block24: {
            ret_list = new ArrayList<ShopOrderMstDto>();
            CloseableHttpResponse response = null;
            CloseableHttpClient client = null;
            String id = param.get(0).getShop_userid();
            param.get(0).getShopPw();
            String shopid = param.get(0).getShopid();
            try {
                String URL2 = "/v2/providers/openapi/apis/api/v4/vendors/%s/ordersheets/acknowledgement";
                String acessKey = param.get(0).getAuthkey1();
                String secretKey = param.get(0).getAuthKey2();
                String vendorid = param.get(0).getVendorId();
                URL2 = String.format(URL2, vendorid);
                URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
                String authorization = Hmac.generate((String)"PATCH", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
                uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
                StringEntity params = new StringEntity(json, "UTF-8");
                client = HttpClients.createDefault();
                HttpPatch requestPatch = new HttpPatch(uriBuilder.build().toString());
                requestPatch.addHeader("Authorization", authorization);
                requestPatch.addHeader("content-type", "application/json");
                requestPatch.setEntity((HttpEntity)params);
                response = client.execute((HttpUriRequest)requestPatch);
                int status2 = response.getStatusLine().getStatusCode();
                response.getStatusLine().getReasonPhrase();
                if (status2 != 200) break block24;
                JsonParser parser = new JsonParser();
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                JsonObject data2 = (JsonObject)resObject.get("data");
                if (data2.size() > 0) {
                    JsonArray responseList = (JsonArray)data2.get("responseList");
                    int i = 0;
                    while (i < responseList.size()) {
                        JsonObject result = (JsonObject)responseList.get(i);
                        String boxId = this.jsonElementNullStr(result.get("shipmentBoxId"));
                        boolean isSucced = result.get("succeed").getAsBoolean();
                        String resultMessage = this.jsonElementNullStr(result.get("resultMessage"));
                        for (ShopOrderMstDto dto : param) {
                            if (!dto.getCopy_idx().equals(boxId)) continue;
                            if (isSucced) {
                                dto.setResult_code("1");
                                dto.setShopid(shopid);
                                dto.setShop_userid(id);
                                dto.setOrder_status("100");
                            } else {
                                dto.setResult_code("-1");
                            }
                            dto.setResult_text(resultMessage);
                            ret_list.add(dto);
                        }
                        ++i;
                    }
                    break block24;
                }
                param.get(0).setResult_code("0");
                param.get(0).setResult_text("\uc870\ud68c\ud560 \ub370\uc774\ud0c0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. ");
                List<ShopOrderMstDto> list = param;
                return list;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return ret_list;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        String vendorid = param.get(0).getVendorId();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        OrderOkParm data2 = new OrderOkParm();
        data2.setVendorId(vendorid);
        List<Long> shipmentBoxIds = param.stream().map(p -> YDMAStringUtil.convertToLong(p.getCopy_idx())).collect(Collectors.toList());
        data2.setShipmentBoxIds(shipmentBoxIds);
        String json = mapper.writeValueAsString((Object)data2);
        YDMAStringUtil.Print(json);
        List<ShopOrderMstDto> retlist = this.getApiList(param, json);
        return retlist;
    }

    static class OrderOkParm {
        private String vendorId;
        private List<Long> shipmentBoxIds;

        OrderOkParm() {
        }

        public String getVendorId() {
            return this.vendorId;
        }

        public void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        public List<Long> getShipmentBoxIds() {
            return this.shipmentBoxIds;
        }

        public void setShipmentBoxIds(List<Long> shipmentBoxIds) {
            this.shipmentBoxIds = shipmentBoxIds;
        }
    }
}

