/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.common.MarketPriceCalc;
import com.kdjsystem.mlink.yellim.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDto;
import java.util.ArrayList;
import java.util.List;

public class ShopProductSendDto {
    List<ProductDTO> shopProductDto;
    ShopProductAdditionDto productAdditionDto;
    ShoppingmallDTO shoppingmallDTO;
    WorkMngDto workMngDto;
    String workgrp = "";
    private int multicnt;
    private boolean Isshopprodin;
    private String mode = "";
    private List<String> updateFlag;

    public ShopProductSendDto() {
    }

    public ShopProductSendDto(List<ProductDTO> shopProductDto, ShopProductAdditionDto productAdditionDto, ShoppingmallDTO shoppingmallDTO) {
        this.shopProductDto = shopProductDto;
        this.productAdditionDto = productAdditionDto;
        this.shoppingmallDTO = shoppingmallDTO;
        this.setWorkMngDto();
    }

    public WorkMngDto getWorkMngDto() {
        return this.workMngDto;
    }

    public void setWorkMngDto() {
        this.workMngDto = new WorkMngDto();
        this.workMngDto.setWorkgrp(this.workgrp);
        this.workMngDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
        this.workMngDto.setShopcd(this.shoppingmallDTO.getSHOPCD());
        this.workMngDto.setShopseq(String.valueOf(this.shoppingmallDTO.getSHOPSEQ()));
        this.workMngDto.setShop_user_id(this.shoppingmallDTO.getSHOPPINGID());
        boolean isReg = this.shopProductDto.stream().allMatch(p -> YDMAStringUtil.convertToInt(p.getSendstats()) == 9000 || YDMAStringUtil.convertToInt(p.getSendstats()) == 6100 || YDMAStringUtil.convertToInt(p.getSendstats()) == -9000);
        if (isReg) {
            this.workMngDto.setWorkcd("100");
            this.workMngDto.setWork_status("W01");
        } else {
            boolean ismodify = this.shopProductDto.stream().allMatch(p -> YDMAStringUtil.convertToInt(p.getSendstats()) == 4000 || YDMAStringUtil.convertToInt(p.getSendstats()) == 2000);
            if (ismodify) {
                boolean isSoldout = this.shopProductDto.stream().allMatch(p -> YDMAStringUtil.convertToInt(p.getSendstats()) == 4000);
                if (isSoldout) {
                    this.workMngDto.setWorkcd("500");
                    this.workMngDto.setWork_status("W01");
                } else {
                    this.workMngDto.setWorkcd("600");
                    this.workMngDto.setWork_status("W01");
                }
            } else {
                this.workMngDto.setWorkcd("200");
                this.workMngDto.setWork_status("W01");
            }
        }
        this.workMngDto.setWork_userid(YDMASessonUtil.getCompnoInfo().getUserId());
        this.workMngDto.setProgress_rate(0);
        ArrayList<WorkMngDetailDto> workMngDetailDtos = new ArrayList<WorkMngDetailDto>();
        for (ProductDTO dto : this.shopProductDto) {
            WorkMngDetailDto workMngDetailDto = new WorkMngDetailDto();
            workMngDetailDto.setWorkgrp(this.workgrp);
            workMngDetailDto.setSeq(dto.getWorkseq());
            workMngDetailDto.setProdseq(dto.getCompayny_goods_cd());
            workMngDetailDto.setStatus("W01");
            workMngDetailDtos.add(workMngDetailDto);
        }
        this.workMngDto.setWork_detail(workMngDetailDtos);
    }

    public String getWorkgrp() {
        return this.workgrp;
    }

    public void setWorkgrp(String workgrp) {
        this.workgrp = workgrp;
    }

    public String getShopCd() {
        return this.shoppingmallDTO.getSHOPCD();
    }

    public int getMulticnt() {
        return this.multicnt;
    }

    public void setMulticnt(int multicnt) {
        this.multicnt = multicnt;
    }

    public boolean getIsshopprodin() {
        return this.Isshopprodin;
    }

    public void setIsshopprodin(boolean isshopprodin) {
        this.Isshopprodin = isshopprodin;
    }

    public String getMode() {
        return this.mode;
    }

    public void addUpdateFlag(String flag) {
        if (this.updateFlag == null) {
            this.updateFlag = new ArrayList<String>();
        }
        this.updateFlag.add(flag);
    }

    public List<String> getUpdateFlag() {
        return this.updateFlag;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<ProductDTO> getShopProductDto() {
        return this.shopProductDto;
    }

    public void setShopProductDto(List<ProductDTO> shopProductDto) {
        for (ProductDTO dto : shopProductDto) {
            this.getMarketCalcate(YDMAStringUtil.convertToInt(dto.getLimit_price()), YDMAStringUtil.convertToInt(dto.getGoods_price()));
        }
        this.shopProductDto = shopProductDto;
    }

    public void setShopProductDto(ShopProductAdditionDto productAdditionDto, List<ProductDTO> shopProductDto) {
        this.productAdditionDto = productAdditionDto;
        for (ProductDTO dto : shopProductDto) {
            this.getMarketCalcate(YDMAStringUtil.convertToInt(dto.getLimit_price()), YDMAStringUtil.convertToInt(dto.getGoods_price()));
        }
        this.shopProductDto = shopProductDto;
    }

    public ShopProductAdditionDto getProductAdditionDto() {
        return this.productAdditionDto;
    }

    public void setProductAdditionDto(ShopProductAdditionDto productAdditionDto) {
        this.productAdditionDto = productAdditionDto;
    }

    public ShoppingmallDTO getShoppingmallDTO() {
        return this.shoppingmallDTO;
    }

    public void setShoppingmallDTO(ShoppingmallDTO shoppingmallDTO) {
        this.shoppingmallDTO = shoppingmallDTO;
    }

    public String getMarketCalcate(float compliancePrice, long testPrice) {
        if (this.productAdditionDto == null) {
            return String.valueOf(testPrice);
        }
        return MarketPriceCalc.get().setCompliancePrice(compliancePrice).setTestPrice(testPrice).setSellerDc(this.productAdditionDto.getSellerDc()).setDc(this.productAdditionDto.getDc()).setFlatDc(this.productAdditionDto.getFlatDc()).setMargin(this.productAdditionDto.getMargin()).setCommission(this.productAdditionDto.getCommission()).calculate().getConsumer_if_sale_price();
    }

    public static ResultMarketPrice getMarketCalcate(ShopProductAdditionDto productAdditionDto, float compliancePrice, long testPrice) {
        if (productAdditionDto == null) {
            ResultMarketPrice dto = new ResultMarketPrice();
            dto.setConsumer_if_sale_price(String.valueOf(testPrice));
            dto.setTotal_sale_discount(String.valueOf(testPrice));
            return dto;
        }
        return MarketPriceCalc.get().setCompliancePrice(compliancePrice).setTestPrice(testPrice).setSellerDc(productAdditionDto.getSellerDc()).setDc(productAdditionDto.getDc()).setFlatDc(productAdditionDto.getFlatDc()).setMargin(productAdditionDto.getMargin()).setCommission(productAdditionDto.getCommission()).calculate();
    }
}

