/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dao.CategoryDAO;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.CategoryDTO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductAddProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductAddProcess;
import com.kdjsystem.mlink.yellim.helper.DateHelper;
import com.kdjsystem.mlink.yellim.protocol.ElevenstProductSearchRequest;
import com.kdjsystem.mlink.yellim.protocol.ElevenstProductSearchResponse;
import com.kdjsystem.mlink.yellim.protocol.ElevenstProductsSearchResponse;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAddDialog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ElevenstProductAddService
implements IProductAddProcess {
    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto) throws Exception {
        boolean flag = true;
        int start = 1;
        int limit = 5000;
        int end = 10;
        int page = 0;
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String beginText = String.format(String.valueOf(DateHelper.getCurrentTimeString()) + "[%s - %s]\r\n", shopInfo.getSHOPNM(), shopInfo.getNICKNM1());
        CommonProgressDialog.get().setValue(beginText.concat("\uc1fc\ud551\ubab0\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4..."), 0);
        try {
            while (flag) {
                String line;
                ++page;
                PostMethod post = new PostMethod("http://api.11st.co.kr/rest/prodmarketservice/prodmarket");
                post.setRequestHeader("openapikey", shopInfo.getAPIKEY());
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ElevenstProductsSearchResponse.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                HttpClient httpclient = new HttpClient();
                httpclient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
                httpclient.getHttpConnectionManager().getParams().setSoTimeout(60000);
                String theXml = this.getXml(String.valueOf(start), String.valueOf(limit), String.valueOf(end), dto);
                StringRequestEntity entity = new StringRequestEntity(theXml, "text/xml", "EUC-KR");
                post.setRequestEntity((RequestEntity)entity);
                int statusCode = httpclient.executeMethod((HttpMethod)post);
                YDMAStringUtil.Print("[No] StatusCode : [" + start + "] " + post.getStatusCode());
                if (statusCode != 200) continue;
                InputStream in = post.getResponseBodyAsStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                StringBuffer buffer = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                reader.close();
                StringReader streader = new StringReader(buffer.toString());
                ElevenstProductsSearchResponse response = (ElevenstProductsSearchResponse)jaxbUnmarshaller.unmarshal((Reader)streader);
                if (response.getItems() != null) {
                    ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                    for (ElevenstProductSearchResponse item : response.getItems()) {
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        CommonProgressDialog.get().setValue(beginText.concat("'" + item.getSellerPrdCd() + "' \ubd88\ub7ec\uc624\ub294\uc911..."), 0);
                        ProductDTO responseProduct = this.setDataBinding(shopInfo, item.getPrdNo(), dto.getCOOKIES(), domemallInfos);
                        if (responseProduct == null) continue;
                        responseProducts.add(responseProduct);
                    }
                    if (responseProducts.size() > 0) {
                        CommonProgressDialog.get().setValue(beginText.concat(String.valueOf(page) + " \ubc88\uc9f8 " + responseProducts.size() + "\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4..."), 0);
                    }
                    for (ProductDTO product2 : responseProducts) {
                        int ret;
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            ret = ProductDAO.get().insertProductInfo(product2);
                            if (ret == 1) {
                                infoRet += ret;
                            }
                        } else {
                            copyProduct.setClass_cd3(product2.getClass_cd3());
                            copyProduct.setShop_cid_info(product2.getShop_cid_info());
                            ret = ProductDAO.get().updateProductInfo(copyProduct);
                            if (ret == 1) {
                                infoRet += ret;
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product2.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret2 = ProductDAO.get().insertProductIn(product2);
                            if (ret2 == 1) {
                                inRet += ret2;
                            }
                        } else {
                            copyProductIn.setClass_cd3(product2.getClass_cd3());
                            copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                            copyProductIn.setGoods_nm(product2.getGoods_nm());
                            copyProductIn.setShopprodno(product2.getShopprodno());
                            copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product2.getSaleenddt());
                            copyProductIn.setMarket_price(product2.getMarket_price());
                            copyProductIn.setGoods_price(product2.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                            copyProductIn.setStatus(product2.getStatus());
                            copyProductIn.setSendstats(product2.getSendstats());
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                            if (ret3 == 1) {
                                inRet += ret3;
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product2.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                        }
                    }
                    start += 10;
                    end += 10;
                } else {
                    flag = false;
                }
                post.releaseConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonProgressDialog.get().setValue(beginText.concat(e.getMessage()), 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        CommonProgressDialog.get().setValue(beginText.concat("\ucd1d " + inRet + "\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4."), 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto, List<String> specificCodes) throws Exception {
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String beginText = String.format(String.valueOf(DateHelper.getCurrentTimeString()) + "[%s - %s]\r\n", shopInfo.getSHOPNM(), shopInfo.getNICKNM1());
        CommonProgressDialog.get().setValue(beginText.concat("\uc1fc\ud551\ubab0\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4..."), 0);
        try {
            for (String specificCode : specificCodes) {
                String line;
                if (ProductAddDialog.getIsCanceled()) {
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                GetMethod get = new GetMethod("http://api.11st.co.kr/rest/prodmarketservice/sellerprodcode/" + specificCode);
                get.setRequestHeader("openapikey", shopInfo.getAPIKEY());
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ElevenstProductsSearchResponse.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                HttpClient httpclient = new HttpClient();
                httpclient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
                httpclient.getHttpConnectionManager().getParams().setSoTimeout(60000);
                int statusCode = httpclient.executeMethod((HttpMethod)get);
                YDMAStringUtil.Print("[No] StatusCode : " + get.getStatusCode());
                if (statusCode != 200) continue;
                InputStream in = get.getResponseBodyAsStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                StringBuffer buffer = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append("\n");
                }
                reader.close();
                StringReader streader = new StringReader(buffer.toString());
                ElevenstProductsSearchResponse response = (ElevenstProductsSearchResponse)jaxbUnmarshaller.unmarshal((Reader)streader);
                if (response.getItems() != null) {
                    ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                    for (ElevenstProductSearchResponse item : response.getItems()) {
                        CommonProgressDialog.get().setValue(beginText.concat("'" + item.getSellerPrdCd() + "' \ubd88\ub7ec\uc624\ub294\uc911..."), 0);
                        ProductDTO responseProduct = this.setDataBinding(shopInfo, item.getPrdNo(), dto.getCOOKIES(), domemallInfos);
                        if (responseProduct == null) continue;
                        responseProducts.add(responseProduct);
                    }
                    if (responseProducts.size() > 0) {
                        CommonProgressDialog.get().setValue(beginText.concat(String.valueOf(responseProducts.size()) + "\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4..."), 0);
                    }
                    for (ProductDTO product2 : responseProducts) {
                        int ret;
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            ret = ProductDAO.get().insertProductInfo(product2);
                            if (ret == 1) {
                                infoRet += ret;
                            }
                        } else {
                            copyProduct.setClass_cd3(product2.getClass_cd3());
                            copyProduct.setShop_cid_info(product2.getShop_cid_info());
                            ret = ProductDAO.get().updateProductInfo(copyProduct);
                            if (ret == 1) {
                                infoRet += ret;
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product2.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret2 = ProductDAO.get().insertProductIn(product2);
                            if (ret2 == 1) {
                                inRet += ret2;
                            }
                        } else {
                            copyProductIn.setClass_cd3(product2.getClass_cd3());
                            copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                            copyProductIn.setGoods_nm(product2.getGoods_nm());
                            copyProductIn.setShopprodno(product2.getShopprodno());
                            copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product2.getSaleenddt());
                            copyProductIn.setMarket_price(product2.getMarket_price());
                            copyProductIn.setGoods_price(product2.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                            copyProductIn.setStatus(product2.getStatus());
                            copyProductIn.setSendstats(product2.getSendstats());
                            String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                            if (ret3 == 1) {
                                inRet += ret3;
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product2.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                                ProductDAO.get().updateOptProductInfo(copyOption);
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                            ProductDAO.get().updateOptProductIn(copyOptionIn);
                        }
                    }
                }
                get.releaseConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonProgressDialog.get().setValue(beginText.concat(e.getMessage()), 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        CommonProgressDialog.get().setValue(beginText.concat("\ucd1d " + inRet + "\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4."), 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    public String getXml(String startIdx, String limit, String end, ProductAddProcessDTO dto) throws JAXBException {
        ElevenstProductSearchRequest request2 = new ElevenstProductSearchRequest();
        request2.start = startIdx;
        request2.end = end;
        request2.schBgnDt = dto.getSTART_DATE().replaceAll("-", "");
        request2.schEndDt = dto.getEND_DATE().replaceAll("-", "");
        request2.schDateType = "1";
        request2.limit = limit;
        request2.selStatCd = "103";
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ElevenstProductSearchRequest.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"euc-kr");
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)request2, (Writer)writer);
        String theXML = writer.toString().replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        return theXML;
    }

    public ProductDTO setDataBinding(ShoppingmallDTO shopInfo, String shopprodno, Map<String, String> cookies, List<DomemallDTO> domemallInfos) {
        ProductDTO responseProduct = new ProductDTO();
        JsonParser parser = new JsonParser();
        try {
            Connection.Response response = Jsoup.connect((String)MallCode.getElevenstProductSingleSearchURL(shopprodno)).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("http://soffice.11st.co.kr/product/SellProductAction.tmall?method=getSellProductList").header("Origin", "http://soffice.11st.co.kr").method(Connection.Method.POST).cookies(cookies).followRedirects(true).ignoreHttpErrors(true).followRedirects(true).execute();
            String body = response.body();
            body = body.substring(body.indexOf("(") + 1, body.lastIndexOf(")"));
            JsonObject object = (JsonObject)parser.parse(body);
            JsonArray dataList = (JsonArray)object.get("DATA_LIST");
            if (dataList.size() > 0) {
                boolean optionFlag;
                JsonObject data2 = dataList.get(0).getAsJsonObject();
                responseProduct.setShopcd(shopInfo.getSHOPCD());
                responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
                responseProduct.setShopprodno(data2.get("prdNo").getAsString());
                responseProduct.setGoods_nm(data2.get("prdNm").getAsString());
                responseProduct.setMarket_price(String.valueOf(data2.get("selPrc").getAsInt()));
                responseProduct.setGoods_price(String.valueOf(data2.get("selPrc").getAsInt()));
                responseProduct.setGoods_consumer_price(String.valueOf(data2.get("selPrc").getAsInt()));
                responseProduct.setCompayny_goods_cd(data2.get("sellerPrdCd").getAsString());
                responseProduct.setInsertdt(data2.get("selBgnDy").getAsString());
                responseProduct.setSaleenddt(data2.get("selEndDy").getAsString());
                responseProduct.setStatus(this.getStatus(data2.get("selStatCd").getAsString()));
                responseProduct.setSendstats(this.getSendStatus(data2.get("selStatCd").getAsString()));
                String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(data2.get("sellerPrdCd").getAsString()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                responseProduct.setGoods_keyword(codeDivision);
                CategoryDTO category = this.getCategory(data2, shopInfo);
                responseProduct.setClass_cd3(category.getCODE());
                responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                responseProduct.setGmcategnm(data2.get("dispCtgrPath").getAsString());
                boolean bl = optionFlag = data2.get("optYn").getAsString().equals("Y");
                if (optionFlag) {
                    List<ProductOptionDTO> options = this.getOption(responseProduct, cookies);
                    responseProduct.setOPTIONS(options);
                    String[] optionNames = options.stream().map(p -> p.getOPTPRODNM()).findFirst().orElse("").split("/");
                    if (optionNames.length == 1) {
                        responseProduct.setChar_1_nm(optionNames[0]);
                    } else if (optionNames.length == 2) {
                        responseProduct.setChar_1_nm(optionNames[0]);
                        responseProduct.setChar_2_nm(optionNames[1]);
                    }
                } else {
                    responseProduct.setChar_1_nm("\ub2e8\ud488");
                    responseProduct.setChar_1_val("");
                    responseProduct.setChar_2_nm("");
                    responseProduct.setChar_2_val("");
                }
            } else {
                responseProduct = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            responseProduct = null;
        }
        return responseProduct;
    }

    public CategoryDTO getCategory(JsonObject data2, ShoppingmallDTO shopInfo) {
        try {
            String code = data2.get("dispCtgrNo").getAsString();
            String[] names = data2.get("dispCtgrPath").getAsString().split(">");
            String lastName = names[names.length - 1].trim();
            CategoryDTO category = CategoryDAO.get().selectShoppingMallCategory(code, lastName);
            if (category == null && (category = CategoryDAO.get().selectShoppingMallCategory(code)) == null) {
                category = CategoryDAO.get().selectCategory("350119000");
            }
            return category;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<ProductOptionDTO> getOption(ProductDTO responseProduct, Map<String, String> cookies) {
        ArrayList<ProductOptionDTO> options = new ArrayList<ProductOptionDTO>();
        try {
            Connection.Response response = Jsoup.connect((String)MallCode.getElevenstProductOptionSearchURL(responseProduct.getShopprodno())).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").header("Host", "www.11st.co.kr").method(Connection.Method.GET).cookies(cookies).followRedirects(true).ignoreHttpErrors(true).followRedirects(true).execute();
            Element body = Jsoup.parseBodyFragment((String)response.body()).body();
            String optionName = body.select("#buyList > li > div > div.accordion_head.dropdown_selected > a > em").text();
            Elements optionEls = body.select("#buyList > li > div > div.accordion_body.dropdown_list > ul > li");
            int i = 0;
            while (i < optionEls.size()) {
                Element optionEl = (Element)optionEls.get(i);
                ProductOptionDTO option2 = new ProductOptionDTO();
                option2.setSKUSEQ(i + 1);
                option2.setSHOPPRODNO(responseProduct.getShopprodno());
                option2.setSHOPPRODSKU(optionEl.attr("data-stckno"));
                option2.setSHOPPRODSKU_NM(responseProduct.getGoods_nm());
                option2.setPRODCD(responseProduct.getCompayny_goods_cd());
                option2.setOPTPRODCD(responseProduct.getCompayny_goods_cd().concat("-" + String.valueOf(i + 1)));
                option2.setOPTPRODNM(optionName);
                option2.setOPTSPECDES(optionEl.attr("data-dtloptnm"));
                option2.setOPTSAFESTOCK(Integer.parseInt(responseProduct.getGoods_price()));
                option2.setOPTVERTSTOCK(Integer.parseInt(optionEl.attr("data-stckqty")));
                option2.setOPTADDAMT(Integer.parseInt(optionEl.attr("data-price")) - Integer.parseInt(responseProduct.getGoods_price()));
                option2.setINSERTDT(responseProduct.getInsertdt());
                option2.setINSERTID(YDMASessonUtil.getUserInfo().getUserId());
                option2.setSTATUS(Integer.parseInt(optionEl.attr("data-stckqty")) > 0 ? "0" : "1");
                options.add(option2);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            options = null;
        }
        return options;
    }

    private String getStatus(String saleStatusCd) {
        switch (saleStatusCd) {
            case "101": 
            case "102": 
            case "103": 
            case "110": 
            case "201": 
            case "202": 
            case "203": 
            case "209": {
                return "0";
            }
            case "104": {
                return "1";
            }
            case "105": 
            case "106": 
            case "107": 
            case "108": 
            case "109": 
            case "204": 
            case "205": 
            case "206": 
            case "207": 
            case "208": {
                return "3";
            }
        }
        return "";
    }

    private String getSendStatus(String saleStatusCd) {
        switch (saleStatusCd) {
            case "101": 
            case "102": 
            case "110": 
            case "201": 
            case "202": 
            case "203": 
            case "209": {
                return String.valueOf(9000);
            }
            case "103": {
                return String.valueOf(8000);
            }
            case "104": {
                return String.valueOf(4000);
            }
            case "105": 
            case "106": 
            case "107": 
            case "108": 
            case "109": 
            case "204": 
            case "205": 
            case "206": 
            case "207": 
            case "208": {
                return String.valueOf(3000);
            }
        }
        return "";
    }

    @Override
    public ResultProcessDTO addProcess2(ProductAddProcessDTO proDto, List<String> specificCodes, IProgressMonitor monitor, ShoppingmallDTO dto) throws Exception {
        return null;
    }
}

