/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.kakaostore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.shop.common.ChromeExtention;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.data.kakaostore.IShopOrderKakaoStoreCommand;
import com.kdjsystem.mlink.yellim.shop.data.kakaostore.KakaoException;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openqa.selenium.chrome.ChromeDriver;

public class KakaoStoreOrderExpressCommand
extends IShopOrderKakaoStoreCommand {
    ChromeExtention chrome = ChromeExtention.getInstace();
    final ChromeDriver driver = ChromeExtention.getInstace().getDriver();
    private static KakaoStoreOrderExpressCommand instance = new KakaoStoreOrderExpressCommand();

    public static KakaoStoreOrderExpressCommand getInstance() {
        return instance;
    }

    private KakaoStoreOrderExpressCommand() {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return 0;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        for (ShopOrderMstDto dto : param) {
            ObjectMapper mapper = new ObjectMapper();
            String jsonMessage = "";
            String body = "";
            try {
                if (dto.getDelivery_id().equals("DIRECT")) {
                    jsonMessage = "[{\"orderId\":" + Long.parseLong(dto.getOrder_id()) + ", \"shippingMethod\":\"DIRECT\"}]";
                } else {
                    DeliveryInvoiceRegisterRequest deliveryInvoiceRegisterRequest = new DeliveryInvoiceRegisterRequest(new DeliveryInvoiceInfo(dto.getDelivery_id(), dto.getInvoice_no()));
                    deliveryInvoiceRegisterRequest.orderId = Long.parseLong(dto.getOrder_id());
                    deliveryInvoiceRegisterRequest.shippingMethod = "SHIPPING";
                    jsonMessage = mapper.writeValueAsString(Arrays.asList(deliveryInvoiceRegisterRequest));
                }
                String requestURL = "https://kapi.kakao.com/v1/shopping/orders/deliveries/invoices";
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpPost postRequest = new HttpPost(requestURL);
                postRequest.setHeader("Host", "kapi.kakao.com");
                postRequest.setHeader("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053");
                postRequest.setHeader("Content-Type", "application/json");
                postRequest.addHeader("Target-Authorization", "KakaoAK " + param.get(0).getApikey());
                postRequest.addHeader("channel-ids", "101");
                postRequest.setEntity((HttpEntity)new StringEntity(jsonMessage));
                HttpResponse response = client.execute((HttpUriRequest)postRequest);
                if (response.getStatusLine().getStatusCode() == 200) {
                    BasicResponseHandler handler = new BasicResponseHandler();
                    body = (String)handler.handleResponse(response);
                    dto.setResult_code("1");
                    dto.setOrder_status("403");
                    continue;
                }
                YDMAStringUtil.Print("response is error : " + response.getStatusLine().getStatusCode());
                dto.setResult_code("-1");
                body = response.toString();
                KakaoException ke = (KakaoException)mapper.readValue(body, KakaoException.class);
                body = ke.getExtras().getValidation().toString().replace("{", "").replace("}", "").replace(",", "\n");
                CommonProgressDialog.get().setValue("\ubc30\uc1a1\ucc98\ub9ac \uc2e4\ud328\n" + body, 0);
            }
            catch (Exception e) {
                throw new Exception("\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4 \ubc30\uc1a1\ucc98\ub9ac \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. " + e);
            }
        }
        return param;
    }

    private static class DeliveryInvoiceInfo {
        public String deliveryCompanyCode;
        public String invoiceNumber;

        public DeliveryInvoiceInfo(String deliveryCompanyCode, String invoiceNumber) {
            this.deliveryCompanyCode = deliveryCompanyCode;
            this.invoiceNumber = invoiceNumber;
        }
    }

    private static class DeliveryInvoiceRegisterRequest {
        public DeliveryInvoiceInfo deliveryInvoiceInfo;
        public long orderId;
        public String shippingMethod;

        public DeliveryInvoiceRegisterRequest(DeliveryInvoiceInfo deliveryInvoiceInfo) {
            this.deliveryInvoiceInfo = deliveryInvoiceInfo;
        }
    }

    public static class SetParams {
        Map<String, Object> deliveryInvoiceInfo = new HashMap<String, Object>();
        long orderId;
        String shippingMethod;
    }
}

