/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.data.excel;

import com.kdjsystem.mlink.yellim.data.excel.AbstractDataManager;
import com.kdjsystem.mlink.yellim.data.excel.MyExcelManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class MyExcelManagerImple
extends AbstractDataManager
implements MyExcelManager {
    private Workbook wkbook;

    @Override
    public Workbook getWkbook() {
        return this.wkbook;
    }

    public MyExcelManagerImple(String fileURI) throws FileNotFoundException {
        super(fileURI);
    }

    private void createWorkbook() {
        this.wkbook = new HSSFWorkbook();
    }

    @Override
    public List<List<String>> getSheetUploadContents(int sheetNumber, int startRowNumber) {
        Sheet sheet = this.wkbook.getSheetAt(sheetNumber);
        ArrayList<List<String>> sheetContents = new ArrayList<List<String>>();
        if (sheet == null) {
            return null;
        }
        for (Row row : sheet) {
            if (row.getRowNum() < startRowNumber) continue;
            ArrayList<String> rowContent = new ArrayList<String>();
            int cellNumber = 0;
            while (cellNumber < row.getLastCellNum()) {
                String cellValue = "";
                Cell cell = row.getCell(cellNumber, Row.CREATE_NULL_AS_BLANK);
                switch (cell.getCellType()) {
                    case 4: {
                        cellValue = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case 2: {
                        cellValue = cell.getCellFormula();
                        break;
                    }
                    case 1: {
                        cellValue = cell.getRichStringCellValue().getString();
                        break;
                    }
                    case 0: {
                        BigDecimal val = new BigDecimal(cell.getNumericCellValue());
                        cellValue = String.valueOf(val);
                    }
                }
                rowContent.add(cellValue);
                ++cellNumber;
            }
            sheetContents.add(rowContent);
        }
        return sheetContents;
    }

    private List<String> getHeader(Sheet sheet, int headerIndex) {
        ArrayList<String> headers = new ArrayList<String>();
        Row row = sheet.getRow(headerIndex);
        try {
            int cellNumber = 0;
            while (cellNumber < row.getLastCellNum()) {
                Cell cell = row.getCell(cellNumber, Row.CREATE_NULL_AS_BLANK);
                String cellValue = "";
                switch (cell.getCellType()) {
                    case 4: {
                        cellValue = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case 2: {
                        cellValue = cell.getCellFormula();
                        break;
                    }
                    case 1: {
                        cellValue = cell.getRichStringCellValue().getString();
                        break;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                            cellValue = sFormat.format(cell.getDateCellValue());
                            break;
                        }
                        cell.setCellType(1);
                        cellValue = cell.getRichStringCellValue().toString();
                    }
                }
                headers.add(cellValue);
                ++cellNumber;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return headers;
    }

    @Override
    public Map<Integer, HashMap<String, String>> getSheetMapContents(int sheetNumber, int headerRowNumber) {
        Sheet sheet = this.wkbook.getSheetAt(sheetNumber);
        HashMap<Integer, HashMap<String, String>> sheetContents = new HashMap<Integer, HashMap<String, String>>();
        if (sheet == null) {
            return null;
        }
        List<String> headers = this.getHeader(sheet, headerRowNumber);
        Integer cnt = 0;
        for (Row row : sheet) {
            if (row.getRowNum() <= headerRowNumber) continue;
            HashMap<String, String> rowContent = new HashMap<String, String>();
            int cellNumber = 0;
            while (cellNumber < row.getLastCellNum()) {
                Cell cell = row.getCell(cellNumber, Row.CREATE_NULL_AS_BLANK);
                String cellValue = "";
                switch (cell.getCellType()) {
                    case 4: {
                        cellValue = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case 2: {
                        cellValue = cell.getCellFormula();
                        break;
                    }
                    case 1: {
                        cellValue = cell.getRichStringCellValue().getString();
                        break;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                            cellValue = sFormat.format(cell.getDateCellValue());
                            break;
                        }
                        cell.setCellType(1);
                        cellValue = cell.getRichStringCellValue().toString();
                    }
                }
                rowContent.put(headers.get(cellNumber), cellValue);
                ++cellNumber;
            }
            sheetContents.put(cnt, rowContent);
            cnt = cnt + 1;
        }
        return sheetContents;
    }

    @Override
    public List<List<String>> getSheetContents(int sheetNumber, int startRowNumber) {
        Sheet sheet = this.wkbook.getSheetAt(sheetNumber);
        ArrayList<List<String>> sheetContents = new ArrayList<List<String>>();
        if (sheet == null) {
            return null;
        }
        for (Row row : sheet) {
            if (row.getRowNum() < startRowNumber) continue;
            ArrayList<String> rowContent = new ArrayList<String>();
            int cellNumber = 0;
            while (cellNumber < row.getLastCellNum()) {
                String cellValue = "";
                Cell cell = row.getCell(cellNumber, Row.CREATE_NULL_AS_BLANK);
                switch (cell.getCellType()) {
                    case 4: {
                        cellValue = String.valueOf(cell.getBooleanCellValue());
                        break;
                    }
                    case 2: {
                        cellValue = cell.getCellFormula();
                        break;
                    }
                    case 1: {
                        cellValue = cell.getRichStringCellValue().getString();
                        break;
                    }
                    case 0: {
                        try {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                                cellValue = sFormat.format(cell.getDateCellValue());
                                break;
                            }
                            cell.setCellType(1);
                            cellValue = cell.getRichStringCellValue().toString();
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                rowContent.add(cellValue);
                ++cellNumber;
            }
            sheetContents.add(rowContent);
        }
        return sheetContents;
    }

    @Override
    public void loadData() throws FileNotFoundException {
        String fileName = this.uriStr;
        FileInputStream inStream = new FileInputStream(fileName);
        try {
            this.wkbook = WorkbookFactory.create((InputStream)inStream);
        }
        catch (IOException e) {
            this.wkbook = null;
            e.printStackTrace();
        }
        catch (Exception e) {
            this.wkbook = null;
            e.printStackTrace();
        }
    }

    @Override
    public void saveData() throws IOException {
        FileOutputStream fileOut = new FileOutputStream(this.uriStr);
        this.wkbook.write((OutputStream)fileOut);
        fileOut.close();
    }

    @Override
    public List<String> getHeaderRowContents() {
        return null;
    }

    @Override
    public void setHeaderRowContents(Sheet sheet, List<String> headerRowContents) {
    }

    @Override
    public int setSheetContents(int sheetNo, int startRowNo, List<List<String>> sheetContent) {
        Sheet sheet = null;
        if (this.wkbook == null) {
            this.createWorkbook();
        }
        try {
            sheet = this.wkbook.getSheetAt(sheetNo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            sheet = this.wkbook.createSheet("sheet-1");
        }
        int rowNo = startRowNo;
        for (List<String> rowContents : sheetContent) {
            Row row = sheet.createRow((int)((short)startRowNo));
            int cellNumber = 0;
            for (String cellValue : rowContents) {
                Cell cell = row.createCell(cellNumber);
                cell.setCellValue(cellValue);
                cellNumber = (short)(cellNumber + 1);
            }
            ++rowNo;
        }
        return rowNo;
    }

    @Override
    public void setSheetContentsWithHeaderRowContents(String sheetName, List<List<String>> voSheetContents) {
    }

    @Override
    public List<List<String>> getSheetContents(String sheetName, int startRowNo) {
        return null;
    }

    @Override
    public int setSheetContents(String sheetName, int startRowNo, List<List<String>> sheetContent) {
        return 0;
    }

    @Override
    public int setSheetContentsWithHeaderRowContents(int sheetNo, List<List<String>> sheetContent) {
        return 0;
    }

    @Override
    public int setSheetContents(TableViewer viewer) {
        Sheet sheet;
        if (this.wkbook == null) {
            this.createWorkbook();
        }
        try {
            sheet = this.wkbook.createSheet("sheet-1");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            sheet = this.wkbook.getSheet("sheet-1");
        }
        TableItem[] items = viewer.getTable().getItems();
        int col = viewer.getTable().getColumnCount();
        ArrayList<String> columnHeaderNames = new ArrayList<String>();
        int i = 1;
        while (i < col) {
            String columnHeaderName = viewer.getTable().getColumn(i).getText();
            columnHeaderNames.add(columnHeaderName);
            ++i;
        }
        this.setHeaderRowContents(sheet, columnHeaderNames);
        i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Row row = sheet.createRow((int)((short)i));
            int j = 1;
            while (j < col) {
                String b = item.getText(j);
                Cell cell = row.createCell((int)((short)j));
                cell.setCellValue(b);
                ++j;
            }
            ++i;
        }
        return items.length + 1;
    }

    private Cell createCell(String cellContent) {
        return null;
    }
}

