/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.dao;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.CodeItem;
import com.kdjsystem.mlink.yellim.common.TimeUtils;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.data.dao.LocationOriginDto;
import com.kdjsystem.mlink.yellim.data.dao.NoticeInfoDto;
import com.kdjsystem.mlink.yellim.data.dao.ProductDtlDescDto;
import com.kdjsystem.mlink.yellim.data.dao.ShopAddProdInDto;
import com.kdjsystem.mlink.yellim.data.dao.ShopAddProdInfoDto;
import com.kdjsystem.mlink.yellim.data.dao.ShopOptProdInfoDto;
import com.kdjsystem.mlink.yellim.data.dao.ShopProdInDto;
import com.kdjsystem.mlink.yellim.data.dao.ShopProdInfoDto;
import com.kdjsystem.mlink.yellim.dto.PreferencesMallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.shop.common.QueryStringUtils;
import com.kdjsystem.mlink.yellim.shop.dao.ProdReceiveSetDto;
import com.kdjsystem.mlink.yellim.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopAddrMstDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCafe24AdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCatInfDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCateDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCateInfoDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCoupangAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopGmarketAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopInterParkAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopKakaoStoreAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopMelchiAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductAuctionAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductCafe24AdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductCoupangAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductInterParkAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductNaverStoreAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductShortDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopSSGAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopTmonAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopWeMarketAdditionDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.yellim.shop.dao.shop11stAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.dao.shopAuctionAdditionDto;
import com.kdjsystem.mlink.yellim.shop.data.godomall.ShopGodomallAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.data.lotteon.ShopLotteOnAdditionalDto;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinMarginDto;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinOption;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinSessonUtil;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinShopDao;
import com.kdjsystem.mlink.yellim.shop.domesin.MapperShopCateDto;
import com.kdjsystem.mlink.yellim.shop.mlink.MLinkShopDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class ShopProductDao {
    private static ShopProductDao daoInstance = new ShopProductDao();
    Map<String, String> mapAddrList = new HashMap<String, String>();
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private ShopProductDao() {
        this.mapAddrList.put("shop0003", "shopaddr11stdtl");
        this.mapAddrList.put("shop0004", "shopaddrinterparkdtl");
        this.mapAddrList.put("shop0075", "shopaddrcoupangdtl");
        this.mapAddrList.put("shop0110", "shopaddrcafe24dtl");
        this.mapAddrList.put("shop0055", "shopaddrnaverstoredtl");
        this.mapAddrList.put("shop0067", "shopaddrauctiondtl");
        this.mapAddrList.put("shop0068", "shopaddrauctiondtl");
    }

    public static ShopProductDao get() {
        return daoInstance;
    }

    public List<ShopProdAttrnmDto> getProductNoticeAll() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ShopProdAttrnmDto> contents = new ArrayList<ShopProdAttrnmDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(ATTRCD, '') AS ATTRCD, \r\nIFNULL( COLSEQ, '') AS COLSEQ, \r\nIFNULL(ATTRNM, '') AS ATTRNM, \r\nIFNULL(FUNNSEQ, '') AS FUNNSEQ, \r\nIFNULL(WTRADINGSEQ, '') AS WTRADINGSEQ, \r\nIFNULL(TOBIZONSEQ, '') AS TOBIZONSEQ, \r\nIFNULL(DOMEGGOOKSEQ, '') AS DOMEGGOOKSEQ, \r\nIFNULL(OWNERCLANSEQ, '') AS OWNERCLANSEQ, \r\nIFNULL(HUBSELLSEQ, '') AS HUBSELLSEQ, \r\nIFNULL(DOSINSEQ, '') AS DOSINSEQ, \r\nIFNULL(NOTICETYPE, '') AS NOTICETYPE, \r\nIFNULL(ITEMCODE, '') AS ITEMCODE, \r\nIFNULL(INTERCODE, '') AS INTERCODE, \r\nIFNULL(INTERAPICODE, '') AS INTERAPICODE, \r\nIFNULL(INTERAPITYPE, '') AS INTERAPITYPE\r\n FROM prodattrnm";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getProductNoticeAll]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopProdAttrnmDto dto = new ShopProdAttrnmDto();
                    dto.setAttrcd(rs.getString("ATTRCD"));
                    dto.setFunnSeq(rs.getString("FUNNSEQ"));
                    dto.setWtradingSeq(rs.getString("WTRADINGSEQ"));
                    dto.setTobizonSeq(rs.getString("TOBIZONSEQ"));
                    dto.setDomeggookSeq(rs.getString("DOMEGGOOKSEQ"));
                    dto.setOwnerclanSeq(rs.getString("OWNERCLANSEQ"));
                    dto.setHubSellSeq(rs.getString("HUBSELLSEQ"));
                    dto.setDosinseq(rs.getString("DOSINSEQ"));
                    dto.setColseq(rs.getString("COLSEQ"));
                    dto.setAttrnm(rs.getString("ATTRNM"));
                    dto.setNoticetype(rs.getString("NOTICETYPE"));
                    dto.setItemcode(rs.getString("ITEMCODE"));
                    dto.setIntercode(rs.getString("INTERCODE"));
                    dto.setInterapicode(rs.getString("INTERAPICODE"));
                    dto.setInterapitype(rs.getString("INTERAPITYPE"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ProductDTO> getShopProductList(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo, int block, int page) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("WITH CTE_PRODLIST AS( \r\n");
                sql.append("  SELECT \r\n");
                sql.append("  IFNULL(PRODSEQ,'') AS PRODSEQ, \r\n");
                sql.append("  IFNULL(COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD, \r\n");
                sql.append("  IFNULL(COMPNO,'') AS COMPNO\r\n");
                sql.append("  FROM SHOPPRODINFO USE INDEX (INSERTDT_DESC) \r\n");
                sql.append(" WHERE COMPNO = ? AND INSERTDT <> '' ");
                if (!dome.equals("")) {
                    sql.append("     AND GOODS_KEYWORD = ? ");
                }
                if (folder.equals("")) {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%"));
                } else {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder));
                }
                if (!categ.equals("")) {
                    sql.append(String.valueOf(String.format(" AND CLASS_CD3 like '%s", categ)) + "%'");
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append(" AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                    sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                int block_data = block * (page - 1);
                sql.append(String.format(" ORDER BY INSERTDT DESC LIMIT %s,%s  )", block_data, block));
                sql.append(" SELECT INFO.*  , \r\n");
                if (YDMASessonUtil.getLoginType() == 0) {
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGLARGE WHERE compno = %s AND CODE = INFO.CLASS_CD1), '')  CLASS_NM1, \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGMIDIUM WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2)), '')  CLASS_NM2,  \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGSMALL WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2,INFO.CLASS_CD3)), '')  CLASS_NM3,  \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGDETAIL WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2,INFO.CLASS_CD3,INFO.CLASS_CD4)), '') as CLASS_NM4, \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                }
                sql.append(" (CASE                            \r\n");
                sql.append("     WHEN STATUS = '0'       \r\n");
                sql.append("     THEN '\uacf5\uae09\uc911'           \r\n");
                sql.append("     WHEN STATUS = '1'       \r\n");
                sql.append("     THEN '\ud488\uc808'           \r\n");
                sql.append("     WHEN STATUS = '2'       \r\n");
                sql.append("     THEN '\ub2e8\uc885'         \r\n");
                sql.append("     WHEN STATUS = '3'       \r\n");
                sql.append("     THEN '\uc0ad\uc81c'         \r\n");
                sql.append("  END )AS STATUS_NM, \r\n");
                sql.append("  (CASE                             \r\n");
                sql.append("     WHEN DELV_TYPE = '1'     \r\n");
                sql.append("     THEN '\ubb34\ub8cc'              \r\n");
                sql.append("     WHEN DELV_TYPE = '2'     \r\n");
                sql.append("     THEN '\ucc29\ubd88'              \r\n");
                sql.append("     WHEN DELV_TYPE = '3'     \r\n");
                sql.append("     THEN '\uc120\uacb0\uc81c'            \r\n");
                sql.append("     WHEN DELV_TYPE = '4'     \r\n");
                sql.append("     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n");
                sql.append("     ELSE ''                  \r\n");
                sql.append("  END )AS DELV_TYPE_NM  \r\n");
                sql.append("  FROM \r\n");
                sql.append(" (\r\n");
                sql.append("    SELECT  \r\n");
                sql.append("     IFNULL(A.PRODSEQ,'') AS PRODSEQ ,\r\n");
                sql.append(" IFNULL(A.COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD ,\r\n");
                sql.append("      IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n");
                sql.append("   CONCAT(IFNULL(CLASS_CD1,''), IFNULL(CLASS_CD2,''), IFNULL(CLASS_CD3,''), IFNULL(CLASS_CD4,'')) AS CODE,\r\n");
                sql.append("\r\n");
                sql.append("      '0' AS SHOPCD,\r\n");
                sql.append("      '' AS SHOP_USERID,\r\n");
                sql.append("      '' as img,\r\n");
                sql.append(" IFNULL(GOODS_KEYWORD,'') AS GOODS_KEYWORD,\r\n");
                sql.append("     IFNULL(GOODS_NM,'' ) AS GOODS_NM,\r\n");
                sql.append("     IFNULL(MODEL_NM,'' ) AS MODEL_NM  ,\r\n");
                sql.append(" IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n");
                sql.append(" IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n");
                sql.append(" IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n");
                sql.append(" IFNULL(SHOP_CID_INFO,'' ) AS SHOP_CID_INFO,  \r\n");
                sql.append(" IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n");
                sql.append(" IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n");
                sql.append(" IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n");
                sql.append(" IFNULL(CLASS_CD4,'' ) AS CLASS_CD4,\r\n");
                sql.append(" IFNULL(PARTNER_ID,'' ) AS PARTNER_ID,  \r\n");
                sql.append(" IFNULL(DPARTNER_ID,'' ) AS DPARTNER_ID,  \r\n");
                sql.append(" IFNULL(MAKER,'' ) AS MAKER,  \r\n");
                sql.append(" IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n");
                sql.append(" IFNULL(MAKE_DM,'' ) AS MAKE_DM,  \r\n");
                sql.append(" IFNULL(SEX,'' ) AS SEX,  \r\n");
                sql.append(" IFNULL(STATUS,'' ) AS STATUS,  \r\n");
                sql.append(" IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n");
                sql.append(" IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n");
                sql.append(" IFNULL(CERT,'' ) AS CERT,  \r\n");
                sql.append("IFNULL(ISLIMIT,'' ) AS ISLIMIT,  \r\n");
                sql.append("IFNULL(LIMIT_PRICE,'' ) AS LIMIT_PRICE,  \r\n");
                sql.append("IFNULL(IS_OVERSEAS,'' ) AS IS_OVERSEAS,  \r\n");
                sql.append("IFNULL(ITYPE,'' ) AS ITYPE,              \r\n");
                sql.append("IFNULL(ADULT,'' ) AS ADULT,               \r\n");
                sql.append("IFNULL(ISRETURN,'' ) AS ISRETURN,         \r\n");
                sql.append("IFNULL(TEXT_OPTION,'' ) AS TEXT_OPTION,   \r\n");
                sql.append("IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n");
                sql.append(" IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n");
                sql.append(" IFNULL(RETURN_DELV_COST,'0' ) AS RETURN_DELV_COST,  \r\n");
                sql.append(" IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n");
                sql.append(" IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n");
                sql.append(" IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n");
                sql.append(" IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n");
                sql.append(" IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n");
                sql.append(" IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n");
                sql.append(" IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n");
                sql.append(" IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n");
                sql.append(" IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n");
                sql.append(" IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n");
                sql.append(" IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n");
                sql.append(" IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n");
                sql.append(" IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n");
                sql.append(" IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n");
                sql.append(" IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n");
                sql.append(" IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n");
                sql.append(" IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n");
                sql.append(" IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n");
                sql.append(" IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n");
                sql.append(" IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n");
                sql.append(" IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n");
                sql.append(" IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,   \r\n");
                sql.append(" IFNULL(CERTNO,'' ) AS CERTNO,  \r\n");
                sql.append(" IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n");
                sql.append(" IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n");
                sql.append(" IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n");
                sql.append(" IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n");
                sql.append(" IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n");
                sql.append(" IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n");
                sql.append(" IFNULL(CERTMODEL,'' ) AS CERTMODEL,  \r\n");
                sql.append(" IFNULL(CERTNAME,'' ) AS CERTNAME,  \r\n");
                sql.append(" IFNULL(EXEMPTIONTYPE,'' ) AS EXEMPTIONTYPE,  \r\n");
                sql.append(" IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n");
                sql.append(" IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n");
                sql.append(" IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n");
                sql.append(" IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n");
                sql.append(" IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n");
                sql.append(" IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n");
                sql.append(" IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n");
                sql.append(" IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n");
                sql.append(" IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n");
                sql.append(" IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n");
                sql.append(" IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n");
                sql.append(" IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n");
                sql.append(" IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n");
                sql.append(" IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n");
                sql.append(" IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n");
                sql.append(" IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n");
                sql.append(" IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n");
                sql.append(" IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n");
                sql.append(" IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n");
                sql.append(" IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n");
                sql.append(" IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n");
                sql.append(" IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n");
                sql.append(" IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n");
                sql.append(" IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n");
                sql.append(" IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n");
                sql.append(" IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n");
                sql.append(" IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n");
                sql.append(" IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n");
                sql.append(" IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n");
                sql.append(" IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n");
                sql.append(" IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n");
                sql.append(" IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n");
                sql.append(" IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n");
                sql.append(" IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n");
                sql.append(" IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n");
                sql.append(" IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n");
                sql.append(" IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n");
                sql.append(" IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n");
                sql.append(" IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n");
                sql.append(" IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n");
                sql.append(" IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n");
                sql.append(" IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n");
                sql.append(" IFNULL(INSERTID,'' ) AS INSERTID,  \r\n");
                sql.append(" IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n");
                sql.append(" IFNULL(MODIFYID, '' ) AS MODIFYID,  \r\n");
                sql.append(" '' AS SEQ,  \r\n");
                sql.append(" IFNULL(ShopSendStatus, '' ) AS ShopSendStatus, \r\n");
                sql.append("'' AS SHOPSEQ, \r\n");
                sql.append("'' AS SALEENDDT, \r\n");
                sql.append(" IFNULL(DELV_QTY, '' ) AS DELV_QTY,  \r\n");
                sql.append(" IFNULL(GMCATEGNM, '' ) AS GMCATEGNM, \r\n");
                sql.append(" IFNULL(SHOPMODIFYCONTENT, '') AS SHOPMODIFYCONTENT, \r\n");
                sql.append(" IFNULL(SELFMOD_NO, '' ) AS SELFMOD_NO, \r\n");
                sql.append("'' AS Sendseq \r\n");
                sql.append("\r\n");
                sql.append(" FROM    SHOPPRODINFO AS A INNER JOIN \r\n");
                sql.append("(SELECT * FROM CTE_PRODLIST) AS B\r\n");
                sql.append("    ON A.PRODSEQ = B.PRODSEQ AND A.COMPNO = B.COMPNO\r\n");
                sql.append("    UNION ALL\r\n");
                sql.append("    SELECT \r\n");
                sql.append("      IFNULL(A.PRODSEQ,'') AS PRODSEQ ,\r\n");
                sql.append("     IFNULL(A.COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD ,\r\n");
                sql.append("      IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n");
                sql.append("   CONCAT(IFNULL(CLASS_CD1,''), IFNULL(CLASS_CD2,''), IFNULL(CLASS_CD3,''), IFNULL(CLASS_CD4,'')) AS CODE,\r\n");
                sql.append("      IFNULL(SHOPCD,'' ) AS SHOPCD,\r\n");
                sql.append("      IFNULL(SHOP_USERID,'' ) AS SHOP_USERID,\r\n");
                sql.append("      '' as img,\r\n");
                sql.append(" IFNULL(GOODS_KEYWORD,'') AS GOODS_KEYWORD,\r\n");
                sql.append("       IFNULL(GOODS_NM,'' ) AS GOODS_NM,\r\n");
                sql.append("     IFNULL(MODEL_NM,'' ) AS MODEL_NM  ,\r\n");
                sql.append(" IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n");
                sql.append(" IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n");
                sql.append(" IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n");
                sql.append(" IFNULL(SHOP_CID_INFO,'' ) AS SHOP_CID_INFO,  \r\n");
                sql.append(" IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n");
                sql.append(" IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n");
                sql.append(" IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n");
                sql.append(" IFNULL(CLASS_CD4,'' ) AS CLASS_CD4 ,\r\n");
                sql.append(" IFNULL(PARTNER_ID,'' ) AS PARTNER_ID,  \r\n");
                sql.append(" IFNULL(DPARTNER_ID,'' ) AS DPARTNER_ID,  \r\n");
                sql.append("  IFNULL(MAKER,'' ) AS MAKER,  \r\n");
                sql.append(" IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n");
                sql.append(" IFNULL(MAKE_DM,'' ) AS MAKE_DM,  \r\n");
                sql.append(" IFNULL(SEX,'' ) AS SEX,  \r\n");
                sql.append("   IFNULL(STATUS, '') AS STATUS,\r\n");
                sql.append(" IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n");
                sql.append(" IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n");
                sql.append(" IFNULL(CERT,'' ) AS CERT,  \r\n");
                sql.append("IFNULL(ISLIMIT,'' ) AS ISLIMIT,  \r\n");
                sql.append("IFNULL(LIMIT_PRICE,'' ) AS LIMIT_PRICE,  \r\n");
                sql.append("IFNULL(IS_OVERSEAS,'' ) AS IS_OVERSEAS,  \r\n");
                sql.append("IFNULL(ITYPE,'' ) AS ITYPE,              \r\n");
                sql.append("IFNULL(ADULT,'' ) AS ADULT,               \r\n");
                sql.append("IFNULL(ISRETURN,'' ) AS ISRETURN,         \r\n");
                sql.append("IFNULL(TEXT_OPTION,'' ) AS TEXT_OPTION,   \r\n");
                sql.append("IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n");
                sql.append(" IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n");
                sql.append(" IFNULL(RETURN_DELV_COST,'0' ) AS RETURN_DELV_COST,  \r\n");
                sql.append(" IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n");
                sql.append(" IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n");
                sql.append(" IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n");
                sql.append(" IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n");
                sql.append(" IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n");
                sql.append(" IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n");
                sql.append(" IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n");
                sql.append(" IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n");
                sql.append(" IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n");
                sql.append(" IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n");
                sql.append(" IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n");
                sql.append(" IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n");
                sql.append(" IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n");
                sql.append(" IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n");
                sql.append(" IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n");
                sql.append(" IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n");
                sql.append(" IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n");
                sql.append(" IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n");
                sql.append(" IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n");
                sql.append(" IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n");
                sql.append(" IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n");
                sql.append(" IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,   \r\n");
                sql.append(" IFNULL(CERTNO,'' ) AS CERTNO,  \r\n");
                sql.append(" IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n");
                sql.append(" IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n");
                sql.append(" IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n");
                sql.append(" IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n");
                sql.append(" IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n");
                sql.append(" IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n");
                sql.append(" IFNULL(CERTMODEL,'' ) AS CERTMODEL,  \r\n");
                sql.append(" IFNULL(CERTNAME,'' ) AS CERTNAME,  \r\n");
                sql.append(" IFNULL(EXEMPTIONTYPE,'' ) AS EXEMPTIONTYPE,  \r\n");
                sql.append(" IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n");
                sql.append(" IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n");
                sql.append(" IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n");
                sql.append(" IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n");
                sql.append(" IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n");
                sql.append(" IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n");
                sql.append(" IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n");
                sql.append(" IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n");
                sql.append(" IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n");
                sql.append(" IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n");
                sql.append(" IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n");
                sql.append(" IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n");
                sql.append(" IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n");
                sql.append(" IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n");
                sql.append(" IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n");
                sql.append(" IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n");
                sql.append(" IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n");
                sql.append(" IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n");
                sql.append(" IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n");
                sql.append(" IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n");
                sql.append(" IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n");
                sql.append(" IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n");
                sql.append(" IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n");
                sql.append(" IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n");
                sql.append(" IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n");
                sql.append(" IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n");
                sql.append(" IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n");
                sql.append(" IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n");
                sql.append(" IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n");
                sql.append(" IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n");
                sql.append(" IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n");
                sql.append(" IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n");
                sql.append(" IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n");
                sql.append(" IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n");
                sql.append(" IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n");
                sql.append(" IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n");
                sql.append(" IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n");
                sql.append(" IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n");
                sql.append(" IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n");
                sql.append(" IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n");
                sql.append(" IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n");
                sql.append(" IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n");
                sql.append(" IFNULL(INSERTID,'' ) AS INSERTID,  \r\n");
                sql.append(" IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n");
                sql.append(" IFNULL(MODIFYID, '' ) AS MODIFYID,  \r\n");
                sql.append(" IFNULL(SEQ, '' ) AS SEQ,  \r\n");
                sql.append(" IFNULL(ShopSendStatus, '' ) AS ShopSendStatus, \r\n");
                sql.append("IFNULL(SHOPSEQ, '' ) AS SHOPSEQ, \r\n");
                sql.append("IFNULL(SALEENDDT, '' ) AS SALEENDDT, \r\n");
                sql.append(" IFNULL(DELV_QTY, '' ) AS DELV_QTY,  \r\n");
                sql.append(" IFNULL(GMCATEGNM, '' ) AS GMCATEGNM, \r\n");
                sql.append("IFNULL(SHOPMODIFYCONTENT,'') AS SHOPMODIFYCONTENT, \r\n");
                sql.append("IFNULL(SELFMOD_NO,'' ) AS SELFMOD_NO, \r\n");
                sql.append("IFNULL(Sendseq,'' ) AS Sendseq \r\n");
                sql.append(" FROM SHOPPRODIN AS A INNER JOIN \r\n");
                sql.append("(SELECT * FROM CTE_PRODLIST) AS B\r\n");
                sql.append("    ON A.COMPNO = B.COMPNO AND A.PRODSEQ = B.PRODSEQ \r\n");
                sql.append(" ) AS INFO  ORDER BY INSERTDT desc\r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(3, prodFrom);
                        pstmt.setString(4, prodTo);
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                    }
                } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                }
                YDMAStringUtil.Print("[getShopProductList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = block * (page - 1);
                YDMAStringUtil.Print("block:" + String.valueOf(block) + "page:" + String.valueOf(page - 1) + "rowno:" + rowno);
                List<ShopProdAttrnmDto> shopProdAttrnmAll = this.getProductNoticeAll();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    if (rs.getString("SHOPCD").equals("0")) {
                        dto.setRowno("" + ++rowno);
                    }
                    dto.setCode(rs.getString("CODE"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setSHOP_USERID(rs.getString("SHOP_USERID"));
                    dto.setSENDSEQ(rs.getString("SENDSEQ"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setImg(rs.getString("Img"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setShop_cid_info(rs.getString("SHOP_CID_INFO"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year("");
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season("");
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelv_r_cost(rs.getString("RETURN_DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCertmodel(rs.getString("CERTMODEL"));
                    dto.setCertname(rs.getString("CERTNAME"));
                    dto.setExemptiontype(rs.getString("EXEMPTIONTYPE"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(YDMAStringUtil.leftPad(rs.getString("PROP1_CD"), 3, "0"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en("");
                    dto.setGoods_nm_pr("");
                    dto.setGoods_remarks2("");
                    dto.setGoods_remarks3("");
                    dto.setGoods_remarks4("");
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setCert(rs.getString("CERT"));
                    dto.setIslimit(rs.getString("ISLIMIT"));
                    dto.setLimit_price(rs.getString("LIMIT_PRICE"));
                    dto.setIs_overseas(rs.getString("IS_OVERSEAS"));
                    dto.setItype(rs.getString("ITYPE"));
                    dto.setAdult(rs.getString("ADULT"));
                    dto.setIsreturn(rs.getString("ISRETURN"));
                    dto.setText_option(rs.getString("TEXT_OPTION"));
                    if (YDMASessonUtil.getLoginType() == 0) {
                        dto.setClass_nm1(rs.getString("CLASS_NM1"));
                        dto.setClass_nm2(rs.getString("CLASS_NM2"));
                        dto.setClass_nm3(rs.getString("CLASS_NM3"));
                        dto.setClass_nm4(rs.getString("CLASS_NM4"));
                    }
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setGoods_gubun_nm("");
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                    dto.setSaleenddt(rs.getString("SALEENDDT"));
                    dto.setSendstats(rs.getString("SHOPSENDSTATUS"));
                    dto.setGmcategnm(rs.getString("GMCATEGNM"));
                    dto.setShopmodifycontent(rs.getString("SHOPMODIFYCONTENT"));
                    dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                    dto.setDelivery_qty(rs.getString("DELV_QTY"));
                    if (YDMASessonUtil.getLoginType() == 2) {
                        String class_cd4 = rs.getString("CLASS_CD4");
                        String class_cd3 = rs.getString("CLASS_CD3");
                        String shop_cid = !class_cd4.isEmpty() ? class_cd4 : class_cd3;
                        String full_cateName = MLinkShopDao.getNewCategoryFullCateName(shop_cid);
                        if (full_cateName.equals("")) {
                            String shopcd = rs.getString("GOODS_KEYWORD");
                            full_cateName = MLinkShopDao.getFullCateName(shopcd, shop_cid);
                        }
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    } else {
                        List<String> ret = Arrays.asList(dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4());
                        String shop_cid = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining());
                        ret = Arrays.asList(dto.getClass_nm1(), dto.getClass_nm2(), dto.getClass_nm3(), dto.getClass_nm4());
                        String full_cateName = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining(">"));
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    }
                    dto.setShopProdAttrnmDtos(shopProdAttrnmAll);
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopProductShortDto> getShopProdShortList(String dome, String searchgubun, String searchtxt, String prodFrom, String prodTo, String shopCd) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ShopProductShortDto> list = new ArrayList<ShopProductShortDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT * FROM ( \r\n");
                sql.append(" WITH CTE_PRODLIST AS( \r\n");
                sql.append("  SELECT IFNULL(SENDSEQ,'') AS SENDSEQ \r\n");
                sql.append("    FROM SHOPPRODIN USE INDEX(INSERTDT_DESC) \r\n");
                sql.append("   WHERE COMPNO = ?  AND INSERTDT<>''   \r\n");
                if (!dome.equals("")) {
                    sql.append("  AND GOODS_KEYWORD = ? ");
                }
                sql.append(" AND SHOPCD = ? ");
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append(" AND ((INSERTDT >= ? AND INSERTDT <= ?) ");
                    sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? )) ");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                sql.append(" ORDER BY INSERTDT DESC ) ");
                sql.append(" SELECT INFO.*  \r\n");
                sql.append("  FROM \r\n");
                sql.append(" (\r\n");
                sql.append("SELECT \r\n");
                sql.append("  IFNULL(A.COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD ,\r\n");
                sql.append("  IFNULL(SHOPCD,'' ) AS SHOPCD,\r\n");
                sql.append("  IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,\r\n");
                sql.append("  IFNULL(SHOPSEQ, '' ) AS SHOPSEQ, \r\n");
                sql.append("  IFNULL(A.SENDSEQ,'' ) AS SENDSEQ, \r\n");
                sql.append("  IFNULL(A.SHOPSENDSTATUS,'' ) AS SHOPSENDSTATUS \r\n");
                sql.append(" FROM SHOPPRODIN AS A INNER JOIN (SELECT SENDSEQ FROM CTE_PRODLIST) AS B ON A.SENDSEQ = B.SENDSEQ \r\n");
                sql.append("   ) AS INFO ) AA  ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    pstmt.setString(3, shopCd);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(4, prodFrom);
                        pstmt.setString(5, prodTo);
                        pstmt.setString(6, prodFrom);
                        pstmt.setString(7, prodTo);
                    }
                } else {
                    pstmt.setString(2, shopCd);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(3, prodFrom);
                        pstmt.setString(4, prodTo);
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                    }
                }
                YDMAStringUtil.Print("[getShopProductList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopProductShortDto dto = new ShopProductShortDto();
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setSendseq(rs.getString("SENDSEQ"));
                    dto.setShopsendstatus(rs.getString("SHOPSENDSTATUS"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void setNotice(ProductDTO dto, List<ShopProdAttrnmDto> shopProdAttrnmAll) {
        List shopProdAttrnmList = shopProdAttrnmAll.stream().filter(p -> p.getAttrcd().equals(dto.getProp1_cd())).collect(Collectors.toList());
        ArrayList<ShopProdAttrnmDto> retList = new ArrayList<ShopProdAttrnmDto>();
        for (ShopProdAttrnmDto prodAttrnmDto : shopProdAttrnmList) {
            List<String> seqList = null;
            seqList = YDMASessonUtil.getLoginType() == 2 ? (dto.getGoods_keyword().equals("shop5001") ? Arrays.asList(prodAttrnmDto.getHubSellSeq().split(",")) : (dto.getGoods_keyword().equals("shop0283") ? Arrays.asList(prodAttrnmDto.getDosinseq().split(",")) : (dto.getGoods_keyword().equals("shop0120") ? Arrays.asList(prodAttrnmDto.getOwnerclanSeq().split(",")) : (dto.getGoods_keyword().equals("shop0319") ? Arrays.asList(prodAttrnmDto.getDomeggookSeq().split(",")) : (dto.getGoods_keyword().equals("shop0316") ? Arrays.asList(prodAttrnmDto.getTobizonSeq().split(",")) : (dto.getGoods_keyword().equals("shop9992") ? Arrays.asList(prodAttrnmDto.getWtradingSeq().split(",")) : (dto.getGoods_keyword().equals("shop0286") ? Arrays.asList(prodAttrnmDto.getFunnSeq().split(",")) : Arrays.asList(prodAttrnmDto.getDosinseq().split(","))))))))) : Arrays.asList(prodAttrnmDto.getColseq().split(","));
            String propval = "";
            int i = 0;
            while (i < seqList.size()) {
                prodAttrnmDto.setColseq(seqList.get(i));
                prodAttrnmDto.setProp1_cd(dto.getProp1_cd());
                if (seqList.get(i).equals("1")) {
                    propval = String.valueOf(propval) + dto.getProp_val1();
                }
                if (seqList.get(i).equals("2")) {
                    propval = String.valueOf(propval) + dto.getProp_val2();
                }
                if (seqList.get(i).equals("3")) {
                    propval = String.valueOf(propval) + dto.getProp_val3();
                }
                if (seqList.get(i).equals("4")) {
                    propval = String.valueOf(propval) + dto.getProp_val4();
                }
                if (seqList.get(i).equals("5")) {
                    propval = String.valueOf(propval) + dto.getProp_val5();
                }
                if (seqList.get(i).equals("6")) {
                    propval = String.valueOf(propval) + dto.getProp_val6();
                }
                if (seqList.get(i).equals("7")) {
                    propval = String.valueOf(propval) + dto.getProp_val7();
                }
                if (seqList.get(i).equals("8")) {
                    propval = String.valueOf(propval) + dto.getProp_val8();
                }
                if (seqList.get(i).equals("9")) {
                    propval = String.valueOf(propval) + dto.getProp_val9();
                }
                if (seqList.get(i).equals("10")) {
                    propval = String.valueOf(propval) + dto.getProp_val10();
                }
                if (seqList.get(i).equals("11")) {
                    propval = String.valueOf(propval) + dto.getProp_val11();
                }
                if (seqList.get(i).equals("12")) {
                    propval = String.valueOf(propval) + dto.getProp_val12();
                }
                if (seqList.get(i).equals("13")) {
                    propval = String.valueOf(propval) + dto.getProp_val13();
                }
                if (seqList.get(i).equals("14")) {
                    propval = String.valueOf(propval) + dto.getProp_val14();
                }
                if (seqList.get(i).equals("15")) {
                    propval = String.valueOf(propval) + dto.getProp_val15();
                }
                if (seqList.get(i).equals("16")) {
                    propval = String.valueOf(propval) + dto.getProp_val16();
                }
                if (seqList.get(i).equals("17")) {
                    propval = String.valueOf(propval) + dto.getProp_val17();
                }
                if (seqList.get(i).equals("18")) {
                    propval = String.valueOf(propval) + dto.getProp_val18();
                }
                if (seqList.get(i).equals("19")) {
                    propval = String.valueOf(propval) + dto.getProp_val19();
                }
                if (seqList.get(i).equals("20")) {
                    propval = String.valueOf(propval) + dto.getProp_val20();
                }
                if (seqList.get(i).equals("21")) {
                    propval = String.valueOf(propval) + dto.getProp_val21();
                }
                if (seqList.get(i).equals("22")) {
                    propval = String.valueOf(propval) + dto.getProp_val22();
                }
                if (seqList.get(i).equals("23")) {
                    propval = String.valueOf(propval) + dto.getProp_val23();
                }
                if (seqList.get(i).equals("24")) {
                    propval = String.valueOf(propval) + dto.getProp_val24();
                }
                if (seqList.get(i).equals("25")) {
                    propval = String.valueOf(propval) + dto.getProp_val25();
                }
                if (seqList.get(i).equals("26")) {
                    propval = String.valueOf(propval) + dto.getProp_val26();
                }
                if (seqList.get(i).equals("27")) {
                    propval = String.valueOf(propval) + dto.getProp_val27();
                }
                if (seqList.get(i).equals("28")) {
                    propval = String.valueOf(propval) + dto.getProp_val28();
                }
                if (i < seqList.size() - 1) {
                    propval = String.valueOf(propval) + ", ";
                }
                prodAttrnmDto.setProp_val(propval);
                ++i;
            }
            retList.add(prodAttrnmDto);
        }
        dto.setShopProdAttrnmDtos(retList);
    }

    public List<ProductDTO> getShopProductDomesinList(String shopcd, int option2, String prodFrom, String prodTo, String lagcateg, String midcateg, String smlcateg, String detcateg, String purch, String logis, int supply, String orderIvtr, String shopfee, String sex, String season, String prod, String searchgubun, String searchtxt) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT                                           \r\n ");
                sql.append(" IFNULL( B.send_result,'') AS send_result,         \r\n ");
                sql.append(" YWM_FUNC_BOSSPRODCD(4,A.icode) AS IMG,  \r\n");
                sql.append(" IFNULL( A.icode, '') AS icode,                     \r\n ");
                sql.append(" IFNULL( A.iname, '') AS iname,                     \r\n ");
                sql.append(" IFNULL( A.cid, '') AS cid,                         \r\n ");
                sql.append(" IFNULL( A.shop_cid_info, '') AS shop_cid_info,     \r\n ");
                sql.append(" IFNULL( A.icountry, '') AS icountry,               \r\n ");
                sql.append(" IFNULL( A.maker, '') AS maker,                     \r\n ");
                sql.append(" IFNULL( A.brand, '') AS brand,                     \r\n ");
                sql.append(" IFNULL( A.tax, '') AS tax,                         \r\n ");
                sql.append(" IFNULL( A.vender_code, '') AS vender_code,         \r\n ");
                sql.append(" IFNULL( A.delivery_type, '') AS delivery_type,     \r\n ");
                sql.append(" IFNULL( A.delivery_amount, '') AS delivery_amount, \r\n ");
                sql.append(" IFNULL( A.delivery_qty, '') AS delivery_qty,       \r\n ");
                sql.append(" IFNULL( A.keyword,  '') AS keyword,                \r\n ");
                sql.append(" IFNULL( A.price,  '') AS price,                    \r\n ");
                sql.append(" IFNULL( A.price_consumer, '') AS price_consumer,   \r\n ");
                sql.append(" IFNULL( A.islimit, '') AS islimit,                 \r\n ");
                sql.append(" IFNULL( A.limit_price, '') AS limit_price,         \r\n ");
                sql.append(" IFNULL( A.content, '') AS content,                 \r\n ");
                sql.append(" IFNULL( A.img, '') AS imgs,                         \r\n ");
                sql.append(" IFNULL( A.select_option, '') AS select_option,     \r\n ");
                sql.append(" IFNULL( A.text_option, '') AS text_option,         \r\n ");
                sql.append(" IFNULL( A.notice, '') AS notice,                   \r\n ");
                sql.append(" IFNULL( A.itype, '') AS itype,                     \r\n ");
                sql.append(" IFNULL( A.`status`, '') AS `status`,               \r\n ");
                sql.append(" IFNULL( A.adult,'') AS adult,                      \r\n ");
                sql.append(" IFNULL(A.reg_datetime, '') AS reg_datetime,        \r\n ");
                sql.append(" IFNULL(A.up_datetime, '') AS up_datetime,          \r\n ");
                sql.append(" IFNULL(A.isreturn, '') AS isreturn,                \r\n ");
                sql.append(" IFNULL(A.cert_type,'') AS cert_type,               \r\n ");
                sql.append(" IFNULL(A.cert, '') AS cert,                        \r\n ");
                sql.append(" IFNULL(A.cert_no, '') AS cert_no,                  \r\n ");
                sql.append(" IFNULL(A.gosi_code,'') AS gosi_code,               \r\n ");
                sql.append(" IFNULL(A.gosi_info,'') AS  gosi_info              \r\n ");
                sql.append(" FROM ds_shopprodinfo  AS A LEFT JOIN             \r\n ");
                sql.append("  ds_shopprodin AS B  \r\n");
                sql.append(" ON A.icode = B.icode \r\n");
                if (option2 == 0) {
                    sql.append(" WHERE  A.reg_datetime >= ? AND A.reg_datetime <= ? \r\n");
                } else {
                    sql.append(" WHERE  A.up_datetime >= ? AND A.up_datetime <= ? \r\n");
                }
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, prodFrom);
                pstmt.setString(2, prodTo);
                YDMAStringUtil.Print("[getShopProductList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setRowno("" + ++rowno);
                    dto.setImg(rs.getString("Img"));
                    dto.setCompno("4");
                    dto.setCompayny_goods_cd(rs.getString("icode"));
                    dto.setGoods_nm(rs.getString("iname"));
                    dto.setClass_cd4(rs.getString("cid"));
                    dto.setOrigin(rs.getString("icountry"));
                    dto.setMaker(rs.getString("maker"));
                    dto.setBrand_nm(rs.getString("brand"));
                    dto.setTax_yn(rs.getString("tax"));
                    dto.setDelv_type(rs.getString("delivery_type"));
                    dto.setDelv_cost(rs.getString("delivery_amount"));
                    dto.setGoods_keyword(rs.getString("keyword"));
                    dto.setGoods_price(rs.getString("price"));
                    dto.setGoods_consumer_price(rs.getString("price_consumer"));
                    dto.setIslimit(rs.getString("islimit"));
                    dto.setLimit_price(rs.getString("limit_price"));
                    dto.setGoods_remarks(rs.getString("content"));
                    dto.setDelivery_qty(rs.getString("delivery_qty"));
                    List<String> images = Arrays.asList(rs.getString("imgs").split(","));
                    if (images.size() > 0) {
                        dto.setImg_path(images.get(0));
                        if (images.size() > 1) {
                            dto.setImg_path1(images.get(1));
                        }
                        if (images.size() > 2) {
                            dto.setImg_path2(images.get(2));
                        }
                        if (images.size() > 3) {
                            dto.setImg_path3(images.get(3));
                        }
                        if (images.size() > 4) {
                            dto.setImg_path4(images.get(4));
                        }
                    }
                    String select_option = rs.getString("select_option");
                    dto.setText_option(rs.getString("text_option"));
                    dto.setDescrition(rs.getString("notice"));
                    dto.setStatus(rs.getString("status"));
                    dto.setItype(rs.getString("itype"));
                    dto.setAdult(rs.getString("adult"));
                    dto.setIsreturn(rs.getString("isreturn"));
                    dto.setCert(rs.getString("cert"));
                    dto.setCert_type(rs.getString("cert_type"));
                    dto.setCertno(rs.getString("cert_no"));
                    dto.setProp1_cd(rs.getString("gosi_code"));
                    dto.setProp_val1(rs.getString("gosi_info"));
                    String shop_cid_info = rs.getString("shop_cid_info");
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    String strgosi = rs.getString("gosi_info");
                    Gosi gosi = (Gosi)mapper.readValue(strgosi, Gosi.class);
                    dto.setProp_val1(gosi.gosi1);
                    dto.setProp_val2(gosi.gosi2);
                    dto.setProp_val3(gosi.gosi3);
                    dto.setProp_val4(gosi.gosi4);
                    dto.setProp_val5(gosi.gosi5);
                    dto.setProp_val6(gosi.gosi6);
                    dto.setProp_val7(gosi.gosi7);
                    dto.setProp_val8(gosi.gosi8);
                    dto.setProp_val9(gosi.gosi9);
                    dto.setProp_val10(gosi.gosi10);
                    dto.setProp_val11(gosi.gosi11);
                    dto.setProp_val12(gosi.gosi12);
                    dto.setProp_val13(gosi.gosi13);
                    dto.setProp_val14(gosi.gosi14);
                    dto.setProp_val15(gosi.gosi15);
                    dto.setProp_val16(gosi.gosi16);
                    dto.setProp_val17(gosi.gosi17);
                    dto.setProp_val18(gosi.gosi18);
                    dto.setProp_val19(gosi.gosi19);
                    dto.setProp_val20(gosi.gosi20);
                    dto.setProp_val21(gosi.gosi21);
                    dto.setProp_val22(gosi.gosi22);
                    List mapperShopCateDtos = (List)mapper.readValue(shop_cid_info, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, MapperShopCateDto.class));
                    dto.setMapperShopCateDtos(mapperShopCateDtos);
                    List domesinOptions = (List)mapper.readValue(select_option, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, DomesinOption.class));
                    dto.setDomesinOptions(domesinOptions);
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<List<String>> getShopidListCheck(String shopcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select SHOPCD,SHOPPINGID,SHOPSEQ,ifnull(DEALTREAD,'') AS DEALTREAD   from shopdtl  where compno = ?    and DEALTREAD = '\uc0ac\uc6a9\uc911'    and shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[getShopidListCheck]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public ShopProductAdditionDto getAdditionaOneList(int seq, String shopcd) throws Exception {
        shop11stAdditionalDto dto = new shop11stAdditionalDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT ifnull(SEQ,'0'), ifnull( COMPNO,'0'), ifnull( TITLE,''), ifnull( ISCATEGORY,''), ifnull( LAGCATCD,''), ifnull( MIDCATCD,''), ifnull( SMLCATCD,''), ifnull( DETCATCD,''), ifnull( SHOPCATNO,''), ifnull( SHOPCATSITENM,''),  ifnull( SHOPCD,''), ifnull( SHOPSEQ,''), ifnull( SHOPUSERID,''), ifnull( SELLERDC,'0'), ifnull( DCRATE,'0'),  ifnull( CUMDC,'0'), ifnull( MARGINDC,'0'), ifnull( COMMDC,'0'), ifnull( ABRDBUYPLACE,''), ifnull( ABRDSIZETABLEDISPYN,''), ifnull( SELMNBDNCKNM,''),  ifnull( SELMTHDCD,''), ifnull( DISPCTGRNO,''), ifnull( PRDTYPCD,''), ifnull( BRAND,''), ifnull( RMATERIALTYPCD,''), ifnull( SUPLDTYFRPRDCLFCD,''),  ifnull( YEARENDTAXYN,''), ifnull( FORABRDBUYCLF,''), ifnull( IMPORTFEECD,''), ifnull( PRDSTATCD,''), ifnull( USEMON,''), ifnull( PAIDSELPRC,''),  ifnull( EXTERIORSPECIALNOTE,''), ifnull( MINORSELCNYN,''), ifnull( REVIEWDISPYN,''), ifnull( SELPRDCLFCD,''), ifnull( APLBGNDY,''), ifnull( APLENDDY,''),  ifnull( WRHSPLNDY,''), ifnull( CUPONCHECK,''), ifnull( DSCAMTPERCNT,''), ifnull( CUPNDSCMTHDCD,''), ifnull( CUPNUSELMTDYYN,''), ifnull( CUPNLSSENDDY,''),  ifnull( PAY11YN,''), ifnull( PAY11VALUE,''), ifnull( PAY11WYCD,''), ifnull( INTFREEYN,''), ifnull( INTFREEMONCLFCD,''), ifnull( PLUYN,''), ifnull( PLUDSCCD,''),  ifnull( PLUDSCBASIS,''), ifnull( PLUDSCAMTPERCNT,''), ifnull( PLUDSCMTHDCD,''), ifnull( PLULSSSTARTDY,''), ifnull( PLULSSENDDY,''), ifnull( HOPESHPYN,''),  ifnull( HOPESHPNT,''), ifnull( HOPESHPWYCD,''), ifnull( PLUUSELMTDYYN,''), ifnull( PRDEXPOSECLFCD,''), ifnull( image,''), ifnull( SELMINLIMITTYPCD,''),  ifnull( SELMINLIMITQTY,''), ifnull( SELLIMITTYPCD,''), ifnull( SELLIMITQTY,''), ifnull( TOWNSELLMTDY,''), ifnull( USEGIFTYN,''), ifnull( GIFTINFO,''), ifnull( GIFTNM,''),  ifnull( APLBGNDT,''), ifnull( APLENDDT,''), ifnull( GBLDLVYN,''), ifnull( GBLHSCODE,''), ifnull( DLVCNAREACD,''), ifnull( DLVWYCD,''), ifnull( DLVETPRSCD,''),  ifnull( DLVSENDCLOSETMPLTNO,''), ifnull( DELIVERY,''), ifnull( DLVCSTINSTBASICD,''), ifnull( DLVCST1,''), ifnull( DLVCST3,''), ifnull( DLVCST4,''),  ifnull( DLVCSTINFOCD,''), ifnull( PRDFRDLVBASIAMT,''), ifnull( DLVCNT1,''), ifnull( DLVCNT2,''), ifnull( BNDLDLVCNYN,''), ifnull( DLVCSTPAYTYPCD,''),  ifnull( JEJUDLVCST,''), ifnull( ISLANDDLVCST,''), ifnull( ADDRSEQOUT,''), ifnull( OUTSIDEYNOUT,''), ifnull( ADDSEQOUTMEMNO,''), ifnull( ADDRSEQIN,''),  ifnull( OUTSIDEYNIN,''), ifnull( ADDSEQINMEMNO,''), ifnull( ABRDCNDLVCST,''), ifnull( RTNGDDLVCST,''), ifnull( RTNGDDLVCD,''), ifnull( EXCHDLVCST,''),  ifnull( ASDETAIL,''), ifnull( RTNGEXCHDETAIL,''), ifnull( DLVCLF,''), ifnull( NTSHORTNM,''), ifnull( GLOBALOUTADDRSEQ,''), ifnull( MNFCDY,''), ifnull( MAINTITLE,''), ifnull( ARTIST,''), ifnull( MUDVDLABEL,''), ifnull( MAKER,''), ifnull( ALBUMNM,''), ifnull( DVDTITLE,''), ifnull( BCKTEXYN,''),  ifnull( PRCCMPEXPYN,''), ifnull( STFPRDYN,''), ifnull( MODEL,''), ifnull( MODELNM,''), ifnull( BRANDMETHOD,''), ifnull( PRDIMAGE10,''),\tifnull( CERTMATCHING,''), ifnull( PROLANGUAGE,''), ifnull( PICTURE,''), ifnull( ISBN13,''), ifnull( ISBN10,''), ifnull( ADDICODE,''), ifnull( PUBLICATION,''), ifnull( KIND,''), ifnull( TICKETNM,''), ifnull( PRODOUTPUT,''), ifnull( PRODNMFRONT,''), ifnull( PRODNMBACK,''), ifnull( PRODDETAILFRONT,''), ifnull( PRODDETAILBACK,''), ifnull( PRODDETAILOUTPUT,''), ifnull( TRANSLATOR,''), ifnull( PLUS,''),ifnull( PLUS1,''),ifnull( PLUS2,''),ifnull( PLUSUP,''),ifnull( PLUSUP1,''),ifnull( PLUSUP2,''),ifnull( GIFIMAGE,''),ifnull( GIFIMAGE1,''), ifnull( GIFIMAGE2,''),ifnull( BOLD,''),ifnull( BOLD1,''),ifnull( BLOD2,''),ifnull( BACKGROUNDCOLOR,''),ifnull( BACKGROUNDCOLOR1,''),ifnull( BACKGROUNDCOLOR2,''), ifnull( TITLEYN,''),ifnull( COLLECTIVEAPP,''),ifnull( COLLECTIVEAPP1,''),ifnull( AGESELECT,''), ifnull( PRODOPTIONMODIFY,''),ifnull( ADDPRODMODIFY,''),ifnull( PRODOPTIONEXCEPTION,''),ifnull( ADDOPTIONEXCEPTION,''), ifnull(FREEDELIVERY,'') , ifnull(EXPPRC,'2500'), \tIFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX, ''),IFNULL(CHANGESIZEY, ''),IFNULL(CHANGESIZEW, ''),IFNULL(CHANGESIZEH, ''),\tIFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL, ''), IFNULL(DETAILKEYWORDR, ''), \tIFNULL(DETAILPRODUCTCODEB,''), IFNULL(DETAILPRODUCTCODEL, ''), IFNULL(DETAILPRODUCTCODER, ''), \tIFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL, ''), IFNULL(DETAILPRODUCTNAMER, ''),  IFNULL(ADDOPTIONLB, ''), IFNULL(ADDOPTIONL, ''), IFNULL(ADDOPTIONRB, ''), IFNULL(ADDOPTIONR, ''),  IFNULL(IMGONEONONE, ''), IFNULL(IMGTHREEONFOUR, ''), IMG_ANGLE, IMG_SCALE_PERCENT \r\n\tFROM shop11staddidtl  where  seq=? and shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                pstmt.setString(2, shopcd);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setAbrdbuyplace(rs.getString(++columnIndex));
                    dto.setAbrdsizetabledispyn(rs.getString(++columnIndex));
                    dto.setSelmnbdncknm(rs.getString(++columnIndex));
                    dto.setSelmthdcd(rs.getString(++columnIndex));
                    dto.setDispctgrno(rs.getString(++columnIndex));
                    dto.setPrdtypcd(rs.getString(++columnIndex));
                    dto.setBrand(rs.getString(++columnIndex));
                    dto.setRmaterialtypcd(rs.getString(++columnIndex));
                    dto.setSupldtyfrprdclfcd(rs.getString(++columnIndex));
                    dto.setYearendtaxyn(rs.getString(++columnIndex));
                    dto.setForabrdbuyclf(rs.getString(++columnIndex));
                    dto.setImportfeecd(rs.getString(++columnIndex));
                    dto.setPrdstatcd(rs.getString(++columnIndex));
                    dto.setUsemon(rs.getString(++columnIndex));
                    dto.setPaidselprc(rs.getString(++columnIndex));
                    dto.setExteriorspecialnote(rs.getString(++columnIndex));
                    dto.setMinorselcnyn(rs.getString(++columnIndex));
                    dto.setReviewdispyn(rs.getString(++columnIndex));
                    dto.setSelprdclfcd(rs.getString(++columnIndex));
                    dto.setAplbgndy(rs.getString(++columnIndex));
                    dto.setAplenddy(rs.getString(++columnIndex));
                    dto.setWrhsplndy(rs.getString(++columnIndex));
                    dto.setCuponcheck(rs.getString(++columnIndex));
                    dto.setDscamtpercnt(rs.getString(++columnIndex));
                    dto.setCupndscmthdcd(rs.getString(++columnIndex));
                    dto.setCupnuselmtdyyn(rs.getString(++columnIndex));
                    dto.setCupnlssenddy(rs.getString(++columnIndex));
                    dto.setPay11yn(rs.getString(++columnIndex));
                    dto.setPay11value(rs.getString(++columnIndex));
                    dto.setPay11wycd(rs.getString(++columnIndex));
                    dto.setIntfreeyn(rs.getString(++columnIndex));
                    dto.setIntfreemonclfcd(rs.getString(++columnIndex));
                    dto.setPluyn(rs.getString(++columnIndex));
                    dto.setPludsccd(rs.getString(++columnIndex));
                    dto.setPludscbasis(rs.getString(++columnIndex));
                    dto.setPludscamtpercnt(rs.getString(++columnIndex));
                    dto.setPludscmthdcd(rs.getString(++columnIndex));
                    dto.setPlulssstartdy(rs.getString(++columnIndex));
                    dto.setPlulssenddy(rs.getString(++columnIndex));
                    dto.setHopeshpyn(rs.getString(++columnIndex));
                    dto.setHopeshpnt(rs.getString(++columnIndex));
                    dto.setHopeshpwycd(rs.getString(++columnIndex));
                    dto.setPluuselmtdyyn(rs.getString(++columnIndex));
                    dto.setPrdexposeclfcd(rs.getString(++columnIndex));
                    dto.setImage(rs.getString(++columnIndex));
                    dto.setSelminlimittypcd(rs.getString(++columnIndex));
                    dto.setSelminlimitqty(rs.getString(++columnIndex));
                    dto.setSellimittypcd(rs.getString(++columnIndex));
                    dto.setSellimitqty(rs.getString(++columnIndex));
                    dto.setTownsellmtdy(rs.getString(++columnIndex));
                    dto.setUsegiftyn(rs.getString(++columnIndex));
                    dto.setGiftinfo(rs.getString(++columnIndex));
                    dto.setGiftnm(rs.getString(++columnIndex));
                    dto.setAplbgndt(rs.getString(++columnIndex));
                    dto.setAplenddt(rs.getString(++columnIndex));
                    dto.setGbldlvyn(rs.getString(++columnIndex));
                    dto.setGblhscode(rs.getString(++columnIndex));
                    dto.setDlvcnareacd(rs.getString(++columnIndex));
                    dto.setDlvwycd(rs.getString(++columnIndex));
                    dto.setDlvetprscd(rs.getString(++columnIndex));
                    dto.setDlvsendclosetmpltno(rs.getString(++columnIndex));
                    dto.setDelivery(rs.getString(++columnIndex));
                    dto.setDlvcstinstbasicd(rs.getString(++columnIndex));
                    dto.setDlvcst1(rs.getString(++columnIndex));
                    dto.setDlvcst3(rs.getString(++columnIndex));
                    dto.setDlvcst4(rs.getString(++columnIndex));
                    dto.setDlvcstinfocd(rs.getString(++columnIndex));
                    dto.setPrdfrdlvbasiamt(rs.getString(++columnIndex));
                    dto.setDlvcnt1(rs.getString(++columnIndex));
                    dto.setDlvcnt2(rs.getString(++columnIndex));
                    dto.setBndldlvcnyn(rs.getString(++columnIndex));
                    dto.setDlvcstpaytypcd(rs.getString(++columnIndex));
                    dto.setJejudlvcst(rs.getString(++columnIndex));
                    dto.setIslanddlvcst(rs.getString(++columnIndex));
                    dto.setAddrseqout(rs.getString(++columnIndex));
                    dto.setOutsideynout(rs.getString(++columnIndex));
                    dto.setAddseqoutmemno(rs.getString(++columnIndex));
                    dto.setAddrseqin(rs.getString(++columnIndex));
                    dto.setOutsideynin(rs.getString(++columnIndex));
                    dto.setAddseqinmemno(rs.getString(++columnIndex));
                    dto.setAbrdcndlvcst(rs.getString(++columnIndex));
                    dto.setRtngddlvcst(rs.getString(++columnIndex));
                    dto.setRtngddlvcd(rs.getString(++columnIndex));
                    dto.setExchdlvcst(rs.getString(++columnIndex));
                    dto.setAsdetail(rs.getString(++columnIndex));
                    dto.setRtngexchdetail(rs.getString(++columnIndex));
                    dto.setDlvclf(rs.getString(++columnIndex));
                    dto.setNtshortnm(rs.getString(++columnIndex));
                    dto.setGlobaloutaddrseq(rs.getString(++columnIndex));
                    dto.setMnfcdy(rs.getString(++columnIndex));
                    dto.setMaintitle(rs.getString(++columnIndex));
                    dto.setArtist(rs.getString(++columnIndex));
                    dto.setMudvdlabel(rs.getString(++columnIndex));
                    dto.setMaker(rs.getString(++columnIndex));
                    dto.setAlbumnm(rs.getString(++columnIndex));
                    dto.setDvdtitle(rs.getString(++columnIndex));
                    dto.setBcktexyn(rs.getString(++columnIndex));
                    dto.setPrccmpexpyn(rs.getString(++columnIndex));
                    dto.setStfprdyn(rs.getString(++columnIndex));
                    dto.setModel(rs.getString(++columnIndex));
                    dto.setModelnm(rs.getString(++columnIndex));
                    dto.setBrandmethod(rs.getString(++columnIndex));
                    dto.setPrdimage10(rs.getString(++columnIndex));
                    dto.setCertmatching(rs.getString(++columnIndex));
                    dto.setProlanguage(rs.getString(++columnIndex));
                    dto.setPicture(rs.getString(++columnIndex));
                    dto.setIsbn13(rs.getString(++columnIndex));
                    dto.setIsbn10(rs.getString(++columnIndex));
                    dto.setAddicode(rs.getString(++columnIndex));
                    dto.setPublication(rs.getString(++columnIndex));
                    dto.setKind(rs.getString(++columnIndex));
                    dto.setTicketnm(rs.getString(++columnIndex));
                    dto.setProdoutput(rs.getString(++columnIndex));
                    dto.setProdnmfront(rs.getString(++columnIndex));
                    dto.setProdnmback(rs.getString(++columnIndex));
                    dto.setProddetailfront(rs.getString(++columnIndex));
                    dto.setProddetailback(rs.getString(++columnIndex));
                    dto.setProddetailoutput(rs.getString(++columnIndex));
                    dto.setTranslator(rs.getString(++columnIndex));
                    dto.setPlus(rs.getString(++columnIndex));
                    dto.setPlus1(rs.getString(++columnIndex));
                    dto.setPlus2(rs.getString(++columnIndex));
                    dto.setPlusup(rs.getString(++columnIndex));
                    dto.setPlusup1(rs.getString(++columnIndex));
                    dto.setPlusup2(rs.getString(++columnIndex));
                    dto.setGifimage(rs.getString(++columnIndex));
                    dto.setGifimage1(rs.getString(++columnIndex));
                    dto.setGifimage2(rs.getString(++columnIndex));
                    dto.setBold(rs.getString(++columnIndex));
                    dto.setBold1(rs.getString(++columnIndex));
                    dto.setBold2(rs.getString(++columnIndex));
                    dto.setBackgroundcolor(rs.getString(++columnIndex));
                    dto.setBackgroundcolor1(rs.getString(++columnIndex));
                    dto.setBackgroundcolor2(rs.getString(++columnIndex));
                    dto.setTitleyn(rs.getString(++columnIndex));
                    dto.setCollectiveapp(rs.getString(++columnIndex));
                    dto.setCollectiveapp1(rs.getString(++columnIndex));
                    dto.setAgeselect(rs.getString(++columnIndex));
                    dto.setProdOptionModify(rs.getString(++columnIndex));
                    dto.setAddProdModify(rs.getString(++columnIndex));
                    dto.setProdOptionException(rs.getString(++columnIndex));
                    dto.setAddOptionException(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setAngle(rs.getDouble(++columnIndex));
                    dto.setScalePercent(rs.getDouble(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<List<String>> getShopDealTrade() throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(a.SHOPCD,''),ifnull(b.SHOPNM,''),ifnull(b.CUSTNM,''),ifnull(b.PRODREGIS,''),ifnull(b.PRODMODIFY,''),ifnull(b.PRODSOLDOUT,''),ifnull(b.STOCKSEND,''),ifnull(b.ORDERCOLLECT,''), \t  ifnull(b.INVOICSEND,''),ifnull(b.CLAIMCOLLECT,''),ifnull(b.QUESTION,''),ifnull(b.MARKETCATEG,''),ifnull(a.IDNUM,''),ifnull(a.DEALTRADE,'')   from shopmst a \t join shopinfo b on a.shopcd = b.shopcd  where a.compno = ?    and a.DEALTRADE = '\uac70\ub798\uc911' ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopDealTrade]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getShopAddrListCheck(String shopcd, int result, String search, String title, String addr) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT IFNULL(b.title,''),IFNULL(b.seq,''),IFNULL(a.insertdt,''),IFNULL(a.updatedt,'') " + String.format(" FROM SHOPADDRMST a JOIN %s b ON a.SHOPCD=b.SHOPCD and a.compno = b.compno and a.seq = b.seq ", this.mapAddrList.get(shopcd)) + "  WHERE b.shopcd = ? " + "    and b.compno = ? ";
                if (search.equals("1")) {
                    sql = String.valueOf(sql) + " and b.title LIKE ? ";
                } else if (search.equals("2")) {
                    sql = String.valueOf(sql) + " and b.seq LIKE ? ";
                }
                sql = result == 0 ? String.valueOf(sql) + " order by b.title" : (result == 1 ? String.valueOf(sql) + " order by a.insertdt " : String.valueOf(sql) + " order by a.updatedt ");
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                if (search.equals("1")) {
                    pstmt.setString(3, "%" + title + "%");
                } else if (search.equals("2")) {
                    pstmt.setString(3, "%" + addr + "%");
                }
                YDMAStringUtil.Print("[getShopAddrListCheck]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(String.valueOf(++rowno));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add("");
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopAddrMstDto> getShopAddrAllList() throws Exception {
        ArrayList<ShopAddrMstDto> contents = new ArrayList<ShopAddrMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "\tSELECT \r\n \t\tIFNULL(SHOPCD, '') AS SHOPCD ,\r\n\t\tIFNULL(SHOPSEQ, '') AS SHOPSEQ ,\r\n\t\tIFNULL(SEQ, '') AS SEQ ,\r\n\t\tIFNULL(TITLE, '') AS TITLE, \r\n\t\tIFNULL(SHOPID, '') AS SHOPID\t FROM shopaddrmst  WHERE COMPNO = ?    AND USEYN='Y'";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopAddrAllList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopAddrMstDto dto = new ShopAddrMstDto();
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setTitle(rs.getString("TITLE"));
                    dto.setShopid(rs.getString("SHOPID"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopAddrMstDto> getShopAddrAllListSet() throws Exception {
        ArrayList<ShopAddrMstDto> contents = new ArrayList<ShopAddrMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "\tSELECT \r\n\t\t   IFNULL(SHOPCD, '') AS SHOPCD ,\r\n\t\t   IFNULL(SHOPSEQ, '') AS SHOPSEQ ,\r\n\t\t   IFNULL(SEQ, '') AS SEQ ,\r\n\t\t   IFNULL(TITLE, '') AS TITLE, \r\n\t\t   IFNULL(SELMTHDCD, '') AS SELMTHDCD, \r\n\t\t   IFNULL(USEYN, '') AS USEYN, \r\n\t\t   IFNULL(INSERTDT, '') AS INSERTDT, \r\n\t\t   IFNULL(UPDATEDT, '') AS UPDATEDT \r\n\t  FROM shopaddrmst   WHERE COMPNO = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopAddrAllListSet]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopAddrMstDto dto = new ShopAddrMstDto();
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setTitle(rs.getString("TITLE"));
                    dto.setSelmthdcd(rs.getString("SELMTHDCD"));
                    dto.setUseyn(rs.getString("USEYN"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setUpdatedt(rs.getString("UPDATEDT"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopAddrMstDto> getShopAddrAllListSet1() throws Exception {
        ArrayList<ShopAddrMstDto> contents = new ArrayList<ShopAddrMstDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "\tSELECT \r\nIFNULL(A.SHOPCD, '') AS SHOPCD ,\r\nIFNULL(A.SHOPSEQ, '') AS SHOPSEQ ,\r\nIFNULL(A.SEQ, '') AS SEQ ,\r\nIFNULL(A.TITLE, '') AS TITLE, \r\nIFNULL(A.SELMTHDCD, '') AS SELMTHDCD, \r\nIFNULL(A.USEYN, '') AS USEYN, \r\nIFNULL(A.INSERTDT, '') AS INSERTDT,\r\nIFNULL(A.UPDATEDT, '') AS UPDATEDT \r\nFROM  shopaddrmst AS A\r\nLEFT JOIN shopdtl AS B\r\nON A.compno = B.compno AND\r\nA.SHOPSEQ = B.SHOPSEQ AND\r\nA.SHOPCD = B.SHOPCD\r\nWHERE A.COMPNO = ?\r\n";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopAddrAllListSet]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopAddrMstDto dto = new ShopAddrMstDto();
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setTitle(rs.getString("TITLE"));
                    dto.setSelmthdcd(rs.getString("SELMTHDCD"));
                    dto.setUseyn(rs.getString("USEYN"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setUpdatedt(rs.getString("UPDATEDT"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getShopAddrList(String shopcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT IFNULL(b.title,''),IFNULL(b.seq,''),IFNULL(a.insertdt,''),IFNULL(a.updatedt,'')    FROM SHOPADDRMST a \t  JOIN shopaddr11stdtl b \t\tON a.SHOPCD=b.SHOPCD and a.compno = b.compno and a.seq = b.seq   WHERE b.shopcd = ?     and b.compno = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopAddrList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(String.valueOf(++rowno));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add("");
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopCateInfoDto> getCatInfoAll() throws Exception {
        ArrayList<ShopCateInfoDto> list = new ArrayList<ShopCateInfoDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT \r\n");
                sb.append("IFNULL(COMPNO, '') AS COMPNO,\r\n");
                sb.append("IFNULL(SHOPCD, '') AS SHOPCD, \r\n");
                sb.append("IFNULL(SHOPCATNO, '') AS SHOPCATNO, \r\n");
                sb.append("IFNULL(SHOPCATSITENM, '') AS SHOPCATSITENM, \r\n");
                sb.append("IFNULL(EBAYCATCD, '') AS EBAYCATCD, \r\n");
                sb.append("IFNULL(SHOPLAGCATCD, '') AS SHOPLAGCATCD,\r\n");
                sb.append("IFNULL(SHOPMIDCATCD, '') AS SHOPMIDCATCD, \r\n");
                sb.append("IFNULL(SHOPSMLCATCD, '') AS SHOPSMLCATCD, \r\n");
                sb.append("IFNULL(SHOPDETCATCD, '') AS SHOPDETCATCD\r\n");
                sb.append("FROM shopcatinf WHERE COMPNO =? ");
                String sql = sb.toString();
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getCatInfoAll]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateInfoDto ShopCatInfDto2 = new ShopCateInfoDto();
                    ShopCatInfDto2.setShopcd(rs.getString("SHOPCD"));
                    ShopCatInfDto2.setCid(rs.getString("SHOPCATNO"));
                    ShopCatInfDto2.setShopcatsitenm(rs.getString("SHOPCATSITENM").replace(" ", ""));
                    ShopCatInfDto2.setEbaycid(rs.getString("EBAYCATCD"));
                    String shopcid = Arrays.asList(String.valueOf(rs.getString("SHOPDETCATCD")), String.valueOf(rs.getString("SHOPSMLCATCD")), String.valueOf(rs.getString("SHOPMIDCATCD")), String.valueOf(rs.getString("SHOPLAGCATCD"))).stream().filter(p -> p != null && !p.isEmpty()).findFirst().orElse("");
                    ShopCatInfDto2.setShopcid(shopcid);
                    list.add(ShopCatInfDto2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopCatInfDto> getCatMapInfoAll() throws Exception {
        ArrayList<ShopCatInfDto> list = new ArrayList<ShopCatInfDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT CODE, SHOPCD, SHOPCATNO FROM categdtlmap WHERE compno=?\r\n");
                sb.append("UNION all \r\n");
                sb.append("SELECT CODE, SHOPCD, SHOPCATNO FROM categsmmap WHERE compno=?\r\n");
                sb.append("UNION all \r\n");
                sb.append("SELECT CODE, SHOPCD, SHOPCATNO FROM categmdmap WHERE compno=?\r\n");
                sb.append("UNION all \r\n");
                sb.append("SELECT CODE, SHOPCD, SHOPCATNO FROM categlgmap WHERE compno=?\r\n");
                String sql = sb.toString();
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getCatMapInfoAll]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCatInfDto ShopCatInfDto2 = new ShopCatInfDto();
                    ShopCatInfDto2.setCode(rs.getString("CODE"));
                    ShopCatInfDto2.setShopcd(rs.getString("SHOPCD"));
                    ShopCatInfDto2.setShopcatno(rs.getString("SHOPCATNO"));
                    list.add(ShopCatInfDto2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopCatInfDto> getCatInfo(String shopcd) throws Exception {
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ShopCatInfDto> list = new ArrayList<ShopCatInfDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT \r\n   IFNULL(CATEMAP.CODE,'' ) AS CODE,\t IFNULL(CATEINF.COMPNO,'' ) AS COMPNO,  \r\n\t IFNULL(CATEINF.SHOPCD,'' ) AS SHOPCD,  \r\n\t IFNULL(CATEINF.SHOPCATNO,'' ) AS SHOPCATNO,  \r\n\t IFNULL(CATEINF.SHOPCATNM,'' ) AS SHOPCATNM,  \r\n\t IFNULL(CATEINF.SHOPCATSITENM,'' ) AS SHOPCATSITENM,  \r\n\t IFNULL(CATEINF.EBAYCATCD,'' ) AS EBAYCATCD,  \r\n\t IFNULL(CATEINF.SHOPLAGCATCD,'' ) AS SHOPLAGCATCD,  \r\n\t IFNULL(CATEINF.SHOPMIDCATCD,'' ) AS SHOPMIDCATCD,  \r\n\t IFNULL(CATEINF.SHOPSMLCATCD,'' ) AS SHOPSMLCATCD,  \r\n\t IFNULL(CATEINF.SHOPDETCATCD,'' ) AS SHOPDETCATCD,  \r\n\t IFNULL(CATEINF.SERVICEPROD,'' ) AS SERVICEPROD,  \r\n\t IFNULL(CATEINF.USE_YN,'' ) AS USE_YN,  \r\n\t IFNULL(CATEINF.SHOPGENERAL,'' ) AS SHOPGENERAL,  \r\n\t IFNULL(CATEINF.SHOPID,'' ) AS SHOPID,  \r\n\t IFNULL(CATEINF.SHOPCOMMIS,'' ) AS SHOPCOMMIS,  \r\n\t IFNULL(CATEINF.INSERTDT,'' ) AS INSERTDT,  \r\n\t IFNULL(CATEINF.MODIFYDT,'' ) AS MODIFYDT   \r\n\tFROM   \r\n\t(      \r\n" + String.format("\t\tSELECT COMPNO, CODE, SHOPCD, SHOPCATNO FROM CATEGLGMAP WHERE COMPNO = '%s' AND SHOPCD= '%s' UNION ALL  \r\n", compno, shopcd) + String.format("\t\tSELECT COMPNO, CODE, SHOPCD, SHOPCATNO FROM CATEGMDMAP WHERE COMPNO = '%s' AND SHOPCD= '%s' UNION ALL  \r\n", compno, shopcd) + String.format("\t\tSELECT COMPNO, CODE, SHOPCD, SHOPCATNO FROM CATEGSMMAP WHERE COMPNO = '%s' AND SHOPCD= '%s' UNION ALL  \r\n", compno, shopcd) + String.format("\t    SELECT COMPNO, CODE, SHOPCD, SHOPCATNO FROM CATEGDTLMAP WHERE COMPNO = '%s' AND SHOPCD= '%s'           \r\n", compno, shopcd) + "\t) CATEMAP                                                                                                                                                    \r\n" + " LEFT JOIN SHOPCATINF AS CATEINF       \r\n" + " ON CATEMAP.COMPNO = CATEINF.COMPNO    \r\n" + " AND CATEMAP.SHOPCD = CATEINF.SHOPCD   \r\n" + "AND CATEMAP.SHOPCATNO  = CATEINF.SHOPCATNO \r\n" + "AND CATEINF.COMPNO= ?\r\n" + "WHERE CATEINF.USE_YN = 'Y' ";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopMstSelectList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCatInfDto ShopCatInfDto2 = new ShopCatInfDto();
                    ShopCatInfDto2.setCode(rs.getString("CODE"));
                    ShopCatInfDto2.setCompno(rs.getString("COMPNO"));
                    ShopCatInfDto2.setShopcd(rs.getString("SHOPCD"));
                    ShopCatInfDto2.setShopcatno(rs.getString("SHOPCATNO"));
                    ShopCatInfDto2.setShopcatnm(rs.getString("SHOPCATNM"));
                    ShopCatInfDto2.setShopcatsitenm(rs.getString("SHOPCATSITENM"));
                    ShopCatInfDto2.setShopebaylagcatcd(rs.getString("EBAYCATCD"));
                    ShopCatInfDto2.setShopebaymidcatcd(rs.getString("EBAYCATCD"));
                    ShopCatInfDto2.setShopebaysmlcatcd(rs.getString("EBAYCATCD"));
                    ShopCatInfDto2.setShopebaydetcatcd(rs.getString("EBAYCATCD"));
                    ShopCatInfDto2.setShopebaytalcatcd(rs.getString("EBAYCATCD"));
                    ShopCatInfDto2.setShoplagcatcd(rs.getString("SHOPLAGCATCD"));
                    ShopCatInfDto2.setShopmidcatcd(rs.getString("SHOPMIDCATCD"));
                    ShopCatInfDto2.setShopsmlcatcd(rs.getString("SHOPSMLCATCD"));
                    ShopCatInfDto2.setShopdetcatcd(rs.getString("SHOPDETCATCD"));
                    ShopCatInfDto2.setServiceprod(rs.getString("SERVICEPROD"));
                    ShopCatInfDto2.setUse_yn(rs.getString("USE_YN"));
                    ShopCatInfDto2.setShopgeneral(rs.getString("SHOPGENERAL"));
                    ShopCatInfDto2.setShopid(rs.getString("SHOPID"));
                    ShopCatInfDto2.setShopcommis(rs.getString("SHOPCOMMIS"));
                    ShopCatInfDto2.setInsertdt(rs.getString("INSERTDT"));
                    ShopCatInfDto2.setModifydt(rs.getString("MODIFYDT"));
                    list.add(ShopCatInfDto2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public ProductDTO getShopProductIn(int sendseq) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ProductDTO dto = new ProductDTO();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "WITH CATEALL AS(                                                                 \r\n\t\tSELECT                                                                    \r\n\t\t   IFNULL(A.CODE,'')     AS CLASS_CD1 ,                                   \r\n\t\t\tIFNULL(A.CATEGORY,'') AS CLASS_NM1 ,                                  \r\n\t\t\tIFNULL(RIGHT(B.CODE,3),'')     AS CLASS_CD2  ,                        \r\n\t\t\tIFNULL(B.CATEGORY,'') AS CLASS_NM2 ,                                  \r\n\t\t\tIFNULL(RIGHT(C.CODE,3),'')     AS CLASS_CD3,                          \r\n\t\t\tIFNULL(C.CATEGORY,'') AS CLASS_NM3,                                   \r\n\t\t\tIFNULL(RIGHT(D.CODE,3),'')     AS CLASS_CD4 ,                         \r\n\t\t\tIFNULL(D.CATEGORY,'') AS CLASS_NM4                                    \r\n\t\tFROM CATEGLARGE A left JOIN CATEGMIDIUM B                                      \r\n\t\t\tON A.COMPNO=B.COMPNO AND A.CODE = B.LRGCODE left JOIN CATEGSMALL C         \r\n\t\t\tON A.COMPNO = C.COMPNO AND B.CODE = C.MIDCODE left JOIN CATEGDETAIL D ON   \r\n A.COMPNO = D.COMPNO AND C.CODE = D.SMLCODE WHERE A.COMPNO = '3'         \r\n\t\t )                                                                        \r\n SELECT SHOPIN.*  , \r\n IFNULL(CATE.CLASS_NM1, '')  CLASS_NM1, \r\n IFNULL(CATE.CLASS_NM2, '')  CLASS_NM2, \r\n IFNULL(CATE.CLASS_NM3, '')  CLASS_NM3, \r\n IFNULL(CATE.CLASS_NM4, '')  CLASS_NM4, \r\n(CASE                                   \r\n\t     WHEN GOODS_GUBUN = '1'         \r\n\t     THEN '\uc704\ud0c1\uc0c1\ud488'                \r\n\t     WHEN GOODS_GUBUN = '2'         \r\n\t     THEN '\uc81c\uc870\uc0c1\ud488'                \r\n\t     WHEN GOODS_GUBUN = '3'         \r\n\t     THEN '\uc0ac\uc5c5\uc0c1\ud488'                \r\n\t     WHEN GOODS_GUBUN = '4'         \r\n\t     THEN '\uc9c1\uc601\uc0c1\ud488'                \r\n\t     ELSE ''                        \r\n\t  END )AS GOODS_GUBUN_NM,            \r\n(CASE                            \r\n\t     WHEN STATUS = '1'       \r\n\t     THEN '\ub300\uae30\uc911'           \r\n\t     WHEN STATUS = '2'       \r\n\t     THEN '\uacf5\uae09\uc911'           \r\n\t     WHEN STATUS = '3'       \r\n\t     THEN '\uc77c\uc2dc\uc911\uc9c0'         \r\n\t     WHEN STATUS = '4'       \r\n\t     THEN '\uc644\uc804\ud488\uc808'         \r\n\t      WHEN STATUS = '5'      \r\n\t     THEN '\ubbf8\uc0ac\uc6a9'           \r\n\t      WHEN STATUS = '6'      \r\n\t     THEN '\uc0ad\uc81c'             \r\n\t     ELSE ''                 \r\n\t  END )AS STATUS_NM,         \r\n(CASE                             \r\n\t     WHEN DELV_TYPE = '1'     \r\n\t     THEN '\ubb34\ub8cc'              \r\n\t     WHEN DELV_TYPE = '2'     \r\n\t     THEN '\ucc29\ubd88'              \r\n\t     WHEN DELV_TYPE = '3'     \r\n\t     THEN '\uc120\uacb0\uc81c'            \r\n\t     WHEN DELV_TYPE = '4'     \r\n\t     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n\t     ELSE ''                  \r\n\t  END )AS DELV_TYPE_NM       \r\n FROM                             \r\n(SELECT                           \r\n CONCAT(IFNULL(A.CLASS_CD1,''), IFNULL(A.CLASS_CD2,''), IFNULL(A.CLASS_CD3,''), IFNULL(A.CLASS_CD4,'')) AS CODE, \r\n(SELECT SHOPNM FROM shopinfo WHERE SHOPCD = A.SHOPCD) AS SHOPNM, \r\n( SELECT SHOPPINGID FROM shopdtl WHERE SHOPCD = A.SHOPCD AND COMPNO = A.COMPNO AND SHOPSEQ = A.SHOPSEQ) AS  SHOPUSERID, YWM_FUNC_BOSSPRODCD(3,A.COMPAYNY_GOODS_CD) AS IMG,\r\n IFNULL(A.SENDSEQ,'' ) AS SENDSEQ,\r\n IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n IFNULL(A.SHOPCD,'' ) AS SHOPCD,\r\n IFNULL(A.SHOPSEQ,'' ) AS SHOPSEQ,\r\n IFNULL(A.PRODSEQ,'' ) AS PRODSEQ,\r\n IFNULL(A.SHOPPRODNO,'' ) AS SHOPPRODNO,\r\n IFNULL(A.SEQ,'' ) AS SEQ,\r\n IFNULL(A.SHOPCATNO,'' ) AS SHOPCATNO,\r\n IFNULL(A.GOODS_NM,'' ) AS GOODS_NM,\r\n IFNULL(A.GOODS_KEYWORD,'' ) AS GOODS_KEYWORD,\r\n IFNULL(A.MODEL_NM,'' ) AS MODEL_NM,\r\n IFNULL(A.MODEL_NO,'' ) AS MODEL_NO,\r\n IFNULL(A.BRAND_NM,'' ) AS BRAND_NM,\r\n IFNULL(A.COMPAYNY_GOODS_CD,'' ) AS COMPAYNY_GOODS_CD,\r\n IFNULL(A.GOODS_SEARCH,'' ) AS GOODS_SEARCH,\r\n IFNULL(A.GOODS_GUBUN,'' ) AS GOODS_GUBUN,\r\n IFNULL(A.CLASS_CD1,'' ) AS CLASS_CD1,\r\n IFNULL(A.CLASS_CD2,'' ) AS CLASS_CD2,\r\n IFNULL(A.CLASS_CD3,'' ) AS CLASS_CD3,\r\n IFNULL(A.CLASS_CD4,'' ) AS CLASS_CD4,\r\n IFNULL(A.PARTNER_ID,'' ) AS PARTNER_ID,\r\n IFNULL(A.DPARTNER_ID,'' ) AS DPARTNER_ID,\r\n IFNULL(A.MAKER,'' ) AS MAKER,\r\n IFNULL(A.ORIGIN,'' ) AS ORIGIN,\r\n IFNULL(A.MAKE_YEAR,'' ) AS MAKE_YEAR,\r\n IFNULL(A.MAKE_DM,'' ) AS MAKE_DM,\r\n IFNULL(A.GOODS_SEASON,'' ) AS GOODS_SEASON,\r\n IFNULL(A.SEX,'' ) AS SEX,\r\n IFNULL(A.STATUS,'' ) AS STATUS,\r\n IFNULL(A.DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,\r\n IFNULL(A.TAX_YN,'' ) AS TAX_YN,\r\n IFNULL(A.DELV_TYPE,'' ) AS DELV_TYPE,\r\n IFNULL(A.DELV_COST,'' ) AS DELV_COST,\r\n IFNULL(A.BANPUM_AREA,'' ) AS BANPUM_AREA,\r\n IFNULL(A.GOODS_COST,'' ) AS GOODS_COST,\r\n IFNULL(A.GOODS_PRICE,'' ) AS GOODS_PRICE,\r\n IFNULL(A.GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,\r\n IFNULL(A.CHAR_1_NM,'' ) AS CHAR_1_NM,\r\n IFNULL(A.CHAR_1_VAL,'' ) AS CHAR_1_VAL,\r\n IFNULL(A.CHAR_2_NM,'' ) AS CHAR_2_NM,\r\n IFNULL(A.CHAR_2_VAL,'' ) AS CHAR_2_VAL,\r\n IFNULL(A.IMG_PATH,'' ) AS IMG_PATH,\r\n IFNULL(A.IMG_PATH1,'' ) AS IMG_PATH1,\r\n IFNULL(A.IMG_PATH2,'' ) AS IMG_PATH2,\r\n IFNULL(A.IMG_PATH3,'' ) AS IMG_PATH3,\r\n IFNULL(A.IMG_PATH4,'' ) AS IMG_PATH4,\r\n IFNULL(A.IMG_PATH5,'' ) AS IMG_PATH5,\r\n IFNULL(A.IMG_PATH6,'' ) AS IMG_PATH6,\r\n IFNULL(A.IMG_PATH7,'' ) AS IMG_PATH7,\r\n IFNULL(A.IMG_PATH8,'' ) AS IMG_PATH8,\r\n IFNULL(A.IMG_PATH9,'' ) AS IMG_PATH9,\r\n IFNULL(A.IMG_PATH10,'' ) AS IMG_PATH10,\r\n IFNULL(A.IMG_PATH11,'' ) AS IMG_PATH11,\r\n IFNULL(A.IMG_PATH12,'' ) AS IMG_PATH12,\r\n IFNULL(A.IMG_PATH13,'' ) AS IMG_PATH13,\r\n IFNULL(A.IMG_PATH14,'' ) AS IMG_PATH14,\r\n IFNULL(A.IMG_PATH15,'' ) AS IMG_PATH15,\r\n IFNULL(A.IMG_PATH16,'' ) AS IMG_PATH16,\r\n IFNULL(A.IMG_PATH17,'' ) AS IMG_PATH17,\r\n IFNULL(A.IMG_PATH18,'' ) AS IMG_PATH18,\r\n IFNULL(A.IMG_PATH19,'' ) AS IMG_PATH19,\r\n IFNULL(A.IMG_PATH20,'' ) AS IMG_PATH20,\r\n IFNULL(A.IMG_PATH21,'' ) AS IMG_PATH21,\r\n IFNULL(A.IMG_PATH22,'' ) AS IMG_PATH22,\r\n IFNULL(A.IMG_PATH23,'' ) AS IMG_PATH23,\r\n IFNULL(A.IMG_PATH24,'' ) AS IMG_PATH24,\r\n IFNULL(A.GOODS_REMARKS,'' ) AS GOODS_REMARKS,\r\n IFNULL(A.CERTNO,'' ) AS CERTNO,\r\n IFNULL(A.AVLST_DM,'' ) AS AVLST_DM,\r\n IFNULL(A.AVLED_DM,'' ) AS AVLED_DM,\r\n IFNULL(A.ISSUEDATE,'' ) AS ISSUEDATE,\r\n IFNULL(A.CERTDATE,'' ) AS CERTDATE,\r\n IFNULL(A.CERT_AGENCY,'' ) AS CERT_AGENCY,\r\n IFNULL(A.CERTFIELD,'' ) AS CERTFIELD,\r\n IFNULL(A.MATERIAL,'' ) AS MATERIAL,\r\n IFNULL(A.STOCK_USE_YN,'' ) AS STOCK_USE_YN,\r\n IFNULL(A.OPT_TYPE,'' ) AS OPT_TYPE,\r\n IFNULL(A.PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,\r\n IFNULL(A.PROP1_CD,'' ) AS PROP1_CD,\r\n IFNULL(A.PROP_VAL1,'' ) AS PROP_VAL1,\r\n IFNULL(A.PROP_VAL2,'' ) AS PROP_VAL2,\r\n IFNULL(A.PROP_VAL3,'' ) AS PROP_VAL3,\r\n IFNULL(A.PROP_VAL4,'' ) AS PROP_VAL4,\r\n IFNULL(A.PROP_VAL5,'' ) AS PROP_VAL5,\r\n IFNULL(A.PROP_VAL6,'' ) AS PROP_VAL6,\r\n IFNULL(A.PROP_VAL7,'' ) AS PROP_VAL7,\r\n IFNULL(A.PROP_VAL8,'' ) AS PROP_VAL8,\r\n IFNULL(A.PROP_VAL9,'' ) AS PROP_VAL9,\r\n IFNULL(A.PROP_VAL10,'' ) AS PROP_VAL10,\r\n IFNULL(A.PROP_VAL11,'' ) AS PROP_VAL11,\r\n IFNULL(A.PROP_VAL12,'' ) AS PROP_VAL12,\r\n IFNULL(A.PROP_VAL13,'' ) AS PROP_VAL13,\r\n IFNULL(A.PROP_VAL14,'' ) AS PROP_VAL14,\r\n IFNULL(A.PROP_VAL15,'' ) AS PROP_VAL15,\r\n IFNULL(A.PROP_VAL16,'' ) AS PROP_VAL16,\r\n IFNULL(A.PROP_VAL17,'' ) AS PROP_VAL17,\r\n IFNULL(A.PROP_VAL18,'' ) AS PROP_VAL18,\r\n IFNULL(A.PROP_VAL19,'' ) AS PROP_VAL19,\r\n IFNULL(A.PROP_VAL20,'' ) AS PROP_VAL20,\r\n IFNULL(A.PROP_VAL21,'' ) AS PROP_VAL21,\r\n IFNULL(A.PROP_VAL22,'' ) AS PROP_VAL22,\r\n IFNULL(A.PROP_VAL23,'' ) AS PROP_VAL23,\r\n IFNULL(A.PROP_VAL24,'' ) AS PROP_VAL24,\r\n IFNULL(A.PROP_VAL25,'' ) AS PROP_VAL25,\r\n IFNULL(A.PROP_VAL26,'' ) AS PROP_VAL26,\r\n IFNULL(A.PROP_VAL27,'' ) AS PROP_VAL27,\r\n IFNULL(A.PROP_VAL28,'' ) AS PROP_VAL28,\r\n IFNULL(A.PACK_CODE_STR,'' ) AS PACK_CODE_STR,\r\n IFNULL(A.GOODS_NM_EN,'' ) AS GOODS_NM_EN,\r\n IFNULL(A.GOODS_NM_PR,'' ) AS GOODS_NM_PR,\r\n IFNULL(A.GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,\r\n IFNULL(A.GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,\r\n IFNULL(A.GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,\r\n IFNULL(A.IMPORTNO,'' ) AS IMPORTNO,\r\n IFNULL(A.GOODS_COST2,'' ) AS GOODS_COST2,\r\n IFNULL(A.ORIGIN2,'' ) AS ORIGIN2,\r\n IFNULL(A.EXPIRE_DM,'' ) AS EXPIRE_DM,\r\n IFNULL(A.SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,\r\n IFNULL(A.DESCRITION,'' ) AS DESCRITION,\r\n IFNULL(A.INSERTDT,'' ) AS INSERTDT,\r\n IFNULL(A.INSERTID,'' ) AS INSERTID,\r\n IFNULL(A.MODIFYDT,'' ) AS MODIFYDT,\r\n IFNULL(A.MODIFYID,'' ) AS MODIFYID \r\n  FROM SHOPPRODIN AS A \r\n WHERE A.COMPNO = ?  AND A.SENDSEQ = ?  \r\n ) AS SHOPIN  LEFT JOIN CATEALL AS CATE  \r\n\t\t ON SHOPIN.CLASS_CD1 = CATE.CLASS_CD1  \r\n \t\t AND SHOPIN.CLASS_CD2 = CATE.CLASS_CD2 \r\nAND SHOPIN.CLASS_CD3 = CATE.CLASS_CD3   \r\nAND SHOPIN.CLASS_CD4 = CATE.CLASS_CD4  ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, sendseq);
                YDMAStringUtil.Print("[getShopProductIn]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    dto.setRowno("" + ++rowno);
                    dto.setSendstats("\uc5f0\ub3d9\uc0dd\uc131");
                    dto.setSHOPNM(rs.getString("SHOPNM"));
                    dto.setSHOP_USERID(rs.getString("SHOPUSERID"));
                    dto.setClass_nm1(rs.getString("CLASS_NM1"));
                    dto.setClass_nm2(rs.getString("CLASS_NM2"));
                    dto.setClass_nm3(rs.getString("CLASS_NM3"));
                    dto.setClass_nm4(rs.getString("CLASS_NM4"));
                    dto.setGoods_gubun_nm(rs.getString("GOODS_GUBUN_NM"));
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setSENDSEQ(rs.getString("SENDSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setShopcatno(rs.getString("SHOPCATNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year(rs.getString("MAKE_YEAR"));
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season(rs.getString("GOODS_SEASON"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ProductDTO> getShopProductModifyList(Map<String, String> params) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "WITH CATEALL AS(                                                                 \r\n\t\tSELECT                                                                    \r\n\t\t   IFNULL(A.CODE,'')     AS CLASS_CD1 ,                                   \r\n\t\t\tIFNULL(A.CATEGORY,'') AS CLASS_NM1 ,                                  \r\n\t\t\tIFNULL(RIGHT(B.CODE,3),'')     AS CLASS_CD2  ,                        \r\n\t\t\tIFNULL(B.CATEGORY,'') AS CLASS_NM2 ,                                  \r\n\t\t\tIFNULL(RIGHT(C.CODE,3),'')     AS CLASS_CD3,                          \r\n\t\t\tIFNULL(C.CATEGORY,'') AS CLASS_NM3,                                   \r\n\t\t\tIFNULL(RIGHT(D.CODE,3),'')     AS CLASS_CD4 ,                         \r\n\t\t\tIFNULL(D.CATEGORY,'') AS CLASS_NM4                                    \r\n\t\tFROM CATEGLARGE A left JOIN CATEGMIDIUM B                                      \r\n\t\t\tON A.COMPNO=B.COMPNO AND A.CODE = B.LRGCODE left JOIN CATEGSMALL C         \r\n\t\t\tON A.COMPNO = C.COMPNO AND B.CODE = C.MIDCODE left JOIN CATEGDETAIL D ON   \r\n A.COMPNO = D.COMPNO AND C.CODE = D.SMLCODE WHERE A.COMPNO = '3'         \r\n\t\t )                                                                        \r\n SELECT SHOPIN.*  , \r\n IFNULL(CATE.CLASS_NM1, '')  CLASS_NM1, \r\n IFNULL(CATE.CLASS_NM2, '')  CLASS_NM2, \r\n IFNULL(CATE.CLASS_NM3, '')  CLASS_NM3, \r\n IFNULL(CATE.CLASS_NM4, '')  CLASS_NM4, \r\n(CASE                                   \r\n\t     WHEN GOODS_GUBUN = '1'         \r\n\t     THEN '\uc704\ud0c1\uc0c1\ud488'                \r\n\t     WHEN GOODS_GUBUN = '2'         \r\n\t     THEN '\uc81c\uc870\uc0c1\ud488'                \r\n\t     WHEN GOODS_GUBUN = '3'         \r\n\t     THEN '\uc0ac\uc5c5\uc0c1\ud488'                \r\n\t     WHEN GOODS_GUBUN = '4'         \r\n\t     THEN '\uc9c1\uc601\uc0c1\ud488'                \r\n\t     ELSE ''                        \r\n\t  END )AS GOODS_GUBUN_NM,            \r\n(CASE                            \r\n\t     WHEN STATUS = '1'       \r\n\t     THEN '\ub300\uae30\uc911'           \r\n\t     WHEN STATUS = '2'       \r\n\t     THEN '\uacf5\uae09\uc911'           \r\n\t     WHEN STATUS = '3'       \r\n\t     THEN '\uc77c\uc2dc\uc911\uc9c0'         \r\n\t     WHEN STATUS = '4'       \r\n\t     THEN '\uc644\uc804\ud488\uc808'         \r\n\t      WHEN STATUS = '5'      \r\n\t     THEN '\ubbf8\uc0ac\uc6a9'           \r\n\t      WHEN STATUS = '6'      \r\n\t     THEN '\uc0ad\uc81c'             \r\n\t     ELSE ''                 \r\n\t  END )AS STATUS_NM,         \r\n(CASE                             \r\n\t     WHEN DELV_TYPE = '1'     \r\n\t     THEN '\ubb34\ub8cc'              \r\n\t     WHEN DELV_TYPE = '2'     \r\n\t     THEN '\ucc29\ubd88'              \r\n\t     WHEN DELV_TYPE = '3'     \r\n\t     THEN '\uc120\uacb0\uc81c'            \r\n\t     WHEN DELV_TYPE = '4'     \r\n\t     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n\t     ELSE ''                  \r\n\t  END )AS DELV_TYPE_NM       \r\n FROM                             \r\n(SELECT                           \r\n CONCAT(IFNULL(A.CLASS_CD1,''), IFNULL(A.CLASS_CD2,''), IFNULL(A.CLASS_CD3,''), IFNULL(A.CLASS_CD4,'')) AS CODE, \r\n(SELECT SHOPNM FROM shopinfo WHERE SHOPCD = A.SHOPCD) AS SHOPNM, \r\n( SELECT SHOPPINGID FROM shopdtl WHERE SHOPCD = A.SHOPCD AND COMPNO = A.COMPNO AND SHOPSEQ = A.SHOPSEQ) AS  SHOPUSERID, YWM_FUNC_BOSSPRODCD(3,A.COMPAYNY_GOODS_CD) AS IMG,\r\n IFNULL(A.SENDSEQ,'' ) AS SENDSEQ,\r\n IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n IFNULL(A.SHOPCD,'' ) AS SHOPCD,\r\n IFNULL(A.SHOPSEQ,'' ) AS SHOPSEQ,\r\n IFNULL(A.PRODSEQ,'' ) AS PRODSEQ,\r\n IFNULL(A.SHOPPRODNO,'' ) AS SHOPPRODNO,\r\n IFNULL(A.SEQ,'' ) AS SEQ,\r\n IFNULL(A.SHOPCATNO,'' ) AS SHOPCATNO,\r\n IFNULL(A.MARGINSEQ,'') AS MARGINSEQ, \r\n";
                sql = params.get("GOODS_NM").equals("1") ? String.valueOf(sql) + " IFNULL(B.GOODS_NM,'' ) AS GOODS_NM,\r\n" : String.valueOf(sql) + " IFNULL(A.GOODS_NM,'' ) AS GOODS_NM,\r\n";
                sql = String.valueOf(sql) + " IFNULL(A.GOODS_KEYWORD,'' ) AS GOODS_KEYWORD,\r\n" + " IFNULL(A.MODEL_NM,'' ) AS MODEL_NM,\r\n" + " IFNULL(A.MODEL_NO,'' ) AS MODEL_NO,\r\n" + " IFNULL(A.BRAND_NM,'' ) AS BRAND_NM,\r\n" + " IFNULL(A.COMPAYNY_GOODS_CD,'' ) AS COMPAYNY_GOODS_CD,\r\n" + " IFNULL(A.GOODS_SEARCH,'' ) AS GOODS_SEARCH,\r\n" + " IFNULL(A.GOODS_GUBUN,'' ) AS GOODS_GUBUN,\r\n" + " IFNULL(A.CLASS_CD1,'' ) AS CLASS_CD1,\r\n" + " IFNULL(A.CLASS_CD2,'' ) AS CLASS_CD2,\r\n" + " IFNULL(A.CLASS_CD3,'' ) AS CLASS_CD3,\r\n" + " IFNULL(A.CLASS_CD4,'' ) AS CLASS_CD4,\r\n" + " IFNULL(A.PARTNER_ID,'' ) AS PARTNER_ID,\r\n" + " IFNULL(A.DPARTNER_ID,'' ) AS DPARTNER_ID,\r\n" + " IFNULL(A.MAKER,'' ) AS MAKER,\r\n" + " IFNULL(A.ORIGIN,'' ) AS ORIGIN,\r\n" + " IFNULL(A.MAKE_YEAR,'' ) AS MAKE_YEAR,\r\n" + " IFNULL(A.MAKE_DM,'' ) AS MAKE_DM,\r\n" + " IFNULL(A.GOODS_SEASON,'' ) AS GOODS_SEASON,\r\n" + " IFNULL(A.SEX,'' ) AS SEX,\r\n" + " IFNULL(A.STATUS,'' ) AS STATUS,\r\n" + " IFNULL(A.DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,\r\n" + " IFNULL(A.TAX_YN,'' ) AS TAX_YN,\r\n" + " IFNULL(A.DELV_TYPE,'' ) AS DELV_TYPE,\r\n" + " IFNULL(A.DELV_COST,'' ) AS DELV_COST,\r\n" + " IFNULL(A.BANPUM_AREA,'' ) AS BANPUM_AREA,\r\n" + " IFNULL(A.GOODS_COST,'' ) AS GOODS_COST,\r\n";
                sql = params.get("GOODS_PRICE").equals("1") ? String.valueOf(sql) + " IFNULL(B.GOODS_PRICE,'' ) AS GOODS_PRICE,\r\n" : String.valueOf(sql) + " IFNULL(A.GOODS_PRICE,'' ) AS GOODS_PRICE,\r\n";
                sql = String.valueOf(sql) + " IFNULL(A.GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,\r\n" + " IFNULL(A.CHAR_1_NM,'' ) AS CHAR_1_NM,\r\n" + " IFNULL(A.CHAR_1_VAL,'' ) AS CHAR_1_VAL,\r\n" + " IFNULL(A.CHAR_2_NM,'' ) AS CHAR_2_NM,\r\n" + " IFNULL(A.CHAR_2_VAL,'' ) AS CHAR_2_VAL,\r\n" + " IFNULL(A.IMG_PATH,'' ) AS IMG_PATH,\r\n" + " IFNULL(A.IMG_PATH1,'' ) AS IMG_PATH1,\r\n" + " IFNULL(A.IMG_PATH2,'' ) AS IMG_PATH2,\r\n" + " IFNULL(A.IMG_PATH3,'' ) AS IMG_PATH3,\r\n" + " IFNULL(A.IMG_PATH4,'' ) AS IMG_PATH4,\r\n" + " IFNULL(A.IMG_PATH5,'' ) AS IMG_PATH5,\r\n" + " IFNULL(A.IMG_PATH6,'' ) AS IMG_PATH6,\r\n" + " IFNULL(A.IMG_PATH7,'' ) AS IMG_PATH7,\r\n" + " IFNULL(A.IMG_PATH8,'' ) AS IMG_PATH8,\r\n" + " IFNULL(A.IMG_PATH9,'' ) AS IMG_PATH9,\r\n" + " IFNULL(A.IMG_PATH10,'' ) AS IMG_PATH10,\r\n" + " IFNULL(A.IMG_PATH11,'' ) AS IMG_PATH11,\r\n" + " IFNULL(A.IMG_PATH12,'' ) AS IMG_PATH12,\r\n" + " IFNULL(A.IMG_PATH13,'' ) AS IMG_PATH13,\r\n" + " IFNULL(A.IMG_PATH14,'' ) AS IMG_PATH14,\r\n" + " IFNULL(A.IMG_PATH15,'' ) AS IMG_PATH15,\r\n" + " IFNULL(A.IMG_PATH16,'' ) AS IMG_PATH16,\r\n" + " IFNULL(A.IMG_PATH17,'' ) AS IMG_PATH17,\r\n" + " IFNULL(A.IMG_PATH18,'' ) AS IMG_PATH18,\r\n" + " IFNULL(A.IMG_PATH19,'' ) AS IMG_PATH19,\r\n" + " IFNULL(A.IMG_PATH20,'' ) AS IMG_PATH20,\r\n" + " IFNULL(A.IMG_PATH21,'' ) AS IMG_PATH21,\r\n" + " IFNULL(A.IMG_PATH22,'' ) AS IMG_PATH22,\r\n" + " IFNULL(A.IMG_PATH23,'' ) AS IMG_PATH23,\r\n" + " IFNULL(A.IMG_PATH24,'' ) AS IMG_PATH24,\r\n" + " IFNULL(A.GOODS_REMARKS,'' ) AS GOODS_REMARKS,\r\n" + " IFNULL(A.CERTNO,'' ) AS CERTNO,\r\n" + " IFNULL(A.AVLST_DM,'' ) AS AVLST_DM,\r\n" + " IFNULL(A.AVLED_DM,'' ) AS AVLED_DM,\r\n" + " IFNULL(A.ISSUEDATE,'' ) AS ISSUEDATE,\r\n" + " IFNULL(A.CERTDATE,'' ) AS CERTDATE,\r\n" + " IFNULL(A.CERT_AGENCY,'' ) AS CERT_AGENCY,\r\n" + " IFNULL(A.CERTFIELD,'' ) AS CERTFIELD,\r\n" + " IFNULL(A.MATERIAL,'' ) AS MATERIAL,\r\n" + " IFNULL(A.STOCK_USE_YN,'' ) AS STOCK_USE_YN,\r\n" + " IFNULL(A.OPT_TYPE,'' ) AS OPT_TYPE,\r\n" + " IFNULL(A.PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,\r\n" + " IFNULL(A.PROP1_CD,'' ) AS PROP1_CD,\r\n" + " IFNULL(A.PROP_VAL1,'' ) AS PROP_VAL1,\r\n" + " IFNULL(A.PROP_VAL2,'' ) AS PROP_VAL2,\r\n" + " IFNULL(A.PROP_VAL3,'' ) AS PROP_VAL3,\r\n" + " IFNULL(A.PROP_VAL4,'' ) AS PROP_VAL4,\r\n" + " IFNULL(A.PROP_VAL5,'' ) AS PROP_VAL5,\r\n" + " IFNULL(A.PROP_VAL6,'' ) AS PROP_VAL6,\r\n" + " IFNULL(A.PROP_VAL7,'' ) AS PROP_VAL7,\r\n" + " IFNULL(A.PROP_VAL8,'' ) AS PROP_VAL8,\r\n" + " IFNULL(A.PROP_VAL9,'' ) AS PROP_VAL9,\r\n" + " IFNULL(A.PROP_VAL10,'' ) AS PROP_VAL10,\r\n" + " IFNULL(A.PROP_VAL11,'' ) AS PROP_VAL11,\r\n" + " IFNULL(A.PROP_VAL12,'' ) AS PROP_VAL12,\r\n" + " IFNULL(A.PROP_VAL13,'' ) AS PROP_VAL13,\r\n" + " IFNULL(A.PROP_VAL14,'' ) AS PROP_VAL14,\r\n" + " IFNULL(A.PROP_VAL15,'' ) AS PROP_VAL15,\r\n" + " IFNULL(A.PROP_VAL16,'' ) AS PROP_VAL16,\r\n" + " IFNULL(A.PROP_VAL17,'' ) AS PROP_VAL17,\r\n" + " IFNULL(A.PROP_VAL18,'' ) AS PROP_VAL18,\r\n" + " IFNULL(A.PROP_VAL19,'' ) AS PROP_VAL19,\r\n" + " IFNULL(A.PROP_VAL20,'' ) AS PROP_VAL20,\r\n" + " IFNULL(A.PROP_VAL21,'' ) AS PROP_VAL21,\r\n" + " IFNULL(A.PROP_VAL22,'' ) AS PROP_VAL22,\r\n" + " IFNULL(A.PROP_VAL23,'' ) AS PROP_VAL23,\r\n" + " IFNULL(A.PROP_VAL24,'' ) AS PROP_VAL24,\r\n" + " IFNULL(A.PROP_VAL25,'' ) AS PROP_VAL25,\r\n" + " IFNULL(A.PROP_VAL26,'' ) AS PROP_VAL26,\r\n" + " IFNULL(A.PROP_VAL27,'' ) AS PROP_VAL27,\r\n" + " IFNULL(A.PROP_VAL28,'' ) AS PROP_VAL28,\r\n" + " IFNULL(A.PACK_CODE_STR,'' ) AS PACK_CODE_STR,\r\n" + " IFNULL(A.GOODS_NM_EN,'' ) AS GOODS_NM_EN,\r\n" + " IFNULL(A.GOODS_NM_PR,'' ) AS GOODS_NM_PR,\r\n" + " IFNULL(A.GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,\r\n" + " IFNULL(A.GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,\r\n" + " IFNULL(A.GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,\r\n" + " IFNULL(A.IMPORTNO,'' ) AS IMPORTNO,\r\n" + " IFNULL(A.GOODS_COST2,'' ) AS GOODS_COST2,\r\n" + " IFNULL(A.ORIGIN2,'' ) AS ORIGIN2,\r\n" + " IFNULL(A.EXPIRE_DM,'' ) AS EXPIRE_DM,\r\n" + " IFNULL(A.SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,\r\n" + " IFNULL(A.DESCRITION,'' ) AS DESCRITION,\r\n" + " IFNULL(A.INSERTDT,'' ) AS INSERTDT,\r\n" + " IFNULL(A.INSERTID,'' ) AS INSERTID,\r\n" + " IFNULL(A.MODIFYDT,'' ) AS MODIFYDT,\r\n" + " IFNULL(A.MODIFYID,'' ) AS MODIFYID \r\n" + "  FROM SHOPPRODIN AS A \r\n" + "  INNER JOIN shopprodinfo AS B \r\n" + "  ON A.COMPNO = B.COMPNO AND A.PRODSEQ = B.PRODSEQ\r\n" + " WHERE A.COMPNO = ?  AND A.INSERTDT >= ? AND A.INSERTDT <= ? \r\n";
                if (!params.get("SEARCH_GUBUN").isEmpty()) {
                    sql = params.get("SEARCH_GUBUN").equals("PRODSEQ") || params.get("SEARCH_GUBUN").equals("DELV_COST") ? String.valueOf(sql) + String.format(" AND B.%s = %s", params.get("SEARCH_GUBUN"), params.get("SEARCH_TEXT")) : String.valueOf(sql) + String.format(" AND B.%s LIKE '%s%s%s' ", params.get("SEARCH_GUBUN"), "%", params.get("SEARCH_TEXT"), "%");
                }
                sql = String.valueOf(sql) + " ) AS SHOPIN  LEFT JOIN CATEALL AS CATE  \r\n" + "\t\t ON SHOPIN.CLASS_CD1 = CATE.CLASS_CD1  \r\n" + " \t\t AND SHOPIN.CLASS_CD2 = CATE.CLASS_CD2 \r\n" + "AND SHOPIN.CLASS_CD3 = CATE.CLASS_CD3   \r\n" + "AND SHOPIN.CLASS_CD4 = CATE.CLASS_CD4  \r\n";
                if (!params.get("CLASS_CD4").equals("CLASS_CD4")) {
                    sql = String.valueOf(sql) + String.format(" WHERE CODE = '%s'", params.get("CLASS_CD4"));
                } else if (!params.get("CLASS_CD3").equals("CLASS_CD3")) {
                    sql = String.valueOf(sql) + String.format(" WHERE CODE LIKE '%s%s'", params.get("CLASS_CD3"), "%");
                } else if (!params.get("CLASS_CD2").equals("CLASS_CD2")) {
                    sql = String.valueOf(sql) + String.format(" WHERE CODE LIKE '%s%s'", params.get("CLASS_CD2"), "%");
                } else if (!params.get("CLASS_CD1").equals("CLASS_CD1")) {
                    sql = String.valueOf(sql) + String.format(" WHERE CODE LIKE '%s%s'", params.get("CLASS_CD1"), "%");
                }
                if (!params.get("SHOPCD").equals("SHOPCD")) {
                    sql = params.get("CLASS_CD1").equals("CLASS_CD1") ? String.valueOf(sql) + String.format(" WHERE SHOPCD = '%s'", params.get("SHOPCD")) : String.valueOf(sql) + String.format("   AND SHOPCD = '%s'", params.get("SHOPCD"));
                    if (!params.get("SHOPUSER_ID").equals("SHOPUSER_ID")) {
                        sql = String.valueOf(sql) + String.format(" AND SHOPSEQ = '%s'", params.get("SHOPUSER_ID"));
                    }
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, params.get("DATE_FROM"));
                pstmt.setString(3, params.get("DATE_TO"));
                YDMAStringUtil.Print("[getShopMstSelectList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setRowno("" + ++rowno);
                    dto.setSendstats("\uc5f0\ub3d9\uc0dd\uc131");
                    dto.setSHOPNM(rs.getString("SHOPNM"));
                    dto.setSHOP_USERID(rs.getString("SHOPUSERID"));
                    dto.setClass_nm1(rs.getString("CLASS_NM1"));
                    dto.setClass_nm2(rs.getString("CLASS_NM2"));
                    dto.setClass_nm3(rs.getString("CLASS_NM3"));
                    dto.setClass_nm4(rs.getString("CLASS_NM4"));
                    dto.setGoods_gubun_nm(rs.getString("GOODS_GUBUN_NM"));
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setSENDSEQ(rs.getString("SENDSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setShopcatno(rs.getString("SHOPCATNO"));
                    dto.setMarginseq(rs.getString("MARGINSEQ"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year(rs.getString("MAKE_YEAR"));
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season(rs.getString("GOODS_SEASON"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public ProductDTO getShopProductInfo(int prodseq) throws Exception {
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        ProductDTO dto = new ProductDTO();
        new ArrayList();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" WITH CateAll AS(                                                                 \r\n");
                sql.append("\t\tSELECT                                                                    \r\n");
                sql.append("\t\t   ifnull(a.CODE,'')     AS CLASS_CD1 ,                                   \r\n");
                sql.append("\t\t\tifnull(a.CATEGORY,'') AS CLASS_NM1 ,                                  \r\n");
                sql.append("\t\t\tIFNULL(RIGHT(b.CODE,3),'')     AS CLASS_CD2  ,                        \r\n");
                sql.append("\t\t\tifnull(b.CATEGORY,'') AS CLASS_NM2 ,                                  \r\n");
                sql.append("\t\t\tifnull(RIGHT(c.CODE,3),'')     AS CLASS_CD3,                          \r\n");
                sql.append("\t\t\tifnull(C.CATEGORY,'') AS CLASS_NM3,                                   \r\n");
                sql.append("\t\t\tifnull(RIGHT(D.CODE,3),'')     AS CLASS_CD4 ,                         \r\n");
                sql.append("\t\t\tifnull(D.CATEGORY,'') AS CLASS_NM4                                    \r\n");
                sql.append("\t\tFROM CATEGLARGE a left JOIN CATEGMIDIUM b                                      \r\n");
                sql.append("\t\t\tON a.COMPNO=b.COMPNO AND a.CODE = b.LRGCODE left JOIN CATEGSMALL C         \r\n");
                sql.append("\t\t\tON a.COMPNO = C.COMPNO AND b.CODE = C.MIDCODE left JOIN CATEGDETAIL D ON   \r\n");
                sql.append(String.format(" a.COMPNO = D.COMPNO AND C.CODE = D.SMLCODE WHERE a.compno = '%s'         \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                sql.append("\t\t )                                                                        \r\n");
                sql.append(" SELECT INFO.*  , \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM1, '')  CLASS_NM1, \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM2, '')  CLASS_NM2, \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM3, '')  CLASS_NM3, \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM4, '')  CLASS_NM4, \r\n");
                sql.append("(CASE                                   \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '1'         \r\n");
                sql.append("\t     THEN '\uc704\ud0c1\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '2'         \r\n");
                sql.append("\t     THEN '\uc81c\uc870\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '3'         \r\n");
                sql.append("\t     THEN '\uc0ac\uc5c5\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '4'         \r\n");
                sql.append("\t     THEN '\uc9c1\uc601\uc0c1\ud488'                \r\n");
                sql.append("\t     ELSE ''                        \r\n");
                sql.append("\t  END )AS GOODS_GUBUN_NM,            \r\n");
                sql.append("(CASE                            \r\n");
                sql.append("\t     WHEN STATUS = '1'       \r\n");
                sql.append("\t     THEN '\ub300\uae30\uc911'           \r\n");
                sql.append("\t     WHEN STATUS = '2'       \r\n");
                sql.append("\t     THEN '\uacf5\uae09\uc911'           \r\n");
                sql.append("\t     WHEN STATUS = '3'       \r\n");
                sql.append("\t     THEN '\uc77c\uc2dc\uc911\uc9c0'         \r\n");
                sql.append("\t     WHEN STATUS = '4'       \r\n");
                sql.append("\t     THEN '\uc644\uc804\ud488\uc808'         \r\n");
                sql.append("\t      WHEN STATUS = '5'      \r\n");
                sql.append("\t     THEN '\ubbf8\uc0ac\uc6a9'           \r\n");
                sql.append("\t      WHEN STATUS = '6'      \r\n");
                sql.append("\t     THEN '\uc0ad\uc81c'             \r\n");
                sql.append("\t     ELSE ''                 \r\n");
                sql.append("\t  END )AS STATUS_NM,         \r\n");
                sql.append("(CASE                             \r\n");
                sql.append("\t     WHEN DELV_TYPE = '1'     \r\n");
                sql.append("\t     THEN '\ubb34\ub8cc'              \r\n");
                sql.append("\t     WHEN DELV_TYPE = '2'     \r\n");
                sql.append("\t     THEN '\ucc29\ubd88'              \r\n");
                sql.append("\t     WHEN DELV_TYPE = '3'     \r\n");
                sql.append("\t     THEN '\uc120\uacb0\uc81c'            \r\n");
                sql.append("\t     WHEN DELV_TYPE = '4'     \r\n");
                sql.append("\t     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n");
                sql.append("\t     ELSE ''                  \r\n");
                sql.append("\t  END )AS DELV_TYPE_NM       \r\n");
                sql.append(" FROM                             \r\n");
                sql.append(" (SELECT                           \r\n");
                sql.append(" CONCAT(IFNULL(CLASS_CD1,''), IFNULL(CLASS_CD2,''), IFNULL(CLASS_CD3,''), IFNULL(CLASS_CD4,'')) AS CODE, \r\n");
                sql.append("IFNULL(PRODSEQ,'' ) AS PRODSEQ,  \r\n ");
                sql.append("IFNULL(COMPNO,'' ) AS COMPNO,  \r\n ");
                sql.append(" '' as img,  \r\n ");
                sql.append("IFNULL(GOODS_NM,'' ) AS GOODS_NM,  \r\n ");
                sql.append("IFNULL(GOODS_KEYWORD,'' ) AS GOODS_KEYWORD,  \r\n ");
                sql.append("IFNULL(MODEL_NM,'' ) AS MODEL_NM,  \r\n ");
                sql.append("IFNULL(MODEL_NO,'' ) AS MODEL_NO,  \r\n ");
                sql.append("IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n ");
                sql.append("IFNULL(COMPAYNY_GOODS_CD,'' ) AS COMPAYNY_GOODS_CD,  \r\n ");
                sql.append("IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n ");
                sql.append("IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n ");
                sql.append("IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n ");
                sql.append("IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n ");
                sql.append("IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n ");
                sql.append("IFNULL(CLASS_CD4,'' ) AS CLASS_CD4,  \r\n ");
                sql.append("IFNULL(PARTNER_ID,'' ) AS PARTNER_ID,  \r\n ");
                sql.append("IFNULL(DPARTNER_ID,'' ) AS DPARTNER_ID,  \r\n ");
                sql.append("IFNULL(MAKER,'' ) AS MAKER,  \r\n ");
                sql.append("IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n ");
                sql.append("IFNULL(MAKE_YEAR,'' ) AS MAKE_YEAR,  \r\n ");
                sql.append("IFNULL(MAKE_DM,'' ) AS MAKE_DM,  \r\n ");
                sql.append("IFNULL(GOODS_SEASON,'' ) AS GOODS_SEASON,  \r\n ");
                sql.append("IFNULL(SEX,'' ) AS SEX,  \r\n ");
                sql.append("IFNULL(STATUS,'' ) AS STATUS,  \r\n ");
                sql.append("IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n ");
                sql.append("IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n ");
                sql.append("IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n ");
                sql.append("IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n ");
                sql.append("IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n ");
                sql.append("IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n ");
                sql.append("IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n ");
                sql.append("IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n ");
                sql.append("IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n ");
                sql.append("IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n ");
                sql.append("IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n ");
                sql.append("IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n ");
                sql.append("IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n ");
                sql.append("IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n ");
                sql.append("IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n ");
                sql.append("IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n ");
                sql.append("IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n ");
                sql.append("IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n ");
                sql.append("IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n ");
                sql.append("IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n ");
                sql.append("IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n ");
                sql.append("IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n ");
                sql.append("IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n ");
                sql.append("IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n ");
                sql.append("IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n ");
                sql.append("IFNULL(IMG_PATH13,'' ) AS IMG_PATH13,  \r\n ");
                sql.append("IFNULL(IMG_PATH14,'' ) AS IMG_PATH14,  \r\n ");
                sql.append("IFNULL(IMG_PATH15,'' ) AS IMG_PATH15,  \r\n ");
                sql.append("IFNULL(IMG_PATH16,'' ) AS IMG_PATH16,  \r\n ");
                sql.append("IFNULL(IMG_PATH17,'' ) AS IMG_PATH17,  \r\n ");
                sql.append("IFNULL(IMG_PATH18,'' ) AS IMG_PATH18,  \r\n ");
                sql.append("IFNULL(IMG_PATH19,'' ) AS IMG_PATH19,  \r\n ");
                sql.append("IFNULL(IMG_PATH20,'' ) AS IMG_PATH20,  \r\n ");
                sql.append("IFNULL(IMG_PATH21,'' ) AS IMG_PATH21,  \r\n ");
                sql.append("IFNULL(IMG_PATH22,'' ) AS IMG_PATH22,  \r\n ");
                sql.append("IFNULL(IMG_PATH23,'' ) AS IMG_PATH23,  \r\n ");
                sql.append("IFNULL(IMG_PATH24,'' ) AS IMG_PATH24,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n ");
                sql.append("IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,  \r\n ");
                sql.append("IFNULL(CERTMODEL,'' ) AS CERTMODEL,  \r\n ");
                sql.append("IFNULL(CERTNAME,'' ) AS CERTNAME,  \r\n ");
                sql.append("IFNULL(EXEMPTIONTYPE,'' ) AS EXEMPTIONTYPE,  \r\n ");
                sql.append("IFNULL(CERTNO,'' ) AS CERTNO,  \r\n ");
                sql.append("IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n ");
                sql.append("IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n ");
                sql.append("IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n ");
                sql.append("IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n ");
                sql.append("IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n ");
                sql.append("IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n ");
                sql.append("IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n ");
                sql.append("IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n ");
                sql.append("IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n ");
                sql.append("IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n ");
                sql.append("IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n ");
                sql.append("IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n ");
                sql.append("IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n ");
                sql.append("IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n ");
                sql.append("IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n ");
                sql.append("IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n ");
                sql.append("IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n ");
                sql.append("IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n ");
                sql.append("IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n ");
                sql.append("IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n ");
                sql.append("IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n ");
                sql.append("IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n ");
                sql.append("IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n ");
                sql.append("IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n ");
                sql.append("IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n ");
                sql.append("IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n ");
                sql.append("IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n ");
                sql.append("IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n ");
                sql.append("IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n ");
                sql.append("IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n ");
                sql.append("IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n ");
                sql.append("IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n ");
                sql.append("IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n ");
                sql.append("IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n ");
                sql.append("IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n ");
                sql.append("IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n ");
                sql.append("IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n ");
                sql.append("IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n ");
                sql.append("IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n ");
                sql.append("IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n ");
                sql.append("IFNULL(GOODS_NM_EN,'' ) AS GOODS_NM_EN,  \r\n ");
                sql.append("IFNULL(GOODS_NM_PR,'' ) AS GOODS_NM_PR,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,  \r\n ");
                sql.append("IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n ");
                sql.append("IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n ");
                sql.append("IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n ");
                sql.append("IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n ");
                sql.append("IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n ");
                sql.append("IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n ");
                sql.append("IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n ");
                sql.append("IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n ");
                sql.append("IFNULL(INSERTID,'' ) AS INSERTID,  \r\n ");
                sql.append("IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n ");
                sql.append("IFNULL(MODIFYID,'' ) AS MODIFYID  \r\n ");
                sql.append(" FROM SHOPPRODINFO \r\n");
                sql.append(" WHERE COMPNO = ?  AND PRODSEQ = ? \r\n");
                sql.append(" ) AS INFO  LEFT JOIN CateAll AS CATE  \r\n");
                sql.append("\t\t ON INFO.CLASS_CD1 = CATE.CLASS_CD1  \r\n");
                sql.append(" \t\t AND INFO.CLASS_CD2 = CATE.CLASS_CD2 \r\n");
                sql.append("AND INFO.CLASS_CD3 = CATE.CLASS_CD3   \r\n");
                sql.append("AND INFO.CLASS_CD4 = CATE.CLASS_CD4   \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, compno);
                pstmt.setInt(2, prodseq);
                YDMAStringUtil.Print("[getShopProductInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    dto.setRowno("" + ++rowno);
                    dto.setCode(rs.getString("CODE"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setImg(rs.getString("Img"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year(rs.getString("MAKE_YEAR"));
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season(rs.getString("GOODS_SEASON"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCertmodel(rs.getString("CERTMODEL"));
                    dto.setCertname(rs.getString("CERTNAME"));
                    dto.setExemptiontype(rs.getString("EXEMPTIONTYPE"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setClass_nm1(rs.getString("CLASS_NM1"));
                    dto.setClass_nm2(rs.getString("CLASS_NM2"));
                    dto.setClass_nm3(rs.getString("CLASS_NM3"));
                    dto.setClass_nm4(rs.getString("CLASS_NM4"));
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setGoods_gubun_nm(rs.getString("GOODS_GUBUN_NM"));
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ProductDTO> getShopProductChildList(String CTE_PRODLIST) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(CTE_PRODLIST);
                sql.append("\r\n SELECT INFO.*  , \r\n");
                sql.append("(CASE                                   \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '1'         \r\n");
                sql.append("\t     THEN '\uc704\ud0c1\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '2'         \r\n");
                sql.append("\t     THEN '\uc81c\uc870\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '3'         \r\n");
                sql.append("\t     THEN '\uc0ac\uc5c5\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '4'         \r\n");
                sql.append("\t     THEN '\uc9c1\uc601\uc0c1\ud488'                \r\n");
                sql.append("\t     ELSE ''                        \r\n");
                sql.append("\t  END )AS GOODS_GUBUN_NM,            \r\n");
                sql.append("(CASE                            \r\n");
                sql.append("\t     WHEN STATUS = '1'       \r\n");
                sql.append("\t     THEN '\ub300\uae30\uc911'           \r\n");
                sql.append("\t     WHEN STATUS = '2'       \r\n");
                sql.append("\t     THEN '\uacf5\uae09\uc911'           \r\n");
                sql.append("\t     WHEN STATUS = '3'       \r\n");
                sql.append("\t     THEN '\uc77c\uc2dc\uc911\uc9c0'         \r\n");
                sql.append("\t     WHEN STATUS = '4'       \r\n");
                sql.append("\t     THEN '\uc644\uc804\ud488\uc808'         \r\n");
                sql.append("\t      WHEN STATUS = '5'      \r\n");
                sql.append("\t     THEN '\ubbf8\uc0ac\uc6a9'           \r\n");
                sql.append("\t      WHEN STATUS = '6'      \r\n");
                sql.append("\t     THEN '\uc0ad\uc81c'             \r\n");
                sql.append("\t     ELSE ''                 \r\n");
                sql.append("\t  END )AS STATUS_NM,         \r\n");
                sql.append("(CASE                             \r\n");
                sql.append("\t     WHEN DELV_TYPE = '1'     \r\n");
                sql.append("\t     THEN '\ubb34\ub8cc'              \r\n");
                sql.append("\t     WHEN DELV_TYPE = '2'     \r\n");
                sql.append("\t     THEN '\ucc29\ubd88'              \r\n");
                sql.append("\t     WHEN DELV_TYPE = '3'     \r\n");
                sql.append("\t     THEN '\uc120\uacb0\uc81c'            \r\n");
                sql.append("\t     WHEN DELV_TYPE = '4'     \r\n");
                sql.append("\t     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n");
                sql.append("\t     ELSE ''                  \r\n");
                sql.append("\t  END )AS DELV_TYPE_NM       \r\n");
                sql.append(" FROM                             \r\n");
                sql.append(" (SELECT                           \r\n");
                sql.append(" CONCAT(IFNULL(CLASS_CD1,''), IFNULL(CLASS_CD2,''), IFNULL(CLASS_CD3,''), IFNULL(CLASS_CD4,'')) AS CODE, \r\n");
                sql.append("IFNULL(A.SHOPCD,'' ) AS SHOPCD,  \r\n ");
                sql.append("IFNULL(SHOP_USERID,'' ) AS SHOP_USERID,  \r\n ");
                sql.append("IFNULL(PRODSEQ,'' ) AS PRODSEQ,  \r\n ");
                sql.append("IFNULL(COMPNO,'' ) AS COMPNO,  \r\n ");
                sql.append(String.format("YWM_FUNC_BOSSPRODCD(%s,COMPAYNY_GOODS_CD) as img,", YDMASessonUtil.getCompnoInfo().getCompno()));
                sql.append("IFNULL(GOODS_NM,'' ) AS GOODS_NM,  \r\n ");
                sql.append("IFNULL(MODEL_NM,'' ) AS MODEL_NM,  \r\n ");
                sql.append("IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n ");
                sql.append("IFNULL(COMPAYNY_GOODS_CD,'' ) AS COMPAYNY_GOODS_CD,  \r\n ");
                sql.append("IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n ");
                sql.append("IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n ");
                sql.append("IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n ");
                sql.append("IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n ");
                sql.append("IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n ");
                sql.append("IFNULL(CLASS_CD4,'' ) AS CLASS_CD4,  \r\n ");
                sql.append("IFNULL(MAKER,'' ) AS MAKER,  \r\n ");
                sql.append("IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n ");
                sql.append("IFNULL(SEX,'' ) AS SEX,  \r\n ");
                sql.append("IFNULL(STATUS,'' ) AS STATUS,  \r\n ");
                sql.append("IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n ");
                sql.append("IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n ");
                sql.append("IFNULL(CERT,'' ) AS CERT,  \r\n");
                sql.append("IFNULL(ISLIMIT,'' ) AS ISLIMIT,  \r\n");
                sql.append("IFNULL(LIMIT_PRICE,'' ) AS LIMIT_PRICE,  \r\n");
                sql.append("IFNULL(IS_OVERSEAS,'' ) AS IS_OVERSEAS,  \r\n");
                sql.append("IFNULL(ITYPE,'' ) AS ITYPE,              \r\n");
                sql.append("IFNULL(ADULT,'' ) AS ADULT,               \r\n");
                sql.append("IFNULL(ISRETURN,'' ) AS ISRETURN,         \r\n");
                sql.append("IFNULL(TEXT_OPTION,'' ) AS TEXT_OPTION,   \r\n");
                sql.append("IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n ");
                sql.append("IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n ");
                sql.append("IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n ");
                sql.append("IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n ");
                sql.append("IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n ");
                sql.append("IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n ");
                sql.append("IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n ");
                sql.append("IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n ");
                sql.append("IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n ");
                sql.append("IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n ");
                sql.append("IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n ");
                sql.append("IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n ");
                sql.append("IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n ");
                sql.append("IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n ");
                sql.append("IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n ");
                sql.append("IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n ");
                sql.append("IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n ");
                sql.append("IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n ");
                sql.append("IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n ");
                sql.append("IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n ");
                sql.append("IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n ");
                sql.append("IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n ");
                sql.append("IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n ");
                sql.append("IFNULL(IMG_PATH13,'' ) AS IMG_PATH13,  \r\n ");
                sql.append("IFNULL(IMG_PATH14,'' ) AS IMG_PATH14,  \r\n ");
                sql.append("IFNULL(IMG_PATH15,'' ) AS IMG_PATH15,  \r\n ");
                sql.append("IFNULL(IMG_PATH16,'' ) AS IMG_PATH16,  \r\n ");
                sql.append("IFNULL(IMG_PATH17,'' ) AS IMG_PATH17,  \r\n ");
                sql.append("IFNULL(IMG_PATH18,'' ) AS IMG_PATH18,  \r\n ");
                sql.append("IFNULL(IMG_PATH19,'' ) AS IMG_PATH19,  \r\n ");
                sql.append("IFNULL(IMG_PATH20,'' ) AS IMG_PATH20,  \r\n ");
                sql.append("IFNULL(IMG_PATH21,'' ) AS IMG_PATH21,  \r\n ");
                sql.append("IFNULL(IMG_PATH22,'' ) AS IMG_PATH22,  \r\n ");
                sql.append("IFNULL(IMG_PATH23,'' ) AS IMG_PATH23,  \r\n ");
                sql.append("IFNULL(IMG_PATH24,'' ) AS IMG_PATH24,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n ");
                sql.append("IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,  \r\n ");
                sql.append("IFNULL(CERTMODEL,'' ) AS CERTMODEL,  \r\n ");
                sql.append("IFNULL(CERTNAME,'' ) AS CERTNAME,  \r\n ");
                sql.append("IFNULL(EXEMPTIONTYPE,'' ) AS EXEMPTIONTYPE,  \r\n ");
                sql.append("IFNULL(CERTNO,'' ) AS CERTNO,  \r\n ");
                sql.append("IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n ");
                sql.append("IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n ");
                sql.append("IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n ");
                sql.append("IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n ");
                sql.append("IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n ");
                sql.append("IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n ");
                sql.append("IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n ");
                sql.append("IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n ");
                sql.append("IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n ");
                sql.append("IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n ");
                sql.append("IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n ");
                sql.append("IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n ");
                sql.append("IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n ");
                sql.append("IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n ");
                sql.append("IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n ");
                sql.append("IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n ");
                sql.append("IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n ");
                sql.append("IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n ");
                sql.append("IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n ");
                sql.append("IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n ");
                sql.append("IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n ");
                sql.append("IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n ");
                sql.append("IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n ");
                sql.append("IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n ");
                sql.append("IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n ");
                sql.append("IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n ");
                sql.append("IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n ");
                sql.append("IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n ");
                sql.append("IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n ");
                sql.append("IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n ");
                sql.append("IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n ");
                sql.append("IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n ");
                sql.append("IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n ");
                sql.append("IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n ");
                sql.append("IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n ");
                sql.append("IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n ");
                sql.append("IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n ");
                sql.append("IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n ");
                sql.append("IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n ");
                sql.append("IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n ");
                sql.append("IFNULL(GOODS_NM_EN,'' ) AS GOODS_NM_EN,  \r\n ");
                sql.append("IFNULL(GOODS_NM_PR,'' ) AS GOODS_NM_PR,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,  \r\n ");
                sql.append("IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n ");
                sql.append("IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n ");
                sql.append("IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n ");
                sql.append("IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n ");
                sql.append("IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n ");
                sql.append("IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n ");
                sql.append("IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n ");
                sql.append("IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n ");
                sql.append("IFNULL(INSERTID,'' ) AS INSERTID,  \r\n ");
                sql.append("IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n ");
                sql.append("IFNULL(MODIFYID, '' ) AS MODIFYID,  \r\n ");
                sql.append("IFNULL(SEQ, '' ) AS SEQ,  \r\n ");
                sql.append("IFNULL(B.ShopSendStatus, '' ) AS ShopSendStatus, \r\n");
                sql.append("IFNULL(B.SHOPSEQ, '' ) AS SHOPSEQ, \r\n");
                sql.append("IFNULL(B.SENDSEQ,'' ) AS SENDSEQ \r\n ");
                sql.append(" FROM CTE_PRODLIST AS A \r\n INNER JOIN  shopprodin AS B\r\nON A.PRODCD = B.COMPAYNY_GOODS_CD AND A.SHOPCD = B.SHOPCD   WHERE B.COMPNO=? \r\n");
                sql.append(" ) AS INFO \r\n");
                pstmt = connection.prepareStatement(sql.toString());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopProductList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setRowno("" + ++rowno);
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setSHOP_USERID(rs.getString("SHOP_USERID"));
                    dto.setCode(rs.getString("CODE"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setImg(rs.getString("Img"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCertmodel(rs.getString("CERTMODEL"));
                    dto.setCertname(rs.getString("CERTNAME"));
                    dto.setExemptiontype(rs.getString("EXEMPTIONTYPE"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setCert(rs.getString("CERT"));
                    dto.setIslimit(rs.getString("ISLIMIT"));
                    dto.setLimit_price(rs.getString("LIMIT_PRICE"));
                    dto.setIs_overseas(rs.getString("IS_OVERSEAS"));
                    dto.setItype(rs.getString("ITYPE"));
                    dto.setAdult(rs.getString("ADULT"));
                    dto.setIsreturn(rs.getString("ISRETURN"));
                    dto.setText_option(rs.getString("TEXT_OPTION"));
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setGoods_gubun_nm(rs.getString("GOODS_GUBUN_NM"));
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                    dto.setSendstats(rs.getString("ShopSendStatus"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setSENDSEQ(rs.getString("SENDSEQ"));
                    if (YDMASessonUtil.getLoginType() == 2) {
                        String class_cd4 = rs.getString("CLASS_CD4");
                        String class_cd3 = rs.getString("CLASS_CD3");
                        String shop_cid = !class_cd4.isEmpty() ? class_cd4 : class_cd3;
                        String full_cateName = DomesinSessonUtil.get().getFullCateName(shop_cid);
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    } else {
                        List<String> ret = Arrays.asList(dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4());
                        String shop_cid = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining());
                        ret = Arrays.asList(dto.getClass_nm1(), dto.getClass_nm2(), dto.getClass_nm3(), dto.getClass_nm4());
                        String full_cateName = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining(">"));
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    }
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ProductDTO> getShopProductList(String lagcateg, String midcateg, String smlcateg, String detcateg, String categcheck, String pricest, String priceed, String overarea, String tax, String adult, String pricecomp, String express, String option2, String returns, String status2, String prodstatus, String exclusive, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT INFO.*  , \r\n");
                if (YDMASessonUtil.getLoginType() == 0) {
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGLARGE WHERE compno = %s AND CODE = INFO.CLASS_CD1), '')  CLASS_NM1, \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGMIDIUM WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2)), '')  CLASS_NM2,  \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGSMALL WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2,INFO.CLASS_CD3)), '')  CLASS_NM3,  \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGDETAIL WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2,INFO.CLASS_CD3,INFO.CLASS_CD4)), '') as CLASS_NM4, \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                }
                sql.append("(CASE                                   \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '1'         \r\n");
                sql.append("\t     THEN '\uc704\ud0c1\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '2'         \r\n");
                sql.append("\t     THEN '\uc81c\uc870\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '3'         \r\n");
                sql.append("\t     THEN '\uc0ac\uc5c5\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '4'         \r\n");
                sql.append("\t     THEN '\uc9c1\uc601\uc0c1\ud488'                \r\n");
                sql.append("\t     ELSE ''                        \r\n");
                sql.append("\t  END )AS GOODS_GUBUN_NM,            \r\n");
                sql.append("(CASE                            \r\n");
                sql.append("\t     WHEN STATUS = '1'       \r\n");
                sql.append("\t     THEN '\ub300\uae30\uc911'           \r\n");
                sql.append("\t     WHEN STATUS = '2'       \r\n");
                sql.append("\t     THEN '\uacf5\uae09\uc911'           \r\n");
                sql.append("\t     WHEN STATUS = '3'       \r\n");
                sql.append("\t     THEN '\uc77c\uc2dc\uc911\uc9c0'         \r\n");
                sql.append("\t     WHEN STATUS = '4'       \r\n");
                sql.append("\t     THEN '\uc644\uc804\ud488\uc808'         \r\n");
                sql.append("\t      WHEN STATUS = '5'      \r\n");
                sql.append("\t     THEN '\ubbf8\uc0ac\uc6a9'           \r\n");
                sql.append("\t      WHEN STATUS = '6'      \r\n");
                sql.append("\t     THEN '\uc0ad\uc81c'             \r\n");
                sql.append("\t     ELSE ''                 \r\n");
                sql.append("\t  END )AS STATUS_NM,         \r\n");
                sql.append("(CASE                             \r\n");
                sql.append("\t     WHEN DELV_TYPE = '1'     \r\n");
                sql.append("\t     THEN '\ubb34\ub8cc'              \r\n");
                sql.append("\t     WHEN DELV_TYPE = '2'     \r\n");
                sql.append("\t     THEN '\ucc29\ubd88'              \r\n");
                sql.append("\t     WHEN DELV_TYPE = '3'     \r\n");
                sql.append("\t     THEN '\uc120\uacb0\uc81c'            \r\n");
                sql.append("\t     WHEN DELV_TYPE = '4'     \r\n");
                sql.append("\t     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n");
                sql.append("\t     ELSE ''                  \r\n");
                sql.append("\t  END )AS DELV_TYPE_NM       \r\n");
                sql.append(" FROM                             \r\n");
                sql.append(" (SELECT                           \r\n");
                sql.append(" CONCAT(IFNULL(CLASS_CD1,''), IFNULL(CLASS_CD2,''), IFNULL(CLASS_CD3,''), IFNULL(CLASS_CD4,'')) AS CODE, \r\n");
                sql.append("IFNULL(PRODSEQ,'' ) AS PRODSEQ,  \r\n ");
                sql.append("IFNULL(COMPNO,'' ) AS COMPNO,  \r\n ");
                sql.append(String.format("YWM_FUNC_BOSSPRODCD(%s,COMPAYNY_GOODS_CD) as img,", YDMASessonUtil.getCompnoInfo().getCompno()));
                sql.append("IFNULL(GOODS_NM,'' ) AS GOODS_NM,  \r\n ");
                sql.append("IFNULL(GOODS_KEYWORD,'' ) AS GOODS_KEYWORD,  \r\n ");
                sql.append("IFNULL(MODEL_NM,'' ) AS MODEL_NM,  \r\n ");
                sql.append("IFNULL(MODEL_NO,'' ) AS MODEL_NO,  \r\n ");
                sql.append("IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n ");
                sql.append("IFNULL(COMPAYNY_GOODS_CD,'' ) AS COMPAYNY_GOODS_CD,  \r\n ");
                sql.append("IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n ");
                sql.append("IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n ");
                sql.append("IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n ");
                sql.append("IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n ");
                sql.append("IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n ");
                sql.append("IFNULL(CLASS_CD4,'' ) AS CLASS_CD4,  \r\n ");
                sql.append("IFNULL(PARTNER_ID,'' ) AS PARTNER_ID,  \r\n ");
                sql.append("IFNULL(DPARTNER_ID,'' ) AS DPARTNER_ID,  \r\n ");
                sql.append("IFNULL(MAKER,'' ) AS MAKER,  \r\n ");
                sql.append("IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n ");
                sql.append("IFNULL(MAKE_YEAR,'' ) AS MAKE_YEAR,  \r\n ");
                sql.append("IFNULL(MAKE_DM,'' ) AS MAKE_DM,  \r\n ");
                sql.append("IFNULL(GOODS_SEASON,'' ) AS GOODS_SEASON,  \r\n ");
                sql.append("IFNULL(SEX,'' ) AS SEX,  \r\n ");
                sql.append("IFNULL(STATUS,'' ) AS STATUS,  \r\n ");
                sql.append("IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n ");
                sql.append("IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n ");
                sql.append("IFNULL(CERT,'' ) AS CERT,  \r\n");
                sql.append("IFNULL(ISLIMIT,'' ) AS ISLIMIT,  \r\n");
                sql.append("IFNULL(LIMIT_PRICE,'' ) AS LIMIT_PRICE,  \r\n");
                sql.append("IFNULL(IS_OVERSEAS,'' ) AS IS_OVERSEAS,  \r\n");
                sql.append("IFNULL(ITYPE,'' ) AS ITYPE,              \r\n");
                sql.append("IFNULL(ADULT,'' ) AS ADULT,               \r\n");
                sql.append("IFNULL(ISRETURN,'' ) AS ISRETURN,         \r\n");
                sql.append("IFNULL(TEXT_OPTION,'' ) AS TEXT_OPTION,   \r\n");
                sql.append("IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n ");
                sql.append("IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n ");
                sql.append("IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n ");
                sql.append("IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n ");
                sql.append("IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n ");
                sql.append("IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n ");
                sql.append("IFNULL(SELECT_OPTION,'' ) AS SELECT_OPTION,  \r\n ");
                sql.append("IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n ");
                sql.append("IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n ");
                sql.append("IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n ");
                sql.append("IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n ");
                sql.append("IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n ");
                sql.append("IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n ");
                sql.append("IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n ");
                sql.append("IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n ");
                sql.append("IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n ");
                sql.append("IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n ");
                sql.append("IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n ");
                sql.append("IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n ");
                sql.append("IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n ");
                sql.append("IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n ");
                sql.append("IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n ");
                sql.append("IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n ");
                sql.append("IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n ");
                sql.append("IFNULL(IMG_PATH13,'' ) AS IMG_PATH13,  \r\n ");
                sql.append("IFNULL(IMG_PATH14,'' ) AS IMG_PATH14,  \r\n ");
                sql.append("IFNULL(IMG_PATH15,'' ) AS IMG_PATH15,  \r\n ");
                sql.append("IFNULL(IMG_PATH16,'' ) AS IMG_PATH16,  \r\n ");
                sql.append("IFNULL(IMG_PATH17,'' ) AS IMG_PATH17,  \r\n ");
                sql.append("IFNULL(IMG_PATH18,'' ) AS IMG_PATH18,  \r\n ");
                sql.append("IFNULL(IMG_PATH19,'' ) AS IMG_PATH19,  \r\n ");
                sql.append("IFNULL(IMG_PATH20,'' ) AS IMG_PATH20,  \r\n ");
                sql.append("IFNULL(IMG_PATH21,'' ) AS IMG_PATH21,  \r\n ");
                sql.append("IFNULL(IMG_PATH22,'' ) AS IMG_PATH22,  \r\n ");
                sql.append("IFNULL(IMG_PATH23,'' ) AS IMG_PATH23,  \r\n ");
                sql.append("IFNULL(IMG_PATH24,'' ) AS IMG_PATH24,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n ");
                sql.append("IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,  \r\n ");
                sql.append("IFNULL(CERTMODEL,'' ) AS CERTMODEL,  \r\n ");
                sql.append("IFNULL(CERTNAME,'' ) AS CERTNAME,  \r\n ");
                sql.append("IFNULL(EXEMPTIONTYPE,'' ) AS EXEMPTIONTYPE,  \r\n ");
                sql.append("IFNULL(CERTNO,'' ) AS CERTNO,  \r\n ");
                sql.append("IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n ");
                sql.append("IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n ");
                sql.append("IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n ");
                sql.append("IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n ");
                sql.append("IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n ");
                sql.append("IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n ");
                sql.append("IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n ");
                sql.append("IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n ");
                sql.append("IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n ");
                sql.append("IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n ");
                sql.append("IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n ");
                sql.append("IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n ");
                sql.append("IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n ");
                sql.append("IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n ");
                sql.append("IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n ");
                sql.append("IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n ");
                sql.append("IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n ");
                sql.append("IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n ");
                sql.append("IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n ");
                sql.append("IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n ");
                sql.append("IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n ");
                sql.append("IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n ");
                sql.append("IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n ");
                sql.append("IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n ");
                sql.append("IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n ");
                sql.append("IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n ");
                sql.append("IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n ");
                sql.append("IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n ");
                sql.append("IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n ");
                sql.append("IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n ");
                sql.append("IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n ");
                sql.append("IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n ");
                sql.append("IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n ");
                sql.append("IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n ");
                sql.append("IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n ");
                sql.append("IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n ");
                sql.append("IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n ");
                sql.append("IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n ");
                sql.append("IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n ");
                sql.append("IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n ");
                sql.append("IFNULL(GOODS_NM_EN,'' ) AS GOODS_NM_EN,  \r\n ");
                sql.append("IFNULL(GOODS_NM_PR,'' ) AS GOODS_NM_PR,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,  \r\n ");
                sql.append("IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n ");
                sql.append("IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n ");
                sql.append("IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n ");
                sql.append("IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n ");
                sql.append("IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n ");
                sql.append("IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n ");
                sql.append("IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n ");
                sql.append("IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n ");
                sql.append("IFNULL(INSERTID,'' ) AS INSERTID,  \r\n ");
                sql.append("IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n ");
                sql.append("IFNULL(MODIFYID,'' ) AS MODIFYID, \r\n ");
                sql.append("IFNULL(SELFMOD_NO,'' ) AS SELFMOD_NO  \r\n ");
                sql.append(" FROM SHOPPRODINFO \r\n");
                sql.append(" WHERE COMPNO = ?  AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                if (categcheck.equals("N")) {
                    if (!lagcateg.equals("")) {
                        sql.append(" AND CLASS_CD1 = '" + lagcateg + "' \r\n");
                    }
                    if (!midcateg.equals("")) {
                        sql.append(" AND CLASS_CD2 = '" + midcateg + "' \r\n");
                    }
                    if (!smlcateg.equals("")) {
                        sql.append(" AND CLASS_CD3 = '" + smlcateg + "' \r\n");
                    }
                    if (!detcateg.equals("")) {
                        sql.append(" AND CLASS_CD4 = '" + detcateg + "' \r\n");
                    }
                } else {
                    if (!lagcateg.equals("")) {
                        sql.append(" AND CLASS_CD1 <> '" + lagcateg + "' \r\n");
                    }
                    if (!midcateg.equals("")) {
                        sql.append(" AND CLASS_CD2 <> '" + midcateg + "' \r\n");
                    }
                    if (!smlcateg.equals("")) {
                        sql.append(" AND CLASS_CD3 <> '" + smlcateg + "' \r\n");
                    }
                    if (!detcateg.equals("")) {
                        sql.append(" AND CLASS_CD4 <> '" + detcateg + "' \r\n");
                    }
                }
                if (!pricest.equals("") && !priceed.equals("")) {
                    sql.append(" AND GOODS_PRICE >= '" + pricest + "' AND GOODS_PRICE <= '" + priceed + "' \r\n");
                }
                if (!overarea.equals("")) {
                    sql.append(" AND IS_OVERSEAS = '" + overarea + "' \r\n");
                }
                if (!tax.equals("")) {
                    sql.append(" AND TAX_YN = '" + tax + "' \r\n");
                }
                if (!adult.equals("")) {
                    sql.append(" AND ADULT = '" + adult + "' \r\n");
                }
                if (!pricecomp.equals("")) {
                    sql.append(" AND ISLIMIT = '" + pricecomp + "' \r\n");
                }
                if (!express.equals("")) {
                    sql.append(" AND DELV_TYPE = '" + express + "' \r\n");
                }
                if (option2.equals("0")) {
                    sql.append(" AND CHAR_1_NM = '\ub2e8\ud488' \r\n");
                }
                if (option2.equals("1")) {
                    sql.append(" AND CHAR_1_NM <> '\ub2e8\ud488' \r\n");
                }
                if (!returns.equals("")) {
                    sql.append(" AND ISRETURN = '" + returns + "' \r\n");
                }
                if (!prodstatus.equals("")) {
                    sql.append(" AND ITYPE = '" + prodstatus + "' \r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                sql.append(" ) AS INFO \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, prodFrom);
                pstmt.setString(3, prodTo);
                pstmt.setString(4, prodFrom);
                pstmt.setString(5, prodTo);
                YDMAStringUtil.Print("[getShopProductList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setRowno("" + ++rowno);
                    dto.setCode(rs.getString("CODE"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setImg(rs.getString("Img"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year(rs.getString("MAKE_YEAR"));
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season(rs.getString("GOODS_SEASON"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setSelect_option(rs.getString("SELECT_OPTION"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCertmodel(rs.getString("CERTMODEL"));
                    dto.setCertname(rs.getString("CERTNAME"));
                    dto.setExemptiontype(rs.getString("EXEMPTIONTYPE"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setCert(rs.getString("CERT"));
                    dto.setIslimit(rs.getString("ISLIMIT"));
                    dto.setLimit_price(rs.getString("LIMIT_PRICE"));
                    dto.setIs_overseas(rs.getString("IS_OVERSEAS"));
                    dto.setItype(rs.getString("ITYPE"));
                    dto.setAdult(rs.getString("ADULT"));
                    dto.setIsreturn(rs.getString("ISRETURN"));
                    dto.setText_option(rs.getString("TEXT_OPTION"));
                    if (YDMASessonUtil.getLoginType() == 0) {
                        dto.setClass_nm1(rs.getString("CLASS_NM1"));
                        dto.setClass_nm2(rs.getString("CLASS_NM2"));
                        dto.setClass_nm3(rs.getString("CLASS_NM3"));
                        dto.setClass_nm4(rs.getString("CLASS_NM4"));
                    }
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setGoods_gubun_nm(rs.getString("GOODS_GUBUN_NM"));
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                    dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                    if (YDMASessonUtil.getLoginType() == 2) {
                        String class_cd4 = rs.getString("CLASS_CD4");
                        String class_cd3 = rs.getString("CLASS_CD3");
                        String shop_cid = !class_cd4.isEmpty() ? class_cd4 : class_cd3;
                        String full_cateName = DomesinSessonUtil.get().getFullCateName(shop_cid);
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    } else {
                        List<String> ret = Arrays.asList(dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4());
                        String shop_cid = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining());
                        ret = Arrays.asList(dto.getClass_nm1(), dto.getClass_nm2(), dto.getClass_nm3(), dto.getClass_nm4());
                        String full_cateName = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining(">"));
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    }
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void setProductMstShopcode(List<List<String>> contents, List<List<String>> allContents) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql_prodmst = " Update shopprodin set MODIFYDT = ? , \t\t\t\t\t     MODIFYID = ?   where SENDSEQ = ?     and compno = ? ";
                PreparedStatement pstmt = connection.prepareStatement(sql_prodmst);
                statementlist.add(pstmt);
                int i = 0;
                while (i < contents.size()) {
                    List<String> alllist = allContents.get(i);
                    int idx = 0;
                    pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++idx, alllist.get(0));
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    ++i;
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setProductErrInsert(ShopProductSendDto dtos) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO shopproderr\r\n ( COMPNO, SHOPCD, SHOPSEQ, PRODSEQ, SEQ, SHOPCATNO, DESCRITION, INSERTDT, INSERTID, FAILCONTENT )\r\n VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) ";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                List<ProductDTO> prodList = dtos.getShopProductDto();
                ShopProductAdditionDto shopProductAdditionDto = dtos.getProductAdditionDto();
                ShoppingmallDTO shoppingmallDTO = dtos.getShoppingmallDTO();
                for (ProductDTO dto : prodList) {
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, shoppingmallDTO.getSHOPCD());
                    pstmt.setInt(3, shoppingmallDTO.getSHOPSEQ());
                    pstmt.setString(4, dto.getPRODSEQ());
                    pstmt.setString(5, shopProductAdditionDto.getSeq());
                    if (dto.getShopCatInDto() == null) {
                        pstmt.setString(6, "");
                    } else {
                        pstmt.setString(6, dto.getShopCatInDto().getShopcatno());
                    }
                    pstmt.setString(7, "");
                    pstmt.setString(8, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(9, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(10, dto.getResult_text());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setProductErrInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setProductInUpate(ShopProductSendDto dtos) throws Exception {
        block7: {
            Connection connection = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    ProductDTO dto = (ProductDTO)((Object)dtos.getShopProductDto());
                    if (dtos.getIsshopprodin()) {
                        String sql = "update shopprodin    set shopprodno = ?, MODIFYDT = ?, MODIFYID = ?  where sendseq= ?    and compno = ? ";
                        sql = sql.toUpperCase();
                        pstmt = connection.prepareStatement(sql);
                        pstmt.setString(1, dto.getShopprodno());
                        pstmt.setString(2, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(3, YDMASessonUtil.getUserInfo().getUserId());
                        pstmt.setString(4, dto.getSENDSEQ());
                        pstmt.setString(5, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.executeUpdate();
                    } else {
                        this.setProductInUpdate(dto, dto.getSENDSEQ(), "shopprodin");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setProductInInsert(ShopProductSendDto dtos) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                int result = this.setShopProductInInsert(dtos);
                if (result > 0) {
                    String sql = "SELECT 1 FROM Shop_OptProdInfo where prodseq = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    List<ProductDTO> prodList = dtos.getShopProductDto();
                    ShoppingmallDTO shoppingmallDTO = dtos.getShoppingmallDTO();
                    for (ProductDTO dto : prodList) {
                        int count = 0;
                        pstmt.setString(1, dto.getPRODSEQ());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            count = rs.getInt(1);
                        }
                        if (count <= 0) continue;
                        this.setShopOptProductInInsert(dto, shoppingmallDTO.getSHOPCD(), shoppingmallDTO.getSHOPSEQ());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int setShopProductInInsert(ShopProductSendDto dtos) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO shopprodin\r\n(\r\n\tCOMPNO, SHOPCD, SHOPSEQ, PRODSEQ, SHOPPRODNO, SEQ, SHOPCATNO,GOODS_NM, GOODS_KEYWORD, MODEL_NM, MODEL_NO, BRAND_NM, \r\n\tCOMPAYNY_GOODS_CD, GOODS_SEARCH, GOODS_GUBUN, CLASS_CD1, CLASS_CD2, CLASS_CD3, CLASS_CD4, PARTNER_ID, DPARTNER_ID, MAKER,\r\n\tORIGIN, MAKE_YEAR, MAKE_DM, GOODS_SEASON, SEX, `STATUS`, DELIV_ABLE_REGION, TAX_YN, DELV_TYPE, DELV_COST, BANPUM_AREA, GOODS_COST, \r\n\tGOODS_PRICE, GOODS_CONSUMER_PRICE, CHAR_1_NM, CHAR_1_VAL, CHAR_2_NM, CHAR_2_VAL, IMG_PATH, IMG_PATH1, IMG_PATH2, IMG_PATH3, \r\n\tIMG_PATH4, IMG_PATH5, IMG_PATH6, IMG_PATH7, IMG_PATH8, IMG_PATH9, IMG_PATH10, IMG_PATH11, IMG_PATH12, IMG_PATH13, IMG_PATH14,\r\n\tIMG_PATH15, IMG_PATH16, IMG_PATH17, IMG_PATH18, IMG_PATH19, IMG_PATH20, IMG_PATH21, IMG_PATH22, IMG_PATH23, IMG_PATH24,\r\n\tGOODS_REMARKS, CERTNO, AVLST_DM, AVLED_DM, ISSUEDATE, CERTDATE, CERT_AGENCY, CERTFIELD, MATERIAL, STOCK_USE_YN, OPT_TYPE, PROP_EDIT_YN, \r\n\tPROP1_CD, PROP_VAL1, PROP_VAL2, PROP_VAL3, PROP_VAL4, PROP_VAL5, PROP_VAL6, PROP_VAL7, PROP_VAL8, PROP_VAL9, PROP_VAL10, \r\n\tPROP_VAL11, PROP_VAL12, PROP_VAL13, PROP_VAL14, PROP_VAL15, PROP_VAL16, PROP_VAL17, PROP_VAL18, PROP_VAL19, PROP_VAL20,\r\n\tPROP_VAL21, PROP_VAL22, PROP_VAL23, PROP_VAL24, PROP_VAL25, PROP_VAL26, PROP_VAL27, PROP_VAL28, PACK_CODE_STR, GOODS_NM_EN,\r\n\tGOODS_NM_PR, GOODS_REMARKS2, GOODS_REMARKS3, GOODS_REMARKS4, IMPORTNO, GOODS_COST2, ORIGIN2, EXPIRE_DM, SUPPLY_SAVE_YN, \r\n\tDESCRITION, INSERTDT, INSERTID\r\n)\r\nSELECT \r\nCOMPNO,\r\n? ,  -- SHOPCD\r\n? , -- ID \uc21c\ubc88\r\nPRODSEQ,\r\n? ,  -- \uc1fc\ud551\ubab0 \uc644\ub8cc \ubc88\ud638\r\n?,   -- \ubd80\uac00\uc815\ubcf4\ucf54\ub4dc ..   SHOPDEL SEQ\r\n?,   -- \uce74\ud14c\uace0\ub9ac\uc815\ubcf4\ucf54\ub4dc ..   SHOPCATINF SHOPCATNO\r\nGOODS_NM, \r\nGOODS_KEYWORD, MODEL_NM, MODEL_NO, BRAND_NM, \r\nCOMPAYNY_GOODS_CD, GOODS_SEARCH, GOODS_GUBUN, CLASS_CD1, CLASS_CD2, CLASS_CD3, CLASS_CD4, PARTNER_ID, DPARTNER_ID, MAKER, \r\nORIGIN, MAKE_YEAR, MAKE_DM, GOODS_SEASON, SEX, `STATUS`, DELIV_ABLE_REGION, TAX_YN, DELV_TYPE, DELV_COST, BANPUM_AREA, GOODS_COST,\r\nGOODS_PRICE, GOODS_CONSUMER_PRICE, CHAR_1_NM, CHAR_1_VAL, CHAR_2_NM, CHAR_2_VAL, IMG_PATH, IMG_PATH1, IMG_PATH2, IMG_PATH3,\r\nIMG_PATH4, IMG_PATH5, IMG_PATH6, IMG_PATH7, IMG_PATH8, IMG_PATH9, IMG_PATH10, IMG_PATH11, IMG_PATH12, IMG_PATH13, IMG_PATH14,\r\nIMG_PATH15, IMG_PATH16, IMG_PATH17, IMG_PATH18, IMG_PATH19, IMG_PATH20, IMG_PATH21, IMG_PATH22, IMG_PATH23, IMG_PATH24, \r\nGOODS_REMARKS, CERTNO, AVLST_DM, AVLED_DM, ISSUEDATE, CERTDATE, CERT_AGENCY, CERTFIELD, MATERIAL, STOCK_USE_YN, OPT_TYPE, PROP_EDIT_YN, \r\nPROP1_CD, PROP_VAL1, PROP_VAL2, PROP_VAL3, PROP_VAL4, PROP_VAL5, PROP_VAL6, PROP_VAL7, PROP_VAL8, PROP_VAL9, PROP_VAL10,\r\nPROP_VAL11, PROP_VAL12, PROP_VAL13, PROP_VAL14, PROP_VAL15, PROP_VAL16, PROP_VAL17, PROP_VAL18, PROP_VAL19, PROP_VAL20,\r\nPROP_VAL21, PROP_VAL22, PROP_VAL23, PROP_VAL24, PROP_VAL25, PROP_VAL26, PROP_VAL27, PROP_VAL28, PACK_CODE_STR, GOODS_NM_EN, \r\nGOODS_NM_PR, GOODS_REMARKS2, GOODS_REMARKS3, GOODS_REMARKS4, IMPORTNO, GOODS_COST2, ORIGIN2, EXPIRE_DM, SUPPLY_SAVE_YN,\r\nDESCRITION, NOW(), ?   -- \uc0ac\uc6a9\uc790 \uc544\uc774\ub514.. \r\nFROM SHOPPRODINFO \r\nWHERE COMPNO = ? AND PRODSEQ = ? AND COMPAYNY_GOODS_CD = ?";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                List<ProductDTO> prodList = dtos.getShopProductDto();
                ShopProductAdditionDto shopProductAdditionDto = dtos.getProductAdditionDto();
                ShoppingmallDTO shoppingmallDTO = dtos.getShoppingmallDTO();
                for (ProductDTO dto : prodList) {
                    pstmt.setString(1, shoppingmallDTO.getSHOPCD());
                    pstmt.setInt(2, shoppingmallDTO.getSHOPSEQ());
                    pstmt.setString(3, dto.getShopprodno());
                    pstmt.setString(4, shopProductAdditionDto.getSeq());
                    pstmt.setString(5, dto.getShopCatInDto().getShopcatno());
                    pstmt.setString(6, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(7, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(8, dto.getPRODSEQ());
                    pstmt.setString(9, dto.getCompayny_goods_cd());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setShopProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int setShopProductInInsertThread(ShopProductSendDto dtos) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO shopprodin\r\n(\r\n\tCOMPNO, SHOPCD, SHOPSEQ, PRODSEQ, SHOPPRODNO, SEQ, SHOPCATNO, SHOPSENDSTATUS ,GOODS_NM, GOODS_KEYWORD, MODEL_NM, BRAND_NM, \r\n\tCOMPAYNY_GOODS_CD, GOODS_SEARCH, GOODS_GUBUN, CLASS_CD1, CLASS_CD2, CLASS_CD3, CLASS_CD4, PARTNER_ID, DPARTNER_ID, MAKER,\r\n\tORIGIN, MAKE_YEAR, MAKE_DM, GOODS_SEASON, SEX, `STATUS`, DELIV_ABLE_REGION, TAX_YN, DELV_TYPE, DELV_COST, BANPUM_AREA, GOODS_COST, \r\n\tGOODS_PRICE, GOODS_CONSUMER_PRICE, ISLIMIT, LIMIT_PRICE, IS_OVERSEAS, ADULT, ISRETURN, ITYPE, \r\n CHAR_1_NM, CHAR_1_VAL, CHAR_2_NM, CHAR_2_VAL, IMG_PATH, IMG_PATH1, IMG_PATH2, IMG_PATH3, \r\n\tIMG_PATH4, IMG_PATH5, IMG_PATH6, IMG_PATH7, IMG_PATH8, IMG_PATH9, IMG_PATH10, IMG_PATH11, IMG_PATH12, IMG_PATH13, IMG_PATH14,\r\n\tIMG_PATH15, IMG_PATH16, IMG_PATH17, IMG_PATH18, IMG_PATH19, IMG_PATH20, IMG_PATH21, IMG_PATH22, IMG_PATH23, IMG_PATH24,\r\n\tGOODS_REMARKS, CERTNO, AVLST_DM, AVLED_DM, ISSUEDATE, CERTDATE, CERT_AGENCY, CERTFIELD, MATERIAL, STOCK_USE_YN, OPT_TYPE, PROP_EDIT_YN, \r\n\tPROP1_CD, PROP_VAL1, PROP_VAL2, PROP_VAL3, PROP_VAL4, PROP_VAL5, PROP_VAL6, PROP_VAL7, PROP_VAL8, PROP_VAL9, PROP_VAL10, \r\n\tPROP_VAL11, PROP_VAL12, PROP_VAL13, PROP_VAL14, PROP_VAL15, PROP_VAL16, PROP_VAL17, PROP_VAL18, PROP_VAL19, PROP_VAL20,\r\n\tPROP_VAL21, PROP_VAL22, PROP_VAL23, PROP_VAL24, PROP_VAL25, PROP_VAL26, PROP_VAL27, PROP_VAL28, PACK_CODE_STR, GOODS_NM_EN,\r\n\tGOODS_NM_PR, GOODS_REMARKS2, GOODS_REMARKS3, GOODS_REMARKS4, IMPORTNO, GOODS_COST2, ORIGIN2, EXPIRE_DM, SUPPLY_SAVE_YN, \r\n\tDESCRITION, INSERTDT, INSERTID \r\n)\r\nSELECT \r\nCOMPNO,\r\n? ,  -- SHOPCD\r\n? , -- ID \uc21c\ubc88\r\nPRODSEQ,\r\n? ,  -- \uc1fc\ud551\ubab0 \uc644\ub8cc \ubc88\ud638\r\n?,   -- \ubd80\uac00\uc815\ubcf4\ucf54\ub4dc ..   SHOPDEL SEQ\r\n?,   -- \uce74\ud14c\uace0\ub9ac\uc815\ubcf4\ucf54\ub4dc ..   SHOPCATINF SHOPCATNO\r\n ?,  \r\nGOODS_NM, \r\nGOODS_KEYWORD, MODEL_NM, BRAND_NM, \r\nCOMPAYNY_GOODS_CD, GOODS_SEARCH, GOODS_GUBUN, CLASS_CD1, CLASS_CD2, CLASS_CD3, CLASS_CD4, PARTNER_ID, DPARTNER_ID, MAKER, \r\nORIGIN, MAKE_YEAR, MAKE_DM, GOODS_SEASON, SEX, `STATUS`, DELIV_ABLE_REGION, TAX_YN, DELV_TYPE, DELV_COST, BANPUM_AREA, GOODS_COST,\r\nGOODS_PRICE, GOODS_CONSUMER_PRICE, ISLIMIT, LIMIT_PRICE, IS_OVERSEAS, ADULT, ISRETURN, ITYPE, \r\n  CHAR_1_NM, CHAR_1_VAL, CHAR_2_NM, CHAR_2_VAL, IMG_PATH, IMG_PATH1, IMG_PATH2, IMG_PATH3,\r\nIMG_PATH4, IMG_PATH5, IMG_PATH6, IMG_PATH7, IMG_PATH8, IMG_PATH9, IMG_PATH10, IMG_PATH11, IMG_PATH12, IMG_PATH13, IMG_PATH14,\r\nIMG_PATH15, IMG_PATH16, IMG_PATH17, IMG_PATH18, IMG_PATH19, IMG_PATH20, IMG_PATH21, IMG_PATH22, IMG_PATH23, IMG_PATH24, \r\nGOODS_REMARKS, CERTNO, AVLST_DM, AVLED_DM, ISSUEDATE, CERTDATE, CERT_AGENCY, CERTFIELD, MATERIAL, STOCK_USE_YN, OPT_TYPE, PROP_EDIT_YN, \r\nPROP1_CD, PROP_VAL1, PROP_VAL2, PROP_VAL3, PROP_VAL4, PROP_VAL5, PROP_VAL6, PROP_VAL7, PROP_VAL8, PROP_VAL9, PROP_VAL10,\r\nPROP_VAL11, PROP_VAL12, PROP_VAL13, PROP_VAL14, PROP_VAL15, PROP_VAL16, PROP_VAL17, PROP_VAL18, PROP_VAL19, PROP_VAL20,\r\nPROP_VAL21, PROP_VAL22, PROP_VAL23, PROP_VAL24, PROP_VAL25, PROP_VAL26, PROP_VAL27, PROP_VAL28, PACK_CODE_STR, GOODS_NM_EN, \r\nGOODS_NM_PR, GOODS_REMARKS2, GOODS_REMARKS3, GOODS_REMARKS4, IMPORTNO, GOODS_COST2, ORIGIN2, EXPIRE_DM, SUPPLY_SAVE_YN,\r\nDESCRITION, NOW(), ? -- \uc0ac\uc6a9\uc790 \uc544\uc774\ub514..\r\nFROM SHOPPRODINFO \r\nWHERE COMPNO = ? AND PRODSEQ = ? AND COMPAYNY_GOODS_CD = ?";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                List<ProductDTO> prodList = dtos.getShopProductDto();
                ShopProductAdditionDto shopProductAdditionDto = dtos.getProductAdditionDto();
                ShoppingmallDTO shoppingmallDTO = dtos.getShoppingmallDTO();
                for (ProductDTO dto : prodList) {
                    pstmt.setString(1, shoppingmallDTO.getSHOPCD());
                    pstmt.setInt(2, shoppingmallDTO.getSHOPSEQ());
                    pstmt.setString(3, dto.getShopprodno());
                    pstmt.setString(4, shopProductAdditionDto.getSeq());
                    pstmt.setString(5, dto.getShopCid());
                    if (dto.getResult_code().equals("1")) {
                        pstmt.setString(6, "8000");
                    } else {
                        pstmt.setString(6, "-9000");
                    }
                    pstmt.setString(7, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(8, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(9, dto.getPRODSEQ());
                    pstmt.setString(10, dto.getCompayny_goods_cd());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setShopProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public void setShopOptProductInInsert(ProductDTO dto, String shopcd, int shopseq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO shop_optprodin(SENDSEQ,SHOPPRODNO,SHOPPRODSKU,SHOPPRODSKU_NM,\r\n PRODSEQ,SKUSEQ,COMPNO,OPTPRODCD,OPTPRODNM,OPTSPECDES,OPTEA,OPTSALE,OPTSALEOUT,OPTNOTUSE,OPTSAFESTOCK,OPTVERTSTOCK,OPTADDAMT,\r\n OPTDELYN,BARCODE,INSERTDT,INSERTID) \r\nSELECT ? , -- ShopProdIn \uc790\ub3d9\ubd80\uc5ec \uc77c\ub828\ubc88\ud638 \r\n? ,  -- \uc1fc\ud551\ubab0\uc0c1\ud488\ucf54\ub4dc \r\n? ,  -- \uc1fc\ud551\ubab0\uc0c1\ud488\ub2e8\ud488\ucf54\ub4dc \r\n? ,  -- \uc1fc\ud551\ubab0\uc0c1\ud488\ub2e8\ud488\uba85\uce6d \r\nPRODSEQ,SKUSEQ,COMPNO,OPTPRODCD,OPTPRODNM,OPTSPECDES,OPTEA,OPTSALE,OPTSALEOUT,OPTNOTUSE,OPTSAFESTOCK,OPTVERTSTOCK,OPTADDAMT,\r\nOPTDELYN,BARCODE,?,? \r\n  FROM shop_optprodinfo\r\n WHERE prodseq=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int sendseq = this.getSendseqFromShopProdin(dto, shopcd, shopseq);
                if (sendseq > 0) {
                    pstmt.setInt(1, sendseq);
                    pstmt.setString(2, dto.getShopprodno());
                    pstmt.setString(3, "");
                    pstmt.setString(4, "");
                    pstmt.setString(5, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(6, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(7, dto.getPRODSEQ());
                    pstmt.executeUpdate();
                }
                YDMAStringUtil.Print("[setShopOptProductInInsert]" + pstmt.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int getSendseqFromShopProdin(ProductDTO dto, String shopcd, int shopseq) throws Exception {
        int sendseq;
        block6: {
            sendseq = 0;
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "SELECT sendseq  FROM ShopProdin \r\n where compno= ?  \r\n   and shopcd=?  \r\n   and shopseq=?  \r\n   and prodseq=?  \r\n   and shopprodno=?  \r\n";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, shopcd);
                    pstmt.setInt(3, shopseq);
                    pstmt.setString(4, dto.getPRODSEQ());
                    pstmt.setString(5, dto.getShopprodno());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        sendseq = rs.getInt(1);
                    }
                    YDMAStringUtil.Print("[getSendseqFromShopProdin]" + pstmt.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return sendseq;
    }

    public List<ProductDTO> getShopProdInList(int option2, String prodFrom, String prodTo, String lagcateg, String midcateg, String smlcateg, String detcateg, String shopnm, String shopid, String purch, String logis, String orderIvtr, String shopfee, String sex, String season, String prod, String prodststsd, String prodststpr, String price2, String prodnm, String yorN, String bundle, String searchgubun, String search) throws Exception {
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(A.shopcd,'') , IFNULL(A.shopseq,''), IFNULL(A.sendseq,'0'), \t\t IFNULL(A.INSERTDT,''),IFNULL(A.MODIFYDT,''), IFNULL(A.seq,'0'),IFNULL(A.SHOPPRODNO,''),\t\t IFNULL(A.prodseq,''), \t\t IFNULL(A.COMPAYNY_GOODS_CD,''), IFNULL(A.GOODS_NM,''), IFNULL(A.CLASS_CD1,''), \t\t IFNULL(A.CLASS_CD2,''), IFNULL(A.CLASS_CD3,''), IFNULL(A.CLASS_CD4,''),IFNULL(A.GOODS_GUBUN,''), \t\t IFNULL(A.PARTNER_ID,'') ,IFNULL(A.MODEL_NM,''), IFNULL(A.BRAND_NM,''), IFNULL(A.MAKER,''), \t\t IFNULL(A.DELV_TYPE,''), IFNULL(A.DELV_COST,'0'), IFNULL(A.STATUS,''), \t\t IFNULL(A.GOODS_PRICE,'0'), IFNULL(A.GOODS_COST,'0'),IFNULL(B.SHOPPINGID,''), \t\t IFNULL(B.PASSWORD,'')   FROM shopprodin AS A \t\t LEFT JOIN shopdtl AS B ON A.COMPNO = B.COMPNO AND A.SHOPCD = B.SHOPCD AND A.SHOPSEQ = B.SHOPSEQ  where A.compno = ? ";
                sql = option2 == 0 ? String.valueOf(sql) + " and A.insertdt >= ? and A.insertdt <= ? " : String.valueOf(sql) + " and A.MODIFYDT >= ? and A.MODIFYDT <= ? ";
                sql = String.valueOf(sql) + " ORDER by A.INSERTDT desc ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, prodFrom);
                pstmt.setString(3, prodTo);
                YDMAStringUtil.Print("[getShopProdInList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    int i = 0;
                    ProductDTO dto = new ProductDTO();
                    dto.setRowno("" + ++rowno);
                    dto.setSendstats("\uc5f0\ub3d9\uc0dd\uc131");
                    dto.setShopcd(rs.getString(++i));
                    dto.setShopseq(rs.getString(++i));
                    dto.setSENDSEQ(rs.getString(++i));
                    dto.setInsertdt(rs.getString(++i));
                    dto.setModifydt(rs.getString(++i));
                    dto.setSeq(rs.getString(++i));
                    dto.setShopprodno(rs.getString(++i));
                    dto.setPRODSEQ(rs.getString(++i));
                    dto.setCompayny_goods_cd(rs.getString(++i));
                    dto.setGoods_nm(rs.getString(++i));
                    dto.setClass_cd1(rs.getString(++i));
                    dto.setClass_cd2(rs.getString(++i));
                    dto.setClass_cd3(rs.getString(++i));
                    dto.setClass_cd4(rs.getString(++i));
                    dto.setGoods_gubun(rs.getString(++i));
                    dto.setPartner_id(rs.getString(++i));
                    dto.setModel_nm(rs.getString(++i));
                    dto.setBrand_nm(rs.getString(++i));
                    dto.setMaker(rs.getString(++i));
                    dto.setDelv_type(rs.getString(++i));
                    dto.setDelv_cost(rs.getString(++i));
                    dto.setStatus(rs.getString(++i));
                    dto.setGoods_price(rs.getString(++i));
                    dto.setGoods_cost(rs.getString(++i));
                    dto.setShopid(rs.getString(++i));
                    dto.setShoppw(rs.getString(++i));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void setProductErrInsert(List<List<String>> contents, List<List<String>> allContents, List<String> dtllist, List<String> idlist) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " insert into shopproderr (compno, SHOPCD, SHOPSEQ,  PRODSEQ, seq,GOODS_NM, GOODS_KEYWORD, MODEL_NM, MODEL_NO, BRAND_NM, COMPAYNY_GOODS_CD, GOODS_SEARCH, GOODS_GUBUN, CLASS_CD1,  CLASS_CD2,CLASS_CD3, CLASS_CD4, PARTNER_ID,  DPARTNER_ID, MAKER, ORIGIN, MAKE_YEAR, MAKE_DM, GOODS_SEASON, SEX, STATUS, DELIV_ABLE_REGION, TAX_YN,DELV_TYPE,DELV_COST,BANPUM_AREA,  GOODS_COST,GOODS_PRICE, GOODS_CONSUMER_PRICE, CHAR_1_NM,  CHAR_1_VAL, CHAR_2_NM, CHAR_2_VAL, IMG_PATH, IMG_PATH1, IMG_PATH2, IMG_PATH3, IMG_PATH4, IMG_PATH5, IMG_PATH6,IMG_PATH7,IMG_PATH8,  IMG_PATH9,IMG_PATH10, IMG_PATH11, IMG_PATH12,  IMG_PATH13, IMG_PATH14, IMG_PATH15, IMG_PATH16, IMG_PATH17, IMG_PATH18, IMG_PATH19, IMG_PATH20, IMG_PATH21, IMG_PATH22,IMG_PATH23,IMG_PATH24,  GOODS_REMARKS,CERTNO, AVLST_DM, AVLED_DM, ISSUEDATE, CERTDATE, CERT_AGENCY, CERTFIELD, MATERIAL, STOCK_USE_YN, OPT_TYPE, PROP_EDIT_YN, PROP1_CD, PROP_VAL1,PROP_VAL2,PROP_VAL3, PROP_VAL4,  PROP_VAL5,PROP_VAL6, PROP_VAL7, PROP_VAL8, PROP_VAL9, PROP_VAL10, PROP_VAL11, PROP_VAL12, PROP_VAL13, PROP_VAL14, PROP_VAL15, PROP_VAL16, PROP_VAL17, PROP_VAL18,PROP_VAL19,PROP_VAL20, PROP_VAL21,  PROP_VAL22,PROP_VAL23, PROP_VAL24, PROP_VAL25, PROP_VAL26, PROP_VAL27, PROP_VAL28, PACK_CODE_STR, GOODS_NM_EN, GOODS_NM_PR, GOODS_REMARKS2, GOODS_REMARKS3, GOODS_REMARKS4, IMPORTNO,  GOODS_COST2,ORIGIN2, EXPIRE_DM, SUPPLY_SAVE_YN,DESCRITION, FAILCONTENT, INSERTDT,INSERTID ) VALUES(? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,?, ? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,?,  ? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ) ";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                while (i < contents.size()) {
                    List<String> alllist = allContents.get(i);
                    int idx = 0;
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++idx, idlist.get(1));
                    pstmt.setString(++idx, idlist.get(2));
                    pstmt.setString(++idx, alllist.get(0));
                    pstmt.setString(++idx, dtllist.get(2));
                    int k = 3;
                    while (k <= 114) {
                        if (k == 114) {
                            pstmt.setString(++idx, contents.get(i).get(1));
                        } else {
                            pstmt.setString(++idx, alllist.get(k - 1));
                        }
                        ++k;
                    }
                    pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    ++i;
                }
                YDMAStringUtil.Print("[setProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<ProductDTO> getShopProdErrorList(Map<String, String> params) throws Exception {
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "WITH CATEALL AS(                                                                 \r\n\t\tSELECT                                                                    \r\n\t\t   IFNULL(A.CODE,'')     AS CLASS_CD1 ,                                   \r\n\t\t\tIFNULL(A.CATEGORY,'') AS CLASS_NM1 ,                                  \r\n\t\t\tIFNULL(RIGHT(B.CODE,3),'')     AS CLASS_CD2  ,                        \r\n\t\t\tIFNULL(B.CATEGORY,'') AS CLASS_NM2 ,                                  \r\n\t\t\tIFNULL(RIGHT(C.CODE,3),'')     AS CLASS_CD3,                          \r\n\t\t\tIFNULL(C.CATEGORY,'') AS CLASS_NM3,                                   \r\n\t\t\tIFNULL(RIGHT(D.CODE,3),'')     AS CLASS_CD4 ,                         \r\n\t\t\tIFNULL(D.CATEGORY,'') AS CLASS_NM4                                    \r\n\t\tFROM CATEGLARGE A left JOIN CATEGMIDIUM B                                      \r\n\t\t\tON A.COMPNO=B.COMPNO AND A.CODE = B.LRGCODE left JOIN CATEGSMALL C         \r\n\t\t\tON A.COMPNO = C.COMPNO AND B.CODE = C.MIDCODE left JOIN CATEGDETAIL D ON   \r\n" + String.format(" A.COMPNO = D.COMPNO AND C.CODE = D.SMLCODE WHERE A.COMPNO = '%s'  \r\n", YDMASessonUtil.getCompnoInfo().getCompno()) + "\t\t )                                                                        \r\n" + " SELECT SHOPERR.*  , \r\n" + " IFNULL(CATE.CLASS_NM1, '')  CLASS_NM1, \r\n" + " IFNULL(CATE.CLASS_NM2, '')  CLASS_NM2, \r\n" + " IFNULL(CATE.CLASS_NM3, '')  CLASS_NM3, \r\n" + " IFNULL(CATE.CLASS_NM4, '')  CLASS_NM4, \r\n" + "(CASE                                   \r\n" + "\t     WHEN GOODS_GUBUN = '1'         \r\n" + "\t     THEN '\uc704\ud0c1\uc0c1\ud488'                \r\n" + "\t     WHEN GOODS_GUBUN = '2'         \r\n" + "\t     THEN '\uc81c\uc870\uc0c1\ud488'                \r\n" + "\t     WHEN GOODS_GUBUN = '3'         \r\n" + "\t     THEN '\uc0ac\uc5c5\uc0c1\ud488'                \r\n" + "\t     WHEN GOODS_GUBUN = '4'         \r\n" + "\t     THEN '\uc9c1\uc601\uc0c1\ud488'                \r\n" + "\t     ELSE ''                        \r\n" + "\t  END )AS GOODS_GUBUN_NM,            \r\n" + "(CASE                            \r\n" + "\t     WHEN STATUS = '1'       \r\n" + "\t     THEN '\ub300\uae30\uc911'           \r\n" + "\t     WHEN STATUS = '2'       \r\n" + "\t     THEN '\uacf5\uae09\uc911'           \r\n" + "\t     WHEN STATUS = '3'       \r\n" + "\t     THEN '\uc77c\uc2dc\uc911\uc9c0'         \r\n" + "\t     WHEN STATUS = '4'       \r\n" + "\t     THEN '\uc644\uc804\ud488\uc808'         \r\n" + "\t      WHEN STATUS = '5'      \r\n" + "\t     THEN '\ubbf8\uc0ac\uc6a9'           \r\n" + "\t      WHEN STATUS = '6'      \r\n" + "\t     THEN '\uc0ad\uc81c'             \r\n" + "\t     ELSE ''                 \r\n" + "\t  END )AS STATUS_NM,         \r\n" + "(CASE                             \r\n" + "\t     WHEN DELV_TYPE = '1'     \r\n" + "\t     THEN '\ubb34\ub8cc'              \r\n" + "\t     WHEN DELV_TYPE = '2'     \r\n" + "\t     THEN '\ucc29\ubd88'              \r\n" + "\t     WHEN DELV_TYPE = '3'     \r\n" + "\t     THEN '\uc120\uacb0\uc81c'            \r\n" + "\t     WHEN DELV_TYPE = '4'     \r\n" + "\t     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n" + "\t     ELSE ''                  \r\n" + "\t  END )AS DELV_TYPE_NM       \r\n" + " FROM                             \r\n" + "(SELECT                           \r\n" + " CONCAT(IFNULL(B.CLASS_CD1,''), IFNULL(B.CLASS_CD2,''), IFNULL(B.CLASS_CD3,''), IFNULL(B.CLASS_CD4,'')) AS CODE, \r\n" + "(SELECT SHOPNM FROM shopinfo WHERE SHOPCD = A.SHOPCD) AS SHOPNM, \r\n" + "( SELECT SHOPPINGID FROM shopdtl WHERE SHOPCD = A.SHOPCD AND COMPNO = A.COMPNO AND SHOPSEQ = A.SHOPSEQ) AS  SHOPUSERID," + String.format(" YWM_FUNC_BOSSPRODCD(%s,B.COMPAYNY_GOODS_CD) AS IMG,\r\n", YDMASessonUtil.getCompnoInfo().getCompno()) + " IFNULL(A.SENDSEQ,'' ) AS SENDSEQ,\r\n" + " IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n" + " IFNULL(A.SHOPCD,'' ) AS SHOPCD,\r\n" + " IFNULL(A.SHOPSEQ,'' ) AS SHOPSEQ,\r\n" + " IFNULL(A.PRODSEQ,'' ) AS PRODSEQ,\r\n" + " IFNULL(A.SEQ,'' ) AS SEQ,\r\n" + " IFNULL(A.SHOPCATNO,'' ) AS SHOPCATNO,\r\n";
                sql = String.valueOf(sql) + " IFNULL(B.GOODS_NM,'' ) AS GOODS_NM,\r\n";
                sql = String.valueOf(sql) + " IFNULL(B.GOODS_KEYWORD,'' ) AS GOODS_KEYWORD,\r\n" + " IFNULL(B.MODEL_NM,'' ) AS MODEL_NM,\r\n" + " IFNULL(B.MODEL_NO,'' ) AS MODEL_NO,\r\n" + " IFNULL(B.BRAND_NM,'' ) AS BRAND_NM,\r\n" + " IFNULL(B.COMPAYNY_GOODS_CD,'' ) AS COMPAYNY_GOODS_CD,\r\n" + " IFNULL(B.GOODS_SEARCH,'' ) AS GOODS_SEARCH,\r\n" + " IFNULL(B.GOODS_GUBUN,'' ) AS GOODS_GUBUN,\r\n" + " IFNULL(B.CLASS_CD1,'' ) AS CLASS_CD1,\r\n" + " IFNULL(B.CLASS_CD2,'' ) AS CLASS_CD2,\r\n" + " IFNULL(B.CLASS_CD3,'' ) AS CLASS_CD3,\r\n" + " IFNULL(B.CLASS_CD4,'' ) AS CLASS_CD4,\r\n" + " IFNULL(B.PARTNER_ID,'' ) AS PARTNER_ID,\r\n" + " IFNULL(B.DPARTNER_ID,'' ) AS DPARTNER_ID,\r\n" + " IFNULL(B.MAKER,'' ) AS MAKER,\r\n" + " IFNULL(B.ORIGIN,'' ) AS ORIGIN,\r\n" + " IFNULL(B.MAKE_YEAR,'' ) AS MAKE_YEAR,\r\n" + " IFNULL(B.MAKE_DM,'' ) AS MAKE_DM,\r\n" + " IFNULL(B.GOODS_SEASON,'' ) AS GOODS_SEASON,\r\n" + " IFNULL(B.SEX,'' ) AS SEX,\r\n" + " IFNULL(B.STATUS,'' ) AS STATUS,\r\n" + " IFNULL(B.DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,\r\n" + " IFNULL(B.TAX_YN,'' ) AS TAX_YN,\r\n" + " IFNULL(B.DELV_TYPE,'' ) AS DELV_TYPE,\r\n" + " IFNULL(B.DELV_COST,'' ) AS DELV_COST,\r\n" + " IFNULL(B.BANPUM_AREA,'' ) AS BANPUM_AREA,\r\n" + " IFNULL(B.GOODS_COST,'' ) AS GOODS_COST,\r\n";
                sql = String.valueOf(sql) + " IFNULL(B.GOODS_PRICE,'' ) AS GOODS_PRICE,\r\n";
                sql = String.valueOf(sql) + " IFNULL(B.GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,\r\n" + " IFNULL(B.CHAR_1_NM,'' ) AS CHAR_1_NM,\r\n" + " IFNULL(B.CHAR_1_VAL,'' ) AS CHAR_1_VAL,\r\n" + " IFNULL(B.CHAR_2_NM,'' ) AS CHAR_2_NM,\r\n" + " IFNULL(B.CHAR_2_VAL,'' ) AS CHAR_2_VAL,\r\n" + " IFNULL(B.IMG_PATH,'' ) AS IMG_PATH,\r\n" + " IFNULL(B.IMG_PATH1,'' ) AS IMG_PATH1,\r\n" + " IFNULL(B.IMG_PATH2,'' ) AS IMG_PATH2,\r\n" + " IFNULL(B.IMG_PATH3,'' ) AS IMG_PATH3,\r\n" + " IFNULL(B.IMG_PATH4,'' ) AS IMG_PATH4,\r\n" + " IFNULL(B.IMG_PATH5,'' ) AS IMG_PATH5,\r\n" + " IFNULL(B.IMG_PATH6,'' ) AS IMG_PATH6,\r\n" + " IFNULL(B.IMG_PATH7,'' ) AS IMG_PATH7,\r\n" + " IFNULL(B.IMG_PATH8,'' ) AS IMG_PATH8,\r\n" + " IFNULL(B.IMG_PATH9,'' ) AS IMG_PATH9,\r\n" + " IFNULL(B.IMG_PATH10,'' ) AS IMG_PATH10,\r\n" + " IFNULL(B.IMG_PATH11,'' ) AS IMG_PATH11,\r\n" + " IFNULL(B.IMG_PATH12,'' ) AS IMG_PATH12,\r\n" + " IFNULL(B.IMG_PATH13,'' ) AS IMG_PATH13,\r\n" + " IFNULL(B.IMG_PATH14,'' ) AS IMG_PATH14,\r\n" + " IFNULL(B.IMG_PATH15,'' ) AS IMG_PATH15,\r\n" + " IFNULL(B.IMG_PATH16,'' ) AS IMG_PATH16,\r\n" + " IFNULL(B.IMG_PATH17,'' ) AS IMG_PATH17,\r\n" + " IFNULL(B.IMG_PATH18,'' ) AS IMG_PATH18,\r\n" + " IFNULL(B.IMG_PATH19,'' ) AS IMG_PATH19,\r\n" + " IFNULL(B.IMG_PATH20,'' ) AS IMG_PATH20,\r\n" + " IFNULL(B.IMG_PATH21,'' ) AS IMG_PATH21,\r\n" + " IFNULL(B.IMG_PATH22,'' ) AS IMG_PATH22,\r\n" + " IFNULL(B.IMG_PATH23,'' ) AS IMG_PATH23,\r\n" + " IFNULL(B.IMG_PATH24,'' ) AS IMG_PATH24,\r\n" + " IFNULL(B.GOODS_REMARKS,'' ) AS GOODS_REMARKS,\r\n" + " IFNULL(B.CERTNO,'' ) AS CERTNO,\r\n" + " IFNULL(B.AVLST_DM,'' ) AS AVLST_DM,\r\n" + " IFNULL(B.AVLED_DM,'' ) AS AVLED_DM,\r\n" + " IFNULL(B.ISSUEDATE,'' ) AS ISSUEDATE,\r\n" + " IFNULL(B.CERTDATE,'' ) AS CERTDATE,\r\n" + " IFNULL(B.CERT_AGENCY,'' ) AS CERT_AGENCY,\r\n" + " IFNULL(B.CERTFIELD,'' ) AS CERTFIELD,\r\n" + " IFNULL(B.MATERIAL,'' ) AS MATERIAL,\r\n" + " IFNULL(B.STOCK_USE_YN,'' ) AS STOCK_USE_YN,\r\n" + " IFNULL(B.OPT_TYPE,'' ) AS OPT_TYPE,\r\n" + " IFNULL(B.PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,\r\n" + " IFNULL(B.PROP1_CD,'' ) AS PROP1_CD,\r\n" + " IFNULL(B.PROP_VAL1,'' ) AS PROP_VAL1,\r\n" + " IFNULL(B.PROP_VAL2,'' ) AS PROP_VAL2,\r\n" + " IFNULL(B.PROP_VAL3,'' ) AS PROP_VAL3,\r\n" + " IFNULL(B.PROP_VAL4,'' ) AS PROP_VAL4,\r\n" + " IFNULL(B.PROP_VAL5,'' ) AS PROP_VAL5,\r\n" + " IFNULL(B.PROP_VAL6,'' ) AS PROP_VAL6,\r\n" + " IFNULL(B.PROP_VAL7,'' ) AS PROP_VAL7,\r\n" + " IFNULL(B.PROP_VAL8,'' ) AS PROP_VAL8,\r\n" + " IFNULL(B.PROP_VAL9,'' ) AS PROP_VAL9,\r\n" + " IFNULL(B.PROP_VAL10,'' ) AS PROP_VAL10,\r\n" + " IFNULL(B.PROP_VAL11,'' ) AS PROP_VAL11,\r\n" + " IFNULL(B.PROP_VAL12,'' ) AS PROP_VAL12,\r\n" + " IFNULL(B.PROP_VAL13,'' ) AS PROP_VAL13,\r\n" + " IFNULL(B.PROP_VAL14,'' ) AS PROP_VAL14,\r\n" + " IFNULL(B.PROP_VAL15,'' ) AS PROP_VAL15,\r\n" + " IFNULL(B.PROP_VAL16,'' ) AS PROP_VAL16,\r\n" + " IFNULL(B.PROP_VAL17,'' ) AS PROP_VAL17,\r\n" + " IFNULL(B.PROP_VAL18,'' ) AS PROP_VAL18,\r\n" + " IFNULL(B.PROP_VAL19,'' ) AS PROP_VAL19,\r\n" + " IFNULL(B.PROP_VAL20,'' ) AS PROP_VAL20,\r\n" + " IFNULL(B.PROP_VAL21,'' ) AS PROP_VAL21,\r\n" + " IFNULL(B.PROP_VAL22,'' ) AS PROP_VAL22,\r\n" + " IFNULL(B.PROP_VAL23,'' ) AS PROP_VAL23,\r\n" + " IFNULL(B.PROP_VAL24,'' ) AS PROP_VAL24,\r\n" + " IFNULL(B.PROP_VAL25,'' ) AS PROP_VAL25,\r\n" + " IFNULL(B.PROP_VAL26,'' ) AS PROP_VAL26,\r\n" + " IFNULL(B.PROP_VAL27,'' ) AS PROP_VAL27,\r\n" + " IFNULL(B.PROP_VAL28,'' ) AS PROP_VAL28,\r\n" + " IFNULL(B.PACK_CODE_STR,'' ) AS PACK_CODE_STR,\r\n" + " IFNULL(B.GOODS_NM_EN,'' ) AS GOODS_NM_EN,\r\n" + " IFNULL(B.GOODS_NM_PR,'' ) AS GOODS_NM_PR,\r\n" + " IFNULL(B.GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,\r\n" + " IFNULL(B.GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,\r\n" + " IFNULL(B.GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,\r\n" + " IFNULL(B.IMPORTNO,'' ) AS IMPORTNO,\r\n" + " IFNULL(B.GOODS_COST2,'' ) AS GOODS_COST2,\r\n" + " IFNULL(B.ORIGIN2,'' ) AS ORIGIN2,\r\n" + " IFNULL(B.EXPIRE_DM,'' ) AS EXPIRE_DM,\r\n" + " IFNULL(B.SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,\r\n" + " IFNULL(A.DESCRITION,'' ) AS DESCRITION,\r\n" + " IFNULL(FAILCONTENT,'' ) AS FAILCONTENT,  \r\n" + " IFNULL(B.INSERTDT,'' ) AS INSERTDT,\r\n" + " IFNULL(B.INSERTID,'' ) AS INSERTID,\r\n" + " IFNULL(A.INSERTDT,'' ) AS ERRINSERTDT,\r\n" + " IFNULL(A.INSERTID,'' ) AS ERRINSERTID,\r\n" + " IFNULL(A.MODIFYDT,'' ) AS MODIFYDT,\r\n" + " IFNULL(A.MODIFYID,'' ) AS MODIFYID \r\n" + "  FROM SHOPPRODERR AS A \r\n" + "  INNER JOIN shopprodinfo AS B \r\n" + "  ON A.COMPNO = B.COMPNO AND A.PRODSEQ = B.PRODSEQ\r\n" + " WHERE A.COMPNO = ?  AND A.INSERTDT >= ? AND A.INSERTDT <= ? \r\n";
                if (!params.get("SEARCH_GUBUN").isEmpty()) {
                    sql = String.valueOf(sql) + String.format(" AND B.%s LIKE '%s%s%s' ", params.get("SEARCH_GUBUN"), "%", params.get("SEARCH_TEXT"), "%");
                }
                sql = String.valueOf(sql) + " ) AS SHOPERR  LEFT JOIN CATEALL AS CATE  \r\n" + "\t\t ON SHOPERR.CLASS_CD1 = CATE.CLASS_CD1  \r\n" + " \t\t AND SHOPERR.CLASS_CD2 = CATE.CLASS_CD2 \r\n" + "AND SHOPERR.CLASS_CD3 = CATE.CLASS_CD3   \r\n" + "AND SHOPERR.CLASS_CD4 = CATE.CLASS_CD4  \r\n";
                if (!params.get("CLASS_CD4").equals("CLASS_CD4")) {
                    sql = String.valueOf(sql) + String.format(" WHERE CODE = '%s'", params.get("CLASS_CD4"));
                } else if (!params.get("CLASS_CD3").equals("CLASS_CD3")) {
                    sql = String.valueOf(sql) + String.format(" WHERE CODE LIKE '%s%s'", params.get("CLASS_CD3"), "%");
                } else if (!params.get("CLASS_CD2").equals("CLASS_CD2")) {
                    sql = String.valueOf(sql) + String.format(" WHERE CODE LIKE '%s%s'", params.get("CLASS_CD2"), "%");
                } else if (!params.get("CLASS_CD1").equals("CLASS_CD1")) {
                    sql = String.valueOf(sql) + String.format(" WHERE CODE LIKE '%s%s'", params.get("CLASS_CD1"), "%");
                }
                if (!params.get("SHOPCD").equals("SHOPCD")) {
                    sql = params.get("CLASS_CD1").equals("CLASS_CD1") ? String.valueOf(sql) + String.format(" WHERE SHOPCD = '%s'", params.get("SHOPCD")) : String.valueOf(sql) + String.format("   AND SHOPCD = '%s'", params.get("SHOPCD"));
                    if (!params.get("SHOPUSER_ID").equals("SHOPUSER_ID")) {
                        sql = String.valueOf(sql) + String.format(" AND SHOPSEQ = '%s'", params.get("SHOPUSER_ID"));
                    }
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, params.get("DATE_FROM"));
                pstmt.setString(3, params.get("DATE_TO"));
                YDMAStringUtil.Print("[setProductInInsert]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setRowno("" + ++rowno);
                    dto.setCode(rs.getString("CODE"));
                    dto.setSENDSEQ(rs.getString("SENDSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setShopcatno(rs.getString("SHOPCATNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year(rs.getString("MAKE_YEAR"));
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season(rs.getString("GOODS_SEASON"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setFailcontent(rs.getString("FAILCONTENT"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setErrinsertdt(rs.getString("ERRINSERTDT"));
                    dto.setErrinsertid(rs.getString("ERRINSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setClass_nm1(rs.getString("CLASS_NM1"));
                    dto.setClass_nm2(rs.getString("CLASS_NM2"));
                    dto.setClass_nm3(rs.getString("CLASS_NM3"));
                    dto.setClass_nm4(rs.getString("CLASS_NM4"));
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setGoods_gubun_nm(rs.getString("GOODS_GUBUN_NM"));
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int[] ProductErrordataDelete(List<ProductDTO> listdto) throws Exception {
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        String sql = "DELETE FROM shopproderr where compno=? and sendseq=? ";
        sql = sql.toUpperCase();
        connection = DBCPInit.getInstance().getConnection();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        for (ProductDTO dto : listdto) {
            int i = 0;
            pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setString(++i, dto.getSENDSEQ());
            YDMAStringUtil.Print("[ProductErrordataDelete]" + pstmt.toString());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        int[] result = pstmt.executeBatch();
        pstmt.clearBatch();
        return result;
    }

    public List<List<String>> getShopprodInList(List<ProductDTO> list) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select ifnull(PRODSEQ,'0'),ifnull(COMPNO,''),ifnull(GOODS_NM,''), ifnull(GOODS_KEYWORD,''), ifnull(MODEL_NM,''), ifnull(MODEL_NO,''), ifnull(BRAND_NM,''), ifnull(COMPAYNY_GOODS_CD,''), ";
                sql = String.valueOf(sql) + " ifnull(GOODS_SEARCH,''), ifnull(GOODS_GUBUN,''), ifnull(CLASS_CD1,''), ifnull(CLASS_CD2,''),  ifnull(CLASS_CD3,''), ifnull(CLASS_CD4,''), ifnull(PARTNER_ID,''), ifnull(DPARTNER_ID,''),";
                sql = String.valueOf(sql) + " ifnull(MAKER,''), ifnull(ORIGIN,''), ifnull(MAKE_YEAR,''), ifnull(MAKE_DM,''), ifnull(GOODS_SEASON,''), ifnull(SEX,''), ifnull(STATUS,''), ifnull(DELIV_ABLE_REGION,''), ifnull(TAX_YN,''),";
                sql = String.valueOf(sql) + " ifnull(DELV_TYPE,''), ifnull(DELV_COST,0), ifnull(BANPUM_AREA,''), ifnull(GOODS_COST,0), ifnull(GOODS_PRICE,0), ifnull(GOODS_CONSUMER_PRICE,0), ifnull(CHAR_1_NM,''), ifnull(CHAR_1_VAL,''), ";
                sql = String.valueOf(sql) + " ifnull(CHAR_2_NM,''), ifnull(CHAR_2_VAL,''), ifnull(IMG_PATH, ''), ifnull(IMG_PATH1,''), ifnull(IMG_PATH2,''), ifnull(IMG_PATH3,''), ifnull(IMG_PATH4,''), ifnull(IMG_PATH5,''), ifnull(IMG_PATH6,''), ";
                sql = String.valueOf(sql) + " ifnull(IMG_PATH7,''), ifnull(IMG_PATH8,''), ifnull(IMG_PATH9, ''), ifnull(IMG_PATH10,''), ifnull(IMG_PATH11,''), ifnull(IMG_PATH12,''), ifnull(IMG_PATH13,''), ifnull(IMG_PATH14,''),  ifnull(IMG_PATH15,''),ifnull(IMG_PATH16,''), ifnull(IMG_PATH17,''), ifnull(IMG_PATH18, ''), ifnull(IMG_PATH19,''), ifnull(IMG_PATH20,''), ifnull(IMG_PATH21,''), ifnull(IMG_PATH22,''),  ifnull(IMG_PATH23,''), ifnull(IMG_PATH24,''), ifnull(GOODS_REMARKS,''), ifnull(CERTNO, ''), ifnull(AVLST_DM,''), ifnull(AVLED_DM,''), ifnull(ISSUEDATE,''), ifnull(CERTDATE,''), ifnull(CERT_AGENCY,''), ifnull(CERTFIELD,''), ifnull(MATERIAL,''), ifnull(STOCK_USE_YN, ''), ifnull(OPT_TYPE,''), ifnull(PROP_EDIT_YN,''), ifnull(PROP1_CD,''), ifnull(PROP_VAL1,''),  ifnull(PROP_VAL2,''), ifnull(PROP_VAL3,''), ifnull(PROP_VAL4,''), ifnull(PROP_VAL5, ''), ifnull(PROP_VAL6,''), ifnull(PROP_VAL7,''), ifnull(PROP_VAL8,''), ifnull(PROP_VAL9,''), ifnull(PROP_VAL10,''),  ifnull(PROP_VAL11,''), ifnull(PROP_VAL12,''), ifnull(PROP_VAL13,''), ifnull(PROP_VAL14, ''), ifnull(PROP_VAL15,''), ifnull(PROP_VAL16,''), ifnull(PROP_VAL17,''), ifnull(PROP_VAL18,''),  ifnull(PROP_VAL19,''), ifnull(PROP_VAL20,''), ifnull(PROP_VAL21,''), ifnull(PROP_VAL22, ''), ifnull(PROP_VAL23,''), ifnull(PROP_VAL24,''), ifnull(PROP_VAL25,''), ifnull(PROP_VAL26,''),  ifnull(PROP_VAL27,''), ifnull(PROP_VAL28,''), ifnull(PACK_CODE_STR,''), ifnull(GOODS_NM_EN, ''), ifnull(GOODS_NM_PR,''), ifnull(GOODS_REMARKS2,''), ifnull(GOODS_REMARKS3,''),  ifnull(GOODS_REMARKS4,''), ifnull(IMPORTNO,''), ifnull(GOODS_COST2,''), ifnull(ORIGIN2, ''), ifnull(EXPIRE_DM,''), ifnull(SUPPLY_SAVE_YN,''), ifnull(DESCRITION,''),   ifnull(shopprodno,''), ifnull(INSERTDT,''), ifnull(INSERTID,''), ifnull(MODIFYDT,''), ifnull(MODIFYID, '')";
                sql = String.valueOf(sql) + " FROM shopprodin ";
                sql = String.valueOf(sql) + " where compno = ? and SENDSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int k = 0;
                while (k < list.size()) {
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.get(k).getSENDSEQ());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ArrayList<String> listarr = new ArrayList<String>();
                        int j = 1;
                        while (j <= 118) {
                            listarr.add(rs.getString(j));
                            ++j;
                        }
                        contents.add(listarr);
                    }
                    ++k;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public void setProductInNErrInsert(List<List<String>> contents, List<List<String>> allContents) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " insert into shopproderr (compno, SHOPCD, SHOPSEQ,  PRODSEQ, seq,GOODS_NM, GOODS_KEYWORD, MODEL_NM, MODEL_NO, BRAND_NM, COMPAYNY_GOODS_CD, GOODS_SEARCH, GOODS_GUBUN, CLASS_CD1,  CLASS_CD2,CLASS_CD3, CLASS_CD4, PARTNER_ID,  DPARTNER_ID, MAKER, ORIGIN, MAKE_YEAR, MAKE_DM, GOODS_SEASON, SEX, STATUS, DELIV_ABLE_REGION, TAX_YN,DELV_TYPE,DELV_COST,BANPUM_AREA,  GOODS_COST,GOODS_PRICE, GOODS_CONSUMER_PRICE, CHAR_1_NM,  CHAR_1_VAL, CHAR_2_NM, CHAR_2_VAL, IMG_PATH, IMG_PATH1, IMG_PATH2, IMG_PATH3, IMG_PATH4, IMG_PATH5, IMG_PATH6,IMG_PATH7,IMG_PATH8,  IMG_PATH9,IMG_PATH10, IMG_PATH11, IMG_PATH12,  IMG_PATH13, IMG_PATH14, IMG_PATH15, IMG_PATH16, IMG_PATH17, IMG_PATH18, IMG_PATH19, IMG_PATH20, IMG_PATH21, IMG_PATH22,IMG_PATH23,IMG_PATH24,  GOODS_REMARKS,CERTNO, AVLST_DM, AVLED_DM, ISSUEDATE, CERTDATE, CERT_AGENCY, CERTFIELD, MATERIAL, STOCK_USE_YN, OPT_TYPE, PROP_EDIT_YN, PROP1_CD, PROP_VAL1,PROP_VAL2,PROP_VAL3, PROP_VAL4,  PROP_VAL5,PROP_VAL6, PROP_VAL7, PROP_VAL8, PROP_VAL9, PROP_VAL10, PROP_VAL11, PROP_VAL12, PROP_VAL13, PROP_VAL14, PROP_VAL15, PROP_VAL16, PROP_VAL17, PROP_VAL18,PROP_VAL19,PROP_VAL20, PROP_VAL21,  PROP_VAL22,PROP_VAL23, PROP_VAL24, PROP_VAL25, PROP_VAL26, PROP_VAL27, PROP_VAL28, PACK_CODE_STR, GOODS_NM_EN, GOODS_NM_PR, GOODS_REMARKS2, GOODS_REMARKS3, GOODS_REMARKS4, IMPORTNO,  GOODS_COST2,ORIGIN2, EXPIRE_DM, SUPPLY_SAVE_YN,DESCRITION, FAILCONTENT, INSERTDT,INSERTID ) VALUES(? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,?, ? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,?,  ? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ) ";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                while (i < contents.size()) {
                    List<String> alllist = allContents.get(i);
                    int idx = 0;
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    int k = 3;
                    while (k <= 118) {
                        pstmt.setString(++idx, alllist.get(k - 1));
                        ++k;
                    }
                    pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    ++i;
                }
                YDMAStringUtil.Print("[setProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<List<String>> getShopprodInAllList(List<ProductDTO> list) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select ifnull(sendseq,'0'), ifnull(COMPNO,''),ifnull(shopcd,''),ifnull(shopseq,'0'),ifnull(PRODSEQ,'0'),ifnull(seq,'0'),ifnull(GOODS_NM,''), ifnull(GOODS_KEYWORD,''), ifnull(MODEL_NM,''), ifnull(MODEL_NO,''), ifnull(BRAND_NM,''), ifnull(COMPAYNY_GOODS_CD,''), ";
                sql = String.valueOf(sql) + " ifnull(GOODS_SEARCH,''), ifnull(GOODS_GUBUN,''), ifnull(CLASS_CD1,''), ifnull(CLASS_CD2,''),  ifnull(CLASS_CD3,''), ifnull(CLASS_CD4,''), ifnull(PARTNER_ID,''), ifnull(DPARTNER_ID,''),";
                sql = String.valueOf(sql) + " ifnull(MAKER,''), ifnull(ORIGIN,''), ifnull(MAKE_YEAR,''), ifnull(MAKE_DM,''), ifnull(GOODS_SEASON,''), ifnull(SEX,''), ifnull(STATUS,''), ifnull(DELIV_ABLE_REGION,''), ifnull(TAX_YN,''),";
                sql = String.valueOf(sql) + " ifnull(DELV_TYPE,''), ifnull(DELV_COST,0), ifnull(BANPUM_AREA,''), ifnull(GOODS_COST,0), ifnull(GOODS_PRICE,0), ifnull(GOODS_CONSUMER_PRICE,0), ifnull(CHAR_1_NM,''), ifnull(CHAR_1_VAL,''), ";
                sql = String.valueOf(sql) + " ifnull(CHAR_2_NM,''), ifnull(CHAR_2_VAL,''), ifnull(IMG_PATH, ''), ifnull(IMG_PATH1,''), ifnull(IMG_PATH2,''), ifnull(IMG_PATH3,''), ifnull(IMG_PATH4,''), ifnull(IMG_PATH5,''), ifnull(IMG_PATH6,''), ";
                sql = String.valueOf(sql) + " ifnull(IMG_PATH7,''), ifnull(IMG_PATH8,''), ifnull(IMG_PATH9, ''), ifnull(IMG_PATH10,''), ifnull(IMG_PATH11,''), ifnull(IMG_PATH12,''), ifnull(IMG_PATH13,''), ifnull(IMG_PATH14,''),  ifnull(IMG_PATH15,''),ifnull(IMG_PATH16,''), ifnull(IMG_PATH17,''), ifnull(IMG_PATH18, ''), ifnull(IMG_PATH19,''), ifnull(IMG_PATH20,''), ifnull(IMG_PATH21,''), ifnull(IMG_PATH22,''),  ifnull(IMG_PATH23,''), ifnull(IMG_PATH24,''), ifnull(GOODS_REMARKS,''), ifnull(CERTNO, ''), ifnull(AVLST_DM,''), ifnull(AVLED_DM,''), ifnull(ISSUEDATE,''), ifnull(CERTDATE,''), ifnull(CERT_AGENCY,''), ifnull(CERTFIELD,''), ifnull(MATERIAL,''), ifnull(STOCK_USE_YN, ''), ifnull(OPT_TYPE,''), ifnull(PROP_EDIT_YN,''), ifnull(PROP1_CD,''), ifnull(PROP_VAL1,''),  ifnull(PROP_VAL2,''), ifnull(PROP_VAL3,''), ifnull(PROP_VAL4,''), ifnull(PROP_VAL5, ''), ifnull(PROP_VAL6,''), ifnull(PROP_VAL7,''), ifnull(PROP_VAL8,''), ifnull(PROP_VAL9,''), ifnull(PROP_VAL10,''),  ifnull(PROP_VAL11,''), ifnull(PROP_VAL12,''), ifnull(PROP_VAL13,''), ifnull(PROP_VAL14, ''), ifnull(PROP_VAL15,''), ifnull(PROP_VAL16,''), ifnull(PROP_VAL17,''), ifnull(PROP_VAL18,''),  ifnull(PROP_VAL19,''), ifnull(PROP_VAL20,''), ifnull(PROP_VAL21,''), ifnull(PROP_VAL22, ''), ifnull(PROP_VAL23,''), ifnull(PROP_VAL24,''), ifnull(PROP_VAL25,''), ifnull(PROP_VAL26,''),  ifnull(PROP_VAL27,''), ifnull(PROP_VAL28,''), ifnull(PACK_CODE_STR,''), ifnull(GOODS_NM_EN, ''), ifnull(GOODS_NM_PR,''), ifnull(GOODS_REMARKS2,''), ifnull(GOODS_REMARKS3,''),  ifnull(GOODS_REMARKS4,''), ifnull(IMPORTNO,''), ifnull(GOODS_COST2,''), ifnull(ORIGIN2, ''), ifnull(EXPIRE_DM,''), ifnull(SUPPLY_SAVE_YN,''), ifnull(DESCRITION,''),   ifnull(shopprodno,''), ifnull(INSERTDT,''), ifnull(INSERTID,''), ifnull(MODIFYDT,''), ifnull(MODIFYID, '')";
                sql = String.valueOf(sql) + " FROM shopprodin ";
                sql = String.valueOf(sql) + " where compno = ? and SENDSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int k = 0;
                while (k < list.size()) {
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.get(k).getSENDSEQ());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ArrayList<String> listarr = new ArrayList<String>();
                        int j = 1;
                        while (j <= 122) {
                            listarr.add(rs.getString(j));
                            ++j;
                        }
                        contents.add(listarr);
                    }
                    ++k;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getShopprodErrorList(List<ProductDTO> list) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select ifnull(PRODSEQ,'0'),ifnull(COMPNO,''),ifnull(GOODS_NM,''), ifnull(GOODS_KEYWORD,''), ifnull(MODEL_NM,''), ifnull(MODEL_NO,''), ifnull(BRAND_NM,''), ifnull(COMPAYNY_GOODS_CD,''), ";
                sql = String.valueOf(sql) + " ifnull(GOODS_SEARCH,''), ifnull(GOODS_GUBUN,''), ifnull(CLASS_CD1,''), ifnull(CLASS_CD2,''),  ifnull(CLASS_CD3,''), ifnull(CLASS_CD4,''), ifnull(PARTNER_ID,''), ifnull(DPARTNER_ID,''),";
                sql = String.valueOf(sql) + " ifnull(MAKER,''), ifnull(ORIGIN,''), ifnull(MAKE_YEAR,''), ifnull(MAKE_DM,''), ifnull(GOODS_SEASON,''), ifnull(SEX,''), ifnull(STATUS,''), ifnull(DELIV_ABLE_REGION,''), ifnull(TAX_YN,''),";
                sql = String.valueOf(sql) + " ifnull(DELV_TYPE,''), ifnull(DELV_COST,0), ifnull(BANPUM_AREA,''), ifnull(GOODS_COST,0), ifnull(GOODS_PRICE,0), ifnull(GOODS_CONSUMER_PRICE,0), ifnull(CHAR_1_NM,''), ifnull(CHAR_1_VAL,''), ";
                sql = String.valueOf(sql) + " ifnull(CHAR_2_NM,''), ifnull(CHAR_2_VAL,''), ifnull(IMG_PATH, ''), ifnull(IMG_PATH1,''), ifnull(IMG_PATH2,''), ifnull(IMG_PATH3,''), ifnull(IMG_PATH4,''), ifnull(IMG_PATH5,''), ifnull(IMG_PATH6,''), ";
                sql = String.valueOf(sql) + " ifnull(IMG_PATH7,''), ifnull(IMG_PATH8,''), ifnull(IMG_PATH9, ''), ifnull(IMG_PATH10,''), ifnull(IMG_PATH11,''), ifnull(IMG_PATH12,''), ifnull(IMG_PATH13,''), ifnull(IMG_PATH14,''),  ifnull(IMG_PATH15,''),ifnull(IMG_PATH16,''), ifnull(IMG_PATH17,''), ifnull(IMG_PATH18, ''), ifnull(IMG_PATH19,''), ifnull(IMG_PATH20,''), ifnull(IMG_PATH21,''), ifnull(IMG_PATH22,''),  ifnull(IMG_PATH23,''), ifnull(IMG_PATH24,''), ifnull(GOODS_REMARKS,''), ifnull(CERTNO, ''), ifnull(AVLST_DM,''), ifnull(AVLED_DM,''), ifnull(ISSUEDATE,''), ifnull(CERTDATE,''), ifnull(CERT_AGENCY,''), ifnull(CERTFIELD,''), ifnull(MATERIAL,''), ifnull(STOCK_USE_YN, ''), ifnull(OPT_TYPE,''), ifnull(PROP_EDIT_YN,''), ifnull(PROP1_CD,''), ifnull(PROP_VAL1,''),  ifnull(PROP_VAL2,''), ifnull(PROP_VAL3,''), ifnull(PROP_VAL4,''), ifnull(PROP_VAL5, ''), ifnull(PROP_VAL6,''), ifnull(PROP_VAL7,''), ifnull(PROP_VAL8,''), ifnull(PROP_VAL9,''), ifnull(PROP_VAL10,''),  ifnull(PROP_VAL11,''), ifnull(PROP_VAL12,''), ifnull(PROP_VAL13,''), ifnull(PROP_VAL14, ''), ifnull(PROP_VAL15,''), ifnull(PROP_VAL16,''), ifnull(PROP_VAL17,''), ifnull(PROP_VAL18,''),  ifnull(PROP_VAL19,''), ifnull(PROP_VAL20,''), ifnull(PROP_VAL21,''), ifnull(PROP_VAL22, ''), ifnull(PROP_VAL23,''), ifnull(PROP_VAL24,''), ifnull(PROP_VAL25,''), ifnull(PROP_VAL26,''),  ifnull(PROP_VAL27,''), ifnull(PROP_VAL28,''), ifnull(PACK_CODE_STR,''), ifnull(GOODS_NM_EN, ''), ifnull(GOODS_NM_PR,''), ifnull(GOODS_REMARKS2,''), ifnull(GOODS_REMARKS3,''),  ifnull(GOODS_REMARKS4,''), ifnull(IMPORTNO,''), ifnull(GOODS_COST2,''), ifnull(ORIGIN2, ''), ifnull(EXPIRE_DM,''), ifnull(SUPPLY_SAVE_YN,''), ifnull(DESCRITION,''),   ifnull(FAILCONTENT,''), ifnull(INSERTDT,''), ifnull(INSERTID,''), ifnull(MODIFYDT,''), ifnull(MODIFYID, '')";
                sql = String.valueOf(sql) + " FROM shopproderr ";
                sql = String.valueOf(sql) + " where compno = ? and SENDSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int k = 0;
                while (k < list.size()) {
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.get(k).getSENDSEQ());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ArrayList<String> listarr = new ArrayList<String>();
                        int j = 1;
                        while (j <= 118) {
                            listarr.add(rs.getString(j));
                            ++j;
                        }
                        contents.add(listarr);
                    }
                    ++k;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getShopprodErrorAllList(List<ProductDTO> list) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select ifnull(sendseq,'0'), ifnull(COMPNO,''),ifnull(shopcd,''),ifnull(shopseq,'0'),ifnull(PRODSEQ,'0'),ifnull(seq,'0'),ifnull(GOODS_NM,''), ifnull(GOODS_KEYWORD,''), ifnull(MODEL_NM,''), ifnull(MODEL_NO,''), ifnull(BRAND_NM,''), ifnull(COMPAYNY_GOODS_CD,''), ";
                sql = String.valueOf(sql) + " ifnull(GOODS_SEARCH,''), ifnull(GOODS_GUBUN,''), ifnull(CLASS_CD1,''), ifnull(CLASS_CD2,''),  ifnull(CLASS_CD3,''), ifnull(CLASS_CD4,''), ifnull(PARTNER_ID,''), ifnull(DPARTNER_ID,''),";
                sql = String.valueOf(sql) + " ifnull(MAKER,''), ifnull(ORIGIN,''), ifnull(MAKE_YEAR,''), ifnull(MAKE_DM,''), ifnull(GOODS_SEASON,''), ifnull(SEX,''), ifnull(STATUS,''), ifnull(DELIV_ABLE_REGION,''), ifnull(TAX_YN,''),";
                sql = String.valueOf(sql) + " ifnull(DELV_TYPE,''), ifnull(DELV_COST,0), ifnull(BANPUM_AREA,''), ifnull(GOODS_COST,0), ifnull(GOODS_PRICE,0), ifnull(GOODS_CONSUMER_PRICE,0), ifnull(CHAR_1_NM,''), ifnull(CHAR_1_VAL,''), ";
                sql = String.valueOf(sql) + " ifnull(CHAR_2_NM,''), ifnull(CHAR_2_VAL,''), ifnull(IMG_PATH, ''), ifnull(IMG_PATH1,''), ifnull(IMG_PATH2,''), ifnull(IMG_PATH3,''), ifnull(IMG_PATH4,''), ifnull(IMG_PATH5,''), ifnull(IMG_PATH6,''), ";
                sql = String.valueOf(sql) + " ifnull(IMG_PATH7,''), ifnull(IMG_PATH8,''), ifnull(IMG_PATH9, ''), ifnull(IMG_PATH10,''), ifnull(IMG_PATH11,''), ifnull(IMG_PATH12,''), ifnull(IMG_PATH13,''), ifnull(IMG_PATH14,''),  ifnull(IMG_PATH15,''),ifnull(IMG_PATH16,''), ifnull(IMG_PATH17,''), ifnull(IMG_PATH18, ''), ifnull(IMG_PATH19,''), ifnull(IMG_PATH20,''), ifnull(IMG_PATH21,''), ifnull(IMG_PATH22,''),  ifnull(IMG_PATH23,''), ifnull(IMG_PATH24,''), ifnull(GOODS_REMARKS,''), ifnull(CERTNO, ''), ifnull(AVLST_DM,''), ifnull(AVLED_DM,''), ifnull(ISSUEDATE,''), ifnull(CERTDATE,''), ifnull(CERT_AGENCY,''), ifnull(CERTFIELD,''), ifnull(MATERIAL,''), ifnull(STOCK_USE_YN, ''), ifnull(OPT_TYPE,''), ifnull(PROP_EDIT_YN,''), ifnull(PROP1_CD,''), ifnull(PROP_VAL1,''),  ifnull(PROP_VAL2,''), ifnull(PROP_VAL3,''), ifnull(PROP_VAL4,''), ifnull(PROP_VAL5, ''), ifnull(PROP_VAL6,''), ifnull(PROP_VAL7,''), ifnull(PROP_VAL8,''), ifnull(PROP_VAL9,''), ifnull(PROP_VAL10,''),  ifnull(PROP_VAL11,''), ifnull(PROP_VAL12,''), ifnull(PROP_VAL13,''), ifnull(PROP_VAL14, ''), ifnull(PROP_VAL15,''), ifnull(PROP_VAL16,''), ifnull(PROP_VAL17,''), ifnull(PROP_VAL18,''),  ifnull(PROP_VAL19,''), ifnull(PROP_VAL20,''), ifnull(PROP_VAL21,''), ifnull(PROP_VAL22, ''), ifnull(PROP_VAL23,''), ifnull(PROP_VAL24,''), ifnull(PROP_VAL25,''), ifnull(PROP_VAL26,''),  ifnull(PROP_VAL27,''), ifnull(PROP_VAL28,''), ifnull(PACK_CODE_STR,''), ifnull(GOODS_NM_EN, ''), ifnull(GOODS_NM_PR,''), ifnull(GOODS_REMARKS2,''), ifnull(GOODS_REMARKS3,''),  ifnull(GOODS_REMARKS4,''), ifnull(IMPORTNO,''), ifnull(GOODS_COST2,''), ifnull(ORIGIN2, ''), ifnull(EXPIRE_DM,''), ifnull(SUPPLY_SAVE_YN,''), ifnull(DESCRITION,''),   ifnull(FAILCONTENT,''), ifnull(INSERTDT,''), ifnull(INSERTID,''), ifnull(MODIFYDT,''), ifnull(MODIFYID, '')";
                sql = String.valueOf(sql) + " FROM shopproderr ";
                sql = String.valueOf(sql) + " where compno = ? and SENDSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int k = 0;
                while (k < list.size()) {
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, list.get(k).getSENDSEQ());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ArrayList<String> listarr = new ArrayList<String>();
                        int j = 1;
                        while (j <= 122) {
                            listarr.add(rs.getString(j));
                            ++j;
                        }
                        contents.add(listarr);
                    }
                    ++k;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public void setProductErrorUpdate(List<List<String>> sendResult, List<List<String>> prodContents_target) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql_prodmst = " Update shopproderr     set MODIFYDT = ? , MODIFYID = ?   where SENDSEQ = ?     and compno = ? ";
                PreparedStatement pstmt = connection.prepareStatement(sql_prodmst);
                statementlist.add(pstmt);
                int i = 0;
                while (i < sendResult.size()) {
                    List<String> alllist = prodContents_target.get(i);
                    int idx = 0;
                    pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++idx, alllist.get(0));
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    ++i;
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setProductErrorNIninsert(List<List<String>> sendResult, List<List<String>> prodContents_target) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " insert into shopprodin (compno, SHOPCD, SHOPSEQ,  PRODSEQ, seq,GOODS_NM, GOODS_KEYWORD, MODEL_NM, MODEL_NO, BRAND_NM, COMPAYNY_GOODS_CD, GOODS_SEARCH, GOODS_GUBUN, CLASS_CD1,  CLASS_CD2,CLASS_CD3, CLASS_CD4, PARTNER_ID,  DPARTNER_ID, MAKER, ORIGIN, MAKE_YEAR, MAKE_DM, GOODS_SEASON, SEX, STATUS, DELIV_ABLE_REGION, TAX_YN,DELV_TYPE,DELV_COST,BANPUM_AREA,  GOODS_COST,GOODS_PRICE, GOODS_CONSUMER_PRICE, CHAR_1_NM,  CHAR_1_VAL, CHAR_2_NM, CHAR_2_VAL, IMG_PATH, IMG_PATH1, IMG_PATH2, IMG_PATH3, IMG_PATH4, IMG_PATH5, IMG_PATH6,IMG_PATH7,IMG_PATH8,  IMG_PATH9,IMG_PATH10, IMG_PATH11, IMG_PATH12,  IMG_PATH13, IMG_PATH14, IMG_PATH15, IMG_PATH16, IMG_PATH17, IMG_PATH18, IMG_PATH19, IMG_PATH20, IMG_PATH21, IMG_PATH22,IMG_PATH23,IMG_PATH24,  GOODS_REMARKS,CERTNO, AVLST_DM, AVLED_DM, ISSUEDATE, CERTDATE, CERT_AGENCY, CERTFIELD, MATERIAL, STOCK_USE_YN, OPT_TYPE, PROP_EDIT_YN, PROP1_CD, PROP_VAL1,PROP_VAL2,PROP_VAL3, PROP_VAL4,  PROP_VAL5,PROP_VAL6, PROP_VAL7, PROP_VAL8, PROP_VAL9, PROP_VAL10, PROP_VAL11, PROP_VAL12, PROP_VAL13, PROP_VAL14, PROP_VAL15, PROP_VAL16, PROP_VAL17, PROP_VAL18,PROP_VAL19,PROP_VAL20, PROP_VAL21,  PROP_VAL22,PROP_VAL23, PROP_VAL24, PROP_VAL25, PROP_VAL26, PROP_VAL27, PROP_VAL28, PACK_CODE_STR, GOODS_NM_EN, GOODS_NM_PR, GOODS_REMARKS2, GOODS_REMARKS3, GOODS_REMARKS4, IMPORTNO,  GOODS_COST2,ORIGIN2, EXPIRE_DM, SUPPLY_SAVE_YN,DESCRITION, SHOPPRODNO, INSERTDT,INSERTID ) VALUES(? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,?, ? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,?,  ? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ) ";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                while (i < sendResult.size()) {
                    List<String> alllist = prodContents_target.get(i);
                    int idx = 0;
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    int k = 3;
                    while (k <= 118) {
                        if (k == 118) {
                            pstmt.setString(++idx, sendResult.get(i).get(3));
                        } else {
                            pstmt.setString(++idx, alllist.get(k - 1));
                        }
                        ++k;
                    }
                    pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    ++i;
                }
                YDMAStringUtil.Print("[setProductErrorNIninsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int ShopProductUpdate(ProductDTO dto, String prodnm, String price2) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodin    set GOODS_NM=?, GOODS_PRICE=?  where SENDSEQ= ?    and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, prodnm);
                pstmt.setInt(++i, Integer.parseInt(price2));
                pstmt.setString(++i, dto.getSENDSEQ());
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[larCategoryUpdate]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public ShopProductCoupangAdditionDto getAdditionaCoupangOneList(int seq) throws Exception {
        ShopProductCoupangAdditionDto dto = new ShopProductCoupangAdditionDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT    \r\nIFNULL(SEQ, '' ) AS SEQ, IFNULL(COMPNO, '' ) AS COMPNO,IFNULL(SHOPCD, '' ) AS SHOPCD,\r\nIFNULL(TITLE, '' ) AS TITLE,IFNULL(MEMO, '' ) AS MEMO,IFNULL(SELMTHDCD, '' ) AS SELMTHDCD,\r\nIFNULL(SHOPID, '' ) AS SHOPID,IFNULL(OFFERCONDITION, '' ) AS OFFERCONDITION,\r\nIFNULL(ORIGINALPRICD, '' ) AS ORIGINALPRICD,IFNULL(COMPANY_GOODS_CD, '' ) AS COMPANY_GOODS_CD,\r\nIFNULL(BARCD, '' ) AS BARCD,IFNULL(BARCDREASON, '' ) AS BARCDREASON,\r\nIFNULL(ADULTONLY, '' ) AS ADULTONLY,IFNULL(PARALLELIMPORT, '' ) AS PARALLELIMPORT,\r\nIFNULL(OVERSEASPURCHASED, '' ) AS OVERSEASPURCHASED,IFNULL(PCCNEEDED, '' ) AS PCCNEEDED,\r\nIFNULL(OVERSEASRECEIPT, '' ) AS OVERSEASRECEIPT,IFNULL(MESSAGE, '' ) AS MESSAGE,\r\nIFNULL(OUTBOUNDSHOPTIMEDAY, '' ) AS OUTBOUNDSHOPTIMEDAY,IFNULL(MAXIMUMBUYPERSON, '' ) AS MAXIMUMBUYPERSON,\r\nIFNULL(MAXIMUMBUYPERSONPERIOD, '' ) AS MAXIMUMBUYPERSONPERIOD,IFNULL(REPIMAGE, '' ) AS REPIMAGE,\r\nIFNULL(RECTIMAGE, '' ) AS RECTIMAGE,IFNULL(CARIMAGE, '' ) AS CARIMAGE,\r\nIFNULL(NOTICEIMAGE, '' ) AS NOTICEIMAGE,IFNULL(PAINTIMAGE, '' ) AS PAINTIMAGE,\r\nIFNULL(OTHERIMAGE, '' ) AS OTHERIMAGE,IFNULL(INCOMEIMAGE, '' ) AS INCOMEIMAGE,\r\nIFNULL(PRODNM, '' ) AS PRODNM,IFNULL(DELIVERYMETHOD, '' ) AS DELIVERYMETHOD,\r\nIFNULL(DELIVERYCOMPANYCD, '' ) AS DELIVERYCOMPANYCD,IFNULL(DELIVERYCHARGETYPE, '' ) AS DELIVERYCHARGETYPE,\r\nIFNULL(DELIVERYCHARGE, '' ) AS DELIVERYCHARGE,IFNULL(FREESHIPOVERCHARGE, '' ) AS FREESHIPOVERCHARGE,\r\nIFNULL(DELIVERYRETCHARGE, '' ) AS DELIVERYRETCHARGE,IFNULL(REMOTEAREACHARGE, '' ) AS REMOTEAREACHARGE,\r\nIFNULL(UNIONDELIVERYTYPE, '' ) AS UNIONDELIVERYTYPE,IFNULL(REMOTEAREADELIVERABLE, '' ) AS REMOTEAREADELIVERABLE,\r\nIFNULL(OUTADDRCD, '' ) AS OUTADDRCD,IFNULL(OUTADDRESS, '' ) AS OUTADDRESS,\r\nIFNULL(OUTADDRESSDTL, '' ) AS OUTADDRESSDTL,IFNULL(RETURNADDRCD, '' ) AS RETURNADDRCD,\r\nIFNULL(RETURNADDRCONTACTNUM, '' ) AS RETURNADDRCONTACTNUM,\r\nIFNULL(RETURNADDRZIPCD, '' ) AS RETURNADDRZIPCD,\r\nIFNULL(RETURNADDRESS, '' ) AS RETURNADDRESS,\r\nIFNULL(RETURNADDRESSDEL, '' ) AS RETURNADDRESSDEL,\r\nIFNULL(RETURNCHARGE, '' ) AS RETURNCHARGE,\r\nIFNULL(RETURNCHARGEVENDOR, '' ) AS RETURNCHARGEVENDOR,\r\nIFNULL(ASINFORMATION, '' ) AS ASINFORMATION,\r\nIFNULL(ASCONTACTNUM, '' ) AS ASCONTACTNUM,\r\nIFNULL(PRODNMFIRST, '' ) AS PRODNMFIRST,\r\nIFNULL(PRODNMEND, '' ) AS PRODNMEND,\r\nIFNULL(PRODNMDTLTOP, '' ) AS PRODNMDTLTOP,\r\nIFNULL(PRODNMDTLBOTTOM, '' ) AS PRODNMDTLBOTTOM,\r\nIFNULL(USEYN, '' ) AS USEYN\r\nFROM shopaddrcoupangdtl WHERE SEQ = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                YDMAStringUtil.Print("[getAdditionaCoupangOneList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setTitle(rs.getString("TITLE"));
                    dto.setMemo(rs.getString("MEMO"));
                    dto.setSelmthdcd(rs.getString("SELMTHDCD"));
                    dto.setShopid(rs.getString("SHOPID"));
                    dto.setOffercondition(rs.getString("OFFERCONDITION"));
                    dto.setOriginalpricd(rs.getString("ORIGINALPRICD"));
                    dto.setCompany_goods_cd(rs.getString("COMPANY_GOODS_CD"));
                    dto.setBarcd(rs.getString("BARCD"));
                    dto.setBarcdreason(rs.getString("BARCDREASON"));
                    dto.setAdultonly(rs.getString("ADULTONLY"));
                    dto.setParallelimport(rs.getString("PARALLELIMPORT"));
                    dto.setOverseaspurchased(rs.getString("OVERSEASPURCHASED"));
                    dto.setPccneeded(rs.getString("PCCNEEDED"));
                    dto.setOverseasreceipt(rs.getString("OVERSEASRECEIPT"));
                    dto.setMessage(rs.getString("MESSAGE"));
                    dto.setOutboundshoptimeday(rs.getString("OUTBOUNDSHOPTIMEDAY"));
                    dto.setMaximumbuyperson(rs.getString("MAXIMUMBUYPERSON"));
                    dto.setMaximumbuypersonperiod(rs.getString("MAXIMUMBUYPERSONPERIOD"));
                    dto.setRepimage(rs.getString("REPIMAGE"));
                    dto.setRectimage(rs.getString("RECTIMAGE"));
                    dto.setCarimage(rs.getString("CARIMAGE"));
                    dto.setNoticeimage(rs.getString("NOTICEIMAGE"));
                    dto.setPaintimage(rs.getString("PAINTIMAGE"));
                    dto.setOtherimage(rs.getString("OTHERIMAGE"));
                    dto.setIncomeimage(rs.getString("INCOMEIMAGE"));
                    dto.setProdnm(rs.getString("PRODNM"));
                    dto.setDeliverymethod(rs.getString("DELIVERYMETHOD"));
                    dto.setDeliverycompanycd(rs.getString("DELIVERYCOMPANYCD"));
                    dto.setDeliverychargetype(rs.getString("DELIVERYCHARGETYPE"));
                    dto.setDeliverycharge(rs.getString("DELIVERYCHARGE"));
                    dto.setFreeshipovercharge(rs.getString("FREESHIPOVERCHARGE"));
                    dto.setDeliveryretcharge(rs.getString("DELIVERYRETCHARGE"));
                    dto.setRemoteareacharge(rs.getString("REMOTEAREACHARGE"));
                    dto.setUniondeliverytype(rs.getString("UNIONDELIVERYTYPE"));
                    dto.setRemoteareadeliverable(rs.getString("REMOTEAREADELIVERABLE"));
                    dto.setOutaddrcd(rs.getString("OUTADDRCD"));
                    dto.setOutaddress(rs.getString("OUTADDRESS"));
                    dto.setOutaddressdtl(rs.getString("OUTADDRESSDTL"));
                    dto.setReturnaddrcd(rs.getString("RETURNADDRCD"));
                    dto.setReturnaddrcontactnum(rs.getString("RETURNADDRCONTACTNUM"));
                    dto.setReturnaddrzipcd(rs.getString("RETURNADDRZIPCD"));
                    dto.setReturnaddress(rs.getString("RETURNADDRESS"));
                    dto.setReturnaddressdel(rs.getString("RETURNADDRESSDEL"));
                    dto.setReturncharge(rs.getString("RETURNCHARGE"));
                    dto.setReturnchargevendor(rs.getString("RETURNCHARGEVENDOR"));
                    dto.setAsinformation(rs.getString("ASINFORMATION"));
                    dto.setAscontactnum(rs.getString("ASCONTACTNUM"));
                    dto.setProdnmfirst(rs.getString("PRODNMFIRST"));
                    dto.setProdnmend(rs.getString("PRODNMEND"));
                    dto.setProdnmdtltop(rs.getString("PRODNMDTLTOP"));
                    dto.setProdnmdtlbottom(rs.getString("PRODNMDTLBOTTOM"));
                    dto.setUseyn(rs.getString("USEYN"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopCoupangAdditionalDto getCoupangAdditionalOneList(int seq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ShopCoupangAdditionalDto listjoin = new ShopCoupangAdditionalDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " SELECT IFNULL(SEQ,'0'), IFNULL(TITLE,''), IFNULL(SHOPCD,''), IFNULL(SHOPSEQ,''),IFNULL(SHOPUSERID,''), IFNULL(RATEYN,''), IFNULL(RATE,'0'), IFNULL(SELLERDC,'0'),  IFNULL(DCRATE,'0'), IFNULL(CUMDC,'0'), IFNULL(MARGINDC,'0'), IFNULL(COMMDC,'0'), IFNULL(USEDYN,''), IFNULL(USEDSTATUS,''), IFNULL(USEDDETAIL,''),  IFNULL(SALEFROMDATE,''), IFNULL(SALETODATE,''), IFNULL(ADULTONLY,''), IFNULL(PARALLELIMPORT,''),  IFNULL(OVERSEASPURCHASED,''), IFNULL(PCCNEEDED,''), IFNULL(PRODOPTYN,''), IFNULL(KEYWORDYN,''), IFNULL(BARCODEYN,''), IFNULL(BARCODE,''), IFNULL(BARCODEREASON,''),  IFNULL(CURRANTY,''), IFNULL(MAINIMAGE,''), IFNULL(SUBIMAGE,''), IFNULL(BRANDYN,''), IFNULL(BRANDNM,''), IFNULL(UNIONDELIVERYTYPE,''), IFNULL(REMOTEAREADELIVERABLE,''), IFNULL(DELIVERYMETHOD,''), IFNULL(DELIVERYCOMPANYCD,''), IFNULL(DELIVERYCHARGETYPE,''), IFNULL(DELIVERYCHARGE,'0'), IFNULL(FREESHIPOVERCHARGE,'0'),  IFNULL(DELIVERYRETCHARGE,'0'), IFNULL(OUTADDRPLACE,''), IFNULL(OUTADDRNAME,''), IFNULL(OUTADDRCEL,''), IFNULL(OUTADDRTEL,''), IFNULL(OUTADDRZIPCD,''),  IFNULL(OUTADDR,''), IFNULL(OUTADDRDTL,''), IFNULL(RETADDRPLACE,''), IFNULL(RETADDRCD,''), IFNULL(RETADDRNAME,''), IFNULL(RETADDRCEL,''), IFNULL(RETADDRZIPCD,''),  IFNULL(RETADDR,''), IFNULL(RETADDRDTL,''), IFNULL(RETURNCHARGE,'0'), IFNULL(OUTBOUNDSHOPTIMEDAY,'0'), IFNULL(MAXIMUMBUYPERSON,'0'), IFNULL(MAXIMUMBUYPERSONPERIOD,'0'),  IFNULL(EXCHANGETYPE,''), IFNULL(PAYMENTYN,''), IFNULL(ASINFORMATION,''), IFNULL(ASINFORMATIONDTL,''), IFNULL(ASCONTACTNUM,''), IFNULL(BATCHYN,''), IFNULL(ATTRCD,''),  IFNULL(ATTRCDTITLEYN,''), IFNULL(MOBILENOTICE,''), IFNULL(PAINTIMAGE,''), IFNULL(PAINTSALEIMAGE,''), IFNULL(CARIMAGE,''), IFNULL(INCOMEIMAGE,''),  IFNULL(OVERSEASRECEIPT,''), IFNULL(PRODGENUINEIMAGE,''), IFNULL(NOTICEIMAGE,''), IFNULL(PRODOUTTYPE,''), IFNULL(PRODNMFIRST,''), IFNULL(PRODNMEND,''),  IFNULL(PRODNMDTLTOP,''), IFNULL(PRODNMDTLBOTTOM,''), IFNULL(PRODREMARKTYPE,''), IFNULL(FREEDELIVERY,'') , IFNULL(EXPPRC,'2500'),  IFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX,''), IFNULL(CHANGESIZEY,''), IFNULL(CHANGESIZEW,''), IFNULL(CHANGESIZEH,''),  IFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL,''), IFNULL(DETAILKEYWORDR,''), IFNULL(DETAILPRODUCTCODEB,''),  IFNULL(DETAILPRODUCTCODEL,''), IFNULL(DETAILPRODUCTCODER,''), IFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL,''),  IFNULL(DETAILPRODUCTNAMER,''), IFNULL(ADDOPTIONLB,''), IFNULL(ADDOPTIONL,''), IFNULL(ADDOPTIONRB,''),  IFNULL(ADDOPTIONR,''), IFNULL(IMGONEONONE,''), IFNULL(IMGTHREEONFOUR,''), \r\n IFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''), IMG_ANGLE, IMG_SCALE_PERCENT \r\n\tFROM shopcoupangaddidtl where seq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    listjoin.setSeq(rs.getString(++columnIndex));
                    listjoin.setTitle(rs.getString(++columnIndex));
                    listjoin.setShopcd(rs.getString(++columnIndex));
                    listjoin.setShopseq(rs.getString(++columnIndex));
                    listjoin.setShopid(rs.getString(++columnIndex));
                    listjoin.setRateyn(rs.getString(++columnIndex));
                    listjoin.setRate(rs.getString(++columnIndex));
                    listjoin.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    listjoin.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    listjoin.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    listjoin.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    listjoin.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    listjoin.setUsedyn(rs.getString(++columnIndex));
                    listjoin.setUsedstatus(rs.getString(++columnIndex));
                    listjoin.setUseddetail(rs.getString(++columnIndex));
                    listjoin.setSalefromdate(rs.getString(++columnIndex));
                    listjoin.setSaletodate(rs.getString(++columnIndex));
                    listjoin.setAdultonly(rs.getString(++columnIndex));
                    listjoin.setParallelimport(rs.getString(++columnIndex));
                    listjoin.setOverseaspurchased(rs.getString(++columnIndex));
                    listjoin.setPccneeded(rs.getString(++columnIndex));
                    listjoin.setProdoptyn(rs.getString(++columnIndex));
                    listjoin.setKeywordyn(rs.getString(++columnIndex));
                    listjoin.setBarcodeyn(rs.getString(++columnIndex));
                    listjoin.setBarcode(rs.getString(++columnIndex));
                    listjoin.setBarcodereason(rs.getString(++columnIndex));
                    listjoin.setCurranty(rs.getString(++columnIndex));
                    listjoin.setMainimage(rs.getString(++columnIndex));
                    listjoin.setSubimage(rs.getString(++columnIndex));
                    listjoin.setBrandyn(rs.getString(++columnIndex));
                    listjoin.setBrandnm(rs.getString(++columnIndex));
                    listjoin.setUniondeliverytype(rs.getString(++columnIndex));
                    listjoin.setRemoteareadeliverable(rs.getString(++columnIndex));
                    listjoin.setDeliverymethod(rs.getString(++columnIndex));
                    listjoin.setDeliverycompanycd(rs.getString(++columnIndex));
                    listjoin.setDeliverychargetype(rs.getString(++columnIndex));
                    listjoin.setDeliverycharge(rs.getString(++columnIndex));
                    listjoin.setFreeshipovercharge(rs.getString(++columnIndex));
                    listjoin.setDeliveryretcharge(rs.getString(++columnIndex));
                    listjoin.setOutaddrplace(rs.getString(++columnIndex));
                    listjoin.setOutaddrname(rs.getString(++columnIndex));
                    listjoin.setOutaddrcel(rs.getString(++columnIndex));
                    listjoin.setOutaddrtel(rs.getString(++columnIndex));
                    listjoin.setOutaddrzipcd(rs.getString(++columnIndex));
                    listjoin.setOutaddr(rs.getString(++columnIndex));
                    listjoin.setOutaddrdtl(rs.getString(++columnIndex));
                    listjoin.setRetaddrplace(rs.getString(++columnIndex));
                    listjoin.setRetaddrcd(rs.getString(++columnIndex));
                    listjoin.setRetaddrname(rs.getString(++columnIndex));
                    listjoin.setRetaddrcel(rs.getString(++columnIndex));
                    listjoin.setRetaddrzipcd(rs.getString(++columnIndex));
                    listjoin.setRetaddr(rs.getString(++columnIndex));
                    listjoin.setRetaddrdtl(rs.getString(++columnIndex));
                    listjoin.setReturncharge(rs.getString(++columnIndex));
                    listjoin.setOutboundshoptimeday(rs.getString(++columnIndex));
                    listjoin.setMaximumbuyperson(rs.getString(++columnIndex));
                    listjoin.setMaximumbuypersonperiod(rs.getString(++columnIndex));
                    listjoin.setExchangetype(rs.getString(++columnIndex));
                    listjoin.setPaymentyn(rs.getString(++columnIndex));
                    listjoin.setAsinfomation(rs.getString(++columnIndex));
                    listjoin.setAsinfomationdtl(rs.getString(++columnIndex));
                    listjoin.setAscontactnum(rs.getString(++columnIndex));
                    listjoin.setBatchyn(rs.getString(++columnIndex));
                    listjoin.setAttrcd(rs.getString(++columnIndex));
                    listjoin.setAttrcdtitleyn(rs.getString(++columnIndex));
                    listjoin.setMobilenotice(rs.getString(++columnIndex));
                    listjoin.setPaintimage(rs.getString(++columnIndex));
                    listjoin.setPaintsaleimage(rs.getString(++columnIndex));
                    listjoin.setCarimage(rs.getString(++columnIndex));
                    listjoin.setIncomeimage(rs.getString(++columnIndex));
                    listjoin.setOverseasreceipt(rs.getString(++columnIndex));
                    listjoin.setProdgenuineimage(rs.getString(++columnIndex));
                    listjoin.setNoticeimage(rs.getString(++columnIndex));
                    listjoin.setProdouttype(rs.getString(++columnIndex));
                    listjoin.setProdnmfirst(rs.getString(++columnIndex));
                    listjoin.setProdnmend(rs.getString(++columnIndex));
                    listjoin.setProdnmdtltop(rs.getString(++columnIndex));
                    listjoin.setProdnmdtlbottom(rs.getString(++columnIndex));
                    listjoin.setProdremarktype(rs.getString(++columnIndex));
                    listjoin.setFreedelivery(rs.getString(++columnIndex));
                    listjoin.setExpprc(rs.getInt(++columnIndex));
                    listjoin.setChangesize(rs.getString(++columnIndex));
                    listjoin.setChangeSizeX(rs.getString(++columnIndex));
                    listjoin.setChangeSizeY(rs.getString(++columnIndex));
                    listjoin.setChangeSizeW(rs.getString(++columnIndex));
                    listjoin.setChangeSizeH(rs.getString(++columnIndex));
                    listjoin.setDetailkeywordb(rs.getString(++columnIndex));
                    listjoin.setDetailKeywordL(rs.getString(++columnIndex));
                    listjoin.setDetailKeywordR(rs.getString(++columnIndex));
                    listjoin.setDetailproductcodeb(rs.getString(++columnIndex));
                    listjoin.setDetailProductCodeL(rs.getString(++columnIndex));
                    listjoin.setDetailProductCodeR(rs.getString(++columnIndex));
                    listjoin.setDetailproductnameb(rs.getString(++columnIndex));
                    listjoin.setDetailProdcutNameL(rs.getString(++columnIndex));
                    listjoin.setDetailProdcutNameR(rs.getString(++columnIndex));
                    listjoin.setAddoptionlb(rs.getString(++columnIndex));
                    listjoin.setAddOptionL(rs.getString(++columnIndex));
                    listjoin.setAddoptionrb(rs.getString(++columnIndex));
                    listjoin.setAddOptionR(rs.getString(++columnIndex));
                    listjoin.setImgOneOnOne(rs.getString(++columnIndex));
                    listjoin.setImgThreeOnFour(rs.getString(++columnIndex));
                    listjoin.setIsCategory(rs.getString(++columnIndex));
                    listjoin.setLagcatcd(rs.getString(++columnIndex));
                    listjoin.setMidcatcd(rs.getString(++columnIndex));
                    listjoin.setSmlcatcd(rs.getString(++columnIndex));
                    listjoin.setDetcatcd(rs.getString(++columnIndex));
                    listjoin.setShopcatno(rs.getString(++columnIndex));
                    listjoin.setShopcatsitenm(rs.getString(++columnIndex));
                    listjoin.setAngle(rs.getString(++columnIndex));
                    listjoin.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return listjoin;
    }

    public ShopProductCafe24AdditionDto getAdditionaCafe24OneList(int seq) throws Exception {
        ShopProductCafe24AdditionDto dto = new ShopProductCafe24AdditionDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SEQ, '0'), ifnull( COMPNO, '0'), ifnull( SHOPCD, ''), ifnull( TITLE, ''), ifnull( MEMO, ''), ifnull( SHOPID, ''), ifnull( VALUE1, ''),  ifnull( VALUE2, ''), ifnull( VALUE3, ''), ifnull( VALUE4, ''), ifnull( VALUE5, ''), ifnull( VALUE6, ''), ifnull( VALUE7, ''), ifnull( VALUE8, ''),  ifnull( VALUE9, ''), ifnull( VALUE10, ''), ifnull( VALUE11, ''), ifnull( VALUE12, ''), ifnull( VALUE13, ''), ifnull( VALUE14, '0'), ifnull(SELLERDC, '0'),  ifnull( DC, '0'), ifnull( FLOATDC, '0'), ifnull( MARGIN, '0'), ifnull( COMM, '0'), ifnull( SUPPLY, ''), ifnull( CONSUMERS, ''), ifnull( MANFNM, ''), ifnull(SUPPLIER, ''),  ifnull( BRANDNM, ''), ifnull( TRENDNM, ''), ifnull( VALUE15, ''), ifnull( VALUE16, ''), ifnull( VALUE17, ''), ifnull( VALUE18, ''), ifnull( VALUE19, ''),  ifnull( VALUE20, ''), ifnull( REPIMAGE, ''), ifnull( LISTIMAGE, ''), ifnull( IMAGEMETHOD, ''), ifnull( ADDIIMAGEYN, ''), ifnull( ADDIIMAGECNT, ''), ifnull( VALUE21, ''),  ifnull( VALUE22, ''), ifnull( VALUE23, ''), ifnull( VALUE24, ''), ifnull( VALUE25, '0'), ifnull( VALUE26, ''), ifnull( VALUE27, '0'), ifnull( VALUE28, ''),  ifnull( VALUE29, '0'), ifnull( VALUE30, ''), ifnull( VALUE31, '0'), ifnull( VALUE32, ''), ifnull( VALUE33, '0'), ifnull( VALUE34, ''), ifnull( VALUE35, '0'),  ifnull( VALUE36, ''), ifnull( VALUE37, '0'), ifnull( VALUE38, ''), ifnull( VALUE39, '0'), ifnull( VALUE40, ''), ifnull( VALUE41, '0'), ifnull( VALUE42, ''),  ifnull( VALUE43, '0'), ifnull( VALUE44, ''), ifnull( VALUE45, '0'), ifnull( VALUE46, ''), ifnull( VALUE47, '0'), ifnull( VALUE48, ''), ifnull( VALUE49, '0'),  ifnull( VALUE50, ''), ifnull( VALUE51, ''), ifnull( VALUE52, ''), ifnull( VALUE53, ''), ifnull( SHIPPINGINFO, ''), ifnull( SHIPPINGMETHOD, ''), ifnull( HOMENABROSHIP, ''),  ifnull( SHIPPINGAREA, ''), ifnull( DELVPERIODFROM, ''), ifnull( DELVPERIODTO, ''), ifnull( DELVCOSTMETHOD, ''), ifnull( DELVCOST1, '0'), ifnull( DELVCOST2, '0'),  ifnull( DELVCOST3, '0'), ifnull( DELVFEESETUP, ''), ifnull( VALUE54, ''), ifnull( VALUE55, ''), ifnull( VALUE90, ''), ifnull( VALUE56, ''), ifnull( VALUE57, '0'),  ifnull( VALUE58, ''), ifnull( VALUE59, '0'), ifnull( VALUE60, ''), ifnull( VALUE61, ''), ifnull( VALUE62, ''), ifnull( VALUE63, ''), ifnull( VALUE64, ''),  ifnull( VALUE65, ''), ifnull( VALUE66, ''), ifnull( VALUE67, ''), ifnull( VALUE68, ''), ifnull( VALUE69, ''), ifnull( VALUE70, ''), ifnull( VALUE71, ''),  ifnull( VALUE72, ''), ifnull( VALUE73, ''), ifnull( VALUE74, ''), ifnull( VALUE75, ''), ifnull( VALUE76, ''), ifnull( VALUE77, ''), ifnull( VALUE78, ''),  ifnull( PRODSTATS, ''), ifnull( USEDPERIOD, '0'), ifnull( VALUE79, ''), ifnull( VALUE80, ''), ifnull( VALUE81, ''), ifnull( SHIPPINGTYPE, ''), ifnull( OTHERVAL1, ''),  ifnull( OTHERVAL2, ''), ifnull( VALUE82, ''), ifnull( VALUE83, ''), ifnull( VALUE84, ''), ifnull( VALUE85, '0'), ifnull( MINORSELCNYN, ''), ifnull( ORDERQTYTYPE, ''),  ifnull( MINIMUMQTY, '0'), ifnull( MAXIMUMTYPE, ''), ifnull( MAXIMUMQTY, '0'), ifnull( VALUE86, ''), ifnull( VALUE87, ''), ifnull( VALUE88, ''), ifnull( VALUE89, ''),  ifnull( USEYN,'')\r\n\tFROM shopaddrcafe24dtl where seq=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setMemo(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setValue1(rs.getString(++columnIndex));
                    dto.setValue2(rs.getString(++columnIndex));
                    dto.setValue3(rs.getString(++columnIndex));
                    dto.setValue4(rs.getString(++columnIndex));
                    dto.setValue5(rs.getString(++columnIndex));
                    dto.setValue6(rs.getString(++columnIndex));
                    dto.setValue7(rs.getString(++columnIndex));
                    dto.setValue8(rs.getString(++columnIndex));
                    dto.setValue9(rs.getString(++columnIndex));
                    dto.setValue10(rs.getString(++columnIndex));
                    dto.setValue11(rs.getString(++columnIndex));
                    dto.setValue12(rs.getString(++columnIndex));
                    dto.setValue13(rs.getString(++columnIndex));
                    dto.setValue14(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setSupply(rs.getString(++columnIndex));
                    dto.setConsumers(rs.getString(++columnIndex));
                    dto.setManfnm(rs.getString(++columnIndex));
                    dto.setSupplier(rs.getString(++columnIndex));
                    dto.setBrandnm(rs.getString(++columnIndex));
                    dto.setTrendnm(rs.getString(++columnIndex));
                    dto.setValue15(rs.getString(++columnIndex));
                    dto.setValue16(rs.getString(++columnIndex));
                    dto.setValue17(rs.getString(++columnIndex));
                    dto.setValue18(rs.getString(++columnIndex));
                    dto.setValue19(rs.getString(++columnIndex));
                    dto.setValue20(rs.getString(++columnIndex));
                    dto.setRepimage(rs.getString(++columnIndex));
                    dto.setListimage(rs.getString(++columnIndex));
                    dto.setImagemethod(rs.getString(++columnIndex));
                    dto.setAddiimageyn(rs.getString(++columnIndex));
                    dto.setAddiimagecnt(rs.getString(++columnIndex));
                    dto.setValue21(rs.getString(++columnIndex));
                    dto.setValue22(rs.getString(++columnIndex));
                    dto.setValue23(rs.getString(++columnIndex));
                    dto.setValue24(rs.getString(++columnIndex));
                    dto.setValue25(rs.getString(++columnIndex));
                    dto.setValue26(rs.getString(++columnIndex));
                    dto.setValue27(rs.getString(++columnIndex));
                    dto.setValue28(rs.getString(++columnIndex));
                    dto.setValue29(rs.getString(++columnIndex));
                    dto.setValue30(rs.getString(++columnIndex));
                    dto.setValue31(rs.getString(++columnIndex));
                    dto.setValue32(rs.getString(++columnIndex));
                    dto.setValue33(rs.getString(++columnIndex));
                    dto.setValue34(rs.getString(++columnIndex));
                    dto.setValue35(rs.getString(++columnIndex));
                    dto.setValue36(rs.getString(++columnIndex));
                    dto.setValue37(rs.getString(++columnIndex));
                    dto.setValue38(rs.getString(++columnIndex));
                    dto.setValue39(rs.getString(++columnIndex));
                    dto.setValue40(rs.getString(++columnIndex));
                    dto.setValue41(rs.getString(++columnIndex));
                    dto.setValue42(rs.getString(++columnIndex));
                    dto.setValue43(rs.getString(++columnIndex));
                    dto.setValue44(rs.getString(++columnIndex));
                    dto.setValue45(rs.getString(++columnIndex));
                    dto.setValue46(rs.getString(++columnIndex));
                    dto.setValue47(rs.getString(++columnIndex));
                    dto.setValue48(rs.getString(++columnIndex));
                    dto.setValue49(rs.getString(++columnIndex));
                    dto.setValue50(rs.getString(++columnIndex));
                    dto.setValue51(rs.getString(++columnIndex));
                    dto.setValue52(rs.getString(++columnIndex));
                    dto.setValue53(rs.getString(++columnIndex));
                    dto.setShippinginfo(rs.getString(++columnIndex));
                    dto.setShippingmethod(rs.getString(++columnIndex));
                    dto.setHomenabroship(rs.getString(++columnIndex));
                    dto.setShippingarea(rs.getString(++columnIndex));
                    dto.setDelvperiodfrom(rs.getString(++columnIndex));
                    dto.setDelvperiodto(rs.getString(++columnIndex));
                    dto.setDelvcostmethod(rs.getString(++columnIndex));
                    dto.setDelvcost1(rs.getString(++columnIndex));
                    dto.setDelvcost2(rs.getString(++columnIndex));
                    dto.setDelvcost3(rs.getString(++columnIndex));
                    dto.setDelvfeesetup(rs.getString(++columnIndex));
                    dto.setValue54(rs.getString(++columnIndex));
                    dto.setValue55(rs.getString(++columnIndex));
                    dto.setValue90(rs.getString(++columnIndex));
                    dto.setValue56(rs.getString(++columnIndex));
                    dto.setValue57(rs.getString(++columnIndex));
                    dto.setValue58(rs.getString(++columnIndex));
                    dto.setValue59(rs.getString(++columnIndex));
                    dto.setValue60(rs.getString(++columnIndex));
                    dto.setValue61(rs.getString(++columnIndex));
                    dto.setValue62(rs.getString(++columnIndex));
                    dto.setValue63(rs.getString(++columnIndex));
                    dto.setValue64(rs.getString(++columnIndex));
                    dto.setValue65(rs.getString(++columnIndex));
                    dto.setValue66(rs.getString(++columnIndex));
                    dto.setValue67(rs.getString(++columnIndex));
                    dto.setValue68(rs.getString(++columnIndex));
                    dto.setValue69(rs.getString(++columnIndex));
                    dto.setValue70(rs.getString(++columnIndex));
                    dto.setValue71(rs.getString(++columnIndex));
                    dto.setValue72(rs.getString(++columnIndex));
                    dto.setValue73(rs.getString(++columnIndex));
                    dto.setValue74(rs.getString(++columnIndex));
                    dto.setValue75(rs.getString(++columnIndex));
                    dto.setValue76(rs.getString(++columnIndex));
                    dto.setValue77(rs.getString(++columnIndex));
                    dto.setValue78(rs.getString(++columnIndex));
                    dto.setProdstats(rs.getString(++columnIndex));
                    dto.setUsedperiod(rs.getString(++columnIndex));
                    dto.setValue79(rs.getString(++columnIndex));
                    dto.setValue80(rs.getString(++columnIndex));
                    dto.setValue81(rs.getString(++columnIndex));
                    dto.setShippingtype(rs.getString(++columnIndex));
                    dto.setOtherval1(rs.getString(++columnIndex));
                    dto.setOtherval2(rs.getString(++columnIndex));
                    dto.setValue82(rs.getString(++columnIndex));
                    dto.setValue83(rs.getString(++columnIndex));
                    dto.setValue84(rs.getString(++columnIndex));
                    dto.setValue85(rs.getString(++columnIndex));
                    dto.setMinorselcnyn(rs.getString(++columnIndex));
                    dto.setOrderqtytype(rs.getString(++columnIndex));
                    dto.setMinimumqty(rs.getString(++columnIndex));
                    dto.setMaximumtype(rs.getString(++columnIndex));
                    dto.setMaximumqty(rs.getString(++columnIndex));
                    dto.setValue86(rs.getString(++columnIndex));
                    dto.setValue87(rs.getString(++columnIndex));
                    dto.setValue88(rs.getString(++columnIndex));
                    dto.setValue89(rs.getString(++columnIndex));
                    dto.setUseyn(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopProductNaverStoreAdditionDto getAdditionaNaverStoreOneList(int seq) throws Exception {
        ShopProductNaverStoreAdditionDto dto = new ShopProductNaverStoreAdditionDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SEQ,''),ifnull(COMPNO,''),ifnull(SHOPCD,''),ifnull(SHOPSEQ,''),ifnull(TITLE,''),ifnull(MEMO,''),ifnull(SHOPID,''),ifnull(PRODSTATS,''),ifnull(MINORTYP,''),ifnull(IMAGE,''),ifnull(ASTELNO,''),ifnull(ASDTL,''),ifnull(STOREMEMBER,''),ifnull(SALLER_DC_RATE,'0'),ifnull(DC_RATE,'0'),ifnull(FLOAT_DC,'0'),ifnull(MARGIN_RATE,'0'),ifnull(COMMISSION_RATE,'0'),ifnull(PRICECOMPARISON,''),ifnull(REVIEW,''),ifnull(MINIMUMTYP,''),ifnull(MINIMUMQTY,''),ifnull(MAXIMUMTYP,''),ifnull(MAXIMUMVAL,''),ifnull(MAXIMUMQTY,''),ifnull(SURTAX,''),ifnull(BANLANGUAGE,''),ifnull(BANLANGUAGEVALUE1,''),ifnull(TAG,''),ifnull(TAGVALUE1,''),ifnull(TAGVALUE2,''),ifnull(TAGVALUE3,''),ifnull(PRODDETAILMODIFY,''),ifnull(PRODCATEMODIFY,''),ifnull(BUYAPPLY,''),ifnull(BUYAPPLYVALUE1,''),ifnull(DVDALBUM,''),ifnull(MOBILECOUPON,''),ifnull(MOBILEVALUE1,''),ifnull(MOBILEVALUESTARTDATE,''),ifnull(MOBILEVALUEENDDATE,''),ifnull(MOBILEVALUE3,''),ifnull(MOBILEVALUE4,''),ifnull(MOBILEVALUE5,''),ifnull(MOBILEVALUE6,''),ifnull(MOBILEVALUE7,''),ifnull(MOBILEVALUE8,''),ifnull(PUBLICATION,''),ifnull(PUBLICATIONVALUE1,''),ifnull(CULTURALEXPENSE,''),ifnull(REQUIREDOPTION,''),ifnull(ADDBUYOPTMODIFY,''),ifnull(ADDBUYOPTIONYN,''),ifnull(EXCLUDEOPTION,''),ifnull(OPTIONLENGTH,''),ifnull(ADDBUYOPTIONLENGTH,''),ifnull(SPECIALCHARVALUE1,''),ifnull(SPECIALCHARVALUE2,''),ifnull(SPECIALCHARVALUE3,''),ifnull(SPECIALCHARVALUE4,''),ifnull(OPTIONSORT,''),ifnull(IMMEDISCOUNT,''),ifnull(IMMEDISCOUNTVALUE1,''),ifnull(IMMEDISCOUNTVALUE2,''),ifnull(IMMEDISCOUNTVALUE3,''),ifnull(IMMEDISSTARTDATE,''),ifnull(IMMEDISENDDATE,''),ifnull(IMMEDISCOUNTVALUE5,''),ifnull(IMMEDISCOUNTVALUE6,''),ifnull(IMMEDISMOBILESTARTDATE,''),ifnull(IMMEDISMOBILEENDDATE,''),ifnull(PLURALBUY,''),ifnull(PLURALBUYVALUE1,''),ifnull(PLURALBUYVALUE2,''),ifnull(PLURALBUYVALUE3,''),ifnull(PLURALBUYVALUE4,''),ifnull(PLURALBUYSTARTDATE,''),ifnull(PLURALBUYENDDATE,''),ifnull(POINTPROD,''),ifnull(POINTPRODVALUE1,''),ifnull(POINTPRODVALUE2,''),ifnull(POINTPRODSTARTDATE,''),ifnull(POINTPRODENDDATE,''),ifnull(POINTREVIEW,''),ifnull(POINTREVIEWVALUE1,''),ifnull(POINTREVIEWVALUE2,''),ifnull(POINTREVIEWVALUE3,''),ifnull(POINTREVIEWVALUE4,''),ifnull(POINTREVIEWVALUE5,''),ifnull(POINTREVIEWSTARTDATE,''),ifnull(POINTREVIEWENDDATE,''),ifnull(INTERESTFREE,''),ifnull(INTERESTFREEVALUE1,''),ifnull(INTERESTFREESTARTDATE,''),ifnull(INTERESTFREEENDDATE,''),ifnull(FREEGIFT,''),ifnull(IMAGERESIZE,''),ifnull(IMAGERESIZE1,''),ifnull(NOTICE,''),ifnull(DUPLICATEREGIS,''),ifnull(DELIVERYTYPE,''),ifnull(GENERALDELVTYP,''),ifnull(CUSTOMORDTYP,''),ifnull(SENDDATE,''),ifnull(OLDSENDDATE,''),ifnull(OLDSENDDATEVALUE1,''),ifnull(SHIPMETHOD,''),ifnull(BUNDLEDSHIPTYP,''),ifnull(BUNDLEDSHIPVALUE1,''),ifnull(BUNDLEDSHIPVALUE2,''),ifnull(BUNDLEDSHIPVALUE3,''),ifnull(BUNDLEDSHIPVALUE4,''),ifnull(BUNDLEDSHIPVALUE5,''),ifnull(BUNDLEDSHIPVALUE6,''),ifnull(BUNDLEDSHIPCD,''),ifnull(SHIPDELVTYP,''),ifnull(SHIPDELVVALUE1,''),ifnull(DELVCOST,''),ifnull(SHIPDELVVALUE2,''),ifnull(SHIPDELVVALUE3,''),ifnull(SHIPDELVVALUE4,''),ifnull(SHIPDELVVALUE5,''),ifnull(SHIPDELVVALUE6,''),ifnull(SHIPDELVVALUE7,''),ifnull(SHIPDELVVALUE8,''),ifnull(SHIPDELVVALUE9,''),ifnull(SHIPDELVVALUE10,''),ifnull(CONDITIONALTYP,''),ifnull(QTYDIVISIONTYP,''),ifnull(RETNCNGEXP,''),ifnull(RETCOST,''),ifnull(CNGCOST,''),ifnull(RETADDR,''),ifnull(OUTADDR,''),ifnull(SPECIFIES,''),ifnull(TITLEYN,''),ifnull(COLLECTIVEAPPLICATION,''),ifnull(COLLECTIVEAPPVALUE1,''),ifnull(BANLANG,''),ifnull(BANLANGVALUE1,''),ifnull(INFOGOSIVALUE1,''),ifnull(INFOGOSIVALUE2,''),ifnull(INFOGOSIVALUE3,''),ifnull(INFOGOSIVALUE4,''),ifnull(INFOGOSIVALUE5,''),ifnull(DELVCOST2,''),ifnull(PREPAYMENT,''),ifnull(AREADELVTYP,''),ifnull(JEJUCOST,''),ifnull(ISLANDCOST,''),ifnull(PRODCDTYP,''),ifnull(PRODCDINPUT,''),ifnull(CHILDCERT,''),ifnull(KCCERT,''),ifnull(ECOCERT,''),ifnull(KCEXEMPTION,''),ifnull(SALESPERIOD,''),ifnull(SALESFROM,''),ifnull(SALESTO,''),ifnull(OPTIONTYP,''),ifnull(CUSTOMMADE,''),ifnull(CUSTOMMADEVALUE1,''),ifnull(SUMMARYTYP1,''),ifnull(SUMMARYVAL1,''),ifnull(SUMMARYTYP2,''),ifnull(SUMMARYVAL2,''),ifnull(SUMMARYTYP3,''),ifnull(SUMMARYVAL3,''),ifnull(SUMMARYTYP4,''),ifnull(SUMMARYVAL4,''),ifnull(SUMMARYTYP5,''),ifnull(SUMMARYVAL5,''),ifnull(PRODNMOUTPUT,''),ifnull(PRODDETAILENDOUTPUT,''),ifnull(PRODNMSTART,''),ifnull(PRODNMEND,''),ifnull(PRODINFOTOP,''),ifnull(PRODINFOBOTTOM,''),ifnull(EVENT,''),ifnull(ORIGIN,''),ifnull(ORIGIN1,''),ifnull(MODELNM,''),ifnull(MODELCHOICE,''),ifnull(BRAND,''),ifnull(MAKER,''),ifnull(INPUTOPT,''),ifnull(USEYN,''),ifnull(FREEGIFT1,''),ifnull(SPECIFIES1,''),ifnull(OUTID,''),ifnull(RETID,''),ifnull(RETDELIVERYID,''),ifnull(BUNDLEID,''),\r\n ifnull(OUTACCOUNTNO,''),ifnull( OUTALIAS,''),ifnull( OUTADDRESSBOOKTYPE,''),ifnull( OUTOVERSEAS1,''),ifnull( OUTAPITYPE,''),ifnull( OUTADDRESS,''),ifnull( OUTBASICADDRESS,''),ifnull( OUTJIBUNADDRESS,''),ifnull( OUTROADNAMEADDRESS,''),ifnull( OUTMASSIVEADDRESS,''),ifnull( OUTDETAILADDRESS,''),ifnull( OUTNEWZIPCODE,''),ifnull( OUTOVERSEAS2,''),ifnull( OUTLATITUDE,''),ifnull( OUTLONGITUDE,''),ifnull( OUTPLACEID,''),ifnull( OUTNAVERMAPCODE,''),ifnull( OUTROADGROUPID,''),ifnull( OUTREPRESENTADDRESSTYPE,''),ifnull( OUTFULLADDRESSINFO,''),ifnull( OUTZIPCODE,''),ifnull( OUTHASROADNAMEADDRESS,''),ifnull( OUTHASJIBUNADDRESS,''),ifnull( RETACCOUNTNO,''),ifnull( RETALIAS,''),ifnull( RETADDRESSBOOKTYPE,''),ifnull( RETOVERSEAS1,''),ifnull( RETAPITYPE,''),ifnull( RETADDRESS,''),ifnull( RETBASICADDRESS,''),ifnull( RETJIBUNADDRESS,''),ifnull( RETROADNAMEADDRESS,''),ifnull( RETMASSIVEADDRESS,''),ifnull( RETDETAILADDRESS,''),ifnull( RETNEWZIPCODE,''),ifnull( RETOVERSEAS2,''),ifnull( RETLATITUDE,''),ifnull( RETLONGITUDE,''),ifnull( RETPLACEID,''),ifnull( RETNAVERMAPCODE,''),ifnull( RETROADGROUPID,''),ifnull( RETREPRESENTADDRESSTYPE,''),ifnull( RETFULLADDRESSINFO,''),ifnull( RETZIPCODE,''),ifnull( RETHASROADNAMEADDRESS,''),ifnull( RETHASJIBUNADDRESS,''),ifnull( REGDATE,''),ifnull( MODDATE,''),ifnull( RETDELIVERYACCOUNTNO,''),ifnull( RETDELICOMPRIORITYTYPE,''),ifnull( NAVERPAYAPPOINTMENT,''),ifnull( DELIVERYCOMPANYNAME,''),ifnull( MEMBERNO,''),ifnull( RETLOGINID,''),ifnull( RETDELINAME,''),ifnull( MEMBERTYPE,''),ifnull( IP,''),ifnull( REQUESTID,''),ifnull( ADMINVIEWTEXT,''),ifnull( BUNDLEACCOUNNO,''),ifnull( BUNDLENAME,''),ifnull( BUNDLEMETHODTYPE,''),ifnull( BUNDLEUSABLE,''),ifnull( BUNDLEBASEGROUP,''),ifnull( BUNDLEREGDATE,''),ifnull( FREEDELIVERY,''),ifnull( EXPPRC,'2500'),IFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX, ''),IFNULL(CHANGESIZEY, ''),IFNULL(CHANGESIZEW, ''),IFNULL(CHANGESIZEH, ''),IFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL, ''), IFNULL(DETAILKEYWORDR, ''), IFNULL(DETAILPRODUCTCODEB,''), IFNULL(DETAILPRODUCTCODEL, ''), IFNULL(DETAILPRODUCTCODER, ''), IFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL, ''), IFNULL(DETAILPRODUCTNAMER, ''), IFNULL(ADDOPTIONLB, ''), IFNULL(ADDOPTIONL, ''), IFNULL(ADDOPTIONRB, ''), IFNULL(ADDOPTIONR, ''), IFNULL(IMGONEONONE, ''), IFNULL(IMGTHREEONFOUR, ''), IFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''),IFNULL(DELIVERYCOMPANYID,''), IFNULL(DELIVERYCOMPANYCODE,''), IMG_ANGLE, IMG_SCALE_PERCENT \r\n from shopaddrnaverstoredtl  where seq=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                YDMAStringUtil.Print("[getAdditionaNaverStoreOneList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setMemo(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setProdstats(rs.getString(++columnIndex));
                    dto.setMinortyp(rs.getString(++columnIndex));
                    dto.setImage(rs.getString(++columnIndex));
                    dto.setAstelno(rs.getString(++columnIndex));
                    dto.setAsdtl(rs.getString(++columnIndex));
                    dto.setStoremember(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setPricecomparison(rs.getString(++columnIndex));
                    dto.setReview(rs.getString(++columnIndex));
                    dto.setMinimumtyp(rs.getString(++columnIndex));
                    dto.setMinimumqty(rs.getString(++columnIndex));
                    dto.setMaximumtyp(rs.getString(++columnIndex));
                    dto.setMaximumval(rs.getString(++columnIndex));
                    dto.setMaximumqty(rs.getString(++columnIndex));
                    dto.setSurtax(rs.getString(++columnIndex));
                    dto.setBanlanguage(rs.getString(++columnIndex));
                    dto.setBanlanguagevalue1(rs.getString(++columnIndex));
                    dto.setTag(rs.getString(++columnIndex));
                    dto.setTagvalue1(rs.getString(++columnIndex));
                    dto.setTagvalue2(rs.getString(++columnIndex));
                    dto.setTagvalue3(rs.getString(++columnIndex));
                    dto.setProddetailmodify(rs.getString(++columnIndex));
                    dto.setProdcatemodify(rs.getString(++columnIndex));
                    dto.setBuyapply(rs.getString(++columnIndex));
                    dto.setBuyapplyvalue1(rs.getString(++columnIndex));
                    dto.setDvdalbum(rs.getString(++columnIndex));
                    dto.setMobilecoupon(rs.getString(++columnIndex));
                    dto.setMobilevalue1(rs.getString(++columnIndex));
                    dto.setMobilevaluestartdate(rs.getString(++columnIndex));
                    dto.setMobilevalueenddate(rs.getString(++columnIndex));
                    dto.setMobilevalue3(rs.getString(++columnIndex));
                    dto.setMobilevalue4(rs.getString(++columnIndex));
                    dto.setMobilevalue5(rs.getString(++columnIndex));
                    dto.setMobilevalue6(rs.getString(++columnIndex));
                    dto.setMobilevalue7(rs.getString(++columnIndex));
                    dto.setMobilevalue8(rs.getString(++columnIndex));
                    dto.setPublication(rs.getString(++columnIndex));
                    dto.setPublicationvalue1(rs.getString(++columnIndex));
                    dto.setCulturalexpense(rs.getString(++columnIndex));
                    dto.setRequiredoption(rs.getString(++columnIndex));
                    dto.setAddbuyoptmodify(rs.getString(++columnIndex));
                    dto.setAddbuyoptionyn(rs.getString(++columnIndex));
                    dto.setExcludeoption(rs.getString(++columnIndex));
                    dto.setOptionlength(rs.getString(++columnIndex));
                    dto.setAddbuyoptionlength(rs.getString(++columnIndex));
                    dto.setSpecialcharvalue1(rs.getString(++columnIndex));
                    dto.setSpecialcharvalue2(rs.getString(++columnIndex));
                    dto.setSpecialcharvalue3(rs.getString(++columnIndex));
                    dto.setSpecialcharvalue4(rs.getString(++columnIndex));
                    dto.setOptionsort(rs.getString(++columnIndex));
                    dto.setImmediscount(rs.getString(++columnIndex));
                    dto.setImmediscountvalue1(rs.getString(++columnIndex));
                    dto.setImmediscountvalue2(rs.getString(++columnIndex));
                    dto.setImmediscountvalue3(rs.getString(++columnIndex));
                    dto.setImmedisstartdate(rs.getString(++columnIndex));
                    dto.setImmedisenddate(rs.getString(++columnIndex));
                    dto.setImmediscountvalue5(rs.getString(++columnIndex));
                    dto.setImmediscountvalue6(rs.getString(++columnIndex));
                    dto.setImmedismobilestartdate(rs.getString(++columnIndex));
                    dto.setImmedismobileenddate(rs.getString(++columnIndex));
                    dto.setPluralbuy(rs.getString(++columnIndex));
                    dto.setPluralbuyvalue1(rs.getString(++columnIndex));
                    dto.setPluralbuyvalue2(rs.getString(++columnIndex));
                    dto.setPluralbuyvalue3(rs.getString(++columnIndex));
                    dto.setPluralbuyvalue4(rs.getString(++columnIndex));
                    dto.setPluralbuystartdate(rs.getString(++columnIndex));
                    dto.setPluralbuyenddate(rs.getString(++columnIndex));
                    dto.setPointprod(rs.getString(++columnIndex));
                    dto.setPointprodvalue1(rs.getString(++columnIndex));
                    dto.setPointprodvalue2(rs.getString(++columnIndex));
                    dto.setPointprodstartdate(rs.getString(++columnIndex));
                    dto.setPointprodenddate(rs.getString(++columnIndex));
                    dto.setPointreview(rs.getString(++columnIndex));
                    dto.setPointreviewvalue1(rs.getString(++columnIndex));
                    dto.setPointreviewvalue2(rs.getString(++columnIndex));
                    dto.setPointreviewvalue3(rs.getString(++columnIndex));
                    dto.setPointreviewvalue4(rs.getString(++columnIndex));
                    dto.setPointreviewvalue5(rs.getString(++columnIndex));
                    dto.setPointreviewstartdate(rs.getString(++columnIndex));
                    dto.setPointreviewenddate(rs.getString(++columnIndex));
                    dto.setInterestfree(rs.getString(++columnIndex));
                    dto.setInterestfreevalue1(rs.getString(++columnIndex));
                    dto.setInterestfreestartdate(rs.getString(++columnIndex));
                    dto.setInterestfreeenddate(rs.getString(++columnIndex));
                    dto.setFreegift(rs.getString(++columnIndex));
                    dto.setImageresize(rs.getString(++columnIndex));
                    dto.setImageresize1(rs.getString(++columnIndex));
                    dto.setNotice(rs.getString(++columnIndex));
                    dto.setDuplicateregis(rs.getString(++columnIndex));
                    dto.setDeliverytype(rs.getString(++columnIndex));
                    dto.setGeneraldelvtyp(rs.getString(++columnIndex));
                    dto.setCustomordtyp(rs.getString(++columnIndex));
                    dto.setSenddate(rs.getString(++columnIndex));
                    dto.setOldsenddate(rs.getString(++columnIndex));
                    dto.setOldsenddatevalue1(rs.getString(++columnIndex));
                    dto.setShipmethod(rs.getString(++columnIndex));
                    dto.setBundledshiptyp(rs.getString(++columnIndex));
                    dto.setBundledshipvalue1(rs.getString(++columnIndex));
                    dto.setBundledshipvalue2(rs.getString(++columnIndex));
                    dto.setBundledshipvalue3(rs.getString(++columnIndex));
                    dto.setBundledshipvalue4(rs.getString(++columnIndex));
                    dto.setBundledshipvalue5(rs.getString(++columnIndex));
                    dto.setBundledshipvalue6(rs.getString(++columnIndex));
                    dto.setBundledshipcd(rs.getString(++columnIndex));
                    dto.setShipdelvtyp(rs.getString(++columnIndex));
                    dto.setShipdelvvalue1(rs.getString(++columnIndex));
                    dto.setDelvcost(rs.getString(++columnIndex));
                    dto.setShipdelvvalue2(rs.getString(++columnIndex));
                    dto.setShipdelvvalue3(rs.getString(++columnIndex));
                    dto.setShipdelvvalue4(rs.getString(++columnIndex));
                    dto.setShipdelvvalue5(rs.getString(++columnIndex));
                    dto.setShipdelvvalue6(rs.getString(++columnIndex));
                    dto.setShipdelvvalue7(rs.getString(++columnIndex));
                    dto.setShipdelvvalue8(rs.getString(++columnIndex));
                    dto.setShipdelvvalue9(rs.getString(++columnIndex));
                    dto.setShipdelvvalue10(rs.getString(++columnIndex));
                    dto.setConditionaltyp(rs.getString(++columnIndex));
                    dto.setQtydivisiontyp(rs.getString(++columnIndex));
                    dto.setRetncngexp(rs.getString(++columnIndex));
                    dto.setRetcost(rs.getString(++columnIndex));
                    dto.setCngcost(rs.getString(++columnIndex));
                    dto.setRetaddr(rs.getString(++columnIndex));
                    dto.setOutaddr(rs.getString(++columnIndex));
                    dto.setSpecifies(rs.getString(++columnIndex));
                    dto.setTitleyn(rs.getString(++columnIndex));
                    dto.setCollectiveapplication(rs.getString(++columnIndex));
                    dto.setCollectiveappvalue1(rs.getString(++columnIndex));
                    dto.setBanlang(rs.getString(++columnIndex));
                    dto.setBanlangvalue1(rs.getString(++columnIndex));
                    dto.setInfogosivalue1(rs.getString(++columnIndex));
                    dto.setInfogosivalue2(rs.getString(++columnIndex));
                    dto.setInfogosivalue3(rs.getString(++columnIndex));
                    dto.setInfogosivalue4(rs.getString(++columnIndex));
                    dto.setInfogosivalue5(rs.getString(++columnIndex));
                    dto.setDelvcost2(rs.getString(++columnIndex));
                    dto.setPrepayment(rs.getString(++columnIndex));
                    dto.setAreadelvtyp(rs.getString(++columnIndex));
                    dto.setJejucost(rs.getString(++columnIndex));
                    dto.setIslandcost(rs.getString(++columnIndex));
                    dto.setProdcdtyp(rs.getString(++columnIndex));
                    dto.setProdcdinput(rs.getString(++columnIndex));
                    dto.setChildcert(rs.getString(++columnIndex));
                    dto.setKccert(rs.getString(++columnIndex));
                    dto.setEcocert(rs.getString(++columnIndex));
                    dto.setKcexemption(rs.getString(++columnIndex));
                    dto.setSalesperiod(rs.getString(++columnIndex));
                    dto.setSalesfrom(rs.getString(++columnIndex));
                    dto.setSalesto(rs.getString(++columnIndex));
                    dto.setOptiontyp(rs.getString(++columnIndex));
                    dto.setCustommade(rs.getString(++columnIndex));
                    dto.setCustommadevalue1(rs.getString(++columnIndex));
                    dto.setSummarytyp1(rs.getString(++columnIndex));
                    dto.setSummaryval1(rs.getString(++columnIndex));
                    dto.setSummarytyp2(rs.getString(++columnIndex));
                    dto.setSummaryval2(rs.getString(++columnIndex));
                    dto.setSummarytyp3(rs.getString(++columnIndex));
                    dto.setSummaryval3(rs.getString(++columnIndex));
                    dto.setSummarytyp4(rs.getString(++columnIndex));
                    dto.setSummaryval4(rs.getString(++columnIndex));
                    dto.setSummarytyp5(rs.getString(++columnIndex));
                    dto.setSummaryval5(rs.getString(++columnIndex));
                    dto.setProdnmoutput(rs.getString(++columnIndex));
                    dto.setProddetailendoutput(rs.getString(++columnIndex));
                    dto.setProdnmstart(rs.getString(++columnIndex));
                    dto.setProdnmend(rs.getString(++columnIndex));
                    dto.setProdinfotop(rs.getString(++columnIndex));
                    dto.setProdinfobottom(rs.getString(++columnIndex));
                    dto.setEvent(rs.getString(++columnIndex));
                    dto.setOrigin(rs.getString(++columnIndex));
                    dto.setOrigin1(rs.getString(++columnIndex));
                    dto.setModelnm(rs.getString(++columnIndex));
                    dto.setModelchoice(rs.getString(++columnIndex));
                    dto.setBrand(rs.getString(++columnIndex));
                    dto.setMaker(rs.getString(++columnIndex));
                    dto.setInputopt(rs.getString(++columnIndex));
                    dto.setUseyn(rs.getString(++columnIndex));
                    dto.setFreegift1(rs.getString(++columnIndex));
                    dto.setSpecifies1(rs.getString(++columnIndex));
                    dto.setOutid(rs.getString(++columnIndex));
                    dto.setRetid(rs.getString(++columnIndex));
                    dto.setRetDeliveryId(rs.getString(++columnIndex));
                    dto.setBundleid(rs.getString(++columnIndex));
                    dto.setOutaccountno(rs.getString(++columnIndex));
                    dto.setOutalias(rs.getString(++columnIndex));
                    dto.setOutaddressbooktype(rs.getString(++columnIndex));
                    dto.setOutoverseas1(rs.getString(++columnIndex));
                    dto.setOutapitype(rs.getString(++columnIndex));
                    dto.setOutaddress(rs.getString(++columnIndex));
                    dto.setOutbasicaddress(rs.getString(++columnIndex));
                    dto.setOutjibunaddress(rs.getString(++columnIndex));
                    dto.setOutroadnameaddress(rs.getString(++columnIndex));
                    dto.setOutmassiveaddress(rs.getString(++columnIndex));
                    dto.setOutdetailaddress(rs.getString(++columnIndex));
                    dto.setOutnewzipcode(rs.getString(++columnIndex));
                    dto.setOutoverseas2(rs.getString(++columnIndex));
                    dto.setOutlatitude(rs.getString(++columnIndex));
                    dto.setOutlongitude(rs.getString(++columnIndex));
                    dto.setOutplaceid(rs.getString(++columnIndex));
                    dto.setOutnavermapcode(rs.getString(++columnIndex));
                    dto.setOutroadgroupid(rs.getString(++columnIndex));
                    dto.setOutrepresentaddresstype(rs.getString(++columnIndex));
                    dto.setOutfulladdressinfo(rs.getString(++columnIndex));
                    dto.setOutzipcode(rs.getString(++columnIndex));
                    dto.setOuthasroadnameaddress(rs.getString(++columnIndex));
                    dto.setOuthasjibunaddress(rs.getString(++columnIndex));
                    dto.setRetaccountno(rs.getString(++columnIndex));
                    dto.setRetalias(rs.getString(++columnIndex));
                    dto.setRetaddressbooktype(rs.getString(++columnIndex));
                    dto.setRetoverseas1(rs.getString(++columnIndex));
                    dto.setRetapitype(rs.getString(++columnIndex));
                    dto.setRetaddress(rs.getString(++columnIndex));
                    dto.setRetbasicaddress(rs.getString(++columnIndex));
                    dto.setRetjibunaddress(rs.getString(++columnIndex));
                    dto.setRetroadnameaddress(rs.getString(++columnIndex));
                    dto.setRetmassiveaddress(rs.getString(++columnIndex));
                    dto.setRetdetailaddress(rs.getString(++columnIndex));
                    dto.setRetnewzipcode(rs.getString(++columnIndex));
                    dto.setRetoverseas2(rs.getString(++columnIndex));
                    dto.setRetlatitude(rs.getString(++columnIndex));
                    dto.setRetlongitude(rs.getString(++columnIndex));
                    dto.setRetplaceid(rs.getString(++columnIndex));
                    dto.setRetnavermapcode(rs.getString(++columnIndex));
                    dto.setRetroadgroupid(rs.getString(++columnIndex));
                    dto.setRetrepresentaddresstype(rs.getString(++columnIndex));
                    dto.setRetfulladdressinfo(rs.getString(++columnIndex));
                    dto.setRetzipcode(rs.getString(++columnIndex));
                    dto.setRethasroadnameaddress(rs.getString(++columnIndex));
                    dto.setRethasjibunaddress(rs.getString(++columnIndex));
                    dto.setRegdate(rs.getString(++columnIndex));
                    dto.setModdate(rs.getString(++columnIndex));
                    dto.setRetdeliveryaccountno(rs.getString(++columnIndex));
                    dto.setRetdelicomprioritytype(rs.getString(++columnIndex));
                    dto.setNaverpayappointment(rs.getString(++columnIndex));
                    dto.setDeliverycompanyname(rs.getString(++columnIndex));
                    dto.setMemberno(rs.getString(++columnIndex));
                    dto.setRetloginid(rs.getString(++columnIndex));
                    dto.setRetdeliname(rs.getString(++columnIndex));
                    dto.setMembertype(rs.getString(++columnIndex));
                    dto.setIp(rs.getString(++columnIndex));
                    dto.setRequestid(rs.getString(++columnIndex));
                    dto.setAdminviewtext(rs.getString(++columnIndex));
                    dto.setBundleaccounno(rs.getString(++columnIndex));
                    dto.setBundlename(rs.getString(++columnIndex));
                    dto.setBundlemethodtype(rs.getString(++columnIndex));
                    dto.setBundleusable(rs.getString(++columnIndex));
                    dto.setBundlebasegroup(rs.getString(++columnIndex));
                    dto.setBundleregdate(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setDeliverycompanyId(rs.getString(++columnIndex));
                    dto.setDeliverycompanyCode(rs.getString(++columnIndex));
                    dto.setAngle(rs.getDouble(++columnIndex));
                    dto.setScalePercent(rs.getDouble(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopProductAuctionAdditionDto getAdditionaAuctionOneList(int seq, String shopcd) throws Exception {
        ShopProductAuctionAdditionDto dto = new ShopProductAuctionAdditionDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SEQ,''),ifnull(COMPNO,''),ifnull(SHOPCD,''),ifnull(TITLE,''),ifnull(SALESMETHOD,''),ifnull(SALEPERIOD,''),ifnull(PREORDERSALE,''),ifnull(PREORDERSALEVALUE1,''),ifnull(PRODSTATUS,''),ifnull(JOINAPPLICATION,''),ifnull(ISBN,''),ifnull(MAXIMUMBUY,''),ifnull(MAXIMUMBUYVALUE1,''),ifnull(MAXIMUMBUYVALUE2,''),ifnull(MAXIMUMBUYVALUE3,''),ifnull(MAXIMUMBUYVALUE4,''),ifnull(YOUTHBUY,''),ifnull(ORIGIN,''),ifnull(PLURALORIGIN,''),ifnull(STANDARD,''),ifnull(STANDARD1,''),ifnull(STANDARD2,''),ifnull(COUPON,''),ifnull(SELLERNICKNAME,''),ifnull(MODELNAME,''),ifnull(MODELNAME1,''),ifnull(BRAND,''),ifnull(BRAND1,''),ifnull(BRAND2,''),ifnull(BRAND3,''),ifnull(REQUIREDOPTION,''),ifnull(ADDITIONALBUY,''),ifnull(OPTIONPRICE,''),ifnull(OPTIONCNT,''),ifnull(OPTIONINVENT,''),ifnull(SOLDOUTOPTION,''),ifnull(RECOMMENDOPTION,''),ifnull(OPTIONVALUE,''),ifnull(OPTIONLENGTH,''),ifnull(SELLERDISCOUNT,''),ifnull(SELLERDISCOUNT1,''),ifnull(SELLERDISCOUNT2,''),ifnull(SELLERDISCOUNT3,''),ifnull(PORTALPRICE,''),ifnull(PRICECOMPARISON,''),ifnull(SITEDISCOUNT,''),ifnull(SPECIALDISCOUNT,''),ifnull(SPECIALDISCOUNT1,''),ifnull(SPECIALDISCOUNT2,''),ifnull(SPECIALDISCOUNT3,''),ifnull(SPECIALDISCOUNT4,''),ifnull(SPECIALDISCOUNT5,''),ifnull(SPECIALDISCOUNT6,''),ifnull(SMILECASH,''),ifnull(SMILECASH1,''),ifnull(DONATION,''),ifnull(DONATION1,''),ifnull(DONATION2,''),ifnull(CHANCE,''),ifnull(CHANCE1,''),ifnull(CHANCE2,''),ifnull(ADDIMAGE,''),ifnull(IMAGERESIZE,''),ifnull(IMAGERESIZE1,''),ifnull(DETAILEXPLAIN,''),ifnull(DUPLIREGIST,''),ifnull(FREEGIFT,''),ifnull(FREEGIFT1,''),ifnull(SHIPMENTPOLICY,''),ifnull(OUTADDRESS,''),ifnull(DELIVERYMETHOD,''),ifnull(DELIVERYMETHOD1,''),ifnull(ADDDELIVERY,''),ifnull(ADDDELIVERY1,''),ifnull(ADDDELIVERY2,''),ifnull(ADDDELIVERY3,''),ifnull(ADDDELIVERY4,''),ifnull(DELIVERYFEESELECT,''),ifnull(DELIVERYFEESELECT1,''),ifnull(DELIVERYFEESELECT2,''),ifnull(DELIVERYFEESELECT3,''),ifnull(DELIVERYFEESELECT4,''),ifnull(DELIVERYFEESELECT5,''),ifnull(DELIVERYFEESELECT6,''),ifnull(DELIVERYFEESELECT7,''),ifnull(DELIVERYFEESELECT8,''),ifnull(DELIVERYFEESELECT9,''),ifnull(DELIVERYFEESELECT10,''),ifnull(DELIVERYFEESELECT11,''),ifnull(DELIVERYFEESELECT12,''),ifnull(DELIVERYFEESELECT13,''),ifnull(DELIVERYFEESELECT14,''),ifnull(DELIVERYFEESELECT15,''),ifnull(DELIVERYFEESELECT16,''),ifnull(DELIVERYFEESELECT17,''),ifnull(ASINFO,''),ifnull(RETURNADDR,''),ifnull(RETEXCHDELIFEE,''),ifnull(COLLECTAPPLICATION,''),ifnull(COLLECTAPPLICATION1,''),ifnull(TITLEYN,''),ifnull(ESTIDELIVERYPERIOD,''),ifnull(OTHERSPECIALNOTE,''),ifnull(MEDICALCERTINFO,''),ifnull(MEDICALCERTINFO1,''),ifnull(MEDICALCERTINFO2,''),ifnull(MEDICALCERTINFO3,''),ifnull(MEDICALCERTINFO4,''),ifnull(PRODGOSILENGTH,''),ifnull(PRODNMOUTPUT,''),ifnull(PRODNMADDFRONT,''),ifnull(PRODNMADDBACK,''),ifnull(PRODDETAILFRONT,''),ifnull(PRODDETAILBACK,''),ifnull(PRODDETAILOUTPUT,''),ifnull(PREMIUM,''),ifnull(PREMIUM1,''),ifnull(PREMIUMPLUS,''),ifnull(PREMIUMPLUS1,''),ifnull(PRODNMVOLD,''),ifnull(PRODNMVOLD1,'') where seq=? and shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[getAdditionaOneList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setMemo(rs.getString(++columnIndex));
                    dto.setSelmthdcd(rs.getString(++columnIndex));
                    dto.setValue1(rs.getString(++columnIndex));
                    dto.setValue2(rs.getString(++columnIndex));
                    dto.setValue3(rs.getString(++columnIndex));
                    dto.setValue4(rs.getString(++columnIndex));
                    dto.setValue5(rs.getString(++columnIndex));
                    dto.setValue6(rs.getString(++columnIndex));
                    dto.setValue7(rs.getString(++columnIndex));
                    dto.setValue8(rs.getString(++columnIndex));
                    dto.setValue9(rs.getString(++columnIndex));
                    dto.setValue10(rs.getString(++columnIndex));
                    dto.setValue11(rs.getString(++columnIndex));
                    dto.setValue12(rs.getString(++columnIndex));
                    dto.setProdstatcd(rs.getString(++columnIndex));
                    dto.setUsedperiod(rs.getString(++columnIndex));
                    dto.setValue13(rs.getString(++columnIndex));
                    dto.setMaximumqtytyp(rs.getString(++columnIndex));
                    dto.setLimitqty(rs.getString(++columnIndex));
                    dto.setLimittime(rs.getString(++columnIndex));
                    dto.setOptexhibition(rs.getString(++columnIndex));
                    dto.setValue14(rs.getString(++columnIndex));
                    dto.setInputtypopt(rs.getString(++columnIndex));
                    dto.setValue15(rs.getString(++columnIndex));
                    dto.setSalesperiod(rs.getString(++columnIndex));
                    dto.setPre_sale(rs.getString(++columnIndex));
                    dto.setValue16(rs.getString(++columnIndex));
                    dto.setImage(rs.getString(++columnIndex));
                    dto.setProdinfoarea(rs.getString(++columnIndex));
                    dto.setProdadditional(rs.getString(++columnIndex));
                    dto.setPromotion(rs.getString(++columnIndex));
                    dto.setAdultgoods(rs.getString(++columnIndex));
                    dto.setChildprod(rs.getString(++columnIndex));
                    dto.setHomeholdprod(rs.getString(++columnIndex));
                    dto.setElectrical(rs.getString(++columnIndex));
                    dto.setChemistry(rs.getString(++columnIndex));
                    dto.setEco(rs.getString(++columnIndex));
                    dto.setMedical(rs.getString(++columnIndex));
                    dto.setOrigin(rs.getString(++columnIndex));
                    dto.setMultiorigin(rs.getString(++columnIndex));
                    dto.setAsdtl(rs.getString(++columnIndex));
                    dto.setShippingpolicy(rs.getString(++columnIndex));
                    dto.setShippingmethod(rs.getString(++columnIndex));
                    dto.setExpress(rs.getString(++columnIndex));
                    dto.setValue17(rs.getString(++columnIndex));
                    dto.setValue69(rs.getString(++columnIndex));
                    dto.setValue70(rs.getString(++columnIndex));
                    dto.setValue18(rs.getString(++columnIndex));
                    dto.setValue19(rs.getString(++columnIndex));
                    dto.setValue20(rs.getString(++columnIndex));
                    dto.setValue21(rs.getString(++columnIndex));
                    dto.setValue22(rs.getString(++columnIndex));
                    dto.setValue23(rs.getString(++columnIndex));
                    dto.setOutaddr(rs.getString(++columnIndex));
                    dto.setBundledyn(rs.getString(++columnIndex));
                    dto.setBundlemaxnmin(rs.getString(++columnIndex));
                    dto.setTemplate(rs.getString(++columnIndex));
                    dto.setDelvcosttyp(rs.getString(++columnIndex));
                    dto.setDelvcost(rs.getString(++columnIndex));
                    dto.setDelvfreecost(rs.getString(++columnIndex));
                    dto.setCostdiscount(rs.getString(++columnIndex));
                    dto.setValue24(rs.getString(++columnIndex));
                    dto.setValue25(rs.getString(++columnIndex));
                    dto.setValue26(rs.getString(++columnIndex));
                    dto.setValue27(rs.getString(++columnIndex));
                    dto.setValue28(rs.getString(++columnIndex));
                    dto.setValue29(rs.getString(++columnIndex));
                    dto.setValue30(rs.getString(++columnIndex));
                    dto.setValue31(rs.getString(++columnIndex));
                    dto.setValue32(rs.getString(++columnIndex));
                    dto.setValue33(rs.getString(++columnIndex));
                    dto.setPrepayment(rs.getString(++columnIndex));
                    dto.setRetnexchangeaddr(rs.getString(++columnIndex));
                    dto.setRetnexchangecost(rs.getString(++columnIndex));
                    dto.setOrderdelaytime(rs.getString(++columnIndex));
                    dto.setValue34(rs.getString(++columnIndex));
                    dto.setValue35(rs.getString(++columnIndex));
                    dto.setValue36(rs.getString(++columnIndex));
                    dto.setValue37(rs.getString(++columnIndex));
                    dto.setValue38(rs.getString(++columnIndex));
                    dto.setValue39(rs.getString(++columnIndex));
                    dto.setValue40(rs.getString(++columnIndex));
                    dto.setValue41(rs.getString(++columnIndex));
                    dto.setValue42(rs.getString(++columnIndex));
                    dto.setValue43(rs.getString(++columnIndex));
                    dto.setValue44(rs.getString(++columnIndex));
                    dto.setValue45(rs.getString(++columnIndex));
                    dto.setValue46(rs.getString(++columnIndex));
                    dto.setValue47(rs.getString(++columnIndex));
                    dto.setValue48(rs.getString(++columnIndex));
                    dto.setValue49(rs.getString(++columnIndex));
                    dto.setValue50(rs.getString(++columnIndex));
                    dto.setValue51(rs.getString(++columnIndex));
                    dto.setValue52(rs.getString(++columnIndex));
                    dto.setValue53(rs.getString(++columnIndex));
                    dto.setValue54(rs.getString(++columnIndex));
                    dto.setValue55(rs.getString(++columnIndex));
                    dto.setValue56(rs.getString(++columnIndex));
                    dto.setValue57(rs.getString(++columnIndex));
                    dto.setValue58(rs.getString(++columnIndex));
                    dto.setValue59(rs.getString(++columnIndex));
                    dto.setValue60(rs.getString(++columnIndex));
                    dto.setValue61(rs.getString(++columnIndex));
                    dto.setValue62(rs.getString(++columnIndex));
                    dto.setValue63(rs.getString(++columnIndex));
                    dto.setValue64(rs.getString(++columnIndex));
                    dto.setValue65(rs.getString(++columnIndex));
                    dto.setValue66(rs.getString(++columnIndex));
                    dto.setValue67(rs.getString(++columnIndex));
                    dto.setValue68(rs.getString(++columnIndex));
                    dto.setUseyn(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopGmarketAdditionDto getAdditionaGmarketOneList(int seq, String shopcd) throws Exception {
        ShopGmarketAdditionDto dto = new ShopGmarketAdditionDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SEQ,''),ifnull(COMPNO,''),ifnull(SHOPCD,''),ifnull(SHOPSEQ,''),ifnull(SHOPID,''),ifnull(TITLE,''),ifnull(SALESMETHOD,''),ifnull(SALEPERIOD,''),ifnull(PRODSTATUS,''),ifnull(PRODSTATUS1,''),ifnull(PRODSTATUS2,''),ifnull(ISBN,''),ifnull(MAXIMUMBUY,''),ifnull(MAXIMUMBUYVALUE1,''),ifnull(MAXIMUMBUYVALUE2,''),ifnull(MAXIMUMBUYVALUE3,''),ifnull(MAXIMUMBUYVALUE4,''),ifnull(YOUTHBUY,''),ifnull(ORIGIN,''),ifnull(PLURALORIGIN,''),ifnull(STANDARD,''),ifnull(STANDARD1,''),ifnull(MODELNAME,''),ifnull(MODELNAME1,''),ifnull(BRAND,''),ifnull(BRAND1,''),ifnull(BRAND2,''),ifnull(BRAND3,''),ifnull(REQUIREDOPTION,''),ifnull(ADDITIONALBUY,''),ifnull(OPTIONPRICE,''),ifnull(OPTIONCNT,''),ifnull(OPTIONINVENT,''),ifnull(SOLDOUTOPTION,''),ifnull(RECOMMENDOPTION,''),ifnull(OPTIONVALUE,''),ifnull(OPTIONLENGTH,''),ifnull(SELLERDISCOUNT,''),ifnull(SELLERDISCOUNT1,''),ifnull(SELLERDISCOUNT2,''),ifnull(SELLERSTARTDAE,''),ifnull(SELLERENDDATE,''),ifnull(PORTALPRICE,''),ifnull(PRICECOMPARISON,''),ifnull(SITEDISCOUNT,''),ifnull(EVENTYN,''),ifnull(OVERSEASSALES,''),ifnull(PLURBUY,''),ifnull(PLURBUY1,''),ifnull(PLURBUYSTARTDATE,''),ifnull(PLURBUYENDDATE,''),ifnull(PLURBUY3,''),ifnull(SMILECASH,''),ifnull(SMILECASH1,''),ifnull(DONATION,''),ifnull(DONATIONSTARTDATE,''),ifnull(DONATIONENDDATE,''),ifnull(DONATION2,''),ifnull(DONATION3,''),ifnull(DONATION4,''),ifnull(BUSINESSLICENSE,''),ifnull(ADDIMAGE,''),ifnull(IMAGERESIZE,''),ifnull(IMAGERESIZE1,''),ifnull(DETAILEXPLAIN,''),ifnull(DUPLIREGIST,''),ifnull(FREEGIFT,''),ifnull(FREEGIFT1,''),ifnull(SALLER_DC_RATE,''),ifnull(DC_RATE,''),ifnull(FLOAT_DC,''),ifnull(MARGIN_RATE,''),ifnull(COMMISSION_RATE,''),ifnull(SHIPMENTPOLICY,''),ifnull(OUTADDRESS,''),ifnull(JEJUFEE,''),ifnull(DTCFEE,''),ifnull(DELIVERYMETHOD,''),ifnull(DELIVERYMETHOD1,''),ifnull(ADDDELIVERY,''),ifnull(ADDDELIVERY1,''),ifnull(ADDDELIVERY2,''),ifnull(ADDDELIVERY3,''),ifnull(ADDDELIVERY4,''),ifnull(ADDDELIVERY5,''),ifnull(ADDDELIVERY6,''),ifnull(ADDDELIVERY7,''),ifnull(DELIVERYFEESELECT,''),ifnull(DELIVERYFEESELECT1,''),ifnull(DELIVERYFEESELECT2,''),ifnull(DELIVERYFEESELECT3,''),ifnull(DELIVERYFEESELECT4,''),ifnull(DELIVERYFEESELECT5,''),ifnull(DELIVERYFEESELECT6,''),ifnull(DELIVERYFEESELECT7,''),ifnull(DELIVERYFEESELECT8,''),ifnull(DELIVERYFEESELECT9,''),ifnull(DELIVERYFEESELECT10,''),ifnull(DELIVERYFEESELECT11,''),ifnull(DELIVERYFEESELECT12,''),ifnull(DELIVERYFEESELECT13,''),ifnull(DELIVERYFEESELECT14,''),ifnull(DELIVERYFEESELECT15,''),ifnull(DELIVERYFEESELECT16,''),ifnull(DELIVERYFEESELECT17,''),ifnull(ASINFO,''),ifnull(RETURNADDR,''),ifnull(RETEXCHDELIFEE,''),ifnull(COLLECTAPPLICATION,''),ifnull(COLLECTAPPLICATION1,''),ifnull(TITLEYN,''),ifnull(ESTIDELIVERYPERIOD,''),ifnull(OTHERSPECIALNOTE,''),ifnull(PRODGOSILENGTH,''),ifnull(PRODNMOUTPUT,''),ifnull(PRODNMADDFRONT,''),ifnull(PRODNMADDBACK,''),ifnull(PRODDETAILFRONT,''),ifnull(PRODDETAILBACK,''),ifnull(PRODDETAILOUTPUT,''),ifnull(FOCUS,''),ifnull(FOCUS1,''),ifnull(FOCUSPLUS,''),ifnull(FOCUSPLUS1,''),ifnull(PLURBUY4,''),ifnull(PLURBUY5,''),ifnull(PLURBUY6,''),ifnull(PLURBUY7,''),ifnull(FREEDELIVERY,''), ifnull(EXPPRC,'2500'),ifnull(CHANGESIZE,''), ifnull(CHANGESIZEX, ''),ifnull(CHANGESIZEY, ''),ifnull(CHANGESIZEW, ''),ifnull(CHANGESIZEH, ''),ifnull(DETAILKEYWORDB,''), ifnull(DETAILKEYWORDL, ''), ifnull(DETAILKEYWORDR, ''), ifnull(DETAILPRODUCTCODEB,''), ifnull(DETAILPRODUCTCODEL, ''), ifnull(DETAILPRODUCTCODER, ''), ifnull(DETAILPRODUCTNAMEB,''), ifnull(DETAILPRODUCTNAMEL, ''), ifnull(DETAILPRODUCTNAMER, ''), ifnull(ADDOPTIONLB, ''), ifnull(ADDOPTIONL, ''), ifnull(ADDOPTIONRB, ''), ifnull(ADDOPTIONR, ''), ifnull(IMGONEONONE, ''), ifnull(IMGTHREEONFOUR, ''),\r\nIFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''), IMG_ANGLE, IMG_SCALE_PERCENT \r\n from shopgmarketadddtl  where seq=? and shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[getAdditionaOneList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setSalesmethod(rs.getString(++columnIndex));
                    dto.setSaleperiod(rs.getString(++columnIndex));
                    dto.setProdstatus(rs.getString(++columnIndex));
                    dto.setProdstatus1(rs.getString(++columnIndex));
                    dto.setProdstatus2(rs.getString(++columnIndex));
                    dto.setIsbn(rs.getString(++columnIndex));
                    dto.setMaximumbuy(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue1(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue2(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue3(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue4(rs.getString(++columnIndex));
                    dto.setYouthbuy(rs.getString(++columnIndex));
                    dto.setOrigin(rs.getString(++columnIndex));
                    dto.setPluralorigin(rs.getString(++columnIndex));
                    dto.setStandard(rs.getString(++columnIndex));
                    dto.setStandard1(rs.getString(++columnIndex));
                    dto.setModelname(rs.getString(++columnIndex));
                    dto.setModelname1(rs.getString(++columnIndex));
                    dto.setBrand(rs.getString(++columnIndex));
                    dto.setBrand1(rs.getString(++columnIndex));
                    dto.setBrand2(rs.getString(++columnIndex));
                    dto.setBrand3(rs.getString(++columnIndex));
                    dto.setRequiredoption(rs.getString(++columnIndex));
                    dto.setAdditionalbuy(rs.getString(++columnIndex));
                    dto.setOptionprice(rs.getString(++columnIndex));
                    dto.setOptioncnt(rs.getString(++columnIndex));
                    dto.setOptioninvent(rs.getString(++columnIndex));
                    dto.setSoldoutoption(rs.getString(++columnIndex));
                    dto.setRecommendoption(rs.getString(++columnIndex));
                    dto.setOptionvalue(rs.getString(++columnIndex));
                    dto.setOptionlength(rs.getString(++columnIndex));
                    dto.setSellerdiscount(rs.getString(++columnIndex));
                    dto.setSellerdiscount1(rs.getString(++columnIndex));
                    dto.setSellerdiscount2(rs.getString(++columnIndex));
                    dto.setSellerstartdate(rs.getString(++columnIndex));
                    dto.setSellerenddate(rs.getString(++columnIndex));
                    dto.setPortalprice(rs.getString(++columnIndex));
                    dto.setPricecomparison(rs.getString(++columnIndex));
                    dto.setSitediscount(rs.getString(++columnIndex));
                    dto.setEventyn(rs.getString(++columnIndex));
                    dto.setOverseassales(rs.getString(++columnIndex));
                    dto.setPlurbuy(rs.getString(++columnIndex));
                    dto.setPlurbuy1(rs.getString(++columnIndex));
                    dto.setPlurbuystartdate(rs.getString(++columnIndex));
                    dto.setPlurbuyenddate(rs.getString(++columnIndex));
                    dto.setPlurbuy3(rs.getString(++columnIndex));
                    dto.setSmilecash(rs.getString(++columnIndex));
                    dto.setSmilecash1(rs.getString(++columnIndex));
                    dto.setDonation(rs.getString(++columnIndex));
                    dto.setDonationstartdate(rs.getString(++columnIndex));
                    dto.setDonationenddate(rs.getString(++columnIndex));
                    dto.setDonation2(rs.getString(++columnIndex));
                    dto.setDonation3(rs.getString(++columnIndex));
                    dto.setDonation4(rs.getString(++columnIndex));
                    dto.setBusinesslicense(rs.getString(++columnIndex));
                    dto.setAddimage(rs.getString(++columnIndex));
                    dto.setImageresize(rs.getString(++columnIndex));
                    dto.setImageresize1(rs.getString(++columnIndex));
                    dto.setDetailexplain(rs.getString(++columnIndex));
                    dto.setDupliregist(rs.getString(++columnIndex));
                    dto.setFreegift(rs.getString(++columnIndex));
                    dto.setFreegift1(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setShipmentpolicy(rs.getString(++columnIndex));
                    dto.setOutaddress(rs.getString(++columnIndex));
                    dto.setJejuAddDeliveryFee(rs.getString(++columnIndex));
                    dto.setBackwoodsAddDeliveryFee(rs.getString(++columnIndex));
                    dto.setDeliverymethod(rs.getString(++columnIndex));
                    dto.setDeliverymethod1(rs.getString(++columnIndex));
                    dto.setAdddelivery(rs.getString(++columnIndex));
                    dto.setAdddelivery1(rs.getString(++columnIndex));
                    dto.setAdddelivery2(rs.getString(++columnIndex));
                    dto.setAdddelivery3(rs.getString(++columnIndex));
                    dto.setAdddelivery4(rs.getString(++columnIndex));
                    dto.setAdddelivery5(rs.getString(++columnIndex));
                    dto.setAdddelivery6(rs.getString(++columnIndex));
                    dto.setAdddelivery7(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect1(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect2(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect3(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect4(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect5(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect6(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect7(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect8(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect9(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect10(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect11(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect12(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect13(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect14(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect15(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect16(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect17(rs.getString(++columnIndex));
                    dto.setAsinfo(rs.getString(++columnIndex));
                    dto.setReturnaddr(rs.getString(++columnIndex));
                    dto.setRetexchdelifee(rs.getString(++columnIndex));
                    dto.setCollectapplication(rs.getString(++columnIndex));
                    dto.setCollectapplication1(rs.getString(++columnIndex));
                    dto.setTitleyn(rs.getString(++columnIndex));
                    dto.setEstideliveryperiod(rs.getString(++columnIndex));
                    dto.setOtherspecialnote(rs.getString(++columnIndex));
                    dto.setProdgosilength(rs.getString(++columnIndex));
                    dto.setProdnmoutput(rs.getString(++columnIndex));
                    dto.setProdnmaddfront(rs.getString(++columnIndex));
                    dto.setProdnmaddback(rs.getString(++columnIndex));
                    dto.setProddetailfront(rs.getString(++columnIndex));
                    dto.setProddetailback(rs.getString(++columnIndex));
                    dto.setProddetailoutput(rs.getString(++columnIndex));
                    dto.setFocus(rs.getString(++columnIndex));
                    dto.setFocus1(rs.getString(++columnIndex));
                    dto.setFocusplus(rs.getString(++columnIndex));
                    dto.setFocusplus1(rs.getString(++columnIndex));
                    dto.setPlurbuy4(rs.getString(++columnIndex));
                    dto.setPlurbuy5(rs.getString(++columnIndex));
                    dto.setPlurbuy6(rs.getString(++columnIndex));
                    dto.setPlurbuy7(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setAngle(rs.getString(++columnIndex));
                    dto.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopProductAdditionDto getAdditionaInterparkOneList(int seq) throws Exception {
        ShopProductInterParkAdditionDto dto = new ShopProductInterParkAdditionDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(compno,''), ifnull(SHOPCD,''),ifnull(SEQ,''),ifnull(TITLE,''),ifnull(MEMO,''),ifnull(SELMTHDCD,''),ifnull(CONTRACTTYPCD,''),ifnull(PRODTYPCD,''), \t  ifnull(PRODSTATCD,''),ifnull(KEYWORD,''),ifnull(PRODNO,''),ifnull(OVERSEASPURCHASED,''),ifnull(MINORSELCNYN,''),ifnull(HEALTHFUNCFOOD,''),ifnull(SALESREPORTING,''),ifnull(SALESREPORTINGNO,''), \t  ifnull(ADREVIEW,''), ifnull(ADREVIEWNO,''), ifnull(ASDTL,''), ifnull(UNIQUENESSYN,''), ifnull(UNIQUENESSVAL,''), ifnull(SALESPERIODYN,''), ifnull(SALESPERIODTYP,''), \t  ifnull(SALESPERIODFROM,''), ifnull(SALESPERIODTO,''),ifnull(QUANTITYYN,''), ifnull(QUANTITYCNT,'0'),ifnull(EXPRESSTYP,''),ifnull(DELVTYPE,''),ifnull(DELVMETHOD,''),ifnull(SHIPPRC,'0'),  \t  ifnull(DELVFREECHK,''), ifnull(SHIPPRC2,'0'),ifnull(DELVQTY,''), ifnull(DELVQTYCOST,''),ifnull(PREPAYMENT,''),  \t  ifnull(SHIPUNIQUENE,''),ifnull(JEJUPRC,'0'),ifnull(ISLANDPRC,'0'),ifnull(ADDRIN,''), ifnull(RETURNSHIPPINGYN,''),ifnull(RETNCNGPRC,''),ifnull(USEYN,'')   from shopaddrinterparkdtl  where seq=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                YDMAStringUtil.Print("[getAdditionaNaverStoreOneList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setMemo(rs.getString(++columnIndex));
                    dto.setSelmthdcd(rs.getString(++columnIndex));
                    dto.setContracttypcd(rs.getString(++columnIndex));
                    dto.setProdtypcd(rs.getString(++columnIndex));
                    dto.setProdstatcd(rs.getString(++columnIndex));
                    dto.setKeyword(rs.getString(++columnIndex));
                    dto.setProdno(rs.getString(++columnIndex));
                    dto.setOverseaspurchased(rs.getString(++columnIndex));
                    dto.setMinorselcnyn(rs.getString(++columnIndex));
                    dto.setHealthfuncfood(rs.getString(++columnIndex));
                    dto.setSalesreporting(rs.getString(++columnIndex));
                    dto.setSalesreportingno(rs.getString(++columnIndex));
                    dto.setAdreview(rs.getString(++columnIndex));
                    dto.setAdreviewno(rs.getString(++columnIndex));
                    dto.setAsdtl(rs.getString(++columnIndex));
                    dto.setUniquenessyn(rs.getString(++columnIndex));
                    dto.setUniquenessval(rs.getString(++columnIndex));
                    dto.setSalesperiodyn(rs.getString(++columnIndex));
                    dto.setSalesperiodtyp(rs.getString(++columnIndex));
                    dto.setSalesperiodfrom(rs.getString(++columnIndex));
                    dto.setSalesperiodto(rs.getString(++columnIndex));
                    dto.setQuantityyn(rs.getString(++columnIndex));
                    dto.setQuantitycnt(rs.getString(++columnIndex));
                    dto.setExpresstyp(rs.getString(++columnIndex));
                    dto.setDelvtype(rs.getString(++columnIndex));
                    dto.setDelvmethod(rs.getString(++columnIndex));
                    dto.setShipprc(rs.getString(++columnIndex));
                    dto.setDelvfreechk(rs.getString(++columnIndex));
                    dto.setShipprc2(rs.getString(++columnIndex));
                    dto.setDelvqty(rs.getString(++columnIndex));
                    dto.setDelvqtycost(rs.getString(++columnIndex));
                    dto.setPrepayment(rs.getString(++columnIndex));
                    dto.setShipuniquene(rs.getString(++columnIndex));
                    dto.setJejuprc(rs.getString(++columnIndex));
                    dto.setIslandprc(rs.getString(++columnIndex));
                    dto.setAddrin(rs.getString(++columnIndex));
                    dto.setReturnshippingyn(rs.getString(++columnIndex));
                    dto.setRetncngprc(rs.getString(++columnIndex));
                    dto.setUseyn(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public int setProductInUpdate(ProductDTO prod, String seq, String dbname) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update " + dbname + "   set GOODS_NM = ?, GOODS_KEYWORD = ?, GOODS_NM_EN = ?, GOODS_NM_PR = ?, MODEL_NM = ?, MODEL_NO = ?, BRAND_NM = ?, COMPAYNY_GOODS_CD = ?, " + " \t  GOODS_SEARCH = ?, CERTNO = ?, AVLST_DM = ?, AVLED_DM = ?, ISSUEDATE = ?, CERTDATE = ?, CERT_AGENCY = ?, CERTFIELD = ?, IMG_PATH23 = ?, " + " \t  GOODS_GUBUN = ?, PARTNER_ID = ?, DPARTNER_ID = ?, CLASS_CD1 = ?, CLASS_CD2 = ?, CLASS_CD3 = ?, CLASS_CD4 = ?, MAKER = ?, ORIGIN = ?, " + " \t  IMPORTNO = ?, IMG_PATH24 = ?, MATERIAL = ?, MAKE_YEAR = ?, MAKE_DM = ?, EXPIRE_DM = ?, SUPPLY_SAVE_YN = ?, GOODS_SEASON = ?, " + " \t  SEX = ?, STATUS = ?, DELIV_ABLE_REGION = ?, DELV_TYPE = ?, DELV_COST = ?, TAX_YN = ?, BANPUM_AREA = ?, GOODS_COST = ?, GOODS_COST2 = ?, GOODS_PRICE = ?, " + " \t  GOODS_CONSUMER_PRICE = ?,  STOCK_USE_YN = ?, OPT_TYPE = ?, IMG_PATH = ?, " + " \t  IMG_PATH1 = ?, IMG_PATH2 = ?, IMG_PATH3 = ?, IMG_PATH4 = ?, IMG_PATH5 = ?, IMG_PATH6 = ?, IMG_PATH7 = ?, IMG_PATH8 = ?, IMG_PATH9 = ?, " + " \t  IMG_PATH10 = ?, IMG_PATH11 = ?, IMG_PATH12 = ?, IMG_PATH13 = ?, IMG_PATH14 = ?, IMG_PATH15 = ?, IMG_PATH16 = ?, IMG_PATH17 = ?, " + " \t  IMG_PATH18 = ?, IMG_PATH19 = ?, IMG_PATH20 = ?, IMG_PATH21 = ?, IMG_PATH22 = ?, " + " \t  DESCRITION = ?, GOODS_REMARKS = ?, GOODS_REMARKS2 = ?, GOODS_REMARKS2 = ?, GOODS_REMARKS4 = ?, " + " \t  PROP1_CD = ?, PROP_VAL1 = ?, PROP_VAL2 = ?, PROP_VAL3 = ?, PROP_VAL4 = ?, PROP_VAL5 = ?, PROP_VAL6 = ?, PROP_VAL7 = ?, PROP_VAL8 = ?, PROP_VAL9 = ?, PROP_VAL10 = ?, " + " \t  PROP_VAL11 = ?, PROP_VAL12 = ?, PROP_VAL13 = ?, PROP_VAL14 = ?, PROP_VAL15 = ?, PROP_VAL16 = ?, PROP_VAL17 = ?, PROP_VAL18 = ?, PROP_VAL19 = ?, PROP_VAL20 = ?, PROP_VAL21 = ?, " + " \t  PROP_VAL22 = ?, PROP_VAL23 = ?, PROP_VAL24 = ?, PROP_VAL25 = ?, PROP_VAL26 = ?, PROP_VAL27 = ?, PROP_VAL28 = ?" + " where COMPNO = ? ";
                sql = dbname.equals("shopprodin") ? String.valueOf(sql) + "and SENDSEQ = ? " : String.valueOf(sql) + "and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, prod.getGoods_nm());
                pstmt.setString(++rowIdx, prod.getGoods_keyword());
                pstmt.setString(++rowIdx, prod.getGoods_nm_en());
                pstmt.setString(++rowIdx, prod.getGoods_nm_pr());
                pstmt.setString(++rowIdx, prod.getModel_nm());
                pstmt.setString(++rowIdx, prod.getModel_no());
                pstmt.setString(++rowIdx, prod.getBrand_nm());
                pstmt.setString(++rowIdx, prod.getCompayny_goods_cd());
                pstmt.setString(++rowIdx, prod.getGoods_search());
                pstmt.setString(++rowIdx, prod.getCertno());
                pstmt.setString(++rowIdx, prod.getAvlst_dm());
                pstmt.setString(++rowIdx, prod.getAvled_dm());
                pstmt.setString(++rowIdx, prod.getIssuedate());
                pstmt.setString(++rowIdx, prod.getCertdate());
                pstmt.setString(++rowIdx, prod.getCert_agency());
                pstmt.setString(++rowIdx, prod.getCertfield());
                pstmt.setString(++rowIdx, prod.getImg_path23());
                pstmt.setString(++rowIdx, prod.getGoods_gubun());
                pstmt.setString(++rowIdx, prod.getPartner_id());
                pstmt.setString(++rowIdx, prod.getDpartner_id());
                pstmt.setString(++rowIdx, prod.getClass_cd1());
                pstmt.setString(++rowIdx, prod.getClass_cd2());
                pstmt.setString(++rowIdx, prod.getClass_cd3());
                pstmt.setString(++rowIdx, prod.getClass_cd4());
                pstmt.setString(++rowIdx, prod.getMaker());
                pstmt.setString(++rowIdx, prod.getOrigin());
                pstmt.setString(++rowIdx, prod.getImportno());
                pstmt.setString(++rowIdx, prod.getImg_path24());
                pstmt.setString(++rowIdx, prod.getMaterial());
                pstmt.setString(++rowIdx, prod.getMake_year());
                pstmt.setString(++rowIdx, prod.getMake_dm());
                pstmt.setString(++rowIdx, prod.getExpire_dm());
                pstmt.setString(++rowIdx, prod.getSupply_save_yn());
                pstmt.setString(++rowIdx, prod.getGoods_season());
                pstmt.setString(++rowIdx, prod.getSex());
                pstmt.setString(++rowIdx, prod.getStatus());
                pstmt.setString(++rowIdx, prod.getDeliv_able_region());
                pstmt.setString(++rowIdx, prod.getDelv_type());
                pstmt.setString(++rowIdx, prod.getDelv_cost());
                pstmt.setString(++rowIdx, prod.getTax_yn());
                pstmt.setString(++rowIdx, prod.getBanpum_area());
                pstmt.setString(++rowIdx, prod.getGoods_cost());
                pstmt.setString(++rowIdx, prod.getGoods_cost2());
                pstmt.setString(++rowIdx, prod.getGoods_price());
                pstmt.setString(++rowIdx, prod.getGoods_consumer_price());
                pstmt.setString(++rowIdx, prod.getStock_use_yn());
                pstmt.setString(++rowIdx, prod.getOpt_type());
                pstmt.setString(++rowIdx, prod.getImg_path());
                pstmt.setString(++rowIdx, prod.getImg_path1());
                pstmt.setString(++rowIdx, prod.getImg_path2());
                pstmt.setString(++rowIdx, prod.getImg_path3());
                pstmt.setString(++rowIdx, prod.getImg_path4());
                pstmt.setString(++rowIdx, prod.getImg_path5());
                pstmt.setString(++rowIdx, prod.getImg_path6());
                pstmt.setString(++rowIdx, prod.getImg_path7());
                pstmt.setString(++rowIdx, prod.getImg_path8());
                pstmt.setString(++rowIdx, prod.getImg_path9());
                pstmt.setString(++rowIdx, prod.getImg_path10());
                pstmt.setString(++rowIdx, prod.getImg_path11());
                pstmt.setString(++rowIdx, prod.getImg_path12());
                pstmt.setString(++rowIdx, prod.getImg_path13());
                pstmt.setString(++rowIdx, prod.getImg_path14());
                pstmt.setString(++rowIdx, prod.getImg_path15());
                pstmt.setString(++rowIdx, prod.getImg_path16());
                pstmt.setString(++rowIdx, prod.getImg_path17());
                pstmt.setString(++rowIdx, prod.getImg_path18());
                pstmt.setString(++rowIdx, prod.getImg_path19());
                pstmt.setString(++rowIdx, prod.getImg_path20());
                pstmt.setString(++rowIdx, prod.getImg_path21());
                pstmt.setString(++rowIdx, prod.getImg_path22());
                pstmt.setString(++rowIdx, prod.getDescrition());
                pstmt.setString(++rowIdx, prod.getGoods_remarks());
                pstmt.setString(++rowIdx, prod.getGoods_remarks2());
                pstmt.setString(++rowIdx, prod.getGoods_remarks3());
                pstmt.setString(++rowIdx, prod.getGoods_remarks4());
                pstmt.setString(++rowIdx, prod.getProp1_cd());
                pstmt.setString(++rowIdx, prod.getProp_val1());
                pstmt.setString(++rowIdx, prod.getProp_val2());
                pstmt.setString(++rowIdx, prod.getProp_val3());
                pstmt.setString(++rowIdx, prod.getProp_val4());
                pstmt.setString(++rowIdx, prod.getProp_val5());
                pstmt.setString(++rowIdx, prod.getProp_val6());
                pstmt.setString(++rowIdx, prod.getProp_val7());
                pstmt.setString(++rowIdx, prod.getProp_val8());
                pstmt.setString(++rowIdx, prod.getProp_val9());
                pstmt.setString(++rowIdx, prod.getProp_val10());
                pstmt.setString(++rowIdx, prod.getProp_val11());
                pstmt.setString(++rowIdx, prod.getProp_val12());
                pstmt.setString(++rowIdx, prod.getProp_val13());
                pstmt.setString(++rowIdx, prod.getProp_val14());
                pstmt.setString(++rowIdx, prod.getProp_val15());
                pstmt.setString(++rowIdx, prod.getProp_val16());
                pstmt.setString(++rowIdx, prod.getProp_val17());
                pstmt.setString(++rowIdx, prod.getProp_val18());
                pstmt.setString(++rowIdx, prod.getProp_val19());
                pstmt.setString(++rowIdx, prod.getProp_val20());
                pstmt.setString(++rowIdx, prod.getProp_val21());
                pstmt.setString(++rowIdx, prod.getProp_val22());
                pstmt.setString(++rowIdx, prod.getProp_val23());
                pstmt.setString(++rowIdx, prod.getProp_val24());
                pstmt.setString(++rowIdx, prod.getProp_val25());
                pstmt.setString(++rowIdx, prod.getProp_val26());
                pstmt.setString(++rowIdx, prod.getProp_val27());
                pstmt.setString(++rowIdx, prod.getProp_val28());
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++rowIdx, seq);
                result = pstmt.executeUpdate();
                YDMAStringUtil.Print("[ShopAddrDtlNaverStoreUpdate]" + pstmt.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public void setProductErrDelete(ShopProductSendDto sendDto) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        List<ProductDTO> prodList = sendDto.getShopProductDto();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopproderr  where sendseq = ?    and compno = ? ";
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductDTO dto : prodList) {
                    int idx = 0;
                    pstmt.setString(++idx, dto.getSENDSEQ());
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int setProductInfoDelete(List<ProductDTO> list) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopprodinfo where prodseq = ? ";
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductDTO dto : list) {
                    pstmt.setString(1, dto.getPRODSEQ());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[setProduct Info Delete]" + pstmt.toString());
                sql = "delete from shop_optprodinfo where prodseq = ? ";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductDTO dto : list) {
                    pstmt.setString(1, dto.getPRODSEQ());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[setProductinfo option Delete]" + pstmt.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                return 0;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int setProductInDelete1(List<ProductDTO> list) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopprodin where prodseq = ? ";
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductDTO dto : list) {
                    pstmt.setString(1, dto.getPRODSEQ());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[setProductInDelete]" + pstmt.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                return 0;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return 1;
    }

    public int setProductInfoAllDelete() throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "truncate table shopprodinfo ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                pstmt.executeUpdate();
                YDMAStringUtil.Print("[setProductInfoAllDelete]" + pstmt.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                return 0;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return 1;
    }

    public List<ProductDTO> setProductInfoConditionDelete(String dome, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        ArrayList<ProductDTO> items;
        block24: {
            Connection connection = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            ResultSet rs = null;
            items = new ArrayList<ProductDTO>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuffer sql = new StringBuffer();
                    sql.append("select prodseq from shopprodinfo \r\n");
                    sql.append(" WHERE COMPNO = ? ");
                    if (!dome.equals("")) {
                        sql.append("     AND GOODS_KEYWORD = ? ");
                    }
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        sql.append(" AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                        sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                    }
                    if (!searchtxt.equals("")) {
                        if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                            String searchtxt1 = "";
                            if (searchtxt.contains("<")) {
                                String[] seartxt2 = searchtxt.split("<");
                                if (seartxt2.length == 2) {
                                    searchtxt1 = searchtxt.replaceAll("<", "");
                                    sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                                } else {
                                    searchtxt1 = searchtxt.replaceAll("<", "");
                                    sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                                }
                            } else if (searchtxt.contains("=")) {
                                searchtxt1 = searchtxt.replaceAll("=", "");
                                sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                            } else if (searchtxt.contains(">")) {
                                searchtxt1 = searchtxt.replaceAll(">", "");
                                sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                            sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                        } else {
                            searchtxt = searchtxt.replace(",", "+|");
                            sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                        }
                    }
                    PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    if (!dome.equals("")) {
                        pstmt.setString(2, dome);
                        if (!prodFrom.equals("") && !prodTo.equals("")) {
                            pstmt.setString(3, prodFrom);
                            pstmt.setString(4, prodTo);
                            pstmt.setString(5, prodFrom);
                            pstmt.setString(6, prodTo);
                        }
                    } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(2, prodFrom);
                        pstmt.setString(3, prodTo);
                        pstmt.setString(4, prodFrom);
                        pstmt.setString(5, prodTo);
                    }
                    YDMAStringUtil.Print("[setProduct Info ConditionDelete]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ProductDTO dto = new ProductDTO();
                        int columnIndex = 0;
                        dto.setPRODSEQ(rs.getString(++columnIndex));
                        items.add(dto);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                    break block24;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return items;
    }

    public int setProductInAllDelete() throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "truncate table shopprodin ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                pstmt.executeUpdate();
                YDMAStringUtil.Print("[setProductInAllDelete]" + pstmt.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                return 0;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return 1;
    }

    public List<ProductDTO> setProductInConditionDelete(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        ArrayList<ProductDTO> items;
        block27: {
            Connection connection = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            ResultSet rs = null;
            items = new ArrayList<ProductDTO>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuffer sql = new StringBuffer();
                    sql.append("select sendseq from shopprodin \r\n");
                    sql.append(" WHERE COMPNO = ? ");
                    if (!dome.equals("")) {
                        sql.append("     AND GOODS_KEYWORD = ? ");
                    }
                    if (folder.equals("")) {
                        sql.append(String.format(" AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%"));
                    } else {
                        sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder));
                    }
                    if (!categ.equals("")) {
                        sql.append(String.valueOf(String.format(" AND CLASS_CD3 like '%s", categ)) + "%'");
                    }
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        sql.append(" AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                        sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                    }
                    if (!searchtxt.equals("")) {
                        if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                            String searchtxt1 = "";
                            if (searchtxt.contains("<")) {
                                String[] seartxt2 = searchtxt.split("<");
                                if (seartxt2.length == 2) {
                                    searchtxt1 = searchtxt.replaceAll("<", "");
                                    sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                                } else {
                                    searchtxt1 = searchtxt.replaceAll("<", "");
                                    sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                                }
                            } else if (searchtxt.contains("=")) {
                                searchtxt1 = searchtxt.replaceAll("=", "");
                                sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                            } else if (searchtxt.contains(">")) {
                                searchtxt1 = searchtxt.replaceAll(">", "");
                                sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                            sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                        } else {
                            searchtxt = searchtxt.replace(",", "+|");
                            sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                        }
                    }
                    PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    if (!dome.equals("")) {
                        pstmt.setString(2, dome);
                        if (!prodFrom.equals("") && !prodTo.equals("")) {
                            pstmt.setString(3, prodFrom);
                            pstmt.setString(4, prodTo);
                            pstmt.setString(5, prodFrom);
                            pstmt.setString(6, prodTo);
                        }
                    } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(2, prodFrom);
                        pstmt.setString(3, prodTo);
                        pstmt.setString(4, prodFrom);
                        pstmt.setString(5, prodTo);
                    }
                    YDMAStringUtil.Print("[setProduct In ConditionDelete]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ProductDTO dto = new ProductDTO();
                        int columnIndex = 0;
                        dto.setSENDSEQ(rs.getString(++columnIndex));
                        items.add(dto);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                    break block27;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return items;
    }

    public int setProductInConditionMove(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        int result = 0;
        new ArrayList();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("update shopprodin set SHOPSENDSTATUS = 7000 \r\n");
                sql.append(" WHERE COMPNO = ? ");
                if (!dome.equals("")) {
                    sql.append("     AND GOODS_KEYWORD = ? ");
                }
                if (folder.equals("")) {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%"));
                } else {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder));
                }
                if (!categ.equals("")) {
                    sql.append(String.valueOf(String.format(" AND CLASS_CD3 like '%s", categ)) + "%'");
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append(" AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                    sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(3, prodFrom);
                        pstmt.setString(4, prodTo);
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                    }
                } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                }
                YDMAStringUtil.Print("[setProductInConditionMove]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int setProductInUpdate(List<ShopProductShortDto> list) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodin set shopprodno = ?, shopsendstatus = ?  where sendseq = ? ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopProductShortDto dto : list) {
                    pstmt.setString(1, dto.getShopprodno());
                    pstmt.setString(2, dto.getShopsendstatus());
                    pstmt.setString(3, dto.getSendseq());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[setProductIn in Update]" + pstmt.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                return 0;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int setProductInDelete(List<ProductDTO> list) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopprodin where sendseq = ? ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductDTO dto : list) {
                    pstmt.setString(1, dto.getSENDSEQ());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[setProductIn in Delete]" + pstmt.toString());
                sql = "delete from shop_optprodin where sendseq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductDTO dto : list) {
                    pstmt.setString(1, dto.getSENDSEQ());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[setProductIn option Delete]" + pstmt.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                return 0;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public void setProductErrUpdate(ShopProductSendDto sendDto) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        List<ProductDTO> prodList = sendDto.getShopProductDto();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " update shopproderr \t   set shopseq = ?, prodseq = ?, seq = ?, shopcatno = ?, descrition = ?, failcontent = ?, modifydt = ?, modifyid = ?   where sendseq = ?     and compno = ?     and shopcd = ?";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductDTO dto : prodList) {
                    int idx = 0;
                    pstmt.setString(++idx, dto.getShopseq());
                    pstmt.setString(++idx, dto.getPRODSEQ());
                    pstmt.setString(++idx, dto.getSeq());
                    pstmt.setString(++idx, dto.getShopcatno());
                    pstmt.setString(++idx, "");
                    pstmt.setString(++idx, dto.getResult_text());
                    pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++idx, dto.getSENDSEQ());
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++idx, dto.getShopcd());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setProductInOneInsert(ProductDTO dto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto idlist, DomesinMarginDto margindto) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                int result = this.setShopProductInOneInsert(dto, dtllist, idlist, margindto);
                if (result > 0) {
                    String sql = "SELECT 1 FROM Shop_OptProdInfo where prodseq = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    int count = 0;
                    pstmt.setString(1, dto.getPRODSEQ());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                    if (count > 0) {
                        this.setShopOptProductInInsert(dto, idlist.getShopcd(), Integer.parseInt(idlist.getShopseq()));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setProductErrOneInsert(ProductDTO dto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto idlist, DomesinMarginDto margindto) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO shopproderr\r\n ( COMPNO, SHOPCD, SHOPSEQ, PRODSEQ, SEQ, SHOPCATNO, MARGINSEQ, DESCRITION, INSERTDT, INSERTID, FAILCONTENT )\r\n VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ) ";
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, idlist.getShopcd());
                pstmt.setString(3, idlist.getShopseq());
                pstmt.setString(4, dto.getPRODSEQ());
                pstmt.setString(5, dtllist.getSeq());
                pstmt.setString(6, dto.getShopCatInDto().getShopcatno());
                pstmt.setString(7, margindto.getMarginseq());
                pstmt.setString(8, "");
                pstmt.setString(9, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(10, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setString(11, dto.getResult_text());
                pstmt.addBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[setProductErrInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int setShopProductInOneInsert(ProductDTO dto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto idlist, DomesinMarginDto margindto) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "INSERT INTO shopprodin\r\n(\r\n\tCOMPNO, SHOPCD, SHOPSEQ, PRODSEQ, SHOPPRODNO, SEQ, SHOPCATNO,MARGINSEQ, GOODS_NM, GOODS_KEYWORD, MODEL_NM, MODEL_NO, BRAND_NM, \r\n\tCOMPAYNY_GOODS_CD, GOODS_SEARCH, GOODS_GUBUN, CLASS_CD1, CLASS_CD2, CLASS_CD3, CLASS_CD4, PARTNER_ID, DPARTNER_ID, MAKER,\r\n\tORIGIN, MAKE_YEAR, MAKE_DM, GOODS_SEASON, SEX, `STATUS`, DELIV_ABLE_REGION, TAX_YN, DELV_TYPE, DELV_COST, BANPUM_AREA, GOODS_COST, \r\n\tGOODS_PRICE, GOODS_CONSUMER_PRICE, CHAR_1_NM, CHAR_1_VAL, CHAR_2_NM, CHAR_2_VAL, IMG_PATH, IMG_PATH1, IMG_PATH2, IMG_PATH3, \r\n\tIMG_PATH4, IMG_PATH5, IMG_PATH6, IMG_PATH7, IMG_PATH8, IMG_PATH9, IMG_PATH10, IMG_PATH11, IMG_PATH12, IMG_PATH13, IMG_PATH14,\r\n\tIMG_PATH15, IMG_PATH16, IMG_PATH17, IMG_PATH18, IMG_PATH19, IMG_PATH20, IMG_PATH21, IMG_PATH22, IMG_PATH23, IMG_PATH24,\r\n\tGOODS_REMARKS, CERTNO, AVLST_DM, AVLED_DM, ISSUEDATE, CERTDATE, CERT_AGENCY, CERTFIELD, MATERIAL, STOCK_USE_YN, OPT_TYPE, PROP_EDIT_YN, \r\n\tPROP1_CD, PROP_VAL1, PROP_VAL2, PROP_VAL3, PROP_VAL4, PROP_VAL5, PROP_VAL6, PROP_VAL7, PROP_VAL8, PROP_VAL9, PROP_VAL10, \r\n\tPROP_VAL11, PROP_VAL12, PROP_VAL13, PROP_VAL14, PROP_VAL15, PROP_VAL16, PROP_VAL17, PROP_VAL18, PROP_VAL19, PROP_VAL20,\r\n\tPROP_VAL21, PROP_VAL22, PROP_VAL23, PROP_VAL24, PROP_VAL25, PROP_VAL26, PROP_VAL27, PROP_VAL28, PACK_CODE_STR, GOODS_NM_EN,\r\n\tGOODS_NM_PR, GOODS_REMARKS2, GOODS_REMARKS3, GOODS_REMARKS4, IMPORTNO, GOODS_COST2, ORIGIN2, EXPIRE_DM, SUPPLY_SAVE_YN, \r\n\tDESCRITION, INSERTDT, INSERTID\r\n)\r\nSELECT \r\nCOMPNO,\r\n? ,  -- SHOPCD\r\n? , -- ID \uc21c\ubc88\r\nPRODSEQ,\r\n? ,  -- \uc1fc\ud551\ubab0 \uc644\ub8cc \ubc88\ud638\r\n?,   -- \ubd80\uac00\uc815\ubcf4\ucf54\ub4dc ..   SHOPDEL SEQ\r\n?,   -- \uce74\ud14c\uace0\ub9ac\uc815\ubcf4\ucf54\ub4dc ..   SHOPCATINF SHOPCATNO\r\n?,   -- \ub9c8\uc9c4\ucf54\ub4dc\uc815\ubcf4 ..   MARGINMNGR MARGINSEQ\r\nGOODS_NM, \r\nGOODS_KEYWORD, MODEL_NM, MODEL_NO, BRAND_NM, \r\nCOMPAYNY_GOODS_CD, GOODS_SEARCH, GOODS_GUBUN, CLASS_CD1, CLASS_CD2, CLASS_CD3, CLASS_CD4, PARTNER_ID, DPARTNER_ID, MAKER, \r\nORIGIN, MAKE_YEAR, MAKE_DM, GOODS_SEASON, SEX, `STATUS`, DELIV_ABLE_REGION, TAX_YN, DELV_TYPE, DELV_COST, BANPUM_AREA, GOODS_COST,\r\nGOODS_PRICE, GOODS_CONSUMER_PRICE, CHAR_1_NM, CHAR_1_VAL, CHAR_2_NM, CHAR_2_VAL, IMG_PATH, IMG_PATH1, IMG_PATH2, IMG_PATH3,\r\nIMG_PATH4, IMG_PATH5, IMG_PATH6, IMG_PATH7, IMG_PATH8, IMG_PATH9, IMG_PATH10, IMG_PATH11, IMG_PATH12, IMG_PATH13, IMG_PATH14,\r\nIMG_PATH15, IMG_PATH16, IMG_PATH17, IMG_PATH18, IMG_PATH19, IMG_PATH20, IMG_PATH21, IMG_PATH22, IMG_PATH23, IMG_PATH24, \r\nGOODS_REMARKS, CERTNO, AVLST_DM, AVLED_DM, ISSUEDATE, CERTDATE, CERT_AGENCY, CERTFIELD, MATERIAL, STOCK_USE_YN, OPT_TYPE, PROP_EDIT_YN, \r\nPROP1_CD, PROP_VAL1, PROP_VAL2, PROP_VAL3, PROP_VAL4, PROP_VAL5, PROP_VAL6, PROP_VAL7, PROP_VAL8, PROP_VAL9, PROP_VAL10,\r\nPROP_VAL11, PROP_VAL12, PROP_VAL13, PROP_VAL14, PROP_VAL15, PROP_VAL16, PROP_VAL17, PROP_VAL18, PROP_VAL19, PROP_VAL20,\r\nPROP_VAL21, PROP_VAL22, PROP_VAL23, PROP_VAL24, PROP_VAL25, PROP_VAL26, PROP_VAL27, PROP_VAL28, PACK_CODE_STR, GOODS_NM_EN, \r\nGOODS_NM_PR, GOODS_REMARKS2, GOODS_REMARKS3, GOODS_REMARKS4, IMPORTNO, GOODS_COST2, ORIGIN2, EXPIRE_DM, SUPPLY_SAVE_YN,\r\nDESCRITION, NOW(), ?   -- \uc0ac\uc6a9\uc790 \uc544\uc774\ub514.. \r\nFROM SHOPPRODINFO \r\nWHERE COMPNO = ? AND PRODSEQ = ? AND COMPAYNY_GOODS_CD = ?";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, idlist.getShopcd());
                pstmt.setString(2, idlist.getShopseq());
                pstmt.setString(3, dto.getShopprodno());
                pstmt.setString(4, dtllist.getSeq());
                pstmt.setString(5, dto.getShopCatInDto().getShopcatno());
                pstmt.setString(6, margindto.getMarginseq());
                pstmt.setString(7, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setString(8, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(9, dto.getPRODSEQ());
                pstmt.setString(10, dto.getCompayny_goods_cd());
                ++result;
                pstmt.addBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[setShopProductInOneInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public ProductDTO getProductInfoCompaynyCode(String icode) throws Exception {
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        ProductDTO dto = new ProductDTO();
        new ArrayList();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" WITH CateAll AS(                                                                 \r\n");
                sql.append("\t\tSELECT                                                                    \r\n");
                sql.append("\t\t   ifnull(a.CODE,'')     AS CLASS_CD1 ,                                   \r\n");
                sql.append("\t\t\tifnull(a.CATEGORY,'') AS CLASS_NM1 ,                                  \r\n");
                sql.append("\t\t\tIFNULL(RIGHT(b.CODE,3),'')     AS CLASS_CD2  ,                        \r\n");
                sql.append("\t\t\tifnull(b.CATEGORY,'') AS CLASS_NM2 ,                                  \r\n");
                sql.append("\t\t\tifnull(RIGHT(c.CODE,3),'')     AS CLASS_CD3,                          \r\n");
                sql.append("\t\t\tifnull(C.CATEGORY,'') AS CLASS_NM3,                                   \r\n");
                sql.append("\t\t\tifnull(RIGHT(D.CODE,3),'')     AS CLASS_CD4 ,                         \r\n");
                sql.append("\t\t\tifnull(D.CATEGORY,'') AS CLASS_NM4                                    \r\n");
                sql.append("\t\tFROM CATEGLARGE a left JOIN CATEGMIDIUM b                                      \r\n");
                sql.append("\t\t\tON a.COMPNO=b.COMPNO AND a.CODE = b.LRGCODE left JOIN CATEGSMALL C         \r\n");
                sql.append("\t\t\tON a.COMPNO = C.COMPNO AND b.CODE = C.MIDCODE left JOIN CATEGDETAIL D ON   \r\n");
                sql.append(String.format(" a.COMPNO = D.COMPNO AND C.CODE = D.SMLCODE WHERE a.compno = '%s'         \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                sql.append("\t\t )                                                                        \r\n");
                sql.append(" SELECT INFO.*  , \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM1, '')  CLASS_NM1, \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM2, '')  CLASS_NM2, \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM3, '')  CLASS_NM3, \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM4, '')  CLASS_NM4, \r\n");
                sql.append("(CASE                                   \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '1'         \r\n");
                sql.append("\t     THEN '\uc704\ud0c1\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '2'         \r\n");
                sql.append("\t     THEN '\uc81c\uc870\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '3'         \r\n");
                sql.append("\t     THEN '\uc0ac\uc5c5\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '4'         \r\n");
                sql.append("\t     THEN '\uc9c1\uc601\uc0c1\ud488'                \r\n");
                sql.append("\t     ELSE ''                        \r\n");
                sql.append("\t  END )AS GOODS_GUBUN_NM,            \r\n");
                sql.append("(CASE                            \r\n");
                sql.append("\t     WHEN STATUS = '1'       \r\n");
                sql.append("\t     THEN '\ub300\uae30\uc911'           \r\n");
                sql.append("\t     WHEN STATUS = '2'       \r\n");
                sql.append("\t     THEN '\uacf5\uae09\uc911'           \r\n");
                sql.append("\t     WHEN STATUS = '3'       \r\n");
                sql.append("\t     THEN '\uc77c\uc2dc\uc911\uc9c0'         \r\n");
                sql.append("\t     WHEN STATUS = '4'       \r\n");
                sql.append("\t     THEN '\uc644\uc804\ud488\uc808'         \r\n");
                sql.append("\t      WHEN STATUS = '5'      \r\n");
                sql.append("\t     THEN '\ubbf8\uc0ac\uc6a9'           \r\n");
                sql.append("\t      WHEN STATUS = '6'      \r\n");
                sql.append("\t     THEN '\uc0ad\uc81c'             \r\n");
                sql.append("\t     ELSE ''                 \r\n");
                sql.append("\t  END )AS STATUS_NM,         \r\n");
                sql.append("(CASE                             \r\n");
                sql.append("\t     WHEN DELV_TYPE = '1'     \r\n");
                sql.append("\t     THEN '\ubb34\ub8cc'              \r\n");
                sql.append("\t     WHEN DELV_TYPE = '2'     \r\n");
                sql.append("\t     THEN '\ucc29\ubd88'              \r\n");
                sql.append("\t     WHEN DELV_TYPE = '3'     \r\n");
                sql.append("\t     THEN '\uc120\uacb0\uc81c'            \r\n");
                sql.append("\t     WHEN DELV_TYPE = '4'     \r\n");
                sql.append("\t     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n");
                sql.append("\t     ELSE ''                  \r\n");
                sql.append("\t  END )AS DELV_TYPE_NM       \r\n");
                sql.append(" FROM                             \r\n");
                sql.append(" (SELECT                           \r\n");
                sql.append(" CONCAT(IFNULL(CLASS_CD1,''), IFNULL(CLASS_CD2,''), IFNULL(CLASS_CD3,''), IFNULL(CLASS_CD4,'')) AS CODE, \r\n");
                sql.append("IFNULL(PRODSEQ,'' ) AS PRODSEQ,  \r\n ");
                sql.append("IFNULL(COMPNO,'' ) AS COMPNO,  \r\n ");
                sql.append(String.format("YWM_FUNC_BOSSPRODCD(%s,COMPAYNY_GOODS_CD) as img,", YDMASessonUtil.getCompnoInfo().getCompno()));
                sql.append("IFNULL(GOODS_NM,'' ) AS GOODS_NM,  \r\n ");
                sql.append("IFNULL(GOODS_KEYWORD,'' ) AS GOODS_KEYWORD,  \r\n ");
                sql.append("IFNULL(MODEL_NM,'' ) AS MODEL_NM,  \r\n ");
                sql.append("IFNULL(MODEL_NO,'' ) AS MODEL_NO,  \r\n ");
                sql.append("IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n ");
                sql.append("IFNULL(COMPAYNY_GOODS_CD,'' ) AS COMPAYNY_GOODS_CD,  \r\n ");
                sql.append("IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n ");
                sql.append("IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n ");
                sql.append("IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n ");
                sql.append("IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n ");
                sql.append("IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n ");
                sql.append("IFNULL(CLASS_CD4,'' ) AS CLASS_CD4,  \r\n ");
                sql.append("IFNULL(PARTNER_ID,'' ) AS PARTNER_ID,  \r\n ");
                sql.append("IFNULL(DPARTNER_ID,'' ) AS DPARTNER_ID,  \r\n ");
                sql.append("IFNULL(MAKER,'' ) AS MAKER,  \r\n ");
                sql.append("IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n ");
                sql.append("IFNULL(MAKE_YEAR,'' ) AS MAKE_YEAR,  \r\n ");
                sql.append("IFNULL(MAKE_DM,'' ) AS MAKE_DM,  \r\n ");
                sql.append("IFNULL(GOODS_SEASON,'' ) AS GOODS_SEASON,  \r\n ");
                sql.append("IFNULL(SEX,'' ) AS SEX,  \r\n ");
                sql.append("IFNULL(STATUS,'' ) AS STATUS,  \r\n ");
                sql.append("IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n ");
                sql.append("IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n ");
                sql.append("IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n ");
                sql.append("IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n ");
                sql.append("IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n ");
                sql.append("IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n ");
                sql.append("IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n ");
                sql.append("IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n ");
                sql.append("IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n ");
                sql.append("IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n ");
                sql.append("IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n ");
                sql.append("IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n ");
                sql.append("IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n ");
                sql.append("IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n ");
                sql.append("IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n ");
                sql.append("IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n ");
                sql.append("IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n ");
                sql.append("IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n ");
                sql.append("IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n ");
                sql.append("IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n ");
                sql.append("IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n ");
                sql.append("IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n ");
                sql.append("IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n ");
                sql.append("IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n ");
                sql.append("IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n ");
                sql.append("IFNULL(IMG_PATH13,'' ) AS IMG_PATH13,  \r\n ");
                sql.append("IFNULL(IMG_PATH14,'' ) AS IMG_PATH14,  \r\n ");
                sql.append("IFNULL(IMG_PATH15,'' ) AS IMG_PATH15,  \r\n ");
                sql.append("IFNULL(IMG_PATH16,'' ) AS IMG_PATH16,  \r\n ");
                sql.append("IFNULL(IMG_PATH17,'' ) AS IMG_PATH17,  \r\n ");
                sql.append("IFNULL(IMG_PATH18,'' ) AS IMG_PATH18,  \r\n ");
                sql.append("IFNULL(IMG_PATH19,'' ) AS IMG_PATH19,  \r\n ");
                sql.append("IFNULL(IMG_PATH20,'' ) AS IMG_PATH20,  \r\n ");
                sql.append("IFNULL(IMG_PATH21,'' ) AS IMG_PATH21,  \r\n ");
                sql.append("IFNULL(IMG_PATH22,'' ) AS IMG_PATH22,  \r\n ");
                sql.append("IFNULL(IMG_PATH23,'' ) AS IMG_PATH23,  \r\n ");
                sql.append("IFNULL(IMG_PATH24,'' ) AS IMG_PATH24,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n ");
                sql.append("IFNULL(CERTNO,'' ) AS CERTNO,  \r\n ");
                sql.append("IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n ");
                sql.append("IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n ");
                sql.append("IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n ");
                sql.append("IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n ");
                sql.append("IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n ");
                sql.append("IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n ");
                sql.append("IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n ");
                sql.append("IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n ");
                sql.append("IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n ");
                sql.append("IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n ");
                sql.append("IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n ");
                sql.append("IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n ");
                sql.append("IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n ");
                sql.append("IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n ");
                sql.append("IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n ");
                sql.append("IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n ");
                sql.append("IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n ");
                sql.append("IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n ");
                sql.append("IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n ");
                sql.append("IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n ");
                sql.append("IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n ");
                sql.append("IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n ");
                sql.append("IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n ");
                sql.append("IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n ");
                sql.append("IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n ");
                sql.append("IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n ");
                sql.append("IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n ");
                sql.append("IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n ");
                sql.append("IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n ");
                sql.append("IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n ");
                sql.append("IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n ");
                sql.append("IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n ");
                sql.append("IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n ");
                sql.append("IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n ");
                sql.append("IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n ");
                sql.append("IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n ");
                sql.append("IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n ");
                sql.append("IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n ");
                sql.append("IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n ");
                sql.append("IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n ");
                sql.append("IFNULL(GOODS_NM_EN,'' ) AS GOODS_NM_EN,  \r\n ");
                sql.append("IFNULL(GOODS_NM_PR,'' ) AS GOODS_NM_PR,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,  \r\n ");
                sql.append("IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n ");
                sql.append("IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n ");
                sql.append("IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n ");
                sql.append("IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n ");
                sql.append("IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n ");
                sql.append("IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n ");
                sql.append("IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n ");
                sql.append("IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n ");
                sql.append("IFNULL(INSERTID,'' ) AS INSERTID,  \r\n ");
                sql.append("IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n ");
                sql.append("IFNULL(MODIFYID,'' ) AS MODIFYID  \r\n ");
                sql.append(" FROM SHOPPRODINFO \r\n");
                sql.append(" WHERE COMPNO = ?  AND COMPAYNY_GOODS_CD = ? \r\n");
                sql.append(" ) AS INFO  LEFT JOIN CateAll AS CATE  \r\n");
                sql.append("\t\t ON INFO.CLASS_CD1 = CATE.CLASS_CD1  \r\n");
                sql.append(" \t\t AND INFO.CLASS_CD2 = CATE.CLASS_CD2 \r\n");
                sql.append("AND INFO.CLASS_CD3 = CATE.CLASS_CD3   \r\n");
                sql.append("AND INFO.CLASS_CD4 = CATE.CLASS_CD4   \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, compno);
                pstmt.setString(2, icode);
                YDMAStringUtil.Print("[getShopProductInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    dto.setRowno("" + ++rowno);
                    dto.setCode(rs.getString("CODE"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setImg(rs.getString("Img"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year(rs.getString("MAKE_YEAR"));
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season(rs.getString("GOODS_SEASON"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setClass_nm1(rs.getString("CLASS_NM1"));
                    dto.setClass_nm2(rs.getString("CLASS_NM2"));
                    dto.setClass_nm3(rs.getString("CLASS_NM3"));
                    dto.setClass_nm4(rs.getString("CLASS_NM4"));
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setGoods_gubun_nm(rs.getString("GOODS_GUBUN_NM"));
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public String getUpdateQueryMapper(List<String> lstUpdate, String tableName) {
        StringBuilder sb_result = new StringBuilder();
        sb_result.append(String.format("UPDATE  %s  SET ", tableName));
        String str_update = lstUpdate.stream().map(p -> p.concat(" = ?")).collect(Collectors.joining(","));
        sb_result.append(str_update);
        return sb_result.toString();
    }

    public String getInsertQueryMapper(List<String> lstInsert, String tableName) {
        StringBuilder sb_result = new StringBuilder();
        sb_result.append(String.format("INSERT INTO %s ", tableName));
        String head = lstInsert.stream().collect(Collectors.joining(",", "(", ") "));
        String bottom = lstInsert.stream().map(p -> String.valueOf("?")).collect(Collectors.joining(",", " VALUES (", ") "));
        sb_result.append(head);
        sb_result.append(bottom);
        return sb_result.toString();
    }

    public void setShopProdInfoUpdate(List<ProductDTO> list, int modifyNo, boolean foundId) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                StringBuilder sql = new StringBuilder();
                sql.append(" update shopprodinfo set \r\n");
                if (modifyNo == 1) {
                    sql.append("SHOP_CID_INFO = ? ,\r\n ");
                    sql.append("GMCATEGNM = ? ,\r\n ");
                    if (foundId) {
                        sql.append("CLASS_CD3 = ? ,\r\n ");
                    }
                } else if (modifyNo == 2) {
                    sql.append("GOODS_NM = ? ,\r\n ");
                } else if (modifyNo == 3) {
                    sql.append("GOODS_SEARCH = ? ,\r\n ");
                }
                sql.append("SHOPMODIFYCONTENT = ? ,\r\n ");
                sql.append("SELFMOD_NO =  ? ,\r\n ");
                sql.append("SHOPSENDSTATUS = ? ,\r\n ");
                sql.append("modifydt = ? \r\n ");
                sql.append("where PRODSEQ = ? and compno = ? ");
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductDTO dto : list) {
                    int idx = 0;
                    if (modifyNo == 1) {
                        pstmt.setString(++idx, dto.getShop_cid_info());
                        pstmt.setString(++idx, dto.getGmcategnm());
                        if (foundId) {
                            pstmt.setString(++idx, dto.getClass_cd3());
                        }
                    } else if (modifyNo == 2) {
                        pstmt.setString(++idx, dto.getGoods_nm());
                    } else if (modifyNo == 3) {
                        pstmt.setString(++idx, dto.getGoods_search());
                    }
                    pstmt.setString(++idx, dto.getShopmodifycontent());
                    if (dto.getSelfmod_no().equals("")) {
                        pstmt.setString(++idx, ":" + Integer.toString(modifyNo));
                    } else if (dto.getSelfmod_no().contains(Integer.toString(modifyNo))) {
                        pstmt.setString(++idx, dto.getSelfmod_no());
                    } else {
                        pstmt.setString(++idx, String.valueOf(dto.getSelfmod_no()) + ":" + Integer.toString(modifyNo));
                    }
                    pstmt.setInt(++idx, 6100);
                    pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++idx, dto.getPRODSEQ());
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[Update shopprodinfo]" + pstmt.toString());
                if (result > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearParameters();
                }
            }
            catch (Exception e) {
                connection.rollback();
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setShopProductInUpdate(List<ProductDTO> childList, int modifyNo) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                StringBuilder sql = new StringBuilder();
                sql.append(" update shopprodin set \r\n");
                if (modifyNo == 1) {
                    sql.append("SHOPCATNO = ? ,\r\n ");
                    sql.append("TEXT_OPTION = ? ,\r\n ");
                    sql.append("CLASS_CD1 = ? ,\r\n ");
                    sql.append("CLASS_CD2 = ? ,\r\n ");
                    sql.append("CLASS_CD3 = ? ,\r\n ");
                    sql.append("CLASS_CD4 = ? ,\r\n ");
                    sql.append("SHOP_CID_INFO = ? ,\r\n ");
                } else if (modifyNo == 2) {
                    sql.append("GOODS_NM = ? ,\r\n ");
                } else if (modifyNo == 3) {
                    sql.append("GOODS_SEARCH = ? ,\r\n ");
                }
                sql.append("SHOPMODIFYCONTENT = ? ,\r\n ");
                sql.append("SELFMOD_NO =  ? ,\r\n ");
                sql.append("SHOPSENDSTATUS = ? ,\r\n ");
                sql.append("modifydt = ? ,\r\n ");
                sql.append("modifyid = ? \r\n ");
                sql.append("where sendseq = ? and compno = ? ");
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                for (ProductDTO dto : childList) {
                    String selmodNo = this.isShopProductInExits(dto.getSENDSEQ(), dto.getShopcd());
                    if (selmodNo.length() <= 0) continue;
                    int j = 0;
                    if (modifyNo == 1) {
                        pstmt.setString(++j, dto.getShopcatcd());
                        pstmt.setString(++j, dto.getText_option());
                        pstmt.setString(++j, dto.getClass_cd1());
                        pstmt.setString(++j, dto.getClass_cd2());
                        pstmt.setString(++j, dto.getClass_cd3());
                        pstmt.setString(++j, dto.getClass_cd4());
                        pstmt.setString(++j, dto.getShop_cid_info());
                    } else if (modifyNo == 2) {
                        pstmt.setString(++j, dto.getGoods_nm());
                    } else if (modifyNo == 3) {
                        pstmt.setString(++j, dto.getGoods_search());
                    }
                    pstmt.setString(++j, dto.getShopmodifycontent());
                    if (selmodNo.substring(1).contains(Integer.toString(modifyNo))) {
                        pstmt.setString(++j, selmodNo.substring(1));
                    } else {
                        pstmt.setString(++j, String.valueOf(selmodNo.substring(1)) + ":" + Integer.toString(modifyNo));
                    }
                    if (dto.getSendstats().equals(String.valueOf(9000))) {
                        pstmt.setInt(++j, 9000);
                    } else {
                        pstmt.setInt(++j, 6000);
                    }
                    pstmt.setString(++j, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++j, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++j, dto.getSENDSEQ());
                    pstmt.setString(++j, YDMASessonUtil.getCompnoInfo().getCompno());
                    YDMAStringUtil.Print("[setShopProductInUpdate]" + pstmt.toString());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                if (result > 0) {
                    pstmt.executeBatch();
                    connection.setAutoCommit(true);
                    pstmt.clearBatch();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    private String isShopProductInExits(String sendseq, String shopcd) {
        String result;
        block12: {
            result = "";
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT ifnull(SELFMOD_NO,'') as SELFMOD_NO, 1 AS CNT   FROM shopprodin  WHERE SENDSEQ=?    AND SHOPCD=?";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, sendseq);
                    pstmt_orddtl.setString(2, shopcd);
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        result = String.valueOf(rs.getString("CNT")) + rs.getString("SELFMOD_NO");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean isShopProductJustOne() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean result = true;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COUNT(*) FROM SHOPPRODINFO";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    boolean bl = result = rs.getInt(1) > 0;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int ShopProdInfoUpdate(ProductDTO infoDto) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("GOODS_NM");
                lstUpdate.add("GOODS_KEYWORD");
                lstUpdate.add("MODEL_NM");
                lstUpdate.add("BRAND_NM");
                lstUpdate.add("COMPAYNY_GOODS_CD");
                lstUpdate.add("GOODS_SEARCH");
                lstUpdate.add("SHOP_CID_INFO");
                lstUpdate.add("CLASS_CD1");
                lstUpdate.add("CLASS_CD2");
                lstUpdate.add("CLASS_CD3");
                lstUpdate.add("CLASS_CD4");
                lstUpdate.add("MAKER");
                lstUpdate.add("ORIGIN");
                lstUpdate.add("TAX_YN");
                lstUpdate.add("DELV_TYPE");
                lstUpdate.add("DELV_COST");
                lstUpdate.add("GOODS_COST");
                lstUpdate.add("GOODS_PRICE");
                lstUpdate.add("CHAR_1_NM");
                lstUpdate.add("CHAR_1_VAL");
                lstUpdate.add("CHAR_2_NM");
                lstUpdate.add("CHAR_2_VAL");
                lstUpdate.add("IMG_PATH");
                lstUpdate.add("IMG_PATH1");
                lstUpdate.add("IMG_PATH2");
                lstUpdate.add("IMG_PATH3");
                lstUpdate.add("IMG_PATH4");
                lstUpdate.add("IMG_PATH5");
                lstUpdate.add("IMG_PATH6");
                lstUpdate.add("IMG_PATH7");
                lstUpdate.add("IMG_PATH8");
                lstUpdate.add("IMG_PATH9");
                lstUpdate.add("GOODS_REMARKS");
                lstUpdate.add("CERT_TYPE");
                lstUpdate.add("CERT");
                lstUpdate.add("CERTNO");
                lstUpdate.add("AVLED_DM");
                lstUpdate.add("CERTDATE");
                lstUpdate.add("CERT_AGENCY");
                lstUpdate.add("CERTMODEL");
                lstUpdate.add("CERTNAME");
                lstUpdate.add("EXEMPTIONTYPE");
                lstUpdate.add("PROP1_CD");
                lstUpdate.add("PROP_VAL1");
                lstUpdate.add("PROP_VAL2");
                lstUpdate.add("PROP_VAL3");
                lstUpdate.add("PROP_VAL4");
                lstUpdate.add("PROP_VAL5");
                lstUpdate.add("PROP_VAL6");
                lstUpdate.add("PROP_VAL7");
                lstUpdate.add("PROP_VAL8");
                lstUpdate.add("PROP_VAL9");
                lstUpdate.add("PROP_VAL10");
                lstUpdate.add("PROP_VAL11");
                lstUpdate.add("PROP_VAL12");
                lstUpdate.add("PROP_VAL13");
                lstUpdate.add("PROP_VAL14");
                lstUpdate.add("PROP_VAL15");
                lstUpdate.add("PROP_VAL16");
                lstUpdate.add("PROP_VAL17");
                lstUpdate.add("PROP_VAL18");
                lstUpdate.add("PROP_VAL19");
                lstUpdate.add("PROP_VAL20");
                lstUpdate.add("PROP_VAL21");
                lstUpdate.add("PROP_VAL22");
                lstUpdate.add("PROP_VAL23");
                lstUpdate.add("PROP_VAL24");
                lstUpdate.add("PROP_VAL25");
                lstUpdate.add("PROP_VAL26");
                lstUpdate.add("PROP_VAL27");
                lstUpdate.add("PROP_VAL28");
                lstUpdate.add("GOODS_REMARKS2");
                lstUpdate.add("GOODS_REMARKS3");
                lstUpdate.add("MODIFYDT");
                lstUpdate.add("SHOPSENDSTATUS");
                lstUpdate.add("ShopModifyContent");
                lstUpdate.add("SELFMOD_NO");
                StringBuilder sb = new StringBuilder();
                String query = this.getUpdateQueryMapper(lstUpdate, "shopprodinfo");
                sb.append(query);
                sb.append("\n WHERE PRODSEQ=?");
                YDMAStringUtil.Print(sb.toString());
                String sql = sb.toString();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int idx = 0;
                pstmt.setString(++idx, infoDto.getGoods_nm());
                pstmt.setString(++idx, infoDto.getGoods_keyword());
                pstmt.setString(++idx, infoDto.getModel_nm());
                pstmt.setString(++idx, infoDto.getBrand_nm());
                pstmt.setString(++idx, infoDto.getCompayny_goods_cd());
                pstmt.setString(++idx, infoDto.getGoods_search());
                pstmt.setString(++idx, infoDto.getShop_cid_info());
                pstmt.setString(++idx, infoDto.getClass_cd1());
                pstmt.setString(++idx, infoDto.getClass_cd2());
                pstmt.setString(++idx, infoDto.getClass_cd3());
                pstmt.setString(++idx, infoDto.getClass_cd4());
                pstmt.setString(++idx, infoDto.getMaker());
                pstmt.setString(++idx, infoDto.getOrigin());
                pstmt.setString(++idx, infoDto.getTax_yn());
                pstmt.setString(++idx, infoDto.getDelv_type());
                pstmt.setString(++idx, infoDto.getDelv_cost());
                pstmt.setString(++idx, infoDto.getGoods_cost());
                pstmt.setString(++idx, infoDto.getGoods_price());
                pstmt.setString(++idx, infoDto.getChar_1_nm());
                pstmt.setString(++idx, infoDto.getChar_1_val());
                pstmt.setString(++idx, infoDto.getChar_2_nm());
                pstmt.setString(++idx, infoDto.getChar_2_val());
                pstmt.setString(++idx, infoDto.getImg_path());
                pstmt.setString(++idx, infoDto.getImg_path1());
                pstmt.setString(++idx, infoDto.getImg_path2());
                pstmt.setString(++idx, infoDto.getImg_path3());
                pstmt.setString(++idx, infoDto.getImg_path4());
                pstmt.setString(++idx, infoDto.getImg_path5());
                pstmt.setString(++idx, infoDto.getImg_path6());
                pstmt.setString(++idx, infoDto.getImg_path7());
                pstmt.setString(++idx, infoDto.getImg_path8());
                pstmt.setString(++idx, infoDto.getImg_path9());
                pstmt.setString(++idx, infoDto.getGoods_remarks());
                pstmt.setString(++idx, infoDto.getCert_type());
                pstmt.setString(++idx, infoDto.getCert());
                pstmt.setString(++idx, infoDto.getCertno());
                pstmt.setString(++idx, infoDto.getAvled_dm());
                pstmt.setString(++idx, infoDto.getCertdate());
                pstmt.setString(++idx, infoDto.getCert_agency());
                pstmt.setString(++idx, infoDto.getCertmodel());
                pstmt.setString(++idx, infoDto.getCertname());
                pstmt.setString(++idx, infoDto.getExemptiontype());
                pstmt.setString(++idx, infoDto.getProp1_cd());
                pstmt.setString(++idx, infoDto.getProp_val1());
                pstmt.setString(++idx, infoDto.getProp_val2());
                pstmt.setString(++idx, infoDto.getProp_val3());
                pstmt.setString(++idx, infoDto.getProp_val4());
                pstmt.setString(++idx, infoDto.getProp_val5());
                pstmt.setString(++idx, infoDto.getProp_val6());
                pstmt.setString(++idx, infoDto.getProp_val7());
                pstmt.setString(++idx, infoDto.getProp_val8());
                pstmt.setString(++idx, infoDto.getProp_val9());
                pstmt.setString(++idx, infoDto.getProp_val10());
                pstmt.setString(++idx, infoDto.getProp_val11());
                pstmt.setString(++idx, infoDto.getProp_val12());
                pstmt.setString(++idx, infoDto.getProp_val13());
                pstmt.setString(++idx, infoDto.getProp_val14());
                pstmt.setString(++idx, infoDto.getProp_val15());
                pstmt.setString(++idx, infoDto.getProp_val16());
                pstmt.setString(++idx, infoDto.getProp_val17());
                pstmt.setString(++idx, infoDto.getProp_val18());
                pstmt.setString(++idx, infoDto.getProp_val19());
                pstmt.setString(++idx, infoDto.getProp_val20());
                pstmt.setString(++idx, infoDto.getProp_val21());
                pstmt.setString(++idx, infoDto.getProp_val22());
                pstmt.setString(++idx, infoDto.getProp_val23());
                pstmt.setString(++idx, infoDto.getProp_val24());
                pstmt.setString(++idx, infoDto.getProp_val25());
                pstmt.setString(++idx, infoDto.getProp_val26());
                pstmt.setString(++idx, infoDto.getProp_val27());
                pstmt.setString(++idx, infoDto.getProp_val28());
                pstmt.setString(++idx, infoDto.getGoods_remarks2());
                pstmt.setString(++idx, infoDto.getGoods_remarks3());
                pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++idx, infoDto.getSendstats());
                pstmt.setString(++idx, "[{\"item\":\"All\",\"before\":\"All\",\"after\":\"All\"}]");
                pstmt.setString(++idx, ":A");
                pstmt.setString(++idx, infoDto.getPRODSEQ());
                result = pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback();
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int ShopProdInInsert(ProductDTO inDto) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("PRODSEQ");
                lstInsert.add("COMPNO");
                lstInsert.add("SHOPCD");
                lstInsert.add("SHOP_USERID");
                lstInsert.add("SHOPSEQ");
                lstInsert.add("GOODS_NM");
                lstInsert.add("GOODS_KEYWORD");
                lstInsert.add("MODEL_NM");
                lstInsert.add("BRAND_NM");
                lstInsert.add("COMPAYNY_GOODS_CD");
                lstInsert.add("GOODS_SEARCH");
                lstInsert.add("GOODS_GUBUN");
                lstInsert.add("SHOP_CID_INFO");
                lstInsert.add("SELECT_OPTION");
                lstInsert.add("TEXT_OPTION");
                lstInsert.add("CLASS_CD1");
                lstInsert.add("CLASS_CD2");
                lstInsert.add("CLASS_CD3");
                lstInsert.add("CLASS_CD4");
                lstInsert.add("PARTNER_ID");
                lstInsert.add("DPARTNER_ID");
                lstInsert.add("MAKER");
                lstInsert.add("ORIGIN");
                lstInsert.add("MAKE_YEAR");
                lstInsert.add("MAKE_DM");
                lstInsert.add("GOODS_SEASON");
                lstInsert.add("SEX");
                lstInsert.add("STATUS");
                lstInsert.add("DELIV_ABLE_REGION");
                lstInsert.add("TAX_YN");
                lstInsert.add("DELV_TYPE");
                lstInsert.add("DELV_COST");
                lstInsert.add("BANPUM_AREA");
                lstInsert.add("GOODS_COST");
                lstInsert.add("GOODS_PRICE");
                lstInsert.add("GOODS_CONSUMER_PRICE");
                lstInsert.add("ISLIMIT");
                lstInsert.add("LIMIT_PRICE");
                lstInsert.add("IS_OVERSEAS");
                lstInsert.add("ADULT");
                lstInsert.add("ISRETURN");
                lstInsert.add("ITYPE");
                lstInsert.add("OPTIONYN");
                lstInsert.add("CHAR_1_NM");
                lstInsert.add("CHAR_1_VAL");
                lstInsert.add("CHAR_2_NM");
                lstInsert.add("CHAR_2_VAL");
                lstInsert.add("IMG_PATH");
                lstInsert.add("IMG_PATH1");
                lstInsert.add("IMG_PATH2");
                lstInsert.add("IMG_PATH3");
                lstInsert.add("IMG_PATH4");
                lstInsert.add("IMG_PATH5");
                lstInsert.add("IMG_PATH6");
                lstInsert.add("IMG_PATH7");
                lstInsert.add("IMG_PATH8");
                lstInsert.add("IMG_PATH9");
                lstInsert.add("IMG_PATH10");
                lstInsert.add("IMG_PATH11");
                lstInsert.add("IMG_PATH12");
                lstInsert.add("IMG_PATH13");
                lstInsert.add("IMG_PATH14");
                lstInsert.add("IMG_PATH15");
                lstInsert.add("IMG_PATH16");
                lstInsert.add("IMG_PATH17");
                lstInsert.add("IMG_PATH18");
                lstInsert.add("IMG_PATH19");
                lstInsert.add("IMG_PATH20");
                lstInsert.add("IMG_PATH21");
                lstInsert.add("IMG_PATH22");
                lstInsert.add("IMG_PATH23");
                lstInsert.add("IMG_PATH24");
                lstInsert.add("GOODS_REMARKS");
                lstInsert.add("CERT_TYPE");
                lstInsert.add("CERT");
                lstInsert.add("CERTNO");
                lstInsert.add("AVLST_DM");
                lstInsert.add("AVLED_DM");
                lstInsert.add("ISSUEDATE");
                lstInsert.add("CERTDATE");
                lstInsert.add("CERT_AGENCY");
                lstInsert.add("CERTMODEL");
                lstInsert.add("CERTNAME");
                lstInsert.add("EXEMPTIONTYPE");
                lstInsert.add("MATERIAL");
                lstInsert.add("STOCK_USE_YN");
                lstInsert.add("OPT_TYPE");
                lstInsert.add("PROP_EDIT_YN");
                lstInsert.add("PROP1_CD");
                lstInsert.add("PROP_VAL1");
                lstInsert.add("PROP_VAL2");
                lstInsert.add("PROP_VAL3");
                lstInsert.add("PROP_VAL4");
                lstInsert.add("PROP_VAL5");
                lstInsert.add("PROP_VAL6");
                lstInsert.add("PROP_VAL7");
                lstInsert.add("PROP_VAL8");
                lstInsert.add("PROP_VAL9");
                lstInsert.add("PROP_VAL10");
                lstInsert.add("PROP_VAL11");
                lstInsert.add("PROP_VAL12");
                lstInsert.add("PROP_VAL13");
                lstInsert.add("PROP_VAL14");
                lstInsert.add("PROP_VAL15");
                lstInsert.add("PROP_VAL16");
                lstInsert.add("PROP_VAL17");
                lstInsert.add("PROP_VAL18");
                lstInsert.add("PROP_VAL19");
                lstInsert.add("PROP_VAL20");
                lstInsert.add("PROP_VAL21");
                lstInsert.add("PROP_VAL22");
                lstInsert.add("PROP_VAL23");
                lstInsert.add("PROP_VAL24");
                lstInsert.add("PROP_VAL25");
                lstInsert.add("PROP_VAL26");
                lstInsert.add("PROP_VAL27");
                lstInsert.add("PROP_VAL28");
                lstInsert.add("PACK_CODE_STR");
                lstInsert.add("GOODS_NM_EN");
                lstInsert.add("GOODS_NM_PR");
                lstInsert.add("GOODS_REMARKS2");
                lstInsert.add("GOODS_REMARKS3");
                lstInsert.add("GOODS_REMARKS4");
                lstInsert.add("IMPORTNO");
                lstInsert.add("GOODS_COST2");
                lstInsert.add("ORIGIN2");
                lstInsert.add("EXPIRE_DM");
                lstInsert.add("SUPPLY_SAVE_YN");
                lstInsert.add("DESCRITION");
                lstInsert.add("SHOPPRODNO");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                lstInsert.add("MODIFYDT");
                lstInsert.add("MODIFYID");
                lstInsert.add("GMCATEGNM");
                lstInsert.add("SALEENDDT");
                lstInsert.add("SHOPMODIFYCONTENT");
                lstInsert.add("SELFMOD_NO");
                lstInsert.add("SHOPSENDSTATUS");
                StringBuilder sb = new StringBuilder();
                String query = this.getInsertQueryMapper(lstInsert, "shopprodin");
                sb.append(query);
                YDMAStringUtil.Print(sb.toString());
                String sql = sb.toString();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int idx = 0;
                pstmt.setString(++idx, inDto.getPRODSEQ());
                pstmt.setString(++idx, inDto.getCompno());
                pstmt.setString(++idx, inDto.getShopcd());
                pstmt.setString(++idx, inDto.getSHOP_USERID());
                pstmt.setString(++idx, inDto.getShopseq());
                pstmt.setString(++idx, inDto.getGoods_nm());
                pstmt.setString(++idx, inDto.getGoods_keyword());
                pstmt.setString(++idx, inDto.getModel_nm());
                pstmt.setString(++idx, inDto.getBrand_nm());
                pstmt.setString(++idx, inDto.getCompayny_goods_cd());
                pstmt.setString(++idx, inDto.getGoods_search());
                pstmt.setString(++idx, inDto.getGoods_gubun());
                pstmt.setString(++idx, inDto.getShop_cid_info());
                pstmt.setString(++idx, inDto.getSelect_option());
                pstmt.setString(++idx, inDto.getText_option());
                pstmt.setString(++idx, inDto.getClass_cd1());
                pstmt.setString(++idx, inDto.getClass_cd2());
                pstmt.setString(++idx, inDto.getClass_cd3());
                pstmt.setString(++idx, inDto.getClass_cd4());
                pstmt.setString(++idx, inDto.getPartner_id());
                pstmt.setString(++idx, inDto.getDpartner_id());
                pstmt.setString(++idx, inDto.getMaker());
                pstmt.setString(++idx, inDto.getOrigin());
                pstmt.setString(++idx, inDto.getMake_year());
                pstmt.setString(++idx, inDto.getMake_dm());
                pstmt.setString(++idx, inDto.getGoods_season());
                pstmt.setString(++idx, inDto.getSex());
                pstmt.setString(++idx, inDto.getStatus());
                pstmt.setString(++idx, inDto.getDeliv_able_region());
                pstmt.setString(++idx, inDto.getTax_yn());
                pstmt.setString(++idx, inDto.getDelv_type());
                pstmt.setString(++idx, inDto.getDelv_cost());
                pstmt.setString(++idx, inDto.getBanpum_area());
                pstmt.setString(++idx, inDto.getGoods_cost());
                pstmt.setString(++idx, inDto.getGoods_price());
                pstmt.setString(++idx, inDto.getGoods_consumer_price());
                pstmt.setString(++idx, inDto.getIslimit().equals("") ? "0" : inDto.getIslimit());
                pstmt.setString(++idx, inDto.getLimit_price().equals("") ? "0" : inDto.getLimit_price());
                pstmt.setString(++idx, inDto.getIs_overseas().equals("") ? "0" : inDto.getIs_overseas());
                pstmt.setString(++idx, inDto.getAdult().equals("") ? "0" : inDto.getAdult());
                pstmt.setString(++idx, inDto.getIsreturn().equals("") ? "0" : inDto.getIsreturn());
                pstmt.setString(++idx, inDto.getItype().equals("") ? "0" : inDto.getItype());
                pstmt.setString(++idx, inDto.getOptionYN());
                pstmt.setString(++idx, inDto.getChar_1_nm());
                pstmt.setString(++idx, inDto.getChar_1_val());
                pstmt.setString(++idx, inDto.getChar_2_nm());
                pstmt.setString(++idx, inDto.getChar_2_val());
                pstmt.setString(++idx, inDto.getImg_path());
                pstmt.setString(++idx, inDto.getImg_path1());
                pstmt.setString(++idx, inDto.getImg_path2());
                pstmt.setString(++idx, inDto.getImg_path3());
                pstmt.setString(++idx, inDto.getImg_path4());
                pstmt.setString(++idx, inDto.getImg_path5());
                pstmt.setString(++idx, inDto.getImg_path6());
                pstmt.setString(++idx, inDto.getImg_path7());
                pstmt.setString(++idx, inDto.getImg_path8());
                pstmt.setString(++idx, inDto.getImg_path9());
                pstmt.setString(++idx, inDto.getImg_path10());
                pstmt.setString(++idx, inDto.getImg_path11());
                pstmt.setString(++idx, inDto.getImg_path12());
                pstmt.setString(++idx, inDto.getImg_path13());
                pstmt.setString(++idx, inDto.getImg_path14());
                pstmt.setString(++idx, inDto.getImg_path15());
                pstmt.setString(++idx, inDto.getImg_path16());
                pstmt.setString(++idx, inDto.getImg_path17());
                pstmt.setString(++idx, inDto.getImg_path18());
                pstmt.setString(++idx, inDto.getImg_path19());
                pstmt.setString(++idx, inDto.getImg_path20());
                pstmt.setString(++idx, inDto.getImg_path21());
                pstmt.setString(++idx, inDto.getImg_path22());
                pstmt.setString(++idx, inDto.getImg_path23());
                pstmt.setString(++idx, inDto.getImg_path24());
                pstmt.setString(++idx, inDto.getGoods_remarks());
                pstmt.setString(++idx, inDto.getCert_type().equals("") ? "0" : inDto.getCert_type());
                pstmt.setString(++idx, inDto.getCert());
                pstmt.setString(++idx, inDto.getCertno());
                pstmt.setString(++idx, inDto.getAvlst_dm());
                pstmt.setString(++idx, inDto.getAvled_dm());
                pstmt.setString(++idx, inDto.getIssuedate());
                pstmt.setString(++idx, inDto.getCertdate());
                pstmt.setString(++idx, inDto.getCert_agency());
                pstmt.setString(++idx, inDto.getCertmodel());
                pstmt.setString(++idx, inDto.getCertname());
                pstmt.setString(++idx, inDto.getExemptiontype());
                pstmt.setString(++idx, inDto.getMaterial());
                pstmt.setString(++idx, inDto.getStock_use_yn());
                pstmt.setString(++idx, inDto.getOpt_type());
                pstmt.setString(++idx, inDto.getProp_edit_yn());
                pstmt.setString(++idx, inDto.getProp1_cd());
                pstmt.setString(++idx, inDto.getProp_val1());
                pstmt.setString(++idx, inDto.getProp_val2());
                pstmt.setString(++idx, inDto.getProp_val3());
                pstmt.setString(++idx, inDto.getProp_val4());
                pstmt.setString(++idx, inDto.getProp_val5());
                pstmt.setString(++idx, inDto.getProp_val6());
                pstmt.setString(++idx, inDto.getProp_val7());
                pstmt.setString(++idx, inDto.getProp_val8());
                pstmt.setString(++idx, inDto.getProp_val9());
                pstmt.setString(++idx, inDto.getProp_val10());
                pstmt.setString(++idx, inDto.getProp_val11());
                pstmt.setString(++idx, inDto.getProp_val12());
                pstmt.setString(++idx, inDto.getProp_val13());
                pstmt.setString(++idx, inDto.getProp_val14());
                pstmt.setString(++idx, inDto.getProp_val15());
                pstmt.setString(++idx, inDto.getProp_val16());
                pstmt.setString(++idx, inDto.getProp_val17());
                pstmt.setString(++idx, inDto.getProp_val18());
                pstmt.setString(++idx, inDto.getProp_val19());
                pstmt.setString(++idx, inDto.getProp_val20());
                pstmt.setString(++idx, inDto.getProp_val21());
                pstmt.setString(++idx, inDto.getProp_val22());
                pstmt.setString(++idx, inDto.getProp_val23());
                pstmt.setString(++idx, inDto.getProp_val24());
                pstmt.setString(++idx, inDto.getProp_val25());
                pstmt.setString(++idx, inDto.getProp_val26());
                pstmt.setString(++idx, inDto.getProp_val27());
                pstmt.setString(++idx, inDto.getProp_val28());
                pstmt.setString(++idx, inDto.getPack_code_str());
                pstmt.setString(++idx, inDto.getGoods_nm_en());
                pstmt.setString(++idx, inDto.getGoods_nm_pr());
                pstmt.setString(++idx, inDto.getGoods_remarks2());
                pstmt.setString(++idx, inDto.getGoods_remarks3());
                pstmt.setString(++idx, inDto.getGoods_remarks4());
                pstmt.setString(++idx, inDto.getImportno());
                pstmt.setString(++idx, inDto.getGoods_cost2());
                pstmt.setString(++idx, inDto.getOrigin2());
                pstmt.setString(++idx, inDto.getExpire_dm());
                pstmt.setString(++idx, inDto.getSupply_save_yn());
                pstmt.setString(++idx, inDto.getDescrition());
                pstmt.setString(++idx, inDto.getShopprodno());
                pstmt.setString(++idx, inDto.getInsertdt());
                pstmt.setString(++idx, inDto.getInsertid());
                pstmt.setString(++idx, inDto.getModifydt());
                pstmt.setString(++idx, inDto.getModifyid());
                pstmt.setString(++idx, inDto.getGmcategnm());
                pstmt.setString(++idx, inDto.getSaleenddt());
                pstmt.setString(++idx, "[{\"item\":\"All\",\"before\":\"All\",\"after\":\"All\"}]");
                pstmt.setString(++idx, ":A");
                pstmt.setInt(++idx, Integer.parseInt(inDto.getSendstats()));
                result = pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback();
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int ShopProdInUpdate(ProductDTO inDto) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("GOODS_NM");
                lstUpdate.add("GOODS_KEYWORD");
                lstUpdate.add("MODEL_NM");
                lstUpdate.add("BRAND_NM");
                lstUpdate.add("COMPAYNY_GOODS_CD");
                lstUpdate.add("GOODS_SEARCH");
                lstUpdate.add("SHOP_CID_INFO");
                lstUpdate.add("MAKER");
                lstUpdate.add("ORIGIN");
                lstUpdate.add("STATUS");
                lstUpdate.add("TAX_YN");
                lstUpdate.add("DELV_TYPE");
                lstUpdate.add("DELV_COST");
                lstUpdate.add("GOODS_COST");
                lstUpdate.add("GOODS_PRICE");
                lstUpdate.add("CHAR_1_NM");
                lstUpdate.add("CHAR_1_VAL");
                lstUpdate.add("CHAR_2_NM");
                lstUpdate.add("CHAR_2_VAL");
                lstUpdate.add("IMG_PATH");
                lstUpdate.add("IMG_PATH1");
                lstUpdate.add("IMG_PATH2");
                lstUpdate.add("IMG_PATH3");
                lstUpdate.add("IMG_PATH4");
                lstUpdate.add("IMG_PATH5");
                lstUpdate.add("IMG_PATH6");
                lstUpdate.add("IMG_PATH7");
                lstUpdate.add("IMG_PATH8");
                lstUpdate.add("IMG_PATH9");
                lstUpdate.add("GOODS_REMARKS");
                lstUpdate.add("CERT_TYPE");
                lstUpdate.add("CERT");
                lstUpdate.add("CERTNO");
                lstUpdate.add("AVLED_DM");
                lstUpdate.add("CERTDATE");
                lstUpdate.add("CERT_AGENCY");
                lstUpdate.add("CERTMODEL");
                lstUpdate.add("CERTNAME");
                lstUpdate.add("EXEMPTIONTYPE");
                lstUpdate.add("PROP1_CD");
                lstUpdate.add("PROP_VAL1");
                lstUpdate.add("PROP_VAL2");
                lstUpdate.add("PROP_VAL3");
                lstUpdate.add("PROP_VAL4");
                lstUpdate.add("PROP_VAL5");
                lstUpdate.add("PROP_VAL6");
                lstUpdate.add("PROP_VAL7");
                lstUpdate.add("PROP_VAL8");
                lstUpdate.add("PROP_VAL9");
                lstUpdate.add("PROP_VAL10");
                lstUpdate.add("PROP_VAL11");
                lstUpdate.add("PROP_VAL12");
                lstUpdate.add("PROP_VAL13");
                lstUpdate.add("PROP_VAL14");
                lstUpdate.add("PROP_VAL15");
                lstUpdate.add("PROP_VAL16");
                lstUpdate.add("PROP_VAL17");
                lstUpdate.add("PROP_VAL18");
                lstUpdate.add("PROP_VAL19");
                lstUpdate.add("PROP_VAL20");
                lstUpdate.add("PROP_VAL21");
                lstUpdate.add("PROP_VAL22");
                lstUpdate.add("PROP_VAL23");
                lstUpdate.add("PROP_VAL24");
                lstUpdate.add("PROP_VAL25");
                lstUpdate.add("PROP_VAL26");
                lstUpdate.add("PROP_VAL27");
                lstUpdate.add("PROP_VAL28");
                lstUpdate.add("GOODS_REMARKS2");
                lstUpdate.add("GOODS_REMARKS3");
                lstUpdate.add("MODIFYDT");
                lstUpdate.add("MODIFYID");
                lstUpdate.add("SHOPSENDSTATUS");
                lstUpdate.add("GMCATEGNM");
                lstUpdate.add("ShopModifyContent");
                lstUpdate.add("SELFMOD_NO");
                StringBuilder sb = new StringBuilder();
                String query = this.getUpdateQueryMapper(lstUpdate, "shopprodin");
                sb.append(query);
                sb.append("\n WHERE SENDSEQ=?");
                YDMAStringUtil.Print(sb.toString());
                String sql = sb.toString();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int idx = 0;
                pstmt.setString(++idx, inDto.getGoods_nm());
                pstmt.setString(++idx, inDto.getGoods_keyword());
                pstmt.setString(++idx, inDto.getModel_nm());
                pstmt.setString(++idx, inDto.getBrand_nm());
                pstmt.setString(++idx, inDto.getCompayny_goods_cd());
                pstmt.setString(++idx, inDto.getGoods_search());
                pstmt.setString(++idx, inDto.getShop_cid_info());
                pstmt.setString(++idx, inDto.getMaker());
                pstmt.setString(++idx, inDto.getOrigin());
                pstmt.setString(++idx, inDto.getStatus());
                pstmt.setString(++idx, inDto.getTax_yn());
                pstmt.setString(++idx, inDto.getDelv_type());
                pstmt.setString(++idx, inDto.getDelv_cost());
                pstmt.setString(++idx, inDto.getGoods_cost());
                pstmt.setString(++idx, inDto.getGoods_price());
                pstmt.setString(++idx, inDto.getChar_1_nm());
                pstmt.setString(++idx, inDto.getChar_1_val());
                pstmt.setString(++idx, inDto.getChar_2_nm());
                pstmt.setString(++idx, inDto.getChar_2_val());
                pstmt.setString(++idx, inDto.getImg_path());
                pstmt.setString(++idx, inDto.getImg_path1());
                pstmt.setString(++idx, inDto.getImg_path2());
                pstmt.setString(++idx, inDto.getImg_path3());
                pstmt.setString(++idx, inDto.getImg_path4());
                pstmt.setString(++idx, inDto.getImg_path5());
                pstmt.setString(++idx, inDto.getImg_path6());
                pstmt.setString(++idx, inDto.getImg_path7());
                pstmt.setString(++idx, inDto.getImg_path8());
                pstmt.setString(++idx, inDto.getImg_path9());
                pstmt.setString(++idx, inDto.getGoods_remarks());
                pstmt.setString(++idx, inDto.getCert_type());
                pstmt.setString(++idx, inDto.getCert());
                pstmt.setString(++idx, inDto.getCertno());
                pstmt.setString(++idx, inDto.getAvled_dm());
                pstmt.setString(++idx, inDto.getCertdate());
                pstmt.setString(++idx, inDto.getCert_agency());
                pstmt.setString(++idx, inDto.getCertmodel());
                pstmt.setString(++idx, inDto.getCertname());
                pstmt.setString(++idx, inDto.getExemptiontype());
                pstmt.setString(++idx, inDto.getProp1_cd());
                pstmt.setString(++idx, inDto.getProp_val1());
                pstmt.setString(++idx, inDto.getProp_val2());
                pstmt.setString(++idx, inDto.getProp_val3());
                pstmt.setString(++idx, inDto.getProp_val4());
                pstmt.setString(++idx, inDto.getProp_val5());
                pstmt.setString(++idx, inDto.getProp_val6());
                pstmt.setString(++idx, inDto.getProp_val7());
                pstmt.setString(++idx, inDto.getProp_val8());
                pstmt.setString(++idx, inDto.getProp_val9());
                pstmt.setString(++idx, inDto.getProp_val10());
                pstmt.setString(++idx, inDto.getProp_val11());
                pstmt.setString(++idx, inDto.getProp_val12());
                pstmt.setString(++idx, inDto.getProp_val13());
                pstmt.setString(++idx, inDto.getProp_val14());
                pstmt.setString(++idx, inDto.getProp_val15());
                pstmt.setString(++idx, inDto.getProp_val16());
                pstmt.setString(++idx, inDto.getProp_val17());
                pstmt.setString(++idx, inDto.getProp_val18());
                pstmt.setString(++idx, inDto.getProp_val19());
                pstmt.setString(++idx, inDto.getProp_val20());
                pstmt.setString(++idx, inDto.getProp_val21());
                pstmt.setString(++idx, inDto.getProp_val22());
                pstmt.setString(++idx, inDto.getProp_val23());
                pstmt.setString(++idx, inDto.getProp_val24());
                pstmt.setString(++idx, inDto.getProp_val25());
                pstmt.setString(++idx, inDto.getProp_val26());
                pstmt.setString(++idx, inDto.getProp_val27());
                pstmt.setString(++idx, inDto.getProp_val28());
                pstmt.setString(++idx, inDto.getGoods_remarks2());
                pstmt.setString(++idx, inDto.getGoods_remarks3());
                pstmt.setString(++idx, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setInt(++idx, Integer.parseInt(inDto.getSendstats()));
                pstmt.setString(++idx, inDto.getGmcategnm());
                pstmt.setString(++idx, "[{\"item\":\"All\",\"before\":\"All\",\"after\":\"All\"}]");
                pstmt.setString(++idx, ":A");
                pstmt.setString(++idx, inDto.getSENDSEQ());
                result = pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback();
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public String addinforname(ProductDTO dto) throws Exception {
        String addinfoname;
        block6: {
            Connection connection = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            PreparedStatement pstmt = null;
            addinfoname = "";
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "SELECT TITLE FROM shopaddrmst where COMPNO = ? AND SEQ = ? and shopcd =?";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, dto.getCompno());
                    pstmt.setString(2, dto.getSeq());
                    pstmt.setString(3, dto.getShopcd());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        addinfoname = rs.getString(1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return addinfoname;
    }

    public ShopOrderMstDto ShopDtl(String shopcd, String shopseq) throws Exception {
        ShopOrderMstDto dto = new ShopOrderMstDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(shopseq,'0'),ifnull(SHOPCD,''),ifnull(SHOPPINGID,''),ifnull(PASSWORD,''),ifnull(NICKNM1,''),ifnull(AUTHKEY1,''),ifnull(AUTHKEY2,'') ,ifnull(APIKEY,'') from shopdtl where SHOPCD = ? and shopseq = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, shopseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[ShoppingMallDetailList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setShop_userid(rs.getString(++columnIndex));
                    dto.setShopPw(rs.getString(++columnIndex));
                    dto.setVendorId(rs.getString(++columnIndex));
                    dto.setAuthkey1(rs.getString(++columnIndex));
                    dto.setAuthKey2(rs.getString(++columnIndex));
                    dto.setApikey(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public boolean duplicatecheck(String cd, String compno) throws Exception {
        block6: {
            ArrayList<PreparedStatement> statementlist;
            ResultSet rs;
            Connection connection;
            block5: {
                int result = 0;
                connection = null;
                PreparedStatement pstmt = null;
                rs = null;
                statementlist = new ArrayList<PreparedStatement>();
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "SELECT COUNT(*) COMPAYNY_GOODS_CD FROM SHOPPRODINFO WHERE COMPAYNY_GOODS_CD = ? AND COMPNO = ?";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, cd);
                    pstmt.setString(2, compno);
                    rs = pstmt.executeQuery();
                    if (!rs.next() || (result = rs.getInt("COMPAYNY_GOODS_CD")) <= 0) break block5;
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block6;
                }
                finally {
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                    connection.close();
                }
                connection.close();
                return true;
            }
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            connection.close();
        }
        return false;
    }

    public boolean duplicatecheck1(String cd, String compno) throws Exception {
        block6: {
            ArrayList<PreparedStatement> statementlist;
            ResultSet rs;
            Connection connection;
            block5: {
                int result = 0;
                connection = null;
                PreparedStatement pstmt = null;
                rs = null;
                statementlist = new ArrayList<PreparedStatement>();
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "SELECT COUNT(*) PRODCD FROM shop_optprodinfo WHERE PRODCD = ? AND COMPNO = ?";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, cd);
                    pstmt.setString(2, compno);
                    rs = pstmt.executeQuery();
                    if (!rs.next() || (result = rs.getInt("PRODCD")) <= 0) break block5;
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block6;
                }
                finally {
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                    connection.close();
                }
                connection.close();
                return true;
            }
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            connection.close();
        }
        return false;
    }

    public ShopProductAdditionDto getInterparkAdditionalOneList(int key) throws Exception {
        ShopInterParkAdditionalDto dto = new ShopInterParkAdditionalDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SEQ,''),ifnull( COMPNO,''),ifnull( TITLE,''),ifnull( SHOPCD,''),ifnull( SHOPUSERID,''),ifnull( SELMTHDCD,''),ifnull( PRESALEDATE1,''), ifnull( PRESALEDATE2,''),ifnull( PRODSTATUS,''),ifnull( USEDMONTHS,''),ifnull( OVERSEASDELVYN,''),ifnull( SETINFOYN,''),ifnull( SETINFOSEX,''),ifnull( SETINFOAGE,''), ifnull( SETSOMESRTAGE,''),ifnull( SETSOMEENDAGE,''),ifnull( SETSOMEMONAGE,''),ifnull( SETSPECSRTAGE,''),ifnull( SETSPECMONAGE,''),ifnull( SETSPECMORLESS,''),ifnull( RENTALYN,''), ifnull( RENTALCOST,''),ifnull( RENTALPERIOD,''),ifnull( INSTYN,''),ifnull( INSTCOST,''),ifnull( REGYN,''),ifnull( REGCOST,''),ifnull( RECOMMYN,''),ifnull( RECOMMCOST,''), ifnull( SALEPERIODYN,''),ifnull( SALEPERIODSRT,''),ifnull( SALEPERIODEND,''),ifnull( SALEPERIODSET,''),ifnull( MINORSELCNYN,''),ifnull( TAXSMALL,''),ifnull( BRANDYN,''), ifnull( MIDCATEGYN,''),ifnull( SELLIMITTYPCD,''),ifnull( SELLIMITTYPCNT,''),ifnull( BOOKLIST,''),ifnull( IMPORTDECYN,''),ifnull( IMPORTNO,''),ifnull( FORABRDBUYCLF,''), ifnull( ASDETAIL,''),ifnull( PROHIBITEDLAN,''),ifnull( UNIQUENESS,''),ifnull( SELLBURDENYN,''),ifnull( SELLBURDENFIXRATEYN,''),ifnull( SELLBURDENFIXRATECOST,''), ifnull( SELLBURDENPERIODYN,''),ifnull( SELLBURDENPERIODSRT,''),ifnull( SELLBURDENPERIODEND,''),ifnull( SELLERDC,''),ifnull( DCRATE,''),ifnull( CUMDC,''),ifnull( MARGINDC,''), ifnull( COMMDC,''),ifnull( MODIFYOPTYN,''),ifnull( ADDOPTYN,''),ifnull( OPTEXCLUDED50,''),ifnull( OPTEXCLUDED20,''),ifnull( OPTSORTYN,''),ifnull( ADDORDOPTYN,''), ifnull( SOLDOPTYN,''),ifnull( COSTCOMPARISONYN,''),ifnull( INTERYN,''),ifnull( INTERPERIODSRT,''),ifnull( INTERPERIODEND,''),ifnull( INTERPERIODYN,''),ifnull( IPOINTCOST,''), ifnull( IPOINTTYPE,''),ifnull( IPOINTMALLYN,''),ifnull( PRODNOTICEERRYN,''),ifnull( DELVMETHOD,''),ifnull( DELVTYPE,''),ifnull( DELVBUNDLECD,''),ifnull( DELVCOSTTYPE,''), ifnull( DELVCOST,''),ifnull( DELVFREEYN,''),ifnull( DELVCNTYN,''),ifnull( DELVCOST1,''),ifnull( DELVPREPAYYN,''),ifnull( DELVQUICK,''),ifnull( DELVADDCOSTYN,''), ifnull( DELVJEJUCOST,''),ifnull( DELVISLANDCOST,''),ifnull( RETURNCD,''),ifnull( RETURNADDR,''),ifnull( DELVRETEXCYN,''),ifnull( DELVRETEXCCOST,''),ifnull( DELVUNIQUENESS,''), ifnull( NOTICETITLEYN,''),ifnull( NOTICEBATCHYN,''),ifnull( NOTICECD,''),ifnull( NOTICEIMG,''),ifnull( PRODOUTPUT,''),ifnull( PRODNMFIRST,''),ifnull( PRODNMLAST,''), ifnull( REMARKFIRST,''),ifnull( REMARKLAST,''),ifnull( REMARKOUTPUT,''),ifnull( PREMIUMYN,''),ifnull( PREMIUMYN2,''),ifnull( PREMIUMPERIODUSE,''),ifnull( PREMIUMPERIODSRT,''), ifnull( PREMIUMTHEMAYN,''),ifnull( PREMIUMTHEMAPERIODUSE,''),ifnull( PREMIUMTHEMAPERIODSRT,''),ifnull( EXHIBITIONYN,''),ifnull( EXHIBITIONPRODBOLDYN,''), ifnull( EXHIBITIONPRODBOLDPERIODUSE,''),ifnull( EXHIBITIONPRODBOLDPERIODSRT,''),ifnull( EXHIBITIONPRODCOLYN,''),ifnull( EXHIBITIONPRODCOLPERIODUSE,''), ifnull( EXHIBITIONPRODCOLPERIODSRT,''),ifnull( PACKAGEYN,''),ifnull( PACKAGETYPE,''),ifnull( PACKAGEPERIOD,''), ifnull(FREEDELIVERY,''), ifnull(EXPPRC,'2500'), ifnull( CHANGESIZE,''), ifnull( CHANGESIZEX,''), ifnull( CHANGESIZEY,''), ifnull( CHANGESIZEW,''), ifnull( CHANGESIZEH,''), ifnull( DETAILKEYWORDB,''), ifnull( DETAILKEYWORDL,''), ifnull( DETAILKEYWORDR,''), ifnull( DETAILPRODUCTCODEB,''), ifnull( DETAILPRODUCTCODEL,''), ifnull( DETAILPRODUCTCODER,''), ifnull( DETAILPRODUCTNAMEB,''), ifnull( DETAILPRODUCTNAMEL,''), ifnull( DETAILPRODUCTNAMER,''), ifnull( ADDOPTIONLB,''), ifnull( ADDOPTIONL,''), ifnull( ADDOPTIONRB,''), ifnull( ADDOPTIONR,''), ifnull( IMGONEONONE,''), ifnull( IMGTHREEONFOUR,''), \r\n IFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''), IFNULL(IMG_ANGLE,''), IFNULL(IMG_SCALE_PERCENT,'')  \r\n\tFROM shopinterparkaddidtl where  seq=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, key);
                YDMAStringUtil.Print("[getInterparkAdditionalOneList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setSelmthdcd(rs.getString(++columnIndex));
                    dto.setPresaledate1(rs.getString(++columnIndex));
                    dto.setPresaledate2(rs.getString(++columnIndex));
                    dto.setProdstatus(rs.getString(++columnIndex));
                    dto.setUsedmonths(rs.getString(++columnIndex));
                    dto.setOverseasdelvyn(rs.getString(++columnIndex));
                    dto.setSetinfoyn(rs.getString(++columnIndex));
                    dto.setSetinfosex(rs.getString(++columnIndex));
                    dto.setSetinfoage(rs.getString(++columnIndex));
                    dto.setSetsomesrtage(rs.getString(++columnIndex));
                    dto.setSetsomeendage(rs.getString(++columnIndex));
                    dto.setSetsomemonage(rs.getString(++columnIndex));
                    dto.setSetspecsrtage(rs.getString(++columnIndex));
                    dto.setSetspecmonage(rs.getString(++columnIndex));
                    dto.setSetspecmorless(rs.getString(++columnIndex));
                    dto.setRentalyn(rs.getString(++columnIndex));
                    dto.setRentalcost(rs.getString(++columnIndex));
                    dto.setRentalperiod(rs.getString(++columnIndex));
                    dto.setInstyn(rs.getString(++columnIndex));
                    dto.setInstcost(rs.getString(++columnIndex));
                    dto.setRegyn(rs.getString(++columnIndex));
                    dto.setRegcost(rs.getString(++columnIndex));
                    dto.setRecommyn(rs.getString(++columnIndex));
                    dto.setRecommcost(rs.getString(++columnIndex));
                    dto.setSaleperiodyn(rs.getString(++columnIndex));
                    dto.setSaleperiodsrt(rs.getString(++columnIndex));
                    dto.setSaleperiodend(rs.getString(++columnIndex));
                    dto.setSaleperiodset(rs.getString(++columnIndex));
                    dto.setMinorselcnyn(rs.getString(++columnIndex));
                    dto.setTaxsmall(rs.getString(++columnIndex));
                    dto.setBrandyn(rs.getString(++columnIndex));
                    dto.setMidcategyn(rs.getString(++columnIndex));
                    dto.setSellimittypcd(rs.getString(++columnIndex));
                    dto.setSellimittypcnt(rs.getString(++columnIndex));
                    dto.setBooklist(rs.getString(++columnIndex));
                    dto.setImportdecyn(rs.getString(++columnIndex));
                    dto.setImportno(rs.getString(++columnIndex));
                    dto.setForabrdbuyclf(rs.getString(++columnIndex));
                    dto.setAsdetail(rs.getString(++columnIndex));
                    dto.setProhibitedlan(rs.getString(++columnIndex));
                    dto.setUniqueness(rs.getString(++columnIndex));
                    dto.setSellburdenyn(rs.getString(++columnIndex));
                    dto.setSellburdenfixrateyn(rs.getString(++columnIndex));
                    dto.setSellburdenfixratecost(rs.getString(++columnIndex));
                    dto.setSellburdenperiodyn(rs.getString(++columnIndex));
                    dto.setSellburdenperiodsrt(rs.getString(++columnIndex));
                    dto.setSellburdenperiodend(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setModifyoptyn(rs.getString(++columnIndex));
                    dto.setAddoptyn(rs.getString(++columnIndex));
                    dto.setOptexcluded50(rs.getString(++columnIndex));
                    dto.setOptexcluded20(rs.getString(++columnIndex));
                    dto.setOptsortyn(rs.getString(++columnIndex));
                    dto.setAddordoptyn(rs.getString(++columnIndex));
                    dto.setSoldoptyn(rs.getString(++columnIndex));
                    dto.setCostcomparisonyn(rs.getString(++columnIndex));
                    dto.setInteryn(rs.getString(++columnIndex));
                    dto.setInterperiodsrt(rs.getString(++columnIndex));
                    dto.setInterperiodend(rs.getString(++columnIndex));
                    dto.setInterperiodyn(rs.getString(++columnIndex));
                    dto.setIpointcost(rs.getString(++columnIndex));
                    dto.setIpointtype(rs.getString(++columnIndex));
                    dto.setIpointmallyn(rs.getString(++columnIndex));
                    dto.setProdnoticeerryn(rs.getString(++columnIndex));
                    dto.setDelvmethod(rs.getString(++columnIndex));
                    dto.setDelvtype(rs.getString(++columnIndex));
                    dto.setDelvbundlecd(rs.getString(++columnIndex));
                    dto.setDelvcosttype(rs.getString(++columnIndex));
                    dto.setDelvcost(rs.getString(++columnIndex));
                    dto.setDelvfreeyn(rs.getString(++columnIndex));
                    dto.setDelvcntyn(rs.getString(++columnIndex));
                    dto.setDelvcost1(rs.getString(++columnIndex));
                    dto.setDelvprepayyn(rs.getString(++columnIndex));
                    dto.setDelvquick(rs.getString(++columnIndex));
                    dto.setDelvaddcostyn(rs.getString(++columnIndex));
                    dto.setDelvjejucost(rs.getString(++columnIndex));
                    dto.setDelvislandcost(rs.getString(++columnIndex));
                    dto.setReturncd(rs.getString(++columnIndex));
                    dto.setReturnaddr(rs.getString(++columnIndex));
                    dto.setDelvretexcyn(rs.getString(++columnIndex));
                    dto.setDelvretexccost(rs.getString(++columnIndex));
                    dto.setDelvuniqueness(rs.getString(++columnIndex));
                    dto.setNoticetitleyn(rs.getString(++columnIndex));
                    dto.setNoticebatchyn(rs.getString(++columnIndex));
                    dto.setNoticecd(rs.getString(++columnIndex));
                    dto.setNoticeimg(rs.getString(++columnIndex));
                    dto.setProdoutput(rs.getString(++columnIndex));
                    dto.setProdnmfirst(rs.getString(++columnIndex));
                    dto.setProdnmlast(rs.getString(++columnIndex));
                    dto.setRemarkfirst(rs.getString(++columnIndex));
                    dto.setRemarklast(rs.getString(++columnIndex));
                    dto.setRemarkoutput(rs.getString(++columnIndex));
                    dto.setPremiumyn(rs.getString(++columnIndex));
                    dto.setPremiumyn2(rs.getString(++columnIndex));
                    dto.setPremiumperioduse(rs.getString(++columnIndex));
                    dto.setPremiumperiodsrt(rs.getString(++columnIndex));
                    dto.setPremiumthemayn(rs.getString(++columnIndex));
                    dto.setPremiumthemaperioduse(rs.getString(++columnIndex));
                    dto.setPremiumthemaperiodsrt(rs.getString(++columnIndex));
                    dto.setExhibitionyn(rs.getString(++columnIndex));
                    dto.setExhibitionprodboldyn(rs.getString(++columnIndex));
                    dto.setExhibitionprodboldperioduse(rs.getString(++columnIndex));
                    dto.setExhibitionprodboldperiodsrt(rs.getString(++columnIndex));
                    dto.setExhibitionprodcolyn(rs.getString(++columnIndex));
                    dto.setExhibitionprodcolperioduse(rs.getString(++columnIndex));
                    dto.setExhibitionprodcolperiodsrt(rs.getString(++columnIndex));
                    dto.setPackageyn(rs.getString(++columnIndex));
                    dto.setPackagetype(rs.getString(++columnIndex));
                    dto.setPackageperiod(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setAngle(rs.getString(++columnIndex));
                    dto.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ShopCatInfDto> getShopCatInf(String[] categ) throws Exception {
        ArrayList<ShopCatInfDto> list = new ArrayList<ShopCatInfDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select DISTINCT SHOPCATNO, SHOPCATSITENM from shopcatinf where compno = ? AND SHOPCATSITENM REGEXP('";
                int i = 0;
                while (i < categ.length) {
                    if (i != 0) {
                        sql = String.valueOf(sql) + "|";
                    }
                    sql = String.valueOf(sql) + categ[i];
                    ++i;
                }
                sql = String.valueOf(sql) + "')";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopCatInf]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    ShopCatInfDto dto = new ShopCatInfDto();
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public ShopCatInfDto getDetailcateg(String lastcate) throws Exception {
        ShopCatInfDto dto = new ShopCatInfDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select smlcode from categdetail where compno = ? and code = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, lastcate);
                YDMAStringUtil.Print("[getShopCatInf]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setShopsmlcatcd(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopCatInfDto getSmallcateg(String smlcate) throws Exception {
        ShopCatInfDto dto = new ShopCatInfDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select midcode from categsmall where compno = ? and code = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, smlcate);
                YDMAStringUtil.Print("[getShopCatInf]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setShopmidcatcd(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public Map<String, String> getShopProductTabCount(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo, String shopCd, String shopSeq) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        HashMap<String, String> list = new HashMap<String, String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String proddup2;
                PreferencesMallDTO dto1;
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT DISTINCT (case when A.SHOPSENDSTATUS = -1 then 9000 \r\n");
                sql.append("\t\t\t\t\t  when A.SHOPSENDSTATUS = 0 then 9000 \r\n");
                sql.append("\t\t\t\t\t  else A.SHOPSENDSTATUS END) AS TYPE, \r\n");
                sql.append("\t   COUNT(*) AS CNT \r\n");
                sql.append("  FROM SHOPPRODINFO AS A USE INDEX(SHOPSENDSTATUS) \r\n");
                sql.append(" WHERE COMPNO = ? \r\n");
                if (!dome.equals("")) {
                    sql.append("   AND GOODS_KEYWORD = ? \r\n");
                }
                if (folder.equals("")) {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%"));
                } else {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder));
                }
                if (!categ.equals("")) {
                    sql.append(String.valueOf(String.format(" AND CLASS_CD3 like '%s", categ)) + "%'");
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("   AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                    sql.append("   OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                String proddup1 = (dto1 = ShopCommonDao.get().getSystemConf()).getPRODDUP1().equals("") ? "N" : dto1.getPRODDUP1();
                String string = proddup2 = dto1.getPRODDUP2().equals("") ? "N" : dto1.getPRODDUP2();
                if (proddup1.equals("Y")) {
                    List<Object> shopgrp = new ArrayList();
                    shopgrp = ShopCommonDao.get().getShopGroupWithShopseq(shopCd, shopSeq);
                    String sql1 = shopgrp.stream().map(name -> "'" + name + "'").collect(Collectors.joining(","));
                    sql.append(" AND NOT EXISTS (SELECT 1 \r\n");
                    sql.append(" \t\t\t\t   FROM SHOPPRODIN AS B \r\n");
                    sql.append(" \t\t\t\t  WHERE A.COMPNO=B.COMPNO \r\n");
                    sql.append(" \t\t\t\t\tAND A.PRODSEQ=B.PRODSEQ\r\n");
                    sql.append(" \t\t\t\t\tAND IFNULL(B.SHOPSENDSTATUS,'')<>9000\r\n");
                    sql.append(String.format(" AND B.SHOPCD='%s' \r\n", shopCd));
                    if (shopgrp.size() > 0) {
                        sql.append(String.format(" AND B.ShopSeq in (%s) ) \r\n", sql1));
                    } else {
                        sql.append(" ) \r\n");
                    }
                } else if (proddup2.equals("Y")) {
                    sql.append(" AND NOT EXISTS (SELECT 1 \r\n");
                    sql.append(" \t\t\t\t   FROM SHOPPRODIN AS B \r\n");
                    sql.append(" \t\t\t\t  WHERE A.COMPNO=B.COMPNO \r\n");
                    sql.append(" \t\t\t\t\tAND A.PRODSEQ=B.PRODSEQ\r\n");
                    sql.append(" \t\t\t\t\tAND IFNULL(B.SHOPSENDSTATUS,'')<>9000\r\n");
                    sql.append(String.format(" AND B.SHOPCD='%s' ) \r\n", shopCd));
                } else {
                    sql.append(" AND NOT EXISTS (SELECT 1 \r\n");
                    sql.append(" \t\t\t\t   FROM SHOPPRODIN AS B \r\n");
                    sql.append(" \t\t\t\t  WHERE A.COMPNO=B.COMPNO \r\n");
                    sql.append(" \t\t\t\t\tAND A.PRODSEQ=B.PRODSEQ\r\n");
                    sql.append(" \t\t\t\t\tAND IFNULL(B.SHOPSENDSTATUS,'')<>9000\r\n");
                    sql.append(String.format(" AND B.SHOPCD='%s' \r\n", shopCd));
                    sql.append(String.format(" AND B.ShopSeq='%s' ) \r\n", shopSeq));
                }
                sql.append("GROUP BY 1");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(3, prodFrom);
                        pstmt.setString(4, prodTo);
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                    }
                } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                }
                YDMAStringUtil.Print("[getShopProductTabCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.put(rs.getString("TYPE"), rs.getString("CNT"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public ShopCatInfDto getMidcateg(String midcate) throws Exception {
        ShopCatInfDto dto = new ShopCatInfDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select lrgcode from categmidium where compno = ? and code = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, midcate);
                YDMAStringUtil.Print("[getShopCatInf]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setShoplagcatcd(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public int getShopProductTabAllCount(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("  SELECT \r\n");
                sql.append("    '10000' AS TYPE ,  \tCOUNT(*) AS CNT \r\n");
                sql.append("  FROM SHOPPRODINFO \r\n");
                sql.append(" WHERE COMPNO = ? ");
                if (!dome.equals("")) {
                    sql.append("     AND GOODS_KEYWORD = ? ");
                }
                if (folder.equals("")) {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%"));
                } else {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder));
                }
                if (!categ.equals("")) {
                    sql.append(String.valueOf(String.format(" AND CLASS_CD3 like '%s", categ)) + "%'");
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("  AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                    sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(3, prodFrom);
                        pstmt.setString(4, prodTo);
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                    }
                } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                }
                YDMAStringUtil.Print("[getShopProductTabCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = YDMAStringUtil.convertToInt(rs.getString("CNT"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public Map<String, String> getShopProductTabShopUserCount(String searchgubun, String searchtxt, String prodFrom, String prodTo, String shopCd, String userID) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        HashMap<String, String> list = new HashMap<String, String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT DISTINCT (case when IFNULL(A.SHOPSENDSTATUS,'') = '-1' then '9000' \r\n");
                sql.append("                      else IFNULL(A.SHOPSENDSTATUS,'') END) AS TYPE, \r\n");
                sql.append("       COUNT(A.PRODSEQ) AS CNT \r\n");
                sql.append("  FROM SHOPPRODINFO AS A LEFT JOIN SHOPPRODIN AS B ON A.COMPNO=B.COMPNO AND A.PRODSEQ=B.PRODSEQ AND B.SHOPCD= ?  AND B.SHOP_USERID= ? \r\n");
                sql.append(" WHERE A.COMPNO = ? \r\n");
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("  AND ((A.INSERTDT >= ? AND A.INSERTDT <= ?) \r\n");
                    sql.append(" OR (A.MODIFYDT >= ? AND A.MODIFYDT <= ? ))\r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                sql.append("  AND B.PRODSEQ IS NULL \r\n");
                sql.append(" GROUP BY 1 ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, shopCd);
                pstmt.setString(2, userID);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                    pstmt.setString(6, prodFrom);
                    pstmt.setString(7, prodTo);
                }
                YDMAStringUtil.Print("[getShopProductTabShopUserCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.put(rs.getString("TYPE"), rs.getString("CNT"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public Map<String, String> getShopProductInTabShopUserCount(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo, String shopCd, int shopSeq) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        HashMap<String, String> list = new HashMap<String, String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT DISTINCT ifnull(SHOPSENDSTATUS,'') AS TYPE, COUNT(*) AS CNT \r\n");
                sql.append("  FROM SHOPPRODIN AS A \r\n");
                sql.append(" WHERE COMPNO = ? ");
                if (!dome.equals("")) {
                    sql.append("     AND GOODS_KEYWORD = ? ");
                }
                if (folder.equals("")) {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%"));
                } else {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder));
                }
                if (!categ.equals("")) {
                    sql.append(String.valueOf(String.format(" AND CLASS_CD3 like '%s", categ)) + "%'");
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("  AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                    sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                sql.append(" AND SHOPCD= ? \r\n");
                sql.append(" AND ShopSeq= ? \r\n");
                sql.append(" AND IFNULL(SHOPSENDSTATUS,'') <> '9000' \r\n");
                sql.append(" GROUP BY 1 ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(3, prodFrom);
                        pstmt.setString(4, prodTo);
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                        pstmt.setString(7, shopCd);
                        pstmt.setInt(8, shopSeq);
                    } else {
                        pstmt.setString(3, shopCd);
                        pstmt.setInt(4, shopSeq);
                    }
                } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                    pstmt.setString(6, shopCd);
                    pstmt.setInt(7, shopSeq);
                } else {
                    pstmt.setString(2, shopCd);
                    pstmt.setInt(3, shopSeq);
                }
                YDMAStringUtil.Print("[getShopProductInTabShopUserCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.put(rs.getString("TYPE"), rs.getString("CNT"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int getShopProductInCount() throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        new HashMap();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT DISTINCT ifnull(SHOPSENDSTATUS,'') AS TYPE, COUNT(PRODSEQ) AS CNT \r\n");
                sql.append("  FROM SHOPPRODIN AS A USE INDEX (SHOPSENDSTATUS) \r\n");
                sql.append(" WHERE COMPNO = ? ");
                sql.append("   AND SHOPSENDSTATUS <> '9000' \r\n");
                sql.append(" GROUP BY 1 ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopProductInCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result += YDMAStringUtil.convertToInt(rs.getString("CNT"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public Map<String, String> getShopProductInEndTabShopUserCount(String dome, String folder, String searchgubun, String searchtxt, String prodFrom, String prodTo, String shopCd, String shopSeq, int enddate) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        HashMap<String, String> list = new HashMap<String, String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT '5000' AS TYPE, COUNT(*) AS CNT \r\n");
                sql.append("  FROM SHOPPRODIN AS A \r\n");
                sql.append(" WHERE COMPNO = ? ");
                if (!dome.equals("")) {
                    sql.append("     AND GOODS_KEYWORD = ? ");
                }
                if (folder.equals("")) {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%"));
                } else {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder));
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("  AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                    sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                sql.append(" AND SHOPCD= ? \r\n");
                sql.append(" AND ShopSeq= ? \r\n");
                sql.append(" AND IFNULL(SHOPSENDSTATUS,'') <> '9000' \r\n");
                sql.append(" AND DATE_FORMAT(SALEENDDT,'%Y%m%d') <= DATE_FORMAT(DATE_ADD(NOW(), INTERVAL " + enddate + " DAY),'%Y%m%d')  \r\n");
                String sqlQuery = sql.toString().toUpperCase().replaceAll("%M%D", "%m%d");
                pstmt = connection.prepareStatement(sqlQuery);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(3, prodFrom);
                        pstmt.setString(4, prodTo);
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                        pstmt.setString(7, shopCd);
                        pstmt.setString(8, shopSeq);
                    } else {
                        pstmt.setString(3, shopCd);
                        pstmt.setString(4, shopSeq);
                    }
                } else if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                    pstmt.setString(6, shopCd);
                    pstmt.setString(7, shopSeq);
                } else {
                    pstmt.setString(2, shopCd);
                    pstmt.setString(3, shopSeq);
                }
                YDMAStringUtil.Print("[getShopProductInTabShopUserCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.put(rs.getString("TYPE"), rs.getString("CNT"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int getShopProductInEndCount(int enddate) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        new HashMap();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT '5000' AS TYPE, COUNT(PRODSEQ) AS CNT \r\n");
                sql.append("  FROM SHOPPRODIN AS A USE INDEX (SALEENDDT) \r\n");
                sql.append(" WHERE COMPNO = ? AND SALEENDDT <> '' ");
                sql.append(" AND SHOPSENDSTATUS <> '9000' \r\n");
                sql.append(" AND DATE_FORMAT(SALEENDDT,'%Y%m%d') <= DATE_FORMAT(DATE_ADD(NOW(), INTERVAL " + enddate + " DAY),'%Y%m%d')  \r\n");
                String sqlQuery = sql.toString().toUpperCase().replaceAll("%M%D", "%m%d");
                pstmt = connection.prepareStatement(sqlQuery);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopProductInEndCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result += YDMAStringUtil.convertToInt(rs.getString("CNT"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int getShopProductInfoTabAllCount(String searchgubun, String searchtxt, String prodFrom, String prodTo, String type, String shopCd) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("  SELECT \r\n");
                sql.append("  COUNT(SENDSEQ) AS CNT \r\n");
                sql.append("  FROM SHOPPRODIN \r\n");
                sql.append(" WHERE COMPNO = ? AND SHOPSENDSTATUS <> '9000'");
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("  AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                    sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                if (type.equals("C")) {
                    sql.append(" AND SHOPCD = ? \r\n");
                }
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(2, prodFrom);
                    pstmt.setString(3, prodTo);
                    pstmt.setString(4, prodFrom);
                    pstmt.setString(5, prodTo);
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    if (type.equals("C")) {
                        pstmt.setString(6, shopCd);
                    }
                } else if (type.equals("C")) {
                    pstmt.setString(2, shopCd);
                }
                YDMAStringUtil.Print("[getShopProductTabCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = YDMAStringUtil.convertToInt(rs.getString("CNT"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ProductDTO> getShopProductInList(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo, int block, int page, String cmdID, String shopCd, String shopSeq, int shopsendstatus, boolean isSoldOut) throws Exception {
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                int block_data = 0;
                if (page > 0) {
                    block_data = block * (page - 1);
                }
                sql.append("SELECT * FROM ( \r\n");
                sql.append(" WITH CTE_PRODLIST AS ( \r\n");
                sql.append("  SELECT IFNULL(SENDSEQ,'') AS SENDSEQ \r\n");
                sql.append("    FROM SHOPPRODIN USE INDEX(INSERTDT_DESC) \r\n");
                sql.append("   WHERE COMPNO = ?  AND INSERTDT<>''   \r\n");
                if (!dome.equals("")) {
                    sql.append("  AND GOODS_KEYWORD = ? ");
                }
                if (folder.equals("")) {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%"));
                } else {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder));
                }
                if (!categ.equals("")) {
                    sql.append(String.valueOf(String.format(" AND CLASS_CD3 like '%s", categ)) + "%'");
                }
                if (!shopCd.equals("")) {
                    sql.append(" AND SHOPCD = ? ");
                    sql.append(" AND IFNULL(SHOPSENDSTATUS,'') = ? ");
                } else {
                    if (isSoldOut) {
                        sql.append(" AND IFNULL(SHOPSENDSTATUS,'') IN (6000,7000)");
                    }
                    if (!searchtxt.equals("")) {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                    sql.append(" ORDER BY INSERTDT DESC) ");
                }
                if (cmdID.equals("U")) {
                    sql.append(" AND  ShopSeq = ? ");
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append(" AND ((INSERTDT >= ? AND INSERTDT <= ?) ");
                    sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? )) ");
                }
                if (!shopCd.equals("") && !searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                if (page > 0) {
                    sql.append(" ORDER BY INSERTDT DESC ");
                    sql.append(String.format(" LIMIT %s,%s )  \r\n", block_data, block));
                }
                sql.append(" SELECT INFO.*  , \r\n");
                if (YDMASessonUtil.getLoginType() == 0) {
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGLARGE WHERE compno = %s AND CODE = INFO.CLASS_CD1), '')  CLASS_NM1, \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGMIDIUM WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2)), '')  CLASS_NM2,  \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGSMALL WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2,INFO.CLASS_CD3)), '')  CLASS_NM3,  \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGDETAIL WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2,INFO.CLASS_CD3,INFO.CLASS_CD4)), '') as CLASS_NM4, \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                }
                sql.append(" (CASE                            \r\n");
                sql.append("     WHEN STATUS = '0'       \r\n");
                sql.append("     THEN '\uacf5\uae09\uc911'           \r\n");
                sql.append("     WHEN STATUS = '1'       \r\n");
                sql.append("     THEN '\ud488\uc808'           \r\n");
                sql.append("     WHEN STATUS = '2'       \r\n");
                sql.append("     THEN '\ub2e8\uc885'         \r\n");
                sql.append("  END )AS STATUS_NM, \r\n");
                sql.append("  (CASE                             \r\n");
                sql.append("     WHEN DELV_TYPE = '1'     \r\n");
                sql.append("     THEN '\ubb34\ub8cc'              \r\n");
                sql.append("     WHEN DELV_TYPE = '2'     \r\n");
                sql.append("     THEN '\ucc29\ubd88'              \r\n");
                sql.append("     WHEN DELV_TYPE = '3'     \r\n");
                sql.append("     THEN '\uc120\uacb0\uc81c'            \r\n");
                sql.append("     WHEN DELV_TYPE = '4'     \r\n");
                sql.append("     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n");
                sql.append("     ELSE ''                  \r\n");
                sql.append("  END )AS DELV_TYPE_NM  \r\n");
                sql.append("  FROM \r\n");
                sql.append(" (\r\n");
                sql.append("    SELECT \r\n");
                sql.append("      IFNULL(A.PRODSEQ,'') AS PRODSEQ ,\r\n");
                sql.append("     IFNULL(A.COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD ,\r\n");
                sql.append("      IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n");
                sql.append("   CONCAT(IFNULL(CLASS_CD1,''), IFNULL(CLASS_CD2,''), IFNULL(CLASS_CD3,''), IFNULL(CLASS_CD4,'')) AS CODE,\r\n");
                sql.append("      IFNULL(SHOPCD,'' ) AS SHOPCD,\r\n");
                sql.append("      IFNULL(SHOP_USERID,'' ) AS SHOP_USERID,\r\n");
                sql.append("      '' as img,\r\n");
                sql.append("       IFNULL(GOODS_NM,'' ) AS GOODS_NM,\r\n");
                sql.append("     IFNULL(GOODS_KEYWORD,'' ) AS GOODS_KEYWORD  ,\r\n");
                sql.append("     IFNULL(MODEL_NM,'' ) AS MODEL_NM  ,\r\n");
                sql.append(" IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n");
                sql.append(" IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n");
                sql.append(" IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n");
                sql.append(" IFNULL(SHOP_CID_INFO,'' ) AS SHOP_CID_INFO,  \r\n");
                sql.append(" IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n");
                sql.append(" IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n");
                sql.append(" IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n");
                sql.append(" IFNULL(CLASS_CD4,'' ) AS CLASS_CD4 ,\r\n");
                sql.append("  IFNULL(MAKER,'' ) AS MAKER,  \r\n");
                sql.append(" IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n");
                sql.append(" IFNULL(SEX,'' ) AS SEX,  \r\n");
                sql.append("   IFNULL(STATUS, '') AS STATUS,\r\n");
                sql.append(" IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n");
                sql.append(" IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n");
                sql.append(" IFNULL(CERT,'' ) AS CERT,  \r\n");
                sql.append("IFNULL(ISLIMIT,'' ) AS ISLIMIT,  \r\n");
                sql.append("IFNULL(LIMIT_PRICE,'' ) AS LIMIT_PRICE,  \r\n");
                sql.append("IFNULL(IS_OVERSEAS,'' ) AS IS_OVERSEAS,  \r\n");
                sql.append("IFNULL(ITYPE,'' ) AS ITYPE,              \r\n");
                sql.append("IFNULL(ADULT,'' ) AS ADULT,               \r\n");
                sql.append("IFNULL(ISRETURN,'' ) AS ISRETURN,         \r\n");
                sql.append("IFNULL(TEXT_OPTION,'' ) AS TEXT_OPTION,   \r\n");
                sql.append("IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n");
                sql.append(" IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n");
                sql.append(" IFNULL(RETURN_DELV_COST,'0' ) AS RETURN_DELV_COST,  \r\n");
                sql.append(" IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n");
                sql.append(" IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n");
                sql.append(" IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n");
                sql.append(" IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n");
                sql.append(" IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n");
                sql.append(" IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n");
                sql.append(" IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n");
                sql.append(" IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n");
                sql.append(" IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n");
                sql.append(" IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n");
                sql.append(" IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n");
                sql.append(" IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n");
                sql.append(" IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n");
                sql.append(" IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n");
                sql.append(" IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n");
                sql.append(" IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n");
                sql.append(" IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n");
                sql.append(" IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n");
                sql.append(" IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n");
                sql.append(" IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n");
                sql.append(" IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n");
                sql.append(" IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,   \r\n");
                sql.append(" IFNULL(CERTNO,'' ) AS CERTNO,  \r\n");
                sql.append(" IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n");
                sql.append(" IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n");
                sql.append(" IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n");
                sql.append(" IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n");
                sql.append(" IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n");
                sql.append(" IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n");
                sql.append(" IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n");
                sql.append(" IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n");
                sql.append(" IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n");
                sql.append(" IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n");
                sql.append(" IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n");
                sql.append(" IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n");
                sql.append(" IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n");
                sql.append(" IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n");
                sql.append(" IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n");
                sql.append(" IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n");
                sql.append(" IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n");
                sql.append(" IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n");
                sql.append(" IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n");
                sql.append(" IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n");
                sql.append(" IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n");
                sql.append(" IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n");
                sql.append(" IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n");
                sql.append(" IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n");
                sql.append(" IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n");
                sql.append(" IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n");
                sql.append(" IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n");
                sql.append(" IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n");
                sql.append(" IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n");
                sql.append(" IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n");
                sql.append(" IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n");
                sql.append(" IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n");
                sql.append(" IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n");
                sql.append(" IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n");
                sql.append(" IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n");
                sql.append(" IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n");
                sql.append(" IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n");
                sql.append(" IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n");
                sql.append(" IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n");
                sql.append(" IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n");
                sql.append(" IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n");
                sql.append(" IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n");
                sql.append(" IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n");
                sql.append(" IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n");
                sql.append(" IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n");
                sql.append(" IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n");
                sql.append(" IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n");
                sql.append(" IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n");
                sql.append(" IFNULL(INSERTID,'' ) AS INSERTID,  \r\n");
                sql.append(" IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n");
                sql.append(" IFNULL(MODIFYID, '' ) AS MODIFYID,  \r\n");
                sql.append(" IFNULL(SEQ, '' ) AS SEQ,  \r\n");
                sql.append(" IFNULL(MARKET_PRICE, '0' ) AS MARKET_PRICE,  \r\n");
                sql.append(" IFNULL(ShopSendStatus, '' ) AS ShopSendStatus, \r\n");
                sql.append(" IFNULL(SHOPSEQ, '' ) AS SHOPSEQ, \r\n");
                sql.append(" IFNULL(GMCATEGNM, '' ) AS GMCATEGNM, \r\n");
                sql.append(" IFNULL(SALEENDDT, '' ) AS SALEENDDT, \r\n");
                sql.append(" IFNULL(DELV_QTY, '' ) AS DELV_QTY, \r\n");
                sql.append(" IFNULL(SHOPMODIFYCONTENT, '') AS SHOPMODIFYCONTENT, \r\n");
                sql.append(" IFNULL(SELFMOD_NO, '' ) AS SELFMOD_NO, \r\n");
                sql.append(" IFNULL(A.Sendseq,'' ) AS Sendseq \r\n");
                sql.append(" FROM SHOPPRODIN AS A INNER JOIN (SELECT SENDSEQ FROM CTE_PRODLIST) AS B ON A.SENDSEQ = B.SENDSEQ \r\n");
                sql.append(" ORDER BY A.INSERTDT DESC  ) AS INFO ) AA  ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    if (!shopCd.equals("")) {
                        pstmt.setString(3, shopCd);
                        pstmt.setInt(4, shopsendstatus);
                        pstmt.setString(5, shopSeq);
                        if (!prodFrom.equals("") && !prodTo.equals("")) {
                            pstmt.setString(6, prodFrom);
                            pstmt.setString(7, prodTo);
                            pstmt.setString(8, prodFrom);
                            pstmt.setString(9, prodTo);
                        }
                    }
                } else if (!shopCd.equals("")) {
                    pstmt.setString(2, shopCd);
                    pstmt.setInt(3, shopsendstatus);
                    pstmt.setString(4, shopSeq);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                        pstmt.setString(7, prodFrom);
                        pstmt.setString(8, prodTo);
                    }
                }
                YDMAStringUtil.Print("[getShopProductList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                if (page > 0) {
                    rowno = block * (page - 1);
                }
                List<ShopProdAttrnmDto> shopProdAttrnmAll = this.getProductNoticeAll();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setRowno("" + ++rowno);
                    dto.setCode(rs.getString("CODE"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setSHOP_USERID(rs.getString("SHOP_USERID"));
                    dto.setSENDSEQ(rs.getString("SENDSEQ"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setImg(rs.getString("Img"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    if (rs.getString("SHOP_CID_INFO").equals("")) {
                        DomesinShopDao.get();
                        String[] chgitems = DomesinShopDao.isShopProductInfoExits(rs.getString("COMPNO"), rs.getString("COMPAYNY_GOODS_CD"));
                        dto.setShop_cid_info(chgitems[13]);
                    } else {
                        dto.setShop_cid_info(rs.getString("SHOP_CID_INFO"));
                    }
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id("");
                    dto.setDpartner_id("");
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year("");
                    dto.setMake_dm("");
                    dto.setGoods_season("");
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelv_r_cost(rs.getString("RETURN_DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setMarket_price(rs.getString("MARKET_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setMarket_price(rs.getString("MARKET_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCertmodel("");
                    dto.setCertname("");
                    dto.setExemptiontype("");
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(YDMAStringUtil.leftPad(rs.getString("PROP1_CD"), 3, "0"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en("");
                    dto.setGoods_nm_pr("");
                    dto.setGoods_remarks2("");
                    dto.setGoods_remarks3("");
                    dto.setGoods_remarks4("");
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setCert(rs.getString("CERT"));
                    dto.setIslimit(rs.getString("ISLIMIT"));
                    dto.setLimit_price(rs.getString("LIMIT_PRICE"));
                    dto.setIs_overseas(rs.getString("IS_OVERSEAS"));
                    dto.setItype(rs.getString("ITYPE"));
                    dto.setAdult(rs.getString("ADULT"));
                    dto.setIsreturn(rs.getString("ISRETURN"));
                    dto.setText_option(rs.getString("TEXT_OPTION"));
                    dto.setGmcategnm(rs.getString("GMCATEGNM"));
                    if (YDMASessonUtil.getLoginType() == 0) {
                        dto.setClass_nm1(rs.getString("CLASS_NM1"));
                        dto.setClass_nm2(rs.getString("CLASS_NM2"));
                        dto.setClass_nm3(rs.getString("CLASS_NM3"));
                        dto.setClass_nm4(rs.getString("CLASS_NM4"));
                    }
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setGoods_gubun_nm("");
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                    dto.setSendstats(rs.getString("SHOPSENDSTATUS"));
                    dto.setSaleenddt(rs.getString("SALEENDDT"));
                    dto.setShopmodifycontent(rs.getString("SHOPMODIFYCONTENT"));
                    dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                    dto.setDelivery_qty(rs.getString("DELV_QTY"));
                    if (YDMASessonUtil.getLoginType() == 2) {
                        String class_cd4 = rs.getString("CLASS_CD4");
                        String class_cd3 = rs.getString("CLASS_CD3");
                        String shop_cid = !class_cd4.isEmpty() ? class_cd4 : class_cd3;
                        String full_cateName = MLinkShopDao.getNewCategoryFullCateName(shop_cid);
                        if (full_cateName.equals("")) {
                            String shopcd = rs.getString("GOODS_KEYWORD");
                            full_cateName = MLinkShopDao.getFullCateName(shopcd, shop_cid);
                        }
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    } else {
                        List<String> ret = Arrays.asList(dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4());
                        String shop_cid = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining());
                        ret = Arrays.asList(dto.getClass_nm1(), dto.getClass_nm2(), dto.getClass_nm3(), dto.getClass_nm4());
                        String full_cateName = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining(">"));
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    }
                    dto.setShopProdAttrnmDtos(shopProdAttrnmAll);
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ProductDTO> getShopProductInEndList(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo, int block, int page, String cmdID, String shopCd, String shopSeq, int shopsendstatus, int enddate) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                int block_data = block * (page - 1);
                sql.append(" SELECT * FROM ( \r\n");
                sql.append(" SELECT INFO.*  , \r\n");
                if (YDMASessonUtil.getLoginType() == 0) {
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGLARGE WHERE compno = %s AND CODE = INFO.CLASS_CD1), '')  CLASS_NM1, \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGMIDIUM WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2)), '')  CLASS_NM2,  \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGSMALL WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2,INFO.CLASS_CD3)), '')  CLASS_NM3,  \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                    sql.append(String.format(" IFNULL((SELECT CATEGORY FROM  CATEGDETAIL WHERE compno = %s AND CODE = CONCAT(INFO.CLASS_CD1,INFO.CLASS_CD2,INFO.CLASS_CD3,INFO.CLASS_CD4)), '') as CLASS_NM4, \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                }
                sql.append(" (CASE                            \r\n");
                sql.append("     WHEN STATUS = '0'       \r\n");
                sql.append("     THEN '\uacf5\uae09\uc911'           \r\n");
                sql.append("     WHEN STATUS = '1'       \r\n");
                sql.append("     THEN '\ud488\uc808'           \r\n");
                sql.append("     WHEN STATUS = '2'       \r\n");
                sql.append("     THEN '\ub2e8\uc885'         \r\n");
                sql.append("  END )AS STATUS_NM, \r\n");
                sql.append("  (CASE                             \r\n");
                sql.append("     WHEN DELV_TYPE = '1'     \r\n");
                sql.append("     THEN '\ubb34\ub8cc'              \r\n");
                sql.append("     WHEN DELV_TYPE = '2'     \r\n");
                sql.append("     THEN '\ucc29\ubd88'              \r\n");
                sql.append("     WHEN DELV_TYPE = '3'     \r\n");
                sql.append("     THEN '\uc120\uacb0\uc81c'            \r\n");
                sql.append("     WHEN DELV_TYPE = '4'     \r\n");
                sql.append("     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n");
                sql.append("     ELSE ''                  \r\n");
                sql.append("  END )AS DELV_TYPE_NM  \r\n");
                sql.append("  FROM \r\n");
                sql.append(" (\r\n");
                sql.append("    SELECT \r\n");
                sql.append("      IFNULL(A.PRODSEQ,'') AS PRODSEQ ,\r\n");
                sql.append("     IFNULL(A.COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD ,\r\n");
                sql.append("      IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n");
                sql.append("   CONCAT(IFNULL(CLASS_CD1,''), IFNULL(CLASS_CD2,''), IFNULL(CLASS_CD3,''), IFNULL(CLASS_CD4,'')) AS CODE,\r\n");
                sql.append("      IFNULL(SHOPCD,'' ) AS SHOPCD,\r\n");
                sql.append("      IFNULL(SHOP_USERID,'' ) AS SHOP_USERID,\r\n");
                sql.append("      '' as img,\r\n");
                sql.append("       IFNULL(GOODS_NM,'' ) AS GOODS_NM,\r\n");
                sql.append("     IFNULL(GOODS_KEYWORD,'' ) AS GOODS_KEYWORD  ,\r\n");
                sql.append("     IFNULL(MODEL_NM,'' ) AS MODEL_NM  ,\r\n");
                sql.append(" IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n");
                sql.append(" IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n");
                sql.append(" IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n");
                sql.append(" IFNULL(SHOP_CID_INFO,'' ) AS SHOP_CID_INFO,  \r\n");
                sql.append(" IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n");
                sql.append(" IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n");
                sql.append(" IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n");
                sql.append(" IFNULL(CLASS_CD4,'' ) AS CLASS_CD4 ,\r\n");
                sql.append("  IFNULL(MAKER,'' ) AS MAKER,  \r\n");
                sql.append(" IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n");
                sql.append(" IFNULL(SEX,'' ) AS SEX,  \r\n");
                sql.append("   IFNULL(STATUS, '') AS STATUS,\r\n");
                sql.append(" IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n");
                sql.append(" IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n");
                sql.append(" IFNULL(CERT,'' ) AS CERT,  \r\n");
                sql.append("IFNULL(ISLIMIT,'' ) AS ISLIMIT,  \r\n");
                sql.append("IFNULL(LIMIT_PRICE,'' ) AS LIMIT_PRICE,  \r\n");
                sql.append("IFNULL(IS_OVERSEAS,'' ) AS IS_OVERSEAS,  \r\n");
                sql.append("IFNULL(ITYPE,'' ) AS ITYPE,              \r\n");
                sql.append("IFNULL(ADULT,'' ) AS ADULT,               \r\n");
                sql.append("IFNULL(ISRETURN,'' ) AS ISRETURN,         \r\n");
                sql.append("IFNULL(TEXT_OPTION,'' ) AS TEXT_OPTION,   \r\n");
                sql.append("IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n");
                sql.append(" IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n");
                sql.append(" IFNULL(RETURN_DELV_COST,'0' ) AS RETURN_DELV_COST,  \r\n");
                sql.append(" IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n");
                sql.append(" IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n");
                sql.append(" IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n");
                sql.append(" IFNULL(MARKET_PRICE,'' ) AS MARKET_PRICE,  \r\n");
                sql.append(" IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n");
                sql.append(" IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n");
                sql.append(" IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n");
                sql.append(" IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n");
                sql.append(" IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n");
                sql.append(" IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n");
                sql.append(" IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n");
                sql.append(" IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n");
                sql.append(" IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n");
                sql.append(" IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n");
                sql.append(" IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n");
                sql.append(" IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n");
                sql.append(" IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n");
                sql.append(" IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n");
                sql.append(" IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n");
                sql.append(" IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n");
                sql.append(" IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n");
                sql.append(" IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n");
                sql.append(" IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,   \r\n");
                sql.append(" IFNULL(CERTNO,'' ) AS CERTNO,  \r\n");
                sql.append(" IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n");
                sql.append(" IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n");
                sql.append(" IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n");
                sql.append(" IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n");
                sql.append(" IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n");
                sql.append(" IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n");
                sql.append(" IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n");
                sql.append(" IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n");
                sql.append(" IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n");
                sql.append(" IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n");
                sql.append(" IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n");
                sql.append(" IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n");
                sql.append(" IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n");
                sql.append(" IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n");
                sql.append(" IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n");
                sql.append(" IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n");
                sql.append(" IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n");
                sql.append(" IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n");
                sql.append(" IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n");
                sql.append(" IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n");
                sql.append(" IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n");
                sql.append(" IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n");
                sql.append(" IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n");
                sql.append(" IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n");
                sql.append(" IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n");
                sql.append(" IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n");
                sql.append(" IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n");
                sql.append(" IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n");
                sql.append(" IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n");
                sql.append(" IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n");
                sql.append(" IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n");
                sql.append(" IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n");
                sql.append(" IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n");
                sql.append(" IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n");
                sql.append(" IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n");
                sql.append(" IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n");
                sql.append(" IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n");
                sql.append(" IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n");
                sql.append(" IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n");
                sql.append(" IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n");
                sql.append(" IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n");
                sql.append(" IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n");
                sql.append(" IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n");
                sql.append(" IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n");
                sql.append(" IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n");
                sql.append(" IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n");
                sql.append(" IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n");
                sql.append(" IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n");
                sql.append(" IFNULL(INSERTID,'' ) AS INSERTID,  \r\n");
                sql.append(" IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n");
                sql.append(" IFNULL(MODIFYID, '' ) AS MODIFYID,  \r\n");
                sql.append(" IFNULL(SEQ, '' ) AS SEQ,  \r\n");
                sql.append(" IFNULL(ShopSendStatus, '' ) AS ShopSendStatus, \r\n");
                sql.append("IFNULL(SHOPSEQ, '' ) AS SHOPSEQ, \r\n");
                sql.append("IFNULL(GMCATEGNM, '' ) AS GMCATEGNM, \r\n");
                sql.append("IFNULL(SALEENDDT, '' ) AS SALEENDDT, \r\n");
                sql.append("IFNULL(DELV_QTY, '' ) AS DELV_QTY, \r\n");
                sql.append("IFNULL(SHOPMODIFYCONTENT, '' ) AS SHOPMODIFYCONTENT, \r\n");
                sql.append("IFNULL(SELFMOD_NO, '' ) AS SELFMOD_NO, \r\n");
                sql.append("IFNULL(Sendseq,'' ) AS Sendseq \r\n");
                sql.append(" FROM SHOPPRODIN AS A USE INDEX (SALEENDDT) \r\n");
                sql.append(" WHERE COMPNO = ? AND SALEENDDT<>''");
                if (!dome.equals("")) {
                    sql.append("     AND GOODS_KEYWORD = ? ");
                }
                if (folder.equals("")) {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD NOT IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER LIKE '%s')", YDMASessonUtil.getCompnoInfo().getCompno(), "NOT_%"));
                } else {
                    sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (SELECT COMPAYNY_GOODS_CD FROM shopprodfolders WHERE COMPNO=%s AND FOLDER='%s')", YDMASessonUtil.getCompnoInfo().getCompno(), folder));
                }
                if (!categ.equals("")) {
                    sql.append(String.valueOf(String.format(" AND CLASS_CD3 like '%s", categ)) + "%'");
                }
                sql.append(" AND SHOPCD = ? ");
                sql.append("   AND IFNULL(SHOPSENDSTATUS,'') <> 9000 ");
                sql.append("   AND ShopSeq = ? ");
                sql.append("   AND DATE_FORMAT(SALEENDDT,'%Y%m%d') <= DATE_FORMAT(DATE_ADD(NOW(), INTERVAL " + enddate + " DAY),'%Y%m%d') ");
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append(" AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                    sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                sql.append(" ) AS INFO  \r\n");
                sql.append(String.format(" LIMIT %s,%s ) AA ", block_data, block));
                String sqlQuery = sql.toString().toUpperCase().replaceAll("%M%D", "%m%d");
                pstmt = connection.prepareStatement(sqlQuery);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                    pstmt.setString(3, shopCd);
                    pstmt.setString(4, shopSeq);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(5, prodFrom);
                        pstmt.setString(6, prodTo);
                        pstmt.setString(7, prodFrom);
                        pstmt.setString(8, prodTo);
                    }
                } else {
                    pstmt.setString(2, shopCd);
                    pstmt.setString(3, shopSeq);
                    if (!prodFrom.equals("") && !prodTo.equals("")) {
                        pstmt.setString(4, prodFrom);
                        pstmt.setString(5, prodTo);
                        pstmt.setString(6, prodFrom);
                        pstmt.setString(7, prodTo);
                    }
                }
                YDMAStringUtil.Print("[getShopProductEndList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = block * (page - 1);
                List<ShopProdAttrnmDto> shopProdAttrnmAll = this.getProductNoticeAll();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setRowno("" + ++rowno);
                    dto.setCode(rs.getString("CODE"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setSHOP_USERID(rs.getString("SHOP_USERID"));
                    dto.setSENDSEQ(rs.getString("SENDSEQ"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setImg(rs.getString("Img"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setShop_cid_info(rs.getString("SHOP_CID_INFO"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id("");
                    dto.setDpartner_id("");
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year("");
                    dto.setMake_dm("");
                    dto.setGoods_season("");
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelv_r_cost(rs.getString("RETURN_DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setMarket_price(rs.getString("MARKET_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCertmodel("");
                    dto.setCertname("");
                    dto.setExemptiontype("");
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(YDMAStringUtil.leftPad(rs.getString("PROP1_CD"), 3, "0"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en("");
                    dto.setGoods_nm_pr("");
                    dto.setGoods_remarks2("");
                    dto.setGoods_remarks3("");
                    dto.setGoods_remarks4("");
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setCert(rs.getString("CERT"));
                    dto.setIslimit(rs.getString("ISLIMIT"));
                    dto.setLimit_price(rs.getString("LIMIT_PRICE"));
                    dto.setIs_overseas(rs.getString("IS_OVERSEAS"));
                    dto.setItype(rs.getString("ITYPE"));
                    dto.setAdult(rs.getString("ADULT"));
                    dto.setIsreturn(rs.getString("ISRETURN"));
                    dto.setText_option(rs.getString("TEXT_OPTION"));
                    dto.setGmcategnm(rs.getString("GMCATEGNM"));
                    if (YDMASessonUtil.getLoginType() == 0) {
                        dto.setClass_nm1(rs.getString("CLASS_NM1"));
                        dto.setClass_nm2(rs.getString("CLASS_NM2"));
                        dto.setClass_nm3(rs.getString("CLASS_NM3"));
                        dto.setClass_nm4(rs.getString("CLASS_NM4"));
                    }
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setGoods_gubun_nm("");
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                    dto.setSendstats(String.valueOf(5000));
                    dto.setSaleenddt(rs.getString("SALEENDDT"));
                    dto.setShopmodifycontent(rs.getString("SHOPMODIFYCONTENT"));
                    dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                    dto.setDelivery_qty(rs.getString("DELV_QTY"));
                    if (YDMASessonUtil.getLoginType() == 2) {
                        String class_cd4 = rs.getString("CLASS_CD4");
                        String class_cd3 = rs.getString("CLASS_CD3");
                        String shop_cid = !class_cd4.isEmpty() ? class_cd4 : class_cd3;
                        String full_cateName = MLinkShopDao.getNewCategoryFullCateName(shop_cid);
                        if (full_cateName.equals("")) {
                            String shopcd = rs.getString("GOODS_KEYWORD");
                            full_cateName = MLinkShopDao.getFullCateName(shopcd, shop_cid);
                        }
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    } else {
                        List<String> ret = Arrays.asList(dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4());
                        String shop_cid = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining());
                        ret = Arrays.asList(dto.getClass_nm1(), dto.getClass_nm2(), dto.getClass_nm3(), dto.getClass_nm4());
                        String full_cateName = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining(">"));
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    }
                    dto.setShopProdAttrnmDtos(shopProdAttrnmAll);
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public String getNewCountShopProdInfoForUpdate(String dome, String folder, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        new ArrayList();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT count(PRODSEQ) AS CNT ");
                sql.append("  FROM SHOPPRODINFO USE INDEX (INSERTDT_DESC) \r\n");
                sql.append(String.format(" WHERE COMPNO = %s \r\n", compno));
                if (!dome.equals("")) {
                    sql.append(String.format(" AND GOODS_KEYWORD = '%s' \r\n", dome));
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append(String.format(" AND ((INSERTDT >= '%s' AND INSERTDT <= '%s') \r\n", prodFrom, prodTo));
                    sql.append(String.format(" OR (MODIFYDT >= '%s' AND MODIFYDT <= '%s' ))\r\n", prodFrom, prodTo));
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                YDMAStringUtil.Print("[getNewCountShopProdInfoForUpdate]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = rs.getString("CNT");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getCountShopProdInfoForUpdate(Map<String, String> parameters) throws Exception {
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        new ArrayList();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String result = "";
        try {
            try {
                String sql1;
                List<String> nameList;
                String[] searchtxt;
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT count(PRODSEQ) AS CNT ");
                sql.append("  FROM SHOPPRODINFO USE INDEX (INSERTDT_DESC) \r\n");
                sql.append(String.format(" WHERE COMPNO = %s \r\n", compno));
                if (!parameters.get("dome").equals("")) {
                    sql.append(String.format(" AND GOODS_KEYWORD = '%s' \r\n", parameters.get("dome")));
                }
                sql.append(String.format(" AND INSERTDT >= '%s' \r\n", parameters.get("start_date")));
                sql.append(String.format(" AND INSERTDT <= '%s' \r\n", parameters.get("end_date")));
                if (!parameters.get("cid_arr").equals("")) {
                    searchtxt = parameters.get("cid_arr").replace(" ", ",").replace("\n", ",").split(",");
                    nameList = Arrays.asList(searchtxt);
                    sql1 = nameList.stream().map(name -> name).collect(Collectors.joining("|^"));
                    if (parameters.get("cid_type").equals("0")) {
                        sql.append(" AND REGEXP_LIKE(CLASS_CD3,'^" + sql1 + "')\r\n");
                    } else {
                        sql.append(" AND (CLASS_CD1 not in (" + sql1 + ") or CLASS_CD2 not in (" + sql1 + ") or CLASS_CD3 not in (" + sql1 + "))\r\n");
                    }
                }
                if (!parameters.get("min_amount").equals("0")) {
                    sql.append(String.format(" AND GOODS_COST >= %s \r\n", parameters.get("min_amount")));
                }
                if (!parameters.get("max_amount").equals("0")) {
                    sql.append(String.format(" AND GOODS_COST <= %s \r\n", parameters.get("max_amount")));
                }
                if (!parameters.get("vender_m_code").equals("")) {
                    searchtxt = parameters.get("vender_m_code").replace(" ", ",").replace("\n", ",").split(",");
                    nameList = Arrays.asList(searchtxt);
                    sql1 = nameList.stream().map(name -> "'" + name + "'").collect(Collectors.joining(","));
                    if (parameters.get("vender_m_code_type").equals("0")) {
                        sql.append(" AND PARTNER_ID in (" + sql1 + ") \r\n");
                    } else {
                        sql.append(" AND PARTNER_ID not in (" + sql1 + ") \r\n");
                    }
                }
                if (!parameters.get("icode_arr").equals("")) {
                    searchtxt = parameters.get("icode_arr").replace(" ", ",").replace("\n", ",").split(",");
                    nameList = Arrays.asList(searchtxt);
                    sql1 = nameList.stream().map(name -> "'" + name + "'").collect(Collectors.joining(","));
                    if (parameters.get("icode_type").equals("0")) {
                        sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (%s) \r\n", sql1));
                    } else {
                        sql.append(String.format(" AND COMPAYNY_GOODS_CD not IN (%s) \r\n", sql1));
                    }
                }
                if (!parameters.get("q").equals("")) {
                    searchtxt = parameters.get("q").replace(" ", ",").replace("\n", ",").split(",");
                    nameList = Arrays.asList(searchtxt);
                    sql1 = nameList.stream().map(name -> "'" + name + "'").collect(Collectors.joining(","));
                    sql.append(" AND (GOODS_SEARCH in (" + sql1 + ") OR GOODS_NM in (" + sql1 + "))\r\n");
                }
                if (!parameters.get("is_overseas").equals("")) {
                    sql.append(String.format(" AND IS_OVERSEAS = '%s' \r\n", parameters.get("is_overseas")));
                }
                if (!parameters.get("is_tax").equals("")) {
                    sql.append(String.format(" AND TAX_YN = '%s' \r\n", parameters.get("is_tax")));
                }
                if (!parameters.get("isreturn").equals("")) {
                    sql.append(String.format(" AND ISRETURN = '%s' \r\n", parameters.get("isreturn")));
                }
                if (!parameters.get("islimit").equals("")) {
                    sql.append(String.format(" AND ISLIMIT = '%s' \r\n", parameters.get("islimit")));
                }
                if (!parameters.get("delivery_type").equals("")) {
                    sql.append(String.format(" AND DELV_TYPE = '%s' \r\n", parameters.get("delivery_type")));
                }
                if (!parameters.get("list_option_use").equals("")) {
                    sql.append(String.format(" AND OPTIONYN = '%s' \r\n", parameters.get("list_option_use")));
                }
                if (!parameters.get("adult").equals("")) {
                    sql.append(String.format(" AND ADULT = '%s' \r\n", parameters.get("adult")));
                }
                if (!parameters.get("status").equals("")) {
                    sql.append(String.format(" AND STATUS = '%s' ", parameters.get("status")));
                }
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                YDMAStringUtil.Print("[getCountShopProdInfoForUpdate]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = rs.getString("CNT");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ProductDTO> getNewShopProductInfoForUpdate(String dome, String folder, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("WITH CTE_PRODLIST AS( \r\n");
                sql.append(" SELECT \r\n");
                sql.append("  \tIFNULL(PRODSEQ,'') AS PRODSEQ, \r\n");
                sql.append("  \tIFNULL(COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD, \r\n");
                sql.append("  \tIFNULL(COMPNO,'') AS COMPNO\r\n");
                sql.append("  FROM SHOPPRODINFO USE INDEX (INSERTDT_DESC) \r\n");
                sql.append(String.format(" WHERE COMPNO = %s \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                if (!dome.equals("")) {
                    sql.append(String.format(" AND GOODS_KEYWORD = '%s' \r\n", dome));
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append(String.format(" AND ((INSERTDT >= '%s' AND INSERTDT <= '%s') \r\n", prodFrom, prodTo));
                    sql.append(String.format(" OR (MODIFYDT >= '%s' AND MODIFYDT <= '%s' ))\r\n", prodFrom, prodTo));
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                sql.append(" ORDER BY INSERTDT DESC ) \r\n");
                sql.append("SELECT \r\n");
                sql.append(" IFNULL(A.PRODSEQ,'') AS PRODSEQ ,\r\n");
                sql.append(" IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n");
                sql.append(" IFNULL(GOODS_NM,'') AS GOODS_NM,\r\n");
                sql.append(" IFNULL(GOODS_KEYWORD,'' ) AS GOODS_KEYWORD,\r\n");
                sql.append(" IFNULL(MODEL_NM,'' ) AS MODEL_NM  ,\r\n");
                sql.append(" IFNULL(MODEL_NO,'' ) AS MODEL_NO  ,\r\n");
                sql.append(" IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n");
                sql.append(" IFNULL(A.COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD ,\r\n");
                sql.append(" IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n");
                sql.append(" IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n");
                sql.append(" IFNULL(SHOP_CID_INFO,'' ) AS SHOP_CID_INFO,  \r\n");
                sql.append(" IFNULL(SELECT_OPTION,'' ) AS SELECT_OPTION,  \r\n");
                sql.append(" IFNULL(TEXT_OPTION,'' ) AS TEXT_OPTION,  \r\n");
                sql.append(" IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n");
                sql.append(" IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n");
                sql.append(" IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n");
                sql.append(" IFNULL(CLASS_CD4,'' ) AS CLASS_CD4,\r\n");
                sql.append(" IFNULL(GMCATEGNM,'' ) AS GMCATEGNM,\r\n");
                sql.append(" IFNULL(PARTNER_ID,'' ) AS PARTNER_ID,  \r\n");
                sql.append(" IFNULL(DPARTNER_ID,'' ) AS DPARTNER_ID,  \r\n");
                sql.append(" IFNULL(MAKER,'' ) AS MAKER,  \r\n");
                sql.append(" IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n");
                sql.append(" IFNULL(MAKE_YEAR,'' ) AS MAKE_YEAR,  \r\n");
                sql.append(" IFNULL(MAKE_DM,'' ) AS MAKE_DM,  \r\n");
                sql.append(" IFNULL(GOODS_SEASON,'' ) AS GOODS_SEASON,  \r\n");
                sql.append(" IFNULL(SEX,'' ) AS SEX,  \r\n");
                sql.append(" IFNULL(STATUS,'' ) AS STATUS,  \r\n");
                sql.append(" IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n");
                sql.append(" IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n");
                sql.append(" IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n");
                sql.append(" IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n");
                sql.append(" IFNULL(RETURN_DELV_COST,'' ) AS RETURN_DELV_COST,  \r\n");
                sql.append(" IFNULL(DELV_QTY,'' ) AS DELV_QTY,  \r\n");
                sql.append(" IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n");
                sql.append(" IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n");
                sql.append(" IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n");
                sql.append(" IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n");
                sql.append(" IFNULL(ISLIMIT,'' ) AS ISLIMIT,  \r\n");
                sql.append(" IFNULL(LIMIT_PRICE,'' ) AS LIMIT_PRICE,  \r\n");
                sql.append(" IFNULL(IS_OVERSEAS,'' ) AS IS_OVERSEAS,  \r\n");
                sql.append(" IFNULL(ITYPE,'' ) AS ITYPE, \r\n");
                sql.append(" IFNULL(ADULT,'' ) AS ADULT, \r\n");
                sql.append(" IFNULL(ISRETURN,'' ) AS ISRETURN, \r\n");
                sql.append(" IFNULL(OPTIONYN,'' ) AS OPTIONYN, \r\n");
                sql.append(" IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n");
                sql.append(" IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n");
                sql.append(" IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n");
                sql.append(" IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n");
                sql.append(" IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n");
                sql.append(" IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n");
                sql.append(" IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n");
                sql.append(" IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n");
                sql.append(" IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n");
                sql.append(" IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n");
                sql.append(" IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n");
                sql.append(" IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n");
                sql.append(" IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n");
                sql.append(" IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n");
                sql.append(" IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n");
                sql.append(" IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n");
                sql.append(" IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n");
                sql.append(" IFNULL(IMG_PATH13,'' ) AS IMG_PATH13,  \r\n");
                sql.append(" IFNULL(IMG_PATH14,'' ) AS IMG_PATH14,  \r\n");
                sql.append(" IFNULL(IMG_PATH15,'' ) AS IMG_PATH15,  \r\n");
                sql.append(" IFNULL(IMG_PATH16,'' ) AS IMG_PATH16,  \r\n");
                sql.append(" IFNULL(IMG_PATH17,'' ) AS IMG_PATH17,  \r\n");
                sql.append(" IFNULL(IMG_PATH18,'' ) AS IMG_PATH18,  \r\n");
                sql.append(" IFNULL(IMG_PATH19,'' ) AS IMG_PATH19,  \r\n");
                sql.append(" IFNULL(IMG_PATH20,'' ) AS IMG_PATH20,  \r\n");
                sql.append(" IFNULL(IMG_PATH21,'' ) AS IMG_PATH21,  \r\n");
                sql.append(" IFNULL(IMG_PATH22,'' ) AS IMG_PATH22,  \r\n");
                sql.append(" IFNULL(IMG_PATH23,'' ) AS IMG_PATH23,  \r\n");
                sql.append(" IFNULL(IMG_PATH24,'' ) AS IMG_PATH24,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n");
                sql.append(" IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,   \r\n");
                sql.append(" IFNULL(CERT,'' ) AS CERT,   \r\n");
                sql.append(" IFNULL(CERTNO,'' ) AS CERTNO,  \r\n");
                sql.append(" IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n");
                sql.append(" IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n");
                sql.append(" IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n");
                sql.append(" IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n");
                sql.append(" IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n");
                sql.append(" IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n");
                sql.append(" IFNULL(CERTMODEL,'' ) AS CERTMODEL,  \r\n");
                sql.append(" IFNULL(CERTNAME,'' ) AS CERTNAME,  \r\n");
                sql.append(" IFNULL(EXEMPTIONTYPE,'' ) AS EXEMPTIONTYPE,  \r\n");
                sql.append(" IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n");
                sql.append(" IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n");
                sql.append(" IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n");
                sql.append(" IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n");
                sql.append(" IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n");
                sql.append(" IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n");
                sql.append(" IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n");
                sql.append(" IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n");
                sql.append(" IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n");
                sql.append(" IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n");
                sql.append(" IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n");
                sql.append(" IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n");
                sql.append(" IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n");
                sql.append(" IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n");
                sql.append(" IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n");
                sql.append(" IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n");
                sql.append(" IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n");
                sql.append(" IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n");
                sql.append(" IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n");
                sql.append(" IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n");
                sql.append(" IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n");
                sql.append(" IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n");
                sql.append(" IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n");
                sql.append(" IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n");
                sql.append(" IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n");
                sql.append(" IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n");
                sql.append(" IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n");
                sql.append(" IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n");
                sql.append(" IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n");
                sql.append(" IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n");
                sql.append(" IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n");
                sql.append(" IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n");
                sql.append(" IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n");
                sql.append(" IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n");
                sql.append(" IFNULL(GOODS_NM_EN,'' ) AS GOODS_NM_EN,  \r\n");
                sql.append(" IFNULL(GOODS_NM_PR,'' ) AS GOODS_NM_PR,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,  \r\n");
                sql.append(" IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n");
                sql.append(" IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n");
                sql.append(" IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n");
                sql.append(" IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n");
                sql.append(" IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n");
                sql.append(" IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n");
                sql.append(" IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n");
                sql.append(" IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n");
                sql.append(" IFNULL(INSERTID,'' ) AS INSERTID,  \r\n");
                sql.append(" IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n");
                sql.append(" IFNULL(MODIFYID, '' ) AS MODIFYID,  \r\n");
                sql.append(" IFNULL(SHOPSENDSTATUS, '' ) AS SHOPSENDSTATUS, \r\n");
                sql.append(" IFNULL(SHOPMODIFYCONTENT, '') AS SHOPMODIFYCONTENT, \r\n");
                sql.append(" IFNULL(SELFMOD_NO, '' ) AS SELFMOD_NO \r\n");
                sql.append(" FROM SHOPPRODINFO AS A INNER JOIN ");
                sql.append("(SELECT * FROM CTE_PRODLIST) AS B ");
                sql.append("ON A.COMPNO = B.COMPNO AND A.PRODSEQ = B.PRODSEQ \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                YDMAStringUtil.Print("[getNewShopProductInfoForUpdate]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setShop_cid_info(rs.getString("SHOP_CID_INFO"));
                    dto.setSelect_option(rs.getString("SELECT_OPTION"));
                    dto.setText_option(rs.getString("TEXT_OPTION"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setGmcategnm(rs.getString("GMCATEGNM"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year(rs.getString("MAKE_YEAR"));
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season(rs.getString("GOODS_SEASON"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelv_r_cost(rs.getString("RETURN_DELV_COST"));
                    dto.setDelv_qty(rs.getString("DELV_QTY"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setIslimit(rs.getString("ISLIMIT"));
                    dto.setLimit_price(rs.getString("LIMIT_PRICE"));
                    dto.setIs_overseas(rs.getString("IS_OVERSEAS"));
                    dto.setAdult(rs.getString("ADULT"));
                    dto.setIsreturn(rs.getString("ISRETURN"));
                    dto.setItype(rs.getString("ITYPE"));
                    dto.setOptionYN(rs.getString("OPTIONYN"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCert(rs.getString("CERT"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setCertmodel(rs.getString("CERTMODEL"));
                    dto.setCertname(rs.getString("CERTNAME"));
                    dto.setExemptiontype(rs.getString("EXEMPTIONTYPE"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setSendstats(rs.getString("SHOPSENDSTATUS"));
                    dto.setShopmodifycontent(rs.getString("SHOPMODIFYCONTENT"));
                    dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ProductDTO> getShopProductInfoForUpdate(Map<String, String> parameters, int block, int page) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql1;
                List<String> nameList;
                String[] searchtxt;
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                int block_data = block * (page - 1);
                sql.append("WITH CTE_PRODLIST AS( \r\n");
                sql.append(" SELECT \r\n");
                sql.append("  \tIFNULL(PRODSEQ,'') AS PRODSEQ, \r\n");
                sql.append("  \tIFNULL(COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD, \r\n");
                sql.append("  \tIFNULL(COMPNO,'') AS COMPNO\r\n");
                sql.append("  FROM SHOPPRODINFO USE INDEX (INSERTDT_DESC) \r\n");
                sql.append(String.format(" WHERE COMPNO = %s \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                if (!parameters.get("dome").equals("")) {
                    sql.append(String.format(" AND GOODS_KEYWORD = '%s' \r\n", parameters.get("dome")));
                }
                sql.append(String.format(" AND INSERTDT >= '%s' \r\n", parameters.get("start_date")));
                sql.append(String.format(" AND INSERTDT <= '%s' \r\n", parameters.get("end_date")));
                if (!parameters.get("cid_arr").equals("")) {
                    searchtxt = parameters.get("cid_arr").replace(" ", ",").replace("\n", ",").split(",");
                    nameList = Arrays.asList(searchtxt);
                    sql1 = nameList.stream().map(name -> name).collect(Collectors.joining("|^"));
                    if (parameters.get("cid_type").equals("0")) {
                        sql.append(" AND REGEXP_LIKE(CLASS_CD3,'^" + sql1 + "')\r\n");
                    } else {
                        sql.append(" AND (CLASS_CD1 not in (" + sql1 + ") or CLASS_CD2 not in (" + sql1 + ") or CLASS_CD3 not in (" + sql1 + "))\r\n");
                    }
                }
                if (!parameters.get("min_amount").equals("0")) {
                    sql.append(String.format(" AND GOODS_COST >= %s \r\n", parameters.get("min_amount")));
                }
                if (!parameters.get("max_amount").equals("0")) {
                    sql.append(String.format(" AND GOODS_COST <= %s \r\n", parameters.get("max_amount")));
                }
                if (!parameters.get("vender_m_code").equals("")) {
                    searchtxt = parameters.get("vender_m_code").replace(" ", ",").replace("\n", ",").split(",");
                    nameList = Arrays.asList(searchtxt);
                    sql1 = nameList.stream().map(name -> "'" + name + "'").collect(Collectors.joining(","));
                    if (parameters.get("vender_m_code_type").equals("0")) {
                        sql.append(" AND PARTNER_ID in (" + sql1 + ") \r\n");
                    } else {
                        sql.append(" AND PARTNER_ID not in (" + sql1 + ") \r\n");
                    }
                }
                if (!parameters.get("icode_arr").equals("")) {
                    searchtxt = parameters.get("icode_arr").replace(" ", ",").replace("\n", ",").split(",");
                    nameList = Arrays.asList(searchtxt);
                    sql1 = nameList.stream().map(name -> "'" + name + "'").collect(Collectors.joining(","));
                    if (parameters.get("icode_type").equals("0")) {
                        sql.append(String.format(" AND COMPAYNY_GOODS_CD IN (%s) \r\n", sql1));
                    } else {
                        sql.append(String.format(" AND COMPAYNY_GOODS_CD not IN (%s) \r\n", sql1));
                    }
                }
                if (!parameters.get("q").equals("")) {
                    searchtxt = parameters.get("q").replace(" ", ",").replace("\n", ",").split(",");
                    nameList = Arrays.asList(searchtxt);
                    sql1 = nameList.stream().map(name -> "'" + name + "'").collect(Collectors.joining(","));
                    sql.append(" AND (GOODS_SEARCH in (" + sql1 + ") OR GOODS_NM in (" + sql1 + "))\r\n");
                }
                if (!parameters.get("is_overseas").equals("")) {
                    sql.append(String.format(" AND IS_OVERSEAS = '%s' \r\n", parameters.get("is_overseas")));
                }
                if (!parameters.get("is_tax").equals("")) {
                    sql.append(String.format(" AND TAX_YN = '%s' \r\n", parameters.get("is_tax")));
                }
                if (!parameters.get("isreturn").equals("")) {
                    sql.append(String.format(" AND ISRETURN = '%s' \r\n", parameters.get("isreturn")));
                }
                if (!parameters.get("islimit").equals("")) {
                    sql.append(String.format(" AND ISLIMIT = '%s' \r\n", parameters.get("islimit")));
                }
                if (!parameters.get("delivery_type").equals("")) {
                    sql.append(String.format(" AND DELV_TYPE = '%s' \r\n", parameters.get("delivery_type")));
                }
                if (!parameters.get("list_option_use").equals("")) {
                    sql.append(String.format(" AND OPTIONYN = '%s' \r\n", parameters.get("list_option_use")));
                }
                if (!parameters.get("adult").equals("")) {
                    sql.append(String.format(" AND ADULT = '%s' \r\n", parameters.get("adult")));
                }
                if (!parameters.get("status").equals("")) {
                    sql.append(String.format(" AND STATUS = '%s' ", parameters.get("status")));
                }
                sql.append(String.format(" LIMIT %s,%s  ) \r\n", block_data, block));
                sql.append("SELECT \r\n");
                sql.append(" IFNULL(A.PRODSEQ,'') AS PRODSEQ ,\r\n");
                sql.append(" IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n");
                sql.append(" IFNULL(GOODS_NM,'') AS GOODS_NM,\r\n");
                sql.append(" IFNULL(GOODS_KEYWORD,'' ) AS GOODS_KEYWORD,\r\n");
                sql.append(" IFNULL(MODEL_NM,'' ) AS MODEL_NM  ,\r\n");
                sql.append(" IFNULL(MODEL_NO,'' ) AS MODEL_NO  ,\r\n");
                sql.append(" IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n");
                sql.append(" IFNULL(A.COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD ,\r\n");
                sql.append(" IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n");
                sql.append(" IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n");
                sql.append(" IFNULL(SHOP_CID_INFO,'' ) AS SHOP_CID_INFO,  \r\n");
                sql.append(" IFNULL(SELECT_OPTION,'' ) AS SELECT_OPTION,  \r\n");
                sql.append(" IFNULL(TEXT_OPTION,'' ) AS TEXT_OPTION,  \r\n");
                sql.append(" IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n");
                sql.append(" IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n");
                sql.append(" IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n");
                sql.append(" IFNULL(CLASS_CD4,'' ) AS CLASS_CD4,\r\n");
                sql.append(" IFNULL(GMCATEGNM,'' ) AS GMCATEGNM,\r\n");
                sql.append(" IFNULL(PARTNER_ID,'' ) AS PARTNER_ID,  \r\n");
                sql.append(" IFNULL(DPARTNER_ID,'' ) AS DPARTNER_ID,  \r\n");
                sql.append(" IFNULL(MAKER,'' ) AS MAKER,  \r\n");
                sql.append(" IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n");
                sql.append(" IFNULL(MAKE_YEAR,'' ) AS MAKE_YEAR,  \r\n");
                sql.append(" IFNULL(MAKE_DM,'' ) AS MAKE_DM,  \r\n");
                sql.append(" IFNULL(GOODS_SEASON,'' ) AS GOODS_SEASON,  \r\n");
                sql.append(" IFNULL(SEX,'' ) AS SEX,  \r\n");
                sql.append(" IFNULL(STATUS,'' ) AS STATUS,  \r\n");
                sql.append(" IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n");
                sql.append(" IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n");
                sql.append(" IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n");
                sql.append(" IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n");
                sql.append(" IFNULL(RETURN_DELV_COST,'' ) AS RETURN_DELV_COST,  \r\n");
                sql.append(" IFNULL(DELV_QTY,'' ) AS DELV_QTY,  \r\n");
                sql.append(" IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n");
                sql.append(" IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n");
                sql.append(" IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n");
                sql.append(" IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n");
                sql.append(" IFNULL(ISLIMIT,'' ) AS ISLIMIT,  \r\n");
                sql.append(" IFNULL(LIMIT_PRICE,'' ) AS LIMIT_PRICE,  \r\n");
                sql.append(" IFNULL(IS_OVERSEAS,'' ) AS IS_OVERSEAS,  \r\n");
                sql.append(" IFNULL(ITYPE,'' ) AS ITYPE, \r\n");
                sql.append(" IFNULL(ADULT,'' ) AS ADULT, \r\n");
                sql.append(" IFNULL(ISRETURN,'' ) AS ISRETURN, \r\n");
                sql.append(" IFNULL(OPTIONYN,'' ) AS OPTIONYN, \r\n");
                sql.append(" IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n");
                sql.append(" IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n");
                sql.append(" IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n");
                sql.append(" IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n");
                sql.append(" IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n");
                sql.append(" IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n");
                sql.append(" IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n");
                sql.append(" IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n");
                sql.append(" IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n");
                sql.append(" IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n");
                sql.append(" IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n");
                sql.append(" IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n");
                sql.append(" IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n");
                sql.append(" IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n");
                sql.append(" IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n");
                sql.append(" IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n");
                sql.append(" IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n");
                sql.append(" IFNULL(IMG_PATH13,'' ) AS IMG_PATH13,  \r\n");
                sql.append(" IFNULL(IMG_PATH14,'' ) AS IMG_PATH14,  \r\n");
                sql.append(" IFNULL(IMG_PATH15,'' ) AS IMG_PATH15,  \r\n");
                sql.append(" IFNULL(IMG_PATH16,'' ) AS IMG_PATH16,  \r\n");
                sql.append(" IFNULL(IMG_PATH17,'' ) AS IMG_PATH17,  \r\n");
                sql.append(" IFNULL(IMG_PATH18,'' ) AS IMG_PATH18,  \r\n");
                sql.append(" IFNULL(IMG_PATH19,'' ) AS IMG_PATH19,  \r\n");
                sql.append(" IFNULL(IMG_PATH20,'' ) AS IMG_PATH20,  \r\n");
                sql.append(" IFNULL(IMG_PATH21,'' ) AS IMG_PATH21,  \r\n");
                sql.append(" IFNULL(IMG_PATH22,'' ) AS IMG_PATH22,  \r\n");
                sql.append(" IFNULL(IMG_PATH23,'' ) AS IMG_PATH23,  \r\n");
                sql.append(" IFNULL(IMG_PATH24,'' ) AS IMG_PATH24,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n");
                sql.append(" IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,   \r\n");
                sql.append(" IFNULL(CERT,'' ) AS CERT,   \r\n");
                sql.append(" IFNULL(CERTNO,'' ) AS CERTNO,  \r\n");
                sql.append(" IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n");
                sql.append(" IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n");
                sql.append(" IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n");
                sql.append(" IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n");
                sql.append(" IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n");
                sql.append(" IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n");
                sql.append(" IFNULL(CERTMODEL,'' ) AS CERTMODEL,  \r\n");
                sql.append(" IFNULL(CERTNAME,'' ) AS CERTNAME,  \r\n");
                sql.append(" IFNULL(EXEMPTIONTYPE,'' ) AS EXEMPTIONTYPE,  \r\n");
                sql.append(" IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n");
                sql.append(" IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n");
                sql.append(" IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n");
                sql.append(" IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n");
                sql.append(" IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n");
                sql.append(" IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n");
                sql.append(" IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n");
                sql.append(" IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n");
                sql.append(" IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n");
                sql.append(" IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n");
                sql.append(" IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n");
                sql.append(" IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n");
                sql.append(" IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n");
                sql.append(" IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n");
                sql.append(" IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n");
                sql.append(" IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n");
                sql.append(" IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n");
                sql.append(" IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n");
                sql.append(" IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n");
                sql.append(" IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n");
                sql.append(" IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n");
                sql.append(" IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n");
                sql.append(" IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n");
                sql.append(" IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n");
                sql.append(" IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n");
                sql.append(" IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n");
                sql.append(" IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n");
                sql.append(" IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n");
                sql.append(" IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n");
                sql.append(" IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n");
                sql.append(" IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n");
                sql.append(" IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n");
                sql.append(" IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n");
                sql.append(" IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n");
                sql.append(" IFNULL(GOODS_NM_EN,'' ) AS GOODS_NM_EN,  \r\n");
                sql.append(" IFNULL(GOODS_NM_PR,'' ) AS GOODS_NM_PR,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,  \r\n");
                sql.append(" IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n");
                sql.append(" IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n");
                sql.append(" IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n");
                sql.append(" IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n");
                sql.append(" IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n");
                sql.append(" IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n");
                sql.append(" IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n");
                sql.append(" IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n");
                sql.append(" IFNULL(INSERTID,'' ) AS INSERTID,  \r\n");
                sql.append(" IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n");
                sql.append(" IFNULL(MODIFYID, '' ) AS MODIFYID,  \r\n");
                sql.append(" IFNULL(SHOPSENDSTATUS, '' ) AS SHOPSENDSTATUS, \r\n");
                sql.append(" IFNULL(SHOPMODIFYCONTENT, '') AS SHOPMODIFYCONTENT, \r\n");
                sql.append(" IFNULL(SELFMOD_NO, '' ) AS SELFMOD_NO \r\n");
                sql.append(" FROM SHOPPRODINFO AS A INNER JOIN ");
                sql.append("(SELECT * FROM CTE_PRODLIST) AS B ");
                sql.append("ON A.COMPNO = B.COMPNO AND A.PRODSEQ = B.PRODSEQ \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                YDMAStringUtil.Print("[getShopProductInfoForUpdate]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setShop_cid_info(rs.getString("SHOP_CID_INFO"));
                    dto.setSelect_option(rs.getString("SELECT_OPTION"));
                    dto.setText_option(rs.getString("TEXT_OPTION"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setGmcategnm(rs.getString("GMCATEGNM"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year(rs.getString("MAKE_YEAR"));
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season(rs.getString("GOODS_SEASON"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelv_r_cost(rs.getString("RETURN_DELV_COST"));
                    dto.setDelv_qty(rs.getString("DELV_QTY"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setIslimit(rs.getString("ISLIMIT"));
                    dto.setLimit_price(rs.getString("LIMIT_PRICE"));
                    dto.setIs_overseas(rs.getString("IS_OVERSEAS"));
                    dto.setAdult(rs.getString("ADULT"));
                    dto.setIsreturn(rs.getString("ISRETURN"));
                    dto.setItype(rs.getString("ITYPE"));
                    dto.setOptionYN(rs.getString("OPTIONYN"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCert(rs.getString("CERT"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setCertmodel(rs.getString("CERTMODEL"));
                    dto.setCertname(rs.getString("CERTNAME"));
                    dto.setExemptiontype(rs.getString("EXEMPTIONTYPE"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setSendstats(rs.getString("SHOPSENDSTATUS"));
                    dto.setShopmodifycontent(rs.getString("SHOPMODIFYCONTENT"));
                    dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public ProductDTO getShopProductInfoItem(String dome, String icode) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ProductDTO list = new ProductDTO();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("WITH CTE_PRODLIST AS( \r\n");
                sql.append(" SELECT \r\n");
                sql.append("  \tIFNULL(PRODSEQ,'') AS PRODSEQ, \r\n");
                sql.append("  \tIFNULL(COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD, \r\n");
                sql.append("  \tIFNULL(COMPNO,'') AS COMPNO\r\n");
                sql.append("  FROM SHOPPRODINFO  \r\n");
                sql.append(String.format(" WHERE COMPNO = %s \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                if (!dome.equals("")) {
                    sql.append(String.format(" AND GOODS_KEYWORD = '%s' \r\n", dome));
                }
                sql.append(String.format(" AND COMPAYNY_GOODS_CD ='%s' ) \r\n", icode));
                sql.append("SELECT \r\n");
                sql.append(" IFNULL(A.PRODSEQ,'') AS PRODSEQ ,\r\n");
                sql.append(" IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n");
                sql.append(" IFNULL(GOODS_NM,'') AS GOODS_NM,\r\n");
                sql.append(" IFNULL(GOODS_KEYWORD,'' ) AS GOODS_KEYWORD,\r\n");
                sql.append(" IFNULL(MODEL_NM,'' ) AS MODEL_NM  ,\r\n");
                sql.append(" IFNULL(MODEL_NO,'' ) AS MODEL_NO  ,\r\n");
                sql.append(" IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n");
                sql.append(" IFNULL(A.COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD ,\r\n");
                sql.append(" IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n");
                sql.append(" IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n");
                sql.append(" IFNULL(SHOP_CID_INFO,'' ) AS SHOP_CID_INFO,  \r\n");
                sql.append(" IFNULL(SELECT_OPTION,'' ) AS SELECT_OPTION,  \r\n");
                sql.append(" IFNULL(TEXT_OPTION,'' ) AS TEXT_OPTION,  \r\n");
                sql.append(" IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n");
                sql.append(" IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n");
                sql.append(" IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n");
                sql.append(" IFNULL(CLASS_CD4,'' ) AS CLASS_CD4,\r\n");
                sql.append(" IFNULL(GMCATEGNM,'' ) AS GMCATEGNM,\r\n");
                sql.append(" IFNULL(PARTNER_ID,'' ) AS PARTNER_ID,  \r\n");
                sql.append(" IFNULL(DPARTNER_ID,'' ) AS DPARTNER_ID,  \r\n");
                sql.append(" IFNULL(MAKER,'' ) AS MAKER,  \r\n");
                sql.append(" IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n");
                sql.append(" IFNULL(MAKE_YEAR,'' ) AS MAKE_YEAR,  \r\n");
                sql.append(" IFNULL(MAKE_DM,'' ) AS MAKE_DM,  \r\n");
                sql.append(" IFNULL(GOODS_SEASON,'' ) AS GOODS_SEASON,  \r\n");
                sql.append(" IFNULL(SEX,'' ) AS SEX,  \r\n");
                sql.append(" IFNULL(STATUS,'' ) AS STATUS,  \r\n");
                sql.append(" IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n");
                sql.append(" IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n");
                sql.append(" IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n");
                sql.append(" IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n");
                sql.append(" IFNULL(DELV_QTY,'' ) AS DELV_QTY,  \r\n");
                sql.append(" IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n");
                sql.append(" IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n");
                sql.append(" IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n");
                sql.append(" IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n");
                sql.append(" IFNULL(ISLIMIT,'' ) AS ISLIMIT,  \r\n");
                sql.append(" IFNULL(LIMIT_PRICE,'' ) AS LIMIT_PRICE,  \r\n");
                sql.append(" IFNULL(IS_OVERSEAS,'' ) AS IS_OVERSEAS,  \r\n");
                sql.append(" IFNULL(ITYPE,'' ) AS ITYPE, \r\n");
                sql.append(" IFNULL(ADULT,'' ) AS ADULT, \r\n");
                sql.append(" IFNULL(ISRETURN,'' ) AS ISRETURN, \r\n");
                sql.append(" IFNULL(OPTIONYN,'' ) AS OPTIONYN, \r\n");
                sql.append(" IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n");
                sql.append(" IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n");
                sql.append(" IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n");
                sql.append(" IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n");
                sql.append(" IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n");
                sql.append(" IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n");
                sql.append(" IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n");
                sql.append(" IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n");
                sql.append(" IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n");
                sql.append(" IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n");
                sql.append(" IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n");
                sql.append(" IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n");
                sql.append(" IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n");
                sql.append(" IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n");
                sql.append(" IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n");
                sql.append(" IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n");
                sql.append(" IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n");
                sql.append(" IFNULL(IMG_PATH13,'' ) AS IMG_PATH13,  \r\n");
                sql.append(" IFNULL(IMG_PATH14,'' ) AS IMG_PATH14,  \r\n");
                sql.append(" IFNULL(IMG_PATH15,'' ) AS IMG_PATH15,  \r\n");
                sql.append(" IFNULL(IMG_PATH16,'' ) AS IMG_PATH16,  \r\n");
                sql.append(" IFNULL(IMG_PATH17,'' ) AS IMG_PATH17,  \r\n");
                sql.append(" IFNULL(IMG_PATH18,'' ) AS IMG_PATH18,  \r\n");
                sql.append(" IFNULL(IMG_PATH19,'' ) AS IMG_PATH19,  \r\n");
                sql.append(" IFNULL(IMG_PATH20,'' ) AS IMG_PATH20,  \r\n");
                sql.append(" IFNULL(IMG_PATH21,'' ) AS IMG_PATH21,  \r\n");
                sql.append(" IFNULL(IMG_PATH22,'' ) AS IMG_PATH22,  \r\n");
                sql.append(" IFNULL(IMG_PATH23,'' ) AS IMG_PATH23,  \r\n");
                sql.append(" IFNULL(IMG_PATH24,'' ) AS IMG_PATH24,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n");
                sql.append(" IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,   \r\n");
                sql.append(" IFNULL(CERT,'' ) AS CERT,   \r\n");
                sql.append(" IFNULL(CERTNO,'' ) AS CERTNO,  \r\n");
                sql.append(" IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n");
                sql.append(" IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n");
                sql.append(" IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n");
                sql.append(" IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n");
                sql.append(" IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n");
                sql.append(" IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n");
                sql.append(" IFNULL(CERTMODEL,'' ) AS CERTMODEL,  \r\n");
                sql.append(" IFNULL(CERTNAME,'' ) AS CERTNAME,  \r\n");
                sql.append(" IFNULL(EXEMPTIONTYPE,'' ) AS EXEMPTIONTYPE,  \r\n");
                sql.append(" IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n");
                sql.append(" IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n");
                sql.append(" IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n");
                sql.append(" IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n");
                sql.append(" IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n");
                sql.append(" IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n");
                sql.append(" IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n");
                sql.append(" IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n");
                sql.append(" IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n");
                sql.append(" IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n");
                sql.append(" IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n");
                sql.append(" IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n");
                sql.append(" IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n");
                sql.append(" IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n");
                sql.append(" IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n");
                sql.append(" IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n");
                sql.append(" IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n");
                sql.append(" IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n");
                sql.append(" IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n");
                sql.append(" IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n");
                sql.append(" IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n");
                sql.append(" IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n");
                sql.append(" IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n");
                sql.append(" IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n");
                sql.append(" IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n");
                sql.append(" IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n");
                sql.append(" IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n");
                sql.append(" IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n");
                sql.append(" IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n");
                sql.append(" IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n");
                sql.append(" IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n");
                sql.append(" IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n");
                sql.append(" IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n");
                sql.append(" IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n");
                sql.append(" IFNULL(GOODS_NM_EN,'' ) AS GOODS_NM_EN,  \r\n");
                sql.append(" IFNULL(GOODS_NM_PR,'' ) AS GOODS_NM_PR,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,  \r\n");
                sql.append(" IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n");
                sql.append(" IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n");
                sql.append(" IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n");
                sql.append(" IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n");
                sql.append(" IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n");
                sql.append(" IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n");
                sql.append(" IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n");
                sql.append(" IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n");
                sql.append(" IFNULL(INSERTID,'' ) AS INSERTID,  \r\n");
                sql.append(" IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n");
                sql.append(" IFNULL(MODIFYID, '' ) AS MODIFYID,  \r\n");
                sql.append(" IFNULL(SHOPSENDSTATUS, '' ) AS SHOPSENDSTATUS, \r\n");
                sql.append(" IFNULL(SHOPMODIFYCONTENT, '') AS SHOPMODIFYCONTENT, \r\n");
                sql.append(" IFNULL(SELFMOD_NO, '' ) AS SELFMOD_NO \r\n");
                sql.append(" FROM SHOPPRODINFO AS A INNER JOIN ");
                sql.append("(SELECT * FROM CTE_PRODLIST) AS B ");
                sql.append("ON A.COMPNO = B.COMPNO AND A.PRODSEQ = B.PRODSEQ \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                YDMAStringUtil.Print("[getShopProductInfoItem]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setShop_cid_info(rs.getString("SHOP_CID_INFO"));
                    dto.setSelect_option(rs.getString("SELECT_OPTION"));
                    dto.setText_option(rs.getString("TEXT_OPTION"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setGmcategnm(rs.getString("GMCATEGNM"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year(rs.getString("MAKE_YEAR"));
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season(rs.getString("GOODS_SEASON"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setDelv_qty(rs.getString("DELV_QTY"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setIslimit(rs.getString("ISLIMIT"));
                    dto.setLimit_price(rs.getString("LIMIT_PRICE"));
                    dto.setIs_overseas(rs.getString("IS_OVERSEAS"));
                    dto.setAdult(rs.getString("ADULT"));
                    dto.setIsreturn(rs.getString("ISRETURN"));
                    dto.setItype(rs.getString("ITYPE"));
                    dto.setOptionYN(rs.getString("OPTIONYN"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCert(rs.getString("CERT"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setCertmodel(rs.getString("CERTMODEL"));
                    dto.setCertname(rs.getString("CERTNAME"));
                    dto.setExemptiontype(rs.getString("EXEMPTIONTYPE"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setSendstats(rs.getString("SHOPSENDSTATUS"));
                    dto.setShopmodifycontent(rs.getString("SHOPMODIFYCONTENT"));
                    dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                    list = dto;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ProductDTO> getShopProductInfoList(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo, int block, int page, String cmdID, String shopCd, String shopSeq, int shopsendstatus) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" SELECT \r\n");
                sql.append("  \tIFNULL(PRODSEQ,'') AS PRODSEQ, \r\n");
                sql.append("  \tIFNULL(COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD, \r\n");
                sql.append("  \tIFNULL(COMPNO,'') AS COMPNO\r\n");
                sql.append("  FROM SHOPPRODINFO AS A  \r\n");
                sql.append(" WHERE COMPNO = ? \r\n");
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append(" AND ((INSERTDT >= ? AND INSERTDT <= ?) \r\n");
                    sql.append(" OR (MODIFYDT >= ? AND MODIFYDT <= ? ))\r\n");
                }
                if (!searchtxt.equals("")) {
                    if (searchgubun.equals("GOODS_COST") || searchgubun.equals("DESCRITION")) {
                        String searchtxt1 = "";
                        if (searchtxt.contains("<")) {
                            String[] seartxt2 = searchtxt.split("<");
                            if (seartxt2.length == 2) {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + " BETWEEN " + seartxt2[0] + " AND " + seartxt2[1] + "\r\n");
                            } else {
                                searchtxt1 = searchtxt.replaceAll("<", "");
                                sql.append(" AND " + searchgubun + ">=" + searchtxt1 + "\r\n");
                            }
                        } else if (searchtxt.contains("=")) {
                            searchtxt1 = searchtxt.replaceAll("=", "");
                            sql.append(" AND " + searchgubun + "=" + searchtxt1 + "\r\n");
                        } else if (searchtxt.contains(">")) {
                            searchtxt1 = searchtxt.replaceAll(">", "");
                            sql.append(" AND " + searchgubun + "<=" + searchtxt1 + "\r\n");
                        }
                    } else if (searchgubun.equals("GOODS_SEARCH_CNT")) {
                        sql.append(" AND (LENGTH(GOODS_SEARCH)-LENGTH(REPLACE(GOODS_SEARCH, ',', ''))) < " + searchtxt + "\r\n");
                    } else {
                        searchtxt = searchtxt.replace(",", "+|");
                        sql.append(" AND " + searchgubun + " REGEXP ('" + searchtxt + "+') \r\n");
                    }
                }
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getShopProductInfoList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public ProductDTO getShopProductInfo1(String compayny_goods_cd, String compno) throws Exception {
        compno = YDMASessonUtil.getCompnoInfo().getCompno();
        ProductDTO dto = new ProductDTO();
        new ArrayList();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append(" WITH CateAll AS(                                                                 \r\n");
                sql.append("\t\tSELECT                                                                    \r\n");
                sql.append("\t\t   ifnull(a.CODE,'')     AS CLASS_CD1 ,                                   \r\n");
                sql.append("\t\t\tifnull(a.CATEGORY,'') AS CLASS_NM1 ,                                  \r\n");
                sql.append("\t\t\tIFNULL(RIGHT(b.CODE,3),'')     AS CLASS_CD2  ,                        \r\n");
                sql.append("\t\t\tifnull(b.CATEGORY,'') AS CLASS_NM2 ,                                  \r\n");
                sql.append("\t\t\tifnull(RIGHT(c.CODE,3),'')     AS CLASS_CD3,                          \r\n");
                sql.append("\t\t\tifnull(C.CATEGORY,'') AS CLASS_NM3,                                   \r\n");
                sql.append("\t\t\tifnull(RIGHT(D.CODE,3),'')     AS CLASS_CD4 ,                         \r\n");
                sql.append("\t\t\tifnull(D.CATEGORY,'') AS CLASS_NM4                                    \r\n");
                sql.append("\t\tFROM CATEGLARGE a left JOIN CATEGMIDIUM b                                      \r\n");
                sql.append("\t\t\tON a.COMPNO=b.COMPNO AND a.CODE = b.LRGCODE left JOIN CATEGSMALL C         \r\n");
                sql.append("\t\t\tON a.COMPNO = C.COMPNO AND b.CODE = C.MIDCODE left JOIN CATEGDETAIL D ON   \r\n");
                sql.append(String.format(" a.COMPNO = D.COMPNO AND C.CODE = D.SMLCODE WHERE a.compno = '%s'         \r\n", YDMASessonUtil.getCompnoInfo().getCompno()));
                sql.append("\t\t )                                                                        \r\n");
                sql.append(" SELECT INFO.*  , \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM1, '')  CLASS_NM1, \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM2, '')  CLASS_NM2, \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM3, '')  CLASS_NM3, \r\n");
                sql.append(" IFNULL(CATE.CLASS_NM4, '')  CLASS_NM4, \r\n");
                sql.append("(CASE                                   \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '1'         \r\n");
                sql.append("\t     THEN '\uc704\ud0c1\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '2'         \r\n");
                sql.append("\t     THEN '\uc81c\uc870\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '3'         \r\n");
                sql.append("\t     THEN '\uc0ac\uc5c5\uc0c1\ud488'                \r\n");
                sql.append("\t     WHEN GOODS_GUBUN = '4'         \r\n");
                sql.append("\t     THEN '\uc9c1\uc601\uc0c1\ud488'                \r\n");
                sql.append("\t     ELSE ''                        \r\n");
                sql.append("\t  END )AS GOODS_GUBUN_NM,            \r\n");
                sql.append("(CASE                            \r\n");
                sql.append("\t     WHEN STATUS = '1'       \r\n");
                sql.append("\t     THEN '\ub300\uae30\uc911'           \r\n");
                sql.append("\t     WHEN STATUS = '2'       \r\n");
                sql.append("\t     THEN '\uacf5\uae09\uc911'           \r\n");
                sql.append("\t     WHEN STATUS = '3'       \r\n");
                sql.append("\t     THEN '\uc77c\uc2dc\uc911\uc9c0'         \r\n");
                sql.append("\t     WHEN STATUS = '4'       \r\n");
                sql.append("\t     THEN '\uc644\uc804\ud488\uc808'         \r\n");
                sql.append("\t      WHEN STATUS = '5'      \r\n");
                sql.append("\t     THEN '\ubbf8\uc0ac\uc6a9'           \r\n");
                sql.append("\t      WHEN STATUS = '6'      \r\n");
                sql.append("\t     THEN '\uc0ad\uc81c'             \r\n");
                sql.append("\t     ELSE ''                 \r\n");
                sql.append("\t  END )AS STATUS_NM,         \r\n");
                sql.append("(CASE                             \r\n");
                sql.append("\t     WHEN DELV_TYPE = '1'     \r\n");
                sql.append("\t     THEN '\ubb34\ub8cc'              \r\n");
                sql.append("\t     WHEN DELV_TYPE = '2'     \r\n");
                sql.append("\t     THEN '\ucc29\ubd88'              \r\n");
                sql.append("\t     WHEN DELV_TYPE = '3'     \r\n");
                sql.append("\t     THEN '\uc120\uacb0\uc81c'            \r\n");
                sql.append("\t     WHEN DELV_TYPE = '4'     \r\n");
                sql.append("\t     THEN '\ucc29\ubd88/\uc120\uacb0\uc81c'       \r\n");
                sql.append("\t     ELSE ''                  \r\n");
                sql.append("\t  END )AS DELV_TYPE_NM       \r\n");
                sql.append(" FROM                             \r\n");
                sql.append(" (SELECT                           \r\n");
                sql.append(" CONCAT(IFNULL(CLASS_CD1,''), IFNULL(CLASS_CD2,''), IFNULL(CLASS_CD3,''), IFNULL(CLASS_CD4,'')) AS CODE, \r\n");
                sql.append("IFNULL(PRODSEQ,'' ) AS PRODSEQ,  \r\n ");
                sql.append("IFNULL(COMPNO,'' ) AS COMPNO,  \r\n ");
                sql.append(" '' as img, ");
                sql.append("IFNULL(GOODS_NM,'' ) AS GOODS_NM,  \r\n ");
                sql.append("IFNULL(GOODS_KEYWORD,'' ) AS GOODS_KEYWORD,  \r\n ");
                sql.append("IFNULL(MODEL_NM,'' ) AS MODEL_NM,  \r\n ");
                sql.append("IFNULL(MODEL_NO,'' ) AS MODEL_NO,  \r\n ");
                sql.append("IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n ");
                sql.append("IFNULL(COMPAYNY_GOODS_CD,'' ) AS COMPAYNY_GOODS_CD,  \r\n ");
                sql.append("IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n ");
                sql.append("IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n ");
                sql.append("IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n ");
                sql.append("IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n ");
                sql.append("IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n ");
                sql.append("IFNULL(CLASS_CD4,'' ) AS CLASS_CD4,  \r\n ");
                sql.append("IFNULL(PARTNER_ID,'' ) AS PARTNER_ID,  \r\n ");
                sql.append("IFNULL(DPARTNER_ID,'' ) AS DPARTNER_ID,  \r\n ");
                sql.append("IFNULL(MAKER,'' ) AS MAKER,  \r\n ");
                sql.append("IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n ");
                sql.append("IFNULL(MAKE_YEAR,'' ) AS MAKE_YEAR,  \r\n ");
                sql.append("IFNULL(MAKE_DM,'' ) AS MAKE_DM,  \r\n ");
                sql.append("IFNULL(GOODS_SEASON,'' ) AS GOODS_SEASON,  \r\n ");
                sql.append("IFNULL(SEX,'' ) AS SEX,  \r\n ");
                sql.append("IFNULL(STATUS,'' ) AS STATUS,  \r\n ");
                sql.append("IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n ");
                sql.append("IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n ");
                sql.append("IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n ");
                sql.append("IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n ");
                sql.append("IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n ");
                sql.append("IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n ");
                sql.append("IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n ");
                sql.append("IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n ");
                sql.append("IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n ");
                sql.append("IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n ");
                sql.append("IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n ");
                sql.append("IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n ");
                sql.append("IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n ");
                sql.append("IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n ");
                sql.append("IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n ");
                sql.append("IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n ");
                sql.append("IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n ");
                sql.append("IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n ");
                sql.append("IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n ");
                sql.append("IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n ");
                sql.append("IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n ");
                sql.append("IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n ");
                sql.append("IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n ");
                sql.append("IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n ");
                sql.append("IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n ");
                sql.append("IFNULL(IMG_PATH13,'' ) AS IMG_PATH13,  \r\n ");
                sql.append("IFNULL(IMG_PATH14,'' ) AS IMG_PATH14,  \r\n ");
                sql.append("IFNULL(IMG_PATH15,'' ) AS IMG_PATH15,  \r\n ");
                sql.append("IFNULL(IMG_PATH16,'' ) AS IMG_PATH16,  \r\n ");
                sql.append("IFNULL(IMG_PATH17,'' ) AS IMG_PATH17,  \r\n ");
                sql.append("IFNULL(IMG_PATH18,'' ) AS IMG_PATH18,  \r\n ");
                sql.append("IFNULL(IMG_PATH19,'' ) AS IMG_PATH19,  \r\n ");
                sql.append("IFNULL(IMG_PATH20,'' ) AS IMG_PATH20,  \r\n ");
                sql.append("IFNULL(IMG_PATH21,'' ) AS IMG_PATH21,  \r\n ");
                sql.append("IFNULL(IMG_PATH22,'' ) AS IMG_PATH22,  \r\n ");
                sql.append("IFNULL(IMG_PATH23,'' ) AS IMG_PATH23,  \r\n ");
                sql.append("IFNULL(IMG_PATH24,'' ) AS IMG_PATH24,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n ");
                sql.append("IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,  \r\n ");
                sql.append("IFNULL(CERTMODEL,'' ) AS CERTMODEL,  \r\n ");
                sql.append("IFNULL(CERTNAME,'' ) AS CERTNAME,  \r\n ");
                sql.append("IFNULL(EXEMPTIONTYPE,'' ) AS EXEMPTIONTYPE,  \r\n ");
                sql.append("IFNULL(CERTNO,'' ) AS CERTNO,  \r\n ");
                sql.append("IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n ");
                sql.append("IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n ");
                sql.append("IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n ");
                sql.append("IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n ");
                sql.append("IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n ");
                sql.append("IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n ");
                sql.append("IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n ");
                sql.append("IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n ");
                sql.append("IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n ");
                sql.append("IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n ");
                sql.append("IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n ");
                sql.append("IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n ");
                sql.append("IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n ");
                sql.append("IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n ");
                sql.append("IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n ");
                sql.append("IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n ");
                sql.append("IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n ");
                sql.append("IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n ");
                sql.append("IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n ");
                sql.append("IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n ");
                sql.append("IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n ");
                sql.append("IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n ");
                sql.append("IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n ");
                sql.append("IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n ");
                sql.append("IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n ");
                sql.append("IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n ");
                sql.append("IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n ");
                sql.append("IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n ");
                sql.append("IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n ");
                sql.append("IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n ");
                sql.append("IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n ");
                sql.append("IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n ");
                sql.append("IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n ");
                sql.append("IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n ");
                sql.append("IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n ");
                sql.append("IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n ");
                sql.append("IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n ");
                sql.append("IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n ");
                sql.append("IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n ");
                sql.append("IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n ");
                sql.append("IFNULL(GOODS_NM_EN,'' ) AS GOODS_NM_EN,  \r\n ");
                sql.append("IFNULL(GOODS_NM_PR,'' ) AS GOODS_NM_PR,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS2,'' ) AS GOODS_REMARKS2,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS3,'' ) AS GOODS_REMARKS3,  \r\n ");
                sql.append("IFNULL(GOODS_REMARKS4,'' ) AS GOODS_REMARKS4,  \r\n ");
                sql.append("IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n ");
                sql.append("IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n ");
                sql.append("IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n ");
                sql.append("IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n ");
                sql.append("IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n ");
                sql.append("IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n ");
                sql.append("IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n ");
                sql.append("IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n ");
                sql.append("IFNULL(INSERTID,'' ) AS INSERTID,  \r\n ");
                sql.append("IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n ");
                sql.append("IFNULL(MODIFYID,'' ) AS MODIFYID  \r\n ");
                sql.append(" FROM SHOPPRODINFO \r\n");
                sql.append(" WHERE COMPNO = ?  AND COMPAYNY_GOODS_CD = ? \r\n");
                sql.append(" ) AS INFO  LEFT JOIN CateAll AS CATE  \r\n");
                sql.append("\t\t ON INFO.CLASS_CD1 = CATE.CLASS_CD1  \r\n");
                sql.append(" \t\t AND INFO.CLASS_CD2 = CATE.CLASS_CD2 \r\n");
                sql.append("AND INFO.CLASS_CD3 = CATE.CLASS_CD3   \r\n");
                sql.append("AND INFO.CLASS_CD4 = CATE.CLASS_CD4   \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, compno);
                pstmt.setString(2, compayny_goods_cd);
                YDMAStringUtil.Print("[getShopProductInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowno = 0;
                while (rs.next()) {
                    dto.setRowno("" + ++rowno);
                    dto.setCode(rs.getString("CODE"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setImg(rs.getString("Img"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setModel_no(rs.getString("MODEL_NO"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id(rs.getString("PARTNER_ID"));
                    dto.setDpartner_id(rs.getString("DPARTNER_ID"));
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year(rs.getString("MAKE_YEAR"));
                    dto.setMake_dm(rs.getString("MAKE_DM"));
                    dto.setGoods_season(rs.getString("GOODS_SEASON"));
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setImg_path13(rs.getString("IMG_PATH13"));
                    dto.setImg_path14(rs.getString("IMG_PATH14"));
                    dto.setImg_path15(rs.getString("IMG_PATH15"));
                    dto.setImg_path16(rs.getString("IMG_PATH16"));
                    dto.setImg_path17(rs.getString("IMG_PATH17"));
                    dto.setImg_path18(rs.getString("IMG_PATH18"));
                    dto.setImg_path19(rs.getString("IMG_PATH19"));
                    dto.setImg_path20(rs.getString("IMG_PATH20"));
                    dto.setImg_path21(rs.getString("IMG_PATH21"));
                    dto.setImg_path22(rs.getString("IMG_PATH22"));
                    dto.setImg_path23(rs.getString("IMG_PATH23"));
                    dto.setImg_path24(rs.getString("IMG_PATH24"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCertmodel(rs.getString("CERTMODEL"));
                    dto.setCertname(rs.getString("CERTNAME"));
                    dto.setExemptiontype(rs.getString("EXEMPTIONTYPE"));
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en(rs.getString("GOODS_NM_EN"));
                    dto.setGoods_nm_pr(rs.getString("GOODS_NM_PR"));
                    dto.setGoods_remarks2(rs.getString("GOODS_REMARKS2"));
                    dto.setGoods_remarks3(rs.getString("GOODS_REMARKS3"));
                    dto.setGoods_remarks4(rs.getString("GOODS_REMARKS4"));
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setClass_nm1(rs.getString("CLASS_NM1"));
                    dto.setClass_nm2(rs.getString("CLASS_NM2"));
                    dto.setClass_nm3(rs.getString("CLASS_NM3"));
                    dto.setClass_nm4(rs.getString("CLASS_NM4"));
                    dto.setDelv_type_nm(rs.getString("DELV_TYPE_NM"));
                    dto.setGoods_gubun_nm(rs.getString("GOODS_GUBUN_NM"));
                    dto.setStatus_nm(rs.getString("STATUS_NM"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public String ordsearch() throws Exception {
        String ordsearch = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ORDIMPTPER from systemconf where  compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    ordsearch = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return ordsearch;
    }

    public shopAuctionAdditionDto getAdditionaAuctionOneList1(int seq, String shopcd) throws Exception {
        shopAuctionAdditionDto dto = new shopAuctionAdditionDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SEQ,''),ifnull(COMPNO,''),ifnull(SHOPCD,''),ifnull(SHOPSEQ,''),ifnull(TITLE,''),ifnull(SHOPID,''),ifnull(SALESMETHOD,''),ifnull(SALEPERIOD,''),ifnull(PREORDERSALE,''),ifnull(PREORDERSALEVALUE1,''),ifnull(PRODSTATUS,''), ifnull(PRODSTATUSDETAIL,''),ifnull(JOINAPPLICATION,''),ifnull(ISBN,''),ifnull(MAXIMUMBUY,''),ifnull(MAXIMUMBUYVALUE1,''),ifnull(MAXIMUMBUYVALUE2,''),ifnull(MAXIMUMBUYVALUE3,''),ifnull(MAXIMUMBUYVALUE4,''),ifnull(YOUTHBUY,''),ifnull(ORIGIN,''),ifnull(PLURALORIGIN,''),ifnull(STANDARD,''),ifnull(STANDARD1,''),ifnull(STANDARD2,''),ifnull(COUPON,''),ifnull(SELLERNICKNAME,''),ifnull(MODELNAME,''),ifnull(MODELNAME1,''),ifnull(BRAND,''),ifnull(BRAND1,''),ifnull(BRAND2,''),ifnull(BRAND3,''),ifnull(REQUIREDOPTION,''),ifnull(ADDITIONALBUY,''),ifnull(OPTIONPRICE,''),ifnull(OPTIONCNT,''),ifnull(OPTIONINVENT,''),ifnull(SOLDOUTOPTION,''),ifnull(RECOMMENDOPTION,''),ifnull(OPTIONVALUE,''),ifnull(OPTIONLENGTH,''),ifnull(SELLERDISCOUNT,''),ifnull(SELLERDISCOUNT1,''),ifnull(SELLERDISCOUNT2,''),ifnull(SELLERSTARTDATE,''),ifnull(SELLERDENDDATE,''),ifnull(PORTALPRICE,''),ifnull(PRICECOMPARISON,''),ifnull(SITEDISCOUNT,''),ifnull(SPECIALDISCOUNT,''),ifnull(SPECIALSTARTDATE,''),ifnull(SPECIALENDDATE,''),ifnull(SPECIALDISCOUNT2,''),ifnull(SPECIALDISCOUNT3,''),ifnull(SPECIALDISCOUNT4,''),ifnull(SPECIALDISCOUNT5,''),ifnull(SPECIALDISCOUNT6,''),ifnull(SMILECASH,''),ifnull(SMILECASH1,''),ifnull(DONATION,''),ifnull(DONATIONSTARTDATE,''),ifnull(DONATIONENDDATE,''),ifnull(DONATION2,''),ifnull(CHANCE,''),ifnull(CHANCE1,''),ifnull(CHANCESTARTDATE,''),ifnull(CHANCEENDDATE,''),ifnull(ADDIMAGE,''),ifnull(IMAGERESIZE,''),ifnull(IMAGERESIZE1,''),ifnull(DETAILEXPLAIN,''),ifnull(DUPLIREGIST,''),ifnull(FREEGIFT,''),ifnull(FREEGIFT1,''),ifnull(SHIPMENTPOLICY,''),ifnull(OUTADDRESS,''),ifnull(DELIVERYMETHOD,''),ifnull(DELIVERYMETHOD1,''),ifnull(ADDDELIVERY,''),ifnull(ADDDELIVERY1,''),ifnull(ADDDELIVERY2,''),ifnull(ADDDELIVERY3,''),ifnull(ADDDELIVERY4,''),ifnull(DELIVERYFEESELECT,''),ifnull(DELIVERYFEESELECT1,''),ifnull(DELIVERYFEESELECT2,''),ifnull(DELIVERYFEESELECT3,''),ifnull(DELIVERYFEESELECT4,''),ifnull(DELIVERYFEESELECT5,''),ifnull(DELIVERYFEESELECT6,''),ifnull(DELIVERYFEESELECT7,''),ifnull(DELIVERYFEESELECT8,''),ifnull(DELIVERYFEESELECT9,''),ifnull(DELIVERYFEESELECT10,''),ifnull(DELIVERYFEESELECT11,''),ifnull(DELIVERYFEESELECT12,''),ifnull(DELIVERYFEESELECT13,''),ifnull(DELIVERYFEESELECT14,''),ifnull(DELIVERYFEESELECT15,''),ifnull(DELIVERYFEESELECT16,''),ifnull(DELIVERYFEESELECT17,''),ifnull(ASINFO,''),ifnull(RETURNADDR,''),ifnull(RETEXCHDELIFEE,''),ifnull(COLLECTAPPLICATION,''),ifnull(COLLECTAPPLICATION1,''),ifnull(TITLEYN,''),ifnull(ESTIDELIVERYPERIOD,''),ifnull(OTHERSPECIALNOTE,''),ifnull(MEDICALCERTINFO,''),ifnull(MEDICALCERTINFO1,''),ifnull(MEDICALCERTINFO2,''),ifnull(MEDICALCERTINFO3,''),ifnull(MEDICALCERTINFO4,''),ifnull(PRODGOSILENGTH,''),ifnull(PRODNMOUTPUT,''),ifnull(PRODNMADDFRONT,''),ifnull(PRODNMADDBACK,''),ifnull(PRODDETAILFRONT,''),ifnull(PRODDETAILBACK,''),ifnull(PRODDETAILOUTPUT,''),ifnull(PREMIUM,''),ifnull(PREMIUM1,''),ifnull(PREMIUMPLUS,''),ifnull(PREMIUMPLUS1,''),ifnull(PRODNMVOLD,''),ifnull(PRODNMVOLD1,''),ifnull(SALLER_DC_RATE,'0'),ifnull(DC_RATE,'0'),ifnull(FLOAT_DC,'0'),ifnull(MARGIN_RATE,'0'),ifnull(COMMISSION_RATE,'0'),ifnull(ADDDELIVERYP,''),ifnull(ADDDELIVERYQ,''),ifnull(FREEDELIVERY,''),ifnull(EXPPRC,'2500'),IFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX, ''),IFNULL(CHANGESIZEY, ''),IFNULL(CHANGESIZEW, ''),IFNULL(CHANGESIZEH, ''),IFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL, ''), IFNULL(DETAILKEYWORDR, ''), IFNULL(DETAILPRODUCTCODEB,''), IFNULL(DETAILPRODUCTCODEL, ''), IFNULL(DETAILPRODUCTCODER, ''), IFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL, ''), IFNULL(DETAILPRODUCTNAMER, ''), IFNULL(ADDOPTIONLB, ''), IFNULL(ADDOPTIONL, ''), IFNULL(ADDOPTIONRB, ''), IFNULL(ADDOPTIONR, ''), IFNULL(IMGONEONONE, ''), IFNULL(IMGTHREEONFOUR, ''),IFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''), IMG_ANGLE, IMG_SCALE_PERCENT \r\n\r\n from shopauctionadddtl where seq=? and shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[getAdditionaOneList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setSalesmethod(rs.getString(++columnIndex));
                    dto.setSaleperiod(rs.getString(++columnIndex));
                    dto.setPreordersale(rs.getString(++columnIndex));
                    dto.setPreordersalevalue1(rs.getString(++columnIndex));
                    dto.setProdstatus(rs.getString(++columnIndex));
                    dto.setProdStatusDetail(rs.getString(++columnIndex));
                    dto.setJoinapplication(rs.getString(++columnIndex));
                    dto.setIsbn(rs.getString(++columnIndex));
                    dto.setMaximumbuy(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue1(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue2(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue3(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue4(rs.getString(++columnIndex));
                    dto.setYouthbuy(rs.getString(++columnIndex));
                    dto.setOrigin(rs.getString(++columnIndex));
                    dto.setPluralorigin(rs.getString(++columnIndex));
                    dto.setStandard(rs.getString(++columnIndex));
                    dto.setStandard1(rs.getString(++columnIndex));
                    dto.setStandard2(rs.getString(++columnIndex));
                    dto.setCoupon(rs.getString(++columnIndex));
                    dto.setSellernickname(rs.getString(++columnIndex));
                    dto.setModelname(rs.getString(++columnIndex));
                    dto.setModelname1(rs.getString(++columnIndex));
                    dto.setBrand(rs.getString(++columnIndex));
                    dto.setBrand1(rs.getString(++columnIndex));
                    dto.setBrand2(rs.getString(++columnIndex));
                    dto.setBrand3(rs.getString(++columnIndex));
                    dto.setRequiredoption(rs.getString(++columnIndex));
                    dto.setAdditionalbuy(rs.getString(++columnIndex));
                    dto.setOptionprice(rs.getString(++columnIndex));
                    dto.setOptioncnt(rs.getString(++columnIndex));
                    dto.setOptioninvent(rs.getString(++columnIndex));
                    dto.setSoldoutoption(rs.getString(++columnIndex));
                    dto.setRecommendoption(rs.getString(++columnIndex));
                    dto.setOptionvalue(rs.getString(++columnIndex));
                    dto.setOptionlength(rs.getString(++columnIndex));
                    dto.setSellerdiscount(rs.getString(++columnIndex));
                    dto.setSellerdiscount1(rs.getString(++columnIndex));
                    dto.setSellerdiscount2(rs.getString(++columnIndex));
                    dto.setSellerstartdate(rs.getString(++columnIndex));
                    dto.setSellerendtdate(rs.getString(++columnIndex));
                    dto.setPortalprice(rs.getString(++columnIndex));
                    dto.setPricecomparison(rs.getString(++columnIndex));
                    dto.setSitediscount(rs.getString(++columnIndex));
                    dto.setSpecialdiscount(rs.getString(++columnIndex));
                    dto.setSpecialstartdate(rs.getString(++columnIndex));
                    dto.setSpecialenddate(rs.getString(++columnIndex));
                    dto.setSpecialdiscount2(rs.getString(++columnIndex));
                    dto.setSpecialdiscount3(rs.getString(++columnIndex));
                    dto.setSpecialdiscount4(rs.getString(++columnIndex));
                    dto.setSpecialdiscount5(rs.getString(++columnIndex));
                    dto.setSpecialdiscount6(rs.getString(++columnIndex));
                    dto.setSmilecash(rs.getString(++columnIndex));
                    dto.setSmilecash1(rs.getString(++columnIndex));
                    dto.setDonation(rs.getString(++columnIndex));
                    dto.setDonationstartdate(rs.getString(++columnIndex));
                    dto.setDonationenddate(rs.getString(++columnIndex));
                    dto.setDonation2(rs.getString(++columnIndex));
                    dto.setChance(rs.getString(++columnIndex));
                    dto.setChance1(rs.getString(++columnIndex));
                    dto.setChancestartdate(rs.getString(++columnIndex));
                    dto.setChanceenddate(rs.getString(++columnIndex));
                    dto.setAddimage(rs.getString(++columnIndex));
                    dto.setImageresize(rs.getString(++columnIndex));
                    dto.setImageresize1(rs.getString(++columnIndex));
                    dto.setDetailexplain(rs.getString(++columnIndex));
                    dto.setDupliregist(rs.getString(++columnIndex));
                    dto.setFreegift(rs.getString(++columnIndex));
                    dto.setFreegift1(rs.getString(++columnIndex));
                    dto.setShipmentpolicy(rs.getString(++columnIndex));
                    dto.setOutaddress(rs.getString(++columnIndex));
                    dto.setDeliverymethod(rs.getString(++columnIndex));
                    dto.setDeliverymethod1(rs.getString(++columnIndex));
                    dto.setAdddelivery(rs.getString(++columnIndex));
                    dto.setAdddelivery1(rs.getString(++columnIndex));
                    dto.setAdddelivery2(rs.getString(++columnIndex));
                    dto.setAdddelivery3(rs.getString(++columnIndex));
                    dto.setAdddelivery4(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect1(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect2(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect3(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect4(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect5(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect6(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect7(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect8(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect9(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect10(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect11(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect12(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect13(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect14(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect15(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect16(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect17(rs.getString(++columnIndex));
                    dto.setAsinfo(rs.getString(++columnIndex));
                    dto.setReturnaddr(rs.getString(++columnIndex));
                    dto.setRetexchdelifee(rs.getString(++columnIndex));
                    dto.setCollectapplication(rs.getString(++columnIndex));
                    dto.setCollectapplication1(rs.getString(++columnIndex));
                    dto.setTitleyn(rs.getString(++columnIndex));
                    dto.setEstideliveryperiod(rs.getString(++columnIndex));
                    dto.setOtherspecialnote(rs.getString(++columnIndex));
                    dto.setMedicalcertinfo(rs.getString(++columnIndex));
                    dto.setMedicalcertinfo1(rs.getString(++columnIndex));
                    dto.setMedicalcertinfo2(rs.getString(++columnIndex));
                    dto.setMedicalcertinfo3(rs.getString(++columnIndex));
                    dto.setMedicalcertinfo4(rs.getString(++columnIndex));
                    dto.setProdgosilength(rs.getString(++columnIndex));
                    dto.setProdnmoutput(rs.getString(++columnIndex));
                    dto.setProdnmaddfront(rs.getString(++columnIndex));
                    dto.setProdnmaddback(rs.getString(++columnIndex));
                    dto.setProddetailfront(rs.getString(++columnIndex));
                    dto.setProddetailback(rs.getString(++columnIndex));
                    dto.setProddetailoutput(rs.getString(++columnIndex));
                    dto.setPremium(rs.getString(++columnIndex));
                    dto.setPremium1(rs.getString(++columnIndex));
                    dto.setPremiumplus(rs.getString(++columnIndex));
                    dto.setPremiumplus1(rs.getString(++columnIndex));
                    dto.setProdnmvold(rs.getString(++columnIndex));
                    dto.setProdnmvold1(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setAdddeliveryP(rs.getString(++columnIndex));
                    dto.setAdddeliveryQ(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setAngle(rs.getString(++columnIndex));
                    dto.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopCafe24AdditionDto getAdditionaCafe24OneList1(int seq) throws Exception {
        ShopCafe24AdditionDto dto = new ShopCafe24AdditionDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select ifnull(ADULTCHECK,''),ifnull(BULKPURCHASE,''),ifnull(BULKPURCHASE1,''),ifnull(BULKPURCHASE2,''),ifnull(BULKPURCHASE3,''),ifnull(BULKPURCHASE4,''),ifnull(BULKPURCHASE5,''),ifnull(BULKPURCHASE6,''),ifnull(COMMONEVENT,''),ifnull(COMPNO,''),ifnull(DELIVERYFEETYPE,''),ifnull(DETAILEXPLAIN,''),ifnull(DISCOUNTCRIT,''),ifnull(DISPLAYRANK,''),ifnull(EXCHRETINFO,''),ifnull(EXCHRETINFO1,''),ifnull(EXPIRATIONDATE,''),ifnull(KNOWSHOPPING,''),ifnull(MDENDDATE,''),ifnull(MDSTARTDATE,''),ifnull(MEMBERREPUR,''),ifnull(MEMBERREPUR1,''),ifnull(MEMBERREPUR2,''),ifnull(MEMBERREPUR3,''),ifnull(MEMBERREPUR4,''),ifnull(MEMBERREPUR5,''),ifnull(MILEAGE,''),ifnull(MILEAGE1,''),ifnull(MILEAGE10,''),ifnull(MILEAGE11,''),ifnull(MILEAGE12,''),ifnull(MILEAGE13,''),ifnull(MILEAGE14,''),ifnull(MILEAGE2,''),ifnull(MILEAGE3,''),ifnull(MILEAGE4,''),ifnull(MILEAGE5,''),ifnull(MILEAGE6,''),ifnull(MILEAGE7,''),ifnull(MILEAGE8,''),ifnull(MILEAGE9,''),ifnull(MOBILEDISCOUNT,''),ifnull(MOBILEDISCOUNT1,''),ifnull(MOBILEDISCOUNT2,''),ifnull(MOBILEDISCOUNT3,''),ifnull(MOBILEDISCOUNT4,''),ifnull(MOBILEDISCOUNT5,''),ifnull(NAVERCHECKOUT,''),ifnull(PAYINFO,''),ifnull(PAYINFO1,''),ifnull(PRENDDATE,''),ifnull(PRODDETAILEND,''),ifnull(PRODDETAILFRONT,''),ifnull(PRODDETAILOUTPUT,''),ifnull(PRODNAME,''),ifnull(PRODNMEND,''),ifnull(PRODNMFRONT,''),ifnull(PRODOUTPUT,''),ifnull(PRODUCTMAX,''),ifnull(PRODUCTMAXTYPE,''),ifnull(PRODUCTMIN,''),ifnull(PRSTARTDATE,''),ifnull(RELEASEDATE,''),ifnull(SELLPRICEREPLACE,''),ifnull(SELLPRICEREPLACE1,''),ifnull(SEQ,''),ifnull(SERVICEINFO,''),ifnull(SERVICEINFO1,''),ifnull(SETIMAGE,''),ifnull(SHIPFEE,''),ifnull(SHIPPINGINFO,''),ifnull(SHIPPINGINFO1,''),ifnull(SHOPCD,''),ifnull(SHOPSEQ,''),ifnull(SHOPID,''),ifnull(SMS,''),ifnull(SMS1,''),ifnull(SMS2,''),ifnull(SMS3,''),ifnull(SOLDOUTSTOCKTYPE,''),ifnull(STOCKTYPE,''),ifnull(STOCKWARNVALUE,''),ifnull(SUPPLY,''),ifnull(TAXRATING,''),ifnull(TAXRATING1,''),ifnull(TITLE,''),ifnull(SALLER_DC_RATE,''),ifnull(DC_RATE,''),ifnull(FLOAT_DC,''),ifnull(MARGIN_RATE,''),ifnull(COMMISSION_RATE,''),ifnull(FREEDELIVERY,''),ifnull(EXPPRC,'2500')\t FROM shopcafe24adddtl  where seq=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setAdultcheck(rs.getString(++columnIndex));
                    dto.setBulkpurchase(rs.getString(++columnIndex));
                    dto.setBulkpurchase1(rs.getString(++columnIndex));
                    dto.setBulkpurchase2(rs.getString(++columnIndex));
                    dto.setBulkpurchase3(rs.getString(++columnIndex));
                    dto.setBulkpurchase4(rs.getString(++columnIndex));
                    dto.setBulkpurchase5(rs.getString(++columnIndex));
                    dto.setBulkpurchase6(rs.getString(++columnIndex));
                    dto.setCommonevent(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setDeliveryfeetype(rs.getString(++columnIndex));
                    dto.setDetailexplain(rs.getString(++columnIndex));
                    dto.setDiscountcrit(rs.getString(++columnIndex));
                    dto.setDisplayrank(rs.getString(++columnIndex));
                    dto.setExchretinfo(rs.getString(++columnIndex));
                    dto.setExchretinfo1(rs.getString(++columnIndex));
                    dto.setExpirationdate(rs.getString(++columnIndex));
                    dto.setKnowshopping(rs.getString(++columnIndex));
                    dto.setMdenddate(rs.getString(++columnIndex));
                    dto.setMdstartdate(rs.getString(++columnIndex));
                    dto.setMemberrepur(rs.getString(++columnIndex));
                    dto.setMemberrepur1(rs.getString(++columnIndex));
                    dto.setMemberrepur2(rs.getString(++columnIndex));
                    dto.setMemberrepur3(rs.getString(++columnIndex));
                    dto.setMemberrepur4(rs.getString(++columnIndex));
                    dto.setMemberrepur5(rs.getString(++columnIndex));
                    dto.setMileage(rs.getString(++columnIndex));
                    dto.setMileage1(rs.getString(++columnIndex));
                    dto.setMileage10(rs.getString(++columnIndex));
                    dto.setMileage11(rs.getString(++columnIndex));
                    dto.setMileage12(rs.getString(++columnIndex));
                    dto.setMileage13(rs.getString(++columnIndex));
                    dto.setMileage14(rs.getString(++columnIndex));
                    dto.setMileage2(rs.getString(++columnIndex));
                    dto.setMileage3(rs.getString(++columnIndex));
                    dto.setMileage4(rs.getString(++columnIndex));
                    dto.setMileage5(rs.getString(++columnIndex));
                    dto.setMileage6(rs.getString(++columnIndex));
                    dto.setMileage7(rs.getString(++columnIndex));
                    dto.setMileage8(rs.getString(++columnIndex));
                    dto.setMileage9(rs.getString(++columnIndex));
                    dto.setMobilediscount(rs.getString(++columnIndex));
                    dto.setMobilediscount1(rs.getString(++columnIndex));
                    dto.setMobilediscount2(rs.getString(++columnIndex));
                    dto.setMobilediscount3(rs.getString(++columnIndex));
                    dto.setMobilediscount4(rs.getString(++columnIndex));
                    dto.setMobilediscount5(rs.getString(++columnIndex));
                    dto.setNavercheckout(rs.getString(++columnIndex));
                    dto.setPayinfo(rs.getString(++columnIndex));
                    dto.setPayinfo1(rs.getString(++columnIndex));
                    dto.setPrenddate(rs.getString(++columnIndex));
                    dto.setProddetailend(rs.getString(++columnIndex));
                    dto.setProddetailfront(rs.getString(++columnIndex));
                    dto.setProddetailoutput(rs.getString(++columnIndex));
                    dto.setProdname(rs.getString(++columnIndex));
                    dto.setProdnmend(rs.getString(++columnIndex));
                    dto.setProdnmfront(rs.getString(++columnIndex));
                    dto.setProdoutput(rs.getString(++columnIndex));
                    dto.setProductmax(rs.getString(++columnIndex));
                    dto.setProductmaxtype(rs.getString(++columnIndex));
                    dto.setProductmin(rs.getString(++columnIndex));
                    dto.setPrstartdate(rs.getString(++columnIndex));
                    dto.setReleasedate(rs.getString(++columnIndex));
                    dto.setSellpricereplace(rs.getString(++columnIndex));
                    dto.setSellpricereplace1(rs.getString(++columnIndex));
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setServiceinfo(rs.getString(++columnIndex));
                    dto.setServiceinfo1(rs.getString(++columnIndex));
                    dto.setSetimage(rs.getString(++columnIndex));
                    dto.setShipfee(rs.getString(++columnIndex));
                    dto.setShippinginfo(rs.getString(++columnIndex));
                    dto.setShippinginfo1(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setSms(rs.getString(++columnIndex));
                    dto.setSms1(rs.getString(++columnIndex));
                    dto.setSms2(rs.getString(++columnIndex));
                    dto.setSms3(rs.getString(++columnIndex));
                    dto.setSoldoutstocktype(rs.getString(++columnIndex));
                    dto.setStocktype(rs.getString(++columnIndex));
                    dto.setStockwarnvalue(rs.getString(++columnIndex));
                    dto.setSupply(rs.getString(++columnIndex));
                    dto.setTaxrating(rs.getString(++columnIndex));
                    dto.setTaxrating1(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ShopProdAttrnmDto> getProductNaverNotice(String attrcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ShopProdAttrnmDto> contents = new ArrayList<ShopProdAttrnmDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT  \r\n\t IFNULL(TYPE_SEQ, '') AS TYPE_SEQ, \r\n\t IFNULL(TYPE_ENAME, '') AS TYPE_ENAME, \r\n\t IFNULL(TYPE_KNAME, '') AS TYPE_KNAME,\r\n\t IFNULL(COL_SEQ, '') AS COL_SEQ,\r\n\t IFNULL(COL_ENAME, '') AS COL_ENAME,\r\n\t IFNULL(COL_KNAME,'') AS COL_KNAME,\r\n\t IFNULL(COL_VALUE,'') AS COL_VALUE\r\n\tFROM \r\n\tshopnaverattr WHERE TYPE_SEQ =\r\n\t(SELECT ifnull(navercd,'') navercd FROM prodattr WHERE attrcd = ?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, attrcd);
                YDMAStringUtil.Print("[getProductNaverNotice]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopProdAttrnmDto dto = new ShopProdAttrnmDto();
                    dto.setAttrcd(rs.getString("TYPE_SEQ"));
                    dto.setColseq(rs.getString("COL_SEQ"));
                    dto.setNoticetype(rs.getString("TYPE_ENAME"));
                    dto.setAttrnm(rs.getString("COL_ENAME"));
                    dto.setAttrvl(rs.getString("COL_KNAME"));
                    dto.setAttrval(rs.getString("COL_VALUE"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopProdAttrnmDto> getProductNoticeOneList(String attrcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ShopProdAttrnmDto> contents = new ArrayList<ShopProdAttrnmDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "\tSELECT IFNULL(ATTRCD,'') AS ATTRCD,\r\n\tIFNULL( COLSEQ, '') AS COLSEQ,  \r\n\tIFNULL(ATTRNM,'') AS  ATTRNM, \r\n\tIFNULL( DOSINSEQ ,'') AS DOSINSEQ,\r\n\tIFNULL(NOTICETYPE,'') AS NOTICETYPE, \r\n\tIFNULL(ITEMCODE,'') AS ITEMCODE, \r\n\tIFNULL(INTERCODE,'') AS INTERCODE, \r\n\tIFNULL(INTERAPICODE,'') AS INTERAPICODE, \r\n\tIFNULL(INTERAPITYPE,'') AS INTERAPITYPE\r\n\tFROM prodattrnm where ATTRCD = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, attrcd);
                YDMAStringUtil.Print("[getProductNoticeOneList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopProdAttrnmDto dto = new ShopProdAttrnmDto();
                    dto.setAttrcd(rs.getString("ATTRCD"));
                    dto.setDosinseq(rs.getString("DOSINSEQ"));
                    dto.setColseq(rs.getString("COLSEQ"));
                    dto.setAttrnm(rs.getString("ATTRNM"));
                    dto.setNoticetype(rs.getString("NOTICETYPE"));
                    dto.setItemcode(rs.getString("ITEMCODE"));
                    dto.setIntercode(rs.getString("INTERCODE"));
                    dto.setInterapicode(rs.getString("INTERAPICODE"));
                    dto.setInterapitype(rs.getString("INTERAPITYPE"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public String getTmonGosiNum(String attrcd) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        new ArrayList();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "\tSELECT IFNULL(TMONCD,'') AS TMONCD\r\n\tFROM prodattr where ATTRCD = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, attrcd);
                YDMAStringUtil.Print("[getTmonGosiNum]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = rs.getString("TMONCD");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ProductDTO> getShopInfoList(String code, String name) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(PRODSEQ, ''), IFNULL( COMPNO, ''), IFNULL( GOODS_NM, ''), IFNULL( GOODS_KEYWORD, ''), IFNULL( MODEL_NM, ''), IFNULL( MODEL_NO, ''), IFNULL( BRAND_NM, ''), IFNULL( COMPAYNY_GOODS_CD, ''), IFNULL( GOODS_SEARCH, ''), IFNULL( GOODS_GUBUN, ''), IFNULL( SHOP_CID_INFO, ''), IFNULL( SELECT_OPTION, ''), IFNULL( TEXT_OPTION, ''), IFNULL( CLASS_CD1, ''), IFNULL( CLASS_CD2, ''), IFNULL( CLASS_CD3, ''), IFNULL( CLASS_CD4, ''), IFNULL( GMCATEGNM, ''), IFNULL( PARTNER_ID, ''), IFNULL( DPARTNER_ID, ''), IFNULL( MAKER, ''), IFNULL( ORIGIN, ''), IFNULL( MAKE_YEAR, ''), IFNULL( MAKE_DM, ''), IFNULL( GOODS_SEASON, ''), IFNULL( SEX, ''), IFNULL( `STATUS`, ''), IFNULL( DELIV_ABLE_REGION, ''), IFNULL( TAX_YN, ''), IFNULL( DELV_TYPE, ''), IFNULL( DELV_COST, ''), IFNULL( DELV_QTY, ''), IFNULL( BANPUM_AREA, ''), IFNULL( GOODS_COST, ''), IFNULL( GOODS_PRICE, ''), IFNULL( GOODS_CONSUMER_PRICE, ''), IFNULL( ISLIMIT, ''), IFNULL( LIMIT_PRICE, ''), IFNULL( IS_OVERSEAS, ''), IFNULL( ADULT, ''), IFNULL( ISRETURN, ''), IFNULL( ITYPE, ''), IFNULL( CHAR_1_NM, ''), IFNULL( CHAR_1_VAL, ''), IFNULL( CHAR_2_NM, ''), IFNULL( CHAR_2_VAL, ''), IFNULL( IMG_PATH, ''), IFNULL( IMG_PATH1, ''), IFNULL( IMG_PATH2, ''), IFNULL( IMG_PATH3, ''), IFNULL( IMG_PATH4, ''), IFNULL( IMG_PATH5, ''), IFNULL( IMG_PATH6, ''), IFNULL( IMG_PATH7, ''), IFNULL( IMG_PATH8, ''), IFNULL( IMG_PATH9, ''), IFNULL( IMG_PATH10, ''), IFNULL( IMG_PATH11, ''), IFNULL( IMG_PATH12, ''), IFNULL( IMG_PATH13, ''), IFNULL( IMG_PATH14, ''), IFNULL( IMG_PATH15, ''), IFNULL( IMG_PATH16, ''), IFNULL( IMG_PATH17, ''), IFNULL( IMG_PATH18, ''), IFNULL( IMG_PATH19, ''), IFNULL( IMG_PATH20, ''), IFNULL( IMG_PATH21, ''), IFNULL( IMG_PATH22, ''), IFNULL( IMG_PATH23, ''), IFNULL( IMG_PATH24, ''), IFNULL( GOODS_REMARKS, ''), IFNULL( CERT_TYPE, ''), IFNULL( CERT, ''), IFNULL( CERTNO, ''), IFNULL( AVLST_DM, ''), IFNULL( AVLED_DM, ''), IFNULL( ISSUEDATE, ''), IFNULL( CERTDATE, ''), IFNULL( CERT_AGENCY, ''), IFNULL( CERTFIELD, ''), IFNULL( CERTMODEL, ''), IFNULL( CERTNAME, ''), IFNULL( EXEMPTIONTYPE, ''), IFNULL( MATERIAL, ''), IFNULL( STOCK_USE_YN, ''), IFNULL( OPT_TYPE, ''), IFNULL( PROP_EDIT_YN, ''), IFNULL( PROP1_CD, ''), IFNULL( PROP_VAL1, ''), IFNULL( PROP_VAL2, ''), IFNULL( PROP_VAL3, ''), IFNULL( PROP_VAL4, ''), IFNULL( PROP_VAL5, ''), IFNULL( PROP_VAL6, ''), IFNULL( PROP_VAL7, ''), IFNULL( PROP_VAL8, ''), IFNULL( PROP_VAL9, ''), IFNULL( PROP_VAL10, ''), IFNULL( PROP_VAL11, ''), IFNULL( PROP_VAL12, ''), IFNULL( PROP_VAL13, ''), IFNULL( PROP_VAL14, ''), IFNULL( PROP_VAL15, ''), IFNULL( PROP_VAL16, ''), IFNULL( PROP_VAL17, ''), IFNULL( PROP_VAL18, ''), IFNULL( PROP_VAL19, ''), IFNULL( PROP_VAL20, ''), IFNULL( PROP_VAL21, ''), IFNULL( PROP_VAL22, ''), IFNULL( PROP_VAL23, ''), IFNULL( PROP_VAL24, ''), IFNULL( PROP_VAL25, ''), IFNULL( PROP_VAL26, ''), IFNULL( PROP_VAL27, ''), IFNULL( PROP_VAL28, ''), IFNULL( PACK_CODE_STR, ''), IFNULL( GOODS_NM_EN, ''), IFNULL( GOODS_NM_PR, ''), IFNULL( GOODS_REMARKS2, ''), IFNULL( GOODS_REMARKS3, ''), IFNULL( GOODS_REMARKS4, ''), IFNULL( IMPORTNO, ''), IFNULL( GOODS_COST2, ''), IFNULL( ORIGIN2, ''), IFNULL( EXPIRE_DM, ''), IFNULL( SUPPLY_SAVE_YN, ''), IFNULL( DESCRITION, ''), IFNULL( SHOPPRODNO, ''), IFNULL( INSERTDT, ''), IFNULL( INSERTID, ''), IFNULL( MODIFYDT, ''), IFNULL( MODIFYID, ''), IFNULL( SHOPSENDSTATUS, ''), IFNULL( SHOPMODIFYCONTENT, ''), IFNULL( SELFMOD_NO,'') \r\n\tFROM shopprodinfo where compno = ? and " + code + " LIKE ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, "%" + name + "%");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    ProductDTO dto = new ProductDTO();
                    dto.setPRODSEQ(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setGoods_nm(rs.getString(++columnIndex));
                    dto.setGoods_keyword(rs.getString(++columnIndex));
                    dto.setModel_nm(rs.getString(++columnIndex));
                    dto.setModel_no(rs.getString(++columnIndex));
                    dto.setBrand_nm(rs.getString(++columnIndex));
                    dto.setCompayny_goods_cd(rs.getString(++columnIndex));
                    dto.setGoods_search(rs.getString(++columnIndex));
                    dto.setGoods_gubun(rs.getString(++columnIndex));
                    dto.setShop_cid_info(rs.getString(++columnIndex));
                    dto.setSelect_option(rs.getString(++columnIndex));
                    dto.setText_option(rs.getString(++columnIndex));
                    dto.setClass_cd1(rs.getString(++columnIndex));
                    dto.setClass_cd2(rs.getString(++columnIndex));
                    dto.setClass_cd3(rs.getString(++columnIndex));
                    dto.setClass_cd4(rs.getString(++columnIndex));
                    dto.setGmcategnm(rs.getString(++columnIndex));
                    dto.setPartner_id(rs.getString(++columnIndex));
                    dto.setDpartner_id(rs.getString(++columnIndex));
                    dto.setMaker(rs.getString(++columnIndex));
                    dto.setOrigin(rs.getString(++columnIndex));
                    dto.setMake_year(rs.getString(++columnIndex));
                    dto.setMake_dm(rs.getString(++columnIndex));
                    dto.setGoods_season(rs.getString(++columnIndex));
                    dto.setSex(rs.getString(++columnIndex));
                    dto.setStatus(rs.getString(++columnIndex));
                    dto.setDeliv_able_region(rs.getString(++columnIndex));
                    dto.setTax_yn(rs.getString(++columnIndex));
                    dto.setDelv_type(rs.getString(++columnIndex));
                    dto.setDelv_cost(rs.getString(++columnIndex));
                    dto.setDelv_qty(rs.getString(++columnIndex));
                    dto.setBanpum_area(rs.getString(++columnIndex));
                    dto.setGoods_cost(rs.getString(++columnIndex));
                    dto.setGoods_price(rs.getString(++columnIndex));
                    dto.setGoods_consumer_price(rs.getString(++columnIndex));
                    dto.setIslimit(rs.getString(++columnIndex));
                    dto.setLimit_price(rs.getString(++columnIndex));
                    dto.setIs_overseas(rs.getString(++columnIndex));
                    dto.setAdult(rs.getString(++columnIndex));
                    dto.setIsreturn(rs.getString(++columnIndex));
                    dto.setItype(rs.getString(++columnIndex));
                    dto.setChar_1_nm(rs.getString(++columnIndex));
                    dto.setChar_1_val(rs.getString(++columnIndex));
                    dto.setChar_2_nm(rs.getString(++columnIndex));
                    dto.setChar_2_val(rs.getString(++columnIndex));
                    dto.setImg_path(rs.getString(++columnIndex));
                    dto.setImg_path1(rs.getString(++columnIndex));
                    dto.setImg_path2(rs.getString(++columnIndex));
                    dto.setImg_path3(rs.getString(++columnIndex));
                    dto.setImg_path4(rs.getString(++columnIndex));
                    dto.setImg_path5(rs.getString(++columnIndex));
                    dto.setImg_path6(rs.getString(++columnIndex));
                    dto.setImg_path7(rs.getString(++columnIndex));
                    dto.setImg_path8(rs.getString(++columnIndex));
                    dto.setImg_path9(rs.getString(++columnIndex));
                    dto.setImg_path10(rs.getString(++columnIndex));
                    dto.setImg_path11(rs.getString(++columnIndex));
                    dto.setImg_path12(rs.getString(++columnIndex));
                    dto.setImg_path13(rs.getString(++columnIndex));
                    dto.setImg_path14(rs.getString(++columnIndex));
                    dto.setImg_path15(rs.getString(++columnIndex));
                    dto.setImg_path16(rs.getString(++columnIndex));
                    dto.setImg_path17(rs.getString(++columnIndex));
                    dto.setImg_path18(rs.getString(++columnIndex));
                    dto.setImg_path19(rs.getString(++columnIndex));
                    dto.setImg_path20(rs.getString(++columnIndex));
                    dto.setImg_path21(rs.getString(++columnIndex));
                    dto.setImg_path22(rs.getString(++columnIndex));
                    dto.setImg_path23(rs.getString(++columnIndex));
                    dto.setImg_path24(rs.getString(++columnIndex));
                    dto.setGoods_remarks(rs.getString(++columnIndex));
                    dto.setCert_type(rs.getString(++columnIndex));
                    dto.setCert(rs.getString(++columnIndex));
                    dto.setCertno(rs.getString(++columnIndex));
                    dto.setAvlst_dm(rs.getString(++columnIndex));
                    dto.setAvled_dm(rs.getString(++columnIndex));
                    dto.setIssuedate(rs.getString(++columnIndex));
                    dto.setCertdate(rs.getString(++columnIndex));
                    dto.setCert_agency(rs.getString(++columnIndex));
                    dto.setCertfield(rs.getString(++columnIndex));
                    dto.setCertmodel(rs.getString(++columnIndex));
                    dto.setCertname(rs.getString(++columnIndex));
                    dto.setExemptiontype(rs.getString(++columnIndex));
                    dto.setMaterial(rs.getString(++columnIndex));
                    dto.setStock_use_yn(rs.getString(++columnIndex));
                    dto.setOpt_type(rs.getString(++columnIndex));
                    dto.setProp_edit_yn(rs.getString(++columnIndex));
                    dto.setProp1_cd(rs.getString(++columnIndex));
                    dto.setProp_val1(rs.getString(++columnIndex));
                    dto.setProp_val2(rs.getString(++columnIndex));
                    dto.setProp_val3(rs.getString(++columnIndex));
                    dto.setProp_val4(rs.getString(++columnIndex));
                    dto.setProp_val5(rs.getString(++columnIndex));
                    dto.setProp_val6(rs.getString(++columnIndex));
                    dto.setProp_val7(rs.getString(++columnIndex));
                    dto.setProp_val8(rs.getString(++columnIndex));
                    dto.setProp_val9(rs.getString(++columnIndex));
                    dto.setProp_val10(rs.getString(++columnIndex));
                    dto.setProp_val11(rs.getString(++columnIndex));
                    dto.setProp_val12(rs.getString(++columnIndex));
                    dto.setProp_val13(rs.getString(++columnIndex));
                    dto.setProp_val14(rs.getString(++columnIndex));
                    dto.setProp_val15(rs.getString(++columnIndex));
                    dto.setProp_val16(rs.getString(++columnIndex));
                    dto.setProp_val17(rs.getString(++columnIndex));
                    dto.setProp_val18(rs.getString(++columnIndex));
                    dto.setProp_val19(rs.getString(++columnIndex));
                    dto.setProp_val20(rs.getString(++columnIndex));
                    dto.setProp_val21(rs.getString(++columnIndex));
                    dto.setProp_val22(rs.getString(++columnIndex));
                    dto.setProp_val23(rs.getString(++columnIndex));
                    dto.setProp_val24(rs.getString(++columnIndex));
                    dto.setProp_val25(rs.getString(++columnIndex));
                    dto.setProp_val26(rs.getString(++columnIndex));
                    dto.setProp_val27(rs.getString(++columnIndex));
                    dto.setProp_val28(rs.getString(++columnIndex));
                    dto.setPack_code_str(rs.getString(++columnIndex));
                    dto.setGoods_nm_en(rs.getString(++columnIndex));
                    dto.setGoods_nm_pr(rs.getString(++columnIndex));
                    dto.setGoods_remarks2(rs.getString(++columnIndex));
                    dto.setGoods_remarks3(rs.getString(++columnIndex));
                    dto.setGoods_remarks4(rs.getString(++columnIndex));
                    dto.setImportno(rs.getString(++columnIndex));
                    dto.setGoods_cost2(rs.getString(++columnIndex));
                    dto.setOrigin2(rs.getString(++columnIndex));
                    dto.setExpire_dm(rs.getString(++columnIndex));
                    dto.setSupply_save_yn(rs.getString(++columnIndex));
                    dto.setDescrition(rs.getString(++columnIndex));
                    dto.setShopprodno(rs.getString(++columnIndex));
                    dto.setInsertdt(rs.getString(++columnIndex));
                    dto.setInsertid(rs.getString(++columnIndex));
                    dto.setModifydt(rs.getString(++columnIndex));
                    dto.setModifyid(rs.getString(++columnIndex));
                    dto.setSendstats(rs.getString(++columnIndex));
                    dto.setShopmodifycontent(rs.getString(++columnIndex));
                    dto.setSelfmod_no(rs.getString(++columnIndex));
                    dto.setQty("999");
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int getMaxCompanyGoodsCd() throws Exception {
        int companyGoodsCd = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(MAX(COMPAYNY_GOODS_CD), '')  FROM shopprodinfo where compno = ?   AND COMPAYNY_GOODS_CD LIKE 'MLK%' ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int n = companyGoodsCd = rs.getString(1).equals("") ? 0 : Integer.parseInt(rs.getString(1).substring(3));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return companyGoodsCd;
    }

    public ProductDTO getShopInfOne(String code, String name) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ProductDTO dto = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(PRODSEQ, ''), IFNULL( COMPNO, ''), IFNULL( GOODS_NM, ''), IFNULL( GOODS_KEYWORD, ''), IFNULL( MODEL_NM, ''), IFNULL( MODEL_NO, ''), IFNULL( BRAND_NM, ''), IFNULL( COMPAYNY_GOODS_CD, ''), IFNULL( GOODS_SEARCH, ''), IFNULL( GOODS_GUBUN, ''), IFNULL( SHOP_CID_INFO, ''), IFNULL( SELECT_OPTION, ''), IFNULL( TEXT_OPTION, ''), IFNULL( CLASS_CD1, ''), IFNULL( CLASS_CD2, ''), IFNULL( CLASS_CD3, ''), IFNULL( CLASS_CD4, ''), IFNULL( GMCATEGNM, ''), IFNULL( PARTNER_ID, ''), IFNULL( DPARTNER_ID, ''), IFNULL( MAKER, ''), IFNULL( ORIGIN, ''), IFNULL( MAKE_YEAR, ''), IFNULL( MAKE_DM, ''), IFNULL( GOODS_SEASON, ''), IFNULL( SEX, ''), IFNULL( `STATUS`, ''), IFNULL( DELIV_ABLE_REGION, ''), IFNULL( TAX_YN, ''), IFNULL( DELV_TYPE, ''), IFNULL( DELV_COST, '0'), IFNULL( DELV_QTY, '0'), IFNULL( BANPUM_AREA, ''), IFNULL( GOODS_COST, '0'), IFNULL( GOODS_PRICE, '0'), IFNULL( GOODS_CONSUMER_PRICE, '0'), IFNULL( ISLIMIT, '0'), IFNULL( LIMIT_PRICE, '0'), IFNULL( IS_OVERSEAS, '0'), IFNULL( ADULT, '0'), IFNULL( ISRETURN, '0'), IFNULL( ITYPE, '0'), IFNULL( CHAR_1_NM, ''), IFNULL( CHAR_1_VAL, ''), IFNULL( CHAR_2_NM, ''), IFNULL( CHAR_2_VAL, ''), IFNULL( IMG_PATH, ''), IFNULL( IMG_PATH1, ''), IFNULL( IMG_PATH2, ''), IFNULL( IMG_PATH3, ''), IFNULL( IMG_PATH4, ''), IFNULL( IMG_PATH5, ''), IFNULL( IMG_PATH6, ''), IFNULL( IMG_PATH7, ''), IFNULL( IMG_PATH8, ''), IFNULL( IMG_PATH9, ''), IFNULL( IMG_PATH10, ''), IFNULL( IMG_PATH11, ''), IFNULL( IMG_PATH12, ''), IFNULL( IMG_PATH13, ''), IFNULL( IMG_PATH14, ''), IFNULL( IMG_PATH15, ''), IFNULL( IMG_PATH16, ''), IFNULL( IMG_PATH17, ''), IFNULL( IMG_PATH18, ''), IFNULL( IMG_PATH19, ''), IFNULL( IMG_PATH20, ''), IFNULL( IMG_PATH21, ''), IFNULL( IMG_PATH22, ''), IFNULL( IMG_PATH23, ''), IFNULL( IMG_PATH24, ''), IFNULL( GOODS_REMARKS, ''), IFNULL( CERT_TYPE, ''), IFNULL( CERT, ''), IFNULL( CERTNO, ''), IFNULL( AVLST_DM, ''), IFNULL( AVLED_DM, ''), IFNULL( ISSUEDATE, ''), IFNULL( CERTDATE, ''), IFNULL( CERT_AGENCY, ''), IFNULL( CERTFIELD, ''), IFNULL( CERTMODEL, ''), IFNULL( CERTNAME, ''), IFNULL( EXEMPTIONTYPE, ''), IFNULL( MATERIAL, ''), IFNULL( STOCK_USE_YN, ''), IFNULL( OPT_TYPE, ''), IFNULL( PROP_EDIT_YN, ''), IFNULL( PROP1_CD, ''), IFNULL( PROP_VAL1, ''), IFNULL( PROP_VAL2, ''), IFNULL( PROP_VAL3, ''), IFNULL( PROP_VAL4, ''), IFNULL( PROP_VAL5, ''), IFNULL( PROP_VAL6, ''), IFNULL( PROP_VAL7, ''), IFNULL( PROP_VAL8, ''), IFNULL( PROP_VAL9, ''), IFNULL( PROP_VAL10, ''), IFNULL( PROP_VAL11, ''), IFNULL( PROP_VAL12, ''), IFNULL( PROP_VAL13, ''), IFNULL( PROP_VAL14, ''), IFNULL( PROP_VAL15, ''), IFNULL( PROP_VAL16, ''), IFNULL( PROP_VAL17, ''), IFNULL( PROP_VAL18, ''), IFNULL( PROP_VAL19, ''), IFNULL( PROP_VAL20, ''), IFNULL( PROP_VAL21, ''), IFNULL( PROP_VAL22, ''), IFNULL( PROP_VAL23, ''), IFNULL( PROP_VAL24, ''), IFNULL( PROP_VAL25, ''), IFNULL( PROP_VAL26, ''), IFNULL( PROP_VAL27, ''), IFNULL( PROP_VAL28, ''), IFNULL( PACK_CODE_STR, ''), IFNULL( GOODS_NM_EN, ''), IFNULL( GOODS_NM_PR, ''), IFNULL( GOODS_REMARKS2, ''), IFNULL( GOODS_REMARKS3, ''), IFNULL( GOODS_REMARKS4, ''), IFNULL( IMPORTNO, ''), IFNULL( GOODS_COST2, ''), IFNULL( ORIGIN2, ''), IFNULL( EXPIRE_DM, ''), IFNULL( SUPPLY_SAVE_YN, ''), IFNULL( DESCRITION, ''), IFNULL( SHOPPRODNO, ''), IFNULL( INSERTDT, ''), IFNULL( INSERTID, ''), IFNULL( MODIFYDT, ''), IFNULL( MODIFYID, ''), IFNULL( SHOPSENDSTATUS, '0'), IFNULL( SHOPMODIFYCONTENT, ''), IFNULL( SELFMOD_NO,'') \r\n\tFROM shopprodinfo where compno = ? and " + code + " = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, name);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto = new ProductDTO();
                    dto.setPRODSEQ(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setGoods_nm(rs.getString(++columnIndex));
                    dto.setGoods_keyword(rs.getString(++columnIndex));
                    dto.setModel_nm(rs.getString(++columnIndex));
                    dto.setModel_no(rs.getString(++columnIndex));
                    dto.setBrand_nm(rs.getString(++columnIndex));
                    dto.setCompayny_goods_cd(rs.getString(++columnIndex));
                    dto.setGoods_search(rs.getString(++columnIndex));
                    dto.setGoods_gubun(rs.getString(++columnIndex));
                    dto.setShop_cid_info(rs.getString(++columnIndex));
                    dto.setSelect_option(rs.getString(++columnIndex));
                    dto.setText_option(rs.getString(++columnIndex));
                    dto.setClass_cd1(rs.getString(++columnIndex));
                    dto.setClass_cd2(rs.getString(++columnIndex));
                    dto.setClass_cd3(rs.getString(++columnIndex));
                    dto.setClass_cd4(rs.getString(++columnIndex));
                    dto.setGmcategnm(rs.getString(++columnIndex));
                    dto.setPartner_id(rs.getString(++columnIndex));
                    dto.setDpartner_id(rs.getString(++columnIndex));
                    dto.setMaker(rs.getString(++columnIndex));
                    dto.setOrigin(rs.getString(++columnIndex));
                    dto.setMake_year(rs.getString(++columnIndex));
                    dto.setMake_dm(rs.getString(++columnIndex));
                    dto.setGoods_season(rs.getString(++columnIndex));
                    dto.setSex(rs.getString(++columnIndex));
                    dto.setStatus(rs.getString(++columnIndex));
                    dto.setDeliv_able_region(rs.getString(++columnIndex));
                    dto.setTax_yn(rs.getString(++columnIndex));
                    dto.setDelv_type(rs.getString(++columnIndex));
                    dto.setDelv_cost(rs.getString(++columnIndex));
                    dto.setDelv_qty(rs.getString(++columnIndex));
                    dto.setBanpum_area(rs.getString(++columnIndex));
                    dto.setGoods_cost(rs.getString(++columnIndex));
                    dto.setGoods_price(rs.getString(++columnIndex));
                    dto.setGoods_consumer_price(rs.getString(++columnIndex));
                    dto.setIslimit(rs.getString(++columnIndex));
                    dto.setLimit_price(rs.getString(++columnIndex));
                    dto.setIs_overseas(rs.getString(++columnIndex));
                    dto.setAdult(rs.getString(++columnIndex));
                    dto.setIsreturn(rs.getString(++columnIndex));
                    dto.setItype(rs.getString(++columnIndex));
                    dto.setChar_1_nm(rs.getString(++columnIndex));
                    dto.setChar_1_val(rs.getString(++columnIndex));
                    dto.setChar_2_nm(rs.getString(++columnIndex));
                    dto.setChar_2_val(rs.getString(++columnIndex));
                    dto.setImg_path(rs.getString(++columnIndex));
                    dto.setImg_path1(rs.getString(++columnIndex));
                    dto.setImg_path2(rs.getString(++columnIndex));
                    dto.setImg_path3(rs.getString(++columnIndex));
                    dto.setImg_path4(rs.getString(++columnIndex));
                    dto.setImg_path5(rs.getString(++columnIndex));
                    dto.setImg_path6(rs.getString(++columnIndex));
                    dto.setImg_path7(rs.getString(++columnIndex));
                    dto.setImg_path8(rs.getString(++columnIndex));
                    dto.setImg_path9(rs.getString(++columnIndex));
                    dto.setImg_path10(rs.getString(++columnIndex));
                    dto.setImg_path11(rs.getString(++columnIndex));
                    dto.setImg_path12(rs.getString(++columnIndex));
                    dto.setImg_path13(rs.getString(++columnIndex));
                    dto.setImg_path14(rs.getString(++columnIndex));
                    dto.setImg_path15(rs.getString(++columnIndex));
                    dto.setImg_path16(rs.getString(++columnIndex));
                    dto.setImg_path17(rs.getString(++columnIndex));
                    dto.setImg_path18(rs.getString(++columnIndex));
                    dto.setImg_path19(rs.getString(++columnIndex));
                    dto.setImg_path20(rs.getString(++columnIndex));
                    dto.setImg_path21(rs.getString(++columnIndex));
                    dto.setImg_path22(rs.getString(++columnIndex));
                    dto.setImg_path23(rs.getString(++columnIndex));
                    dto.setImg_path24(rs.getString(++columnIndex));
                    dto.setGoods_remarks(rs.getString(++columnIndex));
                    dto.setCert_type(rs.getString(++columnIndex));
                    dto.setCert(rs.getString(++columnIndex));
                    dto.setCertno(rs.getString(++columnIndex));
                    dto.setAvlst_dm(rs.getString(++columnIndex));
                    dto.setAvled_dm(rs.getString(++columnIndex));
                    dto.setIssuedate(rs.getString(++columnIndex));
                    dto.setCertdate(rs.getString(++columnIndex));
                    dto.setCert_agency(rs.getString(++columnIndex));
                    dto.setCertfield(rs.getString(++columnIndex));
                    dto.setCertmodel(rs.getString(++columnIndex));
                    dto.setCertname(rs.getString(++columnIndex));
                    dto.setExemptiontype(rs.getString(++columnIndex));
                    dto.setMaterial(rs.getString(++columnIndex));
                    dto.setStock_use_yn(rs.getString(++columnIndex));
                    dto.setOpt_type(rs.getString(++columnIndex));
                    dto.setProp_edit_yn(rs.getString(++columnIndex));
                    dto.setProp1_cd(rs.getString(++columnIndex));
                    dto.setProp_val1(rs.getString(++columnIndex));
                    dto.setProp_val2(rs.getString(++columnIndex));
                    dto.setProp_val3(rs.getString(++columnIndex));
                    dto.setProp_val4(rs.getString(++columnIndex));
                    dto.setProp_val5(rs.getString(++columnIndex));
                    dto.setProp_val6(rs.getString(++columnIndex));
                    dto.setProp_val7(rs.getString(++columnIndex));
                    dto.setProp_val8(rs.getString(++columnIndex));
                    dto.setProp_val9(rs.getString(++columnIndex));
                    dto.setProp_val10(rs.getString(++columnIndex));
                    dto.setProp_val11(rs.getString(++columnIndex));
                    dto.setProp_val12(rs.getString(++columnIndex));
                    dto.setProp_val13(rs.getString(++columnIndex));
                    dto.setProp_val14(rs.getString(++columnIndex));
                    dto.setProp_val15(rs.getString(++columnIndex));
                    dto.setProp_val16(rs.getString(++columnIndex));
                    dto.setProp_val17(rs.getString(++columnIndex));
                    dto.setProp_val18(rs.getString(++columnIndex));
                    dto.setProp_val19(rs.getString(++columnIndex));
                    dto.setProp_val20(rs.getString(++columnIndex));
                    dto.setProp_val21(rs.getString(++columnIndex));
                    dto.setProp_val22(rs.getString(++columnIndex));
                    dto.setProp_val23(rs.getString(++columnIndex));
                    dto.setProp_val24(rs.getString(++columnIndex));
                    dto.setProp_val25(rs.getString(++columnIndex));
                    dto.setProp_val26(rs.getString(++columnIndex));
                    dto.setProp_val27(rs.getString(++columnIndex));
                    dto.setProp_val28(rs.getString(++columnIndex));
                    dto.setPack_code_str(rs.getString(++columnIndex));
                    dto.setGoods_nm_en(rs.getString(++columnIndex));
                    dto.setGoods_nm_pr(rs.getString(++columnIndex));
                    dto.setGoods_remarks2(rs.getString(++columnIndex));
                    dto.setGoods_remarks3(rs.getString(++columnIndex));
                    dto.setGoods_remarks4(rs.getString(++columnIndex));
                    dto.setImportno(rs.getString(++columnIndex));
                    dto.setGoods_cost2(rs.getString(++columnIndex));
                    dto.setOrigin2(rs.getString(++columnIndex));
                    dto.setExpire_dm(rs.getString(++columnIndex));
                    dto.setSupply_save_yn(rs.getString(++columnIndex));
                    dto.setDescrition(rs.getString(++columnIndex));
                    dto.setShopprodno(rs.getString(++columnIndex));
                    dto.setInsertdt(rs.getString(++columnIndex));
                    dto.setInsertid(rs.getString(++columnIndex));
                    dto.setModifydt(rs.getString(++columnIndex));
                    dto.setModifyid(rs.getString(++columnIndex));
                    dto.setSendstats(rs.getString(++columnIndex));
                    dto.setShopmodifycontent(rs.getString(++columnIndex));
                    dto.setSelfmod_no(rs.getString(++columnIndex));
                    dto.setQty("999");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public int setProductInfoInsertNUpdate(List<ProductDTO> items) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                PreparedStatement pstmtSave = connection.prepareStatement(this.getSqlSave().toUpperCase());
                PreparedStatement pstmtupdate = connection.prepareStatement(this.getSqlupdate().toUpperCase());
                statementlist.add(pstmtSave);
                statementlist.add(pstmtupdate);
                boolean isSave = false;
                boolean isupdate = false;
                for (ProductDTO dto : items) {
                    int isOrder = 0;
                    isOrder = this.isShopProductInExits(dto.getPRODSEQ(), dto.getSHOP_USERID(), YDMASessonUtil.getCompnoInfo().getCompno(), dto.getShopcd(), dto.getShopseq());
                    if (isOrder > 0) {
                        isupdate = true;
                        dto.setSENDSEQ(String.valueOf(isOrder));
                        this.update(dto, connection, statementlist, pstmtupdate);
                        pstmtupdate.executeBatch();
                        pstmtupdate.clearBatch();
                        connection.commit();
                        continue;
                    }
                    isSave = true;
                    this.Save(dto, connection, statementlist, pstmtSave);
                    pstmtSave.executeBatch();
                    pstmtSave.clearBatch();
                    connection.commit();
                }
            }
            catch (Exception ex) {
                connection.rollback();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return items.size();
    }

    private PreparedStatement Save(ProductDTO dto, Connection connection, List<PreparedStatement> statementlist, PreparedStatement pstmt) throws Exception {
        int rowIdx = 0;
        pstmt.setString(++rowIdx, dto.getCompno());
        pstmt.setString(++rowIdx, dto.getShopcd());
        pstmt.setString(++rowIdx, dto.getPRODSEQ());
        pstmt.setString(++rowIdx, dto.getSHOP_USERID());
        pstmt.setString(++rowIdx, dto.getShopseq());
        pstmt.setString(++rowIdx, dto.getShopprodno());
        pstmt.setString(++rowIdx, "0");
        pstmt.setString(++rowIdx, dto.getShopcatno());
        pstmt.setString(++rowIdx, dto.getGoods_nm());
        pstmt.setString(++rowIdx, dto.getGoods_keyword());
        pstmt.setString(++rowIdx, dto.getModel_nm());
        pstmt.setString(++rowIdx, dto.getBrand_nm());
        pstmt.setString(++rowIdx, dto.getCompayny_goods_cd());
        pstmt.setString(++rowIdx, dto.getShop_cid_info().equals("") ? null : dto.getShop_cid_info());
        pstmt.setString(++rowIdx, dto.getGoods_search());
        pstmt.setString(++rowIdx, dto.getGoods_gubun());
        pstmt.setString(++rowIdx, dto.getSelect_option());
        pstmt.setString(++rowIdx, dto.getText_option());
        pstmt.setString(++rowIdx, dto.getClass_cd1());
        pstmt.setString(++rowIdx, dto.getClass_cd2());
        pstmt.setString(++rowIdx, dto.getClass_cd3());
        pstmt.setString(++rowIdx, dto.getClass_cd4());
        pstmt.setString(++rowIdx, dto.getGmcategnm());
        pstmt.setString(++rowIdx, dto.getPartner_id());
        pstmt.setString(++rowIdx, dto.getDpartner_id());
        pstmt.setString(++rowIdx, dto.getMaker());
        pstmt.setString(++rowIdx, dto.getOrigin());
        pstmt.setString(++rowIdx, dto.getMake_year());
        pstmt.setString(++rowIdx, dto.getMake_dm());
        pstmt.setString(++rowIdx, dto.getGoods_season());
        pstmt.setString(++rowIdx, dto.getSex());
        pstmt.setString(++rowIdx, dto.getStatus());
        pstmt.setString(++rowIdx, dto.getDeliv_able_region());
        pstmt.setString(++rowIdx, dto.getTax_yn());
        pstmt.setString(++rowIdx, dto.getDelv_type());
        pstmt.setString(++rowIdx, dto.getDelv_cost());
        pstmt.setString(++rowIdx, dto.getDelv_qty().equals("") ? "0" : dto.getDelv_qty());
        pstmt.setString(++rowIdx, dto.getBanpum_area());
        pstmt.setString(++rowIdx, dto.getGoods_cost());
        pstmt.setString(++rowIdx, dto.getGoods_price());
        pstmt.setString(++rowIdx, dto.getMarket_price());
        pstmt.setString(++rowIdx, dto.getGoods_consumer_price());
        pstmt.setInt(++rowIdx, Integer.parseInt(dto.getIslimit()));
        pstmt.setString(++rowIdx, dto.getLimit_price());
        pstmt.setString(++rowIdx, dto.getIs_overseas());
        pstmt.setString(++rowIdx, dto.getAdult());
        pstmt.setString(++rowIdx, dto.getIsreturn());
        pstmt.setString(++rowIdx, dto.getItype());
        pstmt.setString(++rowIdx, dto.getOptionYN());
        pstmt.setString(++rowIdx, dto.getChar_1_nm());
        pstmt.setString(++rowIdx, dto.getChar_1_val());
        pstmt.setString(++rowIdx, dto.getChar_2_nm());
        pstmt.setString(++rowIdx, dto.getChar_2_val());
        pstmt.setString(++rowIdx, dto.getImg_path());
        pstmt.setString(++rowIdx, dto.getImg_path1());
        pstmt.setString(++rowIdx, dto.getImg_path2());
        pstmt.setString(++rowIdx, dto.getImg_path3());
        pstmt.setString(++rowIdx, dto.getImg_path4());
        pstmt.setString(++rowIdx, dto.getImg_path5());
        pstmt.setString(++rowIdx, dto.getImg_path6());
        pstmt.setString(++rowIdx, dto.getImg_path7());
        pstmt.setString(++rowIdx, dto.getImg_path8());
        pstmt.setString(++rowIdx, dto.getImg_path9());
        pstmt.setString(++rowIdx, dto.getImg_path10());
        pstmt.setString(++rowIdx, dto.getImg_path11());
        pstmt.setString(++rowIdx, dto.getImg_path12());
        pstmt.setString(++rowIdx, dto.getImg_path13());
        pstmt.setString(++rowIdx, dto.getImg_path14());
        pstmt.setString(++rowIdx, dto.getImg_path15());
        pstmt.setString(++rowIdx, dto.getImg_path16());
        pstmt.setString(++rowIdx, dto.getImg_path17());
        pstmt.setString(++rowIdx, dto.getImg_path18());
        pstmt.setString(++rowIdx, dto.getImg_path19());
        pstmt.setString(++rowIdx, dto.getImg_path20());
        pstmt.setString(++rowIdx, dto.getImg_path21());
        pstmt.setString(++rowIdx, dto.getImg_path22());
        pstmt.setString(++rowIdx, dto.getImg_path23());
        pstmt.setString(++rowIdx, dto.getImg_path24());
        pstmt.setString(++rowIdx, dto.getGoods_remarks());
        pstmt.setString(++rowIdx, dto.getCert_type());
        pstmt.setString(++rowIdx, dto.getCert());
        pstmt.setString(++rowIdx, dto.getCertno());
        pstmt.setString(++rowIdx, dto.getAvlst_dm());
        pstmt.setString(++rowIdx, dto.getAvled_dm());
        pstmt.setString(++rowIdx, dto.getIssuedate());
        pstmt.setString(++rowIdx, dto.getCertdate());
        pstmt.setString(++rowIdx, dto.getCert_agency());
        pstmt.setString(++rowIdx, dto.getCertfield());
        pstmt.setString(++rowIdx, dto.getCertmodel());
        pstmt.setString(++rowIdx, dto.getCertname());
        pstmt.setString(++rowIdx, dto.getExemptiontype());
        pstmt.setString(++rowIdx, dto.getMaterial());
        pstmt.setString(++rowIdx, dto.getStock_use_yn());
        pstmt.setString(++rowIdx, dto.getOpt_type());
        pstmt.setString(++rowIdx, dto.getProp_edit_yn());
        pstmt.setString(++rowIdx, dto.getProp1_cd());
        pstmt.setString(++rowIdx, dto.getProp_val1());
        pstmt.setString(++rowIdx, dto.getProp_val2());
        pstmt.setString(++rowIdx, dto.getProp_val3());
        pstmt.setString(++rowIdx, dto.getProp_val4());
        pstmt.setString(++rowIdx, dto.getProp_val5());
        pstmt.setString(++rowIdx, dto.getProp_val6());
        pstmt.setString(++rowIdx, dto.getProp_val7());
        pstmt.setString(++rowIdx, dto.getProp_val8());
        pstmt.setString(++rowIdx, dto.getProp_val9());
        pstmt.setString(++rowIdx, dto.getProp_val10());
        pstmt.setString(++rowIdx, dto.getProp_val11());
        pstmt.setString(++rowIdx, dto.getProp_val12());
        pstmt.setString(++rowIdx, dto.getProp_val13());
        pstmt.setString(++rowIdx, dto.getProp_val14());
        pstmt.setString(++rowIdx, dto.getProp_val15());
        pstmt.setString(++rowIdx, dto.getProp_val16());
        pstmt.setString(++rowIdx, dto.getProp_val17());
        pstmt.setString(++rowIdx, dto.getProp_val18());
        pstmt.setString(++rowIdx, dto.getProp_val19());
        pstmt.setString(++rowIdx, dto.getProp_val20());
        pstmt.setString(++rowIdx, dto.getProp_val21());
        pstmt.setString(++rowIdx, dto.getProp_val22());
        pstmt.setString(++rowIdx, dto.getProp_val23());
        pstmt.setString(++rowIdx, dto.getProp_val24());
        pstmt.setString(++rowIdx, dto.getProp_val25());
        pstmt.setString(++rowIdx, dto.getProp_val26());
        pstmt.setString(++rowIdx, dto.getProp_val27());
        pstmt.setString(++rowIdx, dto.getProp_val28());
        pstmt.setString(++rowIdx, dto.getPack_code_str());
        pstmt.setString(++rowIdx, dto.getGoods_nm_en());
        pstmt.setString(++rowIdx, dto.getGoods_nm_pr());
        pstmt.setString(++rowIdx, dto.getGoods_remarks2());
        pstmt.setString(++rowIdx, dto.getGoods_remarks3());
        pstmt.setString(++rowIdx, dto.getGoods_remarks4());
        pstmt.setString(++rowIdx, dto.getImportno());
        pstmt.setString(++rowIdx, dto.getGoods_cost2());
        pstmt.setString(++rowIdx, dto.getOrigin2());
        pstmt.setString(++rowIdx, dto.getExpire_dm());
        pstmt.setString(++rowIdx, dto.getSupply_save_yn());
        pstmt.setString(++rowIdx, dto.getDescrition());
        pstmt.setString(++rowIdx, dto.getInsertdt());
        pstmt.setString(++rowIdx, dto.getInsertid());
        pstmt.setString(++rowIdx, dto.getModifydt());
        pstmt.setString(++rowIdx, dto.getModifyid());
        pstmt.setString(++rowIdx, dto.getSaleenddt());
        pstmt.setString(++rowIdx, dto.getSendstats());
        pstmt.setString(++rowIdx, dto.getShopmodifycontent());
        pstmt.setString(++rowIdx, dto.getSelfmod_no());
        pstmt.addBatch();
        pstmt.clearParameters();
        return pstmt;
    }

    private PreparedStatement update(ProductDTO dto, Connection connection, List<PreparedStatement> statementlist, PreparedStatement pstmt) throws Exception {
        int rowIdx = 0;
        pstmt.setString(++rowIdx, dto.getShopseq());
        pstmt.setString(++rowIdx, dto.getShopprodno());
        pstmt.setString(++rowIdx, dto.getSendstats());
        pstmt.setString(++rowIdx, dto.getSaleenddt());
        pstmt.setString(++rowIdx, dto.getCompayny_goods_cd());
        pstmt.setString(++rowIdx, dto.getShop_cid_info().equals("") ? null : dto.getShop_cid_info());
        pstmt.setString(++rowIdx, dto.getGoods_price());
        pstmt.setString(++rowIdx, dto.getMarket_price());
        pstmt.setString(++rowIdx, dto.getGoods_consumer_price());
        pstmt.setString(++rowIdx, dto.getImg_path22());
        pstmt.setString(++rowIdx, dto.getSENDSEQ());
        pstmt.addBatch();
        pstmt.clearParameters();
        return pstmt;
    }

    private String getSqlSave() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO shopprodin ( ");
        sb.append("COMPNO ,\r\n");
        sb.append("SHOPCD ,\r\n");
        sb.append("PRODSEQ ,\r\n");
        sb.append("SHOP_USERID ,\r\n");
        sb.append("SHOPSEQ ,\r\n");
        sb.append("SHOPPRODNO ,\r\n");
        sb.append("SEQ ,\r\n");
        sb.append("SHOPCATNO ,\r\n");
        sb.append("GOODS_NM ,\r\n");
        sb.append("GOODS_KEYWORD ,\r\n");
        sb.append("MODEL_NM ,\r\n");
        sb.append("BRAND_NM ,\r\n");
        sb.append("COMPAYNY_GOODS_CD ,\r\n");
        sb.append("SHOP_CID_INFO ,\r\n");
        sb.append("GOODS_SEARCH ,\r\n");
        sb.append("GOODS_GUBUN ,\r\n");
        sb.append("SELECT_OPTION ,\r\n");
        sb.append("TEXT_OPTION ,\r\n");
        sb.append("CLASS_CD1 ,\r\n");
        sb.append("CLASS_CD2 ,\r\n");
        sb.append("CLASS_CD3 ,\r\n");
        sb.append("CLASS_CD4 ,\r\n");
        sb.append("GMCATEGNM ,\r\n");
        sb.append("PARTNER_ID ,\r\n");
        sb.append("DPARTNER_ID ,\r\n");
        sb.append("MAKER ,\r\n");
        sb.append("ORIGIN ,\r\n");
        sb.append("MAKE_YEAR ,\r\n");
        sb.append("MAKE_DM ,\r\n");
        sb.append("GOODS_SEASON ,\r\n");
        sb.append("SEX ,\r\n");
        sb.append("`STATUS` ,\r\n");
        sb.append("DELIV_ABLE_REGION ,\r\n");
        sb.append("TAX_YN ,\r\n");
        sb.append("DELV_TYPE ,\r\n");
        sb.append("DELV_COST ,\r\n");
        sb.append("DELV_QTY ,\r\n");
        sb.append("BANPUM_AREA ,\r\n");
        sb.append("GOODS_COST ,\r\n");
        sb.append("GOODS_PRICE ,\r\n");
        sb.append("MARKET_PRICE ,\r\n");
        sb.append("GOODS_CONSUMER_PRICE ,\r\n");
        sb.append("ISLIMIT ,\r\n");
        sb.append("LIMIT_PRICE ,\r\n");
        sb.append("IS_OVERSEAS ,\r\n");
        sb.append("ADULT ,\r\n");
        sb.append("ISRETURN ,\r\n");
        sb.append("ITYPE ,\r\n");
        sb.append("OPTIONYN ,\r\n");
        sb.append("CHAR_1_NM ,\r\n");
        sb.append("CHAR_1_VAL ,\r\n");
        sb.append("CHAR_2_NM ,\r\n");
        sb.append("CHAR_2_VAL ,\r\n");
        sb.append("IMG_PATH ,\r\n");
        sb.append("IMG_PATH1 ,\r\n");
        sb.append("IMG_PATH2 ,\r\n");
        sb.append("IMG_PATH3 ,\r\n");
        sb.append("IMG_PATH4 ,\r\n");
        sb.append("IMG_PATH5 ,\r\n");
        sb.append("IMG_PATH6 ,\r\n");
        sb.append("IMG_PATH7 ,\r\n");
        sb.append("IMG_PATH8 ,\r\n");
        sb.append("IMG_PATH9 ,\r\n");
        sb.append("IMG_PATH10 ,\r\n");
        sb.append("IMG_PATH11 ,\r\n");
        sb.append("IMG_PATH12 ,\r\n");
        sb.append("IMG_PATH13 ,\r\n");
        sb.append("IMG_PATH14 ,\r\n");
        sb.append("IMG_PATH15 ,\r\n");
        sb.append("IMG_PATH16 ,\r\n");
        sb.append("IMG_PATH17 ,\r\n");
        sb.append("IMG_PATH18 ,\r\n");
        sb.append("IMG_PATH19 ,\r\n");
        sb.append("IMG_PATH20 ,\r\n");
        sb.append("IMG_PATH21 ,\r\n");
        sb.append("IMG_PATH22 ,\r\n");
        sb.append("IMG_PATH23 ,\r\n");
        sb.append("IMG_PATH24 ,\r\n");
        sb.append("GOODS_REMARKS ,\r\n");
        sb.append("CERT_TYPE ,\r\n");
        sb.append("CERT ,\r\n");
        sb.append("CERTNO ,\r\n");
        sb.append("AVLST_DM ,\r\n");
        sb.append("AVLED_DM ,\r\n");
        sb.append("ISSUEDATE ,\r\n");
        sb.append("CERTDATE ,\r\n");
        sb.append("CERT_AGENCY ,\r\n");
        sb.append("CERTFIELD ,\r\n");
        sb.append("CERTMODEL ,\r\n");
        sb.append("CERTNAME ,\r\n");
        sb.append("EXEMPTIONTYPE ,\r\n");
        sb.append("MATERIAL ,\r\n");
        sb.append("STOCK_USE_YN ,\r\n");
        sb.append("OPT_TYPE ,\r\n");
        sb.append("PROP_EDIT_YN ,\r\n");
        sb.append("PROP1_CD ,\r\n");
        sb.append("PROP_VAL1 ,\r\n");
        sb.append("PROP_VAL2 ,\r\n");
        sb.append("PROP_VAL3 ,\r\n");
        sb.append("PROP_VAL4 ,\r\n");
        sb.append("PROP_VAL5 ,\r\n");
        sb.append("PROP_VAL6 ,\r\n");
        sb.append("PROP_VAL7 ,\r\n");
        sb.append("PROP_VAL8 ,\r\n");
        sb.append("PROP_VAL9 ,\r\n");
        sb.append("PROP_VAL10 ,\r\n");
        sb.append("PROP_VAL11 ,\r\n");
        sb.append("PROP_VAL12 ,\r\n");
        sb.append("PROP_VAL13 ,\r\n");
        sb.append("PROP_VAL14 ,\r\n");
        sb.append("PROP_VAL15 ,\r\n");
        sb.append("PROP_VAL16 ,\r\n");
        sb.append("PROP_VAL17 ,\r\n");
        sb.append("PROP_VAL18 ,\r\n");
        sb.append("PROP_VAL19 ,\r\n");
        sb.append("PROP_VAL20 ,\r\n");
        sb.append("PROP_VAL21 ,\r\n");
        sb.append("PROP_VAL22 ,\r\n");
        sb.append("PROP_VAL23 ,\r\n");
        sb.append("PROP_VAL24 ,\r\n");
        sb.append("PROP_VAL25 ,\r\n");
        sb.append("PROP_VAL26 ,\r\n");
        sb.append("PROP_VAL27 ,\r\n");
        sb.append("PROP_VAL28 ,\r\n");
        sb.append("PACK_CODE_STR ,\r\n");
        sb.append("GOODS_NM_EN ,\r\n");
        sb.append("GOODS_NM_PR ,\r\n");
        sb.append("GOODS_REMARKS2 ,\r\n");
        sb.append("GOODS_REMARKS3 ,\r\n");
        sb.append("GOODS_REMARKS4 ,\r\n");
        sb.append("IMPORTNO ,\r\n");
        sb.append("GOODS_COST2 ,\r\n");
        sb.append("ORIGIN2 ,\r\n");
        sb.append("EXPIRE_DM ,\r\n");
        sb.append("SUPPLY_SAVE_YN ,\r\n");
        sb.append("DESCRITION ,\r\n");
        sb.append("INSERTDT ,\r\n");
        sb.append("INSERTID ,\r\n");
        sb.append("MODIFYDT ,\r\n");
        sb.append("MODIFYID ,\r\n");
        sb.append("SALEENDDT ,\r\n");
        sb.append("SHOPSENDSTATUS ,\r\n");
        sb.append("SHOPMODIFYCONTENT ,\r\n");
        sb.append("SELFMOD_NO \r\n");
        sb.append(") values ( ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        return sb.toString();
    }

    private String getSqlupdate() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE shopprodin SET ");
        sb.append("SHOPSEQ = ? ,\r\n");
        sb.append("SHOPPRODNO = ? ,\r\n");
        sb.append("SHOPSENDSTATUS = ? ,\r\n");
        sb.append("SALEENDDT = ? ,\r\n");
        sb.append("COMPAYNY_GOODS_CD = ? ,\r\n");
        sb.append("SHOP_CID_INFO = ? ,\r\n");
        sb.append("GOODS_PRICE = ? ,\r\n");
        sb.append("MARKET_PRICE = ? ,\r\n");
        sb.append("GOODS_CONSUMER_PRICE = ?, \r\n");
        sb.append("IMG_PATH22 = ? \r\n");
        sb.append("where SENDSEQ = ? \r\n");
        return sb.toString();
    }

    public int isShopProductInExits(String prodseq, String userid, String compno, String shopcd, String shopseq) {
        int result;
        block12: {
            result = 0;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT SENDSEQ AS CNT FROM shopprodin WHERE compno = ? AND shopcd = ? AND prodseq = ? and shop_userid = ? and shopseq = ? ";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, compno);
                    pstmt_orddtl.setString(2, shopcd);
                    pstmt_orddtl.setString(3, prodseq);
                    pstmt_orddtl.setString(4, userid);
                    pstmt_orddtl.setString(5, shopseq);
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        result = rs.getInt("CNT");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<ProdReceiveSetDto> getProductReceiveSet(String shopcd) throws Exception {
        ArrayList<ProdReceiveSetDto> contents = new ArrayList<ProdReceiveSetDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select\tifnull(SEQ,''),\r\nifnull(COMPNO,''),\r\nifnull(USERID,''),\r\nifnull(TITLE,''),\r\nifnull(PARAM,'') FROM prodreceiveset WHERE USERID = ? and shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getUserId());
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[getProductReceiveSet]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProdReceiveSetDto dto = new ProdReceiveSetDto();
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setUserid(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setParam(rs.getString(++columnIndex));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int setInfoDelete(ProdReceiveSetDto dto) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from prodreceiveset where userid = ? and seq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dto.getUserid());
                pstmt.setString(2, dto.getSeq());
                YDMAStringUtil.Print("[shoppingMallDetailDelete]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public shopAuctionAdditionDto getAdditionaAuction2OneList1(int seq, String shopcd, String shopseq) throws Exception {
        shopAuctionAdditionDto dto = new shopAuctionAdditionDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SEQ,''),ifnull(COMPNO,''),ifnull(SHOPCD,''),ifnull(SHOPSEQ,''),ifnull(SHOPID,''),ifnull(TITLE,''),ifnull(BRAND,''),ifnull(BRAND1,''),ifnull(BRAND2,''),ifnull(BRAND3,''),ifnull(SEARCHPRODNM,''),ifnull(RPOMOTIONPRODNM,''),ifnull(SALEPERIOD,''),ifnull(SELLERDISCOUNT,''),ifnull(SELLERDISCOUNT1,''),ifnull(SELLERDISCOUNT2,''),ifnull(SELLERSTARTDATE,''),ifnull(SELLERDENDDATE,''),ifnull(MAXIMUMBUY,''),ifnull(MAXIMUMBUYVALUE1,''),ifnull(MAXIMUMBUYVALUE2,''),ifnull(MAXIMUMBUYVALUE3,''),ifnull(MAXIMUMBUYVALUE4,''),ifnull(MODELNAME,''),ifnull(PLURALORIGIN,''),ifnull(IMAGERESIZE,''),ifnull(IMAGERESIZE1,''),ifnull(PREORDERSALE,''),ifnull(PREORDERSALEVALUE1,''),ifnull(YOUTHBUY,''),ifnull(PORTALPRICE,''),ifnull(PRICECOMPARISON,''),ifnull(SITEDISCOUNT,''),ifnull(ISBN,''),ifnull(SPECIALDISCOUNT,''),ifnull(SPECIALSTARTDATE,''),ifnull(SPECIALENDDATE,''),ifnull(SPECIALDISCOUNT2,''),ifnull(SPECIALDISCOUNT3,''),ifnull(SPECIALDISCOUNT4,''),ifnull(SPECIALDISCOUNT5,''),ifnull(SPECIALDISCOUNT6,''),ifnull(SMILECASH,''),ifnull(SMILECASH1,''),ifnull(DONATION,''),ifnull(DONATIONSTARTDATE,''),ifnull(DONATIONENDDATE,''),ifnull(DONATION2,''),ifnull(SALLER_DC_RATE,''),ifnull(DC_RATE,''),ifnull(FLOAT_DC,''),ifnull(MARGIN_RATE,''),ifnull(COMMISSION_RATE,''),ifnull(SHIPMENTPOLICY,''),ifnull(DELIVERYMETHOD,''),ifnull(DELIVERYMETHOD1,''),ifnull(ADDDELIVERYP,''),ifnull(ADDDELIVERYQ,''),ifnull(ADDDELIVERY1,''),ifnull(ADDDELIVERY2,''),ifnull(ADDDELIVERY3,''),ifnull(ADDDELIVERY4,''),ifnull(OUTADDRESS,''),ifnull(DELIVERYFEESELECT1,''),ifnull(RETURNADDR,''),ifnull(RETEXCHDELIFEE,''),ifnull(COLLECTAPPLICATION,''),ifnull(COLLECTAPPLICATION1,''),ifnull(TITLEYN,''),ifnull(PRODNMOUTPUT,''),ifnull(PRODNMADDFRONT,''),ifnull(PRODNMADDBACK,''),ifnull(PRODDETAILFRONT,''),ifnull(PRODDETAILBACK,''),ifnull(PRODDETAILOUTPUT,''),ifnull(OTHERSPECIALNOTE,''),ifnull(FREEDELIVERY,''),ifnull(IMAGERESIZE1,''),ifnull(PREMIUM,''),ifnull(PREMIUM1,''),ifnull(PREMIUMPLUS,''),ifnull(PREMIUMPLUS1,''),ifnull(PRODNMVOLD,''),ifnull(PRODNMVOLD1,''),ifnull(EXPPRC,'2500'),\r\nIFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX, ''),IFNULL(CHANGESIZEY, ''),IFNULL(CHANGESIZEW, ''),IFNULL(CHANGESIZEH, ''),IFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL, ''), IFNULL(DETAILKEYWORDR, ''), IFNULL(DETAILPRODUCTCODEB,''), IFNULL(DETAILPRODUCTCODEL, ''), IFNULL(DETAILPRODUCTCODER, ''), IFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL, ''), IFNULL(DETAILPRODUCTNAMER, ''), IFNULL(ADDOPTIONLB, ''), IFNULL(ADDOPTIONL, ''), IFNULL(ADDOPTIONRB, ''), IFNULL(ADDOPTIONR, ''), IFNULL(IMGONEONONE, ''), IFNULL(IMGTHREEONFOUR, ''),\r\n IFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''), IMG_ANGLE, IMG_SCALE_PERCENT \r\n from shopauction2adddtl where seq=? and shopcd = ?and shopseq =? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                pstmt.setString(2, shopcd);
                pstmt.setString(3, shopseq);
                YDMAStringUtil.Print("[getAdditionaAuction2OneList1]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setBrand(rs.getString(++columnIndex));
                    dto.setBrand1(rs.getString(++columnIndex));
                    dto.setBrand2(rs.getString(++columnIndex));
                    dto.setBrand3(rs.getString(++columnIndex));
                    dto.setSearchProdnm(rs.getString(++columnIndex));
                    dto.setPromotionProdnm(rs.getString(++columnIndex));
                    dto.setSaleperiod(rs.getString(++columnIndex));
                    dto.setSellerdiscount(rs.getString(++columnIndex));
                    dto.setSellerdiscount1(rs.getString(++columnIndex));
                    dto.setSellerdiscount2(rs.getString(++columnIndex));
                    dto.setSellerstartdate(rs.getString(++columnIndex));
                    dto.setSellerendtdate(rs.getString(++columnIndex));
                    dto.setMaximumbuy(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue1(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue2(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue3(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue4(rs.getString(++columnIndex));
                    dto.setModelname(rs.getString(++columnIndex));
                    dto.setPluralorigin(rs.getString(++columnIndex));
                    dto.setImageresize(rs.getString(++columnIndex));
                    dto.setImageresize1(rs.getString(++columnIndex));
                    dto.setPreordersale(rs.getString(++columnIndex));
                    dto.setPreordersalevalue1(rs.getString(++columnIndex));
                    dto.setYouthbuy(rs.getString(++columnIndex));
                    dto.setPortalprice(rs.getString(++columnIndex));
                    dto.setPricecomparison(rs.getString(++columnIndex));
                    dto.setSitediscount(rs.getString(++columnIndex));
                    dto.setIsbn(rs.getString(++columnIndex));
                    dto.setSpecialdiscount(rs.getString(++columnIndex));
                    dto.setSpecialstartdate(rs.getString(++columnIndex));
                    dto.setSpecialenddate(rs.getString(++columnIndex));
                    dto.setSpecialdiscount2(rs.getString(++columnIndex));
                    dto.setSpecialdiscount3(rs.getString(++columnIndex));
                    dto.setSpecialdiscount4(rs.getString(++columnIndex));
                    dto.setSpecialdiscount5(rs.getString(++columnIndex));
                    dto.setSpecialdiscount6(rs.getString(++columnIndex));
                    dto.setSmilecash(rs.getString(++columnIndex));
                    dto.setSmilecash1(rs.getString(++columnIndex));
                    dto.setDonation(rs.getString(++columnIndex));
                    dto.setDonationstartdate(rs.getString(++columnIndex));
                    dto.setDonationenddate(rs.getString(++columnIndex));
                    dto.setDonation2(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setShipmentpolicy(rs.getString(++columnIndex));
                    dto.setDeliverymethod(rs.getString(++columnIndex));
                    dto.setDeliverymethod1(rs.getString(++columnIndex));
                    dto.setAdddeliveryP(rs.getString(++columnIndex));
                    dto.setAdddeliveryQ(rs.getString(++columnIndex));
                    dto.setAdddelivery1(rs.getString(++columnIndex));
                    dto.setAdddelivery2(rs.getString(++columnIndex));
                    dto.setAdddelivery3(rs.getString(++columnIndex));
                    dto.setAdddelivery4(rs.getString(++columnIndex));
                    dto.setOutaddress(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect1(rs.getString(++columnIndex));
                    dto.setReturnaddr(rs.getString(++columnIndex));
                    dto.setRetexchdelifee(rs.getString(++columnIndex));
                    dto.setCollectapplication(rs.getString(++columnIndex));
                    dto.setCollectapplication1(rs.getString(++columnIndex));
                    dto.setTitleyn(rs.getString(++columnIndex));
                    dto.setProdnmoutput(rs.getString(++columnIndex));
                    dto.setProdnmaddfront(rs.getString(++columnIndex));
                    dto.setProdnmaddback(rs.getString(++columnIndex));
                    dto.setProddetailfront(rs.getString(++columnIndex));
                    dto.setProddetailback(rs.getString(++columnIndex));
                    dto.setProddetailoutput(rs.getString(++columnIndex));
                    dto.setOtherspecialnote(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setImageresize1(rs.getString(++columnIndex));
                    dto.setPremium(rs.getString(++columnIndex));
                    dto.setPremium1(rs.getString(++columnIndex));
                    dto.setPremiumplus(rs.getString(++columnIndex));
                    dto.setPremiumplus1(rs.getString(++columnIndex));
                    dto.setProdnmvold(rs.getString(++columnIndex));
                    dto.setProdnmvold1(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setAngle(rs.getString(++columnIndex));
                    dto.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopGmarketAdditionDto getAdditionaGmarket2OneList(int seq, String shopcd) throws Exception {
        ShopGmarketAdditionDto dto = new ShopGmarketAdditionDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SEQ,''),ifnull(COMPNO,''),ifnull(SHOPCD,''),ifnull(SHOPSEQ,''),ifnull(SHOPID,''),ifnull(TITLE,''),ifnull(BRAND,''),ifnull(BRAND1,''),ifnull(BRAND2,''),ifnull(BRAND3,''),ifnull(SEARCHPRODNM,''),ifnull(PROMOTIONPRODNM,''),ifnull(SALEPERIOD,''),ifnull(SELLERDISCOUNT,''),ifnull(SELLERDISCOUNT1,''),ifnull(SELLERDISCOUNT2,''),ifnull(SELLERSTARTDAE,''),ifnull(SELLERENDDATE,''),ifnull(MAXIMUMBUY,''),ifnull(MAXIMUMBUYVALUE1,''),ifnull(MAXIMUMBUYVALUE2,''),ifnull(MAXIMUMBUYVALUE3,''),ifnull(MAXIMUMBUYVALUE4,''),ifnull(MODELNAME,''),ifnull(PLURALORIGIN,''),ifnull(IMAGERESIZE,''),ifnull(IMAGERESIZE1,''),ifnull(OVERSEASSALES,''),ifnull(YOUTHBUY,''),ifnull(PORTALPRICE,''),ifnull(SITEDISCOUNT,''),ifnull(ISBN,''),ifnull(PLURBUY,''),ifnull(PLURBUY1,''),ifnull(PLURBUYSTARTDATE,''),ifnull(PLURBUYENDDATE,''),ifnull(PLURBUY3,''),ifnull(PLURBUY4,''),ifnull(PLURBUY5,''),ifnull(PLURBUY6,''),ifnull(PLURBUY7,''),ifnull(SMILECASH,''),ifnull(SMILECASH1,''),ifnull(DONATION,''),ifnull(DONATIONSTARTDATE,''),ifnull(DONATIONENDDATE,''),ifnull(DONATION2,''),ifnull(DONATION3,''),ifnull(DONATION4,''),ifnull(SALLER_DC_RATE,''),ifnull(DC_RATE,''),ifnull(FLOAT_DC,''),ifnull(MARGIN_RATE,''),ifnull(COMMISSION_RATE,''),ifnull(SHIPMENTPOLICY,''),ifnull(DELIVERYMETHOD,''),ifnull(DELIVERYMETHOD1,''),ifnull(ADDDELIVERY,''),ifnull(ADDDELIVERY4,''),ifnull(ADDDELIVERY5,''),ifnull(ADDDELIVERY6,''),ifnull(ADDDELIVERY7,''),ifnull(OUTADDRESS,''),ifnull(RETURNADDR,''),ifnull(RETEXCHDELIFEE,''),ifnull(COLLECTAPPLICATION,''),ifnull(COLLECTAPPLICATION1,''),ifnull(TITLEYN,''),ifnull(OTHERSPECIALNOTE,''),ifnull(PRODNMOUTPUT,''),ifnull(PRODNMADDFRONT,''),ifnull(PRODNMADDBACK,''),ifnull(PRODDETAILFRONT,''),ifnull(PRODDETAILBACK,''),ifnull(PRODDETAILOUTPUT,''),ifnull(FOCUS,''),ifnull(FOCUS1,''),ifnull(FOCUSPLUS,''),ifnull(FOCUSPLUS1,''),ifnull(DELIVERYFEESELECT,''),ifnull(FREEDELIVERY,''),ifnull(IMAGERESIZE1,''),ifnull(EXPPRC,'2500'),\r\nIFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX, ''),IFNULL(CHANGESIZEY, ''),IFNULL(CHANGESIZEW, ''),IFNULL(CHANGESIZEH, ''),IFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL, ''), IFNULL(DETAILKEYWORDR, ''), IFNULL(DETAILPRODUCTCODEB,''), IFNULL(DETAILPRODUCTCODEL, ''), IFNULL(DETAILPRODUCTCODER, ''), IFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL, ''), IFNULL(DETAILPRODUCTNAMER, ''), IFNULL(ADDOPTIONLB, ''), IFNULL(ADDOPTIONL, ''), IFNULL(ADDOPTIONRB, ''), IFNULL(ADDOPTIONR, ''), IFNULL(IMGONEONONE, ''), IFNULL(IMGTHREEONFOUR, ''),\r\nIFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''), IMG_ANGLE, IMG_SCALE_PERCENT \r\nfrom shopgmarket2adddtl  where seq=? and shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, seq);
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[getAdditionaOneList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setBrand(rs.getString(++columnIndex));
                    dto.setBrand1(rs.getString(++columnIndex));
                    dto.setBrand2(rs.getString(++columnIndex));
                    dto.setBrand3(rs.getString(++columnIndex));
                    dto.setSearchprodnm(rs.getString(++columnIndex));
                    dto.setPromotionprodnm(rs.getString(++columnIndex));
                    dto.setSaleperiod(rs.getString(++columnIndex));
                    dto.setSellerdiscount(rs.getString(++columnIndex));
                    dto.setSellerdiscount1(rs.getString(++columnIndex));
                    dto.setSellerdiscount2(rs.getString(++columnIndex));
                    dto.setSellerstartdate(rs.getString(++columnIndex));
                    dto.setSellerenddate(rs.getString(++columnIndex));
                    dto.setMaximumbuy(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue1(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue2(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue3(rs.getString(++columnIndex));
                    dto.setMaximumbuyvalue4(rs.getString(++columnIndex));
                    dto.setModelname(rs.getString(++columnIndex));
                    dto.setPluralorigin(rs.getString(++columnIndex));
                    dto.setImageresize(rs.getString(++columnIndex));
                    dto.setImageresize1(rs.getString(++columnIndex));
                    dto.setOverseassales(rs.getString(++columnIndex));
                    dto.setYouthbuy(rs.getString(++columnIndex));
                    dto.setPortalprice(rs.getString(++columnIndex));
                    dto.setSitediscount(rs.getString(++columnIndex));
                    dto.setIsbn(rs.getString(++columnIndex));
                    dto.setPlurbuy(rs.getString(++columnIndex));
                    dto.setPlurbuy1(rs.getString(++columnIndex));
                    dto.setPlurbuystartdate(rs.getString(++columnIndex));
                    dto.setPlurbuyenddate(rs.getString(++columnIndex));
                    dto.setPlurbuy3(rs.getString(++columnIndex));
                    dto.setPlurbuy4(rs.getString(++columnIndex));
                    dto.setPlurbuy5(rs.getString(++columnIndex));
                    dto.setPlurbuy6(rs.getString(++columnIndex));
                    dto.setPlurbuy7(rs.getString(++columnIndex));
                    dto.setSmilecash(rs.getString(++columnIndex));
                    dto.setSmilecash1(rs.getString(++columnIndex));
                    dto.setDonation(rs.getString(++columnIndex));
                    dto.setDonationstartdate(rs.getString(++columnIndex));
                    dto.setDonationenddate(rs.getString(++columnIndex));
                    dto.setDonation2(rs.getString(++columnIndex));
                    dto.setDonation3(rs.getString(++columnIndex));
                    dto.setDonation4(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setShipmentpolicy(rs.getString(++columnIndex));
                    dto.setDeliverymethod(rs.getString(++columnIndex));
                    dto.setDeliverymethod1(rs.getString(++columnIndex));
                    dto.setAdddelivery(rs.getString(++columnIndex));
                    dto.setAdddelivery4(rs.getString(++columnIndex));
                    dto.setAdddelivery5(rs.getString(++columnIndex));
                    dto.setAdddelivery6(rs.getString(++columnIndex));
                    dto.setAdddelivery7(rs.getString(++columnIndex));
                    dto.setOutaddress(rs.getString(++columnIndex));
                    dto.setReturnaddr(rs.getString(++columnIndex));
                    dto.setRetexchdelifee(rs.getString(++columnIndex));
                    dto.setCollectapplication(rs.getString(++columnIndex));
                    dto.setCollectapplication1(rs.getString(++columnIndex));
                    dto.setTitleyn(rs.getString(++columnIndex));
                    dto.setOtherspecialnote(rs.getString(++columnIndex));
                    dto.setProdnmoutput(rs.getString(++columnIndex));
                    dto.setProdnmaddfront(rs.getString(++columnIndex));
                    dto.setProdnmaddback(rs.getString(++columnIndex));
                    dto.setProddetailfront(rs.getString(++columnIndex));
                    dto.setProddetailback(rs.getString(++columnIndex));
                    dto.setProddetailoutput(rs.getString(++columnIndex));
                    dto.setFocus(rs.getString(++columnIndex));
                    dto.setFocus1(rs.getString(++columnIndex));
                    dto.setFocusplus(rs.getString(++columnIndex));
                    dto.setFocusplus1(rs.getString(++columnIndex));
                    dto.setDeliveryfeeselect(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setImageresize1(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setAngle(rs.getString(++columnIndex));
                    dto.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopTmonAdditionalDto getAdditionaTmonOneList(int seq, String shopcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ShopTmonAdditionalDto dto = new ShopTmonAdditionalDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(SEQ, ''),IFNULL(COMPNO, ''),IFNULL(SHOPCD, ''),IFNULL(SHOPSEQ, ''),IFNULL(SHOPUSERID, ''), IFNULL(TITLE, ''),IFNULL(PRODPERIOD, ''),IFNULL(PRODUCTSTATUS, ''),IFNULL(SELLMETHOD, ''),IFNULL(ADULTCONFIRMATION, ''), IFNULL(PRODNMTOP, ''),IFNULL(ORIGINYN, ''),IFNULL(MAXQTYPERPERSON, ''),IFNULL(PURCHASELIMIT, ''),IFNULL(SEARCHEXPOSURE, ''), IFNULL(PRICECOMPARISON, ''),IFNULL(PRODMODIFYIMAGE, ''),IFNULL(FOREIGNPROD, ''),IFNULL(FOREIGNPRODVALUE, ''),IFNULL(SELLERDC, ''), IFNULL(DCRATE, ''),IFNULL(CUMDC, ''),IFNULL(MARGINDC, ''),IFNULL(COMMDC, ''),IFNULL(DELIVERYFEESRL, ''),IFNULL(DELIVERYCORPTYPE, ''), IFNULL(REFUNDTYPE, ''),IFNULL(REFUNDREASON, ''),IFNULL(DIFFERENTDELIVERYFEE, ''),IFNULL(DIFFERENTDELIVERYFEECONTENTS, ''), IFNULL(DELIVERYTEMPLATE, ''),IFNULL(NOTICEBATCHYN, ''),IFNULL(NOTICECD, ''),IFNULL(PRODOUTPUT, ''),IFNULL(PRODNMFIRST, ''),IFNULL(PRODNMLAST, ''), IFNULL(REMARKFIRST, ''),IFNULL(REMARKLAST, ''),IFNULL(REMARKOUTPUT, ''),IFNULL(FREEDELIVERY, ''),IFNULL(EXPPRC, '2500'),IFNULL(DELIVERYPRODUCTTYPE, ''),IFNULL(COLLECTIDENTIFY, ''),\r\n IFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX, ''),IFNULL(CHANGESIZEY, ''),IFNULL(CHANGESIZEW, ''),IFNULL(CHANGESIZEH, ''), IFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL, ''), IFNULL(DETAILKEYWORDR, ''),  IFNULL(DETAILPRODUCTCODEB,''), IFNULL(DETAILPRODUCTCODEL, ''), IFNULL(DETAILPRODUCTCODER, ''),  IFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL, ''), IFNULL(DETAILPRODUCTNAMER, ''),  IFNULL(ADDOPTIONLB, ''), IFNULL(ADDOPTIONL, ''), IFNULL(ADDOPTIONRB, ''), IFNULL(ADDOPTIONR, ''),\r\n IFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''), IMG_ANGLE, IMG_SCALE_PERCENT \r\n\tFROM shoptmonaddidtl where compno = ? and shopcd = ? and seq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setInt(3, seq);
                YDMAStringUtil.Print("[shopDetailjoinList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setShopuserid(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setProdperiod(rs.getString(++columnIndex));
                    dto.setProductstatus(rs.getString(++columnIndex));
                    dto.setSellmethod(rs.getString(++columnIndex));
                    dto.setAdultconfirmation(rs.getString(++columnIndex));
                    dto.setProdnmtop(rs.getString(++columnIndex));
                    dto.setOriginyn(rs.getString(++columnIndex));
                    dto.setMaxqtyperperson(rs.getString(++columnIndex));
                    dto.setPurchaselimit(rs.getString(++columnIndex));
                    dto.setSearchexposure(rs.getString(++columnIndex));
                    dto.setPricecomparison(rs.getString(++columnIndex));
                    dto.setProdmodifyimage(rs.getString(++columnIndex));
                    dto.setForeignprod(rs.getString(++columnIndex));
                    dto.setForeignprodvalue(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDeliveryfeesrl(rs.getString(++columnIndex));
                    dto.setDeliverycorptype(rs.getString(++columnIndex));
                    dto.setRefundtype(rs.getString(++columnIndex));
                    dto.setRefundreason(rs.getString(++columnIndex));
                    dto.setDifferentdeliveryfee(rs.getString(++columnIndex));
                    dto.setDifferentdeliveryfeecontents(rs.getString(++columnIndex));
                    dto.setDeliverytemplate(rs.getString(++columnIndex));
                    dto.setNoticebatchyn(rs.getString(++columnIndex));
                    dto.setNoticecd(rs.getString(++columnIndex));
                    dto.setProdoutput(rs.getString(++columnIndex));
                    dto.setProdnmfirst(rs.getString(++columnIndex));
                    dto.setProdnmlast(rs.getString(++columnIndex));
                    dto.setRemarkfirst(rs.getString(++columnIndex));
                    dto.setRemarklast(rs.getString(++columnIndex));
                    dto.setRemarkoutput(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                    dto.setDeliveryProductType(rs.getString(++columnIndex));
                    dto.setCollectIdentify(rs.getString(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setAngle(rs.getString(++columnIndex));
                    dto.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopWeMarketAdditionDto getAdditionaWeMarketOneList(int seq, String shopcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ShopWeMarketAdditionDto dto = new ShopWeMarketAdditionDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(SEQ, ''),IFNULL(COMPNO, ''),IFNULL(SHOPCD, ''),IFNULL(SHOPSEQ, ''),IFNULL(SHOPUSERID, ''),IFNULL(TITLE, ''), IFNULL(PRODUCTTYPE, ''),IFNULL(BRANDYN, ''),IFNULL(BRANDNM, ''),IFNULL(BRANDNO, ''),IFNULL(MAKERYN, ''),IFNULL(MAKERNM, ''),IFNULL(MAKERNO, ''),IFNULL(BIZYN, ''), IFNULL(DISPLAYYN, ''),IFNULL(DISPLAYONLYDEALYN, ''),IFNULL(TAXYN, ''),IFNULL(REFERENCEPRICETYPE, ''),IFNULL(SALEPERIODYN, ''), IFNULL(SALEENDPERIOD, ''),IFNULL(PURCHASEMINCOUNT, ''),IFNULL(PURCHASELIMITYN, ''),IFNULL(PURCHASELIMITDURATION, ''),IFNULL(PURCHASELIMITDAY, ''), IFNULL(PURCHASELIMITCOUNT, ''),IFNULL(BASKETLIMITYN, ''),IFNULL(IMAGERESIZEYN, ''),IFNULL(IMAGERESIZE, ''),IFNULL(PRICECOMPARISONSITEYN, ''), IFNULL(ADULTLIMITYN, ''),IFNULL(PARALLELIMPORTYN, ''),IFNULL(PARALLELIMPORTURL, ''),IFNULL(LABELNOLIST, ''),IFNULL(REVIEWDISP, ''),IFNULL(SELLERDC, ''), IFNULL(DCRATE, ''),IFNULL(CUMDC, ''),IFNULL(MARGINDC, ''),IFNULL(COMMDC, ''),IFNULL(SHIPPOLICYNO, ''),IFNULL(FREEDELIVERY, ''),IFNULL(NOTICEBATCHYN, ''), IFNULL(NOTICECD, ''),IFNULL(PRODOUTPUT, ''),IFNULL(PRODNMFIRST, ''),IFNULL(PRODNMLAST, ''),IFNULL(REMARKFIRST, ''),IFNULL(REMARKLAST, ''),IFNULL(REMARKOUTPUT,''),IFNULL(EXPPRC,'2500'), IFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX, ''),IFNULL(CHANGESIZEY, ''),IFNULL(CHANGESIZEW, ''),IFNULL(CHANGESIZEH, ''), IFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL, ''), IFNULL(DETAILKEYWORDR, ''),  IFNULL(DETAILPRODUCTCODEB,''), IFNULL(DETAILPRODUCTCODEL, ''), IFNULL(DETAILPRODUCTCODER, ''),  IFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL, ''), IFNULL(DETAILPRODUCTNAMER, ''),  IFNULL(ADDOPTIONLB, ''), IFNULL(ADDOPTIONL, ''), IFNULL(ADDOPTIONRB, ''), IFNULL(ADDOPTIONR, ''),  IFNULL(IMGONEONONE, ''), IFNULL(IMGTHREEONFOUR, ''), \r\n IFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''), IMG_ANGLE, IMG_SCALE_PERCENT \r\n\tFROM shopwemarketadddtl where compno = ? and shopcd = ? and seq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setInt(3, seq);
                YDMAStringUtil.Print("[shopDetailjoinList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setShopuserid(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setProducttype(rs.getString(++columnIndex));
                    dto.setBrandyn(rs.getString(++columnIndex));
                    dto.setBrandnm(rs.getString(++columnIndex));
                    dto.setBrandno(rs.getString(++columnIndex));
                    dto.setMakeryn(rs.getString(++columnIndex));
                    dto.setMakernm(rs.getString(++columnIndex));
                    dto.setMakerno(rs.getString(++columnIndex));
                    dto.setBizyn(rs.getString(++columnIndex));
                    dto.setDisplayyn(rs.getString(++columnIndex));
                    dto.setDisplayonlydealyn(rs.getString(++columnIndex));
                    dto.setTaxyn(rs.getString(++columnIndex));
                    dto.setReferencepricetype(rs.getString(++columnIndex));
                    dto.setSaleperiodyn(rs.getString(++columnIndex));
                    dto.setSaleendperiod(rs.getString(++columnIndex));
                    dto.setPurchasemincount(rs.getString(++columnIndex));
                    dto.setPurchaselimityn(rs.getString(++columnIndex));
                    dto.setPurchaselimitduration(rs.getString(++columnIndex));
                    dto.setPurchaselimitday(rs.getString(++columnIndex));
                    dto.setPurchaselimitcount(rs.getString(++columnIndex));
                    dto.setBasketlimityn(rs.getString(++columnIndex));
                    dto.setImageresizeyn(rs.getString(++columnIndex));
                    dto.setImageresize(rs.getString(++columnIndex));
                    dto.setPricecomparisonsiteyn(rs.getString(++columnIndex));
                    dto.setAdultlimityn(rs.getString(++columnIndex));
                    dto.setParallelimportyn(rs.getString(++columnIndex));
                    dto.setParallelimporturl(rs.getString(++columnIndex));
                    dto.setLabelnolist(rs.getString(++columnIndex));
                    dto.setReviewdisp(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setShippolicyno(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setNoticebatchyn(rs.getString(++columnIndex));
                    dto.setNoticecd(rs.getString(++columnIndex));
                    dto.setProdoutput(rs.getString(++columnIndex));
                    dto.setProdnmfirst(rs.getString(++columnIndex));
                    dto.setProdnmlast(rs.getString(++columnIndex));
                    dto.setRemarkfirst(rs.getString(++columnIndex));
                    dto.setRemarklast(rs.getString(++columnIndex));
                    dto.setRemarkoutput(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setAngle(rs.getString(++columnIndex));
                    dto.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public static String getInsertOrUpdateQueryMapper(List<String> lstInsert, List<String> lstUpdate, String tableName) {
        StringBuilder sb_result = new StringBuilder();
        sb_result.append(String.format("INSERT INTO %s ", tableName));
        String head = lstInsert.stream().collect(Collectors.joining(",", "(", ") "));
        String bottom = lstInsert.stream().map(p -> String.valueOf("?")).collect(Collectors.joining(",", " VALUES (", ") "));
        sb_result.append(head);
        sb_result.append(bottom);
        if (lstUpdate != null) {
            sb_result.append("\r\n ON DUPLICATE KEY  UPDATE \r\n");
            String str_update = lstUpdate.stream().map(p -> p.concat(" = ?")).collect(Collectors.joining(","));
            sb_result.append(str_update);
        }
        return sb_result.toString();
    }

    public void Category(ShopCatInfDto cateDto, ProductDTO dto, List<String> class_nm, String dome) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("COMPNO");
                lstInsert.add("DOME");
                lstInsert.add("SHOPCD");
                lstInsert.add("SHOPCATNO");
                lstInsert.add("SHOPCATNM");
                lstInsert.add("SHOPCATSITENM");
                lstInsert.add("EBAYCATCD");
                lstInsert.add("SHOPLAGCATCD");
                lstInsert.add("SHOPMIDCATCD");
                lstInsert.add("SHOPSMLCATCD");
                lstInsert.add("SHOPDETCATCD");
                lstInsert.add("SERVICEPROD");
                lstInsert.add("USE_YN");
                lstInsert.add("SHOPGENERAL");
                lstInsert.add("SHOPID");
                lstInsert.add("INSERTDT");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("SHOPCATNM");
                lstUpdate.add("SHOPCATSITENM");
                lstUpdate.add("EBAYCATCD");
                lstUpdate.add("SHOPLAGCATCD");
                lstUpdate.add("SHOPMIDCATCD");
                lstUpdate.add("SHOPSMLCATCD");
                lstUpdate.add("SHOPDETCATCD");
                lstUpdate.add("SERVICEPROD");
                lstUpdate.add("USE_YN");
                lstUpdate.add("SHOPGENERAL");
                lstUpdate.add("SHOPID");
                lstUpdate.add("MODIFYDT");
                String sql = ShopProductDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "shopcatinf");
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setString(++i, cateDto.getCompno());
                pstmt.setString(++i, dome);
                pstmt.setString(++i, cateDto.getShopcd());
                pstmt.setString(++i, cateDto.getShopcatno());
                pstmt.setString(++i, cateDto.getShopcatnm());
                pstmt.setString(++i, cateDto.getShopcatsitenm());
                pstmt.setString(++i, "");
                pstmt.setString(++i, cateDto.getShoplagcatcd());
                pstmt.setString(++i, cateDto.getShopmidcatcd());
                pstmt.setString(++i, cateDto.getShopsmlcatcd());
                pstmt.setString(++i, cateDto.getShopdetcatcd());
                pstmt.setString(++i, "\uc77c\ubc18\ubc30\uc1a1\uc0c1\ud488");
                pstmt.setString(++i, "Y");
                pstmt.setString(++i, "01");
                pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++i, cateDto.getShopcatnm());
                pstmt.setString(++i, cateDto.getShopcatsitenm());
                pstmt.setString(++i, "");
                pstmt.setString(++i, cateDto.getShoplagcatcd());
                pstmt.setString(++i, cateDto.getShopmidcatcd());
                pstmt.setString(++i, cateDto.getShopsmlcatcd());
                pstmt.setString(++i, cateDto.getShopdetcatcd());
                pstmt.setString(++i, "\uc77c\ubc18\ubc30\uc1a1\uc0c1\ud488");
                pstmt.setString(++i, "Y");
                pstmt.setString(++i, "01");
                pstmt.setString(++i, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.execute();
                connection.setAutoCommit(true);
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public static String getParentClassCd(String shopcd, String level, String code) throws Exception {
        ArrayList<ShopCateDto> list = new ArrayList<ShopCateDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT   IFNULL(UPCODE,'') AS UPCODE \r\n");
                sql.append(" FROM DOMECATEG  \r\n");
                sql.append(" WHERE SHOPCD= ? \r\n");
                sql.append(" AND LEVEL = ? \r\n");
                sql.append(" AND CODE = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, shopcd);
                pstmt.setString(2, level);
                pstmt.setString(3, code);
                YDMAStringUtil.Print("[getDomeParentClassCd]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto dto = new ShopCateDto();
                    dto.setUpcode(rs.getString("UPCODE"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list.size() == 0 ? "" : ((ShopCateDto)list.get(0)).getUpcode();
    }

    public static String getCateName(String shopcd, String code) throws Exception {
        ArrayList<ShopCateDto> list = new ArrayList<ShopCateDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT   IFNULL(NAME,'') AS NAME \r\n");
                sql.append(" FROM DOMECATEG  \r\n");
                sql.append(" WHERE SHOPCD= ? \r\n");
                sql.append(" AND CODE = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, shopcd);
                pstmt.setString(2, code);
                YDMAStringUtil.Print("[getDomeCateName]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto dto = new ShopCateDto();
                    dto.setName(rs.getString("NAME"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list.size() == 0 ? "" : ((ShopCateDto)list.get(0)).getName();
    }

    public static String getFullCateName(String shopcd, String code) throws Exception {
        ArrayList<ShopCateDto> list = new ArrayList<ShopCateDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT   IFNULL(FULLCAT,'') AS FULLCAT \r\n");
                sql.append(" FROM DOMECATEG  \r\n");
                sql.append(" WHERE SHOPCD= ? \r\n");
                sql.append(" AND CODE = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, shopcd);
                pstmt.setString(2, code);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto dto = new ShopCateDto();
                    dto.setName(rs.getString("FULLCAT"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list.size() == 0 ? "" : ((ShopCateDto)list.get(0)).getName();
    }

    public static String getFullCategoryName(String ID) throws Exception {
        ArrayList<ProductItemDto> list = new ArrayList<ProductItemDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT   IFNULL(FULL_NAME,'') AS FULL_NAME \r\n");
                sql.append(" FROM CATEGORY  \r\n");
                sql.append(" WHERE ID= ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductItemDto dto = new ProductItemDto();
                    dto.setCateg_nm(rs.getString("FULL_NAME"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list.size() == 0 ? "" : ((ProductItemDto)list.get(0)).getCateg_nm();
    }

    public static String toJson(Object obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ShopCateItem getCateJson(String catejson, String shopcd) throws Exception {
        ShopCateItem shopCateItem;
        block3: {
            shopCateItem = null;
            try {
                if (!catejson.equals("")) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        ShopCateItem[] shopcateItem = (ShopCateItem[])mapper.readValue(catejson, ShopCateItem[].class);
        shopCateItem = Arrays.asList(shopcateItem).stream().filter(p -> p.getShopcd().equals(shopcd)).findFirst().orElse(null);
        return shopCateItem;
    }

    public static String getCategoryInfo(String ID) throws Exception {
        String result;
        block6: {
            result = "";
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    conn = DBCPInit.getInstance().getConnection();
                    String sql = "SELECT SHOPCATE FROM category WHERE ID = ?";
                    pstmt = conn.prepareStatement(sql.toString().toUpperCase());
                    pstmt.setString(1, ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int columnIndex = 0;
                        result = rs.getString(++columnIndex);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(conn, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(conn, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(conn, pstmt, rs);
        }
        return result;
    }

    public String getGosiNum(String value) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ATTRCD FROM prodattr WHERE ATTRNM LIKE ?";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, "%" + value + "%");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public Map<String, Map<String, String>> setNaverNotice2() throws Exception {
        LinkedHashMap<String, Map<String, String>> result = new LinkedHashMap<String, Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String attrcd = "";
        boolean flag = true;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ATTRCD, COLSEQ, DOSINSEQ FROM prodattrnm WHERE DOSINSEQ IS NOT NULL;";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    map.put(rs.getString(2), rs.getString(3));
                    if (flag || rs.getString(1).equals(attrcd)) {
                        flag = false;
                        attrcd = rs.getString(1);
                        continue;
                    }
                    attrcd = rs.getString(1);
                    result.put(attrcd, map);
                    map.clear();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public HashMap<String, String> setNaverNotice(String gosiNum, List<String> prop) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ATTRNM, DOSINSEQ FROM prodattrnm WHERE ATTRCD LIKE ? AND INTERCODE IS NOT NULL AND INTERCODE != ''";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, "%" + gosiNum + "%");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result.put(rs.getString(++columnIndex), rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int getCateCid(String value) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT CODE FROM domecateg WHERE NAME LIKE ?";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, "%" + value + "%");
                YDMAStringUtil.Print("[getCateCid]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getInt(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String[] getProdSeq(String code) {
        String[] result;
        block12: {
            result = new String[9];
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT PRODSEQ,CLASS_CD1,CLASS_CD2,CLASS_CD3,SHOP_CID_INFO,CHAR_1_NM,CHAR_1_VAL,CHAR_2_NM,CHAR_2_VAL AS CNT FROM shopprodinfo WHERE COMPAYNY_GOODS_CD = ? AND COMPNO = ?";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, code);
                    pstmt_orddtl.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        int columnIndex = 0;
                        result[0] = rs.getString(++columnIndex);
                        result[1] = rs.getString(++columnIndex);
                        result[2] = rs.getString(++columnIndex);
                        result[3] = rs.getString(++columnIndex);
                        result[4] = rs.getString(++columnIndex);
                        result[5] = rs.getString(++columnIndex);
                        result[6] = rs.getString(++columnIndex);
                        result[7] = rs.getString(++columnIndex);
                        result[8] = rs.getString(++columnIndex);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String getShopCdTread(String shopcd) {
        String string = shopcd;
        string.hashCode();
        return null;
    }

    public ProductDTO getShopCdNNickNm(ProductDTO cateDto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ProductDTO dto = new ProductDTO();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(a.SHOPNM,''), IFNULL(b.NICKNM1,'') FROM shopinfo AS a LEFT JOIN shopdtl AS b ON a.SHOPCD = b.SHOPCD WHERE b.compno = ? and b.SHOPCD = ? AND b.SHOPSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, cateDto.getShopcd());
                pstmt.setString(3, cateDto.getShopseq());
                YDMAStringUtil.Print("[shopDetailjoinList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSHOPNM(rs.getString(++columnIndex));
                    dto.setNicknm(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopCateDto.MallCategoryList getShopCategorys(ProductDTO cateDto) throws Exception {
        ShopCateDto.MallCategoryList shopcatnm = new ShopCateDto.MallCategoryList();
        try {
            ShopCateItem shopCateItem = ShopProductDao.getCateJson(cateDto.getShop_cid_info(), cateDto.getShopcd());
            if (shopCateItem != null) {
                shopcatnm = this.getFindShopCategory(shopCateItem.getShopcd(), shopCateItem.getCid());
                if (shopcatnm.equals("")) {
                    shopcatnm.setCode(shopCateItem.getCid());
                }
                if (shopCateItem.getShopcd().equals("shop00671")) {
                    shopcatnm.setEsmcode(shopCateItem.getEsm_auction());
                } else if (shopCateItem.getShopcd().equals("shop00681")) {
                    shopcatnm.setEsmcode(shopCateItem.getEsm_gmarket());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return shopcatnm;
    }

    public String getShopCategoryCode(ProductDTO cateDto) throws Exception {
        ShopCateItem shopCateItem = ShopProductDao.getCateJson(cateDto.getShop_cid_info(), cateDto.getShopcd());
        if (shopCateItem == null) {
            return "";
        }
        return shopCateItem.getCid();
    }

    public ShopCateDto.MallCategoryList getFindShopCategory(String shopcd, String cid) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ShopCateDto.MallCategoryList shopcat = new ShopCateDto.MallCategoryList();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT CODE, SHOPCATENM, IFNULL(ESMCODE,''), IFNULL(ESMSHOPCATENM,'')  FROM SHOPCATEGORYS  WHERE SHOPCD = ?    AND CODE = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, cid);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    shopcat.setCode(rs.getString(++columnIndex));
                    shopcat.setShopcatenm(rs.getString(++columnIndex));
                    shopcat.setEsmcode(rs.getString(++columnIndex));
                    shopcat.setEsmshopcatenm(rs.getString(++columnIndex));
                    shopcat.setShopcd(shopcd);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return shopcat;
    }

    public Map<String, String> getExcelTemplete(String seq) throws Exception {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder queryBuilder = new StringBuilder();
                queryBuilder.append("SELECT\n").append("IFNULL(ExcelColumnName, '') AS ExcelColumnName,\n").append("IFNULL(ExcelColumnValue, '') AS ExcelColumnValue\n").append("FROM excelformdetail\n").append("WHERE MasterSeq = ?\n").append("ORDER BY ExcelColumnIndex;");
                String sql = queryBuilder.toString();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, Integer.parseInt(seq));
                YDMAStringUtil.Print("[getExcelTemplete]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String excelColumnName = rs.getString("ExcelColumnName");
                    String excelColumnValue = rs.getString("ExcelColumnValue");
                    result.put(excelColumnName, excelColumnValue);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<CodeItem> getDomeName(String service) throws Exception {
        ArrayList<CodeItem> result = new ArrayList<CodeItem>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder queryBuilder = new StringBuilder();
                queryBuilder.append("SELECT dome1.SHOPNM, IFNULL(dome.NICKNM1,'') AS NICKNM1, dome.SHOPCD, dome.SHOPSEQ\n").append("FROM shopdtldome AS dome\n").append("JOIN shopinfodome AS dome1 ON dome.SHOPCD = dome1.SHOPCD\n").append("WHERE dome.COMPNO = ?\n");
                String sql = queryBuilder.toString();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getDomeName]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    CodeItem dto = new CodeItem();
                    String name = rs.getString(++columnIndex);
                    dto.setSname(name);
                    String nicknm = rs.getString(++columnIndex);
                    nicknm = nicknm.equals("") ? name : String.valueOf(name) + "_" + nicknm;
                    dto.setName(nicknm);
                    dto.setCode(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    result.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<CodeItem> getDomeNameExcel(String service) throws Exception {
        ArrayList<CodeItem> result = new ArrayList<CodeItem>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder queryBuilder = new StringBuilder();
                queryBuilder.append("SELECT dome1.SHOPNM, IFNULL(dome.NICKNM1,'') AS NICKNM1, dome.SHOPCD, dome.SHOPSEQ\n").append("FROM shopdtldome AS dome\n").append("JOIN shopinfodome AS dome1 ON dome.SHOPCD = dome1.SHOPCD\n").append("WHERE dome.COMPNO = ?\n").append("UNION ALL\n").append("SELECT ExcelFormName AS SHOPNM,\n").append("'' AS NICKNM1,\n").append("'9999' AS SHOPCD,\n").append("SEQ AS SHOPSEQ\n").append("FROM excelformmaster\n").append("WHERE UseYn = 'Y';");
                String sql = queryBuilder.toString();
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getDomeName]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    CodeItem dto = new CodeItem();
                    String name = rs.getString(++columnIndex);
                    dto.setSname(name);
                    String nicknm = rs.getString(++columnIndex);
                    nicknm = nicknm.equals("") ? name : String.valueOf(name) + "_" + nicknm;
                    dto.setName(nicknm);
                    dto.setCode(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    result.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<CodeItem> getDelvName() throws Exception {
        ArrayList<CodeItem> result = new ArrayList<CodeItem>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT DLVNM, ifnull(USERID,''), ifnull(USERPW,''), DLVID FROM deliverys WHERE SERVICE_YN = 'Y' and USERID IS NOT NULL";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getDeliverys]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    CodeItem dto = new CodeItem();
                    String name = rs.getString(++columnIndex);
                    String nicknm = rs.getString(++columnIndex);
                    dto.setSname(nicknm);
                    nicknm = nicknm.equals("") ? name : String.valueOf(name) + "_" + nicknm;
                    dto.setName(nicknm);
                    dto.setUserpw(rs.getString(++columnIndex));
                    dto.setCode(rs.getString(++columnIndex));
                    result.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ProductDTO> getShopProductInEditSend(String dome) throws Exception {
        YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("    SELECT \r\n");
                sql.append("      IFNULL(A.PRODSEQ,'') AS PRODSEQ ,\r\n");
                sql.append("     IFNULL(A.COMPAYNY_GOODS_CD,'') AS COMPAYNY_GOODS_CD ,\r\n");
                sql.append("      IFNULL(A.COMPNO,'' ) AS COMPNO,\r\n");
                sql.append("   CONCAT(IFNULL(CLASS_CD1,''), IFNULL(CLASS_CD2,''), IFNULL(CLASS_CD3,''), IFNULL(CLASS_CD4,'')) AS CODE,\r\n");
                sql.append("      IFNULL(SHOPCD,'' ) AS SHOPCD,\r\n");
                sql.append("      IFNULL(SHOP_USERID,'' ) AS SHOP_USERID,\r\n");
                sql.append("       IFNULL(GOODS_NM,'' ) AS GOODS_NM,\r\n");
                sql.append("     IFNULL(GOODS_KEYWORD,'' ) AS GOODS_KEYWORD  ,\r\n");
                sql.append("     IFNULL(MODEL_NM,'' ) AS MODEL_NM  ,\r\n");
                sql.append(" IFNULL(BRAND_NM,'' ) AS BRAND_NM,  \r\n");
                sql.append(" IFNULL(GOODS_SEARCH,'' ) AS GOODS_SEARCH,  \r\n");
                sql.append(" IFNULL(GOODS_GUBUN,'' ) AS GOODS_GUBUN,  \r\n");
                sql.append(" IFNULL(SHOP_CID_INFO,'' ) AS SHOP_CID_INFO,  \r\n");
                sql.append(" IFNULL(CLASS_CD1,'' ) AS CLASS_CD1,  \r\n");
                sql.append(" IFNULL(CLASS_CD2,'' ) AS CLASS_CD2,  \r\n");
                sql.append(" IFNULL(CLASS_CD3,'' ) AS CLASS_CD3,  \r\n");
                sql.append(" IFNULL(CLASS_CD4,'' ) AS CLASS_CD4 ,\r\n");
                sql.append("  IFNULL(MAKER,'' ) AS MAKER,  \r\n");
                sql.append(" IFNULL(ORIGIN,'' ) AS ORIGIN,  \r\n");
                sql.append(" IFNULL(SEX,'' ) AS SEX,  \r\n");
                sql.append("   IFNULL(STATUS, '') AS STATUS,\r\n");
                sql.append(" IFNULL(DELIV_ABLE_REGION,'' ) AS DELIV_ABLE_REGION,  \r\n");
                sql.append(" IFNULL(TAX_YN,'' ) AS TAX_YN,  \r\n");
                sql.append(" IFNULL(CERT,'' ) AS CERT,  \r\n");
                sql.append("IFNULL(ISLIMIT,'' ) AS ISLIMIT,  \r\n");
                sql.append("IFNULL(LIMIT_PRICE,'' ) AS LIMIT_PRICE,  \r\n");
                sql.append("IFNULL(IS_OVERSEAS,'' ) AS IS_OVERSEAS,  \r\n");
                sql.append("IFNULL(ITYPE,'' ) AS ITYPE,              \r\n");
                sql.append("IFNULL(ADULT,'' ) AS ADULT,               \r\n");
                sql.append("IFNULL(ISRETURN,'' ) AS ISRETURN,         \r\n");
                sql.append("IFNULL(TEXT_OPTION,'' ) AS TEXT_OPTION,   \r\n");
                sql.append("IFNULL(DELV_TYPE,'' ) AS DELV_TYPE,  \r\n");
                sql.append(" IFNULL(DELV_COST,'' ) AS DELV_COST,  \r\n");
                sql.append(" IFNULL(BANPUM_AREA,'' ) AS BANPUM_AREA,  \r\n");
                sql.append(" IFNULL(GOODS_COST,'' ) AS GOODS_COST,  \r\n");
                sql.append(" IFNULL(GOODS_PRICE,'' ) AS GOODS_PRICE,  \r\n");
                sql.append(" IFNULL(GOODS_CONSUMER_PRICE,'' ) AS GOODS_CONSUMER_PRICE,  \r\n");
                sql.append(" IFNULL(CHAR_1_NM,'' ) AS CHAR_1_NM,  \r\n");
                sql.append(" IFNULL(CHAR_1_VAL,'' ) AS CHAR_1_VAL,  \r\n");
                sql.append(" IFNULL(CHAR_2_NM,'' ) AS CHAR_2_NM,  \r\n");
                sql.append(" IFNULL(CHAR_2_VAL,'' ) AS CHAR_2_VAL,  \r\n");
                sql.append(" IFNULL(IMG_PATH,'' ) AS IMG_PATH,  \r\n");
                sql.append(" IFNULL(IMG_PATH1,'' ) AS IMG_PATH1,  \r\n");
                sql.append(" IFNULL(IMG_PATH2,'' ) AS IMG_PATH2,  \r\n");
                sql.append(" IFNULL(IMG_PATH3,'' ) AS IMG_PATH3,  \r\n");
                sql.append(" IFNULL(IMG_PATH4,'' ) AS IMG_PATH4,  \r\n");
                sql.append(" IFNULL(IMG_PATH5,'' ) AS IMG_PATH5,  \r\n");
                sql.append(" IFNULL(IMG_PATH6,'' ) AS IMG_PATH6,  \r\n");
                sql.append(" IFNULL(IMG_PATH7,'' ) AS IMG_PATH7,  \r\n");
                sql.append(" IFNULL(IMG_PATH8,'' ) AS IMG_PATH8,  \r\n");
                sql.append(" IFNULL(IMG_PATH9,'' ) AS IMG_PATH9,  \r\n");
                sql.append(" IFNULL(IMG_PATH10,'' ) AS IMG_PATH10,  \r\n");
                sql.append(" IFNULL(IMG_PATH11,'' ) AS IMG_PATH11,  \r\n");
                sql.append(" IFNULL(IMG_PATH12,'' ) AS IMG_PATH12,  \r\n");
                sql.append(" IFNULL(GOODS_REMARKS,'' ) AS GOODS_REMARKS,  \r\n");
                sql.append(" IFNULL(CERT_TYPE,'' ) AS CERT_TYPE,   \r\n");
                sql.append(" IFNULL(CERTNO,'' ) AS CERTNO,  \r\n");
                sql.append(" IFNULL(AVLST_DM,'' ) AS AVLST_DM,  \r\n");
                sql.append(" IFNULL(AVLED_DM,'' ) AS AVLED_DM,  \r\n");
                sql.append(" IFNULL(ISSUEDATE,'' ) AS ISSUEDATE,  \r\n");
                sql.append(" IFNULL(CERTDATE,'' ) AS CERTDATE,  \r\n");
                sql.append(" IFNULL(CERT_AGENCY,'' ) AS CERT_AGENCY,  \r\n");
                sql.append(" IFNULL(CERTFIELD,'' ) AS CERTFIELD,  \r\n");
                sql.append(" IFNULL(MATERIAL,'' ) AS MATERIAL,  \r\n");
                sql.append(" IFNULL(STOCK_USE_YN,'' ) AS STOCK_USE_YN,  \r\n");
                sql.append(" IFNULL(OPT_TYPE,'' ) AS OPT_TYPE,  \r\n");
                sql.append(" IFNULL(PROP_EDIT_YN,'' ) AS PROP_EDIT_YN,  \r\n");
                sql.append(" IFNULL(PROP1_CD,'' ) AS PROP1_CD,  \r\n");
                sql.append(" IFNULL(PROP_VAL1,'' ) AS PROP_VAL1,  \r\n");
                sql.append(" IFNULL(PROP_VAL2,'' ) AS PROP_VAL2,  \r\n");
                sql.append(" IFNULL(PROP_VAL3,'' ) AS PROP_VAL3,  \r\n");
                sql.append(" IFNULL(PROP_VAL4,'' ) AS PROP_VAL4,  \r\n");
                sql.append(" IFNULL(PROP_VAL5,'' ) AS PROP_VAL5,  \r\n");
                sql.append(" IFNULL(PROP_VAL6,'' ) AS PROP_VAL6,  \r\n");
                sql.append(" IFNULL(PROP_VAL7,'' ) AS PROP_VAL7,  \r\n");
                sql.append(" IFNULL(PROP_VAL8,'' ) AS PROP_VAL8,  \r\n");
                sql.append(" IFNULL(PROP_VAL9,'' ) AS PROP_VAL9,  \r\n");
                sql.append(" IFNULL(PROP_VAL10,'' ) AS PROP_VAL10,  \r\n");
                sql.append(" IFNULL(PROP_VAL11,'' ) AS PROP_VAL11,  \r\n");
                sql.append(" IFNULL(PROP_VAL12,'' ) AS PROP_VAL12,  \r\n");
                sql.append(" IFNULL(PROP_VAL13,'' ) AS PROP_VAL13,  \r\n");
                sql.append(" IFNULL(PROP_VAL14,'' ) AS PROP_VAL14,  \r\n");
                sql.append(" IFNULL(PROP_VAL15,'' ) AS PROP_VAL15,  \r\n");
                sql.append(" IFNULL(PROP_VAL16,'' ) AS PROP_VAL16,  \r\n");
                sql.append(" IFNULL(PROP_VAL17,'' ) AS PROP_VAL17,  \r\n");
                sql.append(" IFNULL(PROP_VAL18,'' ) AS PROP_VAL18,  \r\n");
                sql.append(" IFNULL(PROP_VAL19,'' ) AS PROP_VAL19,  \r\n");
                sql.append(" IFNULL(PROP_VAL20,'' ) AS PROP_VAL20,  \r\n");
                sql.append(" IFNULL(PROP_VAL21,'' ) AS PROP_VAL21,  \r\n");
                sql.append(" IFNULL(PROP_VAL22,'' ) AS PROP_VAL22,  \r\n");
                sql.append(" IFNULL(PROP_VAL23,'' ) AS PROP_VAL23,  \r\n");
                sql.append(" IFNULL(PROP_VAL24,'' ) AS PROP_VAL24,  \r\n");
                sql.append(" IFNULL(PROP_VAL25,'' ) AS PROP_VAL25,  \r\n");
                sql.append(" IFNULL(PROP_VAL26,'' ) AS PROP_VAL26,  \r\n");
                sql.append(" IFNULL(PROP_VAL27,'' ) AS PROP_VAL27,  \r\n");
                sql.append(" IFNULL(PROP_VAL28,'' ) AS PROP_VAL28,  \r\n");
                sql.append(" IFNULL(PACK_CODE_STR,'' ) AS PACK_CODE_STR,  \r\n");
                sql.append(" IFNULL(IMPORTNO,'' ) AS IMPORTNO,  \r\n");
                sql.append(" IFNULL(GOODS_COST2,'' ) AS GOODS_COST2,  \r\n");
                sql.append(" IFNULL(ORIGIN2,'' ) AS ORIGIN2,  \r\n");
                sql.append(" IFNULL(EXPIRE_DM,'' ) AS EXPIRE_DM,  \r\n");
                sql.append(" IFNULL(SUPPLY_SAVE_YN,'' ) AS SUPPLY_SAVE_YN,  \r\n");
                sql.append(" IFNULL(DESCRITION,'' ) AS DESCRITION,  \r\n");
                sql.append(" IFNULL(SHOPPRODNO,'' ) AS SHOPPRODNO,  \r\n");
                sql.append(" IFNULL(INSERTDT,'' ) AS INSERTDT,  \r\n");
                sql.append(" IFNULL(INSERTID,'' ) AS INSERTID,  \r\n");
                sql.append(" IFNULL(MODIFYDT,'' ) AS MODIFYDT,  \r\n");
                sql.append(" IFNULL(MODIFYID, '' ) AS MODIFYID,  \r\n");
                sql.append(" IFNULL(SEQ, '' ) AS SEQ,  \r\n");
                sql.append(" IFNULL(MARKET_PRICE, '0' ) AS MARKET_PRICE,  \r\n");
                sql.append(" IFNULL(ShopSendStatus, '' ) AS ShopSendStatus, \r\n");
                sql.append(" IFNULL(SHOPSEQ, '' ) AS SHOPSEQ, \r\n");
                sql.append(" IFNULL(GMCATEGNM, '' ) AS GMCATEGNM, \r\n");
                sql.append(" IFNULL(SALEENDDT, '' ) AS SALEENDDT, \r\n");
                sql.append(" IFNULL(DELV_QTY, '' ) AS DELV_QTY, \r\n");
                sql.append(" IFNULL(SHOPMODIFYCONTENT, '') AS SHOPMODIFYCONTENT, \r\n");
                sql.append(" IFNULL(SELFMOD_NO, '' ) AS SELFMOD_NO, \r\n");
                sql.append(" IFNULL(A.Sendseq,'' ) AS Sendseq \r\n");
                sql.append(" FROM SHOPPRODIN AS A ");
                sql.append(String.format(" WHERE COMPNO = ? AND SHOPPRODNO <>'' AND (SEQ <>'0' AND SEQ IS NOT NULL) AND GOODS_KEYWORD = ?  AND (SHOPSENDSTATUS = %d OR SHOPSENDSTATUS = %d) ORDER BY SHOPCD", 7000, 6000));
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dome);
                YDMAStringUtil.Print("[getShopProductList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                List<ShopProdAttrnmDto> shopProdAttrnmAll = this.getProductNoticeAll();
                while (rs.next()) {
                    ProductDTO dto = new ProductDTO();
                    dto.setCode(rs.getString("CODE"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setSHOP_USERID(rs.getString("SHOP_USERID"));
                    dto.setSENDSEQ(rs.getString("SENDSEQ"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setPRODSEQ(rs.getString("PRODSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setGoods_nm(rs.getString("GOODS_NM"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setModel_nm(rs.getString("MODEL_NM"));
                    dto.setBrand_nm(rs.getString("BRAND_NM"));
                    dto.setCompayny_goods_cd(rs.getString("COMPAYNY_GOODS_CD"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setGoods_gubun(rs.getString("GOODS_GUBUN"));
                    if (rs.getString("SHOP_CID_INFO").equals("")) {
                        DomesinShopDao.get();
                        String[] chgitems = DomesinShopDao.isShopProductInfoEditExits(rs.getString("COMPNO"), rs.getString("COMPAYNY_GOODS_CD"), rs.getString("PRODSEQ"));
                        dto.setShop_cid_info(chgitems[13]);
                    } else {
                        dto.setShop_cid_info(rs.getString("SHOP_CID_INFO"));
                    }
                    dto.setClass_cd1(rs.getString("CLASS_CD1"));
                    dto.setClass_cd2(rs.getString("CLASS_CD2"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setClass_cd4(rs.getString("CLASS_CD4"));
                    dto.setPartner_id("");
                    dto.setDpartner_id("");
                    dto.setMaker(rs.getString("MAKER"));
                    dto.setOrigin(rs.getString("ORIGIN"));
                    dto.setMake_year("");
                    dto.setMake_dm("");
                    dto.setGoods_season("");
                    dto.setSex(rs.getString("SEX"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setDeliv_able_region(rs.getString("DELIV_ABLE_REGION"));
                    dto.setTax_yn(rs.getString("TAX_YN"));
                    dto.setDelv_type(rs.getString("DELV_TYPE"));
                    dto.setDelv_cost(rs.getString("DELV_COST"));
                    dto.setBanpum_area(rs.getString("BANPUM_AREA"));
                    dto.setGoods_cost(rs.getString("GOODS_COST"));
                    dto.setGoods_price(rs.getString("GOODS_PRICE"));
                    dto.setMarket_price(rs.getString("MARKET_PRICE"));
                    dto.setGoods_consumer_price(rs.getString("GOODS_CONSUMER_PRICE"));
                    dto.setMarket_price(rs.getString("MARKET_PRICE"));
                    dto.setChar_1_nm(rs.getString("CHAR_1_NM"));
                    dto.setChar_1_val(rs.getString("CHAR_1_VAL"));
                    dto.setChar_2_nm(rs.getString("CHAR_2_NM"));
                    dto.setChar_2_val(rs.getString("CHAR_2_VAL"));
                    dto.setImg_path(rs.getString("IMG_PATH"));
                    dto.setImg_path1(rs.getString("IMG_PATH1"));
                    dto.setImg_path2(rs.getString("IMG_PATH2"));
                    dto.setImg_path3(rs.getString("IMG_PATH3"));
                    dto.setImg_path4(rs.getString("IMG_PATH4"));
                    dto.setImg_path5(rs.getString("IMG_PATH5"));
                    dto.setImg_path6(rs.getString("IMG_PATH6"));
                    dto.setImg_path7(rs.getString("IMG_PATH7"));
                    dto.setImg_path8(rs.getString("IMG_PATH8"));
                    dto.setImg_path9(rs.getString("IMG_PATH9"));
                    dto.setImg_path10(rs.getString("IMG_PATH10"));
                    dto.setImg_path11(rs.getString("IMG_PATH11"));
                    dto.setImg_path12(rs.getString("IMG_PATH12"));
                    dto.setGoods_remarks(rs.getString("GOODS_REMARKS"));
                    dto.setCert_type(rs.getString("CERT_TYPE"));
                    dto.setCertmodel("");
                    dto.setCertname("");
                    dto.setExemptiontype("");
                    dto.setCertno(rs.getString("CERTNO"));
                    dto.setAvlst_dm(rs.getString("AVLST_DM"));
                    dto.setAvled_dm(rs.getString("AVLED_DM"));
                    dto.setIssuedate(rs.getString("ISSUEDATE"));
                    dto.setCertdate(rs.getString("CERTDATE"));
                    dto.setCert_agency(rs.getString("CERT_AGENCY"));
                    dto.setCertfield(rs.getString("CERTFIELD"));
                    dto.setMaterial(rs.getString("MATERIAL"));
                    dto.setStock_use_yn(rs.getString("STOCK_USE_YN"));
                    dto.setOpt_type(rs.getString("OPT_TYPE"));
                    dto.setProp_edit_yn(rs.getString("PROP_EDIT_YN"));
                    dto.setProp1_cd(rs.getString("PROP1_CD"));
                    dto.setProp_val1(rs.getString("PROP_VAL1"));
                    dto.setProp_val2(rs.getString("PROP_VAL2"));
                    dto.setProp_val3(rs.getString("PROP_VAL3"));
                    dto.setProp_val4(rs.getString("PROP_VAL4"));
                    dto.setProp_val5(rs.getString("PROP_VAL5"));
                    dto.setProp_val6(rs.getString("PROP_VAL6"));
                    dto.setProp_val7(rs.getString("PROP_VAL7"));
                    dto.setProp_val8(rs.getString("PROP_VAL8"));
                    dto.setProp_val9(rs.getString("PROP_VAL9"));
                    dto.setProp_val10(rs.getString("PROP_VAL10"));
                    dto.setProp_val11(rs.getString("PROP_VAL11"));
                    dto.setProp_val12(rs.getString("PROP_VAL12"));
                    dto.setProp_val13(rs.getString("PROP_VAL13"));
                    dto.setProp_val14(rs.getString("PROP_VAL14"));
                    dto.setProp_val15(rs.getString("PROP_VAL15"));
                    dto.setProp_val16(rs.getString("PROP_VAL16"));
                    dto.setProp_val17(rs.getString("PROP_VAL17"));
                    dto.setProp_val18(rs.getString("PROP_VAL18"));
                    dto.setProp_val19(rs.getString("PROP_VAL19"));
                    dto.setProp_val20(rs.getString("PROP_VAL20"));
                    dto.setProp_val21(rs.getString("PROP_VAL21"));
                    dto.setProp_val22(rs.getString("PROP_VAL22"));
                    dto.setProp_val23(rs.getString("PROP_VAL23"));
                    dto.setProp_val24(rs.getString("PROP_VAL24"));
                    dto.setProp_val25(rs.getString("PROP_VAL25"));
                    dto.setProp_val26(rs.getString("PROP_VAL26"));
                    dto.setProp_val27(rs.getString("PROP_VAL27"));
                    dto.setProp_val28(rs.getString("PROP_VAL28"));
                    dto.setPack_code_str(rs.getString("PACK_CODE_STR"));
                    dto.setGoods_nm_en("");
                    dto.setGoods_nm_pr("");
                    dto.setGoods_remarks2("");
                    dto.setGoods_remarks3("");
                    dto.setGoods_remarks4("");
                    dto.setImportno(rs.getString("IMPORTNO"));
                    dto.setGoods_cost2(rs.getString("GOODS_COST2"));
                    dto.setOrigin2(rs.getString("ORIGIN2"));
                    dto.setExpire_dm(rs.getString("EXPIRE_DM"));
                    dto.setSupply_save_yn(rs.getString("SUPPLY_SAVE_YN"));
                    dto.setDescrition(rs.getString("DESCRITION"));
                    dto.setShopprodno(rs.getString("SHOPPRODNO"));
                    dto.setInsertdt(rs.getString("INSERTDT"));
                    dto.setInsertid(rs.getString("INSERTID"));
                    dto.setModifydt(rs.getString("MODIFYDT"));
                    dto.setModifyid(rs.getString("MODIFYID"));
                    dto.setCert(rs.getString("CERT"));
                    dto.setIslimit(rs.getString("ISLIMIT"));
                    dto.setLimit_price(rs.getString("LIMIT_PRICE"));
                    dto.setIs_overseas(rs.getString("IS_OVERSEAS"));
                    dto.setItype(rs.getString("ITYPE"));
                    dto.setAdult(rs.getString("ADULT"));
                    dto.setIsreturn(rs.getString("ISRETURN"));
                    dto.setText_option(rs.getString("TEXT_OPTION"));
                    dto.setGmcategnm(rs.getString("GMCATEGNM"));
                    dto.setGoods_gubun_nm("");
                    dto.setSendstats(rs.getString("SHOPSENDSTATUS"));
                    dto.setSaleenddt(rs.getString("SALEENDDT"));
                    dto.setShopmodifycontent(rs.getString("SHOPMODIFYCONTENT"));
                    dto.setSelfmod_no(rs.getString("SELFMOD_NO"));
                    dto.setDelivery_qty(rs.getString("DELV_QTY"));
                    if (YDMASessonUtil.getLoginType() == 2) {
                        String class_cd4 = rs.getString("CLASS_CD4");
                        String class_cd3 = rs.getString("CLASS_CD3");
                        String shop_cid = !class_cd4.isEmpty() ? class_cd4 : class_cd3;
                        String full_cateName = DomesinSessonUtil.get().getFullCateName(shop_cid);
                        if (full_cateName.equals("")) {
                            String shopcd = rs.getString("GOODS_KEYWORD");
                            full_cateName = MLinkShopDao.getFullCateName(shopcd, shop_cid);
                        }
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    } else {
                        List<String> ret = Arrays.asList(dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4());
                        String shop_cid = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining());
                        ret = Arrays.asList(dto.getClass_nm1(), dto.getClass_nm2(), dto.getClass_nm3(), dto.getClass_nm4());
                        String full_cateName = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining(">"));
                        dto.setCode(shop_cid);
                        dto.setClass_nm1(full_cateName);
                    }
                    dto.setShopProdAttrnmDtos(shopProdAttrnmAll);
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void shopProdInfoCategory(List<ProductDTO> list, String modifyNo) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "UPDATE SHOPPRODINFO SET  SHOP_CID_INFO=?,GMCATEGNM = ? ,SELFMOD_NO = ?, SHOPSENDSTATUS = ? where COMPAYNY_GOODS_CD=? and PRODSEQ =?and COMPNO =?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductDTO dto : list) {
                    int i = 0;
                    pstmt.setString(++i, dto.getShop_cid_info());
                    pstmt.setString(++i, dto.getGmcategnm());
                    if (dto.getSelfmod_no().equals("")) {
                        pstmt.setString(++i, ":" + modifyNo);
                    } else if (dto.getSelfmod_no().contains(modifyNo)) {
                        pstmt.setString(++i, dto.getSelfmod_no());
                    } else {
                        pstmt.setString(++i, String.valueOf(dto.getSelfmod_no()) + ":" + modifyNo);
                    }
                    pstmt.setInt(++i, 6100);
                    pstmt.setString(++i, dto.getCompayny_goods_cd());
                    pstmt.setString(++i, dto.getPRODSEQ());
                    pstmt.setString(++i, YDMASessonUtil.getUserInfo().getCompno());
                    pstmt.executeUpdate();
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[shopProdInCategory]" + pstmt.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void shopProdInCategory(List<ProductDTO> childList) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "UPDATE SHOPPRODIN SET  SHOP_CID_INFO=? where shopcd=? and SHOPSEQ =?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ProductDTO dto : childList) {
                    int i = 0;
                    pstmt.setString(++i, dto.getShop_cid_info());
                    pstmt.setString(++i, dto.getShopcd());
                    pstmt.setString(++i, dto.getShopseq());
                    pstmt.executeUpdate();
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[shopProdInCategory]" + pstmt.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int getShopGroupProdInExist(String shopcd, String prodseq, String shopSeq) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                List<Object> shopgrp = new ArrayList();
                shopgrp = ShopCommonDao.get().getShopGroupWithShopseq(shopcd, shopSeq);
                String sql1 = shopgrp.stream().map(name -> "'" + name + "'").collect(Collectors.joining(","));
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT COUNT(SENDSEQ) FROM shopprodin where COMPNO=? and SHOPCD = ? \r\n");
                sql.append(" AND PRODSEQ=? \r\n");
                if (shopgrp.size() > 0) {
                    sql.append(String.format(" AND ShopSeq in (%s) \r\n", sql1));
                }
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, prodseq);
                YDMAStringUtil.Print("[getShopGroupProdInExist]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int getShopProdInExist(String shopcd, String prodseq) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COUNT(SENDSEQ) FROM shopprodin where COMPNO = ? and SHOPCD = ? and PRODSEQ = ?";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, prodseq);
                YDMAStringUtil.Print("[getShopProdInExist]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    result = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public ShopKakaoStoreAdditionalDto getAdditionaKakaoStoreOneList(int seq, String shopcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ShopKakaoStoreAdditionalDto dto = new ShopKakaoStoreAdditionalDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(SEQ, '0'),IFNULL(COMPNO, '0'),IFNULL(SHOPCD, ''),IFNULL(TITLE, ''),IFNULL(SHOPSEQ, '0'),IFNULL(SHOPID, ''), IFNULL(IMGONEONONE, ''),IFNULL(IMGTHREEONFOUR, ''),IFNULL(DISCOUNT, ''),IFNULL(DISCOUNTVAL, ''),IFNULL(DISCOUNTTYPE, ''),IFNULL(DISCOUNTPERIOD, ''), IFNULL(DISCOUNTFROM, ''),IFNULL(SHAREDISCOUNT, ''),IFNULL(SHAREDISCOUNTVAL, ''),IFNULL(SHAREDSLOTCNT, ''), IFNULL(SHAREDFROM, ''),IFNULL(SHAREDSTOCKYN, ''),IFNULL(SHAREDSTOCK, ''),IFNULL(GROUPDISCOUNT, ''),IFNULL(GROUPSIZE, ''), IFNULL(GROUPPRICE, ''),IFNULL(GROUPFROM, ''),IFNULL(GROUPSTOCKYN, ''),IFNULL(GROUPSTOCK, ''),IFNULL(SALEPERIOD, ''), IFNULL(SALEFROM, ''),IFNULL(PRODNMEDIT, ''),IFNULL(TAX, ''),IFNULL(PRODCONDITION, ''),IFNULL(MODEL, ''),IFNULL(MODELID, ''), IFNULL(BRAND, ''),IFNULL(BRANDID, ''),IFNULL(MANUFACTURER, ''),IFNULL(MANUFACTURERID, ''),IFNULL(ORIGINLAGID, ''),IFNULL(ORIGINID, ''), IFNULL(ORIGIN, ''),IFNULL(PLUSFRIEND, ''),IFNULL(MINPURCHASEQTY, ''),IFNULL(MAXPURCHASEQTY, ''),IFNULL(MAXPURCHASEOFBUYER, ''), IFNULL(DISPLAYSTATUS, ''),IFNULL(SHOPHOWDISPLAYABLE, ''),IFNULL(TALKDISPLAY, ''),IFNULL(ADDIMAGE, ''),IFNULL(IMAGERESIZE, ''), IFNULL(SELLERDC, '0'),IFNULL(DCRATE, '0'),IFNULL(CUMDC, '0'),IFNULL(MARGINDC, '0'),IFNULL(COMMDC, '0'),IFNULL(DELIVERY, ''), IFNULL(BUNDLEGROUP, ''),IFNULL(DELIVERYTYPE, ''),IFNULL(DELIVERYFEETYPE, ''),IFNULL(FREEDELIVERY, ''),IFNULL(EXPPRC, '0'),IFNULL(BASEFEE, '0'), IFNULL(ADDBASEFEE, '0'),IFNULL(DELIVERYPAYMENTTYPE, ''),IFNULL(SHIPPINGADDRID, ''),IFNULL(RETURNDELIVERYFEE, '0'),IFNULL(EXCHANGEDELIVERYFEE, '0'), IFNULL(RETURNADDRID, ''),IFNULL(ASPHONENUMBER, ''),IFNULL(ASGUIDEWORDS, ''),IFNULL(JJMT_DELV_YN, 'N'),IFNULL(JEJUMOUNTYN, 'N'), IFNULL(JEJUDELIVERYFEE, '0'),IFNULL(MOUNTDELIVERYFEE, '0'),IFNULL(USEISOLATEDAREA, ''),IFNULL(ISOLATEAREANOTICE, ''), IFNULL(COLLECTAPPLICATION, ''),IFNULL(COLLECTAPPLICATION1, ''),IFNULL(NOTICETITLEYN, ''),IFNULL(PRODNMOUTPUT, ''),IFNULL(PRODNMADDFRONT, ''), IFNULL(PRODNMADDBACK, ''),IFNULL(PRODDETAILFRONT, ''),IFNULL(PRODDETAILBACK, ''),IFNULL(PRODDETAILOUTPUT, ''),IFNULL(ORIGINYN, ''), \r\n IFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX, ''),IFNULL(CHANGESIZEY, ''),IFNULL(CHANGESIZEW, ''),IFNULL(CHANGESIZEH, ''), IFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL, ''), IFNULL(DETAILKEYWORDR, ''),  IFNULL(DETAILPRODUCTCODEB,''), IFNULL(DETAILPRODUCTCODEL, ''), IFNULL(DETAILPRODUCTCODER, ''),  IFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL, ''), IFNULL(DETAILPRODUCTNAMER, ''),  IFNULL(ADDOPTIONLB, ''), IFNULL(ADDOPTIONL, ''), IFNULL(ADDOPTIONRB, ''), IFNULL(ADDOPTIONR, ''), \r\n IFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''), IMG_ANGLE, IMG_SCALE_PERCENT \r\n\tFROM shopaddrkakaodtl where compno = ? and shopcd = ? and seq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setInt(3, seq);
                YDMAStringUtil.Print("[shopDetailjoinList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setDiscount(rs.getString(++columnIndex));
                    dto.setDiscountval(rs.getString(++columnIndex));
                    dto.setDiscounttype(rs.getString(++columnIndex));
                    dto.setDiscountperiod(rs.getString(++columnIndex));
                    dto.setDiscountfrom(rs.getString(++columnIndex));
                    dto.setSharediscount(rs.getString(++columnIndex));
                    dto.setSharediscountval(rs.getString(++columnIndex));
                    dto.setSharedslotcnt(rs.getString(++columnIndex));
                    dto.setSharedfrom(rs.getString(++columnIndex));
                    dto.setSharedstockyn(rs.getString(++columnIndex));
                    dto.setSharedstock(rs.getString(++columnIndex));
                    dto.setGroupdiscount(rs.getString(++columnIndex));
                    dto.setGroupsize(rs.getString(++columnIndex));
                    dto.setGroupprice(rs.getString(++columnIndex));
                    dto.setGroupfrom(rs.getString(++columnIndex));
                    dto.setGroupstockyn(rs.getString(++columnIndex));
                    dto.setGroupstock(rs.getString(++columnIndex));
                    dto.setSaleperiod(rs.getString(++columnIndex));
                    dto.setSalefrom(rs.getString(++columnIndex));
                    dto.setProdnmedit(rs.getString(++columnIndex));
                    dto.setTax(rs.getString(++columnIndex));
                    dto.setProdcondition(rs.getString(++columnIndex));
                    dto.setModel(rs.getString(++columnIndex));
                    dto.setModelid(rs.getString(++columnIndex));
                    dto.setBrand(rs.getString(++columnIndex));
                    dto.setBrandid(rs.getString(++columnIndex));
                    dto.setManufacturer(rs.getString(++columnIndex));
                    dto.setManufacturerid(rs.getString(++columnIndex));
                    dto.setOriginlagid(rs.getString(++columnIndex));
                    dto.setOriginid(rs.getString(++columnIndex));
                    dto.setOrigin(rs.getString(++columnIndex));
                    dto.setPlusfriend(rs.getString(++columnIndex));
                    dto.setMinpurchaseqty(rs.getString(++columnIndex));
                    dto.setMaxpurchaseqty(rs.getString(++columnIndex));
                    dto.setMaxpurchaseofbuyer(rs.getString(++columnIndex));
                    dto.setDisplaystatus(rs.getString(++columnIndex));
                    dto.setShophowdisplayable(rs.getString(++columnIndex));
                    dto.setTalkdisplay(rs.getString(++columnIndex));
                    dto.setAddimage(rs.getString(++columnIndex));
                    dto.setImageresize(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDelivery(rs.getString(++columnIndex));
                    dto.setBundlegroup(rs.getString(++columnIndex));
                    dto.setDeliverytype(rs.getString(++columnIndex));
                    dto.setDeliveryfeetype(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getString(++columnIndex));
                    dto.setBasefee(rs.getString(++columnIndex));
                    dto.setAddbasefee(rs.getString(++columnIndex));
                    dto.setDeliverypaymenttype(rs.getString(++columnIndex));
                    dto.setShippingaddrid(rs.getString(++columnIndex));
                    dto.setReturndeliveryfee(rs.getString(++columnIndex));
                    dto.setExchangedeliveryfee(rs.getString(++columnIndex));
                    dto.setReturnaddrid(rs.getString(++columnIndex));
                    dto.setAsphonenumber(rs.getString(++columnIndex));
                    dto.setAsguidewords(rs.getString(++columnIndex));
                    dto.setJjmt_delv_yn(rs.getString(++columnIndex));
                    dto.setJejuMountYn(rs.getString(++columnIndex));
                    dto.setJejuDeliveryFee(rs.getString(++columnIndex));
                    dto.setMountDeliveryFee(rs.getString(++columnIndex));
                    dto.setUseisolatedarea(rs.getString(++columnIndex));
                    dto.setIsolateareanotice(rs.getString(++columnIndex));
                    dto.setCollectapplication(rs.getString(++columnIndex));
                    dto.setCollectapplication1(rs.getString(++columnIndex));
                    dto.setNoticetitleyn(rs.getString(++columnIndex));
                    dto.setProdnmoutput(rs.getString(++columnIndex));
                    dto.setProdnmaddfront(rs.getString(++columnIndex));
                    dto.setProdnmaddback(rs.getString(++columnIndex));
                    dto.setProddetailfront(rs.getString(++columnIndex));
                    dto.setProddetailback(rs.getString(++columnIndex));
                    dto.setProddetailoutput(rs.getString(++columnIndex));
                    dto.setOriginyn(rs.getString(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setAngle(rs.getString(++columnIndex));
                    dto.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public String getAttrcd(ProductDTO dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String value = "";
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT KAKAOCD FROM prodattr WHERE attrcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dto.getProp1_cd());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    value = rs.getString(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return value;
    }

    public List<ShopProdAttrnmDto> getProductKakaoNotice(String attrcd, String shopcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ShopProdAttrnmDto> contents = new ArrayList<ShopProdAttrnmDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(GOSICODE, '') AS GOSICODE, IFNULL(GOSINUM, '') AS GOSINUM, IFNULL(GOSIVAL, '') AS GOSIVAL FROM SHOPATTRINFO WHERE GOSICODE=(SELECT IFNULL(KAKAOCD, '') AS KAKAOCD FROM PRODATTR WHERE ATTRCD = ?) AND SHOPCD=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, attrcd);
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[getProductKakaoNotice]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopProdAttrnmDto dto = new ShopProdAttrnmDto();
                    dto.setAttrcd(rs.getString("GOSICODE"));
                    dto.setColseq(rs.getString("GOSINUM"));
                    dto.setAttrvl(rs.getString("GOSIVAL"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public ShopSSGAdditionDto getAdditionaSSGOneList(int seq, String shopcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ShopSSGAdditionDto dto = new ShopSSGAdditionDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(SEQ, '0'), IFNULL(COMPNO, '0'), IFNULL(SHOPCD, ''), IFNULL(SHOPSEQ, '0'), IFNULL(SHOPUSERID, ''), IFNULL(TITLE, ''), IFNULL(BRANDYN, ''), IFNULL(BRANDPRDNADDI, ''), IFNULL(BRANDPRDFAIL, ''), IFNULL(BRANDID, ''), IFNULL(PRODMANUFCNTRYID, ''), IFNULL(ITEMCHRCTDIVCD, ''), IFNULL(ITEMCHRCTDTLCD, ''), IFNULL(EXUSITEMDIVCD, ''), IFNULL(EXUSITEMDTLCD, ''), IFNULL(ADULTITEMTYPECD, ''), IFNULL(ITEMSTATTYPECD, ''), IFNULL(ITEMSELLWAYCD, ''), IFNULL(PALIMPITEMYN, ''), IFNULL(GIFTPSBLYN, ''), IFNULL(WHINNOTIYN, ''), IFNULL(MAX1DYORDPSBLQTY, '0'), IFNULL(MINONETORDPSBLQTY, '0'), IFNULL(MAXONETORDPSBLQTY, '0'), IFNULL(RESERVEYN, ''), IFNULL(RESERVEDATE, ''), IFNULL(OPTZEROPRICEYN, ''), IFNULL(PROMOTIONYN, ''), IFNULL(RPLCTEXTNM1, ''), IFNULL(RPLCTEXTNM2, ''), IFNULL(RPLCTEXTNM3, ''), IFNULL(RPLCTEXTNM4, ''), IFNULL(RPLCTEXTNM5, ''), IFNULL(EPLNKGYN, ''), IFNULL(DCEXPSRYN, ''), IFNULL(PROMOTIONAPLYN, ''), IFNULL(BUYAPLYN, ''), IFNULL(BASCPRVDPRFTVAL, '0'), IFNULL(BASCPRVDPRFTTYPECD, ''), IFNULL(ADDPRVDPRFTVAL, '0'), IFNULL(ADDPRVDPRFTTYPECD, ''), IFNULL(BUYAPLENDDT, ''), IFNULL(REVIEWAPLYN, ''), IFNULL(TEXTPRVDPRFTVAL, '0'), IFNULL(PHOTOPRVDPRFTVAL, '0'), IFNULL(REVIEWAPLENDDT, ''), IFNULL(MULTIBUYDISCOUNTYN, ''), IFNULL(MULTIBUYDISCOUNTTGT, '0'), IFNULL(MULTIBUYDISCOUNTTYPECD, ''), IFNULL(MULTIBUYDISCOUNT, '0'), IFNULL(MULTIBUYDISCOUNTPRICETYPECD, ''), IFNULL(MULTIBUYDISCOUNTISAPLDATE, ''), IFNULL(MULTIBUYDISCOUNTENDDT, ''), IFNULL(IMMDISCOUNTYN, ''), IFNULL(IMMDISCOUNT, '0'), IFNULL(IMMDISCOUNTTYPECD, ''), IFNULL(IMMDISCOUNTISAPLDATE, ''), IFNULL(IMMDISCOUNTENDDT, ''), IFNULL(FREBIEINCLYN, ''), IFNULL(FREBIEINCLPRDNADDI, ''), IFNULL(FREEGIFTNM, ''), IFNULL(FREEGIFTAPLENDDT, ''), IFNULL(INVMNGYN, ''), IFNULL(INVQTY, '0'), IFNULL(SALLER_DC_RATE, '0'), IFNULL(DC_RATE, '0'), IFNULL(FLOAT_DC, '0'), IFNULL(MARGIN_RATE, '0'), IFNULL(COMMISSION_RATE, '0'), IFNULL(SHPPMTHDCD, ''), IFNULL(SHPPITEMDIVCD, ''), IFNULL(CTVATLNCLYN, ''), IFNULL(EXPRTCNTRYID, ''), IFNULL(SHPPRQRMDCNT, '0'), IFNULL(RETEXCHPSBLYN, ''), IFNULL(TDSHPPPSBLYN, ''), IFNULL(TDWHOUTCLSGHM, ''), IFNULL(DOFFLST, ''), IFNULL(MAREASHPPYN, ''), IFNULL(JEJUSHPPDISABYN, ''), IFNULL(ISMTARSHPPDISABYN, ''), IFNULL(WHOUTSHPPCSTID, ''), IFNULL(RETSHPPCSTID, ''), IFNULL(WHOUTADDRID, ''), IFNULL(SNBKADDRID, ''), IFNULL(ISMTARADDSHPPCSTID, ''), IFNULL(JEJUADDSHPPCSTID, ''), IFNULL(NOTICEBATCHYN, ''), IFNULL(NOTICECD, ''), IFNULL(NOTICETITLEYN, ''), IFNULL(SELLTATCAPA, ''), IFNULL(SELLUNITCAPA, ''), IFNULL(SELLCAPAUNITCD, ''), IFNULL(SELLUNITQTY, ''), IFNULL(EXPORTINGCOUNTRY, ''), IFNULL(TRAVELSELECTEXPENSES, ''), IFNULL(TRAVELGUIDETIPS, ''), IFNULL(TRAVELSIGN, ''), IFNULL(PHONESUBSCRIPTIONTYPE, ''), IFNULL(PHONEPLAN, ''), IFNULL(PHONECONTRACTPERIOD, ''), IFNULL(PHONEUSIMFEE, ''), IFNULL(PHONESUBSCRIPTIONFEE, ''), IFNULL(PHONERELEASE, ''), IFNULL(PHONEDISCLOSURESUBSIDY, ''), IFNULL(PHONESUPPLEMENTARYSUPPORT, ''), IFNULL(PHONEINSTALLMENTPRINCIPAL, ''), IFNULL(PHONEMONTHLYAMOUNT, ''), IFNULL(PHONEMOMTHLYFEE, ''), IFNULL(PHONEBILLDISCOUNT, ''), IFNULL(PHONEMONTHLYTOTALFEE, ''), IFNULL(RENTALMONTHLYFEE, ''), IFNULL(EFFICIENCYYN, ''), IFNULL(NUTRIENT, ''), IFNULL(BABYFOOD, ''), IFNULL(PRODOUTPUT, ''), IFNULL(PRODNMFIRST, ''), IFNULL(PRODNMLAST, ''), IFNULL(REMARKFIRST, ''), IFNULL(REMARKLAST, ''), IFNULL(REMARKOUTPUT,''), IFNULL(FREEDELIVERY,''), IFNULL(EXPPRC,'0'),\tIFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX, ''),IFNULL(CHANGESIZEY, ''),IFNULL(CHANGESIZEW, ''),IFNULL(CHANGESIZEH, ''),IFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL, ''), IFNULL(DETAILKEYWORDR, ''), IFNULL(DETAILPRODUCTCODEB,''), IFNULL(DETAILPRODUCTCODEL, ''), IFNULL(DETAILPRODUCTCODER, ''), IFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL, ''), IFNULL(DETAILPRODUCTNAMER, ''), IFNULL(ADDOPTIONLB, ''), IFNULL(ADDOPTIONL, ''), IFNULL(ADDOPTIONRB, ''), IFNULL(ADDOPTIONR, ''), IFNULL(IMGONEONONE, ''), IFNULL(IMGTHREEONFOUR, ''),\r\n IFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''), IMG_ANGLE, IMG_SCALE_PERCENT \r\nFROM shopssgaddidtl where compno = ? and shopcd = ? and seq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setInt(3, seq);
                YDMAStringUtil.Print("[shopDetailjoinList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setShopid(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setBrandyn(rs.getString(++columnIndex));
                    dto.setBrandprdnaddi(rs.getString(++columnIndex));
                    dto.setBrandprdfail(rs.getString(++columnIndex));
                    dto.setBrandid(rs.getString(++columnIndex));
                    dto.setProdmanufcntryid(rs.getString(++columnIndex));
                    dto.setItemchrctdivcd(rs.getString(++columnIndex));
                    dto.setItemchrctdtlcd(rs.getString(++columnIndex));
                    dto.setExusitemdivcd(rs.getString(++columnIndex));
                    dto.setExusitemdtlcd(rs.getString(++columnIndex));
                    dto.setAdultitemtypecd(rs.getString(++columnIndex));
                    dto.setItemstattypecd(rs.getString(++columnIndex));
                    dto.setItemsellwaycd(rs.getString(++columnIndex));
                    dto.setPalimpitemyn(rs.getString(++columnIndex));
                    dto.setGiftpsblyn(rs.getString(++columnIndex));
                    dto.setWhinnotiyn(rs.getString(++columnIndex));
                    dto.setMax1dyordpsblqty(rs.getString(++columnIndex));
                    dto.setMinonetordpsblqty(rs.getString(++columnIndex));
                    dto.setMaxonetordpsblqty(rs.getString(++columnIndex));
                    dto.setReserveyn(rs.getString(++columnIndex));
                    dto.setReservedate(rs.getString(++columnIndex));
                    dto.setOptzeropriceyn(rs.getString(++columnIndex));
                    dto.setPromotionyn(rs.getString(++columnIndex));
                    dto.setRplctextnm1(rs.getString(++columnIndex));
                    dto.setRplctextnm2(rs.getString(++columnIndex));
                    dto.setRplctextnm3(rs.getString(++columnIndex));
                    dto.setRplctextnm4(rs.getString(++columnIndex));
                    dto.setRplctextnm5(rs.getString(++columnIndex));
                    dto.setEplnkgyn(rs.getString(++columnIndex));
                    dto.setDcexpsryn(rs.getString(++columnIndex));
                    dto.setPromotionaplyn(rs.getString(++columnIndex));
                    dto.setBuyaplyn(rs.getString(++columnIndex));
                    dto.setBascprvdprftval(rs.getString(++columnIndex));
                    dto.setBascprvdprfttypecd(rs.getString(++columnIndex));
                    dto.setAddprvdprftval(rs.getString(++columnIndex));
                    dto.setAddprvdprfttypecd(rs.getString(++columnIndex));
                    dto.setBuyaplenddt(rs.getString(++columnIndex));
                    dto.setReviewaplyn(rs.getString(++columnIndex));
                    dto.setTextprvdprftval(rs.getString(++columnIndex));
                    dto.setPhotoprvdprftval(rs.getString(++columnIndex));
                    dto.setReviewaplenddt(rs.getString(++columnIndex));
                    dto.setMultibuydiscountyn(rs.getString(++columnIndex));
                    dto.setMultibuydiscounttgt(rs.getString(++columnIndex));
                    dto.setMultibuydiscounttypecd(rs.getString(++columnIndex));
                    dto.setMultibuydiscount(rs.getString(++columnIndex));
                    dto.setMultibuydiscountpricetypecd(rs.getString(++columnIndex));
                    dto.setMultibuydiscountisapldate(rs.getString(++columnIndex));
                    dto.setMultibuydiscountenddt(rs.getString(++columnIndex));
                    dto.setImmdiscountyn(rs.getString(++columnIndex));
                    dto.setImmdiscount(rs.getString(++columnIndex));
                    dto.setImmdiscounttypecd(rs.getString(++columnIndex));
                    dto.setImmdiscountisapldate(rs.getString(++columnIndex));
                    dto.setImmdiscountenddt(rs.getString(++columnIndex));
                    dto.setFrebieinclyn(rs.getString(++columnIndex));
                    dto.setFrebieinclprdnaddi(rs.getString(++columnIndex));
                    dto.setFreegiftnm(rs.getString(++columnIndex));
                    dto.setFreegiftaplenddt(rs.getString(++columnIndex));
                    dto.setInvmngyn(rs.getString(++columnIndex));
                    dto.setInvqty(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setShppmthdcd(rs.getString(++columnIndex));
                    dto.setShppitemdivcd(rs.getString(++columnIndex));
                    dto.setCtvatlnclyn(rs.getString(++columnIndex));
                    dto.setExprtcntryid(rs.getString(++columnIndex));
                    dto.setShpprqrmdcnt(rs.getString(++columnIndex));
                    dto.setRetexchpsblyn(rs.getString(++columnIndex));
                    dto.setTdshpppsblyn(rs.getString(++columnIndex));
                    dto.setTdwhoutclsghm(rs.getString(++columnIndex));
                    dto.setDofflst(rs.getString(++columnIndex));
                    dto.setMareashppyn(rs.getString(++columnIndex));
                    dto.setJejushppdisabyn(rs.getString(++columnIndex));
                    dto.setIsmtarshppdisabyn(rs.getString(++columnIndex));
                    dto.setWhoutshppcstid(rs.getString(++columnIndex));
                    dto.setRetshppcstid(rs.getString(++columnIndex));
                    dto.setWhoutaddrid(rs.getString(++columnIndex));
                    dto.setSnbkaddrid(rs.getString(++columnIndex));
                    dto.setIsmtaraddshppcstid(rs.getString(++columnIndex));
                    dto.setJejuaddshppcstid(rs.getString(++columnIndex));
                    dto.setNoticebatchyn(rs.getString(++columnIndex));
                    dto.setNoticecd(rs.getString(++columnIndex));
                    dto.setNoticetitleyn(rs.getString(++columnIndex));
                    dto.setSelltatcapa(rs.getString(++columnIndex));
                    dto.setSellunitcapa(rs.getString(++columnIndex));
                    dto.setSellcapaunitcd(rs.getString(++columnIndex));
                    dto.setSellunitqty(rs.getString(++columnIndex));
                    dto.setExportingcountry(rs.getString(++columnIndex));
                    dto.setTravelselectexpenses(rs.getString(++columnIndex));
                    dto.setTravelguidetips(rs.getString(++columnIndex));
                    dto.setTravelsign(rs.getString(++columnIndex));
                    dto.setPhonesubscriptiontype(rs.getString(++columnIndex));
                    dto.setPhoneplan(rs.getString(++columnIndex));
                    dto.setPhonecontractperiod(rs.getString(++columnIndex));
                    dto.setPhoneusimfee(rs.getString(++columnIndex));
                    dto.setPhonesubscriptionfee(rs.getString(++columnIndex));
                    dto.setPhonerelease(rs.getString(++columnIndex));
                    dto.setPhonedisclosuresubsidy(rs.getString(++columnIndex));
                    dto.setPhonesupplementarysupport(rs.getString(++columnIndex));
                    dto.setPhoneinstallmentprincipal(rs.getString(++columnIndex));
                    dto.setPhonemonthlyamount(rs.getString(++columnIndex));
                    dto.setPhonemomthlyfee(rs.getString(++columnIndex));
                    dto.setPhonebilldiscount(rs.getString(++columnIndex));
                    dto.setPhonemonthlytotalfee(rs.getString(++columnIndex));
                    dto.setRentalmonthlyfee(rs.getString(++columnIndex));
                    dto.setEfficiencyyn(rs.getString(++columnIndex));
                    dto.setNutrient(rs.getString(++columnIndex));
                    dto.setBabyfood(rs.getString(++columnIndex));
                    dto.setProdoutput(rs.getString(++columnIndex));
                    dto.setProdnmfirst(rs.getString(++columnIndex));
                    dto.setProdnmlast(rs.getString(++columnIndex));
                    dto.setRemarkfirst(rs.getString(++columnIndex));
                    dto.setRemarklast(rs.getString(++columnIndex));
                    dto.setRemarkoutput(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setExpprc(rs.getInt(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setAngle(rs.getString(++columnIndex));
                    dto.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopLotteOnAdditionalDto getAdditionaLotteOnOneList(int seq, String shopcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ShopLotteOnAdditionalDto dto = new ShopLotteOnAdditionalDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(SEQ, '0'), IFNULL(COMPNO, '0'), IFNULL(SHOPCD, ''), IFNULL(SHOPSEQ, '0'), IFNULL(TITLE, ''), IFNULL(ISCATEGORY,''), IFNULL(LAGCATCD,''), IFNULL(MIDCATCD,''), IFNULL(SMLCATCD,''), IFNULL(DETCATCD,''), IFNULL(SHOPCATNO,''), IFNULL(SHOPCATSITENM,''),IFNULL(CTRTTYPCD, ''), IFNULL(CSHBLTYPDYN, ''), IFNULL(AGELMTCD, ''), IFNULL(BOOKCULTCSTDDCTYN, ''), IFNULL(SLTYPCD, ''), IFNULL(PDTYPCD, ''), IFNULL(BRDREGYN, ''), IFNULL(BRDPDINFOYN, ''), IFNULL(BRDPDREGPRCYN, ''), IFNULL(BRDPDRST, ''), IFNULL(OPLCCD, ''), IFNULL(IMPCONM, ''), IFNULL(IMPDVSCD, ''), IFNULL(PDSTATCD, ''), IFNULL(SLSTRTDTTM, ''), IFNULL(SLENDDTTM, ''), IFNULL(PRCCMPREPSRYN, ''), IFNULL(CNCLPSBYN, ''), IFNULL(IMMDCNCLPSBYN, ''), IFNULL(BRKHMAPPKCPPSBYN, ''), IFNULL(PRSTPSBYN, ''), IFNULL(ITMBYMINPURYN, ''), IFNULL(ITMBYMAXPURPSBQTYYN, ''), IFNULL(ASGUIDE, ''), IFNULL(STKMGTYN, ''), IFNULL(PDOPTMODIFYYN, ''), IFNULL(SELSALEOPTSETYN, ''),IFNULL(SELLERDC, '0'), IFNULL(DCRATE, '0'), IFNULL(CUMDC, '0'), IFNULL(MARGINDC, '0'), IFNULL(COMMDC, '0'), IFNULL(PDPRTWAY, ''), IFNULL(PDNMADDFRTTXT, ''), IFNULL(PDNMADDBACKTXT, ''), IFNULL(PDDTLFRTDEC, ''), IFNULL(PDDTLBACKDEC, ''), IFNULL(PDDTLBACKDECPRTLOC, ''), IFNULL(DMSTOVSDVDVSCD, ''), IFNULL(PSTKYN, ''), IFNULL(DVPROCTYPCD, ''), IFNULL(DVPDTYPCD, ''), IFNULL(NLDYSNDCLOSETM, '0'), IFNULL(SATSNDPSBYN, ''), IFNULL(SATSNDCLOSETM, ''), IFNULL(DVRGSPRGRPCD, ''), IFNULL(DVMNSCD, ''), IFNULL(OWHPNO, ''), IFNULL(HDCCD, ''), IFNULL(DVCSTPOLNO, ''), IFNULL(ADTNDVCSTPOLNO, ''), IFNULL(CMDNDVPSBYN, ''), IFNULL(DVCSTSTDQTY, ''), IFNULL(QCKDVUSEYN, ''), IFNULL(CRDAYDVPSBYN, ''), IFNULL(ODCLOSETM, ''), IFNULL(HPDDDVPSBYN, ''), IFNULL(SAVETYPCD, ''), IFNULL(RTNGPSBYN, ''), IFNULL(XCHGPSBYN, ''), IFNULL(ECHGPSBYN, ''), IFNULL(CMBNRTNGPSBYN, ''), IFNULL(RTNGHDCCD, ''), IFNULL(RTNGRTRVPSBYN, ''), IFNULL(RTRPNO, ''),IFNULL(TDFDVSCD, ''), IFNULL(SBJPSTTITUSEYN, ''), IFNULL(BTCAPPSETYN,''), IFNULL(PDPSTDIVS,''), IFNULL(FREEDELIVERY,''), IFNULL(EXPPRC,''), IFNULL(BRND_ID,''), IFNULL(CHANGESIZE,''), IFNULL(CHANGESIZEX, ''),IFNULL(CHANGESIZEY, ''),IFNULL(CHANGESIZEW, ''),IFNULL(CHANGESIZEH, ''),IFNULL(DETAILKEYWORDB,''), IFNULL(DETAILKEYWORDL, ''), IFNULL(DETAILKEYWORDR, ''), IFNULL(DETAILPRODUCTCODEB,''), IFNULL(DETAILPRODUCTCODEL, ''), IFNULL(DETAILPRODUCTCODER, ''), IFNULL(DETAILPRODUCTNAMEB,''), IFNULL(DETAILPRODUCTNAMEL, ''), IFNULL(DETAILPRODUCTNAMER, ''), IFNULL(ADDOPTIONLB, ''), IFNULL(ADDOPTIONL, ''), IFNULL(ADDOPTIONRB, ''), IFNULL(ADDOPTIONR, ''), IFNULL(IMGONEONONE, ''), IFNULL(IMGTHREEONFOUR, ''), IMG_ANGLE, IMG_SCALE_PERCENT \r\nFROM shoplotteonadddtl where compno = ? and shopcd = ? and seq = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setInt(3, seq);
                YDMAStringUtil.Print("[shopDetailjoinList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setShopcd(rs.getString(++columnIndex));
                    dto.setShopseq(rs.getString(++columnIndex));
                    dto.setTitle(rs.getString(++columnIndex));
                    dto.setIsCategory(rs.getString(++columnIndex));
                    dto.setLagcatcd(rs.getString(++columnIndex));
                    dto.setMidcatcd(rs.getString(++columnIndex));
                    dto.setSmlcatcd(rs.getString(++columnIndex));
                    dto.setDetcatcd(rs.getString(++columnIndex));
                    dto.setShopcatno(rs.getString(++columnIndex));
                    dto.setShopcatsitenm(rs.getString(++columnIndex));
                    dto.setCtrtTypCd(rs.getString(++columnIndex));
                    dto.setCshbltyPdYn(rs.getString(++columnIndex));
                    dto.setAgeLmtCd(rs.getString(++columnIndex));
                    dto.setBookCultCstDdctYn(rs.getString(++columnIndex));
                    dto.setSlTypCd(rs.getString(++columnIndex));
                    dto.setPdTypCd(rs.getString(++columnIndex));
                    dto.setBrdRegYn(rs.getString(++columnIndex));
                    dto.setBrdPdInfoYn(rs.getString(++columnIndex));
                    dto.setBrdPdRegPrcYn(rs.getString(++columnIndex));
                    dto.setBrdPdRst(rs.getString(++columnIndex));
                    dto.setOplcCd(rs.getString(++columnIndex));
                    dto.setImpCoNm(rs.getString(++columnIndex));
                    dto.setImpDvsCd(rs.getString(++columnIndex));
                    dto.setPdStatCd(rs.getString(++columnIndex));
                    dto.setSlStrtDttm(rs.getString(++columnIndex));
                    dto.setSlEndDttm(rs.getString(++columnIndex));
                    dto.setPrcCmprEpsrYn(rs.getString(++columnIndex));
                    dto.setCnclPsbYn(rs.getString(++columnIndex));
                    dto.setImmdCnclPsbYn(rs.getString(++columnIndex));
                    dto.setBrkHmapPkcpPsbYn(rs.getString(++columnIndex));
                    dto.setPrstPsbYn(rs.getString(++columnIndex));
                    dto.setItmByMinPurYn(rs.getString(++columnIndex));
                    dto.setItmByMaxPurPsbQtyYn(rs.getString(++columnIndex));
                    dto.setAsGuide(rs.getString(++columnIndex));
                    dto.setStkMgtYn(rs.getString(++columnIndex));
                    dto.setPdOptmodifyYn(rs.getString(++columnIndex));
                    dto.setSelSaleOptSetYn(rs.getString(++columnIndex));
                    dto.setSellerDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setFlatDc(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setMargin(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setCommission(Float.parseFloat(rs.getString(++columnIndex)));
                    dto.setPdPrtWay(rs.getString(++columnIndex));
                    dto.setPdNmAddFrtTxt(rs.getString(++columnIndex));
                    dto.setPdNmAddBackTxt(rs.getString(++columnIndex));
                    dto.setPdDtlFrtDec(rs.getString(++columnIndex));
                    dto.setPdDtlBackDec(rs.getString(++columnIndex));
                    dto.setPdDtlBackDecPrtLoc(rs.getString(++columnIndex));
                    dto.setDmstOvsDvDvsCd(rs.getString(++columnIndex));
                    dto.setPstkYn(rs.getString(++columnIndex));
                    dto.setDvProcTypCd(rs.getString(++columnIndex));
                    dto.setDvPdTypCd(rs.getString(++columnIndex));
                    dto.setNldySndCloseTm(rs.getString(++columnIndex));
                    dto.setSatSndPsbYn(rs.getString(++columnIndex));
                    dto.setSatSndCloseTm(rs.getString(++columnIndex));
                    dto.setDvRgsprGrpCd(rs.getString(++columnIndex));
                    dto.setDvMnsCd(rs.getString(++columnIndex));
                    dto.setOwhpNo(rs.getString(++columnIndex));
                    dto.setHdcCd(rs.getString(++columnIndex));
                    dto.setDvCstPolNo(rs.getString(++columnIndex));
                    dto.setAdtnDvCstPolNo(rs.getString(++columnIndex));
                    dto.setCmbnDvPsbYn(rs.getString(++columnIndex));
                    dto.setDvCstStdQty(rs.getString(++columnIndex));
                    dto.setQckDvUseYn(rs.getString(++columnIndex));
                    dto.setCrdayDvPsbYn(rs.getString(++columnIndex));
                    dto.setOdCloseTm(rs.getString(++columnIndex));
                    dto.setHpDdDvPsbYn(rs.getString(++columnIndex));
                    dto.setSaveTypCd(rs.getString(++columnIndex));
                    dto.setRtngPsbYn(rs.getString(++columnIndex));
                    dto.setXchgPsbYn(rs.getString(++columnIndex));
                    dto.setEchgPsbYn(rs.getString(++columnIndex));
                    dto.setCmbnRtngPsbYn(rs.getString(++columnIndex));
                    dto.setRtngHdcCd(rs.getString(++columnIndex));
                    dto.setRtngRtrvPsbYn(rs.getString(++columnIndex));
                    dto.setRtrpNo(rs.getString(++columnIndex));
                    dto.setTdfDvsCd(rs.getString(++columnIndex));
                    dto.setSbjPstTitUseYn(rs.getString(++columnIndex));
                    dto.setBtcAppSetYn(rs.getString(++columnIndex));
                    dto.setPdPstDivs(rs.getString(++columnIndex));
                    dto.setFreedelivery(rs.getString(++columnIndex));
                    dto.setExpprc(Integer.parseInt(rs.getString(++columnIndex)));
                    dto.setBrnd_id(rs.getString(++columnIndex));
                    dto.setChangesize(rs.getString(++columnIndex));
                    dto.setChangeSizeX(rs.getString(++columnIndex));
                    dto.setChangeSizeY(rs.getString(++columnIndex));
                    dto.setChangeSizeW(rs.getString(++columnIndex));
                    dto.setChangeSizeH(rs.getString(++columnIndex));
                    dto.setDetailkeywordb(rs.getString(++columnIndex));
                    dto.setDetailKeywordL(rs.getString(++columnIndex));
                    dto.setDetailKeywordR(rs.getString(++columnIndex));
                    dto.setDetailproductcodeb(rs.getString(++columnIndex));
                    dto.setDetailProductCodeL(rs.getString(++columnIndex));
                    dto.setDetailProductCodeR(rs.getString(++columnIndex));
                    dto.setDetailproductnameb(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameL(rs.getString(++columnIndex));
                    dto.setDetailProdcutNameR(rs.getString(++columnIndex));
                    dto.setAddoptionlb(rs.getString(++columnIndex));
                    dto.setAddOptionL(rs.getString(++columnIndex));
                    dto.setAddoptionrb(rs.getString(++columnIndex));
                    dto.setAddOptionR(rs.getString(++columnIndex));
                    dto.setImgOneOnOne(rs.getString(++columnIndex));
                    dto.setImgThreeOnFour(rs.getString(++columnIndex));
                    dto.setAngle(rs.getString(++columnIndex));
                    dto.setScalePercent(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ShopProdAttrnmDto> getProductLotteOnNotice(String attrcd, String shopcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ShopProdAttrnmDto> contents = new ArrayList<ShopProdAttrnmDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(GOSICODE, '') AS GOSICODE, IFNULL(GOSINUM, '') AS GOSINUM, IFNULL(GOSIVAL, '') AS GOSIVAL FROM SHOPATTRINFO WHERE GOSICODE=(SELECT IFNULL(lottecd, '') AS lottecd FROM PRODATTR WHERE ATTRCD = ?) AND SHOPCD=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, attrcd);
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[getProductLotteonNotice]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopProdAttrnmDto dto = new ShopProdAttrnmDto();
                    dto.setAttrcd(rs.getString("GOSICODE"));
                    dto.setColseq(rs.getString("GOSINUM"));
                    if (dto.getColseq().equals("0200")) continue;
                    dto.setAttrvl(rs.getString("GOSIVAL"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public ShopGodomallAdditionalDto getAdditionalGodomallOneList(int seq, String shopcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ShopGodomallAdditionalDto dto = new ShopGodomallAdditionalDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(SEQ, '0') as SEQ,\r\nIFNULL(COMPNO, '0') as COMPNO,\r\nIFNULL(SHOPCD, '') as SHOPCD,\r\nIFNULL(SHOPSEQ, '0') as SHOPSEQ,\r\nIFNULL(SHOPID, '') as SHOPID,\r\nIFNULL(TITLE, '') as TITLE,\r\nIFNULL(ISCATEGORY, '') as ISCATEGORY,\r\nIFNULL(LAGCATCD, '') as LAGCATCD,\r\nIFNULL(MIDCATCD, '') as MIDCATCD,\r\nIFNULL(SMLCATCD, '') as SMLCATCD,\r\nIFNULL(DETCATCD, '') as DETCATCD,\r\nIFNULL(SHOPCATNO, '') as SHOPCATNO,\r\nIFNULL(SHOPCATSITENM, '') as SHOPCATSITENM,\r\nIFNULL(IMGONEONONE, '') as IMGONEONONE,\r\nIFNULL(IMGTHREEONFOUR, '') as IMGTHREEONFOUR,\r\nIFNULL(GOODSSELLMOBILEFL, '') as GOODSSELLMOBILEFL,\r\nIFNULL(GOODSDISPLAYMOBILEFL, '') as GOODSDISPLAYMOBILEFL,\r\nIFNULL(GOODSSTATE, '') as GOODSSTATE,\r\nIFNULL(GOODSPERMISSION, '') as GOODSPERMISSION,\r\nIFNULL(SCMNO, '') as SCMNO,\r\nIFNULL(PAYLIMITFL, '') as PAYLIMITFL,\r\nIFNULL(PAYLIMIT, '') as PAYLIMIT,\r\nIFNULL(EX_TITLE, '') as EX_TITLE,\r\nIFNULL(GOODSCOLOR, '') as GOODSCOLOR,\r\nIFNULL(SALESENDYMD, '') as SALESENDYMD,\r\nIFNULL(BRANDCD, '0') as BRANDCD,\r\nIFNULL(RELATIONFL, '') as RELATIONFL,\r\nIFNULL(RELATIONSAMEFL, '') as RELATIONSAMEFL,\r\nIFNULL(RELATIONGOODSNO, '') as RELATIONGOODSNO,\r\nIFNULL(OPTIONDISPLAYFL, '') as OPTIONDISPLAYFL,\r\nIFNULL(GOODSPRICESTRING, '') as GOODSPRICESTRING,\r\nIFNULL(ONLYADULTFL, '') as ONLYADULTFL,\r\nIFNULL(IMAGEUPDATE, '') as IMAGEUPDATE,\r\nIFNULL(IMAGESTORAGE, '') as IMAGESTORAGE,\r\nIFNULL(MAGNIFYIMAGEDATA, '') as MAGNIFYIMAGEDATA,\r\nIFNULL(DETAILIMAGEDATA, '') as DETAILIMAGEDATA,\r\nIFNULL(LISTIMAGEDATA, '') as LISTIMAGEDATA,\r\nIFNULL(MAINIMAGEDATA, '') as MAINIMAGEDATA,\r\nIFNULL(STOCKFL, '') as STOCKFL,\r\nIFNULL(MINORDERCNT, '0') as MINORDERCNT,\r\nIFNULL(MAXORDERCNT, '0') as MAXORDERCNT,\r\nIFNULL(RESTOCKFL, '') as RESTOCKFL,\r\nIFNULL(SHORTDESCRIPTION, '') as SHORTDESCRIPTION,\r\nIFNULL(IMGDETAILVIEWFL, '') as IMGDETAILVIEWFL,\r\nIFNULL(NAVERFL, '') as NAVERFL,\r\nIFNULL(NAVERIMPORTFLAG, '') as NAVERIMPORTFLAG,\r\nIFNULL(NAVERPRODUCTFLAG, '') as NAVERPRODUCTFLAG,\r\nIFNULL(NAVERAGEGROUP, '') as NAVERAGEGROUP,\r\nIFNULL(NAVERGENDER, '') as NAVERGENDER,\r\nIFNULL(NAVERATTRIBUTE, '') as NAVERATTRIBUTE,\r\nIFNULL(NAVERTAG, '') as NAVERTAG,\r\nIFNULL(NAVERCATEGORY, '0') as NAVERCATEGORY,\r\nIFNULL(NAVERPRODUCTID, '') as NAVERPRODUCTID,\r\nIFNULL(SELLERDC, '') as SELLERDC,\r\nIFNULL(DCRATE, '') as DCRATE,\r\nIFNULL(CUMDC, '') as CUMDC,\r\nIFNULL(MARGINDC, '') as MARGINDC,\r\nIFNULL(COMMDC, '') as COMMDC,\r\nIFNULL(DELIVERYSNO, '') as DELIVERYSNO,\r\nIFNULL(METHOD, '') as METHOD,\r\nIFNULL(DETAILINFODELIVERY, '') as DETAILINFODELIVERY,\r\nIFNULL(DETAILINFOAS, '') as DETAILINFOAS,\r\nIFNULL(DETAILINFOREFUND, '') as DETAILINFOREFUND,\r\nIFNULL(DETAILINFOEXCHANGE, '') as DETAILINFOEXCHANGE,\r\nIFNULL(CHANGESIZE, '') as CHANGESIZE,\r\nIFNULL(CHANGESIZEX, '') as CHANGESIZEX,\r\nIFNULL(CHANGESIZEY, '') as CHANGESIZEY,\r\nIFNULL(CHANGESIZEW, '') as CHANGESIZEW,\r\nIFNULL(CHANGESIZEH, '') as CHANGESIZEH,\r\nIFNULL(DETAILKEYWORDB, '') as DETAILKEYWORDB,\r\nIFNULL(DETAILKEYWORDL, '') as DETAILKEYWORDL,\r\nIFNULL(DETAILKEYWORDR, '') as DETAILKEYWORDR,\r\nIFNULL(DETAILPRODUCTCODEB, '') as DETAILPRODUCTCODEB,\r\nIFNULL(DETAIL