/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.data.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.data.dao.SMSInfoDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CompInfoDao {
    public int getSMSSafeMoney(String companyNo) throws Exception {
        int charge = 0;
        int use = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select smschgamt, smsuseamt from companyinfo where compno=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    charge = rs.getInt(1);
                    use = rs.getInt(2);
                    YDMAStringUtil.Print("charge " + charge + " use " + use);
                } else {
                    YDMAStringUtil.Print("Error");
                    charge = 0;
                    use = 0;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return charge - use;
    }

    public String getSMSNo(String compNo) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select smsno from companyinfo where compno=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    result = rs.getString(1);
                    YDMAStringUtil.Print("sms no " + result);
                } else {
                    YDMAStringUtil.Print("Error");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public SMSInfoDto getCompInfo(String compNo) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        SMSInfoDto dto = new SMSInfoDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select smsno, smschgamt, smsuseamt from companyinfo where compno=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    dto.setSmsno(rs.getString(1));
                    dto.setSmschgamt(rs.getInt(2));
                    dto.setSmsuseamt(rs.getInt(3));
                    YDMAStringUtil.Print("Success:CompanyInfo.getCompInfo  " + rs.getString(1) + " " + rs.getInt(2) + " " + rs.getInt(3));
                } else {
                    YDMAStringUtil.Print("Error : CompanyInfo.getCompInfo");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<String> getCompanyInfoByAll() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select COMPNM,SB_CMP_ID,SB_AUTH_KEY, EC_COM_CD,EC_USR_ID,EC_API_KEY from companyinfo where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getCompanyInfoByAll]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void updateMoneyInfo(String compNo, SMSInfoDto dto) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                PreparedStatement pstmt_prodmst = null;
                String sql_prodmst = "update companyinfo set smsuseamt=? where compno=?";
                sql_prodmst = sql_prodmst.toUpperCase();
                pstmt_prodmst = connection.prepareStatement(sql_prodmst);
                statementlist.add(pstmt_prodmst);
                pstmt_prodmst.setInt(1, dto.getSmsuseamt());
                pstmt_prodmst.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_prodmst.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<String> getCompno() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select COMPNO, IMGFOLDER from companyinfo where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getCompno]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<String> getCompNoImage() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(compno,''), ifnull(compnm,''),ifnull(SB_CMP_ID,''),ifnull(SB_AUTH_KEY,''),ifnull(SB_PROD_FILE,''),ifnull(SB_ORD_FILE,''),ifnull(SB_CLAIM_FILE,''), ifnull(EC_COM_CD,'') ,ifnull(EC_USR_ID,''),ifnull(EC_API_KEY,''),ifnull(IMGFOLDER,''),ifnull(CUSTNO,''),ifnull(CEONM,''),ifnull(zipcode,''),ifnull(ADDRESS,'') ,ifnull(BUSINESS,''),ifnull(EVENT,'') ,ifnull(TELNO,''),ifnull(CPHON,''),ifnull(FAXNO,''),ifnull(EMAIL,''),ifnull(kakao_key,''),ifnull(sabangid,''),ifnull(sabangpw,''), ifnull(compals,''), ifnull(userid,'') from companyinfo where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getCompNoImage]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public SMSInfoDto getCompFaxInfo() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        SMSInfoDto dto = new SMSInfoDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select smsno, smschgamt, smsuseamt from companyinfo where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    dto.setSmsno(rs.getString(1));
                    dto.setSmschgamt(rs.getInt(2));
                    dto.setSmsuseamt(rs.getInt(3));
                    YDMAStringUtil.Print("Success:CompanyInfo.getCompInfo  " + rs.getString(1) + " " + rs.getInt(2) + " " + rs.getInt(3));
                } else {
                    YDMAStringUtil.Print("Error : CompanyInfo.getCompInfo");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<String> getServerCompany() throws Exception {
        String json = "{\"compno\" : 4 }";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
        Request request2 = new Request.Builder().url("http://api.kdjsystem.com:8080/api/v1/company").method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string();
        data2 = data2.substring(data2.indexOf("[") + 1, data2.indexOf("]"));
        data2 = data2.replaceAll("\"", "");
        return Arrays.asList(data2.split(","));
    }
}

