/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.config.AcessConfig;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductAddProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductAddProcess;
import com.kdjsystem.mlink.yellim.helper.DateHelper;
import com.kdjsystem.mlink.yellim.shop.common.ShopCommon;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAddDialog;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.core.runtime.IProgressMonitor;

public class Cafe24ProductAddService
implements IProductAddProcess {
    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto) throws Exception {
        boolean flag = true;
        int page = 0;
        int start = 0;
        int end = 100;
        int infoRet = 0;
        int inRet = 0;
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String lastCreatedDate = dto.getEND_DATE();
        String beginText = String.format(String.valueOf(DateHelper.getCurrentTimeString()) + "[%s - %s]\r\n", shopInfo.getSHOPNM(), shopInfo.getNICKNM1());
        CommonProgressDialog.get().setValue(beginText.concat("\uc1fc\ud551\ubab0\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4..."), 0);
        try {
            while (flag) {
                String codeDivision;
                ++page;
                Response response = null;
                if (!AcessConfig.get().checkCafe24Accesstoken(shopInfo)) {
                    throw new Exception("\uc811\uadfc\uad8c\ud55c \ud68d\ub4dd \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc0ac\uc6a9\uc790 API \ud658\uacbd\uc124\uc815 \uc815\ubcf4 \ud655\uc778 \ubc14\ub78d\ub2c8\ub2e4.");
                }
                Request request2 = new Request.Builder().url(String.format("https://%s.cafe24api.com/api/v2/admin/products?offset=%s&limit=100&created_start_date=%s&created_end_date=%s", shopInfo.getSHOPPINGID(), start, dto.getSTART_DATE(), lastCreatedDate)).addHeader("Authorization", "Bearer " + AcessConfig.ACCESSTOKEN).addHeader("Content-Type", "application/json").get().build();
                OkHttpClient client = new OkHttpClient();
                response = client.newCall(request2).execute();
                String data2 = response.body().string().toString();
                response.close();
                if (data2 == null || data2.isEmpty()) {
                    System.out.println("API \uc751\ub2f5\uc774 \ube44\uc5b4 \uc788\uc74c, 2\ucd08 \ub300\uae30 \ud6c4 \uc7ac\uc2dc\ub3c4 \uc608\uc815\uc785\ub2c8\ub2e4.");
                    Thread.sleep(2000L);
                    continue;
                }
                JsonParser jsonparser = new JsonParser();
                JsonObject jsonobject = (JsonObject)jsonparser.parse(data2);
                JsonArray products = (JsonArray)jsonobject.get("products");
                if (products == null) {
                    System.out.println("Cafe24 \uc0c1\ud488 \uc815\ubcf4\uac00 \ube44\uc5b4 \uc788\uc74c, 2\ucd08 \ub300\uae30 \ud6c4 \uc7ac\uc2dc\ub3c4 \uc608\uc815\uc785\ub2c8\ub2e4.");
                    Thread.sleep(2000L);
                    continue;
                }
                if (products.size() == 0) {
                    CommonProgressDialog.get().setValue(beginText.concat("\ucd1d " + inRet + "\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4."), 100);
                    return new ResultProcessDTO(0, "", infoRet, inRet);
                }
                if (products.size() < 100) {
                    flag = false;
                }
                ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                int i = 0;
                while (i < products.size()) {
                    if (ProductAddDialog.getIsCanceled()) {
                        return new ResultProcessDTO(0, "", infoRet, inRet);
                    }
                    JsonObject product2 = (JsonObject)products.get(i);
                    ProductDTO responseProduct = new ProductDTO();
                    responseProduct.setShopcd(shopInfo.getSHOPCD());
                    responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
                    responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
                    responseProduct.setGoods_nm(ShopCommon.jsonElementNullStr(product2.get("product_name")));
                    responseProduct.setShopprodno(ShopCommon.jsonElementNullStr(product2.get("product_no")));
                    if (ShopCommon.jsonElementNullStr(product2.get("created_date")).length() > 10) {
                        responseProduct.setInsertdt(YDMATimeUtil.getLondtoDate1(ShopCommon.jsonElementNullStr(product2.get("created_date")).substring(0, 10)));
                    } else {
                        responseProduct.setInsertdt(YDMATimeUtil.getLondtoDate1(YDMATimeUtil.getCurrentDateScheduler()));
                    }
                    if (ShopCommon.jsonElementNullStr(product2.get("created_end_date")).length() > 10) {
                        responseProduct.setSaleenddt(ShopCommon.jsonElementNullStr(product2.get("created_end_date")).substring(0, 10));
                    } else {
                        responseProduct.setSaleenddt("");
                    }
                    int price2 = (int)product2.get("supply_price").getAsDouble();
                    responseProduct.setMarket_price(String.valueOf(price2));
                    responseProduct.setGoods_price(String.valueOf(price2));
                    responseProduct.setGoods_consumer_price(String.valueOf(price2));
                    responseProduct.setCompayny_goods_cd(ShopCommon.jsonElementNullStr(product2.get("custom_product_code")));
                    if (ShopCommon.jsonElementNullStr(product2.get("selling")).equals("T")) {
                        responseProduct.setSaleStatusCd("8000");
                        responseProduct.setStatus("0");
                        responseProduct.setSendstats(String.valueOf(8000));
                    } else {
                        responseProduct.setSaleStatusCd("3000");
                        responseProduct.setStatus("2");
                        responseProduct.setSendstats(String.valueOf(3000));
                    }
                    codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(responseProduct.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                    responseProduct.setGoods_keyword(codeDivision);
                    responseProducts.add(responseProduct);
                    CommonProgressDialog.get().setValue(beginText.concat("'" + responseProduct.getCompayny_goods_cd() + "' \ubd88\ub7ec\uc624\ub294\uc911..."), 0);
                    ++i;
                }
                if (responseProducts.size() > 0) {
                    CommonProgressDialog.get().setValue(beginText.concat(String.valueOf(page) + " \ubc88\uc9f8 " + responseProducts.size() + "\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4..."), 0);
                    for (ProductDTO product3 : responseProducts) {
                        int ret;
                        if (ProductAddDialog.getIsCanceled()) {
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                        if (copyProduct == null) {
                            if (!product3.getSaleStatusCd().equals(Integer.toString(8000))) continue;
                            ret = ProductDAO.get().insertProductInfo(product3);
                            if (ret == 1) {
                                infoRet += ret;
                            }
                        } else {
                            copyProduct.setClass_cd3(product3.getClass_cd3());
                            copyProduct.setShop_cid_info(product3.getShop_cid_info());
                            ret = ProductDAO.get().updateProductInfo(copyProduct);
                            if (ret == 1) {
                                infoRet += ret;
                            }
                        }
                        copyProduct = ProductDAO.get().selectProductInfo(product3.getCompayny_goods_cd());
                        ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (copyProductIn == null) {
                            product3.setPRODSEQ(copyProduct.getPRODSEQ());
                            int ret2 = ProductDAO.get().insertProductIn(product3);
                            if (ret2 == 1) {
                                inRet += ret2;
                            }
                        } else {
                            copyProductIn.setClass_cd3(product3.getClass_cd3());
                            copyProductIn.setShop_cid_info(product3.getShop_cid_info());
                            copyProductIn.setGoods_nm(product3.getGoods_nm());
                            copyProductIn.setShopprodno(product3.getShopprodno());
                            copyProductIn.setDelv_r_cost(product3.getDelv_r_cost());
                            copyProductIn.setSaleenddt(product3.getSaleenddt());
                            copyProductIn.setMarket_price(product3.getMarket_price());
                            copyProductIn.setGoods_price(product3.getGoods_price());
                            copyProductIn.setGoods_consumer_price(product3.getGoods_consumer_price());
                            copyProductIn.setCompayny_goods_cd(product3.getCompayny_goods_cd());
                            copyProductIn.setSaleStatusCd(product3.getSaleStatusCd());
                            copyProductIn.setStdPrdYn(product3.getStdPrdYn());
                            copyProductIn.setStatus(product3.getStatus());
                            copyProductIn.setSendstats(product3.getSendstats());
                            codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product3.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                            copyProductIn.setGoods_keyword(codeDivision);
                            int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                            if (ret3 == 1) {
                                inRet += ret3;
                            }
                        }
                        copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                        if (product3.getOPTIONS() == null) continue;
                        for (ProductOptionDTO option2 : product3.getOPTIONS()) {
                            ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                            if (copyOption == null) {
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                option2.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                                ProductDAO.get().insertOptProductInfo(option2);
                            } else {
                                copyOption.setCOMPAYNY_GOODS_CD(product3.getCompayny_goods_cd());
                                copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                copyOption.setOPTEA(option2.getOPTEA());
                                copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                copyOption.setINSERTDT(option2.getINSERTDT());
                                copyOption.setINSERTID(option2.getINSERTID());
                                copyOption.setMODIFYDT(option2.getMODIFYDT());
                                copyOption.setSTATUS(option2.getSTATUS());
                            }
                            ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                            if (copyOptionIn == null) {
                                option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                ProductDAO.get().insertOptProductIn(option2);
                                continue;
                            }
                            copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                            copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                            copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                            copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                            copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                            copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                            copyOptionIn.setOPTEA(option2.getOPTEA());
                            copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                            copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                            copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                            copyOptionIn.setINSERTDT(option2.getINSERTDT());
                            copyOptionIn.setINSERTID(option2.getINSERTID());
                            copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                            copyOptionIn.setSTATUS(option2.getSTATUS());
                        }
                    }
                }
                if ((start += end) < 5000) continue;
                start = 0;
                JsonObject lastProduct = products.get(products.size() - 1).getAsJsonObject();
                lastCreatedDate = lastProduct.get("created_date").getAsString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CommonProgressDialog.get().setValue(beginText.concat(e.getMessage()), 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        CommonProgressDialog.get().setValue(beginText.concat("\ucd1d " + inRet + "\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4."), 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    public static String formatDate(String isoDate) {
        OffsetDateTime dateTime = OffsetDateTime.parse(isoDate);
        return dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto, List<String> specificCodes) throws Exception {
        return null;
    }

    @Override
    public ResultProcessDTO addProcess2(ProductAddProcessDTO proDto, List<String> specificCodes, IProgressMonitor monitor, ShoppingmallDTO dto) throws Exception {
        return null;
    }
}

