/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.common;

import com.google.common.io.CharStreams;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.kdjsystem.mlink.yellim.common.YDMAProperties;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import org.aes256util.AES256Util;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpUtil {
    static String host;
    static Integer port;
    static String webPath;
    static String user;
    static String password;
    static String imagepath;
    private static Session session;
    private static Channel channel;
    private static ChannelSftp channelSftp;
    private static FTPClient ftpClient;
    private static List<String> files;
    private static List<String> directories;
    static FtpUtil instance;

    static {
        session = null;
        channel = null;
        channelSftp = null;
        ftpClient = null;
        files = new ArrayList<String>();
        directories = new ArrayList<String>();
    }

    public static FtpUtil getInstance() throws Exception {
        if (instance == null) {
            instance = new FtpUtil();
        }
        return instance;
    }

    public static void connectFtpDir() throws Exception {
        host = YDMAProperties.getInstance().getAppProperty("ftpimageezup2.host");
        port = Integer.parseInt(YDMAProperties.getInstance().getAppProperty("ftpimageezup2.port"));
        user = YDMAProperties.getInstance().getAppProperty("ftpimageezup2.username");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        user = AES256Util.decrypt((String)user);
        password = YDMAProperties.getInstance().getAppProperty("ftpimageezup2.password");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        password = AES256Util.decrypt((String)password);
        webPath = YDMAProperties.getInstance().getAppProperty("ftpimageezup2.webpath");
        imagepath = YDMAProperties.getInstance().getAppProperty("ftpimageezup2.imagepath");
        try {
            ftpClient = new FTPClient();
            ftpClient.connect(host, port.intValue());
            FtpUtil.showServerReply(ftpClient);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                YDMAStringUtil.Print("Connect failed");
                return;
            }
            boolean success = ftpClient.login(user, password);
            FtpUtil.showServerReply(ftpClient);
            if (!success) {
                YDMAStringUtil.Print("Could not login to the server");
                return;
            }
        }
        catch (IOException ex) {
            YDMAStringUtil.Print("Oops! Something wrong happened");
            ex.printStackTrace();
        }
    }

    public static void connectFtp() throws Exception {
        host = YDMAProperties.getInstance().getAppProperty("ftpezup2.host");
        port = Integer.parseInt(YDMAProperties.getInstance().getAppProperty("ftpezup2.port"));
        user = YDMAProperties.getInstance().getAppProperty("ftpezup2.username");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        user = AES256Util.decrypt((String)user);
        password = YDMAProperties.getInstance().getAppProperty("ftpezup2.password");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        password = AES256Util.decrypt((String)password);
        webPath = YDMAProperties.getInstance().getAppProperty("ftpezup2.webpath");
        imagepath = YDMAProperties.getInstance().getAppProperty("ftpezup2.imagepath");
        try {
            ftpClient = new FTPClient();
            ftpClient.connect(host, port.intValue());
            FtpUtil.showServerReply(ftpClient);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                YDMAStringUtil.Print("Connect failed");
                return;
            }
            boolean success = ftpClient.login(user, password);
            FtpUtil.showServerReply(ftpClient);
            if (!success) {
                YDMAStringUtil.Print("Could not login to the server");
                return;
            }
        }
        catch (IOException ex) {
            YDMAStringUtil.Print("Oops! Something wrong happened");
            ex.printStackTrace();
        }
    }

    private static void showServerReply(FTPClient ftpClient) {
        String[] replies = ftpClient.getReplyStrings();
        if (replies != null && replies.length > 0) {
            String[] stringArray = replies;
            int n = replies.length;
            int n2 = 0;
            while (n2 < n) {
                String aReply = stringArray[n2];
                YDMAStringUtil.Print("SERVER: " + aReply);
                ++n2;
            }
        }
    }

    public static void connect() throws Exception {
        host = YDMAProperties.getInstance().getAppProperty("ftp.host");
        port = Integer.parseInt(YDMAProperties.getInstance().getAppProperty("ftp.port"));
        user = YDMAProperties.getInstance().getAppProperty("ftp.username");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        user = AES256Util.decrypt((String)user);
        password = YDMAProperties.getInstance().getAppProperty("ftp.password");
        AES256Util.getInstance((String)AES256Util.KEY_WORD);
        password = AES256Util.decrypt((String)password);
        webPath = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
        imagepath = YDMAProperties.getInstance().getAppProperty("ftp.imagepath");
        JSch jsch = new JSch();
        session = jsch.getSession(user, host, port.intValue());
        session.setConfig("StrictHostKeyChecking", "no");
        session.setPassword(password);
        session.connect();
        channel = session.openChannel("sftp");
        channel.connect();
        channelSftp = (ChannelSftp)channel;
    }

    public static void disconnect() {
        if (session != null && session.isConnected()) {
            channelSftp.quit();
            channel.disconnect();
            session.disconnect();
        }
    }

    public static void disconnectFtp() throws Exception {
        ftpClient.logout();
        ftpClient.disconnect();
    }

    public static void uploadXmlFileToWeb(char type) throws Exception {
        String remoteDir = "";
        remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
        String templatePath = null;
        String templateFile = null;
        if (type == 'O') {
            templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.orderTemplatePath"));
            templateFile = YDMAProperties.getInstance().getAppProperty("sabang.orderTempateFile");
        } else if (type == 'P') {
            templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.productTemplatePath"));
            templateFile = YDMAProperties.getInstance().getAppProperty("sabang.productTempateFile");
        } else if (type == 'C') {
            templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.claimTemplatePath"));
            templateFile = YDMAProperties.getInstance().getAppProperty("sabang.claimTempateFile");
        } else if (type == 'Q') {
            templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.questionTemplatePath"));
            templateFile = YDMAProperties.getInstance().getAppProperty("sabang.questionTempateFile");
        } else if (type == 'S') {
            templatePath = YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("sabang.pickupExpressSabangNetTemplatePath"));
            templateFile = YDMAProperties.getInstance().getAppProperty("sabang.pickupExpressSabangNetTempateFile");
        }
        String templateFullpath = String.valueOf(templatePath) + File.separator + templateFile;
        FtpUtil.upload(remoteDir, templateFullpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deletefile(String remoteDir, String fileName) throws Exception {
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            FtpUtil.deleteSFtp(remoteDir, fileName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFtps(String remoteDir, List<String> fileNames) throws Exception {
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            FtpUtil.connectFtp();
            try {
                ftpClient.changeWorkingDirectory(remoteDir);
                FtpUtil.showServerReply(ftpClient);
                for (String fileName : fileNames) {
                    if (!ftpClient.deleteFile(fileName)) continue;
                    YDMAStringUtil.Print("Delete - " + fileName);
                }
            }
            finally {
                FtpUtil.disconnectFtp();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFtp(String remoteDir, String fileName) throws Exception {
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            FtpUtil.connectFtp();
            try {
                ftpClient.changeWorkingDirectory(remoteDir);
                FtpUtil.showServerReply(ftpClient);
                if (ftpClient.deleteFile(fileName)) {
                    YDMAStringUtil.Print("Delete - " + fileName);
                }
            }
            finally {
                FtpUtil.disconnectFtp();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSFtp(String remoteDir, String fileName) throws Exception {
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            block8: {
                FtpUtil.connect();
                try {
                    try {
                        channelSftp.cd(remoteDir);
                        channelSftp.rm(fileName);
                    }
                    catch (SftpException e) {
                        e.printStackTrace();
                        FtpUtil.disconnect();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    FtpUtil.disconnect();
                    throw throwable;
                }
                FtpUtil.disconnect();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static boolean isExistsDirSftp(String pathName) {
        boolean success = true;
        try {
            channelSftp.stat(pathName);
        }
        catch (Exception exception) {
            success = false;
            YDMAStringUtil.Print(String.valueOf(pathName) + " not found");
        }
        return success;
    }

    public static boolean isExistsDir(String pathName) {
        boolean success = true;
        try {
            success = ftpClient.cwd(pathName) == 550 ? false : ftpClient.cwd(pathName) == 250;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadnCreateDir(String remoteDir, String localfileName, String tartgetfileName) throws Exception {
        String templatefilename = "";
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            templatefilename = FtpUtil.uploadSFtpSourcToTarget(remoteDir, localfileName, tartgetfileName);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return templatefilename;
        }
    }

    public static String uploadSFtpSourcToTarget(String remoteDir, String localfileName, String tartgetfileName) throws Exception {
        FileInputStream fis = null;
        FtpUtil.connect();
        try {
            if (!FtpUtil.isExistsDirSftp(remoteDir)) {
                channelSftp.mkdir(remoteDir);
            }
            channelSftp.cd(remoteDir);
            File file = new File(localfileName);
            fis = new FileInputStream(file);
            channelSftp.put((InputStream)fis, tartgetfileName);
            YDMAStringUtil.Print("File uploaded successfully - " + file.getAbsolutePath());
        }
        catch (Throwable throwable) {}
        FtpUtil.disconnect();
        return tartgetfileName;
    }

    public static String uploadFtpSourcToTarget(String remoteDir, String localfileName, String tartgetfileName) throws Exception {
        FtpUtil.connectFtp();
        try {
            if (!FtpUtil.isExistsDir(remoteDir)) {
                ftpClient.makeDirectory(remoteDir);
                FtpUtil.showServerReply(ftpClient);
            }
            ftpClient.changeWorkingDirectory(remoteDir);
            FtpUtil.showServerReply(ftpClient);
            File file = new File(localfileName);
            if (!file.canRead()) {
                String fileName = file.getName();
                file.getParentFile().getPath();
                file = new File("C:\\Image" + File.separator + fileName);
            }
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            ftpClient.setFileTransferMode(2);
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                if (ftpClient.storeFile(tartgetfileName, (InputStream)fis)) {
                    YDMAStringUtil.Print("Upload - " + file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {}
        FtpUtil.disconnectFtp();
        return tartgetfileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(String remoteDir, String fileName) throws Exception {
        String templatefilename = "";
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            templatefilename = FtpUtil.uploadSFtp(remoteDir, fileName);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return templatefilename;
        }
    }

    public static String uploadFtp(String remoteDir, String fileName) throws Exception {
        String templatefilename = "";
        FtpUtil.connectFtp();
        try {
            ftpClient.changeWorkingDirectory(remoteDir);
            FtpUtil.showServerReply(ftpClient);
            File file = new File(fileName);
            templatefilename = file.getName();
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            ftpClient.setFileTransferMode(2);
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                if (ftpClient.storeFile(templatefilename, (InputStream)fis)) {
                    YDMAStringUtil.Print("Upload - " + file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {}
        FtpUtil.disconnectFtp();
        return templatefilename;
    }

    public static boolean downFtp(String remoteDir, String fileName) throws Exception {
        String outfile = "C:\\" + fileName;
        FtpUtil.connectFtp();
        try {
            ftpClient.changeWorkingDirectory(remoteDir);
            FtpUtil.showServerReply(ftpClient);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            ftpClient.setFileTransferMode(2);
            File file = new File(outfile);
            Throwable throwable = null;
            Object var5_8 = null;
            try (FileOutputStream fo = new FileOutputStream(file);){
                if (ftpClient.retrieveFile(fileName, (OutputStream)fo)) {
                    YDMAStringUtil.Print("File downloaded successfully - " + outfile);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            FtpUtil.disconnectFtp();
        }
        return true;
    }

    public static String downSFtpFile(String remoteDir, String fileName) throws Exception {
        String file = "";
        FtpUtil.connect();
        try {
            channelSftp.cd(remoteDir);
            InputStream iStream = channelSftp.get(fileName);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader(iStream, StandardCharsets.UTF_8);){
                file = CharStreams.toString((Readable)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            YDMAStringUtil.Print("File downloaded successfully length - " + file.length());
        }
        finally {
            FtpUtil.disconnect();
        }
        return file;
    }

    public static String downFtpFile(String remoteDir, String fileName) throws Exception {
        String file = "";
        FtpUtil.connectFtp();
        try {
            ftpClient.changeWorkingDirectory(remoteDir);
            FtpUtil.showServerReply(ftpClient);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            ftpClient.setFileTransferMode(2);
            InputStream iStream = ftpClient.retrieveFileStream(fileName);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader(iStream, StandardCharsets.UTF_8);){
                file = CharStreams.toString((Readable)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            YDMAStringUtil.Print("File downloaded successfully length - " + file.length());
        }
        finally {
            FtpUtil.disconnectFtp();
        }
        return file;
    }

    public static String[] downSFtpFileWithSplit(String remoteDir, String fileName) throws Exception {
        String[] file = null;
        FtpUtil.connect();
        try {
            channelSftp.cd(remoteDir);
            InputStream iStream = channelSftp.get(fileName);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader(iStream, StandardCharsets.UTF_8);){
                file = CharStreams.toString((Readable)reader).split(";");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            YDMAStringUtil.Print("File downloaded successfully - " + file);
        }
        finally {
            FtpUtil.disconnect();
        }
        return file;
    }

    public static String[] downSFtpFileWithSplitPlus(String remoteDir, String fileName) throws Exception {
        String[] file = null;
        FtpUtil.connect();
        try {
            channelSftp.cd(remoteDir);
            InputStream iStream = channelSftp.get(fileName);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader(iStream, StandardCharsets.UTF_8);){
                file = CharStreams.toString((Readable)reader).split(";;");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            YDMAStringUtil.Print("File downloaded successfully - " + file);
        }
        finally {
            FtpUtil.disconnect();
        }
        return file;
    }

    public static String[] downFtpFileWithSplit(String remoteDir, String fileName) throws Exception {
        String[] file = null;
        FtpUtil.connectFtp();
        try {
            ftpClient.changeWorkingDirectory(remoteDir);
            FtpUtil.showServerReply(ftpClient);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            ftpClient.setFileTransferMode(2);
            InputStream iStream = ftpClient.retrieveFileStream(fileName);
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader(iStream, StandardCharsets.UTF_8);){
                file = CharStreams.toString((Readable)reader).split(";");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            YDMAStringUtil.Print("File downloaded successfully - " + file);
        }
        finally {
            FtpUtil.disconnectFtp();
        }
        return file;
    }

    private static boolean getFileList(FTPClient client, String cw, List<String> files, List<String> directories) throws IOException {
        if (client.changeWorkingDirectory(cw)) {
            FTPFile[] fTPFileArray = client.listFiles();
            int n = fTPFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                FTPFile file = fTPFileArray[n2];
                if (file.isFile()) {
                    files.add(String.valueOf(cw) + file.getName());
                } else {
                    if (!FtpUtil.getFileList(client, String.valueOf(cw) + file.getName() + File.separator, files, directories)) {
                        return false;
                    }
                    directories.add(String.valueOf(cw) + file.getName() + File.separator);
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static String uploadSFtp(String remoteDir, String fileName) throws Exception {
        FileInputStream fis = null;
        String templatefilename = "";
        FtpUtil.connect();
        try {
            channelSftp.cd(remoteDir);
            File file = new File(fileName);
            templatefilename = file.getName();
            fis = new FileInputStream(file);
            channelSftp.put((InputStream)fis, file.getName());
            YDMAStringUtil.Print("File uploaded successfully - " + file.getAbsolutePath());
        }
        catch (Throwable throwable) {}
        if (fis != null) {
            fis.close();
        }
        FtpUtil.disconnect();
        return templatefilename;
    }

    public static void download(String fileName, String localDir) throws Exception {
        byte[] buffer = new byte[1024];
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int readCount;
            String cdDir = fileName.substring(0, fileName.lastIndexOf("/") + 1);
            channelSftp.cd(cdDir);
            File file = new File(fileName);
            bis = new BufferedInputStream(channelSftp.get(file.getName()));
            File newFile = new File(String.valueOf(localDir) + "/" + file.getName());
            FileOutputStream os = new FileOutputStream(newFile);
            bos = new BufferedOutputStream(os);
            while ((readCount = bis.read(buffer)) > 0) {
                ((BufferedOutputStream)bos).write(buffer, 0, readCount);
            }
            YDMAStringUtil.Print("File downloaded successfully - " + file.getAbsolutePath());
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    public static int uploadImage(String prodcd, String sourimage, int imgnum, List<String> comlist) throws Exception {
        FileInputStream fis = null;
        int result = 0;
        String tagimage = String.valueOf(prodcd) + "0" + Integer.toString(imgnum) + ".jpg";
        FtpUtil.connect();
        try {
            try {
                channelSftp.cd(String.valueOf(imagepath) + comlist.get(1));
                File file = new File(sourimage);
                fis = new FileInputStream(file);
                channelSftp.put((InputStream)fis, tagimage);
            }
            catch (Exception e) {
                e.getMessage();
                result = 0;
                result = 1;
            }
        }
        finally {
            result = 1;
        }
        return result;
    }

    public static Vector getFtpLile(String remoteDir) throws Exception {
        Vector filelist = null;
        FtpUtil.connect();
        try {
            channelSftp.cd(remoteDir);
            filelist = channelSftp.ls(remoteDir);
        }
        finally {
            FtpUtil.disconnect();
        }
        return filelist;
    }

    public static int compareFtptoLocalFile(String remoteDir, String localDir, List<String> checkFiles) throws Exception {
        int copyCnt = 0;
        int Check = 0;
        JFrame frame = new JFrame("\uc800\uc7a5\ub41c \ud30c\uc77c\uc744 \uac00\uc9c0\uace0 \uc624\ub294\uc911\uc785\ub2c8\ub2e4.");
        frame.setDefaultCloseOperation(2);
        JProgressBar bar = new JProgressBar();
        Container container = frame.getContentPane();
        container.add((Component)bar, "Center");
        frame.setSize(570, 80);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        frame.setLocation(screen.width / 2 - 285, screen.height / 2 - 40);
        FtpUtil.connect();
        try {
            channelSftp.cd(remoteDir);
            Vector filelist = channelSftp.ls(remoteDir);
            for (String chkFile : checkFiles) {
                File file = new File(localDir.concat(chkFile));
                boolean fileEquals = false;
                ChannelSftp.LsEntry lsEntry = filelist.stream().filter(p -> !p.getFilename().equals(".")).filter(p -> !p.getFilename().equals("..")).filter(p -> p.getFilename().equals(file.getName())).findAny().orElseGet(() -> null);
                if (file.exists()) {
                    long cfr_ignored_0 = file.lastModified() / 1000L / 86400L;
                    SftpATTRS attr = lsEntry.getAttrs();
                    long modTime = (long)attr.getMTime() * 1000L;
                    Date firstDate = new Date(modTime);
                    Path path = Paths.get(localDir, chkFile);
                    FileTime lastModifiedTime = (FileTime)Files.getAttribute(path, "basic:lastModifiedTime", LinkOption.NOFOLLOW_LINKS);
                    Date secondDate = new Date(lastModifiedTime.toMillis());
                    SimpleDateFormat transFormat = new SimpleDateFormat("yyyy-MM-dd");
                    String from = transFormat.format(firstDate);
                    String to = transFormat.format(secondDate);
                    int compare = from.compareTo(to);
                    if (compare == 0) {
                        fileEquals = true;
                    }
                }
                if (fileEquals) continue;
                FtpUtil.downloadWithDir(String.valueOf(remoteDir) + "/" + lsEntry.getFilename(), localDir);
                bar.setMaximum(checkFiles.size());
                bar.setValue(++Check);
                bar.setStringPainted(true);
                frame.setVisible(true);
            }
        }
        finally {
            FtpUtil.disconnect();
            frame.setVisible(false);
        }
        return copyCnt;
    }

    public static int compareFtptoLocalFile(String remoteDir, String localDir) throws Exception {
        int copyCnt = 0;
        int Check = 0;
        JFrame frame = new JFrame("\uc800\uc7a5\ub41c \ud30c\uc77c\uc744 \uac00\uc9c0\uace0 \uc624\ub294\uc911\uc785\ub2c8\ub2e4.");
        frame.setDefaultCloseOperation(2);
        JProgressBar bar = new JProgressBar();
        Container container = frame.getContentPane();
        container.add((Component)bar, "Center");
        frame.setSize(570, 80);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        frame.setLocation(screen.width / 2 - 285, screen.height / 2 - 40);
        FtpUtil.connect();
        try {
            channelSftp.cd(remoteDir);
            Vector filelist = channelSftp.ls(remoteDir);
            File folder = new File(localDir);
            String[] filename = folder.list();
            if (filename == null || filename.length == 0) {
                int i = 2;
                while (i < filelist.size()) {
                    ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)filelist.get(i);
                    if (!lsEntry.getFilename().equals(".") && !lsEntry.getFilename().equals("..")) {
                        FtpUtil.downloadWithDir(String.valueOf(remoteDir) + lsEntry.getFilename(), localDir);
                        ++copyCnt;
                        if (filelist.size() >= Check) {
                            bar.setMaximum(filelist.size());
                            bar.setValue(Check);
                            bar.setStringPainted(true);
                            frame.setVisible(true);
                        }
                        ++Check;
                    }
                    ++i;
                }
            } else {
                int i = 2;
                while (i < filelist.size()) {
                    ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry)filelist.get(i);
                    if (!lsEntry.getFilename().equals(".") && !lsEntry.getFilename().equals("..")) {
                        boolean existed = false;
                        int k = 0;
                        while (k < filename.length) {
                            if (filename[k].equals(lsEntry.getFilename())) {
                                String to;
                                SftpATTRS attr = lsEntry.getAttrs();
                                long modTime = (long)attr.getMTime() * 1000L;
                                Date firstDate = new Date(modTime);
                                Path path = Paths.get(localDir, filename[k]);
                                FileTime lastModifiedTime = (FileTime)Files.getAttribute(path, "basic:lastModifiedTime", LinkOption.NOFOLLOW_LINKS);
                                Date secondDate = new Date(lastModifiedTime.toMillis());
                                SimpleDateFormat transFormat = new SimpleDateFormat("yyyy-MM-dd");
                                String from = transFormat.format(firstDate);
                                int compare = from.compareTo(to = transFormat.format(secondDate));
                                if (compare > 0) break;
                                existed = true;
                                break;
                            }
                            ++k;
                        }
                        if (!existed) {
                            FtpUtil.downloadWithDir(String.valueOf(remoteDir) + lsEntry.getFilename(), localDir);
                            ++copyCnt;
                        }
                        if (filelist.size() >= Check) {
                            bar.setMaximum(filelist.size());
                            bar.setValue(Check);
                            bar.setStringPainted(true);
                            frame.setVisible(true);
                        }
                        ++Check;
                    }
                    ++i;
                }
            }
        }
        finally {
            FtpUtil.disconnect();
            frame.setVisible(false);
        }
        return copyCnt;
    }

    private static void downloadWithDir(String fileName, String localDir) throws Exception {
        byte[] buffer = new byte[1024];
        BufferedInputStream bis = null;
        String cdDir = fileName.substring(0, fileName.lastIndexOf("/") + 1);
        channelSftp.cd(cdDir);
        File file = new File(fileName);
        bis = new BufferedInputStream(channelSftp.get(file.getName()));
        File newFile = new File(String.valueOf(localDir) + "/" + file.getName());
        File parentDir = newFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdir();
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newFile));
        try {
            int readCount;
            while ((readCount = bis.read(buffer)) > 0) {
                ((OutputStream)bos).write(buffer, 0, readCount);
            }
            YDMAStringUtil.Print("File downloaded successfully - " + file.getAbsolutePath());
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                ((OutputStream)bos).close();
            }
        }
    }

    public static void uploadLocalImage(String prodcd, String mainimg, int imgnum, List<String> comlist) {
        try {
            FileInputStream fis = null;
            String imagename = mainimg;
            String SRC_FILE = "";
            BufferedImage img = null;
            URL url = null;
            Image resizeImage = null;
            BufferedImage newImage = null;
            Graphics g = null;
            SRC_FILE = "tmp1";
            try {
                if (imagename.contains("http")) {
                    url = new URL(imagename);
                    img = ImageIO.read(url);
                } else {
                    img = ImageIO.read(new File(imagename));
                }
                resizeImage = img.getScaledInstance(90, 85, 4);
                newImage = new BufferedImage(90, 85, 1);
                g = newImage.getGraphics();
                g.drawImage(resizeImage, 0, 0, null);
                g.dispose();
                ImageIO.write((RenderedImage)newImage, "jpg", new File(SRC_FILE));
                String tagimage = String.valueOf(prodcd) + ".jpg";
                FtpUtil.connect();
                channelSftp.cd(String.valueOf(imagepath) + comlist.get(1) + "/thumb2/");
                File file = new File(SRC_FILE);
                fis = new FileInputStream(file);
                channelSftp.put((InputStream)fis, tagimage);
                if (imagename.contains("http")) {
                    url = new URL(imagename);
                    img = ImageIO.read(url);
                } else {
                    img = ImageIO.read(new File(imagename));
                }
                resizeImage = img.getScaledInstance(25, 25, 4);
                newImage = new BufferedImage(25, 25, 1);
                g = newImage.getGraphics();
                g.drawImage(resizeImage, 0, 0, null);
                g.dispose();
                ImageIO.write((RenderedImage)newImage, "jpg", new File(SRC_FILE));
                FtpUtil.connect();
                channelSftp.cd(String.valueOf(imagepath) + comlist.get(1) + "/thumb1/");
                file = new File(SRC_FILE);
                fis = new FileInputStream(file);
                channelSftp.put((InputStream)fis, tagimage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            YDMAStringUtil.Print("\uc378\ub124\uc77c \uc0dd\uc131\uc644\ub8cc2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

