/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.lotteon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.data.lotteon.IShopLotteOnOrderCommand;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class LotteOnOrderNewCommand
extends IShopLotteOnOrderCommand {
    private static IShopOrderCommand instance = new LotteOnOrderNewCommand();

    public static IShopOrderCommand getIstance() {
        return instance;
    }

    LotteOnOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> ret_list = new ArrayList<ShopOrderMstDto>();
        try {
            String startdt = param.get(0).getStartDt().substring(0, 8);
            String enddt = param.get(0).getEndDt().substring(0, 8);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(startdt);
            Date edate = formatter.parse(enddt);
            long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(sdate);
            cal2.setTime(sdate);
            int i = 0;
            while (i < (int)range) {
                this.getNewOrder(param, ret_list, startdt);
                this.getBeforeDelivery(param, ret_list, startdt);
                this.deliveryCompleted(param, ret_list, startdt);
                cal1.add(5, 1);
                startdt = formatter.format(cal1.getTime());
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub86f\ub370\uc628 \uc2e0\uaddc \uc8fc\ubb38 \uc218\uc9d1 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return ret_list;
    }

    private List<ShopOrderMstDto> getNewOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret_list, String date) throws Exception {
        String json = "{\"srchStrtDt\":\"" + date + "000000\",\"srchEndDt\":\"" + date + "235959\",\"odPrgsStepCd\":\"11\"}";
        Connection.Response response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/delivery/v1/SellerDeliveryProgressStateSearch").header("Authorization", "Bearer " + param.get(0).getApikey()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
        String body = response.body();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
        jsonObject = (JsonObject)jsonObject.get("data");
        JsonArray neworders = (JsonArray)jsonObject.get("deliveryProgressStateList");
        this.getJsonManager(neworders, param, "100", ret_list);
        return ret_list;
    }

    private List<ShopOrderMstDto> getBeforeDelivery(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret_list, String date) throws Exception {
        String json = "{\"srchStrtDt\":\"" + date + "000000\",\"srchEndDt\":\"" + date + "235959\",\"odPrgsStepCd\":\"12\"}";
        Connection.Response response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/delivery/v1/SellerDeliveryProgressStateSearch").header("Authorization", "Bearer " + param.get(0).getApikey()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
        String body = response.body();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
        jsonObject = (JsonObject)jsonObject.get("data");
        JsonArray neworders = (JsonArray)jsonObject.get("deliveryProgressStateList");
        this.getJsonManager(neworders, param, "100", ret_list);
        return ret_list;
    }

    private List<ShopOrderMstDto> deliveryCompleted(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret_list, String date) throws Exception {
        String json = "{\"srchStrtDt\":\"" + date + "000000\",\"srchEndDt\":\"" + date + "235959\",\"odPrgsStepCd\":\"15\"}";
        Connection.Response response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/delivery/v1/SellerDeliveryProgressStateSearch").header("Authorization", "Bearer " + param.get(0).getApikey()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
        String body = response.body();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
        jsonObject = (JsonObject)jsonObject.get("data");
        JsonArray neworders = (JsonArray)jsonObject.get("deliveryProgressStateList");
        this.getJsonManager(neworders, param, "410", ret_list);
        return ret_list;
    }

    private List<ShopOrderMstDto> getJsonManager(JsonArray neworders, List<ShopOrderMstDto> param, String orderStatus, List<ShopOrderMstDto> ret_list) throws Exception {
        try {
            if (neworders != null && neworders.size() > 0) {
                int i = 0;
                while (i < neworders.size()) {
                    JsonObject neworder = (JsonObject)neworders.get(i);
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    dto.setEtc_msg(neworder.get("owhoDttm").getAsString());
                    dto.setP_sku_id(neworder.get("sitmNm").getAsString());
                    dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                    dto.setShopid(param.get(0).getShopid());
                    dto.setShop_userid(param.get(0).getShop_userid());
                    dto.setOrder_id(neworder.get("odNo").getAsString());
                    dto.setMall_product_id(neworder.get("spdNo").getAsString());
                    dto.setSku_id(neworder.get("sitmNo").getAsString());
                    dto.setOrder_status(orderStatus);
                    dto.setP_product_name(neworder.get("spdNm").getAsString());
                    String ordDt = neworder.get("odCmptDttm").getAsString();
                    ordDt = String.valueOf(ordDt.substring(0, 4)) + "-" + ordDt.substring(4, 6) + "-" + ordDt.substring(6, 8) + " " + ordDt.substring(8, 10) + ":" + ordDt.substring(10, 12) + ":" + ordDt.substring(12, 14);
                    dto.setOrder_date(ordDt);
                    dto.setProduct_name(neworder.get("spdNm").getAsString());
                    dto.setP_sku_value(neworder.get("sitmNm").getAsString());
                    dto.setSku_value("");
                    dto.setUser_name(neworder.get("odrNm").getAsString());
                    dto.setUser_email(this.nullcheck(neworder.get("emlAddr")));
                    dto.setUser_id("");
                    dto.setReceive_name(neworder.get("dvpCustNm").getAsString());
                    dto.setSale_cnt(String.valueOf(neworder.get("odQty").getAsInt()));
                    dto.setSale_cost(String.valueOf(neworder.get("slPrc").getAsInt()));
                    int price2 = (int)neworder.get("slAmt").getAsDouble();
                    int expprice = (int)neworder.get("dvCst").getAsDouble();
                    dto.setDelv_cost(String.valueOf(expprice));
                    dto.setTotal_cost(String.valueOf(price2));
                    dto.setPay_cost(String.valueOf(price2 + expprice));
                    dto.setMall_won_cost("0");
                    dto.setReceive_cel(this.phonenumber_check(neworder.get("dvpMphnNo")));
                    dto.setReceive_tel(this.phonenumber_check(neworder.get("dvpTelNo")));
                    String addr = String.valueOf(this.nullcheck(neworder.get("dvpStnmZipAddr"))) + " " + this.nullcheck(neworder.get("dvpStnmDtlAddr"));
                    dto.setReceive_addr(addr);
                    dto.setReceive_zipcode(neworder.get("dvpZipNo").getAsString());
                    dto.setDelv_msg(this.nullcheck(neworder.get("dvMsg")));
                    dto.setUser_cel(this.phonenumber_check(neworder.get("mphnNo")));
                    dto.setCompayny_goods_cd(neworder.get("epdNo").getAsString());
                    dto.setMall_exp_cd(neworder.get("odSeq").getAsString());
                    dto.setWon_cost("0");
                    if (expprice > 0) {
                        dto.setDelivery_method_str2("\uc120\uacb0\uc81c");
                    } else if (expprice == 0) {
                        dto.setDelivery_method_str2("\ubb34\ub8cc");
                    }
                    dto.setResult_code("1");
                    ret_list.add(dto);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub86f\ub370\uc628 \uc8fc\ubb38 \uc2e0\uaddc \uc218\uc9d1 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return ret_list;
    }

    public String phonenumber_check(JsonElement ele) {
        String num = "";
        if (ele.isJsonNull() || ele.toString().equals("null") || ele.toString().trim().equals("")) {
            return num;
        }
        if (ele.getAsString().length() == 12) {
            num = ele.getAsString();
            num = String.valueOf(num.substring(0, 4)) + "-" + num.substring(4, 8) + "-" + num.substring(8, 12);
        } else if (ele.getAsString().length() == 11) {
            num = ele.getAsString();
            num = String.valueOf(num.substring(0, 3)) + "-" + num.substring(3, 7) + "-" + num.substring(7, 11);
        } else {
            num = ele.getAsString();
        }
        return num;
    }

    public String nullcheck(JsonElement ele) {
        if (ele.isJsonNull() || ele.toString().equals("null") || ele.toString().trim().equals("")) {
            return "";
        }
        return ele.getAsString();
    }
}

