/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.alwayz;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.yellim.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.yellim.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.yellim.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.yellim.shop.data.alwayz.IShopOrderAlwayzCommand;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class AlwayzOrderNewCommand
extends IShopOrderAlwayzCommand {
    private static IShopOrderCommand instance = new AlwayzOrderNewCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private AlwayzOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        try {
            ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
            Map<String, String> loginInfo = IShopCommonLogin.loginAlwayzInfo(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid());
            Connection.Response rs = Jsoup.connect((String)"https://alwayz-seller-back.ilevit.com/sellers/orders/status").header("Connection", "keep-alive").header("x-access-token", loginInfo.get("token")).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            String body = rs.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            int status2 = jsonObject.get("status").getAsInt();
            if (status2 == 200) {
                JsonArray dataArray = (JsonArray)jsonObject.get("data");
                int i = 0;
                while (i < dataArray.size()) {
                    JsonObject obj = (JsonObject)dataArray.get(i);
                    String dataStatus = obj.get("status").getAsString();
                    int dataCount = Integer.parseInt(obj.get("totalOrderNum").toString());
                    if (dataStatus.equals("pre-shipping-pre-excel") && dataCount > 0) {
                        JsonArray orderArrys = (JsonArray)obj.get("topKOrders");
                        List<ShopOrderMstDto> orderList = this.setNewOrdersData(orderArrys, param, "100");
                        orderList.forEach(d -> d.setResult_code("1"));
                        ret.addAll(orderList);
                        break;
                    }
                    ++i;
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private List<ShopOrderMstDto> setNewOrdersData(JsonArray orderArrys, List<ShopOrderMstDto> param, String orderStatus) throws Exception {
        ArrayList<ShopOrderMstDto> orderList = new ArrayList<ShopOrderMstDto>();
        try {
            int i = 0;
            while (i < orderArrys.size()) {
                ShopOrderMstDto dto = new ShopOrderMstDto();
                JsonObject object = (JsonObject)orderArrys.get(i);
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setOrder_id(object.get("_id").getAsString());
                dto.setOrder_status(orderStatus);
                JsonObject itemInfo = (JsonObject)object.get("itemInfo");
                dto.setP_product_name(itemInfo.get("itemTitle").getAsString());
                String preShippingTimeStamp = this.dateFormat(object.get("preShippingTimeStamp").getAsString());
                dto.setOrder_date(preShippingTimeStamp);
                dto.setProduct_name(itemInfo.get("itemTitle").getAsString());
                JsonObject selectedOption = (JsonObject)object.get("selectedOption");
                dto.setP_sku_value(this.setOption(object, itemInfo, selectedOption));
                dto.setSku_value(dto.getSku_value());
                dto.setSale_cnt(object.get("quantity").getAsString());
                dto.setUser_name("");
                JsonObject addressInfo = (JsonObject)object.get("addressInfo");
                dto.setReceive_name(addressInfo.get("recipient").getAsString());
                dto.setShopid(param.get(0).getShopid());
                dto.setShop_userid(param.get(0).getShop_userid());
                double amount = object.get("totalPrice").getAsDouble();
                double commissionRate = 0.035;
                int price2 = (int)Math.round(amount - amount * commissionRate);
                dto.setMall_won_cost(String.valueOf(price2));
                dto.setTotal_cost(object.get("totalPrice").getAsString());
                dto.setDelv_cost("0");
                dto.setPay_cost(object.get("totalPrice").getAsString());
                dto.setSale_cost(selectedOption.get("teamPurchasePrice").getAsString());
                dto.setMall_product_id(itemInfo.get("itemId").getAsString());
                dto.setMall_exp_cd(selectedOption.has("optionCode") ? selectedOption.get("optionCode").getAsString() : "");
                dto.setP_sku_id(dto.getSku_value());
                dto.setReceive_zipcode(addressInfo.get("postcode").getAsString());
                dto.setReceive_addr(String.valueOf(addressInfo.get("postcodeAddress").getAsString()) + " " + addressInfo.get("detailAddress").getAsString());
                String recipientPhoneNumber = AlwayzOrderNewCommand.formatPhoneNumber(addressInfo.get("recipientPhoneNumber").getAsString());
                dto.setReceive_tel(recipientPhoneNumber);
                dto.setReceive_cel(recipientPhoneNumber);
                String receivingMethod = addressInfo.get("receivingMethod").getAsString();
                String frontDoorPassword = addressInfo.get("frontDoorPassword").getAsString();
                StringBuilder sb = new StringBuilder();
                if (receivingMethod.equals("door")) {
                    sb.append("\ubb38 \uc55e");
                } else if (receivingMethod.equals("etc")) {
                    sb.append(addressInfo.get("detailForReceivingMethod").getAsString());
                }
                if (!frontDoorPassword.equals("")) {
                    sb.append(", \uacf5\ub3d9\ud604\uad00 \ube44\ubc00\ubc88\ud638 : ").append(frontDoorPassword);
                }
                dto.setDelv_msg(sb.toString());
                dto.setCompno(param.get(0).getCompno());
                dto.setReceive_email("");
                dto.setWon_cost("0");
                dto.setBox_ea("0");
                dto.setResult_code("1");
                dto.setAuthkey1(param.get(0).getAuthkey1());
                dto.setCompayny_goods_cd(this.getCompanyGoodsCd(itemInfo.get("itemId").getAsString(), param.get(0).getShopid()));
                orderList.add(dto);
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc62c\uc6e8\uc774\uc988 \uc2e0\uaddc \uc8fc\ubb38 \uc218\uc9d1 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return orderList;
    }

    private String getCompanyGoodsCd(String itemId, String shopId) {
        String company_goods_cd = "";
        try {
            company_goods_cd = ShopCommonDao.get().getCompanyGoodsCd(itemId, shopId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return company_goods_cd;
    }

    private String setOption(JsonObject object, JsonObject itemInfo, JsonObject selectedOption) {
        JsonObject optionsInfo = (JsonObject)itemInfo.get("optionsInfo");
        JsonArray optionNames = (JsonArray)optionsInfo.get("optionNames");
        JsonArray totalOptions = (JsonArray)optionsInfo.get("totalOptions");
        String option2 = "";
        int selectedValue1 = 0;
        if (optionNames.size() == 2) {
            List optionNameList = IntStream.range(0, optionNames.size()).mapToObj(arg_0 -> ((JsonArray)optionNames).get(arg_0)).map(element -> element.getAsString()).collect(Collectors.toList());
            ArrayList option1 = new ArrayList();
            ArrayList option22 = new ArrayList();
            JsonArray totalOptionsArray1 = totalOptions.get(0).getAsJsonArray();
            IntStream.range(0, totalOptionsArray1.size()).forEach(t -> {
                boolean bl = option1.add(totalOptionsArray1.get(t).getAsJsonObject().get("name").getAsString());
            });
            JsonArray totalOptionsArray2 = totalOptions.get(1).getAsJsonArray();
            IntStream.range(0, totalOptionsArray2.size()).forEach(q -> {
                boolean bl = option22.add(totalOptionsArray2.get(q).getAsJsonObject().get("name").getAsString());
            });
            selectedValue1 = selectedOption.get("0").getAsInt();
            int selectedValue2 = selectedOption.get("1").getAsInt();
            String optionValue1 = (String)option1.get(selectedValue1);
            String optionValue2 = (String)option22.get(selectedValue2);
            option2 = "0. " + (String)optionNameList.get(0) + ": " + optionValue1 + "\n1. " + (String)optionNameList.get(1) + ": " + optionValue2;
        } else if (optionNames.size() == 1) {
            selectedValue1 = selectedOption.get("0").getAsInt();
            String optionName = optionNames.get(0).getAsString();
            String optionValue = totalOptions.get(0).getAsJsonArray().get(selectedValue1).getAsJsonObject().get("name").getAsString();
            option2 = "0. " + optionName + ": " + optionValue;
        }
        return option2;
    }

    private String dateFormat(String inputDate) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(inputDate, inputFormatter);
        String formattedDate = zonedDateTime.format(outputFormatter);
        return formattedDate;
    }

    public static String formatPhoneNumber(String phoneNumber) {
        if (phoneNumber.length() == 11) {
            String part1 = phoneNumber.substring(0, 3);
            String part2 = phoneNumber.substring(3, 7);
            String part3 = phoneNumber.substring(7);
            return String.valueOf(part1) + "-" + part2 + "-" + part3;
        }
        return "Invalid phone number length!";
    }

    @Override
    public void Login(String loginID, String loginPw, String gubun) throws Exception {
    }

    @Override
    public int Search_conf(String URL2, String startdt, String enddt, String searchkeyword) throws Exception {
        return 0;
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return 0;
    }
}

