/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.util;

import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.dao.CategoryDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.CategoryDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import java.util.ArrayList;
import java.util.List;

public class ProductExcelUploadUtil {
    public List<ProductDTO> getProductUploadMapping(List<List<String>> sheetContents) throws Exception {
        ArrayList<ProductDTO> result = new ArrayList<ProductDTO>();
        for (List<String> list : sheetContents) {
            try {
                if (list.get(2).trim().isEmpty() && list.get(3).trim().isEmpty() && list.get(5).trim().isEmpty()) continue;
                ProductDTO dto = new ProductDTO();
                dto.setRowno(list.get(0).trim());
                dto.setShopprodno(list.get(1).trim());
                dto.setGoods_keyword(MallCode.getDomeMallCode(list.get(2).trim()));
                dto.setCompayny_goods_cd(list.get(3).trim());
                String[] shopSplit = list.get(4).trim().split("-");
                if (shopSplit.length == 2) {
                    dto.setShopcd(shopSplit[0]);
                    dto.setSHOP_USERID(shopSplit[1]);
                }
                dto.setGoods_nm(list.get(5).trim());
                CategoryDTO category = CategoryDAO.get().selectCategory(list.get(6).trim());
                if (category != null) {
                    dto.setShop_cid_info(category.getSHOPCATE_JSON());
                    dto.setGmcategnm(category.getFULL_NAME());
                } else {
                    category = CategoryDAO.get().selectCategory("350119000");
                    dto.setShop_cid_info(category.getSHOPCATE_JSON());
                    dto.setGmcategnm(category.getFULL_NAME());
                }
                dto.setGoods_gubun(list.get(7).trim());
                dto.setPartner_id(list.get(8).trim());
                dto.setChar_1_nm(list.get(9).trim());
                dto.setChar_2_nm(list.get(10).trim());
                dto.setModel_nm(list.get(11).trim());
                dto.setOrigin(list.get(12).trim());
                dto.setMaker(list.get(13).trim());
                dto.setBrand_nm(list.get(14).trim());
                dto.setItype(list.get(15).trim());
                dto.setDelv_type(list.get(16).trim());
                dto.setDelv_cost(list.get(17).trim());
                dto.setGoods_price(list.get(21).trim());
                dto.setGoods_cost(list.get(22).trim());
                dto.setInsertdt(list.get(24).trim());
                dto.setModifydt(list.get(25).trim());
                dto.setStatus(dto.getItype());
                dto.setSendstats(String.valueOf(9000));
                result.add(dto);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public int registerUploadProducts(List<ProductDTO> dtos) {
        try {
            int result = ProductDAO.get().insertProductInfo(dtos);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }
}

