/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.yellim.code.MallCode;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dao.CategoryDAO;
import com.kdjsystem.mlink.yellim.dao.DomemallDAO;
import com.kdjsystem.mlink.yellim.dao.ProductDAO;
import com.kdjsystem.mlink.yellim.dto.CategoryDTO;
import com.kdjsystem.mlink.yellim.dto.DomemallDTO;
import com.kdjsystem.mlink.yellim.dto.ProductAddProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.dto.ProductOptionDTO;
import com.kdjsystem.mlink.yellim.dto.ResultProcessDTO;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.factory.IProductAddProcess;
import com.kdjsystem.mlink.yellim.helper.AppConfigHelper;
import com.kdjsystem.mlink.yellim.helper.DateHelper;
import com.kdjsystem.mlink.yellim.helper.JsonHelper;
import com.kdjsystem.mlink.yellim.protocol.WemarketProductResponse;
import com.kdjsystem.mlink.yellim.protocol.WemarketResponse;
import com.kdjsystem.mlink.yellim.ui.CommonProgressDialog;
import com.kdjsystem.mlink.yellim.ui.ProductAddDialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.core.runtime.IProgressMonitor;

public class WemarketProductAddService
implements IProductAddProcess {
    private static final String Host = "http://api.kdjsystem.com:8082/";

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto) throws Exception {
        boolean flag = true;
        int start = 1;
        int infoRet = 0;
        int inRet = 0;
        String startdt = "";
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String beginText = String.format(String.valueOf(DateHelper.getCurrentTimeString()) + "[%s - %s]\r\n", shopInfo.getSHOPNM(), shopInfo.getNICKNM1());
        CommonProgressDialog.get().setValue(beginText.concat("\uc1fc\ud551\ubab0\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4..."), 0);
        try {
            int month = YDMATimeUtil.getMonthsDifference(dto.getSTART_DATE(), dto.getEND_DATE());
            int i = 0;
            while (i <= month) {
                flag = true;
                start = 1;
                if (i == 0) {
                    startdt = dto.getSTART_DATE();
                    YDMATimeUtil.getEndofMonth(dto.getSTART_DATE());
                } else if (i == month) {
                    startdt = YDMATimeUtil.getStartofMonth(dto.getEND_DATE());
                    dto.getEND_DATE();
                } else {
                    startdt = YDMATimeUtil.getNextMonthStartDay(dto.getSTART_DATE(), i);
                    YDMATimeUtil.getEndofMonth(startdt);
                }
                while (flag) {
                    Request request2;
                    ObjectMapper mapper = new ObjectMapper();
                    String url = Host.concat(String.format("wemarket/api/v1/getProductList?%s", "startDate=" + dto.getSTART_DATE() + "&endDate=" + dto.getEND_DATE() + "&currentPage=" + start));
                    OkHttpClient client = AppConfigHelper.getInstance().getOkHttpClient();
                    Response response = client.newCall(request2 = new Request.Builder().url(url).method("GET", null).addHeader("apiKey", shopInfo.getAPIKEY()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build()).execute();
                    String data2 = response.body().string().toString();
                    WemarketResponse productData = (WemarketResponse)mapper.readValue(data2, WemarketResponse.class);
                    if (productData.getResultCode().equals("200")) {
                        if (productData.getData().getList().size() == 0) {
                            CommonProgressDialog.get().setValue(beginText.concat("\ucd1d " + inRet + "\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4."), 100);
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                        for (WemarketProductResponse item : productData.getData().getList()) {
                            if (ProductAddDialog.getIsCanceled()) {
                                return new ResultProcessDTO(0, "", infoRet, inRet);
                            }
                            ProductDTO responseProduct = this.setDataBinding(shopInfo, item, domemallInfos);
                            if (responseProduct == null) continue;
                            responseProducts.add(responseProduct);
                            CommonProgressDialog.get().setValue(beginText.concat("'" + responseProduct.getCompayny_goods_cd() + "' \ubd88\ub7ec\uc624\ub294\uc911..."), 0);
                        }
                        if (responseProducts.size() > 0) {
                            CommonProgressDialog.get().setValue(beginText.concat(String.valueOf(start) + " \ubc88\uc9f8 " + responseProducts.size() + "\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4..."), 0);
                            for (ProductDTO product2 : responseProducts) {
                                int ret;
                                if (ProductAddDialog.getIsCanceled()) {
                                    return new ResultProcessDTO(0, "", infoRet, inRet);
                                }
                                ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                                if (copyProduct == null) {
                                    ret = ProductDAO.get().insertProductInfo(product2);
                                    if (ret == 1) {
                                        infoRet += ret;
                                    }
                                } else {
                                    copyProduct.setClass_cd3(product2.getClass_cd3());
                                    copyProduct.setShop_cid_info(product2.getShop_cid_info());
                                    ret = ProductDAO.get().updateProductInfo(copyProduct);
                                    if (ret == 1) {
                                        infoRet += ret;
                                    }
                                }
                                copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                                ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                                if (copyProductIn == null) {
                                    product2.setPRODSEQ(copyProduct.getPRODSEQ());
                                    int ret2 = ProductDAO.get().insertProductIn(product2);
                                    if (ret2 == 1) {
                                        inRet += ret2;
                                    }
                                } else {
                                    copyProductIn.setClass_cd3(product2.getClass_cd3());
                                    copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                                    copyProductIn.setGoods_nm(product2.getGoods_nm());
                                    copyProductIn.setShopprodno(product2.getShopprodno());
                                    copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                                    copyProductIn.setSaleenddt(product2.getSaleenddt());
                                    copyProductIn.setMarket_price(product2.getMarket_price());
                                    copyProductIn.setGoods_price(product2.getGoods_price());
                                    copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                                    copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                                    copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                                    copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                                    copyProductIn.setStatus(product2.getStatus());
                                    copyProductIn.setSendstats(product2.getSendstats());
                                    String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                                    copyProductIn.setGoods_keyword(codeDivision);
                                    int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                                    if (ret3 == 1) {
                                        inRet += ret3;
                                    }
                                }
                                copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                                if (product2.getOPTIONS() == null) continue;
                                for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                                    ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                                    if (copyOption == null) {
                                        option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                        option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                        ProductDAO.get().insertOptProductInfo(option2);
                                    } else {
                                        copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                        copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                        copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                        copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                        copyOption.setOPTEA(option2.getOPTEA());
                                        copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                        copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                        copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                        copyOption.setINSERTDT(option2.getINSERTDT());
                                        copyOption.setINSERTID(option2.getINSERTID());
                                        copyOption.setMODIFYDT(option2.getMODIFYDT());
                                        copyOption.setSTATUS(option2.getSTATUS());
                                    }
                                    ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                                    if (copyOptionIn == null) {
                                        option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                        option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                        ProductDAO.get().insertOptProductIn(option2);
                                        continue;
                                    }
                                    copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                                    copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                                    copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                                    copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                                    copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                                    copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                                    copyOptionIn.setOPTEA(option2.getOPTEA());
                                    copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                    copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                    copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                                    copyOptionIn.setINSERTDT(option2.getINSERTDT());
                                    copyOptionIn.setINSERTID(option2.getINSERTID());
                                    copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                                    copyOptionIn.setSTATUS(option2.getSTATUS());
                                }
                            }
                        }
                    }
                    ++start;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage() != null ? e.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            CommonProgressDialog.get().setValue(beginText.concat(errorMessage), 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        CommonProgressDialog.get().setValue(beginText.concat("\ucd1d " + inRet + "\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4."), 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    @Override
    public ResultProcessDTO addProcess(ProductAddProcessDTO dto, List<String> specificCodes) throws Exception {
        boolean flag = true;
        int start = 1;
        int infoRet = 0;
        int inRet = 0;
        String startdt = "";
        ShoppingmallDTO shopInfo = dto.getSHOPINFO();
        List<DomemallDTO> domemallInfos = DomemallDAO.get().selectDomemallInfos();
        String beginText = String.format(String.valueOf(DateHelper.getCurrentTimeString()) + "[%s - %s]\r\n", shopInfo.getSHOPNM(), shopInfo.getNICKNM1());
        CommonProgressDialog.get().setValue(beginText.concat("\uc1fc\ud551\ubab0\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4..."), 0);
        try {
            int month = YDMATimeUtil.getMonthsDifference(dto.getSTART_DATE(), dto.getEND_DATE());
            int i = 0;
            while (i <= month) {
                flag = true;
                start = 1;
                if (i == 0) {
                    startdt = dto.getSTART_DATE();
                    YDMATimeUtil.getEndofMonth(dto.getSTART_DATE());
                } else if (i == month) {
                    startdt = YDMATimeUtil.getStartofMonth(dto.getEND_DATE());
                    dto.getEND_DATE();
                } else {
                    startdt = YDMATimeUtil.getNextMonthStartDay(dto.getSTART_DATE(), i);
                    YDMATimeUtil.getEndofMonth(startdt);
                }
                while (flag) {
                    Request request2;
                    ObjectMapper mapper = new ObjectMapper();
                    String url = Host.concat(String.format("wemarket/api/v1/getProductList?%s", "startDate=" + dto.getSTART_DATE() + "&endDate=" + dto.getEND_DATE() + "&currentPage=" + start));
                    OkHttpClient client = AppConfigHelper.getInstance().getOkHttpClient();
                    Response response = client.newCall(request2 = new Request.Builder().url(url).method("GET", null).addHeader("apiKey", shopInfo.getAPIKEY()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build()).execute();
                    String data2 = response.body().string().toString();
                    WemarketResponse productData = (WemarketResponse)mapper.readValue(data2, WemarketResponse.class);
                    if (productData.getResultCode().equals("200")) {
                        if (productData.getData().getList().size() == 0) {
                            CommonProgressDialog.get().setValue(beginText.concat("\ucd1d " + inRet + "\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4."), 100);
                            return new ResultProcessDTO(0, "", infoRet, inRet);
                        }
                        ArrayList<ProductDTO> responseProducts = new ArrayList<ProductDTO>();
                        for (WemarketProductResponse item : productData.getData().getList()) {
                            String specificCode;
                            if (ProductAddDialog.getIsCanceled()) {
                                return new ResultProcessDTO(0, "", infoRet, inRet);
                            }
                            ProductDTO responseProduct = this.setDataBinding(shopInfo, item, domemallInfos);
                            if (specificCodes.size() > 0 && (specificCode = specificCodes.stream().filter(p -> p.equals(responseProduct.getCompayny_goods_cd())).findFirst().orElse("")).equals("") || responseProduct == null) continue;
                            responseProducts.add(responseProduct);
                            CommonProgressDialog.get().setValue(beginText.concat("'" + responseProduct.getCompayny_goods_cd() + "' \ubd88\ub7ec\uc624\ub294\uc911..."), 0);
                        }
                        if (responseProducts.size() > 0) {
                            CommonProgressDialog.get().setValue(beginText.concat(String.valueOf(responseProducts.size()) + "\uac74\uc744 DB\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4..."), 0);
                            for (ProductDTO product2 : responseProducts) {
                                int ret;
                                if (ProductAddDialog.getIsCanceled()) {
                                    return new ResultProcessDTO(0, "", infoRet, inRet);
                                }
                                ProductDTO copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                                if (copyProduct == null) {
                                    ret = ProductDAO.get().insertProductInfo(product2);
                                    if (ret == 1) {
                                        infoRet += ret;
                                    }
                                } else {
                                    copyProduct.setClass_cd3(product2.getClass_cd3());
                                    copyProduct.setShop_cid_info(product2.getShop_cid_info());
                                    ret = ProductDAO.get().updateProductInfo(copyProduct);
                                    if (ret == 1) {
                                        infoRet += ret;
                                    }
                                }
                                copyProduct = ProductDAO.get().selectProductInfo(product2.getCompayny_goods_cd());
                                ProductDTO copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                                if (copyProductIn == null) {
                                    product2.setPRODSEQ(copyProduct.getPRODSEQ());
                                    int ret2 = ProductDAO.get().insertProductIn(product2);
                                    if (ret2 == 1) {
                                        inRet += ret2;
                                    }
                                } else {
                                    copyProductIn.setClass_cd3(product2.getClass_cd3());
                                    copyProductIn.setShop_cid_info(product2.getShop_cid_info());
                                    copyProductIn.setGoods_nm(product2.getGoods_nm());
                                    copyProductIn.setShopprodno(product2.getShopprodno());
                                    copyProductIn.setDelv_r_cost(product2.getDelv_r_cost());
                                    copyProductIn.setSaleenddt(product2.getSaleenddt());
                                    copyProductIn.setMarket_price(product2.getMarket_price());
                                    copyProductIn.setGoods_price(product2.getGoods_price());
                                    copyProductIn.setGoods_consumer_price(product2.getGoods_consumer_price());
                                    copyProductIn.setCompayny_goods_cd(product2.getCompayny_goods_cd());
                                    copyProductIn.setSaleStatusCd(product2.getSaleStatusCd());
                                    copyProductIn.setStdPrdYn(product2.getStdPrdYn());
                                    copyProductIn.setStatus(product2.getStatus());
                                    copyProductIn.setSendstats(product2.getSendstats());
                                    String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(product2.getCompayny_goods_cd()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                                    copyProductIn.setGoods_keyword(codeDivision);
                                    int ret3 = ProductDAO.get().updateProductIn(copyProductIn);
                                    if (ret3 == 1) {
                                        inRet += ret3;
                                    }
                                }
                                copyProductIn = ProductDAO.get().selectProductIn(shopInfo, copyProduct.getPRODSEQ());
                                if (product2.getOPTIONS() == null) continue;
                                for (ProductOptionDTO option2 : product2.getOPTIONS()) {
                                    ProductOptionDTO copyOption = ProductDAO.get().selectOptProductInfo(copyProduct.getPRODSEQ(), option2.getSKUSEQ());
                                    if (copyOption == null) {
                                        option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                        option2.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                        ProductDAO.get().insertOptProductInfo(option2);
                                    } else {
                                        copyOption.setCOMPAYNY_GOODS_CD(product2.getCompayny_goods_cd());
                                        copyOption.setOPTPRODCD(option2.getOPTPRODCD());
                                        copyOption.setOPTPRODNM(option2.getOPTPRODNM());
                                        copyOption.setOPTSPECDES(option2.getOPTSPECDES());
                                        copyOption.setOPTEA(option2.getOPTEA());
                                        copyOption.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                        copyOption.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                        copyOption.setOPTADDAMT(option2.getOPTADDAMT());
                                        copyOption.setINSERTDT(option2.getINSERTDT());
                                        copyOption.setINSERTID(option2.getINSERTID());
                                        copyOption.setMODIFYDT(option2.getMODIFYDT());
                                        copyOption.setSTATUS(option2.getSTATUS());
                                        ProductDAO.get().updateOptProductInfo(copyOption);
                                    }
                                    ProductOptionDTO copyOptionIn = ProductDAO.get().selectOptProductIn(copyProductIn.getSENDSEQ(), option2.getSKUSEQ());
                                    if (copyOptionIn == null) {
                                        option2.setSENDSEQ(Integer.parseInt(copyProductIn.getSENDSEQ()));
                                        option2.setPRODSEQ(Integer.parseInt(copyProduct.getPRODSEQ()));
                                        ProductDAO.get().insertOptProductIn(option2);
                                        continue;
                                    }
                                    copyOptionIn.setSHOPPRODNO(option2.getSHOPPRODNO());
                                    copyOptionIn.setSHOPPRODSKU(option2.getSHOPPRODSKU());
                                    copyOptionIn.setSHOPPRODSKU_NM(option2.getSHOPPRODSKU_NM());
                                    copyOptionIn.setOPTPRODCD(option2.getOPTPRODCD());
                                    copyOptionIn.setOPTPRODNM(option2.getOPTPRODNM());
                                    copyOptionIn.setOPTSPECDES(option2.getOPTSPECDES());
                                    copyOptionIn.setOPTEA(option2.getOPTEA());
                                    copyOptionIn.setOPTSAFESTOCK(option2.getOPTSAFESTOCK());
                                    copyOptionIn.setOPTVERTSTOCK(option2.getOPTVERTSTOCK());
                                    copyOptionIn.setOPTADDAMT(option2.getOPTADDAMT());
                                    copyOptionIn.setINSERTDT(option2.getINSERTDT());
                                    copyOptionIn.setINSERTID(option2.getINSERTID());
                                    copyOptionIn.setMODIFYDT(option2.getMODIFYDT());
                                    copyOptionIn.setSTATUS(option2.getSTATUS());
                                    ProductDAO.get().updateOptProductIn(copyOptionIn);
                                }
                            }
                        }
                    }
                    ++start;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage() != null ? e.getMessage() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958 \ubc1c\uc0dd";
            CommonProgressDialog.get().setValue(beginText.concat(errorMessage), 100);
            return new ResultProcessDTO(-1, "", 0, 0);
        }
        CommonProgressDialog.get().setValue(beginText.concat("\ucd1d " + inRet + "\uac74\uc758 \uc0c1\ud488 \ub370\uc774\ud130 \ucd94\uac00\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4."), 100);
        return new ResultProcessDTO(0, "", infoRet, inRet);
    }

    public ProductDTO setDataBinding(ShoppingmallDTO shopInfo, WemarketProductResponse item, List<DomemallDTO> domemallInfos) {
        ProductDTO responseProduct = new ProductDTO();
        JsonParser parser = new JsonParser();
        try {
            responseProduct.setShopcd(shopInfo.getSHOPCD());
            responseProduct.setShopseq(String.valueOf(shopInfo.getSHOPSEQ()));
            responseProduct.setSHOP_USERID(shopInfo.getSHOPPINGID());
            responseProduct.setGoods_nm(item.getProductName());
            responseProduct.setShopprodno(String.valueOf(item.getProductNo()));
            responseProduct.setInsertdt(item.getSaleStartDate().equals("") ? YDMATimeUtil.getCurrentTimeByYDFormat() : item.getSaleStartDate());
            responseProduct.setSaleenddt(item.getSaleEndDate());
            responseProduct.setMarket_price(String.valueOf(item.getSalePrice()));
            responseProduct.setGoods_price(String.valueOf(item.getSalePrice()));
            responseProduct.setGoods_consumer_price(String.valueOf(item.getSalePrice()));
            responseProduct.setSaleStatusCd(item.getProductStatusName());
            responseProduct.setStatus(this.getStatus(item.getProductStatusName()));
            responseProduct.setSendstats(this.getSendStatus(item.getProductStatusName()));
            OkHttpClient client = AppConfigHelper.getInstance().getOkHttpClient();
            Request request2 = new Request.Builder().url(Host.concat(String.format("wemarket/api/v1/getProductAPI?%s", "productNo=" + responseProduct.getShopprodno()))).method("GET", null).addHeader("apiKey", shopInfo.getAPIKEY()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var9_12 = null;
                try (Response response = client.newCall(request2).execute();){
                    String body = response.body().string().toString();
                    JsonObject bodyObj = (JsonObject)parser.parse(body);
                    JsonObject dataObj = (JsonObject)bodyObj.get("data");
                    JsonObject etc = (JsonObject)dataObj.get("etc");
                    responseProduct.setCompayny_goods_cd(etc.get("sellerProductCode").getAsString());
                    String codeDivision = domemallInfos.stream().filter(p -> p.getCODE_DIVISION().equals(MallCode.getDomeMallProductCodeDivision(etc.get("sellerProductCode").getAsString()))).map(p -> p.getSHOPCD()).findFirst().orElse("");
                    responseProduct.setGoods_keyword(codeDivision);
                    JsonObject basic = (JsonObject)dataObj.get("basic");
                    CategoryDTO category = this.getCategory(basic);
                    responseProduct.setClass_cd3(category.getCODE());
                    responseProduct.setShop_cid_info(category.getSHOPCATE_JSON());
                    responseProduct.setGmcategnm(category.getFULL_NAME());
                    JsonObject optionObj = (JsonObject)dataObj.get("option");
                    if (optionObj.get("selectOptionDepth").getAsInt() > 0) {
                        List<ProductOptionDTO> options = this.getOption(responseProduct, optionObj);
                        responseProduct.setOPTIONS(options);
                        String[] optionNames = options.stream().map(p -> p.getOPTPRODNM()).findFirst().orElse("").split("/");
                        if (optionNames.length == 1) {
                            responseProduct.setChar_1_nm(optionNames[0]);
                        } else if (optionNames.length == 2) {
                            responseProduct.setChar_1_nm(optionNames[0]);
                            responseProduct.setChar_2_nm(optionNames[1]);
                        }
                    } else {
                        responseProduct.setChar_1_nm("\ub2e8\ud488");
                        responseProduct.setChar_1_val("");
                        responseProduct.setChar_2_nm("");
                        responseProduct.setChar_2_val("");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                responseProduct = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            responseProduct = null;
        }
        return responseProduct;
    }

    public CategoryDTO getCategory(JsonObject basic) {
        try {
            String code = JsonHelper.jsonNullStr(basic.get("dcateCode"));
            String lastName = JsonHelper.jsonNullStr(basic.get("dcateName"));
            CategoryDTO category = CategoryDAO.get().selectShoppingMallCategory(code, lastName);
            if (category == null && (category = CategoryDAO.get().selectShoppingMallCategory(code)) == null) {
                category = CategoryDAO.get().selectCategory("350119000");
            }
            return category;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<ProductOptionDTO> getOption(ProductDTO responseProduct, JsonObject optionObj) {
        ArrayList<ProductOptionDTO> options = new ArrayList<ProductOptionDTO>();
        try {
            JsonArray selectOptionValueListArr = optionObj.get("selectOptionValueList").getAsJsonArray();
            int i = 0;
            while (i < selectOptionValueListArr.size()) {
                JsonObject selectOptionValue = selectOptionValueListArr.get(i).getAsJsonObject();
                ProductOptionDTO option2 = new ProductOptionDTO();
                option2.setSKUSEQ(i + 1);
                option2.setSHOPPRODNO(responseProduct.getShopprodno());
                option2.setSHOPPRODSKU(responseProduct.getCompayny_goods_cd().concat("-" + String.valueOf(i + 1)));
                option2.setSHOPPRODSKU_NM(responseProduct.getGoods_nm());
                option2.setPRODCD(responseProduct.getCompayny_goods_cd());
                option2.setOPTPRODCD(responseProduct.getCompayny_goods_cd().concat("-" + String.valueOf(i + 1)));
                String optprodnm = "";
                String optspecdes = "";
                if (optionObj.get("selectOptionDepth").getAsInt() == 1) {
                    optprodnm = optionObj.get("selectOptionTitle1").getAsString();
                    optspecdes = selectOptionValue.get("optionValue1").getAsString();
                } else if (optionObj.get("selectOptionDepth").getAsInt() == 2) {
                    String name1 = optionObj.get("selectOptionTitle1").getAsString();
                    String name2 = optionObj.get("selectOptionTitle2").getAsString();
                    optprodnm = String.valueOf(name1) + "/" + name2;
                    String val1 = selectOptionValue.get("optionValue1").getAsString();
                    String val2 = selectOptionValue.get("optionValue2").getAsString();
                    optspecdes = String.valueOf(val1) + "/" + val2;
                }
                option2.setOPTPRODNM(optprodnm);
                option2.setOPTSPECDES(optspecdes);
                option2.setOPTSAFESTOCK(Integer.parseInt(responseProduct.getGoods_price()));
                option2.setOPTVERTSTOCK(selectOptionValue.get("stockCount").getAsInt());
                option2.setOPTADDAMT(selectOptionValue.get("optAddPrice").getAsInt());
                option2.setINSERTDT(responseProduct.getInsertdt());
                option2.setINSERTID(YDMASessonUtil.getUserInfo().getUserId());
                option2.setSTATUS(selectOptionValue.get("stockCount").getAsInt() > 0 ? "0" : "1");
                options.add(option2);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            options = null;
        }
        return options;
    }

    private String getStatus(String status2) {
        switch (status2) {
            case "\ud310\ub9e4\uc911": 
            case "\ud310\ub9e4\ub300\uae30": {
                return "0";
            }
            case "\ud310\ub9e4\uc885\ub8cc": {
                return "3";
            }
            case "\ud310\ub9e4\uc911\uc9c0": {
                return "1";
            }
        }
        return "";
    }

    private String getSendStatus(String status2) {
        switch (status2) {
            case "\ud310\ub9e4\ub300\uae30": {
                return String.valueOf(9000);
            }
            case "\ud310\ub9e4\uc911": {
                return String.valueOf(8000);
            }
            case "\ud310\ub9e4\uc885\ub8cc": {
                return String.valueOf(3000);
            }
            case "\ud310\ub9e4\uc911\uc9c0": {
                return String.valueOf(4000);
            }
        }
        return "";
    }

    @Override
    public ResultProcessDTO addProcess2(ProductAddProcessDTO proDto, List<String> specificCodes, IProgressMonitor monitor, ShoppingmallDTO dto) throws Exception {
        return null;
    }
}

