/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.dao;

import com.kdjsystem.mlink.yellim.common.TimeUtils;
import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit2;
import com.kdjsystem.mlink.yellim.data.dao.NoticeInfoDto;
import com.kdjsystem.mlink.yellim.data.dao.ShopAddProdInfoDto;
import com.kdjsystem.mlink.yellim.data.dao.ShopOptProdInfoDto;
import com.kdjsystem.mlink.yellim.dto.ProductDomeAllItemDto;
import com.kdjsystem.mlink.yellim.shop.common.QueryStringUtils;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductOptionDto;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinOption;
import com.kdjsystem.mlink.yellim.shop.domesin.DomesinOptionList;
import com.kdjsystem.mlink.yellim.shop.mlink.MLinkShopDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;

public class ProductDomeAllItemDao {
    private static ProductDomeAllItemDao instance = new ProductDomeAllItemDao();

    public static ProductDomeAllItemDao get() {
        return instance;
    }

    public List<ProductDomeAllItemDto> getProductAll(List<String> domeCode, String prodFrom, String prodTo, int lowPrice, int highPrice, int option_YN, int edit_YN, int date_sort, int keyword_YN, int productStat, String searchAll, String searchPart, String searchText, int delv_type, int noticeYN, int search_date_type, int text_option, int opt_outofstock, int search_img) throws Exception {
        ArrayList<ProductDomeAllItemDto> list = new ArrayList<ProductDomeAllItemDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit2.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT dome_code, \r\n");
                sql.append("\t   icode, \r\n");
                sql.append("\t   COALESCE(iname,'') as iname, \r\n");
                sql.append("\t   COALESCE(cid,'') as cid, \r\n");
                sql.append("\t   COALESCE(es_code,'') as es_code, \r\n");
                sql.append("\t   COALESCE(shop_cid_info,'') as shop_cid_info, \r\n");
                sql.append("\t   COALESCE(cate_fullname,'') as cate_fullname, \r\n");
                sql.append("\t   COALESCE(delivery_amount,0) as delivery_amount, \r\n");
                sql.append("\t   COALESCE(keyword,'') as keyword, \r\n");
                sql.append("\t   COALESCE(price,0) as price, \r\n");
                sql.append("\t   COALESCE(content,'') as content, \r\n");
                sql.append("\t   COALESCE(img, '') as img,");
                sql.append("\t   COALESCE(select_option,'') as select_option, \r\n");
                sql.append("\t   COALESCE(status,'') as status, \r\n");
                sql.append("\t   COALESCE(reg_datetime,'') as reg_datetime, \r\n");
                sql.append("\t   COALESCE(up_datetime,'') as up_datetime, \r\n");
                sql.append("\t   COALESCE(gosi_code,'') as gosi_code, \r\n");
                sql.append("\t   COALESCE(gosi_info,'') as gosi_info, \r\n");
                sql.append("\t   COALESCE(delivery_type,'') as delivery_type, \r\n");
                sql.append("\t   COALESCE(text_option,'') as text_option, \r\n");
                sql.append("\t   COALESCE(vender_code,'') as vender_code, \r\n");
                sql.append("\t   COALESCE(delivery_qty,'') as delivery_qty, \r\n");
                sql.append("\t   COALESCE(limit_price,0) as limit_price, \r\n");
                sql.append("\t   COALESCE(notice,'') as notice, \r\n");
                sql.append("\t   COALESCE(text_option,'') as text_option, \r\n");
                sql.append("\t   COALESCE(cid,'') as cid \r\n");
                sql.append("  FROM shopprodinfo_all \r\n");
                sql.append(" WHERE reg_datetime <> '' \r\n");
                String param = domeCode.stream().map(name -> "'" + name + "'").collect(Collectors.joining(","));
                if (param.equals("")) {
                    sql.append("AND 1=2");
                } else {
                    sql.append(String.format(" AND dome_code IN(%s) \r\n", param));
                }
                if (search_date_type == 0) {
                    if (!prodFrom.equals("")) {
                        sql.append(String.format("AND reg_datetime >= '%s' AND reg_datetime <= '%s' \r\n", prodFrom, prodTo));
                    } else {
                        sql.append(String.format("AND reg_datetime <= '%s' \r\n", prodTo));
                    }
                } else if (search_date_type == 1) {
                    if (!prodFrom.equals("")) {
                        sql.append(String.format("AND up_datetime >= '%s' AND up_datetime <= '%s' \r\n", prodFrom, prodTo));
                    } else {
                        sql.append(String.format("AND up_datetime <= '%s' \r\n", prodTo));
                    }
                }
                sql.append("AND price >= ? AND price <= ? \r\n");
                if (option_YN == 2 || option_YN == 3) {
                    if (option_YN == 2) {
                        sql.append("AND select_option != '' \r\n");
                    } else {
                        sql.append("AND select_option = '' \r\n");
                    }
                }
                if (edit_YN == 2 || edit_YN == 3) {
                    if (edit_YN == 2) {
                        sql.append("AND vender_code != '' \r\n");
                    } else {
                        sql.append("AND vender_code = '' \r\n");
                    }
                }
                if (keyword_YN == 2 || keyword_YN == 3) {
                    if (keyword_YN == 2) {
                        sql.append("AND keyword != '' \r\n");
                    } else {
                        sql.append("AND (keyword IS NULL OR keyword = '')\r\n");
                    }
                }
                if (productStat == 2 || productStat == 3) {
                    if (productStat == 2) {
                        sql.append("AND status = '0' \r\n");
                    } else if (productStat == 3) {
                        sql.append("AND status = '1' \r\n");
                    }
                }
                if (delv_type == 2 || delv_type == 3 || delv_type == 4 || delv_type == 5) {
                    if (delv_type == 2) {
                        sql.append("AND delivery_type = '0' \r\n");
                    } else if (delv_type == 3) {
                        sql.append("AND delivery_type = '1' \r\n");
                    } else if (delv_type == 4) {
                        sql.append("AND delivery_type = '2' \r\n");
                    } else if (delv_type == 5) {
                        sql.append("AND delivery_type = '3' \r\n");
                    }
                }
                if (noticeYN == 2 || noticeYN == 3) {
                    if (noticeYN == 2) {
                        sql.append("AND notice != '' \r\n");
                    } else {
                        sql.append("AND notice = '' \r\n");
                    }
                }
                if (text_option == 2 || text_option == 3) {
                    if (text_option == 2) {
                        sql.append("AND text_option != '' \r\n");
                    } else {
                        sql.append("AND text_option = '' \r\n");
                    }
                }
                if (opt_outofstock == 2 || opt_outofstock == 3) {
                    if (opt_outofstock == 2) {
                        sql.append("AND select_option like '%\ud488\uc808%' \r\n");
                    } else {
                        sql.append("AND select_option not like '%\ud488\uc808%' \r\n");
                    }
                }
                List<String> cols = Arrays.asList("  AND ( ", "  (icode %s)", " OR (iname %s)", " OR (cid %s)", " OR (keyword %s)", " OR (icountry %s)", " OR (maker %s)", " OR (brand %s) )");
                if (!searchText.contains(",")) {
                    if (searchAll.equals("")) {
                        String query = "";
                        if (searchPart.equals("\ubd80\ubd84\uc77c\uce58")) {
                            query = cols.stream().map(p -> String.format(p, " LIKE '%" + searchText + "%'")).collect(Collectors.joining());
                            sql.append(query);
                        } else {
                            query = cols.stream().map(p -> String.format(p, " = '" + searchText + "'")).collect(Collectors.joining());
                            sql.append(query);
                        }
                    } else if (searchPart.equals("\ubd80\ubd84\uc77c\uce58")) {
                        sql.append(String.format(" AND %s LIKE '%s%s%s' ", searchAll, "%", searchText, "%"));
                    } else {
                        sql.append(String.format(" AND %s = '%s' ", searchAll, searchText));
                    }
                } else if (searchText.contains(",")) {
                    String multi_searchText = searchText.replace(" ", "").trim();
                    if (searchAll.equals("")) {
                        String query = "";
                        if (searchPart.equals("\ubd80\ubd84\uc77c\uce58")) {
                            query = cols.stream().map(p -> String.format(p, " ~ '" + multi_searchText.replace(",", "|") + "'")).collect(Collectors.joining());
                            sql.append(query);
                        } else {
                            query = cols.stream().map(p -> String.format(p, " ~ '^" + multi_searchText.replace(",", "$|^") + "$'")).collect(Collectors.joining());
                            sql.append(query);
                        }
                    } else if (searchPart.equals("\ubd80\ubd84\uc77c\uce58")) {
                        sql.append(String.format(" AND %s ~ '%s' ", searchAll, multi_searchText.replace(",", "|")));
                    } else {
                        sql.append(String.format(" AND %s ~ '^%s$' ", searchAll, multi_searchText.replace(",", "$|^")));
                    }
                }
                if (date_sort == 2 || date_sort == 3 || date_sort == 4 || date_sort == 5) {
                    if (date_sort == 2) {
                        sql.append(" ORDER BY reg_datetime desc \r\n");
                    } else if (date_sort == 3) {
                        sql.append(" ORDER BY up_datetime desc \r\n");
                    } else if (date_sort == 4) {
                        sql.append(" ORDER BY reg_datetime asc \r\n");
                    } else if (date_sort == 5) {
                        sql.append(" ORDER BY up_datetime asc \r\n");
                    }
                } else {
                    sql.append(" ORDER BY reg_datetime desc");
                }
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setInt(1, lowPrice);
                pstmt.setInt(2, highPrice);
                YDMAStringUtil.Print("[\ubd88\uce5c\uc808\ud55c \ub3c4\ub9e4 \uc0c1\ud488 \uac80\uc0c9] " + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDomeAllItemDto dto = new ProductDomeAllItemDto();
                    dto.setDome_code(rs.getString("dome_code"));
                    dto.setIcode(rs.getString("icode"));
                    dto.setIname(rs.getString("iname").replaceAll("[\\p{C}]", ""));
                    dto.setUrl(rs.getString("cid"));
                    dto.setEs_code(rs.getString("es_code"));
                    dto.setShop_cid_info(rs.getString("shop_cid_info"));
                    dto.setCate_fullname(rs.getString("cate_fullname"));
                    dto.setDelivery_amount(rs.getInt("delivery_amount"));
                    dto.setKeyword(rs.getString("keyword"));
                    dto.setPrice(rs.getInt("price"));
                    dto.setContent(rs.getString("content"));
                    dto.setImg(rs.getString("img"));
                    dto.setSelect_option(rs.getString("select_option"));
                    dto.setStatus(rs.getString("status"));
                    dto.setReg_datetime(rs.getString("reg_datetime"));
                    dto.setUp_datetime(rs.getString("up_datetime"));
                    dto.setGosi_code(rs.getString("gosi_code"));
                    dto.setGosi_info(rs.getString("gosi_info"));
                    dto.setDelivery_type(rs.getString("delivery_type"));
                    dto.setCateg_nm(rs.getString("cate_fullname"));
                    dto.setText_option(rs.getString("text_option"));
                    dto.setSearch(this.setSearchData(rs.getString("dome_code")));
                    dto.setVender_code(rs.getString("vender_code"));
                    dto.setDelivery_qty(rs.getString("delivery_qty"));
                    dto.setLimit_price(rs.getInt("limit_price"));
                    dto.setNotice(rs.getString("notice"));
                    dto.setText_option(rs.getString("text_option"));
                    dto.setUrl(rs.getString("cid"));
                    dto.setCert_type("0");
                    dto.setIslimit("0");
                    dto.setIsreturn("0");
                    dto.setItype("0");
                    dto.setTax("0");
                    dto.setIcountry("\uae30\ud0c0");
                    dto.setMaker("\ud611\ub825\uc5c5\uccb4");
                    dto.setAdult("0");
                    dto.setPrice_consumer(rs.getInt("price"));
                    ProductDomeAllItemDto item = new ProductDomeAllItemDto(dto);
                    String full_cateName = "";
                    try {
                        full_cateName = MLinkShopDao.getNewCategoryFullCateName(dto.getEs_code());
                        item.setCateg_nm(full_cateName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    list.add(item);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    private String setSearchData(String input) {
        String value = "";
        switch (input) {
            case "11": {
                value = "shop9987";
                break;
            }
            case "12": {
                value = "\ub3c4\ub9e4\ucc1c";
                break;
            }
            case "18": {
                value = "shop9985";
                break;
            }
            case "19": {
                value = "\ubc14\ub098\ub098B2B";
                break;
            }
            case "25": {
                value = "\ub3c4\ub9e4\ud1a0\ud53c\uc544";
                break;
            }
            case "17": {
                value = "shop9986";
                break;
            }
            case "21": {
                value = "\ucf54\uc2a4\ucf54\uc570\uc54c\uc624";
                break;
            }
            case "22": {
                value = "\uc0dd\ud65c\uacf5\uac04\uc13c\ud130";
                break;
            }
            case "23": {
                value = "\ube44\ubc14\ub370\uc774B2B\uc885\ud569\uc1fc\ud551\ubab0";
                break;
            }
            case "24": {
                value = "\ud380\ud0c0\uc2a4\ud2f1B2B";
                break;
            }
            case "34": {
                value = "shop0000";
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }

    public List<ProductDomeAllItemDto> getProductUser(List<String> domeCode, String prodFrom, String prodTo, int lowPrice, int highPrice, int option_YN, int edit_YN, int date_sort, int keyword_YN, int productStat, String searchAll, String searchPart, String searchText, int delv_type, int noticeYN, int search_date_type, int text_option, int opt_outofstock, int textSearchYN) throws Exception {
        ArrayList<ProductDomeAllItemDto> list = new ArrayList<ProductDomeAllItemDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT id,");
                sql.append("\t   userid,");
                sql.append("\t   dome_code,");
                sql.append("\t   icode,");
                sql.append("\t   IFNULL(iname, '') as iname,");
                sql.append("\t   IFNULL(cid, '') as cid,");
                sql.append("\t   IFNULL(es_code, '') as es_code,");
                sql.append("\t   IFNULL(shop_cid_info, '') as shop_cid_info,");
                sql.append("\t   IFNULL(cate_fullname, '') as cate_fullname,");
                sql.append("\t   IFNULL(icountry, '') as icountry,");
                sql.append("\t   IFNULL(cate_dept, '') as cate_dept,");
                sql.append("\t   IFNULL(maker, '') as cate_fullname,");
                sql.append("\t   IFNULL(cate_fullname, '') as cate_fullname,");
                sql.append("\t   IFNULL(cate_fullname, '') as cate_fullname,");
                sql.append("\t   IFNULL(delivery_amount,0) as delivery_amount,");
                sql.append("\t   IFNULL(keyword, '') as keyword,");
                sql.append("\t   IFNULL(price,0) as price,");
                sql.append("\t   IFNULL(content, '') as content,");
                sql.append("\t   IFNULL(img, '') as img,");
                sql.append("\t   IFNULL(select_option, '') as select_option,");
                sql.append("\t   IFNULL(status, '') as status,");
                sql.append("\t   IFNULL(reg_datetime, '') as reg_datetime,");
                sql.append("\t   IFNULL(up_datetime, '') as up_datetime,");
                sql.append("\t   IFNULL(gosi_code, '') as gosi_code,");
                sql.append("\t   IFNULL(gosi_info, '') as gosi_info, \r\n");
                sql.append("\t   IFNULL(delivery_type, '') as delivery_type, \r\n");
                sql.append("\t   IFNULL(text_option, '') as text_option, \r\n");
                sql.append("\t   IFNULL(delivery_qty, '') as delivery_qty, \r\n");
                sql.append("\t   IFNULL(limit_price,0) as limit_price, \r\n");
                sql.append("\t   IFNULL(notice, '') as notice, \r\n");
                sql.append("\t   IFNULL(a_vender_code, '') as a_vender_code, \r\n");
                sql.append("\t   IFNULL(a_status, '') as a_status, \r\n");
                sql.append("\t   IFNULL(cid, '') as cid, \r\n");
                sql.append("\t   IFNULL(img_text_detected, '') as img_text_detected \r\n");
                sql.append("  FROM shopprodinfo_user");
                sql.append(" WHERE reg_datetime <> '' AND userid = ? ");
                String param = domeCode.stream().map(name -> "'" + name + "'").collect(Collectors.joining(","));
                if (param.equals("")) {
                    sql.append("AND 1=2");
                } else {
                    sql.append(String.format(" AND dome_code IN(%s) \r\n", param));
                }
                if (search_date_type == 0) {
                    if (!prodFrom.equals("")) {
                        sql.append(String.format("AND reg_datetime >= '%s' AND reg_datetime <= '%s' \r\n", prodFrom, prodTo));
                    } else {
                        sql.append(String.format("AND reg_datetime <= '%s' \r\n", prodTo));
                    }
                } else if (search_date_type == 1) {
                    if (!prodFrom.equals("")) {
                        sql.append(String.format("AND up_datetime >= '%s' AND up_datetime <= '%s' \r\n", prodFrom, prodTo));
                    } else {
                        sql.append(String.format("AND up_datetime <= '%s' \r\n", prodTo));
                    }
                }
                sql.append("AND price >= ? AND price <= ? \r\n");
                if (option_YN == 2 || option_YN == 3) {
                    if (option_YN == 2) {
                        sql.append("AND select_option != '' \r\n");
                    } else {
                        sql.append("AND select_option = '' \r\n");
                    }
                }
                if (edit_YN == 2 || edit_YN == 3) {
                    if (edit_YN == 2) {
                        sql.append("AND a_vender_code != '' \r\n");
                    } else {
                        sql.append("AND a_vender_code = '' \r\n");
                    }
                }
                if (keyword_YN == 2 || keyword_YN == 3) {
                    if (keyword_YN == 2) {
                        sql.append("AND keyword != '' \r\n");
                    } else {
                        sql.append("AND (keyword IS NULL OR keyword = '')\r\n");
                    }
                }
                if (productStat != 0 && productStat != 1) {
                    if (productStat == 2) {
                        sql.append("AND status = '0' \r\n");
                    } else if (productStat == 3) {
                        sql.append("AND status = '1' \r\n");
                    } else if (productStat == 4) {
                        sql.append("AND a_status = '0' \r\n");
                    } else {
                        sql.append("AND a_status = '1' \r\n");
                    }
                }
                if (delv_type == 2 || delv_type == 3 || delv_type == 4 || delv_type == 5) {
                    if (delv_type == 2) {
                        sql.append("AND delivery_type = '0' \r\n");
                    } else if (delv_type == 3) {
                        sql.append("AND delivery_type = '1' \r\n");
                    } else if (delv_type == 4) {
                        sql.append("AND delivery_type = '2' \r\n");
                    } else if (delv_type == 5) {
                        sql.append("AND delivery_type = '3' \r\n");
                    }
                }
                if (noticeYN == 2 || noticeYN == 3) {
                    if (noticeYN == 2) {
                        sql.append("AND notice != '' \r\n");
                    } else {
                        sql.append("AND notice = '' \r\n");
                    }
                }
                if (text_option == 2 || text_option == 3) {
                    if (text_option == 2) {
                        sql.append("AND text_option != '' \r\n");
                    } else {
                        sql.append("AND text_option = '' \r\n");
                    }
                }
                if (opt_outofstock == 2 || opt_outofstock == 3) {
                    if (opt_outofstock == 2) {
                        sql.append("AND select_option like '%\ud488\uc808%' \r\n");
                    } else {
                        sql.append("AND select_option not like '%\ud488\uc808%' \r\n");
                    }
                }
                if (textSearchYN == 3 || textSearchYN == 4) {
                    if (textSearchYN == 3) {
                        sql.append("AND img_text_detected = 1 \r\n");
                    } else if (textSearchYN == 4) {
                        sql.append("AND img_text_detected = 0 \r\n");
                    }
                }
                List<String> cols = Arrays.asList("  AND ( ", "  (icode %s)", " OR (iname %s)", " OR (cid %s)", " OR (keyword %s)", " OR (icountry %s)", " OR (maker %s)", " OR (brand %s) )");
                if (!searchText.contains(",")) {
                    if (searchAll.equals("")) {
                        String query = "";
                        if (searchPart.equals("\ubd80\ubd84\uc77c\uce58")) {
                            query = cols.stream().map(p -> String.format(p, " LIKE '%" + searchText + "%'")).collect(Collectors.joining());
                            sql.append(query);
                        } else {
                            query = cols.stream().map(p -> String.format(p, " = '" + searchText + "'")).collect(Collectors.joining());
                            sql.append(query);
                        }
                    } else if (searchPart.equals("\ubd80\ubd84\uc77c\uce58")) {
                        sql.append(String.format(" AND %s LIKE '%s%s%s' ", searchAll, "%", searchText, "%"));
                    } else {
                        sql.append(String.format(" AND %s = '%s' ", searchAll, searchText));
                    }
                } else if (searchText.contains(",")) {
                    String multi_searchText = searchText.replace(" ", "").trim();
                    if (searchAll.equals("")) {
                        String query = "";
                        if (searchPart.equals("\ubd80\ubd84\uc77c\uce58")) {
                            query = cols.stream().map(p -> String.format(p, " REGEXP ('" + searchText.replace(" ", "").replace(",", "+|").trim() + "')")).collect(Collectors.joining());
                            sql.append(query);
                        } else {
                            query = cols.stream().map(p -> String.format(p, " REGEXP ('^" + searchText.replace(" ", "").replace(",", "$|^").trim() + "$')")).collect(Collectors.joining());
                            sql.append(query);
                        }
                    } else if (searchPart.equals("\ubd80\ubd84\uc77c\uce58")) {
                        multi_searchText = multi_searchText.replace(",", "+|");
                        sql.append(String.format(" AND M.%s REGEXP ('%s') ", searchAll, multi_searchText));
                    } else {
                        multi_searchText = "^" + multi_searchText.replace(",", "$|^") + "$";
                        sql.append(String.format(" AND M.%s REGEXP ('%s') ", searchAll, multi_searchText));
                    }
                }
                if (date_sort == 2 || date_sort == 3 || date_sort == 4 || date_sort == 5) {
                    if (date_sort == 2) {
                        sql.append(" ORDER BY reg_datetime desc \r\n");
                    } else if (date_sort == 3) {
                        sql.append(" ORDER BY up_datetime desc \r\n");
                    } else if (date_sort == 4) {
                        sql.append(" ORDER BY reg_datetime asc \r\n");
                    } else if (date_sort == 5) {
                        sql.append(" ORDER BY up_datetime asc \r\n");
                    }
                } else {
                    sql.append(" ORDER BY reg_datetime desc");
                }
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setInt(2, lowPrice);
                pstmt.setInt(3, highPrice);
                YDMAStringUtil.Print("[\ubd88\uce5c\uc808\ud55c \ub3c4\ub9e4 \uc0c1\ud488 \uc720\uc800 \uac80\uc0c9] " + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDomeAllItemDto dto = new ProductDomeAllItemDto();
                    dto.setId(rs.getInt("id"));
                    dto.setUserid(rs.getString("userid"));
                    dto.setDome_code(rs.getString("dome_code"));
                    dto.setIcode(rs.getString("icode"));
                    dto.setIname(rs.getString("iname").replaceAll("[\\p{C}]", ""));
                    dto.setCid(rs.getString("es_code"));
                    dto.setEs_code(rs.getString("es_code"));
                    dto.setShop_cid_info(rs.getString("shop_cid_info"));
                    dto.setDelivery_amount(rs.getInt("delivery_amount"));
                    dto.setKeyword(rs.getString("keyword"));
                    dto.setPrice(rs.getInt("price"));
                    dto.setContent(rs.getString("content"));
                    dto.setImg(rs.getString("img"));
                    dto.setSelect_option(rs.getString("select_option"));
                    dto.setStatus(rs.getString("status"));
                    dto.setReg_datetime(rs.getString("reg_datetime"));
                    dto.setUp_datetime(rs.getString("up_datetime"));
                    dto.setGosi_code(rs.getString("gosi_code"));
                    dto.setGosi_info(rs.getString("gosi_info"));
                    dto.setDelivery_type(rs.getString("delivery_type"));
                    dto.setCateg_nm(rs.getString("cate_fullname"));
                    dto.setText_option(rs.getString("text_option"));
                    dto.setDelivery_qty(rs.getString("delivery_qty"));
                    dto.setSearch(this.setSearchData(rs.getString("dome_code")));
                    dto.setUpdate_vender_code(rs.getString("a_vender_code"));
                    dto.setUpdate_status(rs.getString("a_status"));
                    dto.setLimit_price(rs.getInt("limit_price"));
                    dto.setNotice(rs.getString("notice"));
                    dto.setUrl(rs.getString("cid"));
                    dto.setImg_text_detected(rs.getString("img_text_detected"));
                    dto.setCert_type("0");
                    dto.setIslimit("0");
                    dto.setIsreturn("0");
                    dto.setItype("0");
                    dto.setTax("0");
                    dto.setIcountry("\uae30\ud0c0");
                    dto.setMaker("\ud611\ub825\uc5c5\uccb4");
                    dto.setAdult("0");
                    dto.setPrice_consumer(rs.getInt("price"));
                    ProductDomeAllItemDto item = new ProductDomeAllItemDto(dto);
                    String full_cateName = "";
                    try {
                        full_cateName = MLinkShopDao.getNewCategoryFullCateName(dto.getEs_code());
                        item.setCateg_nm(full_cateName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    list.add(item);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int updateProductDomeInfo(ProductDomeAllItemDto dto) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        try (Connection connection = DBCPInit.getInstance().getConnection();){
            try {
                ArrayList<String> fileds = new ArrayList<String>();
                fileds.add("INAME");
                fileds.add("KEYWORD");
                fileds.add("SHOP_CID_INFO");
                fileds.add("SELECT_OPTION");
                fileds.add("ES_CODE");
                fileds.add("MAKER");
                fileds.add("ICOUNTRY");
                fileds.add("TAX");
                fileds.add("STATUS");
                fileds.add("DELIVERY_TYPE");
                fileds.add("DELIVERY_AMOUNT");
                fileds.add("R_DELIVERY_AMOUNT");
                fileds.add("PRICE");
                fileds.add("OPTION_USE");
                fileds.add("IMG");
                fileds.add("CONTENT");
                fileds.add("CERT_TYPE");
                fileds.add("CERT");
                fileds.add("CERT_NO");
                fileds.add("GOSI_CODE");
                fileds.add("GOSI_INFO");
                fileds.add("UP_DATETIME");
                String query = QueryStringUtils.queryStringUpdate(fileds, "shopprodinfo_user").concat(" WHERE ID = ? ");
                pstmt = connection.prepareStatement(query);
                int i = 0;
                pstmt.setString(++i, dto.getIname());
                pstmt.setString(++i, dto.getKeyword());
                pstmt.setString(++i, dto.getShop_cid_info());
                pstmt.setString(++i, dto.getSelect_option());
                pstmt.setString(++i, dto.getEs_code());
                pstmt.setString(++i, dto.getMaker());
                pstmt.setString(++i, dto.getIcountry());
                pstmt.setString(++i, dto.getTax());
                pstmt.setString(++i, dto.getStatus());
                pstmt.setString(++i, dto.getDelivery_type());
                pstmt.setInt(++i, dto.getDelivery_amount());
                pstmt.setInt(++i, Integer.parseInt(dto.getR_delivery_amount()));
                pstmt.setInt(++i, dto.getPrice());
                pstmt.setString(++i, dto.getOption_use());
                pstmt.setString(++i, dto.getImg());
                pstmt.setString(++i, dto.getContent());
                pstmt.setString(++i, dto.getCert_type());
                pstmt.setString(++i, dto.getCert());
                pstmt.setString(++i, dto.getCert_no());
                pstmt.setString(++i, dto.getGosi_code());
                pstmt.setString(++i, dto.getGosi_info());
                pstmt.setString(++i, dto.getUp_datetime());
                pstmt.setInt(++i, dto.getId());
                YDMAStringUtil.Print("[updateProductDomeInfo | \uc218\uc815 \ud31d\uc5c5 \uc5c5\ub370\uc774\ud2b8] " + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return result;
    }

    private static String replaceIcode(String input) {
        if (input.contains("OM")) {
            input = input.replace("OM", "");
        } else if (input.contains("CBW")) {
            input = input.replace("CBW", "");
        } else if (input.contains("RM")) {
            input = input.replace("RM", "");
        } else if (input.contains("DMT")) {
            input = input.replace("DMT", "");
        }
        return input;
    }

    public void insertProductToUser(ProductDomeAllItemDto dto) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("INSERT INTO SHOPPRODINFO_USER (").append("USERID, DOME_CODE, ICODE, INAME, ES_CODE, ").append("SHOP_CID_INFO, CATE_FULLNAME, DELIVERY_AMOUNT, PRICE, CONTENT, ").append("IMG, SELECT_OPTION, STATUS, REG_DATETIME, UP_DATETIME, ").append("GOSI_CODE, GOSI_INFO, DELIVERY_TYPE, LIMIT_PRICE, NOTICE, ").append("TEXT_OPTION, KEYWORD, CID) ").append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ").append("ON DUPLICATE KEY UPDATE ").append("INAME = VALUES(INAME), ").append("ES_CODE = VALUES(ES_CODE), ").append("SHOP_CID_INFO = VALUES(SHOP_CID_INFO), ").append("CATE_FULLNAME = VALUES(CATE_FULLNAME), ").append("DELIVERY_AMOUNT = VALUES(DELIVERY_AMOUNT), ").append("PRICE = VALUES(PRICE), ").append("CONTENT = VALUES(CONTENT), ").append("IMG = VALUES(IMG), ").append("SELECT_OPTION = VALUES(SELECT_OPTION), ").append("STATUS = VALUES(STATUS), ").append("REG_DATETIME = VALUES(REG_DATETIME), ").append("UP_DATETIME = VALUES(UP_DATETIME), ").append("GOSI_CODE = VALUES(GOSI_CODE), ").append("GOSI_INFO = VALUES(GOSI_INFO), ").append("DELIVERY_TYPE = VALUES(DELIVERY_TYPE), ").append("LIMIT_PRICE = VALUES(LIMIT_PRICE), ").append("NOTICE = VALUES(NOTICE), ").append("TEXT_OPTION = VALUES(TEXT_OPTION), ").append("KEYWORD = VALUES(KEYWORD), ").append("CID = VALUES(CID);");
                PreparedStatement pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                statementlist.add(pstmt);
                int idx = 0;
                pstmt.setString(++idx, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setString(++idx, dto.getDome_code());
                pstmt.setString(++idx, dto.getIcode());
                pstmt.setString(++idx, dto.getIname());
                pstmt.setString(++idx, dto.getEs_code());
                pstmt.setString(++idx, dto.getShop_cid_info());
                pstmt.setString(++idx, dto.getCate_fullname());
                pstmt.setInt(++idx, dto.getDelivery_amount());
                pstmt.setInt(++idx, dto.getPrice());
                pstmt.setString(++idx, dto.getContent());
                String img_url = dto.getImg();
                if (dto.getDome_code().equals("17")) {
                    img_url = "https:" + img_url;
                }
                pstmt.setString(++idx, img_url);
                pstmt.setString(++idx, this.setOptionName(dto.getSelect_option()));
                pstmt.setString(++idx, dto.getStatus());
                pstmt.setString(++idx, dto.getReg_datetime());
                pstmt.setString(++idx, dto.getUp_datetime());
                pstmt.setString(++idx, dto.getGosi_code());
                pstmt.setString(++idx, dto.getGosi_info());
                pstmt.setString(++idx, dto.getDelivery_type());
                pstmt.setInt(++idx, dto.getLimit_price());
                pstmt.setString(++idx, dto.getNotice());
                pstmt.setString(++idx, dto.getText_option());
                pstmt.setString(++idx, dto.getKeyword());
                pstmt.setString(++idx, dto.getUrl());
                pstmt.addBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[insertProductToUser] " + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            DBCPInit2.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public String setOptionName(String input) {
        String select_option = "";
        if (input.contains("[\ud488\uc808]") || input.contains(" [\ud488\uc808]")) {
            select_option = input.replaceAll("\\s*\\[\ud488\uc808\\]\\s*", "(\ud488\uc808)");
            return select_option;
        }
        return input;
    }

    public static String getInsertOrUpdateQueryMapper(List<String> lstInsert, List<String> lstUpdate, String tableName) {
        StringBuilder sb_result = new StringBuilder();
        sb_result.append(String.format("INSERT INTO %s ", tableName));
        String head = lstInsert.stream().collect(Collectors.joining(",", "(", ") "));
        String bottom = lstInsert.stream().map(p -> String.valueOf("?")).collect(Collectors.joining(",", " VALUES (", ") "));
        sb_result.append(head);
        sb_result.append(bottom);
        if (lstUpdate != null) {
            sb_result.append("\r\n ON DUPLICATE KEY  UPDATE \r\n");
            String str_update = lstUpdate.stream().map(p -> p.concat(" = ?")).collect(Collectors.joining(","));
            sb_result.append(str_update);
        }
        return sb_result.toString();
    }

    public static void delete_optProdInfo(int id) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopprodinfo_user_option where id = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, id);
                YDMAStringUtil.Print("[delete_optProdInfo | \ub3c4\ub9e4 \ud3ec\ud138 \uc635\uc158 \uc0ad\uc81c] " + sql);
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public static void delete_shopprodinfo_user(String userid, String icode, String dome_code) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopprodinfo_user where userid = ? and icode = ? and dome_code = ? ";
                YDMAStringUtil.Print("[delete_shopprodinfo_user | \ub3c4\ub9e4 \ud3ec\ud138 \uc0ac\uc6a9\uc790 \uc0c1\ud488 \uc0ad\uc81c] " + sql);
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, userid);
                pstmt.setString(2, icode);
                pstmt.setString(3, dome_code);
                pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public static DomesinOptionList getOptionList(String option2) {
        DomesinOptionList optionList = new DomesinOptionList();
        ArrayList<DomesinOption> ret_options = new ArrayList<DomesinOption>();
        List lines = Arrays.stream(option2.split("\\r|\\n")).collect(Collectors.toList());
        String title = ((String)lines.remove(0)).replace("[", "").replace("]", "");
        int dan = title.split("=").length;
        optionList.setDan(dan);
        ProductDomeAllItemDao.setOptionListNames(optionList, title, dan);
        String optionType = ProductDomeAllItemDao.getOptionType(optionList, dan);
        for (String line : lines) {
            List<String> lst_option = Arrays.asList(line.split("="));
            if (lst_option.size() < 7) continue;
            DomesinOption dto = new DomesinOption();
            dto.setOptionType(optionType);
            ProductDomeAllItemDao.setOptionNames(dto, lst_option, dan);
            dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
            dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
            dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(5)));
            dto.setSoldOut(YDMAStringUtil.convertToInt(lst_option.get(6)));
            ret_options.add(dto);
        }
        if (ret_options.size() > 0 && dan == 2) {
            String char_2_val = ret_options.stream().map(DomesinOption::getOptionName2).collect(Collectors.joining(","));
            optionList.setChar_2_val(char_2_val);
        }
        optionList.setOptions(ret_options);
        return optionList;
    }

    private static void setOptionListNames(DomesinOptionList optionList, String title, int dan) {
        String[] charNames = title.split("=");
        if (dan == 3) {
            optionList.setChar_1_nm(charNames[0]);
            optionList.setChar_2_nm(charNames[1]);
            optionList.setChar_3_nm(charNames[2]);
        } else if (dan == 2) {
            optionList.setChar_1_nm(charNames[0].contains("\uc0c9\uc0c1") ? "\uce7c\ub77c" : charNames[0]);
            optionList.setChar_2_nm(charNames.length > 1 ? charNames[1] : "");
        } else if (dan == 1) {
            optionList.setChar_1_nm(charNames[0].contains("\uc0c9\uc0c1") ? "\uce7c\ub77c" : charNames[0]);
        }
    }

    private static String getOptionType(DomesinOptionList optionList, int dan) {
        if (dan == 3) {
            return String.valueOf(optionList.getChar_1_nm()) + ":" + optionList.getChar_2_nm() + ":" + optionList.getChar_3_nm();
        }
        if (dan == 2) {
            return String.valueOf(optionList.getChar_1_nm()) + ":" + optionList.getChar_2_nm();
        }
        return optionList.getChar_1_nm();
    }

    private static void setOptionNames(DomesinOption dto, List<String> lst_option, int dan) {
        boolean isSoldOut = lst_option.get(6).equals("1");
        if (dan == 3) {
            dto.setOptionName1(ProductDomeAllItemDao.formatOptionName(lst_option.get(0), isSoldOut));
            dto.setOptionName2(ProductDomeAllItemDao.formatOptionName(lst_option.get(1), isSoldOut));
            dto.setOptionName3(ProductDomeAllItemDao.formatOptionName(lst_option.get(2), isSoldOut));
        } else if (dan == 2) {
            dto.setOptionName1(ProductDomeAllItemDao.formatOptionName(lst_option.get(0), isSoldOut));
            dto.setOptionName2(ProductDomeAllItemDao.formatOptionName(lst_option.get(1), isSoldOut));
        } else if (dan == 1) {
            dto.setOptionName1(lst_option.get(0).equals("\uc0c1\ud488\uc120\ud0dd") ? ProductDomeAllItemDao.formatOptionName(lst_option.get(1), isSoldOut) : ProductDomeAllItemDao.formatOptionName(lst_option.get(0), isSoldOut));
        }
    }

    private static String formatOptionName(String name, boolean isSoldOut) {
        if (!isSoldOut) {
            return name;
        }
        if (name.contains("[\ud488\uc808]")) {
            return name.replace("[", "(").replace("]", ")").replaceAll("\\s+\\(", "(").replaceAll("\\)\\s+", ")");
        }
        return name.contains("(\ud488\uc808)") ? name : String.valueOf(name) + "(\ud488\uc808)";
    }

    public static void saveShopOptProdInfo(ProductDomeAllItemDto list) throws Exception {
        block9: {
            int result = 0;
            Connection connection = DBCPInit.getInstance().getConnection();
            connection.setAutoCommit(false);
            PreparedStatement pstmt = null;
            try {
                try {
                    List<DomesinOption> options;
                    ArrayList<String> lstInsert = new ArrayList<String>();
                    lstInsert.add("ID");
                    lstInsert.add("SKUSEQ");
                    lstInsert.add("PRODCD");
                    lstInsert.add("OPTPRODCD");
                    lstInsert.add("OPTPRODNM");
                    lstInsert.add("OPTSPECDES");
                    lstInsert.add("OPTSAFESTOCK");
                    lstInsert.add("OPTVERTSTOCK");
                    lstInsert.add("OPTADDAMT");
                    lstInsert.add("LIMIT_PRICE");
                    lstInsert.add("INSERTDT");
                    lstInsert.add("INSERTID");
                    pstmt = connection.prepareStatement(QueryStringUtils.queryStringInsert(lstInsert, "shopprodinfo_user_option"));
                    String optionString = list.getSelect_option();
                    if (optionString.isEmpty()) {
                        ProductDomeAllItemDao.delete_optProdInfo(list.getId());
                    }
                    if ((options = ProductDomeAllItemDao.getOptionList((String)optionString).options) == null || options.size() == 0) break block9;
                    ProductDomeAllItemDao.delete_optProdInfo(list.getId());
                    int i = 1;
                    for (DomesinOption option2 : options) {
                        int rowIdx2 = 0;
                        pstmt.setInt(++rowIdx2, list.getId());
                        pstmt.setInt(++rowIdx2, i);
                        pstmt.setString(++rowIdx2, list.getIcode());
                        String optrprodcd = list.getIcode().concat("-").concat(YDMAStringUtil.leftPad(String.valueOf(i), 2, "0"));
                        pstmt.setString(++rowIdx2, optrprodcd);
                        pstmt.setString(++rowIdx2, option2.getOptionType());
                        String optionVal = "";
                        String optionName1 = option2.getOptionName1() == null ? "" : option2.getOptionName1();
                        String optionName2 = option2.getOptionName2() == null ? "" : option2.getOptionName2();
                        String optionName3 = option2.getOptionName3() == null ? "" : option2.getOptionName3();
                        optionVal = Arrays.asList(optionName1, optionName2, optionName3).stream().filter(p -> p != "").collect(Collectors.joining(":"));
                        pstmt.setString(++rowIdx2, optionVal);
                        int cnt = option2.getSoldOut() == 0 ? 999 : 0;
                        pstmt.setInt(++rowIdx2, cnt);
                        pstmt.setInt(++rowIdx2, cnt);
                        int price2 = 0;
                        if (option2.getOptionPrice() != 0) {
                            price2 = option2.getOptionPrice() - list.getPrice();
                        }
                        pstmt.setInt(++rowIdx2, price2);
                        pstmt.setInt(++rowIdx2, option2.getCompliancePrice());
                        pstmt.setString(++rowIdx2, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++rowIdx2, YDMASessonUtil.getUserInfo().getUserId());
                        ++i;
                        result += pstmt.executeUpdate();
                        YDMAStringUtil.Print("[saveShopOptProdInfo | \ub3c4\ub9e4 \ud3ec\ud138 \uc0c1\ud488 \ub2e4\uc6b4\ub85c\ub4dc \uc635\uc158 \uc815\ubcf4 \uc800\uc7a5] " + pstmt.toString());
                    }
                    if (result == options.size()) {
                        connection.commit();
                        break block9;
                    }
                    throw new Exception();
                }
                catch (Exception ex) {
                    connection.rollback();
                    ex.printStackTrace();
                    throw ex;
                }
            }
            finally {
                connection.close();
            }
        }
    }

    public List<ShopProductOptionDto> getShopOptProdInfoListByProdseq(int id) throws Exception {
        ArrayList<ShopProductOptionDto> list = new ArrayList<ShopProductOptionDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT IFNULL(ID, 0) as ID, ");
                sb.append("IFNULL(SKUSEQ, 0) as SKUSEQ, ");
                sb.append("IFNULL(PRODCD, '') as PRODCD, ");
                sb.append("IFNULL(OPTPRODCD, '') as OPTPRODCD, ");
                sb.append("IFNULL(OPTPRODNM, '') as OPTPRODNM, ");
                sb.append("IFNULL(OPTSPECDES, '') as OPTSPECDES, ");
                sb.append("IFNULL(OPTEA, 0) as OPTEA, ");
                sb.append("IFNULL(OPTSALE, '') as OPTSALE, ");
                sb.append("IFNULL(OPTSALEOUT, '') as OPTSALEOUT, ");
                sb.append("IFNULL(OPTNOTUSE, '') as OPTNOTUSE, ");
                sb.append("IFNULL(OPTSAFESTOCK, 0) as OPTSAFESTOCK, ");
                sb.append("IFNULL(OPTVERTSTOCK, 0) as OPTVERTSTOCK, ");
                sb.append("IFNULL(OPTADDAMT, 0) as OPTADDAMT, ");
                sb.append("IFNULL(OPTDELYN, '') as OPTDELYN, ");
                sb.append("IFNULL(BARCODE, '') as BARCODE, ");
                sb.append("IFNULL(LIMIT_PRICE, 0) as LIMIT_PRICE ");
                sb.append("FROM shopprodinfo_user_option ");
                sb.append("WHERE ID = ?");
                String sql = sb.toString().toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, id);
                YDMAStringUtil.Print("[getShopOptProdInfoListByProdseq | \uc218\uc815 \ud31d\uc5c5 \uc635\uc158 \ud14c\uc774\ube14 \uc870\ud68c] " + pstmt.toString());
                rs = pstmt.executeQuery();
                int idx = 0;
                while (rs.next()) {
                    int rowIdx = 0;
                    ShopProductOptionDto dto = new ShopProductOptionDto();
                    dto.setRow(String.valueOf(++idx));
                    dto.setProdseq(rs.getInt(++rowIdx));
                    dto.setSkuseq(rs.getInt(++rowIdx));
                    dto.setProdcd(rs.getString(++rowIdx));
                    dto.setOptprodcd(rs.getString(++rowIdx));
                    dto.setOptprodnm(rs.getString(++rowIdx));
                    dto.setOptspecdes(rs.getString(++rowIdx));
                    dto.setOptea(rs.getInt(++rowIdx));
                    dto.setOptsale(rs.getString(++rowIdx));
                    dto.setOptsaleout(rs.getString(++rowIdx));
                    dto.setOptnotuse(rs.getString(++rowIdx));
                    dto.setOptsafestock(rs.getString(++rowIdx));
                    dto.setOptvertstock(rs.getString(++rowIdx));
                    dto.setOptaddamt(rs.getInt(++rowIdx));
                    dto.setOptdelyn(rs.getString(++rowIdx));
                    dto.setBarcode(rs.getString(++rowIdx));
                    dto.setLimit_price(rs.getString(++rowIdx));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopProductOptionDto> getShopOptProdInfoListByProdseq_view(int id) throws Exception {
        ArrayList<ShopProductOptionDto> list = new ArrayList<ShopProductOptionDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT IFNULL(ID, 0) as ID, ");
                sb.append("IFNULL(SKUSEQ, 0) as SKUSEQ, ");
                sb.append("IFNULL(PRODCD, '') as PRODCD, ");
                sb.append("IFNULL(OPTPRODCD, '') as OPTPRODCD, ");
                sb.append("IFNULL(OPTPRODNM, '') as OPTPRODNM, ");
                sb.append("IFNULL(OPTSPECDES, '') as OPTSPECDES, ");
                sb.append("IFNULL(OPTEA, 0) as OPTEA, ");
                sb.append("IFNULL(OPTSALE, '') as OPTSALE, ");
                sb.append("IFNULL(OPTSALEOUT, '') as OPTSALEOUT, ");
                sb.append("IFNULL(OPTNOTUSE, '') as OPTNOTUSE, ");
                sb.append("IFNULL(OPTSAFESTOCK, 0) as OPTSAFESTOCK, ");
                sb.append("IFNULL(OPTVERTSTOCK, 0) as OPTVERTSTOCK, ");
                sb.append("IFNULL(OPTADDAMT, 0) as OPTADDAMT, ");
                sb.append("IFNULL(OPTDELYN, '') as OPTDELYN, ");
                sb.append("IFNULL(BARCODE, '') as BARCODE, ");
                sb.append("IFNULL(LIMIT_PRICE, 0) as LIMIT_PRICE ");
                sb.append("FROM shopprodinfo_user_option ");
                sb.append("WHERE ID = ?");
                String sql = sb.toString().toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setInt(1, id);
                YDMAStringUtil.Print("[getShopOptProdInfoListByProdseq | \uc218\uc815 \ud31d\uc5c5 \uc635\uc158 \ud14c\uc774\ube14 \uc870\ud68c] " + pstmt.toString());
                rs = pstmt.executeQuery();
                int idx = 0;
                while (rs.next()) {
                    int rowIdx = 0;
                    ShopProductOptionDto dto = new ShopProductOptionDto();
                    dto.setRow(String.valueOf(++idx));
                    dto.setProdseq(rs.getInt(++rowIdx));
                    dto.setSkuseq(rs.getInt(++rowIdx));
                    dto.setProdcd(rs.getString(++rowIdx));
                    dto.setOptprodcd(rs.getString(++rowIdx));
                    dto.setOptprodnm(rs.getString(++rowIdx));
                    dto.setOptspecdes(rs.getString(++rowIdx));
                    dto.setOptea(rs.getInt(++rowIdx));
                    dto.setOptsale(rs.getString(++rowIdx));
                    dto.setOptsaleout(rs.getString(++rowIdx));
                    dto.setOptnotuse(rs.getString(++rowIdx));
                    dto.setOptsafestock(rs.getString(++rowIdx));
                    dto.setOptvertstock(rs.getString(++rowIdx));
                    dto.setOptaddamt(rs.getInt(++rowIdx));
                    dto.setOptdelyn(rs.getString(++rowIdx));
                    dto.setBarcode(rs.getString(++rowIdx));
                    dto.setLimit_price(rs.getString(++rowIdx));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int deleteOptionInfo(String prodcd, int id) throws Exception {
        int cnt = 0;
        QueryRunner run = new QueryRunner();
        try (Connection connection = DBCPInit.getInstance().getConnection();){
            try {
                String query = "DELETE FROM shopprodinfo_user_option WHERE ID = " + id + " PRODCD = '" + prodcd + "'";
                YDMAStringUtil.Print("[deleteOptionInfo | \uc635\uc158 \ub370\uc774\ud130 \uc0ad\uc81c] " + query);
                cnt = run.update(connection, query);
            }
            catch (SQLException e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return cnt;
    }

    public int insertOptProdInfo(List<ShopOptProdInfoDto> dtoList, String code, String prodcd, int id) throws Exception {
        int result;
        block7: {
            result = 0;
            Connection connection = DBCPInit.getInstance().getConnection();
            connection.setAutoCommit(false);
            PreparedStatement pstmt = null;
            try {
                try {
                    ArrayList<String> fileds = new ArrayList<String>();
                    fileds.add("ID");
                    fileds.add("SKUSEQ");
                    fileds.add("PRODCD");
                    fileds.add("OPTPRODCD");
                    fileds.add("OPTPRODNM");
                    fileds.add("OPTSPECDES");
                    fileds.add("OPTEA");
                    fileds.add("OPTSALE");
                    fileds.add("OPTSALEOUT");
                    fileds.add("OPTNOTUSE");
                    fileds.add("OPTSAFESTOCK");
                    fileds.add("OPTVERTSTOCK");
                    fileds.add("OPTADDAMT");
                    fileds.add("LIMIT_PRICE");
                    fileds.add("OPTDELYN");
                    fileds.add("BARCODE");
                    fileds.add("INSERTDT");
                    fileds.add("INSERTID");
                    fileds.add("MODIFYDT");
                    fileds.add("MODIFYID");
                    for (ShopOptProdInfoDto dto : dtoList) {
                        pstmt = connection.prepareStatement(QueryStringUtils.queryStringInsert(fileds, "shopprodinfo_user_option"));
                        int i = 0;
                        pstmt.setInt(++i, id);
                        pstmt.setInt(++i, dto.getSkuseq());
                        pstmt.setString(++i, code.equals("") ? dto.getProdcd() : code);
                        pstmt.setString(++i, dto.getOptprodcd());
                        pstmt.setString(++i, dto.getOptprodnm());
                        pstmt.setString(++i, dto.getOptspecdes());
                        pstmt.setInt(++i, dto.getOptea());
                        pstmt.setString(++i, dto.getOptsale());
                        pstmt.setString(++i, dto.getOptsaleout());
                        pstmt.setString(++i, dto.getOptnotuse());
                        pstmt.setInt(++i, dto.getOptsafestock());
                        pstmt.setInt(++i, dto.getOptvertstock());
                        pstmt.setInt(++i, dto.getOptaddamt());
                        pstmt.setInt(++i, dto.getLimit_price());
                        pstmt.setString(++i, dto.getOptdelyn());
                        pstmt.setString(++i, dto.getBarcode());
                        pstmt.setString(++i, TimeUtils.getCurrentTimeFormat());
                        pstmt.setString(++i, dto.getInsertid());
                        pstmt.setString(++i, dto.getModifydt());
                        pstmt.setString(++i, dto.getModifyid());
                        YDMAStringUtil.Print("[insertOptProdInfo | \uc218\uc815 \ud31d\uc5c5 \ud544\uc218 \uc635\uc158 \uc800\uc7a5] " + pstmt.toString());
                        result += pstmt.executeUpdate();
                    }
                    if (result == dtoList.size()) {
                        connection.commit();
                        break block7;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    connection.rollback();
                    e.printStackTrace();
                    connection.close();
                }
            }
            finally {
                connection.close();
            }
        }
        return result;
    }

    public List<NoticeInfoDto> getDomeNoticeInfo(String code, String domeSeq) throws SQLException {
        List<NoticeInfoDto> result = new ArrayList<NoticeInfoDto>();
        BeanListHandler handler = new BeanListHandler(NoticeInfoDto.class);
        QueryRunner run = new QueryRunner();
        try (Connection connection = null;){
            try {
                connection = DBCPInit2.getInstance().getConnection();
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("SELECT ATTRCD, ATTRNM, ").append(domeSeq).append(" FROM prodattrnm WHERE ATTRCD = '").append(code).append("' AND ").append(domeSeq).append(" IS NOT NULL ").append("ORDER BY ").append(domeSeq);
                String sql = sqlBuilder.toString();
                YDMAStringUtil.Print("[getDomeNoticeInfo | \uc218\uc815 \ud31d\uc5c5 \ud488\ubaa9\uc815\ubcf4 \uc870\ud68c] " + sql);
                result = (List)run.query(connection, sql, (ResultSetHandler)handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return result;
    }

    public int deleteShopaddprodinfo(int id) throws Exception {
        int result = 0;
        QueryRunner run = new QueryRunner();
        try (Connection connection = DBCPInit.getInstance().getConnection();){
            try {
                String query = "DELETE FROM shopaddprodinfo_user WHERE PRODSEQ = " + id;
                YDMAStringUtil.Print("[deleteShopaddprodinfo | \uae30\uc874 \ucd94\uac00 \uc635\uc158 \uc0ad\uc81c] " + query);
                result = run.update(connection, query);
            }
            catch (SQLException e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return result;
    }

    public int insertAddProdInfo(ProductDomeAllItemDto dto) throws Exception {
        int result;
        block7: {
            result = 0;
            Connection connection = DBCPInit.getInstance().getConnection();
            connection.setAutoCommit(false);
            PreparedStatement pstmt = null;
            try {
                try {
                    ArrayList<String> fileds = new ArrayList<String>();
                    List<ShopAddProdInfoDto> addOptList = new ArrayList<ShopAddProdInfoDto>();
                    fileds.add("PRODSEQ");
                    fileds.add("SKUSEQ");
                    fileds.add("USER_CODE");
                    fileds.add("PROD_TYPE1");
                    fileds.add("PROD_VAL1");
                    fileds.add("PROD_TYPE2");
                    fileds.add("PROD_VAL2");
                    fileds.add("PROD_AMT");
                    fileds.add("PROD_CNT");
                    fileds.add("INSERTDT");
                    fileds.add("INSERTID");
                    this.deleteShopaddprodinfo(dto.getId());
                    pstmt = connection.prepareStatement(QueryStringUtils.queryStringInsert(fileds, "shopaddprodinfo_user"));
                    addOptList = this.getAddOptList(dto, addOptList);
                    int i = 0;
                    for (ShopAddProdInfoDto optDto : addOptList) {
                        pstmt.setInt(++i, dto.getId());
                        pstmt.setInt(++i, optDto.getSkuseq());
                        pstmt.setString(++i, optDto.getUser_code());
                        pstmt.setString(++i, optDto.getProd_type1());
                        pstmt.setString(++i, optDto.getProd_val1());
                        pstmt.setString(++i, optDto.getProd_type2());
                        pstmt.setString(++i, optDto.getProd_val2());
                        pstmt.setInt(++i, optDto.getProd_amt());
                        pstmt.setInt(++i, optDto.getProd_cnt());
                        pstmt.setString(++i, optDto.getInsertdt());
                        pstmt.setString(++i, optDto.getInsertid());
                        i = 0;
                        result += pstmt.executeUpdate();
                    }
                    if (result == addOptList.size()) {
                        connection.commit();
                        break block7;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    connection.rollback();
                    e.printStackTrace();
                    connection.close();
                }
            }
            finally {
                connection.close();
            }
        }
        return result;
    }

    private List<ShopAddProdInfoDto> getAddOptList(ProductDomeAllItemDto dto, List<ShopAddProdInfoDto> addOptList) {
        String[] text_option = dto.getText_option().split("\n");
        int k = 0;
        while (k < text_option.length - 2) {
            int cnt;
            ShopAddProdInfoDto addOptDto = new ShopAddProdInfoDto();
            addOptDto.setSkuseq(k + 1);
            addOptDto.setCompno(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
            addOptDto.setCompayny_goods_cd(dto.getIcode());
            addOptDto.setUser_code(text_option[0]);
            String prod_type2 = "";
            String prod_val2 = "";
            String[] prod_type = text_option[1].split("=");
            String[] detail = text_option[2 + k].split("=");
            int amount = Integer.parseInt(detail[3]);
            int n = cnt = Integer.parseInt(detail[4]) == 0 ? 999 : Integer.parseInt(detail[4]);
            if (text_option[1].contains("=")) {
                prod_type2 = String.valueOf(prod_type[0].substring(prod_type[0].indexOf(91) + 1)) + "_" + prod_type[1].substring(0, prod_type[1].indexOf(93));
                prod_val2 = String.valueOf(detail[0]) + "_" + detail[1];
            } else {
                prod_type2 = prod_type[0].substring(prod_type[0].indexOf(91) + 1, prod_type[0].indexOf(93));
                prod_val2 = detail[0];
            }
            addOptDto.setProd_type1("\ucd94\uac00\uc0c1\ud488\uba85");
            addOptDto.setProd_val1(text_option[0]);
            addOptDto.setProd_type2(prod_type2);
            addOptDto.setProd_val2(prod_val2);
            addOptDto.setProd_amt(amount);
            addOptDto.setProd_cnt(cnt);
            addOptDto.setInsertdt(TimeUtils.getCurrentTimeFormat());
            addOptDto.setInsertid(YDMASessonUtil.getUserInfo().getUserId());
            addOptList.add(addOptDto);
            ++k;
        }
        return addOptList;
    }

    public ProductDomeAllItemDto getUpdateLogView(String domeCode, String iCode) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            connection = DBCPInit2.getInstance().getConnection();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT COALESCE(iname,'') as iname, \r\n");
            sql.append("\t   COALESCE(delivery_amount,0) as delivery_amount, \r\n");
            sql.append("\t   COALESCE(delivery_qty,'') as delivery_qty, \r\n");
            sql.append("\t   COALESCE(price,0) as price, \r\n");
            sql.append("\t   COALESCE(img,'') as img, \r\n");
            sql.append("\t   COALESCE(content,'') as content, \r\n");
            sql.append("\t   COALESCE(select_option,'') as select_option, \r\n");
            sql.append("\t   COALESCE(status,'') as status, \r\n");
            sql.append("\t   COALESCE(text_option,'') as text_option \r\n");
            sql.append("  FROM shopprodinfo_all \r\n");
            sql.append(" WHERE dome_code = ? \r\n");
            sql.append("   AND icode = ?");
            pstmt = connection.prepareStatement(sql.toString().toUpperCase());
            pstmt.setString(1, domeCode);
            pstmt.setString(2, iCode);
            YDMAStringUtil.Print("[\ub3c4\ub9e4\ud3ec\ud0c8 \ubcc0\uacbd \ub0b4\uc5ed \uc870\ud68c] " + pstmt.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ProductDomeAllItemDto dto = new ProductDomeAllItemDto();
                dto.setIname(rs.getString("iname"));
                dto.setDelivery_amount(rs.getInt("delivery_amount"));
                dto.setDelivery_qty(rs.getString("delivery_qty"));
                dto.setPrice(rs.getInt("price"));
                dto.setContent(rs.getString("content"));
                dto.setImg(rs.getString("img"));
                dto.setSelect_option(rs.getString("select_option"));
                dto.setStatus(rs.getString("status"));
                dto.setText_option(rs.getString("text_option"));
                ProductDomeAllItemDto productDomeAllItemDto = dto;
                DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
                return productDomeAllItemDto;
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw ex;
            }
            catch (Throwable throwable) {
                DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
        }
        DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
        return null;
    }

    public List<ProductDomeAllItemDto> getDome_user_info() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ProductDomeAllItemDto> user_list = new ArrayList<ProductDomeAllItemDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(icode, '') as icode, \r\n");
                sql.append("\t   IFNULL(dome_code, '') as dome_code \r\n");
                sql.append("  FROM shopprodinfo_user \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                YDMAStringUtil.Print("[\ub3c4\ub9e4\ud3ec\ud138 \uc0ac\uc6a9\uc790 \uc0c1\ud488 \ucf54\ub4dc, \ub3c4\ub9e4\ucf54\ub4dc \uc804\uccb4 \uc870\ud68c] " + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDomeAllItemDto dto = new ProductDomeAllItemDto();
                    dto.setDome_code(rs.getString("dome_code"));
                    dto.setIcode(rs.getString("icode"));
                    user_list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
        return user_list;
    }

    public List<ProductDomeAllItemDto> getDome_all_vender_code(List<ProductDomeAllItemDto> user_list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ProductDomeAllItemDto> all_list = new ArrayList<ProductDomeAllItemDto>();
        try {
            try {
                connection = DBCPInit2.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT COALESCE(vender_code, '') as vender_code, \r\n");
                sql.append("       COALESCE(status, '') as status \r\n");
                sql.append("  FROM shopprodinfo_all \r\n");
                sql.append(" WHERE dome_code = ? \r\n");
                sql.append("   AND icode = ?");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                for (ProductDomeAllItemDto dto : user_list) {
                    pstmt.setString(1, dto.getDome_code());
                    pstmt.setString(2, dto.getIcode());
                    YDMAStringUtil.Print("[\ub3c4\ub9e4\ud3ec\ud138 \uc804\uccb4 \ubcc0\uacbd\ub0b4\uc5ed \uc870\ud68c] " + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        dto.setIcode(dto.getIcode());
                        dto.setVender_code(rs.getString("vender_code") == null || rs.getString("vender_code").equals("") ? "" : rs.getString("vender_code"));
                        dto.setStatus(rs.getString("status"));
                        dto.setDome_code(dto.getDome_code());
                        all_list.add(dto);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit2.getInstance().freeConnection(connection, pstmt, rs);
        return all_list;
    }

    public void updateDome_user_vender_code(String vender_code, String dome_code, String icode, String status2) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodinfo_user    set a_vender_code = ?,       a_status = ? where dome_code = ?    and icode = ?    and userid = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, vender_code);
                pstmt.setString(2, status2);
                pstmt.setString(3, dome_code);
                pstmt.setString(4, icode);
                pstmt.setString(5, YDMASessonUtil.getUserInfo().getUserId());
                YDMAStringUtil.Print("[updateDome_user_vender_code] " + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public int updateUserTextOpiton(String textOption, String domeCode, String icode) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement("update shopprodinfo_user set text_option = ? where dome_code = ? and icode = ?");
                pstmt.setString(1, textOption);
                pstmt.setString(2, domeCode);
                pstmt.setString(3, icode);
                YDMAStringUtil.Print("[updateDome_user_text_option] " + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public void findId(ProductDomeAllItemDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement("select id from shopprodinfo_user where userid = ? and dome_code = ? and icode = ?");
                pstmt.setString(1, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setString(2, dto.getDome_code());
                pstmt.setString(3, dto.getIcode());
                YDMAStringUtil.Print("[DomeUser_findId] " + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setId(rs.getInt("id"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public List<ShopAddProdInfoDto> getAddProdInfo(int prodseq) throws Exception {
        List<ShopAddProdInfoDto> result = new ArrayList<ShopAddProdInfoDto>();
        BeanListHandler handler = new BeanListHandler(ShopAddProdInfoDto.class);
        QueryRunner run = new QueryRunner();
        try (Connection connection = DBCPInit.getInstance().getConnection();){
            try {
                String sql = "SELECT * FROM shopaddprodinfo_user WHERE PRODSEQ=" + prodseq;
                result = (List)run.query(connection, sql, (ResultSetHandler)handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return result;
    }

    public List<String> getLoginIdPW(String shopCd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement("select shoppingid, password from shopdtldome where compno = ? and shopcd = ? and shopseq = 1");
                pstmt.setString(1, YDMASessonUtil.getUserInfo().getCompno());
                pstmt.setString(2, shopCd);
                YDMAStringUtil.Print("[getLoginIdPW] " + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString("shoppingid"));
                    list.add(rs.getString("password"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ProductDomeAllItemDto> getRMIcodeAndIname(List<ProductDomeAllItemDto> items) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ProductDomeAllItemDto> user_list = new ArrayList<ProductDomeAllItemDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement("select icode, iname, dome_code from shopprodinfo_user where compno = ? and dome_code = ? and status = '0'");
                YDMAStringUtil.Print("[getRMIcodeAndIname] " + pstmt.toString());
                pstmt.setString(1, YDMASessonUtil.getUserInfo().getCompno());
                pstmt.setString(1, YDMASessonUtil.getUserInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductDomeAllItemDto dto = new ProductDomeAllItemDto();
                    dto.setIcode(rs.getString("icode"));
                    dto.setIname(rs.getString("iname"));
                    dto.setDome_code(rs.getString("dome_code"));
                    user_list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return user_list;
    }

    public void updateUserKeyword(ProductDomeAllItemDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodinfo_user    set keyword = ?  where dome_code = ?    and icode = ?    and userid = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, dto.getKeyword());
                pstmt.setString(2, dto.getDome_code());
                pstmt.setString(3, dto.getIcode());
                pstmt.setString(4, YDMASessonUtil.getUserInfo().getUserId());
                YDMAStringUtil.Print("[updateUserKeyword] " + pstmt.toString());
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void updateImage(ProductDomeAllItemDto dto) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE SHOPPRODINFO_USER SET IMG = ?, IMG_TEXT_DETECTED = ?  ").append("WHERE ICODE = ? AND INAME = ? AND DOME_CODE = ?");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int idx = 0;
                pstmt.setString(++idx, dto.getImg());
                pstmt.setString(++idx, "0");
                pstmt.setString(++idx, dto.getIcode());
                pstmt.setString(++idx, dto.getIname());
                pstmt.setString(++idx, dto.getDome_code());
                int result = pstmt.executeUpdate();
                if (result > 0) {
                    YDMAStringUtil.Print("[updateImage]\uc774\ubbf8\uc9c0 \uc5c5\ub370\uc774\ud2b8 \uc131\uacf5: " + dto.getIcode());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void updateTextDetectedFlag(String imagePath, int flag) throws Exception {
        block7: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "UPDATE SHOPPRODINFO_USER SET IMG_TEXT_DETECTED = ? WHERE IMG = ?";
                    pstmt = connection.prepareStatement(sql.toUpperCase());
                    pstmt.setInt(1, flag);
                    pstmt.setString(2, imagePath);
                    int result = pstmt.executeUpdate();
                    if (result > 0) {
                        YDMAStringUtil.Print("[updateTextDetectedFlag] \ud14d\uc2a4\ud2b8 \uac10\uc9c0 \uc0c1\ud0dc \uc5c5\ub370\uc774\ud2b8 \uc131\uacf5: " + imagePath);
                    } else {
                        YDMAStringUtil.Print("[updateTextDetectedFlag] \ud14d\uc2a4\ud2b8 \uac10\uc9c0 \uc0c1\ud0dc \uc5c5\ub370\uc774\ud2b8 \uc2e4\ud328: " + imagePath);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
    }
}

