/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.data.ssgmarket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.data.dao.QuestListDto;
import com.kdjsystem.mlink.yellim.shop.data.ssgmarket.SSGProductQnaDto;
import com.kdjsystem.mlink.yellim.shop.data.ssgmarket.ShopSSGQuestionContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ShopSSGQuestionSearch
extends ShopSSGQuestionContext {
    private static final String Host = "https://eapi.ssgadm.com";
    private final OkHttpClient client = new OkHttpClient().newBuilder().build();
    Map<String, String> cookie;

    @Override
    public List<QuestListDto> excute(List<QuestListDto> prodList) throws Exception {
        ArrayList<QuestListDto> dtoArray = new ArrayList<QuestListDto>();
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        this.customorQnaList(prodList, dtoArray, mapper);
        return dtoArray;
    }

    private void customorQnaList(List<QuestListDto> prodList, List<QuestListDto> dtoArray, ObjectMapper mapper) {
        try {
            String startDate = prodList.get(0).getStartDt().substring(0, 8);
            startDate = String.valueOf(startDate.substring(0, 4)) + startDate.substring(4, 6) + startDate.substring(6, 8);
            String endDate = prodList.get(0).getEndDt().substring(0, 8);
            endDate = String.valueOf(endDate.substring(0, 4)) + endDate.substring(4, 6) + endDate.substring(6, 8);
            String json = "{\"postngReq\":{\"qnaStartDt\":\"" + startDate + "0000\",\"qnaEndDt\":\"" + endDate + "0000\"}}";
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/api/postng/qnaList.ssg")).method("POST", body).addHeader("Authorization", prodList.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
            try {
                Throwable throwable = null;
                Object var11_14 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    SSGProductQnaDto.QnaSearchList ResponseQnaList = (SSGProductQnaDto.QnaSearchList)mapper.readValue(response.body().string().toString(), SSGProductQnaDto.QnaSearchList.class);
                    if (ResponseQnaList.result.resultCode.equals("00") && ResponseQnaList.result.qnaList.get(0) != null) {
                        int i = 0;
                        while (i < ResponseQnaList.result.qnaList.size()) {
                            SSGProductQnaDto.QnaSearchList.Result.Qna qnaList = ResponseQnaList.result.qnaList.get((int)i).qna;
                            QuestListDto dto = new QuestListDto();
                            dto.setQnastat("");
                            dto.setQnaseq(qnaList.postngId);
                            dto.setInsdm(qnaList.regDts.substring(0, 8));
                            dto.setMprodid(qnaList.itemId);
                            dto.setInsnm(qnaList.regpeId);
                            dto.setSubject(qnaList.postngTitleNm);
                            dto.setSenddt("");
                            dto.setStat("\uace0\uac1d\ubb38\uc758");
                            dto.setRegdm(YDMATimeUtil.getCurrentTime());
                            dto.setProdnm(qnaList.itemNm);
                            dto.setQuests(qnaList.postngCntt);
                            dto.setQnastat("100");
                            dto.setShopid(prodList.get(0).getShopid());
                            dto.setOrdid(qnaList.ordNo == null ? "" : qnaList.ordNo);
                            dto.setShopnm("shop0411");
                            dtoArray.add(dto);
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String setRequestParam(List<QuestListDto> param) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            SSGProductQnaDto.RequestParameter requestParmeter = new SSGProductQnaDto.RequestParameter();
            String startDate = param.get(0).getStartDt().substring(0, 8);
            startDate = String.valueOf(startDate.substring(0, 4)) + startDate.substring(4, 6) + startDate.substring(6, 8) + "0000";
            String endDate = param.get(0).getEndDt().substring(0, 8);
            endDate = String.valueOf(endDate.substring(0, 4)) + endDate.substring(4, 6) + endDate.substring(6, 8) + "0000";
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            new SimpleDateFormat("yyyyMMdd").format(date_from);
            requestParmeter.postngReq = new SSGProductQnaDto.RequestParameter.PostngReq();
            requestParmeter.postngReq.qnaStartDt = startDate;
            requestParmeter.postngReq.qnaEndDt = endDate;
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)requestParmeter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }
}

