/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.ui;

import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.ui.MallWorkDataQueue;
import com.kdjsystem.mlink.yellim.ui.ShopMallStatusUpdate;
import java.nio.channels.CompletionHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MallWorkBackground
extends Thread {
    private static MallWorkBackground instance = new MallWorkBackground();
    private ExecutorService executorService;
    public CompletionHandler<Map<String, Map<Integer, List<ShoppingmallDTO>>>, Map<String, Map<Integer, List<ShoppingmallDTO>>>> callback = new CompletionHandler<Map<String, Map<Integer, List<ShoppingmallDTO>>>, Map<String, Map<Integer, List<ShoppingmallDTO>>>>(){

        @Override
        public void completed(Map<String, Map<Integer, List<ShoppingmallDTO>>> result, Map<String, Map<Integer, List<ShoppingmallDTO>>> attachment) {
            try {
                MallWorkDataQueue.get().notifyObservers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void failed(Throwable exc, Map<String, Map<Integer, List<ShoppingmallDTO>>> attachment) {
        }
    };

    private MallWorkBackground() {
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public static MallWorkBackground get() {
        return instance;
    }

    public void startBackground() {
        Thread.State state = this.getState();
        if (state == Thread.State.NEW) {
            this.setDaemon(true);
            this.start();
            YDMAStringUtil.Print("\uc2a4\ub808\ub4dc \uc2dc\uc791");
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private Runnable getRunnableRegister(Map<String, Map<Integer, List<ShoppingmallDTO>>> mall) {
        Runnable run = () -> {
            try {
                ShopMallStatusUpdate.get().ShopMallProductInfoSend(mall);
                this.callback.completed(mall, mall);
            }
            catch (Exception exception) {}
        };
        return run;
    }

    @Override
    public void run() {
        while (true) {
            ExecutorService executorService = MallWorkDataQueue.get().getExecutorService();
            try {
                Thread.sleep(3000L);
                Map<String, Map<Integer, List<ShoppingmallDTO>>> mall = MallWorkDataQueue.get().getWaitData();
                if (mall == null) continue;
                executorService.submit(this.getRunnableRegister(mall));
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

