/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.ui;

import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.dto.ShoppingmallDTO;
import com.kdjsystem.mlink.yellim.ui.BackJobObserver;
import com.kdjsystem.mlink.yellim.ui.BackJobObserverable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MallWorkDataQueue
implements BackJobObserverable {
    private static MallWorkDataQueue instance = new MallWorkDataQueue();
    private ArrayList<BackJobObserver> observers;
    ExecutorService executorService;
    Map<String, Map<Integer, List<ShoppingmallDTO>>> queueShop = new LinkedHashMap<String, Map<Integer, List<ShoppingmallDTO>>>();

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void stopExecutorService() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    YDMAStringUtil.Print("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private MallWorkDataQueue() {
        int corePoolSize = 1;
        int maximumPoolSize = 1;
        long keepAliveTime = 3L;
        TimeUnit unit = TimeUnit.SECONDS;
        this.executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
        this.observers = new ArrayList();
    }

    public static MallWorkDataQueue get() {
        return instance;
    }

    public void add(Map<String, Map<Integer, List<ShoppingmallDTO>>> mall) {
        this.queueShop = mall;
        this.notifyObservers();
    }

    public synchronized Map<String, Map<Integer, List<ShoppingmallDTO>>> getAllData() {
        if (this.queueShop.size() == 0) {
            return (Map)((Object)new ArrayList());
        }
        return this.queueShop;
    }

    public synchronized Map<String, Map<Integer, List<ShoppingmallDTO>>> getWaitData() {
        if (this.queueShop.size() == 0) {
            return null;
        }
        Map<String, Map<Integer, List<ShoppingmallDTO>>> mall = this.queueShop;
        if (mall == null) {
            return null;
        }
        return mall;
    }

    @Override
    public void addObserver(BackJobObserver o) {
        this.observers.add(o);
    }

    @Override
    public void deleteObserver(BackJobObserver o) {
        int i = this.observers.indexOf(o);
        if (i >= 0) {
            this.observers.remove(i);
        }
    }

    @Override
    public void notifyObservers() {
        int i = 0;
        while (i < this.observers.size()) {
            BackJobObserver observer = this.observers.get(i);
            observer.update(this);
            ++i;
        }
    }

    private static class DataFlatMap {
        private String grp;

        public DataFlatMap(String grp) {
            this.grp = grp;
        }
    }
}

