/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.data.dao;

import com.kdjsystem.mlink.yellim.common.YDMASessonUtil;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.data.dao.DBCPInit;
import com.kdjsystem.mlink.yellim.data.dao.UserDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class UserDao {
    public boolean checkExistUser(String id) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select  userid from userinf where compno = ? and  userid = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, id);
                YDMAStringUtil.Print("[checkExistUser]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public UserDto getUserInfoLogin(String compno, String id, String pw) throws Exception {
        UserDto dto = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select compno, userid, usernam, userpwd, email, progcd, useyn, ltype, startuse, enduse  from userinf  where compno = ?     and userid = ?     and userpwd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, compno);
                pstmt.setString(2, id);
                pstmt.setString(3, pw);
                YDMAStringUtil.Print("[getUserInfoLogin]" + pstmt.toString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    int i = 0;
                    dto = new UserDto();
                    dto.setCompno(rs.getString(++i));
                    dto.setUserId(rs.getString(++i));
                    dto.setUsernam(rs.getString(++i));
                    dto.setUserpwd(rs.getString(++i));
                    dto.setEmail(rs.getString(++i));
                    dto.setProgcd(rs.getString(++i));
                    dto.setUseyn(rs.getString(++i));
                    dto.setLtype(rs.getString(++i));
                    dto.setStartuse(rs.getString(++i));
                    dto.setEnduse(rs.getString(++i));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<UserDto> getUserListByName(String username) throws Exception {
        ArrayList<UserDto> list = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT USERID, USERNAM, USERPWD, EMAIL, PROGCD, USEYN, COMPNO ,BRANDCD FROM USERINF where compno= ? ";
                if (username.length() != 0) {
                    sql = String.valueOf(sql) + " and USERNAM like ?";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (username.length() != 0) {
                    pstmt.setString(2, "%" + username + "%");
                }
                YDMAStringUtil.Print("[getUserListByName]" + pstmt.toString());
                rs = pstmt.executeQuery();
                rs.last();
                int rowcount = rs.getRow();
                if (rowcount > 0) {
                    rs.beforeFirst();
                    list = new ArrayList<UserDto>();
                    int rowno = 0;
                    while (rs.next()) {
                        int i = 0;
                        UserDto dto = new UserDto();
                        dto.setRowno(String.valueOf(++rowno));
                        dto.setUserId(rs.getString(++i));
                        dto.setUsernam(rs.getString(++i));
                        dto.setUserpwd(rs.getString(++i));
                        dto.setEmail(rs.getString(++i));
                        dto.setProgcd(rs.getString(++i));
                        dto.setUseyn(rs.getString(++i));
                        dto.setCompno(rs.getString(++i));
                        dto.setBrandcd(rs.getString(++i));
                        list.add(dto);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public UserDto getUserInfoById(String userId) throws Exception {
        UserDto dto = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select userid, usernam, userpwd,  email, PROGCD, useyn, compno , brandcd   from userinf  where compno = ?   and userid = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, userId);
                YDMAStringUtil.Print("[getUserInfoById]" + pstmt.toString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    int i = 0;
                    dto = new UserDto();
                    dto.setUserId(rs.getString(++i));
                    dto.setUsernam(rs.getString(++i));
                    dto.setUserpwd(rs.getString(++i));
                    dto.setEmail(rs.getString(++i));
                    dto.setProgcd(rs.getString(++i));
                    dto.setUseyn(rs.getString(++i));
                    dto.setCompno(rs.getString(++i));
                    dto.setBrandcd(rs.getString(++i));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public int insertUser(String username, String userId, String userPw, String email, String useyn, String compno, String ltype, int brandcd) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into userinf (compno, usernam, userid, userpwd, email, useyn, ltype,brandcd) \t\t\t   values (?, ?, ?, ?, ?, ?, ?,?)  ON DUPLICATE KEY UPDATE userpwd = ?,compno = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, compno);
                pstmt.setString(2, username);
                pstmt.setString(3, userId);
                pstmt.setString(4, userPw);
                pstmt.setString(5, email);
                pstmt.setString(6, useyn);
                pstmt.setString(7, ltype);
                pstmt.setInt(8, brandcd);
                pstmt.setString(9, userPw);
                pstmt.setString(10, compno);
                YDMAStringUtil.Print("[insertUser]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int updateUser(String username, String userId, String userPw, String email, String useyn, String compno, int brandcd) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update userinf set usernam=?, userpwd=?, email=?, useyn=?, compno=?, brandcd = ?  where compno=?    and userid=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, username);
                pstmt.setString(2, userPw);
                pstmt.setString(3, email);
                pstmt.setString(4, useyn);
                pstmt.setString(5, compno);
                pstmt.setInt(6, brandcd);
                pstmt.setString(7, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(8, userId);
                YDMAStringUtil.Print("[updateUser]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int deleteUser(String userId) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int updateUseyn(String compno, String userId, String userPw, String useyn) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update userinf set useyn=? where compno=?     and userid=?     and userpwd=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, useyn);
                pstmt.setString(2, compno);
                pstmt.setString(3, userId);
                pstmt.setString(4, userPw);
                YDMAStringUtil.Print("[updateUseyn]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }
}

