/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.common;

import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.dto.ProductDTO;
import com.kdjsystem.mlink.yellim.shop.common.Observer;
import com.kdjsystem.mlink.yellim.shop.common.Observerable;
import com.kdjsystem.mlink.yellim.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.yellim.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.yellim.shop.dao.WorkMngDto;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class ShopWorkDataQueue
implements Observerable {
    private List<DataFlatMap> dataFlatMaps = new ArrayList<DataFlatMap>();
    private static ShopWorkDataQueue instance = new ShopWorkDataQueue();
    private ArrayList<Observer> observers;
    ExecutorService executorService;
    Map<String, ShopProductSendDto> queue = new LinkedHashMap<String, ShopProductSendDto>();

    public List<DataFlatMap> getDataFlatMaps() {
        return this.dataFlatMaps;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void stopExecutorService() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    YDMAStringUtil.Print("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private ShopWorkDataQueue() {
        int cnt;
        try {
            cnt = ShopWorkDao.get().getMultiThreadCnt();
            int cores = Runtime.getRuntime().availableProcessors();
            if (cnt != 1 && cnt > cores / 2) {
                cnt = cores / 2;
            }
        }
        catch (Exception exception) {
            cnt = 1;
        }
        int corePoolSize = cnt;
        int maximumPoolSize = cnt;
        long keepAliveTime = 3L;
        TimeUnit unit = TimeUnit.SECONDS;
        this.executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
        this.observers = new ArrayList();
    }

    public static ShopWorkDataQueue get() {
        return instance;
    }

    public void add(ShopProductSendDto shopProductSendDto) {
        for (ProductDTO d : shopProductSendDto.getShopProductDto()) {
            this.dataFlatMaps.add(new DataFlatMap(d.getShopcd(), d.getShopseq(), d.getPRODSEQ(), shopProductSendDto.getWorkgrp()));
        }
        this.queue.put(shopProductSendDto.getWorkgrp(), shopProductSendDto);
        this.notifyObservers();
    }

    public boolean isExistGrp(String grp) {
        return this.queue.get(grp) != null;
    }

    public void delete(String grp) {
        this.queue.remove(grp);
        List result_dataFlatMaps = this.dataFlatMaps.stream().filter(p -> ((DataFlatMap)p).grp.equals(grp)).collect(Collectors.toList());
        if (result_dataFlatMaps != null && result_dataFlatMaps.size() > 0) {
            for (DataFlatMap dataFlatMap : result_dataFlatMaps) {
                this.dataFlatMaps.remove(dataFlatMap);
            }
        }
    }

    public boolean isExistsDataQueue() {
        return this.queue.size() > 0;
    }

    public boolean isExistsDataQueue(String shopcd, String shopseq, String prodseq) {
        DataFlatMap flatMap = this.dataFlatMaps.stream().filter(p -> ((DataFlatMap)p).shopcd.equals(shopcd) && ((DataFlatMap)p).shopseq.equals(shopseq) && ((DataFlatMap)p).prodseq.equals(prodseq)).findAny().orElse(null);
        return flatMap != null;
    }

    public synchronized List<WorkMngDto> getAllData() {
        if (this.queue.size() == 0) {
            return new ArrayList<WorkMngDto>();
        }
        return this.queue.entrySet().stream().map(p -> ((ShopProductSendDto)p.getValue()).getWorkMngDto()).collect(Collectors.toList());
    }

    public synchronized ShopProductSendDto getWaitData() {
        if (this.queue.size() == 0) {
            return null;
        }
        ShopProductSendDto retSendDto = this.queue.entrySet().stream().filter(p -> ((ShopProductSendDto)p.getValue()).getWorkMngDto().getWorkcd().equals("100")).filter(p -> ((ShopProductSendDto)p.getValue()).getWorkMngDto().getWork_status().equals("W01")).map(p -> (ShopProductSendDto)p.getValue()).findFirst().orElse(null);
        if (retSendDto == null) {
            return null;
        }
        retSendDto.getWorkMngDto().setWork_status("W03");
        retSendDto.getWorkMngDto().setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        this.notifyObservers();
        return retSendDto;
    }

    public synchronized ShopProductSendDto getModifyData() {
        if (this.queue.size() == 0) {
            return null;
        }
        ShopProductSendDto retSendDto = this.queue.entrySet().stream().filter(p -> ((ShopProductSendDto)p.getValue()).getWorkMngDto().getWorkcd().equals("200")).filter(p -> ((ShopProductSendDto)p.getValue()).getWorkMngDto().getWork_status().equals("W01")).map(p -> (ShopProductSendDto)p.getValue()).findFirst().orElse(null);
        if (retSendDto == null) {
            return null;
        }
        retSendDto.getWorkMngDto().setWork_status("W03");
        retSendDto.getWorkMngDto().setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        this.notifyObservers();
        return retSendDto;
    }

    public synchronized ShopProductSendDto getModifySoldOutData() {
        if (this.queue.size() == 0) {
            return null;
        }
        ShopProductSendDto retSendDto = this.queue.entrySet().stream().filter(p -> ((ShopProductSendDto)p.getValue()).getWorkMngDto().getWorkcd().equals("500")).filter(p -> ((ShopProductSendDto)p.getValue()).getWorkMngDto().getWork_status().equals("W01")).map(p -> (ShopProductSendDto)p.getValue()).findFirst().orElse(null);
        if (retSendDto == null) {
            return null;
        }
        retSendDto.getWorkMngDto().setWork_status("W03");
        retSendDto.getWorkMngDto().setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        this.notifyObservers();
        return retSendDto;
    }

    public synchronized ShopProductSendDto getModifyDeleteData() {
        if (this.queue.size() == 0) {
            return null;
        }
        ShopProductSendDto retSendDto = this.queue.entrySet().stream().filter(p -> ((ShopProductSendDto)p.getValue()).getWorkMngDto().getWorkcd().equals("600")).filter(p -> ((ShopProductSendDto)p.getValue()).getWorkMngDto().getWork_status().equals("W01")).map(p -> (ShopProductSendDto)p.getValue()).findFirst().orElse(null);
        if (retSendDto == null) {
            return null;
        }
        retSendDto.getWorkMngDto().setWork_status("W03");
        retSendDto.getWorkMngDto().setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        this.notifyObservers();
        return retSendDto;
    }

    @Override
    public void addObserver(Observer o) {
        this.observers.add(o);
    }

    @Override
    public void deleteObserver(Observer o) {
        int i = this.observers.indexOf(o);
        if (i >= 0) {
            this.observers.remove(i);
        }
    }

    public void notifyCompleteObservers() {
        int i = 0;
        while (i < this.observers.size()) {
            Observer observer = this.observers.get(i);
            observer.updateComplete(this);
            ++i;
        }
    }

    @Override
    public void notifyObservers() {
        int i = 0;
        while (i < this.observers.size()) {
            Observer observer = this.observers.get(i);
            observer.update(this);
            ++i;
        }
    }

    private static class DataFlatMap {
        private String grp;
        private String shopcd;
        private String shopseq;
        private String prodseq;

        public DataFlatMap(String shopcd, String shopseq, String prodseq, String grp) {
            this.shopcd = shopcd;
            this.shopseq = shopseq;
            this.prodseq = prodseq;
            this.grp = grp;
        }
    }
}

