/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.yellim.shop.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.yellim.common.YDMAStringUtil;
import com.kdjsystem.mlink.yellim.common.YDMATimeUtil;
import com.kdjsystem.mlink.yellim.shop.common.ChromePath;
import com.kdjsystem.mlink.yellim.shop.common.DriverPool;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;

public class ChromeExtention {
    private boolean isFileDown;
    private boolean isCheckDrive;
    private boolean headless_mode = false;
    private Path downloadPath;
    private ChromeDriverService driverService = null;
    private ChromeDriver driver;
    private String tempProfileDir;
    int checkVer = ChromePath.getChromePath();
    Map<Integer, DriverPool> driverPools = new HashMap<Integer, DriverPool>();
    public static ChromeExtention instance = new ChromeExtention();

    private ChromeExtention() {
    }

    public static ChromeExtention getInstace() {
        return instance;
    }

    public ChromeExtention setHeadlessMode(boolean headless_mode) {
        this.isCheckDrive = this.headless_mode == headless_mode;
        this.headless_mode = headless_mode;
        return this;
    }

    public ChromeExtention setFileDown(boolean isFileDown) {
        this.isCheckDrive = this.isFileDown == isFileDown;
        this.isFileDown = isFileDown;
        return this;
    }

    public ChromeDriver getDriver() {
        return this.getDriver(true);
    }

    public ChromeDriver getDriverForAuctionGmarket() {
        return this.getDriverForAuctionGmarket(true);
    }

    private static void deleteDirectoryRecursively(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            YDMAStringUtil.Print("\uc784\uc2dc chrome profile \ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c\ub428: " + path.toString());
        }
    }

    public ChromeDriver getDriver(boolean isHeadless) {
        if (this.checkVer > 114) {
            ChromePath.downloadDriver(this.checkVer);
        } else {
            this.downgradeCheck();
        }
        WebDriverManager.chromedriver().setup();
        this.tempProfileDir = String.valueOf(System.getProperty("java.io.tmpdir")) + "chrome-profile-" + UUID.randomUUID().toString();
        try {
            Files.createDirectories(Paths.get(this.tempProfileDir, new String[0]), new FileAttribute[0]);
            YDMAStringUtil.Print("\uc784\uc2dc chrome profile \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131\ub428: " + this.tempProfileDir);
        }
        catch (IOException e) {
            YDMAStringUtil.Print("\uc784\uc2dc \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 \uc2e4\ud328: " + e.getMessage());
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                YDMAStringUtil.Print("\uc560\ud50c\ub9ac\ucf00\uc774\uc158 \uc885\ub8cc, chrome profile \ub514\ub809\ud1a0\ub9ac \uc815\ub9ac \uc911: " + ChromeExtention.this.tempProfileDir);
                try {
                    ChromeExtention.deleteDirectoryRecursively(Paths.get(ChromeExtention.this.tempProfileDir, new String[0]));
                }
                catch (IOException e) {
                    YDMAStringUtil.Print("\ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }));
        if (isHeadless) {
            ChromeOptions options = new ChromeOptions();
            options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
            options.addArguments(new String[]{"--headless=new"});
            options.addArguments(new String[]{"User-Agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36"});
            options.addArguments(new String[]{"--window-position=-2400,-2400"});
            options.addArguments(new String[]{"--disable-gpu"});
            options.addArguments(new String[]{"--disable-infobars"});
            options.addArguments(new String[]{"--disable-extensions"});
            options.addArguments(new String[]{"--eyellim"});
            options.addArguments(new String[]{"--user-data-dir=" + this.tempProfileDir});
            this.driver = new ChromeDriver(options);
        } else {
            InetAddress local = null;
            try {
                local = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            local.getHostAddress();
            List<String> givenList = Arrays.asList("78.0.3904.70", "80.0.3987.163", "80.0.3987.149", "81.0.4044.138", "83.0.4103.116", "84.0.4147.135", "85.0.4183.102", "87.0.4280.141", "89.0.4389.128");
            Random rand = new Random();
            givenList.get(rand.nextInt(givenList.size()));
            ChromeOptions options = new ChromeOptions();
            options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
            options.addArguments(new String[]{"User-Agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36"});
            options.addArguments(new String[]{"--window-position=-2400,-2400"});
            options.addArguments(new String[]{"--lang=ko_KR"});
            options.addArguments(new String[]{"--disable-gpu"});
            options.addArguments(new String[]{"--disable-infobars"});
            options.addArguments(new String[]{"--disable-extensions"});
            options.addArguments(new String[]{"--eyellim"});
            options.addArguments(new String[]{"--user-data-dir=" + this.tempProfileDir});
            this.driver = new ChromeDriver(options);
            this.driver.manage().window().maximize();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            YDMAStringUtil.Print("\uc560\ud50c\ub9ac\ucf00\uc774\uc158 \uc885\ub8cc, chrome profile \ub514\ub809\ud1a0\ub9ac \uc815\ub9ac \uc911: " + this.tempProfileDir);
            try {
                if (this.driver != null) {
                    this.driver.quit();
                    YDMAStringUtil.Print("ChromeDriver \uc815\uc0c1 \uc885\ub8cc\ub428.");
                }
            }
            catch (Exception e) {
                YDMAStringUtil.Print("ChromeDriver \uc885\ub8cc \uc911 \uc624\ub958: " + e.getMessage());
            }
            try {
                ChromeExtention.deleteDirectoryRecursively(Paths.get(this.tempProfileDir, new String[0]));
            }
            catch (IOException e) {
                YDMAStringUtil.Print("\ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
            }
        }));
        return this.driver;
    }

    public ChromeDriver getDriverForAuctionGmarket(boolean isHeadless) {
        if (this.checkVer > 114) {
            ChromePath.downloadDriver(this.checkVer);
        } else {
            this.downgradeCheck();
        }
        WebDriverManager.chromedriver().setup();
        this.tempProfileDir = String.valueOf(System.getProperty("java.io.tmpdir")) + "chrome-profile-" + UUID.randomUUID().toString();
        try {
            Files.createDirectories(Paths.get(this.tempProfileDir, new String[0]), new FileAttribute[0]);
            YDMAStringUtil.Print("\uc784\uc2dc chrome profile \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131\ub428: " + this.tempProfileDir);
        }
        catch (IOException e) {
            YDMAStringUtil.Print("\uc784\uc2dc \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 \uc2e4\ud328: " + e.getMessage());
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                YDMAStringUtil.Print("\uc560\ud50c\ub9ac\ucf00\uc774\uc158 \uc885\ub8cc, chrome profile \ub514\ub809\ud1a0\ub9ac \uc815\ub9ac \uc911: " + ChromeExtention.this.tempProfileDir);
                try {
                    ChromeExtention.deleteDirectoryRecursively(Paths.get(ChromeExtention.this.tempProfileDir, new String[0]));
                }
                catch (IOException e) {
                    YDMAStringUtil.Print("\ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }));
        if (isHeadless) {
            ChromeOptions options = new ChromeOptions();
            options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
            options.addArguments(new String[]{"--headless=new"});
            options.addArguments(new String[]{"User-Agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36"});
            options.addArguments(new String[]{"--window-position=-2400,-2400"});
            options.addArguments(new String[]{"--disable-gpu"});
            options.addArguments(new String[]{"--disable-infobars"});
            options.addArguments(new String[]{"--disable-extensions"});
            options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
            options.addArguments(new String[]{"--eyellim"});
            options.addArguments(new String[]{"--user-data-dir=" + this.tempProfileDir});
            this.driver = new ChromeDriver(options);
        } else {
            InetAddress local = null;
            try {
                local = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            local.getHostAddress();
            List<String> givenList = Arrays.asList("78.0.3904.70", "80.0.3987.163", "80.0.3987.149", "81.0.4044.138", "83.0.4103.116", "84.0.4147.135", "85.0.4183.102", "87.0.4280.141", "89.0.4389.128");
            Random rand = new Random();
            givenList.get(rand.nextInt(givenList.size()));
            ChromeOptions options = new ChromeOptions();
            options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
            options.addArguments(new String[]{"User-Agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36"});
            options.addArguments(new String[]{"--window-position=-2400,-2400"});
            options.addArguments(new String[]{"--lang=ko_KR"});
            options.addArguments(new String[]{"--disable-gpu"});
            options.addArguments(new String[]{"--disable-infobars"});
            options.addArguments(new String[]{"--disable-extensions"});
            options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
            options.addArguments(new String[]{"--eyellim"});
            options.addArguments(new String[]{"--user-data-dir=" + this.tempProfileDir});
            this.driver = new ChromeDriver(options);
            this.driver.manage().window().maximize();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            YDMAStringUtil.Print("\uc560\ud50c\ub9ac\ucf00\uc774\uc158 \uc885\ub8cc, chrome profile \ub514\ub809\ud1a0\ub9ac \uc815\ub9ac \uc911: " + this.tempProfileDir);
            try {
                if (this.driver != null) {
                    this.driver.quit();
                    YDMAStringUtil.Print("ChromeDriver \uc815\uc0c1 \uc885\ub8cc\ub428.");
                }
            }
            catch (Exception e) {
                YDMAStringUtil.Print("ChromeDriver \uc885\ub8cc \uc911 \uc624\ub958: " + e.getMessage());
            }
            try {
                ChromeExtention.deleteDirectoryRecursively(Paths.get(this.tempProfileDir, new String[0]));
            }
            catch (IOException e) {
                YDMAStringUtil.Print("\ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
            }
        }));
        return this.driver;
    }

    public ChromeDriver getDriver(boolean isHeadless, boolean fileDown) {
        if (this.checkVer > 114) {
            ChromePath.downloadDriver(this.checkVer);
        } else {
            this.downgradeCheck();
        }
        WebDriverManager.chromedriver().setup();
        this.tempProfileDir = String.valueOf(System.getProperty("java.io.tmpdir")) + "chrome-profile-" + UUID.randomUUID().toString();
        try {
            Files.createDirectories(Paths.get(this.tempProfileDir, new String[0]), new FileAttribute[0]);
            YDMAStringUtil.Print("\uc784\uc2dc chrome profile \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131\ub428: " + this.tempProfileDir);
        }
        catch (IOException e) {
            YDMAStringUtil.Print("\uc784\uc2dc \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 \uc2e4\ud328: " + e.getMessage());
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                YDMAStringUtil.Print("\uc560\ud50c\ub9ac\ucf00\uc774\uc158 \uc885\ub8cc, chrome profile \ub514\ub809\ud1a0\ub9ac \uc815\ub9ac \uc911: " + ChromeExtention.this.tempProfileDir);
                try {
                    ChromeExtention.deleteDirectoryRecursively(Paths.get(ChromeExtention.this.tempProfileDir, new String[0]));
                }
                catch (IOException e) {
                    YDMAStringUtil.Print("\ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }));
        if (isHeadless) {
            ChromeOptions options = new ChromeOptions();
            options.addArguments(new String[]{"--headless=new"});
            options.addArguments(new String[]{"user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36"});
            options.addArguments(new String[]{"--window-position=-2400,-2400"});
            options.addArguments(new String[]{"disable-gpu"});
            options.addArguments(new String[]{"disable-infobars"});
            options.addArguments(new String[]{"--disable-extensions"});
            if (fileDown) {
                try {
                    this.downloadPath = this.createDirectory();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
            chromePrefs.put("download.default_directory", this.downloadPath);
            chromePrefs.put("download.directory_upgrade", true);
            chromePrefs.put("download.prompt_for_download", false);
            chromePrefs.put("browser.set_download_behavior", "{behavior:\"allow\"}");
            options.setExperimentalOption("prefs", chromePrefs);
            options.addArguments(new String[]{"--test-type"});
            options.addArguments(new String[]{"--disable-extension"});
            options.addArguments(new String[]{"--eyellim"});
            options.addArguments(new String[]{"--user-data-dir=" + this.tempProfileDir});
            this.driverService = ChromeDriverService.createDefaultService();
            this.driver = new ChromeDriver(this.driverService, options);
        } else {
            if (fileDown) {
                try {
                    this.downloadPath = this.createDirectory();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
            chromePrefs.put("download.default_directory", this.downloadPath);
            chromePrefs.put("download.directory_upgrade", true);
            chromePrefs.put("download.prompt_for_download", false);
            chromePrefs.put("browser.set_download_behavior", "{behavior:\"allow\"}");
            ChromeOptions options = new ChromeOptions();
            options.setExperimentalOption("prefs", chromePrefs);
            options.addArguments(new String[]{"--test-type"});
            options.addArguments(new String[]{"--disable-extension"});
            options.addArguments(new String[]{"--eyellim"});
            options.addArguments(new String[]{"--user-data-dir=" + this.tempProfileDir});
            this.driverService = ChromeDriverService.createDefaultService();
            this.driver = new ChromeDriver(this.driverService, options);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            YDMAStringUtil.Print("\uc560\ud50c\ub9ac\ucf00\uc774\uc158 \uc885\ub8cc, chrome profile \ub514\ub809\ud1a0\ub9ac \uc815\ub9ac \uc911: " + this.tempProfileDir);
            try {
                if (this.driver != null) {
                    this.driver.quit();
                    YDMAStringUtil.Print("ChromeDriver \uc815\uc0c1 \uc885\ub8cc\ub428.");
                }
            }
            catch (Exception e) {
                YDMAStringUtil.Print("ChromeDriver \uc885\ub8cc \uc911 \uc624\ub958: " + e.getMessage());
            }
            try {
                ChromeExtention.deleteDirectoryRecursively(Paths.get(this.tempProfileDir, new String[0]));
            }
            catch (IOException e) {
                YDMAStringUtil.Print("\ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
            }
        }));
        return this.driver;
    }

    public Path getDownloadPath() {
        return this.downloadPath;
    }

    public File getLastModifiedFile() {
        String strPath = this.getDownloadPath().toAbsolutePath().toString();
        File[] files = new File(strPath).listFiles();
        File lastFile = Arrays.stream(files).reduce((a, b) -> Long.valueOf(a.lastModified()).compareTo(b.lastModified()) > 0 ? a : b).get();
        return lastFile;
    }

    public String getLastFileAbsolutePath() {
        String strPath = this.downloadPath.toAbsolutePath().toString();
        return strPath.concat("\\").concat(this.getLastModifiedFile().getName());
    }

    public Path createDirectory() throws IOException {
        Path basePath = Paths.get("", new String[0]).toAbsolutePath();
        String currentDate = YDMATimeUtil.getCurrentTime().substring(0, 8);
        this.downloadPath = basePath.resolve("EXCEL_" + currentDate);
        if (!Files.exists(this.downloadPath, new LinkOption[0])) {
            this.downloadPath = Files.createDirectory(this.downloadPath, new FileAttribute[0]);
        }
        return this.downloadPath;
    }

    public void crome_headless_filedown(ChromeDriver driver) throws ClientProtocolException, IOException {
        this.downloadPath = this.createDirectory();
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("cmd", "Page.setDownloadBehavior");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("behavior", "allow");
        params.put("downloadPath", this.downloadPath.toAbsolutePath().toString());
        params.put("cmd", "Page.setDownloadBehavior");
        commandParams.put("params", params);
        ObjectMapper objectMapper = new ObjectMapper();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String command = objectMapper.writeValueAsString(commandParams);
        String u = String.valueOf(this.driverService.getUrl().toString()) + "/session/" + driver.getSessionId() + "/chromium/send_command";
        HttpPost request2 = new HttpPost(u);
        request2.addHeader("content-type", "application/json");
        request2.setEntity((HttpEntity)new StringEntity(command));
        httpClient.execute((HttpUriRequest)request2);
    }

    public void downgradeCheck() {
        File fileToDelete = new File(String.valueOf(ChromePath.directoryCheck()) + "\\chromedriver.exe");
        if (fileToDelete.exists()) {
            fileToDelete.delete();
        }
    }
}

